/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d;

import com.eteks.sweethome3d.HomeFrameController;
import com.eteks.sweethome3d.MacOSXConfiguration;
import com.eteks.sweethome3d.io.AutoRecoveryManager;
import com.eteks.sweethome3d.io.FileUserPreferences;
import com.eteks.sweethome3d.io.HomeFileRecorder;
import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.HomeRecorder;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.ObjectProperty;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.plugin.HomePluginController;
import com.eteks.sweethome3d.plugin.PluginManager;
import com.eteks.sweethome3d.swing.FileContentManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.swing.SwingViewFactory;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.ServiceManagerStub;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class SweetHome3D
extends HomeApplication {
    private static final String PREFERENCES_FOLDER = "com.eteks.sweethome3d.preferencesFolder";
    private static final String APPLICATION_FOLDERS = "com.eteks.sweethome3d.applicationFolders";
    private static final String APPLICATION_PLUGINS_SUB_FOLDER = "plugins";
    private HomeRecorder homeRecorder;
    private HomeRecorder compressedHomeRecorder;
    private UserPreferences userPreferences;
    private ContentManager contentManager;
    private ViewFactory viewFactory;
    private PluginManager pluginManager;
    private boolean pluginManagerInitialized;
    private boolean checkUpdatesNeeded;
    private AutoRecoveryManager autoRecoveryManager;
    private final Map<Home, HomeFrameController> homeFrameControllers = new HashMap<Home, HomeFrameController>();

    protected SweetHome3D() {
        this.checkUpdatesNeeded = Boolean.parseBoolean(System.getProperty("com.eteks.sweethome3d.checkUpdates", "true"));
    }

    @Override
    public HomeRecorder getHomeRecorder() {
        if (this.homeRecorder == null) {
            this.homeRecorder = new HomeFileRecorder(0, false, this.getUserPreferences(), false, true, true);
        }
        return this.homeRecorder;
    }

    @Override
    public HomeRecorder getHomeRecorder(HomeRecorder.Type type) {
        if (type == HomeRecorder.Type.COMPRESSED) {
            if (this.compressedHomeRecorder == null) {
                this.compressedHomeRecorder = new HomeFileRecorder(9, false, this.getUserPreferences(), false, true, true);
            }
            return this.compressedHomeRecorder;
        }
        return super.getHomeRecorder(type);
    }

    @Override
    public UserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            File[] fileArray;
            Object object;
            File file;
            String string = System.getProperty(PREFERENCES_FOLDER, null);
            String string2 = System.getProperty(APPLICATION_FOLDERS, null);
            File file2 = file = string != null ? new File(string) : null;
            if (string2 != null) {
                object = string2.split(File.pathSeparator);
                fileArray = new File[((String[])object).length];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i] = new File(object[i]);
                }
            } else {
                fileArray = null;
            }
            object = new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    EventQueue.invokeLater(runnable);
                }
            };
            this.userPreferences = new FileUserPreferences(file, fileArray, (Executor)object){

                @Override
                public List<Library> getLibraries() {
                    List<Library> list;
                    if (SweetHome3D.this.userPreferences != null && SweetHome3D.this.getPluginManager() != null && !(list = SweetHome3D.this.getPluginManager().getPluginLibraries()).isEmpty()) {
                        ArrayList<Library> arrayList = new ArrayList<Library>(super.getLibraries());
                        arrayList.addAll(list);
                        return Collections.unmodifiableList(arrayList);
                    }
                    return super.getLibraries();
                }

                @Override
                public void deleteLibraries(List<Library> list) throws RecorderException {
                    if (SweetHome3D.this.userPreferences != null && SweetHome3D.this.getPluginManager() != null) {
                        super.deleteLibraries(list);
                        ArrayList<Library> arrayList = new ArrayList<Library>();
                        for (Library library : list) {
                            if (!"Plugin".equals(library.getType())) continue;
                            arrayList.add(library);
                        }
                        SweetHome3D.this.getPluginManager().deletePlugins(arrayList);
                    }
                }
            };
        }
        return this.userPreferences;
    }

    protected ContentManager getContentManager() {
        if (this.contentManager == null) {
            this.contentManager = new FileContentManagerWithRecordedLastDirectories(this.getUserPreferences(), this.getClass());
        }
        return this.contentManager;
    }

    protected ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new SwingViewFactory();
        }
        return this.viewFactory;
    }

    protected PluginManager getPluginManager() {
        if (!this.pluginManagerInitialized) {
            try {
                UserPreferences userPreferences = this.getUserPreferences();
                if (userPreferences instanceof FileUserPreferences) {
                    File[] fileArray = ((FileUserPreferences)userPreferences).getApplicationSubfolders(APPLICATION_PLUGINS_SUB_FOLDER);
                    this.pluginManager = new PluginManager(fileArray);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.pluginManagerInitialized = true;
        }
        return this.pluginManager;
    }

    @Override
    public String getId() {
        String string = System.getProperty("com.eteks.sweethome3d.applicationId");
        if (string != null && string.length() > 0) {
            return string;
        }
        try {
            return this.getUserPreferences().getLocalizedString(SweetHome3D.class, "applicationId", new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return super.getId();
        }
    }

    @Override
    public String getName() {
        return this.getUserPreferences().getLocalizedString(SweetHome3D.class, "applicationName", new Object[0]);
    }

    @Override
    public String getVersion() {
        String string = System.getProperty("com.eteks.sweethome3d.applicationVersion");
        if (string != null) {
            return string;
        }
        return this.getUserPreferences().getLocalizedString(SweetHome3D.class, "applicationVersion", new Object[0]);
    }

    JFrame getHomeFrame(Home home) {
        return (JFrame)SwingUtilities.getRoot((JComponent)((Object)this.homeFrameControllers.get(home).getView()));
    }

    HomeFrameController getHomeFrameController(Home home) {
        return this.homeFrameControllers.get(home);
    }

    private void showHomeFrame(Home home) {
        JFrame jFrame = this.getHomeFrame(home);
        jFrame.setVisible(true);
        jFrame.setState(0);
        jFrame.toFront();
    }

    public static void main(String[] stringArray) {
        new SweetHome3D().init(stringArray);
    }

    protected void init(final String[] stringArray) {
        this.initSystemProperties();
        if (ServiceManager.getServiceNames() == null) {
            if (Boolean.parseBoolean(System.getProperty("com.eteks.sweethome3d.singleInstance", "true")) && StandaloneSingleInstanceService.callSingleInstanceServer(stringArray, this.getClass())) {
                System.exit(0);
            } else {
                SwingTools.showSplashScreenWindow(SweetHome3D.class.getResource("resources/splashScreen.jpg"));
                ServiceManager.setServiceManagerStub((ServiceManagerStub)new StandaloneServiceManager(this.getClass()));
            }
        }
        SingleInstanceService singleInstanceService = null;
        final SingleInstanceListener singleInstanceListener = new SingleInstanceListener(){

            public void newActivation(final String[] stringArray) {
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    @Override
                    public void run() {
                        this.this$1.SweetHome3D.this.start(stringArray);
                    }
                });
            }
        };
        try {
            singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            singleInstanceService.addSingleInstanceListener(singleInstanceListener);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            // empty catch block
        }
        final SingleInstanceService singleInstanceService2 = singleInstanceService;
        this.addHomesListener(new CollectionListener<Home>(){
            private boolean firstApplicationHomeAdded;
            final /* synthetic */ SweetHome3D this$0;
            {
                this.this$0 = sweetHome3D;
            }

            @Override
            public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                switch (collectionEvent.getType()) {
                    case ADD: {
                        Home home = collectionEvent.getItem();
                        home.setFurnitureAdditionalProperties(this.this$0.getFurnitureAdditionalProperties());
                        try {
                            HomeFrameController homeFrameController = this.this$0.createHomeFrameController(home);
                            homeFrameController.displayView();
                            if (!this.firstApplicationHomeAdded) {
                                this.firstApplicationHomeAdded = true;
                                this.this$0.addNewHomeCloseListener(home, homeFrameController.getHomeController());
                            }
                            this.this$0.homeFrameControllers.put(home, homeFrameController);
                            break;
                        }
                        catch (IllegalStateException illegalStateException) {
                            if ("javax.media.j3d.IllegalRenderingStateException".equals(illegalStateException.getClass().getName())) {
                                illegalStateException.printStackTrace();
                                this.this$0.exitAfter3DError();
                                break;
                            }
                            throw illegalStateException;
                        }
                    }
                    case DELETE: {
                        this.this$0.homeFrameControllers.remove(collectionEvent.getItem());
                        if (!this.this$0.getHomes().isEmpty() || OperatingSystem.isMacOSX() && Boolean.getBoolean("apple.laf.useScreenMenuBar")) break;
                        if (singleInstanceService2 != null) {
                            singleInstanceService2.removeSingleInstanceListener(singleInstanceListener);
                        }
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                System.exit(0);
                            }
                        });
                    }
                }
            }
        });
        this.addComponent3DRenderingErrorObserver();
        this.getUserPreferences();
        try {
            System.setProperty("http.agent", this.getId() + "/" + this.getVersion() + " (" + System.getProperty("os.name") + " " + System.getProperty("os.version") + "; " + System.getProperty("os.arch") + "; " + Locale.getDefault() + ")");
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        this.initLookAndFeel();
        try {
            this.autoRecoveryManager = new AutoRecoveryManager(this);
        }
        catch (RecorderException recorderException) {
            recorderException.printStackTrace();
        }
        if (OperatingSystem.isMacOSX()) {
            MacOSXConfiguration.bindToApplicationMenu(this);
        }
        EventQueue.invokeLater(new Runnable(){
            final /* synthetic */ SweetHome3D this$0;
            {
                this.this$0 = sweetHome3D;
            }

            @Override
            public void run() {
                this.this$0.start(stringArray);
            }
        });
    }

    protected HomeFrameController createHomeFrameController(Home home) {
        return new HomeFrameController(home, this, this.getViewFactory(), this.getContentManager(), this.getPluginManager());
    }

    private List<ObjectProperty> getFurnitureAdditionalProperties() {
        ArrayList<ObjectProperty> arrayList = new ArrayList<ObjectProperty>();
        for (String string : System.getProperty("com.eteks.sweethome3d.additionalFurnitureProperties", "").split(",\\s*")) {
            if (string.length() <= 0) continue;
            try {
                arrayList.add(ObjectProperty.fromDescription(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
        }
        return arrayList;
    }

    private void initSystemProperties() {
        if (OperatingSystem.isMacOSX()) {
            String string = SweetHome3D.class.getName();
            string = string.substring(0, string.lastIndexOf("."));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string + ".package");
            String string2 = resourceBundle.getString("SweetHome3D.applicationName");
            if (System.getProperty("com.apple.mrj.application.apple.menu.about.name") == null) {
                System.setProperty("com.apple.mrj.application.apple.menu.about.name", string2);
            }
            if (System.getProperty("apple.awt.application.name") == null) {
                System.setProperty("apple.awt.application.name", string2);
            }
            if (System.getProperty("apple.laf.useScreenMenuBar") == null) {
                System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(OperatingSystem.compareVersions(System.getProperty("os.version"), "10.13") < 0 || MacOSXConfiguration.isScreenMenuBarSupported()));
            }
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
            if (System.getProperty("com.eteks.sweethome3d.dragAndDropWithoutTransferHandler") == null && OperatingSystem.isJavaVersionBetween("1.7", "1.8.0_40")) {
                System.setProperty("com.eteks.sweethome3d.dragAndDropWithoutTransferHandler", "true");
            }
            System.setProperty("apple.awt.transparentTitleBar", "false");
        }
        if (System.getProperty("java.net.useSystemProxies") == null) {
            System.setProperty("java.net.useSystemProxies", "true");
        }
    }

    private void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(System.getProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName()));
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                UIManager.put("TitledBorder.border", UIManager.getBorder("TitledBorder.aquaVariant"));
            }
            if (OperatingSystem.isMacOSXYosemiteOrSuperior()) {
                UIManager.put("SplitPaneDivider.border", new Border(){

                    @Override
                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        graphics.setColor(UIManager.getColor("SplitPane.background"));
                        Shape shape = graphics.getClip();
                        Area area = new Area(new Rectangle2D.Float((float)n - 0.5f, (float)n2 - 0.5f, (float)n3 + 1.0f, (float)n4 + 1.0f));
                        area.subtract(new Area(new Ellipse2D.Float((float)n + (float)n3 / 2.0f - 3.4f, (float)n2 + (float)n4 / 2.0f - 3.2f, 6.8f, 6.8f)));
                        JSplitPane jSplitPane = ((BasicSplitPaneDivider)component).getBasicSplitPaneUI().getSplitPane();
                        if (jSplitPane.getOrientation() == 0) {
                            area.subtract(new Area(new Polygon(new int[]{n, n + 4, n + 8}, new int[]{n2 + n4 / 2 + 3, n2 + n4 / 2 - 3, n2 + n4 / 2 + 3}, 3)));
                            area.subtract(new Area(new Polygon(new int[]{n + 12, n + 15, n + 19}, new int[]{n2 + n4 / 2 - 2, n2 + n4 / 2 + 3, n2 + n4 / 2 - 2}, 3)));
                        }
                        graphics.setClip(area);
                        graphics.fillRect(n, n2 + n4 / 2 - 5, n + n3, 11);
                        graphics.setClip(shape);
                    }

                    @Override
                    public boolean isBorderOpaque() {
                        return true;
                    }

                    @Override
                    public Insets getBorderInsets(Component component) {
                        return new Insets(0, 0, 0, 0);
                    }
                });
            }
            SwingTools.updateSwingResourceLanguage(this.getUserPreferences());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addNewHomeCloseListener(final Home home, final HomeController homeController) {
        if (home.getName() == null) {
            final CollectionListener<Home> collectionListener = new CollectionListener<Home>(){
                final /* synthetic */ SweetHome3D this$0;
                {
                    this.this$0 = sweetHome3D;
                }

                @Override
                public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                    if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                        if (collectionEvent.getItem().getName() != null && home.getName() == null && !home.isRecovered()) {
                            if (OperatingSystem.isMacOSXLionOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7") && MacOSXConfiguration.isWindowFullScreen(this.this$0.getHomeFrame(home))) {
                                new Timer(3000, new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent actionEvent) {
                                        ((Timer)actionEvent.getSource()).stop();
                                        homeController.close();
                                    }
                                }).start();
                            } else {
                                homeController.close();
                            }
                        }
                        this.this$0.removeHomesListener(this);
                    } else if (collectionEvent.getItem() == home && collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        this.this$0.removeHomesListener(this);
                    }
                }
            };
            this.addHomesListener(collectionListener);
            home.addPropertyChangeListener(Home.Property.MODIFIED, new PropertyChangeListener(){
                final /* synthetic */ SweetHome3D this$0;
                {
                    this.this$0 = sweetHome3D;
                }

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.this$0.removeHomesListener(collectionListener);
                    home.removePropertyChangeListener(Home.Property.MODIFIED, (PropertyChangeListener)this);
                }
            });
        }
    }

    private void addComponent3DRenderingErrorObserver() {
        if (!Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
            Component3DManager.getInstance().setRenderingErrorObserver(new Component3DManager.RenderingErrorObserver(){

                @Override
                public void errorOccured(int n, String string) {
                    System.err.print("Error in Java 3D : " + n + " " + string);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SweetHome3D.this.exitAfter3DError();
                        }
                    });
                }
            });
        }
    }

    private void exitAfter3DError() {
        boolean bl = false;
        for (Home home : this.getHomes()) {
            if (!home.isModified()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.show3DError();
        } else if (this.confirmSaveAfter3DError()) {
            for (Home home : this.getHomes()) {
                if (!home.isModified()) continue;
                String string = home.getName();
                if (string == null) {
                    JFrame jFrame = this.getHomeFrame(home);
                    jFrame.toFront();
                    string = this.contentManager.showSaveDialog((View)((Object)jFrame.getRootPane()), null, ContentManager.ContentType.SWEET_HOME_3D, null);
                }
                if (string != null) {
                    try {
                        this.getHomeRecorder().writeHome(home, string);
                    }
                    catch (RecorderException recorderException) {
                        recorderException.printStackTrace();
                    }
                }
                this.deleteHome(home);
            }
        }
        for (Home home : this.getHomes()) {
            this.deleteHome(home);
        }
        System.exit(0);
    }

    private void show3DError() {
        UserPreferences userPreferences = this.getUserPreferences();
        String string = userPreferences.getLocalizedString(SweetHome3D.class, "3DError.message", new Object[0]);
        String string2 = userPreferences.getLocalizedString(SweetHome3D.class, "3DError.title", new Object[0]);
        JOptionPane.showMessageDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), string, string2, 0);
    }

    private boolean confirmSaveAfter3DError() {
        UserPreferences userPreferences = this.getUserPreferences();
        String string = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.message", new Object[0]);
        String string2 = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.title", new Object[0]);
        String string3 = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.save", new Object[0]);
        String string4 = userPreferences.getLocalizedString(SweetHome3D.class, "confirmSaveAfter3DError.doNotSave", new Object[0]);
        return JOptionPane.showOptionDialog(KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(), string, string2, 0, 3, null, new Object[]{string3, string4}, string3) == 0;
    }

    protected void start(String[] stringArray) {
        if (stringArray.length == 1 && !stringArray[0].equals("-open")) {
            stringArray = new String[]{"-open", stringArray[0]};
        }
        if (stringArray.length == 2 && stringArray[0].equals("-open") && stringArray[1].length() > 0) {
            Object object;
            for (Home home : this.getHomes()) {
                if (!stringArray[1].equals(home.getName())) continue;
                this.showHomeFrame(home);
                return;
            }
            if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.SWEET_HOME_3D)) {
                this.addHomesListener(new CollectionListener<Home>(){

                    @Override
                    public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                        if (collectionEvent.getType() == CollectionEvent.Type.ADD) {
                            SweetHome3D.this.removeHomesListener(this);
                            if (SweetHome3D.this.autoRecoveryManager != null) {
                                SweetHome3D.this.autoRecoveryManager.openRecoveredHomes();
                            }
                        }
                    }
                });
                this.createHomeFrameController(this.createHome()).getHomeController().open(stringArray[1]);
                this.checkUpdates();
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.LANGUAGE_LIBRARY)) {
                this.showDefaultHomeFrame();
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ String val$languageLibraryName;
                    final /* synthetic */ SweetHome3D this$0;
                    {
                        this.val$languageLibraryName = string;
                        this.this$0 = sweetHome3D;
                    }

                    @Override
                    public void run() {
                        List<String> list = Arrays.asList(this.this$0.getUserPreferences().getSupportedLanguages());
                        this.this$0.createHomeFrameController(this.this$0.createHome()).getHomeController().importLanguageLibrary(this.val$languageLibraryName);
                        for (String string : this.this$0.getUserPreferences().getSupportedLanguages()) {
                            if (list.contains(string)) continue;
                            this.this$0.getUserPreferences().setLanguage(string);
                            break;
                        }
                        this.this$0.checkUpdates();
                    }
                });
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.FURNITURE_LIBRARY)) {
                this.showDefaultHomeFrame();
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ String val$furnitureLibraryName;
                    final /* synthetic */ SweetHome3D this$0;
                    {
                        this.val$furnitureLibraryName = string;
                        this.this$0 = sweetHome3D;
                    }

                    @Override
                    public void run() {
                        this.this$0.createHomeFrameController(this.this$0.createHome()).getHomeController().importFurnitureLibrary(this.val$furnitureLibraryName);
                        this.this$0.checkUpdates();
                    }
                });
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.TEXTURES_LIBRARY)) {
                this.showDefaultHomeFrame();
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ String val$texturesLibraryName;
                    final /* synthetic */ SweetHome3D this$0;
                    {
                        this.val$texturesLibraryName = string;
                        this.this$0 = sweetHome3D;
                    }

                    @Override
                    public void run() {
                        this.this$0.createHomeFrameController(this.this$0.createHome()).getHomeController().importTexturesLibrary(this.val$texturesLibraryName);
                        this.this$0.checkUpdates();
                    }
                });
            } else if (this.getContentManager().isAcceptable(stringArray[1], ContentManager.ContentType.PLUGIN)) {
                this.showDefaultHomeFrame();
                object = stringArray[1];
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ String val$pluginName;
                    final /* synthetic */ SweetHome3D this$0;
                    {
                        this.val$pluginName = string;
                        this.this$0 = sweetHome3D;
                    }

                    @Override
                    public void run() {
                        HomeController homeController = this.this$0.createHomeFrameController(this.this$0.createHome()).getHomeController();
                        if (homeController instanceof HomePluginController) {
                            ((HomePluginController)homeController).importPlugin(this.val$pluginName);
                        }
                        this.this$0.checkUpdates();
                    }
                });
            }
        } else {
            this.showDefaultHomeFrame();
            this.checkUpdates();
        }
    }

    private void showDefaultHomeFrame() {
        if (this.getHomes().isEmpty()) {
            if (this.autoRecoveryManager != null) {
                this.autoRecoveryManager.openRecoveredHomes();
            }
            if (this.getHomes().isEmpty()) {
                this.addHome(this.createHome());
            }
        } else {
            JFrame jFrame;
            int n;
            List<Home> list = this.getHomes();
            Home home = null;
            for (n = list.size() - 1; n >= 0; --n) {
                jFrame = this.getHomeFrame(list.get(n));
                if (!jFrame.isActive() && jFrame.getState() == 1) continue;
                home = list.get(n);
                break;
            }
            if (home == null) {
                for (n = list.size() - 1; n >= 0; --n) {
                    jFrame = this.getHomeFrame(list.get(n));
                    if (!jFrame.isDisplayable()) continue;
                    home = list.get(n);
                    break;
                }
            }
            this.showHomeFrame(home);
        }
    }

    private void checkUpdates() {
        if (this.checkUpdatesNeeded) {
            this.checkUpdatesNeeded = false;
            if (this.getUserPreferences().isCheckUpdatesEnabled()) {
                new Timer(500, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((Timer)actionEvent.getSource()).stop();
                        SweetHome3D.this.createHomeFrameController(SweetHome3D.this.createHome()).getHomeController().checkUpdates(true);
                    }
                }).start();
            }
        }
    }

    private static class FileContentManagerWithRecordedLastDirectories
    extends FileContentManager {
        private static final String LAST_DIRECTORY = "lastDirectory#";
        private static final String LAST_DEFAULT_DIRECTORY = "lastDefaultDirectory";
        private final Class<? extends SweetHome3D> mainClass;

        public FileContentManagerWithRecordedLastDirectories(UserPreferences userPreferences, Class<? extends SweetHome3D> clazz) {
            super(userPreferences);
            this.mainClass = clazz;
        }

        @Override
        protected File getLastDirectory(ContentManager.ContentType contentType) {
            File file;
            Preferences preferences = Preferences.userNodeForPackage(this.mainClass);
            String string = null;
            if (contentType != null) {
                string = preferences.get(LAST_DIRECTORY + (Object)((Object)contentType), null);
            }
            if (string == null) {
                string = preferences.get(LAST_DEFAULT_DIRECTORY, null);
            }
            if (string != null && (file = new File(string)).isDirectory()) {
                return file;
            }
            return null;
        }

        @Override
        protected void setLastDirectory(ContentManager.ContentType contentType, File file) {
            Preferences preferences = Preferences.userNodeForPackage(this.mainClass);
            if (file == null) {
                preferences.remove(LAST_DIRECTORY + (Object)((Object)contentType));
            } else {
                String string = file.getAbsolutePath();
                if (contentType != null) {
                    preferences.put(LAST_DIRECTORY + (Object)((Object)contentType), string);
                }
                if (string != null) {
                    preferences.put(LAST_DEFAULT_DIRECTORY, string);
                }
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    private static class StandaloneSingleInstanceService
    implements SingleInstanceService {
        private static final String SINGLE_INSTANCE_PORT = "singleInstancePort";
        private final Class<? extends SweetHome3D> mainClass;
        private final List<SingleInstanceListener> singleInstanceListeners = new ArrayList<SingleInstanceListener>();

        public StandaloneSingleInstanceService(Class<? extends SweetHome3D> clazz) {
            this.mainClass = clazz;
        }

        public void addSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
            if (this.singleInstanceListeners.isEmpty() && !OperatingSystem.isMacOSX()) {
                this.launchSingleInstanceServer();
            }
            this.singleInstanceListeners.add(singleInstanceListener);
        }

        private void launchSingleInstanceServer() {
            ServerSocket serverSocket;
            try {
                serverSocket = new ServerSocket(0, 0, InetAddress.getByName("127.0.0.1"));
                Preferences preferences = Preferences.userNodeForPackage(this.mainClass);
                preferences.putInt(SINGLE_INSTANCE_PORT, serverSocket.getLocalPort());
                preferences.flush();
            }
            catch (IOException iOException) {
                return;
            }
            catch (BackingStoreException backingStoreException) {
                return;
            }
            Executors.newSingleThreadExecutor().execute(new Runnable(){
                final /* synthetic */ StandaloneSingleInstanceService this$0;
                {
                    this.this$0 = standaloneSingleInstanceService;
                }

                @Override
                public void run() {
                    try {
                        block2: while (true) {
                            SingleInstanceListener[] singleInstanceListenerArray;
                            Socket socket = serverSocket.accept();
                            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF-8"));
                            String[] stringArray = bufferedReader.readLine().split("\t");
                            bufferedReader.close();
                            socket.close();
                            SingleInstanceListener[] singleInstanceListenerArray2 = singleInstanceListenerArray = this.this$0.singleInstanceListeners.toArray(new SingleInstanceListener[this.this$0.singleInstanceListeners.size()]);
                            int n = singleInstanceListenerArray2.length;
                            int n2 = 0;
                            while (true) {
                                if (n2 >= n) continue block2;
                                SingleInstanceListener singleInstanceListener = singleInstanceListenerArray2[n2];
                                singleInstanceListener.newActivation(stringArray);
                                ++n2;
                            }
                            break;
                        }
                    }
                    catch (IOException iOException) {
                        this.this$0.launchSingleInstanceServer();
                        return;
                    }
                }
            });
        }

        public void removeSingleInstanceListener(SingleInstanceListener singleInstanceListener) {
            this.singleInstanceListeners.remove(singleInstanceListener);
            if (this.singleInstanceListeners.isEmpty()) {
                Preferences preferences = Preferences.userNodeForPackage(this.mainClass);
                preferences.remove(SINGLE_INSTANCE_PORT);
                try {
                    preferences.flush();
                }
                catch (BackingStoreException backingStoreException) {
                    throw new RuntimeException(backingStoreException);
                }
            }
        }

        public static boolean callSingleInstanceServer(String[] stringArray, Class<? extends SweetHome3D> clazz) {
            Preferences preferences;
            int n;
            if (!OperatingSystem.isMacOSX() && (n = (preferences = Preferences.userNodeForPackage(clazz)).getInt(SINGLE_INSTANCE_PORT, -1)) != -1) {
                try {
                    Socket socket = new Socket("127.0.0.1", n);
                    BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "UTF-8"));
                    for (String string : stringArray) {
                        bufferedWriter.write(string);
                        bufferedWriter.write("\t");
                    }
                    bufferedWriter.write("\n");
                    bufferedWriter.close();
                    socket.close();
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static class StandaloneServiceManager
    implements ServiceManagerStub {
        private final Class<? extends SweetHome3D> mainClass;

        public StandaloneServiceManager(Class<? extends SweetHome3D> clazz) {
            this.mainClass = clazz;
        }

        public Object lookup(String string) throws UnavailableServiceException {
            if (string.equals("javax.jnlp.BasicService")) {
                return new StandaloneBasicService();
            }
            if (string.equals("javax.jnlp.SingleInstanceService") && Boolean.parseBoolean(System.getProperty("com.eteks.sweethome3d.singleInstance", "true"))) {
                return new StandaloneSingleInstanceService(this.mainClass);
            }
            throw new UnavailableServiceException(string);
        }

        public String[] getServiceNames() {
            return new String[]{"javax.jnlp.BasicService", "javax.jnlp.SingleInstanceService"};
        }
    }

    private static class StandaloneBasicService
    implements BasicService {
        private StandaloneBasicService() {
        }

        public boolean showDocument(URL uRL) {
            try {
                if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    clazz.getMethod("browse", URI.class).invoke(object, uRL.toURI());
                    return true;
                }
            }
            catch (Exception exception) {
                try {
                    if (OperatingSystem.isMacOSX()) {
                        Runtime.getRuntime().exec(new String[]{"open", uRL.toString()});
                        return true;
                    }
                    if (OperatingSystem.isLinux()) {
                        Runtime.getRuntime().exec(new String[]{"xdg-open", uRL.toString()});
                        return true;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return false;
        }

        public URL getCodeBase() {
            return StandaloneServiceManager.class.getResource("resources");
        }

        public boolean isOffline() {
            return false;
        }

        public boolean isWebBrowserSupported() {
            if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6")) {
                try {
                    Class<?> clazz = Class.forName("java.awt.Desktop");
                    Object object = clazz.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    Class<?> clazz2 = Class.forName("java.awt.Desktop$Action");
                    Object object2 = clazz2.getMethod("valueOf", String.class).invoke(null, "BROWSE");
                    if (((Boolean)clazz.getMethod("isSupported", clazz2).invoke(object, object2)).booleanValue()) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return OperatingSystem.isMacOSX() || OperatingSystem.isLinux();
        }
    }
}

