/*
 * Decompiled with CFR 0.152.
 */
package hughai.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlHelper {
    public static Document CreateDom() {
        Document document = XmlHelper.getDocumentBuilder().newDocument();
        Element element = document.createElement("root");
        document.appendChild(element);
        return document;
    }

    static DocumentBuilder getDocumentBuilder() {
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return documentBuilder;
    }

    public static Document OpenDom(String string) {
        Document document = null;
        try {
            document = XmlHelper.getDocumentBuilder().parse(new File(string));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return document;
    }

    public static void SaveDom(Document document, String string) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(new FileOutputStream(string));
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "utf-8");
            transformer.transform(dOMSource, streamResult);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static Element AddChild(Element element, String string) {
        Element element2 = element.getOwnerDocument().createElement(string);
        element.appendChild(element2);
        return element2;
    }

    public static List<Element> SelectElements(Element element, String string) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        XPath xPath = XmlHelper.getXPath();
        try {
            XPathExpression xPathExpression = xPath.compile(string);
            NodeList nodeList = (NodeList)xPathExpression.evaluate(element, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add((Element)nodeList.item(i));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return arrayList;
    }

    public static Element SelectSingleElement(Element element, String string) {
        Element element2 = null;
        XPath xPath = XmlHelper.getXPath();
        try {
            XPathExpression xPathExpression = xPath.compile(string);
            element2 = (Element)xPathExpression.evaluate(element, XPathConstants.NODE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        return element2;
    }

    public static XPath getXPath() {
        return XmlHelper.getXPathFactory().newXPath();
    }

    public static XPathFactory getXPathFactory() {
        return XPathFactory.newInstance();
    }
}

