/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.Static;
import org.apache.sis.util.resources.Errors;

public final class Characters
extends Static {
    public static final char HYPHEN = '\u2010';
    public static final char SOFT_HYPHEN = '\u00ad';
    public static final char NO_BREAK_SPACE = '\u00a0';
    public static final char LINE_SEPARATOR = '\u2028';
    public static final char PARAGRAPH_SEPARATOR = '\u2029';

    private Characters() {
    }

    public static boolean isValidWKT(int n) {
        switch (n) {
            case 33: 
            case 35: 
            case 36: 
            case 64: 
            case 96: {
                return false;
            }
            case 176: {
                return true;
            }
        }
        return n >= 32 && n <= 125;
    }

    public static boolean isLineOrParagraphSeparator(int n) {
        switch (Character.getType(n)) {
            default: {
                return false;
            }
            case 13: 
            case 14: {
                return true;
            }
            case 15: 
        }
        return n == 13 || n == 10;
    }

    public static boolean isHexadecimal(int n) {
        return n >= 48 && n <= 57 || (n &= 0xFFFFFFDF) >= 65 && n <= 70;
    }

    public static boolean isSuperScript(int n) {
        switch (n) {
            case 178: 
            case 179: 
            case 185: {
                return true;
            }
            case 8305: 
            case 8306: 
            case 8307: {
                return false;
            }
        }
        return n >= 8304 && n <= 8319;
    }

    public static boolean isSubScript(int n) {
        return n >= 8320 && n <= 8334;
    }

    public static char toSuperScript(char c) {
        switch (c) {
            case '1': {
                c = (char)185;
                break;
            }
            case '2': {
                c = (char)178;
                break;
            }
            case '3': {
                c = (char)179;
                break;
            }
            case '+': {
                c = (char)8314;
                break;
            }
            case '-': {
                c = (char)8315;
                break;
            }
            case '=': {
                c = (char)8316;
                break;
            }
            case '(': {
                c = (char)8317;
                break;
            }
            case ')': {
                c = (char)8318;
                break;
            }
            case 'n': {
                c = (char)8319;
                break;
            }
            default: {
                if (c < '0' || c > '9') break;
                c = (char)(c + 8256);
            }
        }
        return c;
    }

    public static char toSubScript(char c) {
        switch (c) {
            case '+': {
                c = (char)8330;
                break;
            }
            case '-': {
                c = (char)8331;
                break;
            }
            case '=': {
                c = (char)8332;
                break;
            }
            case '(': {
                c = (char)8333;
                break;
            }
            case ')': {
                c = (char)8334;
                break;
            }
            default: {
                if (c < '0' || c > '9') break;
                c = (char)(c + 8272);
            }
        }
        return c;
    }

    public static char toNormalScript(char c) {
        return (char)Characters.toNormalScript((int)c);
    }

    public static int toNormalScript(int n) {
        switch (n) {
            case 8305: 
            case 8306: 
            case 8307: {
                break;
            }
            case 185: {
                n = 49;
                break;
            }
            case 178: {
                n = 50;
                break;
            }
            case 179: {
                n = 51;
                break;
            }
            case 8314: 
            case 8330: {
                n = 43;
                break;
            }
            case 8315: 
            case 8331: {
                n = 45;
                break;
            }
            case 8316: 
            case 8332: {
                n = 61;
                break;
            }
            case 8317: 
            case 8333: {
                n = 40;
                break;
            }
            case 8318: 
            case 8334: {
                n = 41;
                break;
            }
            case 8319: {
                n = 110;
                break;
            }
            default: {
                if (n < 8304 || n > 8329) break;
                if (n <= 8313) {
                    n -= 8256;
                    break;
                }
                if (n < 8320) break;
                n -= 8272;
            }
        }
        return n;
    }

    private static final class UnicodeIdentifier
    extends Filter {
        UnicodeIdentifier() {
            super("UNICODE_IDENTIFIER", 8390526L);
        }

        @Override
        public boolean contains(int n) {
            return Character.isUnicodeIdentifierPart(n) && !Character.isIdentifierIgnorable(n);
        }
    }

    private static final class LettersAndDigits
    extends Filter {
        LettersAndDigits() {
            super("LETTERS_AND_DIGITS", 574L);
        }

        @Override
        public boolean contains(int n) {
            return Character.isLetterOrDigit(n);
        }
    }

    public static class Filter
    extends Character.Subset {
        public static final Filter LETTERS_AND_DIGITS = new LettersAndDigits();
        public static final Filter UNICODE_IDENTIFIER = new UnicodeIdentifier();
        private final long types;

        Filter(String string, long l) {
            super(string);
            this.types = l;
        }

        public boolean contains(int n) {
            return (this.types & Numerics.bitmask(Character.getType(n))) != 0L;
        }

        public static Filter forTypes(byte ... byArray) {
            int n;
            long l = 0L;
            for (n = 0; n < byArray.length; ++n) {
                byte by = byArray[n];
                if (by < 0 || by >= 64) {
                    throw new IllegalArgumentException(Errors.format((short)45, Strings.toIndexed("types", n), by));
                }
                l |= 1L << by;
            }
            n = 0;
            block5: while (true) {
                Filter filter;
                switch (n) {
                    case 0: {
                        filter = LETTERS_AND_DIGITS;
                        break;
                    }
                    case 1: {
                        filter = UNICODE_IDENTIFIER;
                        break;
                    }
                    default: {
                        break block5;
                    }
                }
                if (l == filter.types) {
                    return filter;
                }
                ++n;
            }
            return new Filter("Filter", l);
        }
    }
}

