/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mov.atoms;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.mov.atoms.Atom;
import com.drew.metadata.mov.atoms.SampleDescription;
import com.drew.metadata.mov.atoms.SampleDescriptionAtom;
import com.drew.metadata.mov.media.QuickTimeTextDirectory;
import java.io.IOException;

public class TextSampleDescriptionAtom
extends SampleDescriptionAtom<TextSampleDescription> {
    public TextSampleDescriptionAtom(SequentialReader reader, Atom atom) throws IOException {
        super(reader, atom);
    }

    @Override
    @NotNull
    TextSampleDescription getSampleDescription(SequentialReader reader) throws IOException {
        return new TextSampleDescription(reader);
    }

    public void addMetadata(QuickTimeTextDirectory directory) {
        if (this.sampleDescriptions.size() == 0) {
            return;
        }
        TextSampleDescription description = (TextSampleDescription)this.sampleDescriptions.get(0);
        directory.setBoolean(1, (description.displayFlags & 2) == 2);
        directory.setBoolean(2, (description.displayFlags & 8) == 8);
        directory.setBoolean(3, (description.displayFlags & 0x20) == 32);
        directory.setBoolean(4, (description.displayFlags & 0x40) == 64);
        directory.setString(5, (description.displayFlags & 0x80) == 128 ? "Horizontal" : "Vertical");
        directory.setString(6, (description.displayFlags & 0x100) == 256 ? "Reverse" : "Normal");
        directory.setBoolean(7, (description.displayFlags & 0x200) == 512);
        directory.setBoolean(8, (description.displayFlags & 0x1000) == 4096);
        directory.setBoolean(9, (description.displayFlags & 0x2000) == 8192);
        directory.setBoolean(10, (description.displayFlags & 0x4000) == 16384);
        switch (description.textJustification) {
            case 0: {
                directory.setString(11, "Left");
                break;
            }
            case 1: {
                directory.setString(11, "Center");
                break;
            }
            case -1: {
                directory.setString(11, "Right");
            }
        }
        directory.setIntArray(12, description.backgroundColor);
        directory.setLong(13, description.defaultTextBox);
        directory.setInt(14, description.fontNumber);
        switch (description.fontFace) {
            case 1: {
                directory.setString(15, "Bold");
                break;
            }
            case 2: {
                directory.setString(15, "Italic");
                break;
            }
            case 4: {
                directory.setString(15, "Underline");
                break;
            }
            case 8: {
                directory.setString(15, "Outline");
                break;
            }
            case 16: {
                directory.setString(15, "Shadow");
                break;
            }
            case 32: {
                directory.setString(15, "Condense");
                break;
            }
            case 64: {
                directory.setString(15, "Extend");
            }
        }
        directory.setIntArray(16, description.foregroundColor);
        directory.setString(17, description.textName);
    }

    static class TextSampleDescription
    extends SampleDescription {
        int displayFlags;
        int textJustification;
        int[] backgroundColor;
        long defaultTextBox;
        int fontNumber;
        int fontFace;
        int[] foregroundColor;
        String textName;

        public TextSampleDescription(SequentialReader reader) throws IOException {
            super(reader);
            this.displayFlags = reader.getInt32();
            this.textJustification = reader.getInt32();
            this.backgroundColor = new int[]{reader.getUInt16(), reader.getUInt16(), reader.getUInt16()};
            this.defaultTextBox = reader.getInt64();
            reader.skip(8L);
            this.fontNumber = reader.getUInt16();
            this.fontFace = reader.getUInt16();
            reader.skip(1L);
            reader.skip(2L);
            this.foregroundColor = new int[]{reader.getUInt16(), reader.getUInt16(), reader.getUInt16()};
            this.textName = reader.getString(reader.getUInt8());
        }
    }
}

