/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.FieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.PushBackStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class JoinStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    private List<PushBackStream> streams;
    protected StreamEqualitor eq;

    public JoinStream(StreamEqualitor eq, TupleStream first, TupleStream second, TupleStream ... others) {
        this.streams = new ArrayList<PushBackStream>();
        this.eq = eq;
        this.streams.add(new PushBackStream(first));
        this.streams.add(new PushBackStream(second));
        for (TupleStream other : others) {
            this.streams.add(new PushBackStream(other));
        }
    }

    protected abstract void validateTupleOrder() throws IOException;

    public JoinStream(StreamExpression expression, StreamFactory factory) throws IOException {
        List<StreamExpression> streamExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, TupleStream.class);
        StreamExpressionNamedParameter onExpression = factory.getNamedOperand(expression, "on");
        if (expression.getParameters().size() != streamExpressions.size() + 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - unknown operands found", expression));
        }
        if (streamExpressions.size() < 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least two streams but found %d (must be PushBackStream types)", expression, streamExpressions.size()));
        }
        this.streams = new ArrayList<PushBackStream>();
        for (StreamExpression streamExpression : streamExpressions) {
            this.streams.add(new PushBackStream(factory.constructStream(streamExpression)));
        }
        if (null == onExpression || !(onExpression.getParameter() instanceof StreamExpressionValue)) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting single 'on' parameter listing fields to join on but didn't find one", expression));
        }
        this.eq = factory.constructEqualitor(((StreamExpressionValue)onExpression.getParameter()).getValue(), FieldEqualitor.class);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (PushBackStream stream : this.streams) {
            if (includeStreams) {
                expression.addParameter(stream.toExpression(factory));
                continue;
            }
            expression.addParameter("<stream>");
        }
        if (this.eq == null) {
            throw new IOException("This JoinStream contains a non-expressible equalitor - it cannot be converted to an expression");
        }
        expression.addParameter(new StreamExpressionNamedParameter("on", this.eq.toExpression(factory)));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-decorator");
        explanation.setExpression(this.toExpression(factory, false).toString());
        explanation.addHelper(this.eq.toExplanation(factory));
        for (TupleStream tupleStream : this.streams) {
            explanation.addChild(tupleStream.toExplanation(factory));
        }
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        for (PushBackStream stream : this.streams) {
            stream.setStreamContext(context);
        }
    }

    @Override
    public void open() throws IOException {
        for (PushBackStream stream : this.streams) {
            stream.open();
        }
    }

    @Override
    public void close() throws IOException {
        for (PushBackStream stream : this.streams) {
            stream.close();
        }
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> list = new ArrayList<TupleStream>();
        for (TupleStream tupleStream : this.streams) {
            list.add(tupleStream);
        }
        return list;
    }

    public PushBackStream getStream(int idx) {
        if (this.streams.size() > idx) {
            return this.streams.get(idx);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Stream idx=%d doesn't exist. Number of streams is %d", idx, this.streams.size()));
    }

    protected boolean isValidTupleOrder() {
        for (TupleStream tupleStream : this.streams) {
            if (this.eq.isDerivedFrom(tupleStream.getStreamSort())) continue;
            return false;
        }
        return true;
    }

    protected Tuple loadEqualTupleGroup(PushBackStream stream, LinkedList<Tuple> group, StreamComparator groupComparator) throws IOException {
        Tuple firstMember;
        block1: {
            Tuple nMember;
            firstMember = stream.read();
            if (firstMember.EOF) break block1;
            group.add(firstMember);
            while (true) {
                nMember = stream.read();
                if (nMember.EOF || 0 != groupComparator.compare(firstMember, nMember)) break;
                group.add(nMember);
            }
            stream.pushBack(nMember);
        }
        return firstMember;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

