/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.TupleStreamParser;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.noggit.JSONParser;
import org.noggit.ObjectBuilder;

public class JSONTupleStream
implements TupleStreamParser {
    private List<String> path;
    private Reader reader;
    private JSONParser parser;
    private boolean atDocs;

    public JSONTupleStream(Reader reader) {
        this.reader = reader;
        this.parser = new JSONParser(reader);
    }

    public static JSONTupleStream create(SolrClient server, SolrParams requestParams) throws IOException, SolrServerException {
        String p = requestParams.get("qt");
        if (p != null) {
            ModifiableSolrParams modifiableSolrParams = (ModifiableSolrParams)requestParams;
            modifiableSolrParams.remove("qt");
        }
        QueryRequest query = new QueryRequest(requestParams);
        query.setPath(p);
        query.setResponseParser((ResponseParser)new InputStreamResponseParser("json"));
        query.setMethod(SolrRequest.METHOD.POST);
        NamedList genericResponse = server.request((SolrRequest)query);
        InputStream stream = (InputStream)genericResponse.get(InputStreamResponseParser.STREAM_KEY);
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        return new JSONTupleStream(reader);
    }

    @Override
    public Map<String, Object> next() throws IOException {
        int event;
        if (!this.atDocs) {
            boolean found = this.advanceToDocs();
            this.atDocs = true;
            if (!found) {
                return null;
            }
        }
        if ((event = this.parser.nextEvent()) == 10) {
            return null;
        }
        Object o = ObjectBuilder.getVal((JSONParser)this.parser);
        return (Map)o;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    private void expect(int parserEventType) throws IOException {
        int event = this.parser.nextEvent();
        if (event != parserEventType) {
            throw new IOException("JSONTupleStream: expected " + JSONParser.getEventString((int)parserEventType) + " but got " + JSONParser.getEventString((int)event));
        }
    }

    private void expect(String mapKey) {
    }

    private boolean advanceToMapKey(String key, boolean deepSearch) throws IOException {
        block6: while (true) {
            int event = this.parser.nextEvent();
            switch (event) {
                case 1: {
                    if (key == null) break;
                    String val = this.parser.getString();
                    if (key.equals(val)) {
                        return true;
                    }
                    if (!"error".equals(val)) continue block6;
                    this.handleError();
                    break;
                }
                case 8: {
                    return false;
                }
                case 7: {
                    if (deepSearch) {
                        boolean found = this.advanceToMapKey(key, true);
                        if (!found) continue block6;
                        return true;
                    }
                    this.advanceToMapKey(null, false);
                    break;
                }
                case 9: {
                    this.skipArray(key, deepSearch);
                }
            }
        }
    }

    private void handleError() throws IOException {
        while (true) {
            int event;
            if ((event = this.parser.nextEvent()) == 1) {
                String msg;
                String val = this.parser.getString();
                if (!"msg".equals(val) || (event = this.parser.nextEvent()) != 1 || (msg = this.parser.getString()) == null) continue;
                throw new SolrStream.HandledException(msg);
            }
            if (event == 8) break;
        }
        throw new IOException("");
    }

    private void skipArray(String key, boolean deepSearch) throws IOException {
        while (true) {
            int event = this.parser.nextEvent();
            switch (event) {
                case 7: {
                    this.advanceToMapKey(key, deepSearch);
                    break;
                }
                case 9: {
                    this.skipArray(key, deepSearch);
                    break;
                }
                case 10: {
                    return;
                }
            }
        }
    }

    private boolean advanceToDocs() throws IOException {
        this.expect(7);
        boolean found = this.advanceToMapKey("docs", true);
        this.expect(9);
        return found;
    }
}

