/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security.cert;

import java.lang.invoke.MethodHandles;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertResolverPattern {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String name;
    private final String path;
    private final CheckType checkType;
    private final Set<String> filterValues;

    public CertResolverPattern(String name, String path, String checkType, Set<String> filterValues) {
        this.name = name;
        this.path = path;
        this.checkType = CheckType.fromString(checkType);
        this.filterValues = filterValues;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public CheckType getCheckType() {
        return this.checkType;
    }

    public Set<String> getFilterValues() {
        return this.filterValues;
    }

    public static boolean matchesPattern(String value, CertResolverPattern pattern) {
        return CertResolverPattern.matchesPattern(value, pattern.getCheckType(), pattern.getFilterValues());
    }

    public static boolean matchesPattern(String value, CheckType checkType, Set<String> values) {
        log.debug("matchesPattern   value:{}   checkType:{}    values:{}", new Object[]{value, checkType, values});
        String lowerValue = value.toLowerCase(Locale.ROOT);
        switch (checkType) {
            case EQUALS: {
                return values.contains(lowerValue);
            }
            case STARTS_WITH: {
                return values.stream().anyMatch(lowerValue::startsWith);
            }
            case ENDS_WITH: {
                return values.stream().anyMatch(lowerValue::endsWith);
            }
            case CONTAINS: {
                return values.stream().anyMatch(lowerValue::contains);
            }
            case WILDCARD: {
                return true;
            }
        }
        return false;
    }

    public static enum CheckType {
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        EQUALS,
        WILDCARD;

        private static final Map<String, CheckType> lookup;

        public static CheckType fromString(String checkType) {
            if (checkType == null) {
                throw new IllegalArgumentException("CheckType cannot be null");
            }
            CheckType result = lookup.get(checkType.toLowerCase(Locale.ROOT));
            if (result == null) {
                throw new IllegalArgumentException("No CheckType with text '" + checkType + "' found");
            }
            return result;
        }

        static {
            lookup = Map.of("equals", EQUALS, "startswith", STARTS_WITH, "endswith", ENDS_WITH, "contains", CONTAINS, "*", WILDCARD, "wildcard", WILDCARD);
        }
    }
}

