/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement.impl;

import java.util.Map;
import java.util.Optional;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.placement.AttributeValues;
import org.apache.solr.cluster.placement.CollectionMetrics;
import org.apache.solr.cluster.placement.NodeMetric;
import org.apache.solr.cluster.placement.impl.AttributeFetcherImpl;

public class AttributeValuesImpl
implements AttributeValues {
    final Map<String, Map<Node, String>> systemSnitchToNodeToValue;
    final Map<NodeMetric<?>, Map<Node, Object>> metricSnitchToNodeToValue;
    final Map<String, CollectionMetrics> collectionMetrics;

    public AttributeValuesImpl(Map<String, Map<Node, String>> systemSnitchToNodeToValue, Map<NodeMetric<?>, Map<Node, Object>> metricSnitchToNodeToValue, Map<String, CollectionMetrics> collectionMetrics) {
        this.systemSnitchToNodeToValue = systemSnitchToNodeToValue;
        this.metricSnitchToNodeToValue = metricSnitchToNodeToValue;
        this.collectionMetrics = collectionMetrics;
    }

    @Override
    public Optional<String> getSystemProperty(Node node, String name) {
        Map<Node, String> nodeToValue = this.systemSnitchToNodeToValue.get(AttributeFetcherImpl.getSystemPropertySnitchTag(name));
        if (nodeToValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nodeToValue.get(node));
    }

    @Override
    public <T> Optional<T> getNodeMetric(Node node, NodeMetric<T> metric) {
        Map<Node, Object> nodeToValue = this.metricSnitchToNodeToValue.get(metric);
        if (nodeToValue == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nodeToValue.get(node));
    }

    @Override
    public Optional<CollectionMetrics> getCollectionMetrics(String collectionName) {
        return Optional.ofNullable(this.collectionMetrics.get(collectionName));
    }
}

