/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.cloud.SolrZkServerProps;
import org.apache.solr.common.SolrException;
import org.apache.solr.util.AddressUtils;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrZkServer {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String ZK_WHITELIST_PROPERTY = "zookeeper.4lw.commands.whitelist";
    String zkRun;
    String zkHost;
    int solrPort;
    Properties props;
    SolrZkServerProps zkProps;
    private Thread zkThread;
    private File dataHome;
    private String confHome;

    public SolrZkServer(String zkRun, String zkHost, File dataHome, String confHome, int solrPort) {
        this.zkRun = zkRun;
        this.zkHost = zkHost;
        this.dataHome = dataHome;
        this.confHome = confHome;
        this.solrPort = solrPort;
    }

    public String getClientString() {
        if (this.zkHost != null) {
            return this.zkHost;
        }
        if (this.zkProps == null) {
            return null;
        }
        if (this.zkRun == null) {
            return null;
        }
        InetSocketAddress addr = this.zkProps.getClientPortAddress();
        String hostName = addr.getAddress().isAnyLocalAddress() ? AddressUtils.getHostToAdvertise() : addr.getAddress().getHostAddress();
        return hostName + ":" + addr.getPort();
    }

    public void parseConfig() {
        block6: {
            Path zooCfgPath;
            if (this.zkProps == null) {
                this.zkProps = new SolrZkServerProps();
                this.zkProps.setDataDir(this.dataHome);
                this.zkProps.zkRun = this.zkRun;
                this.zkProps.solrPort = Integer.toString(this.solrPort);
            }
            if (!Files.exists(zooCfgPath = Path.of(this.confHome, new String[0]).resolve("zoo.cfg"), new LinkOption[0])) {
                log.info("Zookeeper configuration not found in {}, using built-in default", (Object)this.confHome);
                String solrInstallDir = System.getProperty("solr.install.dir");
                if (solrInstallDir == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not find default zoo.cfg file due to missing solr.install.dir");
                }
                zooCfgPath = Path.of(solrInstallDir, new String[0]).resolve("server").resolve("solr").resolve("zoo.cfg");
            }
            try {
                this.props = SolrZkServerProps.getProperties(zooCfgPath);
                SolrZkServerProps.injectServers(this.props, this.zkRun, this.zkHost);
                this.props.setProperty("clientPortAddress", System.getProperty("solr.zk.embedded.host", "127.0.0.1"));
                if (this.props.getProperty("clientPort") == null) {
                    this.props.setProperty("clientPort", Integer.toString(this.solrPort + 1000));
                }
                this.zkProps.parseProperties(this.props);
            }
            catch (IOException | QuorumPeerConfig.ConfigException e) {
                if (this.zkRun == null) break block6;
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, e);
            }
        }
    }

    public Map<Long, QuorumPeer.QuorumServer> getServers() {
        return this.zkProps.getServers();
    }

    public void start() {
        if (this.zkRun == null) {
            return;
        }
        if (System.getProperty(ZK_WHITELIST_PROPERTY) == null) {
            System.setProperty(ZK_WHITELIST_PROPERTY, "ruok, mntr, conf");
        }
        AtomicReference zkException = new AtomicReference();
        this.zkThread = new Thread(() -> {
            try {
                if (this.zkProps.getServers().size() > 1) {
                    QuorumPeerMain zkServer = new QuorumPeerMain();
                    zkServer.runFromConfig((QuorumPeerConfig)this.zkProps);
                } else {
                    ServerConfig sc = new ServerConfig();
                    sc.readFrom((QuorumPeerConfig)this.zkProps);
                    ZooKeeperServerMain zkServer = new ZooKeeperServerMain();
                    zkServer.runFromConfig(sc);
                }
                log.info("ZooKeeper Server exited.");
            }
            catch (Exception e) {
                log.error("ZooKeeper Server ERROR", (Throwable)e);
                zkException.set(e);
            }
        }, "embeddedZkServer");
        if (this.zkProps.getServers().size() > 1) {
            if (log.isInfoEnabled()) {
                log.info("STARTING EMBEDDED ENSEMBLE ZOOKEEPER SERVER at port {}, listening on host {}", (Object)this.zkProps.getClientPortAddress().getPort(), (Object)this.zkProps.getClientPortAddress().getAddress().getHostAddress());
            }
        } else if (log.isInfoEnabled()) {
            log.info("STARTING EMBEDDED ENSEMBLE ZOOKEEPER SERVER at port {}, listening on host {}", (Object)this.zkProps.getClientPortAddress().getPort(), (Object)this.zkProps.getClientPortAddress().getAddress().getHostAddress());
        }
        log.warn("Embedded Zookeeper is not recommended in production environments. See Reference Guide for details.");
        this.zkThread.setDaemon(true);
        this.zkThread.start();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while starting embedded zookeeper server", (Throwable)e);
        }
        if (zkException.get() != null) {
            log.info("Embedded ZK dataHome={}", (Object)this.dataHome);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not start embedded zookeeper server", (Throwable)zkException.get());
        }
    }

    public void stop() {
        if (this.zkRun == null) {
            return;
        }
        this.zkThread.interrupt();
    }
}

