/*
 * Decompiled with CFR 0.152.
 */
package ucar.atd.dorade;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import ucar.atd.dorade.DoradeCELV;
import ucar.atd.dorade.DoradeCFAC;
import ucar.atd.dorade.DoradeCSFD;
import ucar.atd.dorade.DoradeDescriptor;
import ucar.atd.dorade.DoradePARM;
import ucar.atd.dorade.ScanMode;
import ucar.nc2.constants.CDM;
import ucar.nc2.util.Misc;

class DoradeRADD
extends DoradeDescriptor {
    public static final RadarType TYPE_GROUND = new RadarType("ground");
    public static final RadarType TYPE_AIR_FORE = new RadarType("airborne (fore)");
    public static final RadarType TYPE_AIR_AFT = new RadarType("airborne (aft)");
    public static final RadarType TYPE_AIR_TAIL = new RadarType("airborne (tail)");
    public static final RadarType TYPE_AIR_LF = new RadarType("airborne (lower fuselage)");
    public static final RadarType TYPE_SHIP = new RadarType("shipborne");
    public static final RadarType TYPE_AIR_NOSE = new RadarType("airborne (nose)");
    public static final RadarType TYPE_SATELLITE = new RadarType("satellite");
    public static final RadarType TYPE_FIXED_LIDAR = new RadarType("fixed lidar");
    public static final RadarType TYPE_MOVING_LIDAR = new RadarType("moving lidar");
    private static RadarType[] radarTypes = new RadarType[]{TYPE_GROUND, TYPE_AIR_FORE, TYPE_AIR_AFT, TYPE_AIR_LF, TYPE_AIR_TAIL, TYPE_SHIP, TYPE_AIR_NOSE, TYPE_SATELLITE, TYPE_MOVING_LIDAR, TYPE_FIXED_LIDAR};
    private static ScanMode[] scanModeTable = new ScanMode[]{ScanMode.MODE_calibration, ScanMode.MODE_PPI, ScanMode.MODE_coplane, ScanMode.MODE_RHI, ScanMode.MODE_vertical, ScanMode.MODE_target, ScanMode.MODE_manual, ScanMode.MODE_idle, ScanMode.MODE_SUR, ScanMode.MODE_air, ScanMode.MODE_horizontal};
    private String radarName;
    private float radarConstant;
    private float peakPower;
    private float noisePower;
    private float rcvrGain;
    private float antennaGain;
    private float systemGain;
    private float hBeamWidth;
    private float vBeamWidth;
    private short radarTypeNdx;
    private ScanMode scanMode;
    private float rotVelocity;
    private float scanParam0;
    private float scanParam1;
    private short nParams;
    private short nAdditionalDescriptors;
    private short compressionScheme;
    public static final int COMPRESSION_NONE = 0;
    public static final int COMPRESSION_HRD = 1;
    private short dataReductionMethod;
    public static final int DATA_REDUCTION_NONE = 1;
    public static final int DATA_REDUCTION_BY_AZIMUTH = 2;
    public static final int DATA_REDUCTION_BY_RANGE = 3;
    public static final int DATA_REDUCTION_BY_ALTITUDE = 4;
    private float reductionBound0;
    private float reductionBound1;
    private float longitude;
    private float latitude;
    private float altitude;
    private float unambiguousVelocity;
    private float unambiguousRange;
    private short nFrequencies;
    private short nPRTs;
    private float[] frequencies;
    private float[] PRTs;
    private DoradePARM[] myPARMs;
    private DoradeCELV myCELV;
    private DoradeCFAC myCFAC;
    private int nCells;

    public DoradeRADD(RandomAccessFile file, boolean littleEndianData) throws DoradeDescriptor.DescriptorException {
        int i;
        byte[] data = this.readDescriptor(file, littleEndianData, "RADD");
        this.radarName = new String(data, 8, 8, CDM.utf8Charset).trim();
        this.radarConstant = this.grabFloat(data, 16);
        this.peakPower = this.grabFloat(data, 20);
        this.noisePower = this.grabFloat(data, 24);
        this.rcvrGain = this.grabFloat(data, 28);
        this.antennaGain = this.grabFloat(data, 32);
        this.systemGain = this.grabFloat(data, 36);
        this.hBeamWidth = this.grabFloat(data, 40);
        this.vBeamWidth = this.grabFloat(data, 44);
        this.radarTypeNdx = this.grabShort(data, 48);
        this.scanMode = scanModeTable[this.grabShort(data, 50)];
        this.rotVelocity = this.grabFloat(data, 52);
        this.scanParam0 = this.grabFloat(data, 56);
        this.scanParam1 = this.grabFloat(data, 60);
        this.nParams = this.grabShort(data, 64);
        this.nAdditionalDescriptors = this.grabShort(data, 66);
        this.compressionScheme = this.grabShort(data, 68);
        this.dataReductionMethod = this.grabShort(data, 70);
        this.reductionBound0 = this.grabFloat(data, 72);
        this.reductionBound1 = this.grabFloat(data, 76);
        this.longitude = this.grabFloat(data, 80);
        this.latitude = this.grabFloat(data, 84);
        this.altitude = this.grabFloat(data, 88);
        this.unambiguousVelocity = this.grabFloat(data, 92);
        this.unambiguousRange = this.grabFloat(data, 96);
        this.nFrequencies = this.grabShort(data, 100);
        this.nPRTs = this.grabShort(data, 102);
        this.frequencies = new float[5];
        for (i = 0; i < 5; ++i) {
            this.frequencies[i] = this.grabFloat(data, 104 + 4 * i);
        }
        this.PRTs = new float[5];
        for (i = 0; i < 5; ++i) {
            this.PRTs[i] = this.grabFloat(data, 124 + 4 * i);
        }
        if (this.verbose) {
            System.out.println(this);
        }
        this.myPARMs = new DoradePARM[this.nParams];
        for (i = 0; i < this.nParams; ++i) {
            this.myPARMs[i] = new DoradePARM(file, littleEndianData, this);
        }
        try {
            String dName;
            long startpos = file.getFilePointer();
            switch (dName = DoradeRADD.peekName(file)) {
                case "CELV": {
                    this.myCELV = new DoradeCELV(file, littleEndianData);
                    break;
                }
                case "CSFD": {
                    file.seek(startpos);
                    this.myCELV = new DoradeCSFD(file, littleEndianData);
                    break;
                }
                default: {
                    throw new DoradeDescriptor.DescriptorException("Expected " + dName + " descriptor not found!");
                }
            }
        }
        catch (IOException ioex) {
            throw new DoradeDescriptor.DescriptorException(ioex);
        }
        this.nCells = this.myCELV.getNCells();
        this.myCFAC = this.nAdditionalDescriptors > this.nParams + 1 ? new DoradeCFAC(file, littleEndianData) : null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DoradeRADD{");
        sb.append("radarName='").append(this.radarName).append('\'');
        sb.append(", radarConstant=").append(this.radarConstant);
        sb.append(", peakPower=").append(this.peakPower);
        sb.append(", noisePower=").append(this.noisePower);
        sb.append(", rcvrGain=").append(this.rcvrGain);
        sb.append(", antennaGain=").append(this.antennaGain);
        sb.append(", systemGain=").append(this.systemGain);
        sb.append(", hBeamWidth=").append(this.hBeamWidth);
        sb.append(", vBeamWidth=").append(this.vBeamWidth);
        sb.append(", radarTypeNdx=").append(this.radarTypeNdx);
        sb.append(", scanMode=").append(this.scanMode);
        sb.append(", rotVelocity=").append(this.rotVelocity);
        sb.append(", scanParam0=").append(this.scanParam0);
        sb.append(", scanParam1=").append(this.scanParam1);
        sb.append(", nParams=").append(this.nParams);
        sb.append(", nAdditionalDescriptors=").append(this.nAdditionalDescriptors);
        sb.append(", compressionScheme=").append(this.compressionScheme);
        sb.append(", dataReductionMethod=").append(this.dataReductionMethod);
        sb.append(", reductionBound0=").append(this.reductionBound0);
        sb.append(", reductionBound1=").append(this.reductionBound1);
        sb.append(", longitude=").append(this.longitude);
        sb.append(", latitude=").append(this.latitude);
        sb.append(", altitude=").append(this.altitude);
        sb.append(", unambiguousVelocity=").append(this.unambiguousVelocity);
        sb.append(", unambiguousRange=").append(this.unambiguousRange);
        sb.append(", nFrequencies=").append(this.nFrequencies);
        sb.append(", nPRTs=").append(this.nPRTs);
        sb.append(", frequencies=").append(Arrays.toString(this.frequencies));
        sb.append(", PRTs=").append(Arrays.toString(this.PRTs));
        sb.append(", myPARMs=").append(Arrays.toString(this.myPARMs));
        sb.append(", myCELV=").append(this.myCELV);
        sb.append(", myCFAC=").append(this.myCFAC);
        sb.append(", nCells=").append(this.nCells);
        sb.append('}');
        return sb.toString();
    }

    public int getCompressionScheme() {
        return this.compressionScheme;
    }

    public int getNCells() {
        return this.nCells;
    }

    public DoradePARM[] getParamList() {
        return this.myPARMs;
    }

    public int getNParams() {
        return this.nParams;
    }

    public String getRadarName() {
        return this.radarName;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public float getAltitude() {
        return this.altitude;
    }

    public float getRangeToFirstCell() {
        return this.myCELV.getCellRanges()[0];
    }

    public float getCellSpacing() throws DoradeDescriptor.DescriptorException {
        float[] cellRanges = this.myCELV.getCellRanges();
        float cellSpacing = cellRanges[1] - cellRanges[0];
        for (int i = 2; i < cellRanges.length; ++i) {
            float space = cellRanges[i] - cellRanges[i - 1];
            if (Misc.closeEnough(space, cellSpacing) || !(Math.abs((double)(space / cellSpacing) - 1.0) > 0.01)) continue;
            throw new DoradeDescriptor.DescriptorException("variable cell spacing");
        }
        return cellSpacing;
    }

    public ScanMode getScanMode() {
        return this.scanMode;
    }

    public float getUnambiguousVelocity() {
        return this.unambiguousVelocity;
    }

    public float getunambiguousRange() {
        return this.unambiguousRange;
    }

    public float getradarConstant() {
        return this.radarConstant;
    }

    public float getrcvrGain() {
        return this.rcvrGain;
    }

    public float getantennaGain() {
        return this.antennaGain;
    }

    public float getsystemGain() {
        return this.systemGain;
    }

    public float gethBeamWidth() {
        return this.hBeamWidth;
    }

    public float getpeakPower() {
        return this.peakPower;
    }

    public float getnoisePower() {
        return this.noisePower;
    }

    static class RadarType {
        private String name;

        protected RadarType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

