/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.common.util.NamedList;
import org.noggit.CharArr;
import org.noggit.JSONWriter;

public class ConfigTool
extends ToolBase {
    public ConfigTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "config";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of the collection.").build(), Option.builder((String)"a").longOpt("action").argName("ACTION").hasArg().required(false).desc("Config API action, one of: set-property, unset-property, set-user-property, unset-user-property; default is 'set-property'.").build(), Option.builder().longOpt("property").argName("PROP").hasArg().required(false).desc("Name of the Config API property to apply the action to, such as: 'updateHandler.autoSoftCommit.maxTime'.").build(), Option.builder((String)"p").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --property instead").get()).hasArg().argName("PROP").required(false).desc("Name of the Config API property to apply the action to, such as: 'updateHandler.autoSoftCommit.maxTime'.").build(), Option.builder((String)"v").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --value instead").get()).argName("VALUE").hasArg().required(false).desc("Set the property to this value; accepts JSON objects and strings.").build(), Option.builder().longOpt("value").argName("VALUE").hasArg().required(false).desc("Set the property to this value; accepts JSON objects and strings.").build(), SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        block13: {
            String solrUrl = SolrCLI.normalizeSolrUrl(cli);
            String action = cli.getOptionValue("action", "set-property");
            String collection = cli.getOptionValue("name");
            String property = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "property", "p", null);
            String value = SolrCLI.getOptionWithDeprecatedAndDefault(cli, "value", "v", null);
            if (property == null) {
                throw new MissingArgumentException("'property' is a required option.");
            }
            if (value == null) {
                throw new MissingArgumentException("'value' is a required option.");
            }
            HashMap<String, Object> jsonObj = new HashMap<String, Object>();
            if (value != null) {
                HashMap<String, String> setMap = new HashMap<String, String>();
                setMap.put(property, value);
                jsonObj.put(action, setMap);
            } else {
                jsonObj.put(action, property);
            }
            CharArr arr = new CharArr();
            new JSONWriter(arr, 0).write(jsonObj);
            String jsonBody = arr.toString();
            String updatePath = "/" + collection + "/config";
            this.echo("\nPOSTing request to Config API: " + solrUrl + updatePath);
            this.echoIfVerbose(jsonBody, cli);
            try (SolrClient solrClient = SolrCLI.getSolrClient(solrUrl);){
                NamedList<Object> result = SolrCLI.postJsonToSolr(solrClient, updatePath, jsonBody);
                Integer statusCode = (Integer)result._get(List.of("responseHeader", "status"), null);
                if (statusCode == 0) {
                    if (value != null) {
                        this.echo("Successfully " + action + " " + property + " to " + value);
                    } else {
                        this.echo("Successfully " + action + " " + property);
                    }
                    break block13;
                }
                throw new Exception("Failed to " + action + " property due to:\n" + String.valueOf(result));
            }
        }
    }
}

