/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.CreateCollectionSnapshotRequestBody;
import org.apache.solr.client.api.model.ListCollectionSnapshotsResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CollectionSnapshotsApi {

    public static class ListSnapshots
    extends SolrRequest<ListSnapshotsResponse> {
        private final String collName;

        public ListSnapshots(String collName) {
            super(SolrRequest.METHOD.valueOf("GET"), "/collections/{collName}/snapshots".replace("{collName}", collName));
            this.collName = collName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected ListSnapshotsResponse createResponse(SolrClient client) {
            return new ListSnapshotsResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ListSnapshotsResponse
    extends JacksonParsingResponse<ListCollectionSnapshotsResponse> {
        public ListSnapshotsResponse() {
            super(ListCollectionSnapshotsResponse.class);
        }
    }

    public static class DeleteCollectionSnapshot
    extends SolrRequest<DeleteCollectionSnapshotResponse> {
        private final String collName;
        private final String snapshotName;
        private Boolean followAliases;
        private String async;

        public DeleteCollectionSnapshot(String collName, String snapshotName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collName}/snapshots/{snapshotName}".replace("{collName}", collName).replace("{snapshotName}", snapshotName));
            this.collName = collName;
            this.snapshotName = snapshotName;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        public void setAsync(String async) {
            this.async = async;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (this.followAliases != null) {
                params.add("followAliases", this.followAliases.toString());
            }
            if (this.async != null) {
                params.add("async", this.async);
            }
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            queryParams.add("followAliases");
            queryParams.add("async");
            return queryParams;
        }

        @Override
        protected DeleteCollectionSnapshotResponse createResponse(SolrClient client) {
            return new DeleteCollectionSnapshotResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteCollectionSnapshotResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse> {
        public DeleteCollectionSnapshotResponse() {
            super(org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse.class);
        }
    }

    public static class CreateCollectionSnapshot
    extends SolrRequest<CreateCollectionSnapshotResponse> {
        private final CreateCollectionSnapshotRequestBody requestBody;
        private final String collName;
        private final String snapshotName;

        public CreateCollectionSnapshot(String collName, String snapshotName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/collections/{collName}/snapshots/{snapshotName}".replace("{collName}", collName).replace("{snapshotName}", snapshotName));
            this.collName = collName;
            this.snapshotName = snapshotName;
            this.requestBody = new CreateCollectionSnapshotRequestBody();
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.requestBody.followAliases = followAliases;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
            return new JacksonContentWriter(this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrRequest.ApiVersion getApiVersion() {
            return SolrRequest.ApiVersion.V2;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        public Set<String> getQueryParams() {
            HashSet<String> queryParams = new HashSet<String>();
            return queryParams;
        }

        @Override
        protected CreateCollectionSnapshotResponse createResponse(SolrClient client) {
            return new CreateCollectionSnapshotResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateCollectionSnapshotResponse
    extends JacksonParsingResponse<org.apache.solr.client.api.model.CreateCollectionSnapshotResponse> {
        public CreateCollectionSnapshotResponse() {
            super(org.apache.solr.client.api.model.CreateCollectionSnapshotResponse.class);
        }
    }
}

