/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLabelImageToLabelMapFilter_h
#define sitkLabelImageToLabelMapFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LabelImageToLabelMapFilter
\brief convert a labeled image to a label collection image

LabelImageToLabelMapFilter converts a label image to a label collection image. The labels are the same in the input and the output image.

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4 

\see BinaryImageToLabelMapFilter , LabelMapToLabelImageFilter
\sa itk::simple::LabelImageToLabelMapFilter for the procedural interface
\sa itk::LabelImageToLabelMapFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LabelImageToLabelMapFilter : public ImageFilter {
    public:
      using Self = LabelImageToLabelMapFilter;

      /** Destructor */
      virtual ~LabelImageToLabelMapFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LabelImageToLabelMapFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = UnsignedIntegerPixelIDTypeList;
\

      /**
       * Set/Get the value used as "background" in the output image. Defaults to NumericTraits<PixelType>::NonpositiveMin() .
       */
      SITK_RETURN_SELF_TYPE_HEADER SetBackgroundValue ( double BackgroundValue ) { this->m_BackgroundValue = BackgroundValue; return *this; }

      /**
       * Set/Get the value used as "background" in the output image. Defaults to NumericTraits<PixelType>::NonpositiveMin() .
       */
      double GetBackgroundValue() const { return this->m_BackgroundValue; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LabelImageToLabelMapFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      double  m_BackgroundValue{0};


    };

    /**\
     * \brief convert a labeled image to a label collection image
     *
     * This function directly calls the execute method of LabelImageToLabelMapFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LabelImageToLabelMapFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image LabelImageToLabelMap ( const Image& image1, double backgroundValue = 0 );

     /** @} */
}
#endif
