\name{SaltAndPepperNoiseImageFilter}
\alias{SaltAndPepperNoiseImageFilter}
\title{SaltAndPepperNoiseImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Alter an image with fixed value impulse noise, often called salt and
pepper noise.
SaltAndPepperNoiseImageFilter}
\details{
Salt (sensor saturation) and pepper (dead pixels) noise is a special
kind of impulse noise where the value of the noise is either the
maximum possible value in the image or its minimum. This is not
necessarily the maximal/minimal possible intensity value based on the
pixel type. For example, the native pixel type for CT is a signed 16
bit integer, but only 12 bits used, so we would like to set the salt
and pepper values to match this smaller intensity range and not the
range the pixel type represents. It can be modeled as:
 \eqn{ I = \begin{cases} M, \quad if  U < p/2 \\ m, \quad if  U > 1 - p/2 \\ I_0, \quad if  p/2 \geq U \leq 1 - p/2 \end{cases} }
where \eqn{ p } is the probability of the noise event, \eqn{ U } is a uniformly distributed random variable in the \eqn{ [0,1] } range, \eqn{ M } is the greatest possible pixel value, and \eqn{ m } the smallest possible pixel value.
 Pixel alteration occurs at a user defined probability. Salt and
pepper pixels are equally distributed.
Gaetan Lehmann
 This code was contributed in the Insight Journal paper "Noise
Simulation". https://www.insight-journal.org/browse/publication/721
See:
SaltAndPepperNoise for the procedural interface
itk::SaltAndPepperNoiseImageFilter for the Doxygen on the original ITK class.
SaltAndPepperNoiseImageFilter}
%C++ includes: sitkSaltAndPepperNoiseImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{}
\item{Image Execute(Image &&image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{double GetProbability() const:}{
Set/Get the probability of the salt and pepper noise event. Defaults
to 0.01.
}
\item{uint32_t GetSeed() const:}{}
\item{ SaltAndPepperNoiseImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetProbability(double Probability):}{
Set/Get the probability of the salt and pepper noise event. Defaults
to 0.01.
}
\item{Self SetSeed(uint32_t Seed):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~SaltAndPepperNoiseImageFilter():}{
Destructor
}
}
}
