/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mlapi.feature.json;

import com.jetbrains.mlapi.feature.Feature;
import com.jetbrains.mlapi.feature.FeatureSignature;
import com.jetbrains.mlapi.feature.PrimitiveType;
import com.jetbrains.mlapi.feature.UnionFeatureSignature;
import com.jetbrains.mlapi.feature.UnionType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonIntegerFeature;", "Lcom/jetbrains/mlapi/feature/Feature$Int32;", "Lcom/jetbrains/mlapi/feature/Feature$Int64;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "int32Value", "", "getInt32Value", "()I", "int64Value", "", "getInt64Value", "()J", "integerAsString", "getIntegerAsString", "()Ljava/lang/String;", "signature", "Lcom/jetbrains/mlapi/feature/FeatureSignature;", "getSignature", "()Lcom/jetbrains/mlapi/feature/FeatureSignature;", "equals", "", "other", "", "hashCode", "toString", "withName", "Lcom/jetbrains/mlapi/feature/Feature;", "newName", "Companion", "mlapi-core"})
public final class JsonIntegerFeature
implements Feature.Int32,
Feature.Int64 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    @NotNull
    private final FeatureSignature signature;
    @NotNull
    private static final UnionType INTEGER_TYPE;

    public JsonIntegerFeature(@NotNull String name, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.signature = new UnionFeatureSignature(name, INTEGER_TYPE, null, 4, null);
    }

    @Override
    @NotNull
    public FeatureSignature getSignature() {
        return this.signature;
    }

    @Override
    public int getInt32Value() {
        return Integer.parseInt(this.content);
    }

    @Override
    @NotNull
    public String getIntegerAsString() {
        return this.content;
    }

    @Override
    public long getInt64Value() {
        return Long.parseLong(this.content);
    }

    @Override
    @NotNull
    public Feature withName(@NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return new JsonIntegerFeature(newName, this.content);
    }

    @NotNull
    public String toString() {
        return this.getName() + "(json-integer)='" + this.content + "'";
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.jetbrains.mlapi.feature.json.JsonIntegerFeature");
        JsonIntegerFeature cfr_ignored_0 = (JsonIntegerFeature)other;
        if (!Intrinsics.areEqual((Object)this.content, (Object)((JsonIntegerFeature)other).content)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getSignature(), (Object)((JsonIntegerFeature)other).getSignature());
    }

    public int hashCode() {
        int result = this.content.hashCode();
        result = 31 * result + this.getSignature().hashCode();
        return result;
    }

    static {
        PrimitiveType[] primitiveTypeArray = new PrimitiveType[]{PrimitiveType.Int32.INSTANCE, PrimitiveType.Int64.INSTANCE};
        INTEGER_TYPE = new UnionType(primitiveTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/mlapi/feature/json/JsonIntegerFeature$Companion;", "", "()V", "INTEGER_TYPE", "Lcom/jetbrains/mlapi/feature/UnionType;", "mlapi-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

