/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.utils.errors;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ExceptionWithAttachments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010\u0013\u001a\u0004\u0018\u0001H\u0014\"\u0004\b\u0000\u0010\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/performancePlugin/utils/errors/ToDirectoryWritingErrorCollector;", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "presentableName", "", "directory", "Ljava/nio/file/Path;", "limitOfErrors", "", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;I)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "nextErrorId", "Ljava/util/concurrent/atomic/AtomicInteger;", "addError", "", "error", "", "runCatchingError", "T", "computation", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "numberOfErrors", "getNumberOfErrors", "()I", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nToDirectoryWritingErrorCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToDirectoryWritingErrorCollector.kt\ncom/jetbrains/performancePlugin/utils/errors/ToDirectoryWritingErrorCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class ToDirectoryWritingErrorCollector
implements ErrorCollector {
    @NotNull
    private final String presentableName;
    @NotNull
    private final Path directory;
    private final int limitOfErrors;
    @NotNull
    private final Logger logger;
    @NotNull
    private final AtomicInteger nextErrorId;

    public ToDirectoryWritingErrorCollector(@NotNull String presentableName, @NotNull Path directory, int limitOfErrors) {
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this.presentableName = presentableName;
        this.directory = directory;
        this.limitOfErrors = limitOfErrors;
        Logger logger = Logger.getInstance((String)("error-collector-" + this.presentableName));
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.nextErrorId = new AtomicInteger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        int errorId = this.nextErrorId.incrementAndGet();
        if (errorId > this.limitOfErrors) {
            throw new RuntimeException("Too many errors reported for " + this.presentableName);
        }
        Path errorHome = this.directory.resolve("error-" + errorId);
        Intrinsics.checkNotNull((Object)errorHome);
        PathKt.createDirectories((Path)errorHome);
        String string = error.getMessage();
        if (string == null) {
            string = error.getClass().getName();
        }
        this.logger.warn("Error #" + errorId + " has been collected. Details will be saved to " + errorHome + ". Message: " + string);
        Path path = errorHome.resolve("stacktrace.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        String string2 = ExceptionUtil.getThrowableText((Throwable)error);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getThrowableText(...)");
        PathKt.write$default((Path)path, (CharSequence)string2, null, (boolean)false, (int)6, null);
        if (error instanceof ExceptionWithAttachments) {
            Attachment[] attachmentArray = ((ExceptionWithAttachments)error).getAttachments();
            Intrinsics.checkNotNullExpressionValue((Object)attachmentArray, (String)"getAttachments(...)");
            for (Attachment attachment : attachmentArray) {
                Intrinsics.checkNotNull((Object)attachment);
                Attachment attachment2 = attachment;
                Path attachmentPath = errorHome.resolve(attachment2.getPath());
                Intrinsics.checkNotNull((Object)attachmentPath);
                Closeable closeable = PathKt.outputStream((Path)attachmentPath);
                Throwable throwable = null;
                try {
                    OutputStream os = (OutputStream)closeable;
                    boolean bl = false;
                    InputStream inputStream = attachment2.openContentStream();
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openContentStream(...)");
                    long l2 = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)os, (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
    }

    @Override
    @Nullable
    public <T> T runCatchingError(@NotNull Function0<? extends T> computation) {
        Object object;
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter(computation, (String)"computation");
            try {
                object = Result.constructor-impl((Object)computation.invoke());
            }
            catch (Throwable throwable2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
            }
            Throwable throwable3 = Result.exceptionOrNull-impl((Object)object);
            if (throwable3 == null) break block2;
            Throwable it = throwable = throwable3;
            boolean bl = false;
            this.addError(it);
        }
        return (T)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @Override
    public int getNumberOfErrors() {
        return this.nextErrorId.get();
    }
}

