/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.Monitor;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;
import oracle.sql.ORADataFactory;

@Deprecated
public class OracleArray
extends DatumWithConnection
implements oracle.jdbc.internal.OracleArray {
    static final byte KOPUP_INLINE_COLL = 1;
    ArrayDescriptor descriptor;
    Object objArray;
    Map<?, ?> javaMap = null;
    Datum[] datumArray;
    byte[] locator;
    byte prefixFlag;
    byte[] prefixSegment;
    int numElems = -1;
    boolean enableBuffering = false;
    boolean enableIndexing = false;
    boolean isFreed = false;
    public static final int ACCESS_FORWARD = 1;
    public static final int ACCESS_REVERSE = 2;
    public static final int ACCESS_UNKNOWN = 3;
    int accessDirection = 3;
    long lastIndex;
    long lastOffset;
    long[] indexArray;
    long imageOffset;
    long imageLength;
    Object acProxy;

    public OracleArray(ArrayDescriptor type, Connection conn, Object elements) throws SQLException {
        OracleArray.assertNotNull(type);
        this.descriptor = type;
        OracleArray.assertNotNull(conn);
        if (!type.getInternalConnection().isDescriptorSharable(((OracleConnection)conn).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance, invalid connection").fillInStackTrace();
        }
        type.setConnection(conn);
        this.setPhysicalConnectionOf(conn);
        this.datumArray = elements == null ? new Datum[0] : this.descriptor.toOracleArray(elements, 1L, -1);
    }

    public OracleArray(ArrayDescriptor type, byte[] bytes, Connection conn) throws SQLException {
        super(bytes);
        OracleArray.assertNotNull(type);
        this.descriptor = type;
        OracleArray.assertNotNull(conn);
        if (!type.getInternalConnection().isDescriptorSharable(((OracleConnection)conn).physicalConnectionWithin())) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Cannot construct ARRAY instance, invalid connection").fillInStackTrace();
        }
        type.setConnection(conn);
        this.setPhysicalConnectionOf(conn);
        this.datumArray = null;
        this.locator = null;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String string = this.descriptor.getBaseName();
            return string;
        }
    }

    @Override
    public int getBaseType() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            int n = this.descriptor.getBaseType();
            return n;
        }
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Object[] objectArray = this.descriptor.toJavaArray(this, this, 1L, -1, this.getMap(), this.enableBuffering);
            return objectArray;
        }
    }

    @Override
    public Map<?, ?> getJavaMap() throws SQLException {
        this.getArray();
        return this.javaMap;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Object[] objectArray = this.descriptor.toJavaArray(this, this, 1L, -1, map, this.enableBuffering);
            return objectArray;
        }
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (index < 1L || count < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments, 'index' should be >= 1 and 'count' >= 0. An exception is thrown.").fillInStackTrace();
            }
            Object[] objectArray = this.descriptor.toJavaArray(this, this, index, count, this.getMap(), false);
            return objectArray;
        }
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (index < 1L || count < 0) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "Invalid arguments, 'index' should be >= 1 and 'count' >= 0. An exception is thrown.");
            }
            Object[] objectArray = this.descriptor.toJavaArray(this, this, index, count, map, false);
            return objectArray;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            ResultSet resultSet = this.getResultSet(this.getInternalConnection().getTypeMap());
            return resultSet;
        }
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            ResultSet resultSet = this.descriptor.toResultSet(this, this, 1L, -1, map, this.enableBuffering);
            return resultSet;
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            ResultSet resultSet = this.getResultSet(index, count, this.getInternalConnection().getTypeMap());
            return resultSet;
        }
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (index < 1L || count < -1) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getResultSet()");
            }
            ResultSet resultSet = this.descriptor.toResultSet(this, this, index, count, map, false);
            return resultSet;
        }
    }

    @Override
    public Datum[] getOracleArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            Datum[] datumArray = this.descriptor.toOracleArray(this, this, 1L, -1, this.enableBuffering);
            return datumArray;
        }
    }

    @Override
    public int length() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            int n = this.descriptor.toLength(this, this);
            return n;
        }
    }

    @Override
    public Datum[] getOracleArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (index < 1L || count < 0) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getOracleArray()");
            }
            Datum[] datumArray = this.descriptor.toOracleArray(this, this, index, count, false);
            return datumArray;
        }
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            String ret = null;
            if (this.descriptor == null) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 61, "ARRAY");
            }
            ret = this.descriptor.getName();
            String string = ret;
            return string;
        }
    }

    @Override
    public Map<String, Class<?>> getMap() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.getInternalConnection().getTypeMap();
    }

    @Override
    public OracleTypeMetaData getOracleMetaData() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.getDescriptor();
    }

    @Override
    public ArrayDescriptor getDescriptor() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.descriptor;
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            byte[] byArray = this.descriptor.toBytes(this, this, this.enableBuffering);
            return byArray;
        }
    }

    @Override
    public void setDatumArray(Datum[] darray) {
        this.datumArray = darray;
    }

    @Override
    public void setObjArray(Object oarray) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            if (oarray == null) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid argument, 'oarray' should not be null. An exception is thrown.");
            }
            this.objArray = oarray;
        }
    }

    @Override
    public void setJavaMap(Map<?, ?> map) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.javaMap = map;
        }
    }

    @Override
    public void setLocator(byte[] pseg_bytes) {
        if (pseg_bytes != null && pseg_bytes.length != 0) {
            this.locator = pseg_bytes;
        }
    }

    @Override
    public void setPrefixSegment(byte[] pseg_bytes) {
        if (pseg_bytes != null && pseg_bytes.length != 0) {
            this.prefixSegment = pseg_bytes;
        }
    }

    @Override
    public void setPrefixFlag(byte psegFlag) {
        this.prefixFlag = psegFlag;
    }

    @Override
    public byte[] getLocator() {
        return this.locator;
    }

    @Override
    public void setLength(int len) {
        this.numElems = len;
    }

    @Override
    public boolean hasDataSeg() {
        return this.locator == null;
    }

    @Override
    public boolean isInline() {
        return (this.prefixFlag & 1) == 1;
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return null;
    }

    public Object toJdbc(Map<String, Class<?>> map) throws SQLException {
        Class c;
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        Object jdbcObject = this;
        if (map != null && (c = this.descriptor.getClass(map)) != null) {
            jdbcObject = this.toClass(c, map);
        }
        return jdbcObject;
    }

    Object toClass(Class<?> clazz, Map<String, Class<?>> map) throws SQLException {
        Object obj;
        block7: {
            if (this.isFreed) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
            }
            obj = null;
            try {
                if (clazz == null || clazz == ARRAY.class || clazz == Array.class || clazz == oracle.jdbc.OracleArray.class || clazz == oracle.jdbc.internal.OracleArray.class) {
                    obj = this;
                    break block7;
                }
                Object i = clazz.newInstance();
                if (i instanceof ORADataFactory) {
                    ORADataFactory f = (ORADataFactory)i;
                    obj = f.create(this, 2003);
                    break block7;
                }
                if (i instanceof OracleDataFactory) {
                    OracleDataFactory f = (OracleDataFactory)i;
                    obj = f.create(this, 2003);
                    break block7;
                }
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
            }
            catch (InstantiationException ex) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + ex.getMessage());
            }
        }
        return obj;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        return false;
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new Object[arraySize][];
    }

    @Override
    public int[] getIntArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            int[] nArray = (int[])this.descriptor.toNumericArray(this, this, 1L, -1, 4, this.enableBuffering);
            return nArray;
        }
    }

    @Override
    public int[] getIntArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            int[] nArray = (int[])this.descriptor.toNumericArray(this, this, index, count, 4, false);
            return nArray;
        }
    }

    @Override
    public double[] getDoubleArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            double[] dArray = (double[])this.descriptor.toNumericArray(this, this, 1L, -1, 5, this.enableBuffering);
            return dArray;
        }
    }

    @Override
    public double[] getDoubleArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            double[] dArray = (double[])this.descriptor.toNumericArray(this, this, index, count, 5, false);
            return dArray;
        }
    }

    @Override
    public short[] getShortArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            short[] sArray = (short[])this.descriptor.toNumericArray(this, this, 1L, -1, 8, this.enableBuffering);
            return sArray;
        }
    }

    @Override
    public short[] getShortArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            short[] sArray = (short[])this.descriptor.toNumericArray(this, this, index, count, 8, false);
            return sArray;
        }
    }

    @Override
    public long[] getLongArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            long[] lArray = (long[])this.descriptor.toNumericArray(this, this, 1L, -1, 7, this.enableBuffering);
            return lArray;
        }
    }

    @Override
    public long[] getLongArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            long[] lArray = (long[])this.descriptor.toNumericArray(this, this, index, count, 7, false);
            return lArray;
        }
    }

    @Override
    public float[] getFloatArray() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            float[] fArray = (float[])this.descriptor.toNumericArray(this, this, 1L, -1, 6, this.enableBuffering);
            return fArray;
        }
    }

    @Override
    public float[] getFloatArray(long index, int count) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            float[] fArray = (float[])this.descriptor.toNumericArray(this, this, index, count, 6, false);
            return fArray;
        }
    }

    @Override
    public void setAutoBuffering(boolean enable) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.enableBuffering = enable;
        }
    }

    @Override
    public boolean getAutoBuffering() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.enableBuffering;
    }

    @Override
    public void setAutoIndexing(boolean enable, int direction) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.enableIndexing = enable;
            this.accessDirection = direction;
        }
    }

    @Override
    public void setAutoIndexing(boolean enable) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        try (Monitor.CloseableLock lock = this.getInternalConnection().acquireCloseableLock();){
            this.enableIndexing = enable;
            this.accessDirection = 3;
        }
    }

    @Override
    public boolean getAutoIndexing() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.enableIndexing;
    }

    @Override
    public int getAccessDirection() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.accessDirection;
    }

    @Override
    public void setLastIndexOffset(long index, long offset) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        this.lastIndex = index;
        this.lastOffset = offset;
    }

    @Override
    public void setIndexOffset(long index, long offset) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        if (this.indexArray == null) {
            this.indexArray = new long[this.numElems];
        }
        this.indexArray[(int)index - 1] = offset;
    }

    @Override
    public long getLastIndex() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.lastIndex;
    }

    @Override
    public long getLastOffset() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        return this.lastOffset;
    }

    @Override
    public long getOffset(long index) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        long ret = -1L;
        if (this.indexArray != null) {
            ret = this.indexArray[(int)index - 1];
        }
        return ret;
    }

    @Override
    public void setImage(byte[] image, long offset, long length) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        this.setShareBytes(image);
        this.imageOffset = offset;
        this.imageLength = length;
    }

    @Override
    public void setImageLength(long length) throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        this.imageLength = length;
    }

    @Override
    public long getImageOffset() {
        return this.imageOffset;
    }

    @Override
    public long getImageLength() {
        return this.imageLength;
    }

    @Override
    public String stringValue() throws SQLException {
        if (this.isFreed) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 291);
        }
        Datum[] datums = this.getOracleArray();
        Object ret = "[";
        for (int i = 0; i < datums.length; ++i) {
            if (i != 0) {
                ret = (String)ret + ", ";
            }
            ret = datums[i] == null ? (String)ret + "null" : (String)ret + datums[i].stringValue();
        }
        ret = (String)ret + "]";
        return ret;
    }

    @Override
    public void free() throws SQLException {
        this.isFreed = true;
    }

    public boolean isFreed() {
        return this.isFreed;
    }

    @Override
    public int getNumElems() {
        return this.numElems;
    }

    @Override
    public Datum[] getDatumArray() {
        return this.datumArray;
    }

    @Override
    public Object getObjArray() {
        return this.objArray;
    }

    @Override
    public void setNullObjArray() {
        this.objArray = null;
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }
}

