/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.LegacyCheckBoxTree;
import com.jidesoft.swing.LegacyCheckBoxTreeSelectionModel;
import com.jidesoft.swing.LegacyTristateCheckBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class LegacyCheckBoxTreeCellRenderer
extends JPanel
implements TreeCellRenderer,
Serializable {
    private static final long serialVersionUID = 30207434500313004L;
    protected LegacyTristateCheckBox _checkBox = null;
    protected JComponent _emptyBox = null;
    protected JCheckBox _protoType = new LegacyTristateCheckBox();
    protected TreeCellRenderer _actualTreeRenderer;

    public LegacyCheckBoxTreeCellRenderer() {
        this((TreeCellRenderer)null);
    }

    public LegacyCheckBoxTreeCellRenderer(TreeCellRenderer renderer) {
        this(renderer, null);
    }

    public LegacyCheckBoxTreeCellRenderer(TreeCellRenderer renderer, LegacyTristateCheckBox checkBox) {
        this._checkBox = checkBox == null ? this.createCheckBox() : checkBox;
        this._emptyBox = (JComponent)Box.createHorizontalStrut(this._protoType.getPreferredSize().width);
        this.setLayout(new BorderLayout(0, 0));
        this.setOpaque(false);
        this._actualTreeRenderer = renderer;
    }

    protected LegacyTristateCheckBox createCheckBox() {
        LegacyTristateCheckBox checkBox = new LegacyTristateCheckBox();
        checkBox.setOpaque(false);
        return checkBox;
    }

    public TreeCellRenderer getActualTreeRenderer() {
        return this._actualTreeRenderer;
    }

    public void setActualTreeRenderer(TreeCellRenderer actualTreeRenderer) {
        this._actualTreeRenderer = actualTreeRenderer;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        LegacyCheckBoxTreeSelectionModel selectionModel;
        this.removeAll();
        this._checkBox.setPreferredSize(new Dimension(this._protoType.getPreferredSize().width, 0));
        this._emptyBox.setPreferredSize(new Dimension(this._protoType.getPreferredSize().width, 0));
        this.applyComponentOrientation(tree.getComponentOrientation());
        TreePath path = tree.getPathForRow(row);
        if (path != null && tree instanceof LegacyCheckBoxTree && (selectionModel = ((LegacyCheckBoxTree)tree).getCheckBoxTreeSelectionModel()) != null) {
            boolean enabled;
            boolean bl = enabled = tree.isEnabled() && ((LegacyCheckBoxTree)tree).isCheckBoxEnabled() && ((LegacyCheckBoxTree)tree).isCheckBoxEnabled(path);
            if (!enabled && !selected && this.getBackground() != null) {
                this.setForeground(this.getBackground().darker());
            }
            this._checkBox.setEnabled(enabled);
            this.updateCheckBoxState(this._checkBox, path, selectionModel);
        }
        if (this._actualTreeRenderer != null) {
            JComponent treeCellRendererComponent = (JComponent)this._actualTreeRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            Border border = treeCellRendererComponent.getBorder();
            this.setBorder(border);
            treeCellRendererComponent.setBorder(BorderFactory.createEmptyBorder());
            if (path == null || !(tree instanceof LegacyCheckBoxTree) || ((LegacyCheckBoxTree)tree).isCheckBoxVisible(path)) {
                this.remove(this._emptyBox);
                this.add((Component)this._checkBox, "Before");
            } else {
                this.remove(this._checkBox);
                this.add((Component)this._emptyBox, "After");
            }
            this.add(treeCellRendererComponent);
        }
        return this;
    }

    protected void updateCheckBoxState(LegacyTristateCheckBox checkBox, TreePath path, LegacyCheckBoxTreeSelectionModel selectionModel) {
        if (selectionModel.isPathSelected(path, selectionModel.isDigIn())) {
            checkBox.setState(LegacyTristateCheckBox.SELECTED);
        } else {
            checkBox.setState((LegacyTristateCheckBox.State)(selectionModel.isDigIn() && selectionModel.isPartiallySelected(path) ? null : LegacyTristateCheckBox.NOT_SELECTED));
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this._actualTreeRenderer instanceof JComponent) {
            Point p = event.getPoint();
            p.translate(-this._checkBox.getWidth(), 0);
            MouseEvent newEvent = new MouseEvent((JComponent)((Object)this._actualTreeRenderer), event.getID(), event.getWhen(), event.getModifiers(), p.x, p.y, event.getClickCount(), event.isPopupTrigger());
            String tip = ((JComponent)((Object)this._actualTreeRenderer)).getToolTipText(newEvent);
            if (tip != null) {
                return tip;
            }
        }
        return super.getToolTipText(event);
    }
}

