/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.List;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.partialimport.AbstractPartialImport;
import org.keycloak.partialimport.ResourceType;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.PartialImportRepresentation;

public class GroupsPartialImport
extends AbstractPartialImport<GroupRepresentation> {
    @Override
    public List<GroupRepresentation> getRepList(PartialImportRepresentation partialImportRep) {
        return partialImportRep.getGroups();
    }

    @Override
    public String getName(GroupRepresentation group) {
        return group.getName();
    }

    private GroupModel findGroupModel(KeycloakSession session, RealmModel realm, GroupRepresentation groupRep) {
        return KeycloakModelUtils.findGroupByPath((KeycloakSession)session, (RealmModel)realm, (String)groupRep.getPath());
    }

    @Override
    public String getModelId(RealmModel realm, KeycloakSession session, GroupRepresentation groupRep) {
        return this.findGroupModel(session, realm, groupRep).getId();
    }

    @Override
    public boolean exists(RealmModel realm, KeycloakSession session, GroupRepresentation groupRep) {
        return this.findGroupModel(session, realm, groupRep) != null;
    }

    @Override
    public String existsMessage(RealmModel realm, GroupRepresentation groupRep) {
        return "Group '" + groupRep.getPath() + "' already exists";
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GROUP;
    }

    @Override
    public void remove(RealmModel realm, KeycloakSession session, GroupRepresentation groupRep) {
        GroupModel group = realm.getGroupById(this.getModelId(realm, session, groupRep));
        realm.removeGroup(group);
    }

    @Override
    public void create(RealmModel realm, KeycloakSession session, GroupRepresentation groupRep) {
        RepresentationToModel.importGroup((RealmModel)realm, null, (GroupRepresentation)groupRep);
    }
}

