/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.openstreetmap.josm.gui.NavigatableComponent;

@FunctionalInterface
public interface NativeScaleLayer {
    public ScaleList getNativeScales();

    public static class ScaleList {
        private final List<Scale> scales = new ArrayList<Scale>();

        protected ScaleList() {
        }

        public ScaleList(Collection<Double> scales) {
            int i = 0;
            for (Double scale : scales) {
                this.scales.add(new Scale(scale, i++));
            }
        }

        protected void addScale(Scale scale) {
            this.scales.add(scale);
        }

        public ScaleList withIntermediateSteps(double ratio) {
            ScaleList result = new ScaleList();
            Scale previous = null;
            for (Scale current : this.scales) {
                double step;
                double factor;
                int steps;
                if (previous != null && (steps = (int)Math.round(factor = Math.log(step = previous.scale / current.scale) / Math.log(ratio))) != 0) {
                    double smallStep = Math.pow(step, 1.0 / (double)steps);
                    for (int j = 1; j < steps; ++j) {
                        double intermediate = previous.scale / Math.pow(smallStep, j);
                        result.addScale(new Scale(intermediate, false, current.index));
                    }
                }
                result.addScale(current);
                previous = current;
            }
            return result;
        }

        public Scale getSnapScale(double scale, boolean floor) {
            return this.getSnapScale(scale, NavigatableComponent.PROP_ZOOM_RATIO.get(), floor);
        }

        public Scale getSnapScale(double scale, double ratio, boolean floor) {
            if (this.scales.isEmpty()) {
                return null;
            }
            int size = this.scales.size();
            Scale first = this.scales.get(0);
            Scale last = this.scales.get(size - 1);
            if (scale > first.scale) {
                double step = scale / first.scale;
                double factor = Math.log(step) / Math.log(ratio);
                int steps = (int)(floor ? Math.floor(factor) : (double)Math.round(factor));
                if (steps == 0) {
                    return new Scale(first.scale, first.isNative, steps);
                }
                return new Scale(first.scale * Math.pow(ratio, steps), false, steps);
            }
            if (scale < last.scale) {
                double step = last.scale / scale;
                double factor = Math.log(step) / Math.log(ratio);
                int steps = (int)(floor ? Math.floor(factor) : (double)Math.round(factor));
                if (steps == 0) {
                    return new Scale(last.scale, last.isNative, size - 1 + steps);
                }
                return new Scale(last.scale / Math.pow(ratio, steps), false, size - 1 + steps);
            }
            Scale previous = null;
            for (int i = 0; i < size; ++i) {
                Scale current = this.scales.get(i);
                if (previous != null && scale <= previous.scale && scale >= current.scale) {
                    if (floor || previous.scale / scale < scale / current.scale) {
                        return new Scale(previous.scale, previous.isNative, i - 1);
                    }
                    return new Scale(current.scale, current.isNative, i);
                }
                previous = current;
            }
            return null;
        }

        public Scale scaleZoomTimes(double scale, double ratio, int times) {
            Scale next = this.getSnapScale(scale, ratio, false);
            int abs = Math.abs(times);
            for (int i = 0; i < abs; ++i) {
                next = times < 0 ? this.getNextIn(next, ratio) : this.getNextOut(next, ratio);
            }
            return next;
        }

        public Scale scaleZoomIn(double scale, double ratio) {
            Scale snap = this.getSnapScale(scale, ratio, false);
            return this.getNextIn(snap, ratio);
        }

        public Scale scaleZoomOut(double scale, double ratio) {
            Scale snap = this.getSnapScale(scale, ratio, false);
            return this.getNextOut(snap, ratio);
        }

        public String toString() {
            return this.scales.stream().map(Scale::toString).collect(Collectors.joining("\n"));
        }

        private Scale getNextIn(Scale scale, double ratio) {
            if (scale == null) {
                return null;
            }
            int nextIndex = scale.getIndex() + 1;
            if (nextIndex <= 0 || nextIndex > this.scales.size() - 1) {
                return new Scale(scale.scale / ratio, nextIndex == 0, nextIndex);
            }
            Scale nextScale = this.scales.get(nextIndex);
            return new Scale(nextScale.scale, nextScale.isNative, nextIndex);
        }

        private Scale getNextOut(Scale scale, double ratio) {
            if (scale == null) {
                return null;
            }
            int nextIndex = scale.getIndex() - 1;
            if (nextIndex < 0 || nextIndex >= this.scales.size() - 1) {
                return new Scale(scale.scale * ratio, nextIndex == this.scales.size() - 1, nextIndex);
            }
            Scale nextScale = this.scales.get(nextIndex);
            return new Scale(nextScale.scale, nextScale.isNative, nextIndex);
        }
    }

    public static class Scale {
        private final double scale;
        private final boolean isNative;
        private final int index;

        public Scale(double scale, int index) {
            this.scale = scale;
            this.isNative = true;
            this.index = index;
        }

        public Scale(double scale, boolean isNative, int index) {
            this.scale = scale;
            this.isNative = isNative;
            this.index = index;
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "%f [%s]", this.scale, this.isNative);
        }

        public int getIndex() {
            return this.index;
        }

        public double getScale() {
            return this.scale;
        }
    }
}

