/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Apply the Fast Marching method to solve an Eikonal equation on an
image.


The speed function can be specified as a speed image or a speed
constant. The speed image is set using the method SetInput(). If the
speed image is nullptr, a constant speed function is used and is
specified using method the SetSpeedConstant() .

If the speed function is constant and of value one, fast marching
results is an approximate distance function from the initial alive
points.

There are two ways to specify the output image information
(LargestPossibleRegion, Spacing, Origin):


it is copied directly from the input speed image

it is specified by the user. Default values are used if the user does
not specify all the information.
 The output information is computed as follows.

If the speed image is nullptr or if the OverrideOutputInformation is
set to true, the output information is set from user specified
parameters. These parameters can be specified using methods


FastMarchingImageFilterBase::SetOutputRegion() ,

FastMarchingImageFilterBase::SetOutputSpacing() ,

FastMarchingImageFilterBase::SetOutputDirection() ,

FastMarchingImageFilterBase::SetOutputOrigin() .
 Else the output information is copied from the input speed image.

Implementation of this class is based on Chapter 8 of "Level Set
Methods and Fast Marching Methods", J.A. Sethian, Cambridge Press,
Second edition, 1999.

For an alternative implementation, see itk::FastMarchingImageFilter .

TTraits

traits


See:
 FastMarchingImageFilter

 ImageFastMarchingTraits

 ImageFastMarchingTraits2

 itk::simple::FastMarchingBase for the procedural interface

 itk::FastMarchingImageFilterBase for the Doxygen on the original ITK class.


C++ includes: sitkFastMarchingBaseImageFilter.h
*/
public class FastMarchingBaseImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FastMarchingBaseImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FastMarchingBaseImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FastMarchingBaseImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FastMarchingBaseImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FastMarchingBaseImageFilter::~FastMarchingBaseImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FastMarchingBaseImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FastMarchingBaseImageFilter::FastMarchingBaseImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FastMarchingBaseImageFilter() {
    this(SimpleITKJNI.new_FastMarchingBaseImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::SetTrialPoints(std::vector&lt; std::vector&lt; unsigned int &gt; &gt; TrialPoints)

Set the container of Trial Points representing the initial front.
Trial points are represented as a VectorContainer of LevelSetNodes.

*/
public  void setTrialPoints(VectorUIntList TrialPoints) {
    SimpleITKJNI.FastMarchingBaseImageFilter_setTrialPoints(swigCPtr, this, VectorUIntList.getCPtr(TrialPoints), TrialPoints);
  }

  /**
std::vector&lt; std::vector&lt; unsigned int &gt; &gt; itk::simple::FastMarchingBaseImageFilter::GetTrialPoints() const

Get the container of Trial Points representing the initial front.

*/
public  VectorUIntList getTrialPoints() {
    return new VectorUIntList(SimpleITKJNI.FastMarchingBaseImageFilter_getTrialPoints(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::AddTrialPoint(std::vector&lt; unsigned int &gt; point)

Add TrialPoints point.

*/
public  void addTrialPoint(VectorUInt32 point) {
    SimpleITKJNI.FastMarchingBaseImageFilter_addTrialPoint(swigCPtr, this, VectorUInt32.getCPtr(point), point);
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::ClearTrialPoints()

Remove all TrialPoints points.

*/
public  void clearTrialPoints() {
    SimpleITKJNI.FastMarchingBaseImageFilter_clearTrialPoints(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::SetNormalizationFactor(double NormalizationFactor)

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public  void setNormalizationFactor(double NormalizationFactor) {
    SimpleITKJNI.FastMarchingBaseImageFilter_setNormalizationFactor(swigCPtr, this, NormalizationFactor);
  }

  /**
double itk::simple::FastMarchingBaseImageFilter::GetNormalizationFactor() const

Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer
pixel types to represent the speed.

*/
public  double getNormalizationFactor() {
    return SimpleITKJNI.FastMarchingBaseImageFilter_getNormalizationFactor(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::SetStoppingValue(double StoppingValue)

Set the Fast Marching algorithm Stopping Value. The Fast Marching
algorithm is terminated when the value of the smallest trial point is
greater than the stopping value.

*/
public  void setStoppingValue(double StoppingValue) {
    SimpleITKJNI.FastMarchingBaseImageFilter_setStoppingValue(swigCPtr, this, StoppingValue);
  }

  /**
double itk::simple::FastMarchingBaseImageFilter::GetStoppingValue() const

Get the Fast Marching algorithm Stopping Value.

*/
public  double getStoppingValue() {
    return SimpleITKJNI.FastMarchingBaseImageFilter_getStoppingValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::SetTopologyCheck(TopologyCheckType TopologyCheck)
*/
public  void setTopologyCheck(FastMarchingBaseImageFilter.TopologyCheckType TopologyCheck) {
    SimpleITKJNI.FastMarchingBaseImageFilter_setTopologyCheck(swigCPtr, this, TopologyCheck.swigValue());
  }

  /**
TopologyCheckType itk::simple::FastMarchingBaseImageFilter::GetTopologyCheck() const
*/
public  FastMarchingBaseImageFilter.TopologyCheckType getTopologyCheck() {
    return FastMarchingBaseImageFilter.TopologyCheckType.swigToEnum(SimpleITKJNI.FastMarchingBaseImageFilter_getTopologyCheck(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::FastMarchingBaseImageFilter::SetInitialTrialValues(std::vector&lt; double &gt; InitialTrialValues)

Set the initial seed values for corresponding trial point.

*/
public  void setInitialTrialValues(VectorDouble InitialTrialValues) {
    SimpleITKJNI.FastMarchingBaseImageFilter_setInitialTrialValues(swigCPtr, this, VectorDouble.getCPtr(InitialTrialValues), InitialTrialValues);
  }

  /**
std::vector&lt;double&gt; itk::simple::FastMarchingBaseImageFilter::GetInitialTrialValues() const
*/
public  VectorDouble getInitialTrialValues() {
    return new VectorDouble(SimpleITKJNI.FastMarchingBaseImageFilter_getInitialTrialValues(swigCPtr, this), true);
  }

  /**
std::string itk::simple::FastMarchingBaseImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FastMarchingBaseImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FastMarchingBaseImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FastMarchingBaseImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FastMarchingBaseImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.FastMarchingBaseImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  public final static class TopologyCheckType {
    public final static FastMarchingBaseImageFilter.TopologyCheckType Nothing = new FastMarchingBaseImageFilter.TopologyCheckType("Nothing");
    public final static FastMarchingBaseImageFilter.TopologyCheckType NoHandles = new FastMarchingBaseImageFilter.TopologyCheckType("NoHandles");
    public final static FastMarchingBaseImageFilter.TopologyCheckType Strict = new FastMarchingBaseImageFilter.TopologyCheckType("Strict");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static TopologyCheckType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + TopologyCheckType.class + " with value " + swigValue);
    }

    private TopologyCheckType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private TopologyCheckType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private TopologyCheckType(String swigName, TopologyCheckType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static TopologyCheckType[] swigValues = { Nothing, NoHandles, Strict };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
