/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.common.TreeDisambiguator;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodePattern;
import ai.grazie.rules.tree.Tree;
import ai.grazie.rules.util.CharUtil;
import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexMatcher;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

class EnglishTreeDisambiguator
extends TreeDisambiguator {
    private static final NodePattern possiblyInfinitive = NodePattern.N.withHeadRelation("nmod|obl").directlyAfter(NodePattern.N.form("to"));
    private static final NodePattern withoutAuxBe = NodePattern.N.noDependents("aux", NodePattern.N.lemma("be"));
    private static final NodePattern isPredicate = NodePattern.N.withDependent("nsubj(:pass)?|i?obj");
    private static final NodePattern isCopPredicate = CommonPatterns.possiblyConj(NodePattern.N.withDependent("cop"));
    private static final NodePattern hasNounPos = NodePattern.N.pos("NN.*");
    private static final NodePattern isAn = NodePattern.N.form("an?");
    private static final NodePattern classesWithoutClassLemma = NodePattern.N.form("classes").withHeadRelation("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").noLemma("class");
    private static final RegexMatcher nominalHead = Regex.parse("nsubj(:pass|:outer)?|i?obj|obl(:npmod|:tmod)?|nmod|compound").caseSensitiveMatcher();
    private static final NodePattern canBeNoun = NodePattern.or(NodePattern.N.withDependent("det|nmod(:poss)?|amod|case"), NodePattern.N.withDependent("advmod", NodePattern.N.pos("JJ")));
    private static final NodePattern vbg = NodePattern.N.pos("VBG");

    EnglishTreeDisambiguator(Tree tree) {
        super(tree);
    }

    @Override
    public Tree disambiguateByTree() {
        Node head;
        String verbalPos = "VB[NPZD]?";
        for (Node dep : this.currentNodes()) {
            head = dep.head();
            String form = dep.form();
            if ((form.length() >= 2 && CharUtil.isAnyOf("'\u2019`\u2018", form.charAt(0)) || form.length() == 3 && CharUtil.isAnyOf("'\u2019`\u2018", form.charAt(1))) && dep.posReadings().stream().allMatch(pos -> "POS".equals(pos) && head == null)) {
                this.tree = this.tree.withReadings(dep, EnglishTreeDisambiguator.expandContraction(dep));
            }
            if (head == null) continue;
            String relation = dep.headRelation();
            if (relation.equals("compound") || relation.startsWith("nmod")) {
                if (!possiblyInfinitive.matches(dep)) {
                    this.removeIfPossible(dep, (String)(relation.equals("compound") ? verbalPos + "|JJ.+" : (relation.equals("nmod:poss") ? verbalPos + "|NN.*" : verbalPos)));
                }
                if (withoutAuxBe.matches(head)) {
                    this.removeIfPossible(head, verbalPos + "|VBG" + ("compound".equals(relation) ? "|JJ.*" : ""));
                    continue;
                }
                this.removeIfPossible(head, verbalPos + ("compound".equals(relation) ? "|JJ.*" : ""));
                continue;
            }
            if (nominalHead.matches(relation)) {
                if (possiblyInfinitive.matches(dep)) continue;
                this.removeIfPossible(dep, verbalPos + "|RB.*" + (hasNounPos.matches(dep) ? "|JJR" : ""));
                continue;
            }
            if (relation.equals("amod")) {
                this.removeIfPossible(dep, "NN.*|VB[PZDG]?|RB");
                if (vbg.matches(head)) {
                    this.removeIfPossible(head, "JJ.*");
                    continue;
                }
                if (!hasNounPos.matches(head)) continue;
                this.removeIfPossible(head, "VB.*");
                continue;
            }
            if (relation.equals("nummod")) {
                this.removeIfPossible(head, "VB.*");
                continue;
            }
            if (relation.equals("advmod")) {
                this.removeIfPossible(dep, "NN.*|JJ.*|VB.*|RP");
                continue;
            }
            if (relation.startsWith("aux")) {
                this.removeIfPossible(dep, "NN.*");
                continue;
            }
            if (relation.equals("compound:prt")) {
                this.removeIfPossible(dep, "NN.*|VB.*|JJ");
                continue;
            }
            if (relation.equals("acl")) {
                this.removeIfPossible(dep, "NN.*");
                continue;
            }
            if (relation.equals("case")) {
                this.removeIfPossible(dep, "NN.*|VB.*|JJ|RB|CC");
                if (!hasNounPos.matches(head)) continue;
                this.removeIfPossible(head, "JJ");
                continue;
            }
            if (relation.equals("mark")) {
                this.removeIfPossible(dep, "NN.*|VB.*|JJ|RB");
                continue;
            }
            if (relation.equals("cc")) {
                this.removeIfPossible(dep, "NN");
                continue;
            }
            if (relation.equals("cop")) {
                this.removeIfPossible(head, "VB[PZD]?|MD" + (canBeNoun.matches(head) ? "" : "|NN.*"));
                this.removeIfPossible(dep, "NN.*");
                continue;
            }
            if (relation.equals("det")) {
                this.removeIfPossible(head, (String)("one".equals(head.lowForm()) ? "CD" : (isAn.matches(dep) ? verbalPos + "|JJ.*" : verbalPos)));
                continue;
            }
            if (!relation.equals("xcomp")) continue;
            if (head.lemmaReadings().contains("make")) {
                dep = this.removeIfPossible(dep, "VBG");
            }
            if (EnglishTreePatterns.withToMark.matches(dep)) {
                this.removeIfPossible(dep, "NN.*");
            }
            if (!head.lowForm().endsWith("ing")) continue;
            this.removeIfPossible(head, "JJ");
        }
        for (Node node : this.currentNodes()) {
            if (!isPredicate.matches(node) || isCopPredicate.matches(node)) continue;
            this.removeIfPossible(node, "NN.*|JJ.*");
        }
        for (Node dep : this.currentNodes()) {
            head = dep.head();
            if (head == null) continue;
            if ("conj".equals(dep.headRelation())) {
                List<Tree.Reading> depNominal = EnglishTreeDisambiguator.filterReadings(dep, "NN.*");
                List<Tree.Reading> headNominal = EnglishTreeDisambiguator.filterReadings(head, "NN.*");
                List<Tree.Reading> depVerbal = EnglishTreeDisambiguator.filterReadings(dep, verbalPos);
                List<Tree.Reading> headVerbal = EnglishTreeDisambiguator.filterReadings(head, verbalPos);
                if (!depNominal.isEmpty() && depVerbal.isEmpty() && !isPredicate.matches(dep)) {
                    this.removeIfPossible(head, headVerbal);
                }
                if (depNominal.isEmpty() && !depVerbal.isEmpty() && head.nextUntil(dep).noneMatch(n -> n.hasForm(":"))) {
                    this.removeIfPossible(head, headNominal);
                }
                if (headNominal.isEmpty() && !headVerbal.isEmpty() && !isCopPredicate.matches(head)) {
                    this.removeIfPossible(dep, depNominal);
                }
                if (!headNominal.isEmpty() && headVerbal.isEmpty() && !isPredicate.matches(head)) {
                    this.removeIfPossible(dep, depVerbal);
                }
            }
            if (!classesWithoutClassLemma.matches(dep)) continue;
            this.tree = this.tree.withReadings(dep, List.of(new Tree.Reading("NNS", "class")));
        }
        return this.tree;
    }

    private static List<Tree.Reading> expandContraction(Node contracted) {
        String token = contracted.form();
        if (EnglishTreeDisambiguator.startsWithApostrophe(token, "m") || EnglishTreeDisambiguator.startsWithApostrophe(token, "re")) {
            return Collections.singletonList(new Tree.Reading("VBP", "be"));
        }
        if (EnglishTreeDisambiguator.startsWithApostrophe(token, "ve")) {
            return Collections.singletonList(new Tree.Reading("VB", "have"));
        }
        if (EnglishTreeDisambiguator.startsWithApostrophe(token, "ll")) {
            return Collections.singletonList(new Tree.Reading("MD", "will"));
        }
        if (EnglishTreeDisambiguator.startsWithApostrophe(token, "d")) {
            return Arrays.asList(new Tree.Reading("VBD", "have"), new Tree.Reading("MD", "will"));
        }
        if (EnglishTreeDisambiguator.startsWithApostrophe(token, "s")) {
            return Arrays.asList(new Tree.Reading("VBZ", "be"), new Tree.Reading("VBZ", "have"), new Tree.Reading("PRP", "we"));
        }
        if (EnglishTreePatterns.contractedNot.matches(contracted)) {
            return Collections.singletonList(new Tree.Reading("RB", "not"));
        }
        return Collections.emptyList();
    }

    private static boolean startsWithApostrophe(String token, String afterApostrophe) {
        return !token.isEmpty() && CharUtil.isAnyOf("'\u2019`\u2018", token.charAt(0)) && afterApostrophe.equals(token.substring(1));
    }
}

