/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import org.apache.maven.model.Activation;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelProblemCollector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.aether.NioTrackingFileManager;

final class RepositorySystemHolder {
    private static final RepositorySystem ourSystem = RepositorySystemHolder.getRepositorySystem();

    RepositorySystemHolder() {
    }

    @NotNull
    public static RepositorySystem getInstance() {
        RepositorySystem repositorySystem = ourSystem;
        if (repositorySystem == null) {
            RepositorySystemHolder.$$$reportNull$$$0(0);
        }
        return repositorySystem;
    }

    @NotNull
    private static RepositorySystem getRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.setServices(TrackingFileManager.class, (Object[])new TrackingFileManager[]{new NioTrackingFileManager()});
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setServices(ModelBuilder.class, (Object[])new ModelBuilder[]{new DefaultModelBuilderFactory(){

            public ProfileActivator[] newProfileActivators() {
                return new ProfileActivator[]{new ProfileActivatorProxy(super.newProfileActivators())};
            }
        }.newInstance()});
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                if (exception != null) {
                    throw new RuntimeException(exception);
                }
            }
        });
        RepositorySystem repositorySystem = (RepositorySystem)locator.getService(RepositorySystem.class);
        if (repositorySystem == null) {
            RepositorySystemHolder.$$$reportNull$$$0(1);
        }
        return repositorySystem;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/aether/RepositorySystemHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositorySystem";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class ProfileActivatorProxy
    implements ProfileActivator {
        private final ProfileActivator[] myDelegates;

        ProfileActivatorProxy(ProfileActivator[] delegates) {
            this.myDelegates = delegates;
        }

        private static boolean isForceActivation(Profile profile) {
            Activation activation = profile.getActivation();
            return activation != null && activation.getJdk() != null;
        }

        public boolean isActive(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
            if (ProfileActivatorProxy.isForceActivation(profile)) {
                return true;
            }
            Boolean active = null;
            for (ProfileActivator delegate : this.myDelegates) {
                if (!delegate.presentInConfig(profile, context, problems)) continue;
                boolean activeValue = delegate.isActive(profile, context, problems);
                active = active == null ? activeValue : active != false && activeValue;
            }
            return Boolean.TRUE.equals(active);
        }

        public boolean presentInConfig(Profile profile, ProfileActivationContext context, ModelProblemCollector problems) {
            if (ProfileActivatorProxy.isForceActivation(profile)) {
                return true;
            }
            for (ProfileActivator delegate : this.myDelegates) {
                if (!delegate.presentInConfig(profile, context, problems)) continue;
                return true;
            }
            return false;
        }
    }
}

