/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.indices.MavenIndexException;
import org.jetbrains.idea.maven.indices.MavenIndexImpl;
import org.jetbrains.idea.maven.indices.MavenRepositoryProvider;
import org.jetbrains.idea.maven.model.MavenRemoteRepository;
import org.jetbrains.idea.maven.model.MavenRepositoryInfo;
import org.jetbrains.idea.maven.model.RepositoryKind;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;

public final class MavenIndexUtils {
    private static final String CURRENT_VERSION = "5";
    private static final String INDEX_INFO_FILE = "index.properties";
    private static final String INDEX_VERSION_KEY = "version";
    private static final String KIND_KEY = "kind";
    private static final String ID_KEY = "id";
    private static final String PATH_OR_URL_KEY = "pathOrUrl";
    private static final String TIMESTAMP_KEY = "lastUpdate";
    private static final String DATA_DIR_NAME_KEY = "dataDirName";
    private static final String FAILURE_MESSAGE_KEY = "failureMessage";

    private MavenIndexUtils() {
    }

    @Nullable
    public static IndexPropertyHolder readIndexProperty(Path dir) throws MavenIndexException {
        Properties props = new Properties();
        try (InputStream s = Files.newInputStream(dir.resolve(INDEX_INFO_FILE), new OpenOption[0]);){
            props.load(s);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            throw new MavenIndexException("Cannot read index.properties file", e);
        }
        if (!CURRENT_VERSION.equals(props.getProperty(INDEX_VERSION_KEY))) {
            throw new MavenIndexException("Incompatible index version, needs to be updated: " + String.valueOf(dir));
        }
        RepositoryKind kind = RepositoryKind.valueOf((String)props.getProperty(KIND_KEY));
        Set<String> repositoryIds = Collections.emptySet();
        String myRepositoryIdsStr = props.getProperty(ID_KEY);
        if (myRepositoryIdsStr != null) {
            repositoryIds = Set.copyOf(StringUtil.split((String)myRepositoryIdsStr, (String)","));
        }
        String repositoryPathOrUrl = MavenIndexUtils.normalizePathOrUrl(props.getProperty(PATH_OR_URL_KEY));
        if (kind != RepositoryKind.LOCAL) {
            repositoryPathOrUrl = repositoryPathOrUrl.toLowerCase(Locale.ROOT);
        }
        long updateTimestamp = -1L;
        try {
            String timestamp = props.getProperty(TIMESTAMP_KEY);
            if (timestamp != null) {
                updateTimestamp = Long.parseLong(timestamp);
            }
        }
        catch (Exception timestamp) {
            // empty catch block
        }
        String dataDirName = props.getProperty(DATA_DIR_NAME_KEY);
        String failureMessage = props.getProperty(FAILURE_MESSAGE_KEY);
        return new IndexPropertyHolder(dir, kind, repositoryIds, repositoryPathOrUrl, updateTimestamp, dataDirName, failureMessage);
    }

    public static void saveIndexProperty(MavenIndexImpl index) {
        Properties props = new Properties();
        props.setProperty(KIND_KEY, index.getRepository().getKind().toString());
        props.setProperty(ID_KEY, index.getRepositoryId());
        props.setProperty(PATH_OR_URL_KEY, index.getRepositoryPathOrUrl());
        props.setProperty(INDEX_VERSION_KEY, CURRENT_VERSION);
        props.setProperty(TIMESTAMP_KEY, String.valueOf(index.getUpdateTimestamp()));
        if (index.getDataDirName() != null) {
            props.setProperty(DATA_DIR_NAME_KEY, index.getDataDirName());
        }
        if (index.getFailureMessage() != null) {
            props.setProperty(FAILURE_MESSAGE_KEY, index.getFailureMessage());
        }
        try (OutputStream s = Files.newOutputStream(index.getDir().resolve(INDEX_INFO_FILE), new OpenOption[0]);){
            props.store(s, null);
        }
        catch (IOException e) {
            MavenLog.LOG.warn((Throwable)e);
        }
    }

    @Nullable
    public static MavenRepositoryInfo getLocalRepository(Project project) {
        if (project.isDisposed()) {
            return null;
        }
        Path repository = MavenProjectsManager.getInstance(project).getRepositoryPath();
        return repository == null ? null : new MavenRepositoryInfo("local", "local", repository.toString(), RepositoryKind.LOCAL);
    }

    @NotNull
    public static List<MavenRemoteRepository> getRemoteRepositoriesNoResolve(Project project) {
        if (project.isDisposed()) {
            List<MavenRemoteRepository> list = Collections.emptyList();
            if (list == null) {
                MavenIndexUtils.$$$reportNull$$$0(0);
            }
            return list;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
        Set<MavenRemoteRepository> repositories = projectsManager.getRemoteRepositories();
        HashSet<MavenRemoteRepository> remoteRepositories = new HashSet<MavenRemoteRepository>(repositories);
        for (MavenRepositoryProvider repositoryProvider : MavenRepositoryProvider.EP_NAME.getExtensionList()) {
            remoteRepositories.addAll(repositoryProvider.getRemoteRepositories(project));
        }
        List<MavenRemoteRepository> list = remoteRepositories.stream().toList();
        if (list == null) {
            MavenIndexUtils.$$$reportNull$$$0(1);
        }
        return list;
    }

    @VisibleForTesting
    static Map<String, Set<String>> groupRemoteRepositoriesByUrl(Collection<MavenRemoteRepository> remoteRepositories) {
        return remoteRepositories.stream().map(r -> new MavenRepositoryInfo(r.getId(), MavenIndexUtils.normalizePathOrUrl(r.getUrl().toLowerCase(Locale.ROOT)), RepositoryKind.REMOTE)).collect(Collectors.groupingBy(r -> r.getUrl(), Collectors.mapping(r -> r.getId(), Collectors.toSet())));
    }

    @NotNull
    public static String normalizePathOrUrl(@NotNull String pathOrUrl) {
        if (pathOrUrl == null) {
            MavenIndexUtils.$$$reportNull$$$0(2);
        }
        pathOrUrl = pathOrUrl.trim();
        pathOrUrl = FileUtil.toSystemIndependentName((String)pathOrUrl);
        while (pathOrUrl.endsWith("/")) {
            pathOrUrl = pathOrUrl.substring(0, pathOrUrl.length() - 1);
        }
        String string = pathOrUrl;
        if (string == null) {
            MavenIndexUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    static List<MavenRepositoryInfo> getAllRepositories(Project project) {
        ArrayList<MavenRepositoryInfo> all = new ArrayList<MavenRepositoryInfo>();
        MavenRepositoryInfo local = MavenIndexUtils.getLocalRepository(project);
        if (local != null) {
            all.add(local);
        }
        all.addAll(ContainerUtil.map(MavenIndexUtils.getRemoteRepositoriesNoResolve(project), rr -> new MavenRepositoryInfo(rr.getId(), rr.getName(), rr.getUrl(), RepositoryKind.REMOTE)));
        return all;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/indices/MavenIndexUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = PATH_OR_URL_KEY;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteRepositoriesNoResolve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/indices/MavenIndexUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizePathOrUrl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizePathOrUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    public static class IndexPropertyHolder {
        final Path dir;
        final RepositoryKind kind;
        final Set<String> repositoryIds;
        final String repositoryPathOrUrl;
        final long updateTimestamp;
        final String dataDirName;
        final String failureMessage;

        IndexPropertyHolder(Path dir, RepositoryKind kind, Set<String> repositoryIds, String url, long timestamp, String dataDirName, String message) {
            this.dir = dir;
            this.kind = kind;
            this.repositoryIds = repositoryIds;
            this.repositoryPathOrUrl = url;
            this.updateTimestamp = timestamp;
            this.dataDirName = dataDirName;
            this.failureMessage = message;
        }

        IndexPropertyHolder(Path dir, RepositoryKind kind, Set<String> repositoryIds, String url) {
            this(dir, kind, repositoryIds, url, -1L, null, null);
        }
    }
}

