/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis.customization.console;

import com.intellij.analysis.customization.console.ClassFinderConsoleColorsPage;
import com.intellij.analysis.customization.console.ClassFinderFilterKt;
import com.intellij.analysis.customization.console.ClassInfoResolver;
import com.intellij.analysis.customization.console.LogFinderHyperlinkHandler;
import com.intellij.analysis.customization.console.OnFlyMultipleFilesHyperlinkInfo;
import com.intellij.analysis.customization.console.ProbableClassName;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ui.NamedColorUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/analysis/customization/console/ClassFinderFilter;", "Lcom/intellij/execution/filters/Filter;", "myProject", "Lcom/intellij/openapi/project/Project;", "myScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)V", "cache", "Lcom/intellij/analysis/customization/console/ClassInfoResolver;", "hyperLinkAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "hardCodedHyperLinkAttributes", "getHyperLink", "Lcom/intellij/execution/filters/HyperlinkInfo;", "probableClassName", "Lcom/intellij/analysis/customization/console/ProbableClassName;", "Companion", "intellij.jvm.analysis.impl"})
public final class ClassFinderFilter
implements Filter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClassInfoResolver cache;
    @NotNull
    private final TextAttributes hyperLinkAttributes;

    public ClassFinderFilter(@NotNull Project myProject, @NotNull GlobalSearchScope myScope) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        Intrinsics.checkNotNullParameter((Object)myScope, (String)"myScope");
        this.myProject = myProject;
        this.cache = new ClassInfoResolver(this.myProject, myScope);
        EditorColorsManager editorColorsManager = EditorColorsManager.getInstance();
        if (editorColorsManager == null || (editorColorsManager = editorColorsManager.getGlobalScheme()) == null || (editorColorsManager = editorColorsManager.getAttributes(ClassFinderConsoleColorsPage.TERMINAL_CLASS_NAME_LOG_REFERENCE)) == null) {
            editorColorsManager = this.hardCodedHyperLinkAttributes();
        }
        this.hyperLinkAttributes = editorColorsManager;
    }

    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        int textStartOffset = entireLength - line.length();
        List expectedClasses = ClassFinderFilter.Companion.findProbableClasses(line);
        List results = new ArrayList();
        TextAttributes attributes = this.hyperLinkAttributes;
        for (ProbableClassName probableClass : expectedClasses) {
            results.add(new Filter.Result(textStartOffset + probableClass.getFrom(), textStartOffset + probableClass.getTo(), this.getHyperLink(probableClass), attributes, attributes));
        }
        if (results.isEmpty()) {
            return null;
        }
        return new Filter.Result(results);
    }

    private final TextAttributes hardCodedHyperLinkAttributes() {
        TextAttributes attributes = new TextAttributes();
        attributes.setEffectType(EffectType.BOLD_DOTTED_LINE);
        attributes.setEffectColor(NamedColorUtil.getInactiveTextColor());
        return attributes;
    }

    private final HyperlinkInfo getHyperLink(ProbableClassName probableClassName) {
        return (HyperlinkInfo)new OnFlyMultipleFilesHyperlinkInfo(this.cache, probableClassName, 0, this.myProject, new LogFinderHyperlinkHandler(probableClassName));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J.\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/analysis/customization/console/ClassFinderFilter$Companion;", "", "<init>", "()V", "findProbableClasses", "", "Lcom/intellij/analysis/customization/console/ProbableClassName;", "line", "", "isJavaIdentifierStart", "", "cp", "", "isJavaIdentifierPart", "addProbableClass", "", "startInclusive", "endExclusive", "result", "", "isHardcodedNotClass", "fullClassName", "isJavaStyle", "shortenedClassName", "canBeShortenedFullyQualifiedClassName", "intellij.jvm.analysis.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final List<ProbableClassName> findProbableClasses(String line) {
            if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((String)line, (String)"Exception in thread \"", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"Caused by: ", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)line, (String)"\tat ", (boolean)false, (int)2, null)) {
                return CollectionsKt.emptyList();
            }
            List result = new ArrayList();
            int start = -1;
            int pointCount = 0;
            int i = 0;
            boolean first = true;
            while (true) {
                if (!first) {
                    int previousPoint;
                    if ((i += Character.charCount(previousPoint = line.codePointAt(i))) >= line.length()) {
                        break;
                    }
                } else {
                    first = false;
                }
                int ch = line.codePointAt(i);
                if (start == -1 && this.isJavaIdentifierStart(ch)) {
                    start = i;
                    continue;
                }
                if (start != -1 && ch == 46) {
                    ++pointCount;
                    continue;
                }
                if (start != -1 && (line.codePointAt(i - 1) == 46 && this.isJavaIdentifierStart(ch) || line.codePointAt(i - 1) != 46 && this.isJavaIdentifierPart(ch))) {
                    int charCount = Character.charCount(ch);
                    if (i + charCount < line.length() || pointCount < 2) continue;
                    this.addProbableClass(line, start, line.length(), result);
                    continue;
                }
                if (pointCount >= 2) {
                    this.addProbableClass(line, start, i, result);
                }
                pointCount = 0;
                start = -1;
            }
            return result;
        }

        private final boolean isJavaIdentifierStart(int cp) {
            return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierStart(cp);
        }

        private final boolean isJavaIdentifierPart(int cp) {
            return cp >= 48 && cp <= 57 || cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierPart(cp);
        }

        private final void addProbableClass(String line, int startInclusive, int endExclusive, List<ProbableClassName> result) {
            int actualEndExclusive = endExclusive;
            if (actualEndExclusive > 0 && line.charAt(actualEndExclusive - 1) == '.') {
                --actualEndExclusive;
            }
            String string = line.substring(startInclusive, actualEndExclusive);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String fullClassName = string;
            if (this.canBeShortenedFullyQualifiedClassName(fullClassName) && this.isJavaStyle(fullClassName) && !this.isHardcodedNotClass(fullClassName)) {
                ProbableClassName probableClassName = new ProbableClassName(startInclusive + StringsKt.lastIndexOf$default((CharSequence)fullClassName, (String)".", (int)0, (boolean)false, (int)6, null) + 1, startInclusive + fullClassName.length(), line, fullClassName);
                result.add(probableClassName);
            }
        }

        private final boolean isHardcodedNotClass(String fullClassName) {
            return ClassFinderFilterKt.access$getHARDCODED_NOT_CLASS$p().contains(fullClassName);
        }

        private final boolean isJavaStyle(String shortenedClassName) {
            if (((CharSequence)shortenedClassName).length() == 0) {
                return false;
            }
            int indexOfSeparator = StringsKt.lastIndexOf$default((CharSequence)shortenedClassName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (indexOfSeparator <= 0 || indexOfSeparator == StringsKt.getLastIndex((CharSequence)shortenedClassName)) {
                return false;
            }
            return !StringsKt.contains$default((CharSequence)shortenedClassName, (CharSequence)"_", (boolean)false, (int)2, null) && Character.isUpperCase(shortenedClassName.charAt(indexOfSeparator + 1)) && Character.isLowerCase(shortenedClassName.charAt(0));
        }

        private final boolean canBeShortenedFullyQualifiedClassName(String fullClassName) {
            int length = 0;
            int n = fullClassName.length();
            for (int i = 0; i < n; ++i) {
                char c = fullClassName.charAt(i);
                if (c == '.') {
                    if (length == 0) {
                        return false;
                    }
                    length = 0;
                    continue;
                }
                ++length;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

