/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Internal
public final class CoverageDataAnnotationsManager
implements Disposable {
    private final Project myProject;
    private final Object myAnnotationsLock = new Object();
    private final ExecutorService myExecutor;
    private final Map<Editor, CoverageEditorAnnotator> myAnnotators = new HashMap<Editor, CoverageEditorAnnotator>();
    private final Map<Editor, Future<?>> myRequests = new ConcurrentHashMap();
    private volatile CompletableFuture<?> myUpdateRequest = null;

    CoverageDataAnnotationsManager(Project project) {
        this.myProject = project;
        this.myExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"CoverageDataAnnotationsManager Pool", (int)1);
    }

    public static CoverageDataAnnotationsManager getInstance(@NotNull Project project) {
        if (project == null) {
            CoverageDataAnnotationsManager.$$$reportNull$$$0(0);
        }
        return (CoverageDataAnnotationsManager)project.getService(CoverageDataAnnotationsManager.class);
    }

    public void dispose() {
        this.clearAnnotations();
    }

    public synchronized void clearAnnotations() {
        Iterator<Map.Entry<Editor, Future<?>>> it = this.myRequests.entrySet().iterator();
        while (it.hasNext()) {
            it.next().getValue().cancel(false);
            it.remove();
        }
        this.myExecutor.execute(() -> {
            Object object = this.myAnnotationsLock;
            synchronized (object) {
                for (CoverageEditorAnnotator annotator : this.myAnnotators.values()) {
                    Disposer.dispose((Disposable)annotator);
                }
                this.myAnnotators.clear();
            }
        });
    }

    public void update() {
        this.myUpdateRequest = CompletableFuture.runAsync(this::updateInternal, this.myExecutor);
    }

    @RequiresBackgroundThread
    public void updateInternal() {
        if (CoverageDataManager.getInstance(this.myProject).activeSuites().isEmpty()) {
            return;
        }
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        List openFiles = fileEditorManager.getOpenFilesWithRemotes();
        for (VirtualFile openFile : openFiles) {
            FileEditor[] allEditors = fileEditorManager.getAllEditors(openFile);
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> openFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(openFile) : null);
            if (psiFile == null || !psiFile.isPhysical()) {
                return;
            }
            for (FileEditor fileEditor : allEditors) {
                if (!(fileEditor instanceof TextEditor)) continue;
                TextEditor textEditor = (TextEditor)fileEditor;
                Editor editor = textEditor.getEditor();
                this.runTask(editor, () -> this.show(editor, psiFile));
            }
        }
    }

    private synchronized void runTask(@NotNull Editor editor, Runnable task) {
        if (editor == null) {
            CoverageDataAnnotationsManager.$$$reportNull$$$0(1);
        }
        Future<?> future = this.myExecutor.submit(() -> {
            this.myRequests.remove(editor);
            task.run();
        });
        this.myRequests.put(editor, future);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CoverageEditorAnnotator getOrCreateAnnotator(Editor editor, PsiFile file, CoverageEngine engine) {
        Object object = this.myAnnotationsLock;
        // MONITORENTER : object
        CoverageEditorAnnotator coverageEditorAnnotator = this.myAnnotators.computeIfAbsent(editor, x -> engine.createSrcFileAnnotator(file, editor));
        // MONITOREXIT : object
        if (coverageEditorAnnotator != null) return coverageEditorAnnotator;
        CoverageDataAnnotationsManager.$$$reportNull$$$0(2);
        return coverageEditorAnnotator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearEditor(Editor editor) {
        CoverageEditorAnnotator annotator;
        Object object = this.myAnnotationsLock;
        synchronized (object) {
            annotator = this.myAnnotators.remove(editor);
        }
        if (annotator != null) {
            Disposer.dispose((Disposable)annotator);
        }
    }

    private void show(Editor editor, PsiFile psiFile) {
        for (CoverageSuitesBundle bundle : CoverageDataManager.getInstance(this.myProject).activeSuites()) {
            CoverageEngine engine = bundle.getCoverageEngine();
            if (!engine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            if (!engine.acceptedByFilters(psiFile, bundle)) {
                return;
            }
            if (engine.isInLibraryClasses(editor.getProject(), psiFile.getVirtualFile())) {
                return;
            }
            CoverageEditorAnnotator annotator = this.getOrCreateAnnotator(editor, psiFile, engine);
            annotator.showCoverage(bundle);
        }
    }

    @TestOnly
    @NotNull
    public Future<?> getAllRequestsCompletion() {
        if (this.myUpdateRequest == null) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {}, this.myExecutor);
            if (completableFuture == null) {
                CoverageDataAnnotationsManager.$$$reportNull$$$0(3);
            }
            return completableFuture;
        }
        CompletionStage completionStage = this.myUpdateRequest.thenRunAsync(() -> {}, this.myExecutor);
        if (completionStage == null) {
            CoverageDataAnnotationsManager.$$$reportNull$$$0(4);
        }
        return completionStage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataAnnotationsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataAnnotationsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateAnnotator";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRequestsCompletion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "runTask";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4 -> new IllegalStateException(string);
        };
    }

    static final class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        CoverageEditorFactoryListener() {
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Project project;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(0);
            }
            if ((project = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            if (CoverageDataManager.getInstance(project).activeSuites().isEmpty()) {
                return;
            }
            CoverageDataAnnotationsManager manager = (CoverageDataAnnotationsManager)project.getServiceIfCreated(CoverageDataAnnotationsManager.class);
            if (manager == null) {
                return;
            }
            PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument()));
            if (psiFile == null || !psiFile.isPhysical()) {
                return;
            }
            manager.runTask(editor, () -> manager.show(editor, psiFile));
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Project project;
            if (event == null) {
                CoverageEditorFactoryListener.$$$reportNull$$$0(1);
            }
            if ((project = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            CoverageDataAnnotationsManager manager = (CoverageDataAnnotationsManager)project.getServiceIfCreated(CoverageDataAnnotationsManager.class);
            if (manager == null) {
                return;
            }
            Future<?> request = manager.myRequests.remove(editor);
            if (request != null) {
                request.cancel(false);
            }
            manager.myExecutor.execute(() -> manager.clearEditor(editor));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/coverage/CoverageDataAnnotationsManager$CoverageEditorFactoryListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

