/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.estimate;

import java.text.NumberFormat;
import java.util.Locale;
import tim.prune.I18nManager;
import tim.prune.data.RangeStatsWithGradients;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.data.UnitSetLibrary;

public class EstimationParameters {
    private final double _flatMins;
    private final double _gentleClimbMins;
    private final double _steepClimbMins;
    private final double _gentleDescentMins;
    private final double _steepDescentMins;
    private static final Unit KILOMETRES = UnitSetLibrary.UNITS_KILOMETRES;
    public static final EstimationParameters DEFAULT_PARAMS = new EstimationParameters(60.0, 12.0, 18.0, 0.0, 12.0);

    private EstimationParameters(double d, double d2, double d3, double d4, double d5) {
        this._flatMins = d;
        this._gentleClimbMins = d2;
        this._steepClimbMins = d3;
        this._gentleDescentMins = d4;
        this._steepDescentMins = d5;
    }

    public static EstimationParameters fromConfigString(String string) {
        if (string == null || string.isBlank()) {
            return null;
        }
        String[] stringArray = string.trim().split(";");
        if (stringArray == null || stringArray.length != 5) {
            return null;
        }
        try {
            NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.UK);
            double d = numberFormat.parse(stringArray[0]).doubleValue();
            double d2 = numberFormat.parse(stringArray[1]).doubleValue();
            double d3 = numberFormat.parse(stringArray[2]).doubleValue();
            double d4 = numberFormat.parse(stringArray[3]).doubleValue();
            double d5 = numberFormat.parse(stringArray[4]).doubleValue();
            return new EstimationParameters(d, d2, d3, d4, d5);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static EstimationParameters fromLocalUnits(UnitSet unitSet, double d, double d2, double d3, double d4, double d5) {
        Unit unit = unitSet.getDistanceUnit();
        Unit unit2 = unitSet.getAltitudeUnit();
        double d6 = unit == KILOMETRES ? 1.0 : 1666.6666666666667 * unit.getMultFactorFromStd();
        double d7 = unit2.isStandard() ? 1.0 : 0.3333333333333333 * unit2.getMultFactorFromStd();
        double d8 = d * d6;
        double d9 = d2 * d7;
        double d10 = d3 * d7;
        double d11 = d4 * d7;
        double d12 = d5 * d7;
        return new EstimationParameters(d8, d9, d10, d11, d12);
    }

    public static EstimationParameters fromMetricUnits(double d, double d2, double d3, double d4, double d5) {
        return new EstimationParameters(d, d2, d3, d4, d5);
    }

    public boolean sameAsDefaults() {
        return this.toConfigString().equals(DEFAULT_PARAMS.toConfigString());
    }

    public double getFlatMinutesLocal(Unit unit) {
        return EstimationParameters.convertDistanceToLocal(this._flatMins, unit);
    }

    private static double convertDistanceToLocal(double d, Unit unit) {
        double d2 = unit == KILOMETRES ? 1.0 : 1666.6666666666667 * unit.getMultFactorFromStd();
        return d / d2;
    }

    public double getGentleClimbMinutesLocal(Unit unit) {
        return EstimationParameters.convertAltitudeToLocal(this._gentleClimbMins, unit);
    }

    public double getSteepClimbMinutesLocal(Unit unit) {
        return EstimationParameters.convertAltitudeToLocal(this._steepClimbMins, unit);
    }

    public double getGentleDescentMinutesLocal(Unit unit) {
        return EstimationParameters.convertAltitudeToLocal(this._gentleDescentMins, unit);
    }

    public double getSteepDescentMinutesLocal(Unit unit) {
        return EstimationParameters.convertAltitudeToLocal(this._steepDescentMins, unit);
    }

    private static double convertAltitudeToLocal(double d, Unit unit) {
        double d2 = unit.isStandard() ? 1.0 : 0.3333333333333333 * unit.getMultFactorFromStd();
        return d / d2;
    }

    public static String getStandardDistance(Unit unit) {
        return String.valueOf(unit == KILOMETRES ? "5 " : "3 ") + I18nManager.getText(unit.getShortnameKey());
    }

    public static String getStandardClimb(Unit unit) {
        return String.valueOf(unit.isStandard() ? "100 " : "300 ") + I18nManager.getText(unit.getShortnameKey());
    }

    public String toConfigString() {
        return EstimationParameters.twoDp(this._flatMins) + ";" + EstimationParameters.twoDp(this._gentleClimbMins) + ";" + EstimationParameters.twoDp(this._steepClimbMins) + ";" + EstimationParameters.twoDp(this._gentleDescentMins) + ";" + EstimationParameters.twoDp(this._steepDescentMins);
    }

    public static String twoDp(double d) {
        if (d < 0.0) {
            return "-" + EstimationParameters.twoDp(-d);
        }
        int n = (int)(d * 100.0 + 0.5);
        return n / 100 + "." + n / 10 % 10 + n % 10;
    }

    public double applyToStats(RangeStatsWithGradients rangeStatsWithGradients) {
        if (rangeStatsWithGradients == null) {
            return 0.0;
        }
        Unit unit = UnitSetLibrary.UNITS_METRES;
        return this._flatMins * rangeStatsWithGradients.getMovingDistanceKilometres() / 5.0 + this._gentleClimbMins * (double)rangeStatsWithGradients.getGentleAltitudeRange().getClimb(unit) / 100.0 + this._steepClimbMins * (double)rangeStatsWithGradients.getSteepAltitudeRange().getClimb(unit) / 100.0 + this._gentleDescentMins * (double)rangeStatsWithGradients.getGentleAltitudeRange().getDescent(unit) / 100.0 + this._steepDescentMins * (double)rangeStatsWithGradients.getSteepAltitudeRange().getDescent(unit) / 100.0;
    }

    public EstimationParameters combine(EstimationParameters estimationParameters, double d) {
        if (d >= 1.0 || estimationParameters == null) {
            return this;
        }
        if (d <= 0.0) {
            return estimationParameters;
        }
        double d2 = 1.0 - d;
        double d3 = d * this._flatMins + d2 * estimationParameters._flatMins;
        double d4 = d * this._gentleClimbMins + d2 * estimationParameters._gentleClimbMins;
        double d5 = d * this._gentleDescentMins + d2 * estimationParameters._gentleDescentMins;
        double d6 = d * this._steepClimbMins + d2 * estimationParameters._steepClimbMins;
        double d7 = d * this._steepDescentMins + d2 * estimationParameters._steepDescentMins;
        return new EstimationParameters(d3, d4, d6, d5, d7);
    }
}

