/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;

public final class VdexConstants {
    public static final String MAGIC = "vdex";
    public static final String vdex_version_003 = "003";
    public static final String VDEX_VERSION_006 = "006";
    public static final String VDEX_VERSION_010 = "010";
    public static final String vdex_version_011 = "011";
    public static final String VDEX_VERSION_019 = "019";
    public static final String VDEX_VERSION_021 = "021";
    public static final String VDEX_VERSION_027 = "027";
    public static final String kDexSectionVersion = "002";
    public static final String kDexSectionVersionEmpty = "000";
    public static final String kVdexNameInDmFile = "primary.vdex";
    public static final String[] SUPPORTED_VERSIONS = new String[]{"006", "010", "019", "021", "027"};

    public static final boolean isSupportedVersion(String version) {
        for (String supportedVersion : SUPPORTED_VERSIONS) {
            if (!supportedVersion.equals(version)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean isVDEX(Program program) {
        if (program == null) return false;
        MemoryBlock[] memoryBlockArray = program.getMemory().getBlocks();
        int n = memoryBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryBlock block = memoryBlockArray[n2];
            try (MemoryByteProvider provider = MemoryByteProvider.createMemoryBlockByteProvider((Memory)program.getMemory(), (MemoryBlock)block);){
                String magic = new String(provider.readBytes(0L, (long)MAGIC.length()));
                if (MAGIC.equals(magic)) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Address findVDEX(Program program) {
        if (program == null) return null;
        MemoryBlock[] memoryBlockArray = program.getMemory().getBlocks();
        int n = memoryBlockArray.length;
        int n2 = 0;
        while (n2 < n) {
            MemoryBlock block = memoryBlockArray[n2];
            try (MemoryByteProvider provider = MemoryByteProvider.createMemoryBlockByteProvider((Memory)program.getMemory(), (MemoryBlock)block);){
                String magic = new String(provider.readBytes(0L, (long)MAGIC.length()));
                if (MAGIC.equals(magic)) {
                    Address address = block.getStart();
                    return address;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        return null;
    }
}

