/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.cmd.function.SetVariableCommentCmd;
import ghidra.app.plugin.core.function.CommentDialog;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.util.HelpLocation;

class VariableCommentDialog
extends CommentDialog {
    private Variable variable;
    private Program program;

    public VariableCommentDialog(FunctionPlugin plugin) {
        super(plugin);
    }

    void showDialog(Program theProgram, Variable theVariable) {
        this.program = theProgram;
        String type = theVariable instanceof Parameter ? "Parameter" : "Local Variable";
        this.setTitle("Set " + type + " Comment: " + theVariable.getName());
        this.setHelpLocation(new HelpLocation(this.plugin.getName(), "Edit_Variable_Comment"));
        this.variable = theVariable;
        this.showDialog(theVariable.getComment());
    }

    @Override
    protected void doApply(String comment) {
        this.plugin.execute(this.program, new SetVariableCommentCmd(this.variable, comment));
    }
}

