/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import ghidra.trace.model.modules.TraceSection;
import java.awt.Component;
import java.util.Set;
import java.util.stream.Collectors;

public class DebuggerSectionActionContext
extends DefaultActionContext {
    private final Set<TraceSection> selectedSections;
    private final boolean forcedSingle;

    public DebuggerSectionActionContext(ComponentProvider provider, Set<TraceSection> selected, Component sourceComponent, boolean forcedSingle) {
        super(provider, selected, sourceComponent);
        this.selectedSections = selected;
        this.forcedSingle = forcedSingle;
    }

    public Set<TraceSection> getSelectedSections(boolean allowExpansion, long snap) {
        if (this.forcedSingle && allowExpansion) {
            return this.selectedSections.stream().flatMap(s -> s.getModule().getSections(snap).stream()).collect(Collectors.toUnmodifiableSet());
        }
        return this.selectedSections;
    }

    public boolean isForcedSingle() {
        return this.forcedSingle;
    }
}

