/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.app.extension.datatype.finder.DecompilerFieldAccess;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.app.extension.datatype.finder.DecompilerVariableType;
import ghidra.app.extension.datatype.finder.DtrfDbg;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferenceContext;
import ghidra.app.services.DataTypeReference;
import ghidra.app.services.FieldMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighVariable;
import ghidra.util.StringUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

public class VariableAccessDR
extends DecompilerReference {
    private List<DecompilerFieldAccess> fields = new ArrayList<DecompilerFieldAccess>();

    protected VariableAccessDR(ClangLine line) {
        super(line, null);
    }

    protected VariableAccessDR(ClangLine line, ClangFieldToken token) {
        super(line, (ClangToken)token);
    }

    void setVariable(ClangVariableToken token, List<DecompilerVariable> casts) {
        if (this.variable != null) {
            throw new AssertException("Decompiler variable is already set for this access");
        }
        this.variable = new DecompilerVariableType(token, casts);
    }

    void addField(ClangFieldToken token, List<DecompilerVariable> fieldCasts) {
        DecompilerFieldAccess field = new DecompilerFieldAccess(token, fieldCasts);
        this.fields.add(field);
    }

    @Override
    public void accumulateMatches(DataType dt, FieldMatcher fieldMatcher, List<DataTypeReference> results) {
        if (this.fields.isEmpty()) {
            DecompilerVariable var = this.getMatch(dt, fieldMatcher, this.variable, null);
            if (var != null) {
                DataTypeReference ref = this.createReference(var);
                results.add(ref);
            }
            return;
        }
        DecompilerVariable start = this.variable;
        for (DecompilerVariable decompilerVariable : this.fields) {
            DecompilerVariable next = decompilerVariable;
            DecompilerVariable var = this.getMatch(dt, fieldMatcher, start, next);
            if (var != null) {
                DataTypeReference ref = this.createReference(var, next);
                results.add(ref);
            }
            start = next;
        }
        if (fieldMatcher.isIgnored()) {
            return;
        }
        DecompilerVariable var = this.getMatch(dt, fieldMatcher, start, null);
        if (var != null) {
            DataTypeReference dataTypeReference = this.createReference(var);
            results.add(dataTypeReference);
        }
    }

    private DecompilerVariable getMatch(DataType dt, FieldMatcher fieldMatcher, DecompilerVariable var, DecompilerVariable potentialField) {
        String indent = "\t\t\t";
        boolean searchForField = !fieldMatcher.isIgnored();
        DecompilerVariable fieldVar = searchForField ? potentialField : null;
        DecompilerVariable match = this.getMatchingVarialbe(dt, var, fieldVar);
        if (match == null) {
            DtrfDbg.println(this.getFunction(), this, indent + "NO MATCHING VARIABLE");
            return null;
        }
        if (fieldMatcher.isIgnored()) {
            DtrfDbg.println(this.getFunction(), this, indent + "field macher is ignored; returning match");
            return match;
        }
        if (potentialField == null) {
            DtrfDbg.println(this.getFunction(), this, indent + "No potential field to match; name / offset match?");
            String name = var.getName();
            int offset = var.getOffset();
            if (fieldMatcher.matches(name, offset)) {
                StringUtilities.indentLines((String)var.toString(), (String)(indent + "\t"));
                DtrfDbg.println(this.getFunction(), this, indent + "\tfield matcher matched on variable: " + String.valueOf(var));
                return var;
            }
            DtrfDbg.println(this.getFunction(), this, indent + "\tNO FIELD MATCHER MATCH");
            return null;
        }
        DtrfDbg.println(this.getFunction(), this, indent + "Checking 'potential field' match...");
        String name = potentialField.getName();
        int offset = potentialField.getOffset();
        if (fieldMatcher.matches(name, offset)) {
            DtrfDbg.println(this.getFunction(), this, indent + "\tMATCHED");
            return match;
        }
        DtrfDbg.println(this.getFunction(), this, indent + "\tNO MATCH");
        return null;
    }

    private DecompilerVariable getMatchingVarialbe(DataType dt, DecompilerVariable var, DecompilerVariable potentialField) {
        String indent = "\t\t\t";
        DtrfDbg.println(this.getFunction(), this, indent + "Checking for matching variable; any casts?");
        List<DecompilerVariable> castVariables = var.getCasts();
        for (DecompilerVariable cast : castVariables) {
            if (!this.matchesType(cast, dt)) continue;
            DtrfDbg.println(this.getFunction(), this, indent + "MATCHED cast: " + String.valueOf(cast));
            return cast;
        }
        String dtString = dt == null ? "null" : dt.toString();
        DtrfDbg.println(this.getFunction(), this, indent + "No matched casts; checking type against var:\n" + StringUtilities.indentLines((String)("type: " + dtString), (String)(indent + "\t")) + "\n" + StringUtilities.indentLines((String)("var: " + var.toString()), (String)(indent + "\t")));
        if (this.matchesType(var, dt)) {
            DtrfDbg.println(this.getFunction(), this, indent + "MATCHED type: ");
            return var;
        }
        DtrfDbg.println(this.getFunction(), this, indent + "Type did not match; checking High Variable: ");
        HighVariable highVariable = var.variable.getHighVariable();
        if (highVariable != null && this.matchesParentType(potentialField, dt)) {
            DtrfDbg.println(this.getFunction(), this, indent + "MATCHED on parent type: " + String.valueOf(dt));
            return potentialField;
        }
        DtrfDbg.println(this.getFunction(), this, indent + "NOT MATCHED");
        return null;
    }

    private boolean matchesParentType(DecompilerVariable var, DataType dt) {
        if (var == null) {
            return false;
        }
        DataType varType = var.getParentDataType();
        boolean matches = VariableAccessDR.isEqual(varType, dt);
        return matches;
    }

    private boolean matchesType(DecompilerVariable var, DataType dt) {
        String indent = "\t\t\t\t";
        if (var == null) {
            DtrfDbg.println(this.getFunction(), this, indent + "Types Match? no variable to check");
            return false;
        }
        DataType varType = var.getDataType();
        if (varType == null) {
            DtrfDbg.println(this.getFunction(), this, indent + "ypes Match? no variable TYPE to check");
            return false;
        }
        boolean matches = VariableAccessDR.isEqual(varType, dt);
        return matches;
    }

    protected DataTypeReference createReference(DecompilerVariable var) {
        DataType dataType = var.getDataType();
        LocationReferenceContext context = this.getContext(var);
        Function function = var.getFunction();
        Address address = this.getAddress(var);
        return new DataTypeReference(dataType, null, function, address, context);
    }

    private DataTypeReference createReference(DecompilerVariable var, DecompilerVariable field) {
        DataType dataType = var.getDataType();
        LocationReferenceContext context = this.getContext(var);
        Function function = var.getFunction();
        Address address = this.getAddress(var);
        return new DataTypeReference(dataType, field.getName(), function, address, context);
    }

    @Override
    protected LocationReferenceContext getContext(DecompilerVariable var) {
        DecompilerVariable field = this.findFieldFor(var);
        LocationReferenceContext context = super.getContext(field);
        return context;
    }

    private DecompilerVariable findFieldFor(DecompilerVariable var) {
        List<DecompilerVariable> allVars = this.getAllVariablesInOrder();
        int varIndex = allVars.indexOf(var);
        if (varIndex == -1) {
            throw new AssertException("Cannot find a field for variable " + String.valueOf(var));
        }
        int fieldIndex = varIndex + 1;
        if (fieldIndex == allVars.size()) {
            fieldIndex = allVars.size() - 1;
        }
        DecompilerVariable field = allVars.get(fieldIndex);
        return field;
    }

    private List<DecompilerVariable> getAllVariablesInOrder() {
        ArrayList<DecompilerVariable> allVars = new ArrayList<DecompilerVariable>();
        this.getAllVariableTypes(this.variable, allVars);
        for (DecompilerVariable decompilerVariable : this.fields) {
            this.getAllVariableTypes(decompilerVariable, allVars);
        }
        return allVars;
    }

    private void getAllVariableTypes(DecompilerVariable var, List<DecompilerVariable> result) {
        List<DecompilerVariable> casts = var.getCasts();
        result.addAll(casts);
        result.add(var);
    }

    @Override
    public String toString() {
        String subFieldsString = this.fields.isEmpty() ? "" : "\tsub fields: " + StringUtilities.toStringWithIndent(this.fields) + ",\n";
        return "{\n\tline " + this.getContext().getPlainText() + ",\n\tfunction: " + String.valueOf(this.getFunction()) + "\n\tvariable: " + StringUtilities.toStringWithIndent((Object)this.variable) + ",\n\tdata type: " + String.valueOf(this.getDataType()) + ",\n" + subFieldsString + "}";
    }
}

