/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin;

import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;

public class ForceVectorUtils {
    public static float distance(Node n1, Node n2) {
        return (float)Math.hypot(n1.x() - n2.x(), n1.y() - n2.y());
    }

    public static void fcBiRepulsor(Node N1, Node N2, double c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist);
        if (dist > 0.0) {
            double f = ForceVectorUtils.repulsion(c, dist);
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    public static void fcBiRepulsor_y(Node N1, Node N2, double c, double verticalization) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist);
        if (dist > 0.0) {
            double f = ForceVectorUtils.repulsion(c, dist);
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + verticalization * yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - verticalization * yDist / dist * f);
        }
    }

    public static void fcBiRepulsor_noCollide(Node N1, Node N2, double c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist) - N1.size() - N2.size();
        if (dist > 0.0) {
            double f = ForceVectorUtils.repulsion(c, dist);
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        } else if (dist != 0.0) {
            double f = -c;
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    public static void fcUniRepulsor(Node N1, Node N2, double c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist);
        if (dist > 0.0) {
            double f = ForceVectorUtils.repulsion(c, dist);
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    public static void fcBiAttractor(Node N1, Node N2, double c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist);
        if (dist > 0.0) {
            double f = ForceVectorUtils.attraction(c, dist);
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    public static void fcBiAttractor_noCollide(Node N1, Node N2, double c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist) - N1.size() - N2.size();
        if (dist > 0.0) {
            double f = ForceVectorUtils.attraction(c, dist);
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    public static void fcBiFlatAttractor(Node N1, Node N2, double c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist);
        if (dist > 0.0) {
            double f = -c;
            ForceVectorNodeLayoutData N1L = (ForceVectorNodeLayoutData)N1.getLayoutData();
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N1L.dx = (float)((double)N1L.dx + xDist / dist * f);
            N1L.dy = (float)((double)N1L.dy + yDist / dist * f);
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    public static void fcUniAttractor(Node N1, Node N2, float c) {
        double yDist;
        double xDist = N1.x() - N2.x();
        double dist = (float)Math.sqrt(xDist * xDist + (yDist = (double)(N1.y() - N2.y())) * yDist);
        if (dist > 0.0) {
            double f = ForceVectorUtils.attraction(c, dist);
            ForceVectorNodeLayoutData N2L = (ForceVectorNodeLayoutData)N2.getLayoutData();
            N2L.dx = (float)((double)N2L.dx - xDist / dist * f);
            N2L.dy = (float)((double)N2L.dy - yDist / dist * f);
        }
    }

    protected static double attraction(double c, double dist) {
        return 0.01 * -c * dist;
    }

    protected static double repulsion(double c, double dist) {
        return 0.001 * c / dist;
    }
}

