/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreAttribute;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintBase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableConstraintColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;

public class PostgreTableConstraint
extends PostgreTableConstraintBase<PostgreTableConstraintColumn> {
    private static final Log log = Log.getLog(PostgreTableConstraint.class);
    private String source;
    private final List<PostgreTableConstraintColumn> columns = new ArrayList<PostgreTableConstraintColumn>();

    public PostgreTableConstraint(PostgreTableBase table, String name, DBSEntityConstraintType constraintType, JDBCResultSet resultSet) throws DBException {
        super(table, name, constraintType, resultSet);
        String sourceCopy = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"consrc_copy");
        this.source = sourceCopy == null && this.getDataSource().getServerType().supportsPGConstraintExpressionColumn() ? (!this.getDataSource().isServerVersionAtLeast(12, 0) ? JDBCUtils.safeGetString((ResultSet)resultSet, (String)"consrc") : null) : sourceCopy;
    }

    public PostgreTableConstraint(PostgreTableBase table, String constraintName, DBSEntityConstraintType constraintType) {
        super(table, constraintName, constraintType);
    }

    public PostgreTableConstraint(DBRProgressMonitor monitor, PostgreTableReal owner, PostgreTableConstraint srcConstr) throws DBException {
        super(monitor, owner, srcConstr);
        this.source = srcConstr.source;
        for (PostgreTableConstraintColumn srcCol : srcConstr.columns) {
            PostgreTableColumn ownAttr = owner.getAttribute(monitor, srcCol.getAttribute().getName());
            if (ownAttr == null) continue;
            this.columns.add(new PostgreTableConstraintColumn(this, ownAttr, this.columns.size()));
        }
    }

    @Override
    void cacheAttributes(DBRProgressMonitor monitor, List<? extends PostgreTableConstraintColumn> children, boolean secondPass) {
        if (secondPass) {
            return;
        }
        this.columns.clear();
        this.columns.addAll(children);
    }

    public List<PostgreTableConstraintColumn> getAttributeReferences(@Nullable DBRProgressMonitor monitor) {
        return this.columns;
    }

    public void addAttributeReference(DBSTableColumn column) throws DBException {
        this.columns.add(new PostgreTableConstraintColumn(this, (PostgreAttribute)column, this.columns.size()));
    }

    public void addColumn(PostgreTableConstraintColumn column) {
        this.columns.add(column);
    }

    public List<PostgreTableConstraintColumn> getColumns() {
        return this.columns;
    }

    public void setAttributeReferences(List<PostgreTableConstraintColumn> columns) throws DBException {
        this.columns.clear();
        this.columns.addAll(columns);
    }

    @Property(viewable=true, editable=true, order=10)
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }
}

