﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/amplifyuibuilder/AmplifyUIBuilder_EXPORTS.h>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AmplifyUIBuilder {
namespace Model {

/**
 * <p>Describes the configuration for an application with no API being
 * used.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/amplifyuibuilder-2021-08-11/NoApiRenderConfig">AWS
 * API Reference</a></p>
 */
class NoApiRenderConfig {
 public:
  AWS_AMPLIFYUIBUILDER_API NoApiRenderConfig() = default;
  AWS_AMPLIFYUIBUILDER_API NoApiRenderConfig(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFYUIBUILDER_API NoApiRenderConfig& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_AMPLIFYUIBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;
};

}  // namespace Model
}  // namespace AmplifyUIBuilder
}  // namespace Aws
