//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.10
//
// <auto-generated>
//
// Generated from file `IceStormInternal.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#include <IceStorm/IceStormInternal.h>
#include <IceUtil/PushDisableWarnings.h>
#include <Ice/LocalException.h>
#include <Ice/ValueFactory.h>
#include <Ice/OutgoingAsync.h>
#include <Ice/InputStream.h>
#include <Ice/OutputStream.h>
#include <Ice/LocalException.h>
#include <IceUtil/PopDisableWarnings.h>

#if defined(_MSC_VER)
#   pragma warning(disable:4458) // declaration of ... hides class member
#elif defined(__clang__)
#   pragma clang diagnostic ignored "-Wshadow"
#elif defined(__GNUC__)
#   pragma GCC diagnostic ignored "-Wshadow"
#endif

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 10
#       error Ice patch level mismatch!
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace
{

const ::std::string iceC_IceStorm_TopicLink_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::TopicLink"
};
const ::std::string iceC_IceStorm_TopicLink_ops[] =
{
    "forward",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};
const ::std::string iceC_IceStorm_TopicLink_forward_name = "forward";

const ::IceInternal::DefaultUserExceptionFactoryInit<::IceStorm::ReapWouldBlock> iceC_IceStorm_ReapWouldBlock_init("::IceStorm::ReapWouldBlock");

const ::std::string iceC_IceStorm_TopicInternal_ids[3] =
{
    "::Ice::Object",
    "::IceStorm::Topic",
    "::IceStorm::TopicInternal"
};
const ::std::string iceC_IceStorm_TopicInternal_ops[] =
{
    "destroy",
    "getLinkInfoSeq",
    "getLinkProxy",
    "getName",
    "getNonReplicatedPublisher",
    "getPublisher",
    "getSubscribers",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "link",
    "reap",
    "subscribeAndGetPublisher",
    "unlink",
    "unsubscribe"
};
const ::std::string iceC_IceStorm_TopicInternal_getLinkProxy_name = "getLinkProxy";
const ::std::string iceC_IceStorm_TopicInternal_reap_name = "reap";

const ::std::string iceC_IceStorm_TopicManagerInternal_ids[3] =
{
    "::Ice::Object",
    "::IceStorm::TopicManager",
    "::IceStorm::TopicManagerInternal"
};
const ::std::string iceC_IceStorm_TopicManagerInternal_ops[] =
{
    "create",
    "getReplicaNode",
    "getSliceChecksums",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "retrieve",
    "retrieveAll"
};
const ::std::string iceC_IceStorm_TopicManagerInternal_getReplicaNode_name = "getReplicaNode";

}

IceStorm::SendQueueSizeMaxReached::~SendQueueSizeMaxReached()
{
}

const ::std::string&
IceStorm::SendQueueSizeMaxReached::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::SendQueueSizeMaxReached";
    return typeId;
}

IceStorm::ReapWouldBlock::~ReapWouldBlock()
{
}

const ::std::string&
IceStorm::ReapWouldBlock::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::ReapWouldBlock";
    return typeId;
}

bool
IceStorm::TopicLink::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicLink_ids, iceC_IceStorm_TopicLink_ids + 2, s);
}

::std::vector<::std::string>
IceStorm::TopicLink::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceStorm_TopicLink_ids[0], &iceC_IceStorm_TopicLink_ids[2]);
}

::std::string
IceStorm::TopicLink::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicLink::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::TopicLink";
    return typeId;
}

/// \cond INTERNAL
bool
IceStorm::TopicLink::_iceD_forward(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    EventDataSeq iceP_events;
    istr->readAll(iceP_events);
    inS.endReadParams();
    this->forward(::std::move(iceP_events), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicLink::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicLink_ops, iceC_IceStorm_TopicLink_ops + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicLink_ops)
    {
        case 0:
        {
            return _iceD_forward(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceStorm::TopicInternal::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicInternal_ids, iceC_IceStorm_TopicInternal_ids + 3, s);
}

::std::vector<::std::string>
IceStorm::TopicInternal::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceStorm_TopicInternal_ids[0], &iceC_IceStorm_TopicInternal_ids[3]);
}

::std::string
IceStorm::TopicInternal::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicInternal::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::TopicInternal";
    return typeId;
}

/// \cond INTERNAL
bool
IceStorm::TopicInternal::_iceD_getLinkProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<TopicLinkPrx> ret = this->getLinkProxy(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicInternal::_iceD_reap(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::OperationMode::Normal, current.mode);
    auto istr = inS.startReadParams();
    ::Ice::IdentitySeq iceP_id;
    istr->readAll(iceP_id);
    inS.endReadParams();
    this->reap(::std::move(iceP_id), current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicInternal::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicInternal_ops, iceC_IceStorm_TopicInternal_ops + 16, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicInternal_ops)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getLinkInfoSeq(in, current);
        }
        case 2:
        {
            return _iceD_getLinkProxy(in, current);
        }
        case 3:
        {
            return _iceD_getName(in, current);
        }
        case 4:
        {
            return _iceD_getNonReplicatedPublisher(in, current);
        }
        case 5:
        {
            return _iceD_getPublisher(in, current);
        }
        case 6:
        {
            return _iceD_getSubscribers(in, current);
        }
        case 7:
        {
            return _iceD_ice_id(in, current);
        }
        case 8:
        {
            return _iceD_ice_ids(in, current);
        }
        case 9:
        {
            return _iceD_ice_isA(in, current);
        }
        case 10:
        {
            return _iceD_ice_ping(in, current);
        }
        case 11:
        {
            return _iceD_link(in, current);
        }
        case 12:
        {
            return _iceD_reap(in, current);
        }
        case 13:
        {
            return _iceD_subscribeAndGetPublisher(in, current);
        }
        case 14:
        {
            return _iceD_unlink(in, current);
        }
        case 15:
        {
            return _iceD_unsubscribe(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

bool
IceStorm::TopicManagerInternal::ice_isA(::std::string s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicManagerInternal_ids, iceC_IceStorm_TopicManagerInternal_ids + 3, s);
}

::std::vector<::std::string>
IceStorm::TopicManagerInternal::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector<::std::string>(&iceC_IceStorm_TopicManagerInternal_ids[0], &iceC_IceStorm_TopicManagerInternal_ids[3]);
}

::std::string
IceStorm::TopicManagerInternal::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicManagerInternal::ice_staticId()
{
    static const ::std::string typeId = "::IceStorm::TopicManagerInternal";
    return typeId;
}

/// \cond INTERNAL
bool
IceStorm::TopicManagerInternal::_iceD_getReplicaNode(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::OperationMode::Idempotent, current.mode);
    inS.readEmptyParams();
    ::std::shared_ptr<::IceStormElection::NodePrx> ret = this->getReplicaNode(current);
    auto ostr = inS.startWriteParams();
    ostr->writeAll(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicManagerInternal::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicManagerInternal_ops, iceC_IceStorm_TopicManagerInternal_ops + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicManagerInternal_ops)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_getReplicaNode(in, current);
        }
        case 2:
        {
            return _iceD_getSliceChecksums(in, current);
        }
        case 3:
        {
            return _iceD_ice_id(in, current);
        }
        case 4:
        {
            return _iceD_ice_ids(in, current);
        }
        case 5:
        {
            return _iceD_ice_isA(in, current);
        }
        case 6:
        {
            return _iceD_ice_ping(in, current);
        }
        case 7:
        {
            return _iceD_retrieve(in, current);
        }
        case 8:
        {
            return _iceD_retrieveAll(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicLinkPrx::_iceI_forward(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const EventDataSeq& iceP_events, const ::Ice::Context& context)
{
    outAsync->invoke(iceC_IceStorm_TopicLink_forward_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_events);
        },
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceStorm::TopicLinkPrx::_newInstance() const
{
    return ::IceInternal::createProxy<TopicLinkPrx>();
}
/// \endcond

const ::std::string&
IceStorm::TopicLinkPrx::ice_staticId()
{
    return TopicLink::ice_staticId();
}

/// \cond INTERNAL
void
IceStorm::TopicInternalPrx::_iceI_getLinkProxy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStorm::TopicLinkPrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicInternal_getLinkProxy_name);
    outAsync->invoke(iceC_IceStorm_TopicInternal_getLinkProxy_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::TopicInternalPrx::_iceI_reap(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>& outAsync, const ::Ice::IdentitySeq& iceP_id, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicInternal_reap_name);
    outAsync->invoke(iceC_IceStorm_TopicInternal_reap_name, ::Ice::OperationMode::Normal, ::Ice::FormatType::DefaultFormat, context,
        [&](::Ice::OutputStream* ostr)
        {
            ostr->writeAll(iceP_id);
        },
        [](const ::Ice::UserException& ex)
        {
            try
            {
                ex.ice_throw();
            }
            catch(const ReapWouldBlock&)
            {
                throw;
            }
            catch(const ::Ice::UserException&)
            {
            }
        });
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceStorm::TopicInternalPrx::_newInstance() const
{
    return ::IceInternal::createProxy<TopicInternalPrx>();
}
/// \endcond

const ::std::string&
IceStorm::TopicInternalPrx::ice_staticId()
{
    return TopicInternal::ice_staticId();
}

/// \cond INTERNAL
void
IceStorm::TopicManagerInternalPrx::_iceI_getReplicaNode(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::IceStormElection::NodePrx>>>& outAsync, const ::Ice::Context& context)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManagerInternal_getReplicaNode_name);
    outAsync->invoke(iceC_IceStorm_TopicManagerInternal_getReplicaNode_name, ::Ice::OperationMode::Idempotent, ::Ice::FormatType::DefaultFormat, context,
        nullptr,
        nullptr);
}
/// \endcond

/// \cond INTERNAL
::std::shared_ptr<::Ice::ObjectPrx>
IceStorm::TopicManagerInternalPrx::_newInstance() const
{
    return ::IceInternal::createProxy<TopicManagerInternalPrx>();
}
/// \endcond

const ::std::string&
IceStorm::TopicManagerInternalPrx::ice_staticId()
{
    return TopicManagerInternal::ice_staticId();
}

namespace Ice
{
}

#else // C++98 mapping

namespace
{

const ::std::string iceC_IceStorm_TopicLink_forward_name = "forward";

const ::std::string iceC_IceStorm_TopicInternal_getLinkProxy_name = "getLinkProxy";

const ::std::string iceC_IceStorm_TopicInternal_reap_name = "reap";

const ::std::string iceC_IceStorm_TopicManagerInternal_getReplicaNode_name = "getReplicaNode";

}

IceStorm::SendQueueSizeMaxReached::SendQueueSizeMaxReached(const char* file, int line) :
    ::Ice::LocalException(file, line)
{
}

#ifdef ICE_CPP11_COMPILER
IceStorm::SendQueueSizeMaxReached::~SendQueueSizeMaxReached()
{
}
#else
IceStorm::SendQueueSizeMaxReached::~SendQueueSizeMaxReached() throw()
{
}
#endif

::std::string
IceStorm::SendQueueSizeMaxReached::ice_id() const
{
    return "::IceStorm::SendQueueSizeMaxReached";
}

IceStorm::SendQueueSizeMaxReached*
IceStorm::SendQueueSizeMaxReached::ice_clone() const
{
    return new SendQueueSizeMaxReached(*this);
}

void
IceStorm::SendQueueSizeMaxReached::ice_throw() const
{
    throw *this;
}

namespace
{

const ::IceInternal::DefaultUserExceptionFactoryInit< ::IceStorm::ReapWouldBlock> iceC_IceStorm_ReapWouldBlock_init("::IceStorm::ReapWouldBlock");

}

#ifdef ICE_CPP11_COMPILER
IceStorm::ReapWouldBlock::~ReapWouldBlock()
{
}
#else
IceStorm::ReapWouldBlock::~ReapWouldBlock() throw()
{
}
#endif

::std::string
IceStorm::ReapWouldBlock::ice_id() const
{
    return "::IceStorm::ReapWouldBlock";
}

IceStorm::ReapWouldBlock*
IceStorm::ReapWouldBlock::ice_clone() const
{
    return new ReapWouldBlock(*this);
}

void
IceStorm::ReapWouldBlock::ice_throw() const
{
    throw *this;
}

/// \cond STREAM
void
IceStorm::ReapWouldBlock::_writeImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice("::IceStorm::ReapWouldBlock", -1, true);
    ::Ice::StreamWriter< ReapWouldBlock, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::ReapWouldBlock::_readImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< ReapWouldBlock, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceStorm::upCast(TopicLink* p) { return p; }

void
::IceProxy::IceStorm::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< TopicLink>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new TopicLink;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicLink::_iceI_begin_forward(const ::IceStorm::EventDataSeq& iceP_events, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicLink_forward_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicLink_forward_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_events);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_TopicLink_forward_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceStorm::TopicLink::end_forward(const ::Ice::AsyncResultPtr& result)
{
    _end(result, iceC_IceStorm_TopicLink_forward_name);
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceStorm::TopicLink::_newInstance() const
{
    return new TopicLink;
}
/// \endcond

const ::std::string&
IceProxy::IceStorm::TopicLink::ice_staticId()
{
    return ::IceStorm::TopicLink::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceStorm::upCast(TopicInternal* p) { return p; }

void
::IceProxy::IceStorm::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< TopicInternal>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new TopicInternal;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicInternal::_iceI_begin_getLinkProxy(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicInternal_getLinkProxy_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicInternal_getLinkProxy_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicInternal_getLinkProxy_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_TopicInternal_getLinkProxy_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStorm::TopicLinkPrx
IceProxy::IceStorm::TopicInternal::end_getLinkProxy(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicInternal_getLinkProxy_name);
    ::IceStorm::TopicLinkPrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicInternal::_iceI_begin_reap(const ::Ice::IdentitySeq& iceP_id, const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicInternal_reap_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicInternal_reap_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicInternal_reap_name, ::Ice::Normal, context);
        ::Ice::OutputStream* ostr = result->startWriteParams(::Ice::DefaultFormat);
        ostr->write(iceP_id);
        result->endWriteParams();
        result->invoke(iceC_IceStorm_TopicInternal_reap_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

void
IceProxy::IceStorm::TopicInternal::end_reap(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicInternal_reap_name);
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::IceStorm::ReapWouldBlock&)
        {
            throw;
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    result->_readEmptyParams();
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceStorm::TopicInternal::_newInstance() const
{
    return new TopicInternal;
}
/// \endcond

const ::std::string&
IceProxy::IceStorm::TopicInternal::ice_staticId()
{
    return ::IceStorm::TopicInternal::ice_staticId();
}

/// \cond INTERNAL
::IceProxy::Ice::Object* ::IceProxy::IceStorm::upCast(TopicManagerInternal* p) { return p; }

void
::IceProxy::IceStorm::_readProxy(::Ice::InputStream* istr, ::IceInternal::ProxyHandle< TopicManagerInternal>& v)
{
    ::Ice::ObjectPrx proxy;
    istr->read(proxy);
    if(!proxy)
    {
        v = 0;
    }
    else
    {
        v = new TopicManagerInternal;
        v->_copyFrom(proxy);
    }
}
/// \endcond

::Ice::AsyncResultPtr
IceProxy::IceStorm::TopicManagerInternal::_iceI_begin_getReplicaNode(const ::Ice::Context& context, const ::IceInternal::CallbackBasePtr& del, const ::Ice::LocalObjectPtr& cookie, bool sync)
{
    _checkTwowayOnly(iceC_IceStorm_TopicManagerInternal_getReplicaNode_name, sync);
    ::IceInternal::OutgoingAsyncPtr result = new ::IceInternal::CallbackOutgoing(this, iceC_IceStorm_TopicManagerInternal_getReplicaNode_name, del, cookie, sync);
    try
    {
        result->prepare(iceC_IceStorm_TopicManagerInternal_getReplicaNode_name, ::Ice::Idempotent, context);
        result->writeEmptyParams();
        result->invoke(iceC_IceStorm_TopicManagerInternal_getReplicaNode_name);
    }
    catch(const ::Ice::Exception& ex)
    {
        result->abort(ex);
    }
    return result;
}

::IceStormElection::NodePrx
IceProxy::IceStorm::TopicManagerInternal::end_getReplicaNode(const ::Ice::AsyncResultPtr& result)
{
    ::Ice::AsyncResult::_check(result, this, iceC_IceStorm_TopicManagerInternal_getReplicaNode_name);
    ::IceStormElection::NodePrx ret;
    if(!result->_waitForResponse())
    {
        try
        {
            result->_throwUserException();
        }
        catch(const ::Ice::UserException& ex)
        {
            throw ::Ice::UnknownUserException(__FILE__, __LINE__, ex.ice_id());
        }
    }
    ::Ice::InputStream* istr = result->_startReadParams();
    istr->read(ret);
    result->_endReadParams();
    return ret;
}

/// \cond INTERNAL
::IceProxy::Ice::Object*
IceProxy::IceStorm::TopicManagerInternal::_newInstance() const
{
    return new TopicManagerInternal;
}
/// \endcond

const ::std::string&
IceProxy::IceStorm::TopicManagerInternal::ice_staticId()
{
    return ::IceStorm::TopicManagerInternal::ice_staticId();
}

IceStorm::TopicLink::~TopicLink()
{
}

/// \cond INTERNAL
::Ice::Object* IceStorm::upCast(TopicLink* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicLink_ids[2] =
{
    "::Ice::Object",
    "::IceStorm::TopicLink"
};

}

bool
IceStorm::TopicLink::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicLink_ids, iceC_IceStorm_TopicLink_ids + 2, s);
}

::std::vector< ::std::string>
IceStorm::TopicLink::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceStorm_TopicLink_ids[0], &iceC_IceStorm_TopicLink_ids[2]);
}

const ::std::string&
IceStorm::TopicLink::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicLink::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceStorm::TopicLink";
    return typeId;
#else
    return iceC_IceStorm_TopicLink_ids[1];
#endif
}

/// \cond INTERNAL
bool
IceStorm::TopicLink::_iceD_forward(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    EventDataSeq iceP_events;
    istr->read(iceP_events);
    inS.endReadParams();
    this->forward(iceP_events, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicLink_all[] =
{
    "forward",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping"
};

}

/// \cond INTERNAL
bool
IceStorm::TopicLink::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicLink_all, iceC_IceStorm_TopicLink_all + 5, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicLink_all)
    {
        case 0:
        {
            return _iceD_forward(in, current);
        }
        case 1:
        {
            return _iceD_ice_id(in, current);
        }
        case 2:
        {
            return _iceD_ice_ids(in, current);
        }
        case 3:
        {
            return _iceD_ice_isA(in, current);
        }
        case 4:
        {
            return _iceD_ice_ping(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceStorm::TopicLink::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< TopicLink, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::TopicLink::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< TopicLink, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::_icePatchObjectPtr(TopicLinkPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = TopicLinkPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(TopicLink::ice_staticId(), v);
    }
}
/// \endcond

IceStorm::TopicInternal::~TopicInternal()
{
}

/// \cond INTERNAL
::Ice::Object* IceStorm::upCast(TopicInternal* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicInternal_ids[3] =
{
    "::Ice::Object",
    "::IceStorm::Topic",
    "::IceStorm::TopicInternal"
};

}

bool
IceStorm::TopicInternal::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicInternal_ids, iceC_IceStorm_TopicInternal_ids + 3, s);
}

::std::vector< ::std::string>
IceStorm::TopicInternal::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceStorm_TopicInternal_ids[0], &iceC_IceStorm_TopicInternal_ids[3]);
}

const ::std::string&
IceStorm::TopicInternal::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicInternal::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceStorm::TopicInternal";
    return typeId;
#else
    return iceC_IceStorm_TopicInternal_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceStorm::TopicInternal::_iceD_getLinkProxy(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    TopicLinkPrx ret = this->getLinkProxy(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

/// \cond INTERNAL
bool
IceStorm::TopicInternal::_iceD_reap(::IceInternal::Incoming& inS, const ::Ice::Current& current)
{
    _iceCheckMode(::Ice::Normal, current.mode);
    ::Ice::InputStream* istr = inS.startReadParams();
    ::Ice::IdentitySeq iceP_id;
    istr->read(iceP_id);
    inS.endReadParams();
    this->reap(iceP_id, current);
    inS.writeEmptyParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicInternal_all[] =
{
    "destroy",
    "getLinkInfoSeq",
    "getLinkProxy",
    "getName",
    "getNonReplicatedPublisher",
    "getPublisher",
    "getSubscribers",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "link",
    "reap",
    "subscribeAndGetPublisher",
    "unlink",
    "unsubscribe"
};

}

/// \cond INTERNAL
bool
IceStorm::TopicInternal::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicInternal_all, iceC_IceStorm_TopicInternal_all + 16, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicInternal_all)
    {
        case 0:
        {
            return _iceD_destroy(in, current);
        }
        case 1:
        {
            return _iceD_getLinkInfoSeq(in, current);
        }
        case 2:
        {
            return _iceD_getLinkProxy(in, current);
        }
        case 3:
        {
            return _iceD_getName(in, current);
        }
        case 4:
        {
            return _iceD_getNonReplicatedPublisher(in, current);
        }
        case 5:
        {
            return _iceD_getPublisher(in, current);
        }
        case 6:
        {
            return _iceD_getSubscribers(in, current);
        }
        case 7:
        {
            return _iceD_ice_id(in, current);
        }
        case 8:
        {
            return _iceD_ice_ids(in, current);
        }
        case 9:
        {
            return _iceD_ice_isA(in, current);
        }
        case 10:
        {
            return _iceD_ice_ping(in, current);
        }
        case 11:
        {
            return _iceD_link(in, current);
        }
        case 12:
        {
            return _iceD_reap(in, current);
        }
        case 13:
        {
            return _iceD_subscribeAndGetPublisher(in, current);
        }
        case 14:
        {
            return _iceD_unlink(in, current);
        }
        case 15:
        {
            return _iceD_unsubscribe(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceStorm::TopicInternal::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< TopicInternal, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::TopicInternal::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< TopicInternal, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::_icePatchObjectPtr(TopicInternalPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = TopicInternalPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(TopicInternal::ice_staticId(), v);
    }
}
/// \endcond

IceStorm::TopicManagerInternal::~TopicManagerInternal()
{
}

/// \cond INTERNAL
::Ice::Object* IceStorm::upCast(TopicManagerInternal* p) { return p; }

/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicManagerInternal_ids[3] =
{
    "::Ice::Object",
    "::IceStorm::TopicManager",
    "::IceStorm::TopicManagerInternal"
};

}

bool
IceStorm::TopicManagerInternal::ice_isA(const ::std::string& s, const ::Ice::Current&) const
{
    return ::std::binary_search(iceC_IceStorm_TopicManagerInternal_ids, iceC_IceStorm_TopicManagerInternal_ids + 3, s);
}

::std::vector< ::std::string>
IceStorm::TopicManagerInternal::ice_ids(const ::Ice::Current&) const
{
    return ::std::vector< ::std::string>(&iceC_IceStorm_TopicManagerInternal_ids[0], &iceC_IceStorm_TopicManagerInternal_ids[3]);
}

const ::std::string&
IceStorm::TopicManagerInternal::ice_id(const ::Ice::Current&) const
{
    return ice_staticId();
}

const ::std::string&
IceStorm::TopicManagerInternal::ice_staticId()
{
#ifdef ICE_HAS_THREAD_SAFE_LOCAL_STATIC
    static const ::std::string typeId = "::IceStorm::TopicManagerInternal";
    return typeId;
#else
    return iceC_IceStorm_TopicManagerInternal_ids[2];
#endif
}

/// \cond INTERNAL
bool
IceStorm::TopicManagerInternal::_iceD_getReplicaNode(::IceInternal::Incoming& inS, const ::Ice::Current& current) const
{
    _iceCheckMode(::Ice::Idempotent, current.mode);
    inS.readEmptyParams();
    ::IceStormElection::NodePrx ret = this->getReplicaNode(current);
    ::Ice::OutputStream* ostr = inS.startWriteParams();
    ostr->write(ret);
    inS.endWriteParams();
    return true;
}
/// \endcond

namespace
{
const ::std::string iceC_IceStorm_TopicManagerInternal_all[] =
{
    "create",
    "getReplicaNode",
    "getSliceChecksums",
    "ice_id",
    "ice_ids",
    "ice_isA",
    "ice_ping",
    "retrieve",
    "retrieveAll"
};

}

/// \cond INTERNAL
bool
IceStorm::TopicManagerInternal::_iceDispatch(::IceInternal::Incoming& in, const ::Ice::Current& current)
{
    ::std::pair<const ::std::string*, const ::std::string*> r = ::std::equal_range(iceC_IceStorm_TopicManagerInternal_all, iceC_IceStorm_TopicManagerInternal_all + 9, current.operation);
    if(r.first == r.second)
    {
        throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
    }

    switch(r.first - iceC_IceStorm_TopicManagerInternal_all)
    {
        case 0:
        {
            return _iceD_create(in, current);
        }
        case 1:
        {
            return _iceD_getReplicaNode(in, current);
        }
        case 2:
        {
            return _iceD_getSliceChecksums(in, current);
        }
        case 3:
        {
            return _iceD_ice_id(in, current);
        }
        case 4:
        {
            return _iceD_ice_ids(in, current);
        }
        case 5:
        {
            return _iceD_ice_isA(in, current);
        }
        case 6:
        {
            return _iceD_ice_ping(in, current);
        }
        case 7:
        {
            return _iceD_retrieve(in, current);
        }
        case 8:
        {
            return _iceD_retrieveAll(in, current);
        }
        default:
        {
            assert(false);
            throw ::Ice::OperationNotExistException(__FILE__, __LINE__, current.id, current.facet, current.operation);
        }
    }
}
/// \endcond

/// \cond STREAM
void
IceStorm::TopicManagerInternal::_iceWriteImpl(::Ice::OutputStream* ostr) const
{
    ostr->startSlice(ice_staticId(), -1, true);
    ::Ice::StreamWriter< TopicManagerInternal, ::Ice::OutputStream>::write(ostr, *this);
    ostr->endSlice();
}

void
IceStorm::TopicManagerInternal::_iceReadImpl(::Ice::InputStream* istr)
{
    istr->startSlice();
    ::Ice::StreamReader< TopicManagerInternal, ::Ice::InputStream>::read(istr, *this);
    istr->endSlice();
}
/// \endcond

/// \cond INTERNAL
void
IceStorm::_icePatchObjectPtr(TopicManagerInternalPtr& handle, const ::Ice::ObjectPtr& v)
{
    handle = TopicManagerInternalPtr::dynamicCast(v);
    if(v && !handle)
    {
        IceInternal::Ex::throwUOE(TopicManagerInternal::ice_staticId(), v);
    }
}
/// \endcond

namespace Ice
{
}

#endif
