/* ext-fts.c generated by valac 0.56.17, the Vala compiler
 * generated from ext-fts.vala, do not modify */

/* fts.vala
 *
 * Copyright © 2011 Seif Lotfy <seif@lotfy.com>
 * Copyright © 2011 Canonical Ltd.
 *             By Michal Hruby <michal.hruby@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "zeitgeist-engine.h"
#include "zeitgeist.h"
#include "zeitgeist-datamodel.h"

#define ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME "org.gnome.zeitgeist.SimpleIndexer"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE (zeitgeist_remote_search_engine_get_type ())
#define ZEITGEIST_REMOTE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, ZeitgeistRemoteSearchEngine))
#define ZEITGEIST_IS_REMOTE_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE))
#define ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, ZeitgeistRemoteSearchEngineIface))

typedef struct _ZeitgeistRemoteSearchEngine ZeitgeistRemoteSearchEngine;
typedef struct _ZeitgeistRemoteSearchEngineIface ZeitgeistRemoteSearchEngineIface;

#define ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE_PROXY (zeitgeist_remote_search_engine_proxy_get_type ())
typedef GDBusProxy ZeitgeistRemoteSearchEngineProxy;
typedef GDBusProxyClass ZeitgeistRemoteSearchEngineProxyClass;
typedef struct _ZeitgeistRemoteSearchEngineSearchReadyData ZeitgeistRemoteSearchEngineSearchReadyData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData;

#define ZEITGEIST_TYPE_SEARCH_ENGINE (zeitgeist_search_engine_get_type ())
#define ZEITGEIST_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine))
#define ZEITGEIST_SEARCH_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngineClass))
#define ZEITGEIST_IS_SEARCH_ENGINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE))
#define ZEITGEIST_IS_SEARCH_ENGINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZEITGEIST_TYPE_SEARCH_ENGINE))
#define ZEITGEIST_SEARCH_ENGINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngineClass))

typedef struct _ZeitgeistSearchEngine ZeitgeistSearchEngine;
typedef struct _ZeitgeistSearchEngineClass ZeitgeistSearchEngineClass;
typedef struct _ZeitgeistSearchEnginePrivate ZeitgeistSearchEnginePrivate;
enum  {
	ZEITGEIST_SEARCH_ENGINE_0_PROPERTY,
	ZEITGEIST_SEARCH_ENGINE_NUM_PROPERTIES
};
static GParamSpec* zeitgeist_search_engine_properties[ZEITGEIST_SEARCH_ENGINE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ZeitgeistSearchEngineWaitForProxyData ZeitgeistSearchEngineWaitForProxyData;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ZeitgeistSearchEngineSearchData ZeitgeistSearchEngineSearchData;
typedef struct _ZeitgeistSearchEngineSearchWithRelevanciesData ZeitgeistSearchEngineSearchWithRelevanciesData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _ZeitgeistRemoteSearchEngineIface {
	GTypeInterface parent_iface;
	void (*search) (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint offset, guint count, guint result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_finish) (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, guint* matches, GError** error);
	void (*search_with_relevancies) (ZeitgeistRemoteSearchEngine* self, const gchar* query_string, GVariant* time_range, GVariant* filter_templates, guint storage_state, guint offset, guint count, guint result_type, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*search_with_relevancies_finish) (ZeitgeistRemoteSearchEngine* self, GAsyncResult* _res_, GVariant** events, gdouble** relevancies, gint* relevancies_length1, guint* matches, GError** error);
};

struct _ZeitgeistRemoteSearchEngineSearchReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint offset;
	guint count;
	guint result_type;
};

struct _ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData {
	GDBusMethodInvocation* _invocation_;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint storage_state;
	guint offset;
	guint count;
	guint result_type;
};

struct _ZeitgeistSearchEngine {
	ZeitgeistExtension parent_instance;
	ZeitgeistSearchEnginePrivate * priv;
};

struct _ZeitgeistSearchEngineClass {
	ZeitgeistExtensionClass parent_class;
};

struct _ZeitgeistSearchEnginePrivate {
	ZeitgeistRemoteSimpleIndexer* siin;
	gboolean siin_connection_failed;
	guint registration_id;
	ZeitgeistMonitorManager* notifier;
};

struct _ZeitgeistSearchEngineWaitForProxyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistSearchEngine* self;
	gint i;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	ZeitgeistRemoteSimpleIndexer* _tmp5_;
	ZeitgeistRemoteSimpleIndexer* _tmp6_;
	GError* _tmp7_;
	GError* _inner_error0_;
};

struct _ZeitgeistSearchEngineSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistSearchEngine* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint offset;
	guint count;
	guint result_type;
	GCancellable* cancellable;
	GVariant* events;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp0_;
	GTimer* timer;
	GTimer* _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	GVariant* _tmp3_;
	guint _tmp4_;
	GVariant* _tmp5_;
	GTimer* _tmp6_;
	GError* _inner_error0_;
};

struct _ZeitgeistSearchEngineSearchWithRelevanciesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ZeitgeistSearchEngine* self;
	gchar* query_string;
	GVariant* time_range;
	GVariant* filter_templates;
	guint storage_state;
	guint offset;
	guint count;
	guint result_type;
	GCancellable* cancellable;
	GVariant* events;
	gdouble* relevancies;
	gint relevancies_length1;
	guint matches;
	ZeitgeistRemoteSimpleIndexer* _tmp0_;
	GTimer* timer;
	GTimer* _tmp1_;
	ZeitgeistRemoteSimpleIndexer* _tmp2_;
	GVariant* _tmp3_;
	gdouble* _tmp4_;
	gint _tmp5_;
	guint _tmp6_;
	GVariant* _tmp7_;
	GTimer* _tmp8_;
	GError* _inner_error0_;
};

static GType zeitgeist_remote_search_engine_type_id = 0;
static gint ZeitgeistSearchEngine_private_offset;
static gpointer zeitgeist_search_engine_parent_class = NULL;
static ZeitgeistRemoteSearchEngineIface * zeitgeist_search_engine_zeitgeist_remote_search_engine_parent_iface = NULL;
static GType zeitgeist_search_engine_type_id = 0;

VALA_EXTERN GType zeitgeist_remote_search_engine_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void zeitgeist_remote_search_engine_proxy_register_dynamic_type (GTypeModule* module);
VALA_EXTERN guint zeitgeist_remote_search_engine_register_object (void* object,
                                                      GDBusConnection* connection,
                                                      const gchar* path,
                                                      GError** error);
GType zeitgeist_remote_search_engine_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_remote_search_engine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistRemoteSearchEngine, g_object_unref)
VALA_EXTERN void zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self,
                                            const gchar* query_string,
                                            GVariant* time_range,
                                            GVariant* filter_templates,
                                            guint offset,
                                            guint count,
                                            guint result_type,
                                            GCancellable* cancellable,
                                            GAsyncReadyCallback _callback_,
                                            gpointer _user_data_);
VALA_EXTERN void zeitgeist_remote_search_engine_search_finish (ZeitgeistRemoteSearchEngine* self,
                                                   GAsyncResult* _res_,
                                                   GVariant** events,
                                                   guint* matches,
                                                   GError** error);
VALA_EXTERN void zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self,
                                                             const gchar* query_string,
                                                             GVariant* time_range,
                                                             GVariant* filter_templates,
                                                             guint storage_state,
                                                             guint offset,
                                                             guint count,
                                                             guint result_type,
                                                             GCancellable* cancellable,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN void zeitgeist_remote_search_engine_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self,
                                                                    GAsyncResult* _res_,
                                                                    GVariant** events,
                                                                    gdouble** relevancies,
                                                                    gint* relevancies_length1,
                                                                    guint* matches,
                                                                    GError** error);
static void zeitgeist_remote_search_engine_proxy_g_signal (GDBusProxy* proxy,
                                                    const gchar* sender_name,
                                                    const gchar* signal_name,
                                                    GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void zeitgeist_remote_search_engine_proxy_search_async (ZeitgeistRemoteSearchEngine* self,
                                                        const gchar* query_string,
                                                        GVariant* time_range,
                                                        GVariant* filter_templates,
                                                        guint offset,
                                                        guint count,
                                                        guint result_type,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_);
static void zeitgeist_remote_search_engine_proxy_search_finish (ZeitgeistRemoteSearchEngine* self,
                                                         GAsyncResult* _res_,
                                                         GVariant** events,
                                                         guint* matches,
                                                         GError** error);
static void zeitgeist_remote_search_engine_proxy_search_with_relevancies_async (ZeitgeistRemoteSearchEngine* self,
                                                                         const gchar* query_string,
                                                                         GVariant* time_range,
                                                                         GVariant* filter_templates,
                                                                         guint storage_state,
                                                                         guint offset,
                                                                         guint count,
                                                                         guint result_type,
                                                                         GCancellable* cancellable,
                                                                         GAsyncReadyCallback _callback_,
                                                                         gpointer _user_data_);
static void zeitgeist_remote_search_engine_proxy_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self,
                                                                          GAsyncResult* _res_,
                                                                          GVariant** events,
                                                                          gdouble** relevancies,
                                                                          gint* relevancies_length1,
                                                                          guint* matches,
                                                                          GError** error);
static void zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface* iface);
static void _dbus_zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self,
                                                  GVariant* _parameters_,
                                                  GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_search_engine_search_ready (GObject * source_object,
                                                        GAsyncResult * _res_,
                                                        gpointer _user_data_);
static void _dbus_zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self,
                                                                   GVariant* _parameters_,
                                                                   GDBusMethodInvocation* invocation);
static void _dbus_zeitgeist_remote_search_engine_search_with_relevancies_ready (GObject * source_object,
                                                                         GAsyncResult * _res_,
                                                                         gpointer _user_data_);
static void zeitgeist_remote_search_engine_dbus_interface_method_call (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* method_name,
                                                                GVariant* parameters,
                                                                GDBusMethodInvocation* invocation,
                                                                gpointer user_data);
static GVariant* zeitgeist_remote_search_engine_dbus_interface_get_property (GDBusConnection* connection,
                                                                      const gchar* sender,
                                                                      const gchar* object_path,
                                                                      const gchar* interface_name,
                                                                      const gchar* property_name,
                                                                      GError** error,
                                                                      gpointer user_data);
static gboolean zeitgeist_remote_search_engine_dbus_interface_set_property (GDBusConnection* connection,
                                                                     const gchar* sender,
                                                                     const gchar* object_path,
                                                                     const gchar* interface_name,
                                                                     const gchar* property_name,
                                                                     GVariant* value,
                                                                     GError** error,
                                                                     gpointer user_data);
static void _zeitgeist_remote_search_engine_unregister_object (gpointer user_data);
GType zeitgeist_search_engine_register_type (GTypeModule * module);
VALA_EXTERN GType zeitgeist_search_engine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ZeitgeistSearchEngine, g_object_unref)
static ZeitgeistSearchEngine* zeitgeist_search_engine_new (void);
static ZeitgeistSearchEngine* zeitgeist_search_engine_construct (GType object_type);
static void zeitgeist_search_engine_proxy_not_present (ZeitgeistSearchEngine* self);
static void zeitgeist_search_engine_proxy_acquired (ZeitgeistSearchEngine* self,
                                             GObject* obj,
                                             GAsyncResult* res);
static void zeitgeist_search_engine_wait_for_proxy_data_free (gpointer _data);
VALA_EXTERN void zeitgeist_search_engine_wait_for_proxy (ZeitgeistSearchEngine* self,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void zeitgeist_search_engine_wait_for_proxy_finish (ZeitgeistSearchEngine* self,
                                                    GAsyncResult* _res_,
                                                    GError** error);
static gboolean zeitgeist_search_engine_wait_for_proxy_co (ZeitgeistSearchEngineWaitForProxyData* _data_);
static gboolean _zeitgeist_search_engine_wait_for_proxy_co_gsource_func (gpointer self);
static void zeitgeist_search_engine_real_unload (ZeitgeistExtension* base);
static void zeitgeist_search_engine_real_search_data_free (gpointer _data);
static void zeitgeist_search_engine_real_search (ZeitgeistRemoteSearchEngine* base,
                                          const gchar* query_string,
                                          GVariant* time_range,
                                          GVariant* filter_templates,
                                          guint offset,
                                          guint count,
                                          guint result_type,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static gboolean zeitgeist_search_engine_real_search_co (ZeitgeistSearchEngineSearchData* _data_);
static void zeitgeist_search_engine_search_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void zeitgeist_search_engine_real_search_with_relevancies_data_free (gpointer _data);
static void zeitgeist_search_engine_real_search_with_relevancies (ZeitgeistRemoteSearchEngine* base,
                                                           const gchar* query_string,
                                                           GVariant* time_range,
                                                           GVariant* filter_templates,
                                                           guint storage_state,
                                                           guint offset,
                                                           guint count,
                                                           guint result_type,
                                                           GCancellable* cancellable,
                                                           GAsyncReadyCallback _callback_,
                                                           gpointer _user_data_);
static gboolean zeitgeist_search_engine_real_search_with_relevancies_co (ZeitgeistSearchEngineSearchWithRelevanciesData* _data_);
static void zeitgeist_search_engine_search_with_relevancies_ready (GObject* source_object,
                                                            GAsyncResult* _res_,
                                                            gpointer _user_data_);
static GObject * zeitgeist_search_engine_constructor (GType type,
                                               guint n_construct_properties,
                                               GObjectConstructParam * construct_properties);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static GVariant* _variant_new1 (GHashTable* value);
static void _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback (GObject* source_object,
                                                                    GAsyncResult* res,
                                                                    gpointer self);
static void zeitgeist_search_engine_finalize (GObject * obj);
VALA_EXTERN GType zeitgeist_fts_init (GTypeModule* module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_query_string = {-1, "query_string", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_time_range = {-1, "time_range", "(xx)", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_filter_templates = {-1, "filter_templates", "a(asaasay)", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_offset = {-1, "offset", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_count = {-1, "count", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_result_type = {-1, "result_type", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_events = {-1, "events", "a(asaasay)", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_matches = {-1, "matches", "u", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_in[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_query_string, &_zeitgeist_remote_search_engine_dbus_arg_info_search_time_range, &_zeitgeist_remote_search_engine_dbus_arg_info_search_filter_templates, &_zeitgeist_remote_search_engine_dbus_arg_info_search_offset, &_zeitgeist_remote_search_engine_dbus_arg_info_search_count, &_zeitgeist_remote_search_engine_dbus_arg_info_search_result_type, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_out[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_events, &_zeitgeist_remote_search_engine_dbus_arg_info_search_matches, NULL};
static const GDBusMethodInfo _zeitgeist_remote_search_engine_dbus_method_info_search = {-1, "Search", (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_in), (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_out), NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_query_string = {-1, "query_string", "s", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_time_range = {-1, "time_range", "(xx)", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_filter_templates = {-1, "filter_templates", "a(asaasay)", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_storage_state = {-1, "storage_state", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_offset = {-1, "offset", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_count = {-1, "count", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_result_type = {-1, "result_type", "u", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_events = {-1, "events", "a(asaasay)", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_relevancies = {-1, "relevancies", "ad", NULL};
static const GDBusArgInfo _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_matches = {-1, "matches", "u", NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_in[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_query_string, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_time_range, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_filter_templates, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_storage_state, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_offset, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_count, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_result_type, NULL};
static const GDBusArgInfo * const _zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_out[] = {&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_events, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_relevancies, &_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_matches, NULL};
static const GDBusMethodInfo _zeitgeist_remote_search_engine_dbus_method_info_search_with_relevancies = {-1, "SearchWithRelevancies", (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_in), (GDBusArgInfo **) (&_zeitgeist_remote_search_engine_dbus_arg_info_search_with_relevancies_out), NULL};
static const GDBusMethodInfo * const _zeitgeist_remote_search_engine_dbus_method_info[] = {&_zeitgeist_remote_search_engine_dbus_method_info_search, &_zeitgeist_remote_search_engine_dbus_method_info_search_with_relevancies, NULL};
static const GDBusSignalInfo * const _zeitgeist_remote_search_engine_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _zeitgeist_remote_search_engine_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _zeitgeist_remote_search_engine_dbus_interface_info = {-1, "org.gnome.zeitgeist.Index", (GDBusMethodInfo **) (&_zeitgeist_remote_search_engine_dbus_method_info), (GDBusSignalInfo **) (&_zeitgeist_remote_search_engine_dbus_signal_info), (GDBusPropertyInfo **) (&_zeitgeist_remote_search_engine_dbus_property_info), NULL};
static const GDBusInterfaceVTable _zeitgeist_remote_search_engine_dbus_interface_vtable = {zeitgeist_remote_search_engine_dbus_interface_method_call, zeitgeist_remote_search_engine_dbus_interface_get_property, zeitgeist_remote_search_engine_dbus_interface_set_property};

void
zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self,
                                       const gchar* query_string,
                                       GVariant* time_range,
                                       GVariant* filter_templates,
                                       guint offset,
                                       guint count,
                                       guint result_type,
                                       GCancellable* cancellable,
                                       GAsyncReadyCallback _callback_,
                                       gpointer _user_data_)
{
	ZeitgeistRemoteSearchEngineIface* _iface_;
	_iface_ = ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self);
	if (_iface_->search) {
		_iface_->search (self, query_string, time_range, filter_templates, offset, count, result_type, cancellable, _callback_, _user_data_);
	}
}

void
zeitgeist_remote_search_engine_search_finish (ZeitgeistRemoteSearchEngine* self,
                                              GAsyncResult* _res_,
                                              GVariant** events,
                                              guint* matches,
                                              GError** error)
{
	ZeitgeistRemoteSearchEngineIface* _iface_;
	_iface_ = ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self);
	if (_iface_->search_finish) {
		_iface_->search_finish (self, _res_, events, matches, error);
	}
}

void
zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self,
                                                        const gchar* query_string,
                                                        GVariant* time_range,
                                                        GVariant* filter_templates,
                                                        guint storage_state,
                                                        guint offset,
                                                        guint count,
                                                        guint result_type,
                                                        GCancellable* cancellable,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	ZeitgeistRemoteSearchEngineIface* _iface_;
	_iface_ = ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self);
	if (_iface_->search_with_relevancies) {
		_iface_->search_with_relevancies (self, query_string, time_range, filter_templates, storage_state, offset, count, result_type, cancellable, _callback_, _user_data_);
	}
}

void
zeitgeist_remote_search_engine_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self,
                                                               GAsyncResult* _res_,
                                                               GVariant** events,
                                                               gdouble** relevancies,
                                                               gint* relevancies_length1,
                                                               guint* matches,
                                                               GError** error)
{
	ZeitgeistRemoteSearchEngineIface* _iface_;
	_iface_ = ZEITGEIST_REMOTE_SEARCH_ENGINE_GET_INTERFACE (self);
	if (_iface_->search_with_relevancies_finish) {
		_iface_->search_with_relevancies_finish (self, _res_, events, relevancies, relevancies_length1, matches, error);
	}
}

static void
zeitgeist_remote_search_engine_default_init (ZeitgeistRemoteSearchEngineIface * iface,
                                             gpointer iface_data)
{
}

GType
zeitgeist_remote_search_engine_get_type (void)
{
	return zeitgeist_remote_search_engine_type_id;
}

GType
zeitgeist_remote_search_engine_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistRemoteSearchEngineIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_remote_search_engine_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	zeitgeist_remote_search_engine_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "ZeitgeistRemoteSearchEngine", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (zeitgeist_remote_search_engine_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) zeitgeist_remote_search_engine_proxy_get_type);
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.zeitgeist.Index");
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_zeitgeist_remote_search_engine_dbus_interface_info));
	g_type_set_qdata (zeitgeist_remote_search_engine_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) zeitgeist_remote_search_engine_register_object);
	return zeitgeist_remote_search_engine_type_id;
}

G_DEFINE_DYNAMIC_TYPE_EXTENDED (ZeitgeistRemoteSearchEngineProxy, zeitgeist_remote_search_engine_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init) )
static void
zeitgeist_remote_search_engine_proxy_class_init (ZeitgeistRemoteSearchEngineProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = zeitgeist_remote_search_engine_proxy_g_signal;
}

static void
zeitgeist_remote_search_engine_proxy_g_signal (GDBusProxy* proxy,
                                               const gchar* sender_name,
                                               const gchar* signal_name,
                                               GVariant* parameters)
{
}

static void
zeitgeist_remote_search_engine_proxy_class_finalize (ZeitgeistRemoteSearchEngineProxyClass* klass)
{
}

void
zeitgeist_remote_search_engine_proxy_register_dynamic_type (GTypeModule* module)
{
	zeitgeist_remote_search_engine_proxy_register_type (module);
}

static void
zeitgeist_remote_search_engine_proxy_init (ZeitgeistRemoteSearchEngineProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_zeitgeist_remote_search_engine_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
zeitgeist_remote_search_engine_proxy_search_async (ZeitgeistRemoteSearchEngine* self,
                                                   const gchar* query_string,
                                                   GVariant* time_range,
                                                   GVariant* filter_templates,
                                                   guint offset,
                                                   guint count,
                                                   guint result_type,
                                                   GCancellable* cancellable,
                                                   GAsyncReadyCallback _callback_,
                                                   gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Index", "Search");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query_string));
	g_variant_builder_add_value (&_arguments_builder, time_range);
	g_variant_builder_add_value (&_arguments_builder, filter_templates);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (offset));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (count));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (result_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, cancellable, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
zeitgeist_remote_search_engine_proxy_search_finish (ZeitgeistRemoteSearchEngine* self,
                                                    GAsyncResult* _res_,
                                                    GVariant** events,
                                                    guint* matches,
                                                    GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _vala_events = NULL;
	guint _vala_matches = 0U;
	GVariant* _tmp0_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_events = g_variant_iter_next_value (&_reply_iter);
	*events = _vala_events;
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_vala_matches = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	*matches = _vala_matches;
	g_object_unref (_reply_message);
}

static void
zeitgeist_remote_search_engine_proxy_search_with_relevancies_async (ZeitgeistRemoteSearchEngine* self,
                                                                    const gchar* query_string,
                                                                    GVariant* time_range,
                                                                    GVariant* filter_templates,
                                                                    guint storage_state,
                                                                    guint offset,
                                                                    guint count,
                                                                    guint result_type,
                                                                    GCancellable* cancellable,
                                                                    GAsyncReadyCallback _callback_,
                                                                    gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.zeitgeist.Index", "SearchWithRelevancies");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (query_string));
	g_variant_builder_add_value (&_arguments_builder, time_range);
	g_variant_builder_add_value (&_arguments_builder, filter_templates);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (storage_state));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (offset));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (count));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (result_type));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, cancellable, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static void
zeitgeist_remote_search_engine_proxy_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* self,
                                                                     GAsyncResult* _res_,
                                                                     GVariant** events,
                                                                     gdouble** relevancies,
                                                                     gint* relevancies_length1,
                                                                     guint* matches,
                                                                     GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	GVariant* _vala_events = NULL;
	gdouble* _vala_relevancies = NULL;
	gint _vala_relevancies_length1;
	GVariant* _tmp1_;
	gdouble* _tmp2_;
	gint _tmp2__length;
	gint _tmp2__size;
	gint _tmp2__length1;
	GVariantIter _tmp3_;
	GVariant* _tmp4_;
	guint _vala_matches = 0U;
	GVariant* _tmp5_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_vala_events = g_variant_iter_next_value (&_reply_iter);
	*events = _vala_events;
	_vala_relevancies_length1 = 0;
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_tmp2_ = g_new (gdouble, 5);
	_tmp2__length = 0;
	_tmp2__size = 4;
	_tmp2__length1 = 0;
	g_variant_iter_init (&_tmp3_, _tmp1_);
	for (; (_tmp4_ = g_variant_iter_next_value (&_tmp3_)) != NULL; _tmp2__length1++) {
		if (_tmp2__size == _tmp2__length) {
			_tmp2__size = 2 * _tmp2__size;
			_tmp2_ = g_renew (gdouble, _tmp2_, _tmp2__size + 1);
		}
		_tmp2_[_tmp2__length++] = g_variant_get_double (_tmp4_);
		g_variant_unref (_tmp4_);
	}
	_vala_relevancies_length1 = _tmp2__length1;
	_vala_relevancies = _tmp2_;
	g_variant_unref (_tmp1_);
	*relevancies = _vala_relevancies;
	*relevancies_length1 = _vala_relevancies_length1;
	_tmp5_ = g_variant_iter_next_value (&_reply_iter);
	_vala_matches = g_variant_get_uint32 (_tmp5_);
	g_variant_unref (_tmp5_);
	*matches = _vala_matches;
	g_object_unref (_reply_message);
}

static void
zeitgeist_remote_search_engine_proxy_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface* iface)
{
	iface->search = zeitgeist_remote_search_engine_proxy_search_async;
	iface->search_finish = zeitgeist_remote_search_engine_proxy_search_finish;
	iface->search_with_relevancies = zeitgeist_remote_search_engine_proxy_search_with_relevancies_async;
	iface->search_with_relevancies_finish = zeitgeist_remote_search_engine_proxy_search_with_relevancies_finish;
}

static void
_dbus_zeitgeist_remote_search_engine_search (ZeitgeistRemoteSearchEngine* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	ZeitgeistRemoteSearchEngineSearchReadyData* _ready_data;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (ZeitgeistRemoteSearchEngineSearchReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query_string = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	_ready_data->time_range = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filter_templates = g_variant_iter_next_value (&_arguments_iter);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->offset = g_variant_get_uint32 (_tmp7_);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->count = g_variant_get_uint32 (_tmp8_);
	g_variant_unref (_tmp8_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->result_type = g_variant_get_uint32 (_tmp9_);
	g_variant_unref (_tmp9_);
	zeitgeist_remote_search_engine_search (self, _ready_data->query_string, _ready_data->time_range, _ready_data->filter_templates, _ready_data->offset, _ready_data->count, _ready_data->result_type, NULL, (GAsyncReadyCallback) _dbus_zeitgeist_remote_search_engine_search_ready, _ready_data);
	_error:
	;
}

static void
_dbus_zeitgeist_remote_search_engine_search_ready (GObject * source_object,
                                                   GAsyncResult * _res_,
                                                   gpointer _user_data_)
{
	ZeitgeistRemoteSearchEngineSearchReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* events = NULL;
	guint matches = 0U;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	zeitgeist_remote_search_engine_search_finish ((ZeitgeistRemoteSearchEngine*) source_object, _res_, &events, &matches, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, events);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (matches));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query_string);
	_g_variant_unref0 (_ready_data->time_range);
	_g_variant_unref0 (_ready_data->filter_templates);
	_g_variant_unref0 (events);
	g_slice_free (ZeitgeistRemoteSearchEngineSearchReadyData, _ready_data);
}

static void
_dbus_zeitgeist_remote_search_engine_search_with_relevancies (ZeitgeistRemoteSearchEngine* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData* _ready_data;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->query_string = g_variant_dup_string (_tmp10_, NULL);
	g_variant_unref (_tmp10_);
	_ready_data->time_range = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filter_templates = g_variant_iter_next_value (&_arguments_iter);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->storage_state = g_variant_get_uint32 (_tmp11_);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->offset = g_variant_get_uint32 (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->count = g_variant_get_uint32 (_tmp13_);
	g_variant_unref (_tmp13_);
	_tmp14_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->result_type = g_variant_get_uint32 (_tmp14_);
	g_variant_unref (_tmp14_);
	zeitgeist_remote_search_engine_search_with_relevancies (self, _ready_data->query_string, _ready_data->time_range, _ready_data->filter_templates, _ready_data->storage_state, _ready_data->offset, _ready_data->count, _ready_data->result_type, NULL, (GAsyncReadyCallback) _dbus_zeitgeist_remote_search_engine_search_with_relevancies_ready, _ready_data);
	_error:
	;
}

static void
_dbus_zeitgeist_remote_search_engine_search_with_relevancies_ready (GObject * source_object,
                                                                    GAsyncResult * _res_,
                                                                    gpointer _user_data_)
{
	ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	GVariant* events = NULL;
	gdouble* relevancies = NULL;
	gint relevancies_length1 = 0;
	gdouble* _tmp15_;
	GVariantBuilder _tmp16_;
	gint _tmp17_;
	guint matches = 0U;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	zeitgeist_remote_search_engine_search_with_relevancies_finish ((ZeitgeistRemoteSearchEngine*) source_object, _res_, &events, &relevancies, &relevancies_length1, &matches, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, events);
	_tmp15_ = relevancies;
	g_variant_builder_init (&_tmp16_, G_VARIANT_TYPE ("ad"));
	for (_tmp17_ = 0; _tmp17_ < relevancies_length1; _tmp17_++) {
		g_variant_builder_add_value (&_tmp16_, g_variant_new_double (*_tmp15_));
		_tmp15_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp16_));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (matches));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->query_string);
	_g_variant_unref0 (_ready_data->time_range);
	_g_variant_unref0 (_ready_data->filter_templates);
	_g_variant_unref0 (events);
	relevancies = (g_free (relevancies), NULL);
	g_slice_free (ZeitgeistRemoteSearchEngineSearchWithRelevanciesReadyData, _ready_data);
}

static void
zeitgeist_remote_search_engine_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Search") == 0) {
		_dbus_zeitgeist_remote_search_engine_search (object, parameters, invocation);
	} else if (strcmp (method_name, "SearchWithRelevancies") == 0) {
		_dbus_zeitgeist_remote_search_engine_search_with_relevancies (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
zeitgeist_remote_search_engine_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
zeitgeist_remote_search_engine_dbus_interface_set_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GVariant* value,
                                                            GError** error,
                                                            gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
zeitgeist_remote_search_engine_register_object (gpointer object,
                                                GDBusConnection* connection,
                                                const gchar* path,
                                                GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_zeitgeist_remote_search_engine_dbus_interface_info), &_zeitgeist_remote_search_engine_dbus_interface_vtable, data, _zeitgeist_remote_search_engine_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_zeitgeist_remote_search_engine_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
zeitgeist_search_engine_get_instance_private (ZeitgeistSearchEngine* self)
{
	return G_STRUCT_MEMBER_P (self, ZeitgeistSearchEngine_private_offset);
}

static ZeitgeistSearchEngine*
zeitgeist_search_engine_construct (GType object_type)
{
	ZeitgeistSearchEngine * self = NULL;
	self = (ZeitgeistSearchEngine*) g_object_new (object_type, NULL);
	return self;
}

static ZeitgeistSearchEngine*
zeitgeist_search_engine_new (void)
{
	return zeitgeist_search_engine_construct (ZEITGEIST_TYPE_SEARCH_ENGINE);
}

static void
zeitgeist_search_engine_proxy_not_present (ZeitgeistSearchEngine* self)
{
	ZeitgeistMonitorManager* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->notifier;
	_tmp1_ = g_strdup (ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME);
	_tmp2_ = _tmp1_;
	zeitgeist_monitor_manager_remove_monitor (_tmp0_, _tmp2_, "/org/gnome/zeitgeist/monitor/special");
	_g_free0 (_tmp2_);
	zeitgeist_extension_unload ((ZeitgeistExtension*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
zeitgeist_search_engine_proxy_acquired (ZeitgeistSearchEngine* self,
                                        GObject* obj,
                                        GAsyncResult* res)
{
	GDBusConnection* conn = NULL;
	GDBusConnection* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (res != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (obj, g_dbus_connection_get_type ()) ? ((GDBusConnection*) obj) : NULL);
	conn = _tmp0_;
	{
		ZeitgeistRemoteSimpleIndexer* _tmp1_ = NULL;
		ZeitgeistRemoteSimpleIndexer* _tmp2_;
		ZeitgeistRemoteSimpleIndexer* _tmp3_;
		ZeitgeistRemoteSimpleIndexer* _tmp4_;
		ZeitgeistRemoteSimpleIndexer* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp2_ = g_async_result_get_source_object (res);
		_tmp3_ = (ZeitgeistRemoteSimpleIndexer*) g_async_initable_new_finish ((GAsyncInitable *) _tmp2_, res, &_inner_error0_);
		g_object_unref (_tmp2_);
		_tmp1_ = (ZeitgeistRemoteSimpleIndexer*) _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->siin);
		self->priv->siin = _tmp4_;
		_tmp5_ = self->priv->siin;
		g_object_get (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, g_dbus_proxy_get_type ()) ? ((GDBusProxy*) _tmp5_) : NULL, "g-name-owner", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_ == NULL;
		_g_free0 (_tmp8_);
		if (_tmp9_) {
			zeitgeist_search_engine_proxy_not_present (self);
			self->priv->siin_connection_failed = TRUE;
		} else {
			self->priv->siin_connection_failed = FALSE;
		}
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		self->priv->siin_connection_failed = TRUE;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_warning ("ext-fts.vala:138: %s", _tmp11_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (conn);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (conn);
}

static void
zeitgeist_search_engine_wait_for_proxy_data_free (gpointer _data)
{
	ZeitgeistSearchEngineWaitForProxyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineWaitForProxyData, _data_);
}

void
zeitgeist_search_engine_wait_for_proxy (ZeitgeistSearchEngine* self,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_)
{
	ZeitgeistSearchEngineWaitForProxyData* _data_;
	ZeitgeistSearchEngine* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ZeitgeistSearchEngineWaitForProxyData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_search_engine_wait_for_proxy_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	zeitgeist_search_engine_wait_for_proxy_co (_data_);
}

void
zeitgeist_search_engine_wait_for_proxy_finish (ZeitgeistSearchEngine* self,
                                               GAsyncResult* _res_,
                                               GError** error)
{
	ZeitgeistSearchEngineWaitForProxyData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
_zeitgeist_search_engine_wait_for_proxy_co_gsource_func (gpointer self)
{
	gboolean result;
	result = zeitgeist_search_engine_wait_for_proxy_co (self);
	return result;
}

static gboolean
zeitgeist_search_engine_wait_for_proxy_co (ZeitgeistSearchEngineWaitForProxyData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->i = 0;
	while (TRUE) {
		_data_->_tmp2_ = _data_->self->priv->siin;
		if (_data_->_tmp2_ == NULL) {
			_data_->_tmp1_ = _data_->i < 6;
		} else {
			_data_->_tmp1_ = FALSE;
		}
		if (_data_->_tmp1_) {
			_data_->_tmp0_ = !_data_->self->priv->siin_connection_failed;
		} else {
			_data_->_tmp0_ = FALSE;
		}
		if (!_data_->_tmp0_) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, (guint) 250, _zeitgeist_search_engine_wait_for_proxy_co_gsource_func, _data_, NULL);
		_data_->_tmp3_ = _data_->i;
		_data_->i = _data_->_tmp3_ + 1;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp5_ = _data_->self->priv->siin;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp4_ = TRUE;
	} else {
		_data_->_tmp6_ = _data_->self->priv->siin;
		_data_->_tmp4_ = !G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp6_, g_dbus_proxy_get_type ());
	}
	if (_data_->_tmp4_) {
		_data_->_tmp7_ = g_error_new_literal (ZEITGEIST_ENGINE_ERROR, ZEITGEIST_ENGINE_ERROR_DATABASE_ERROR, "Not connected to SimpleIndexer");
		_data_->_inner_error0_ = _data_->_tmp7_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_search_engine_real_unload (ZeitgeistExtension* base)
{
	ZeitgeistSearchEngine * self;
	GError* _inner_error0_ = NULL;
	self = (ZeitgeistSearchEngine*) base;
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp0_;
		_tmp0_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (self->priv->registration_id != ((guint) 0)) {
			g_dbus_connection_unregister_object (connection, self->priv->registration_id);
			self->priv->registration_id = (guint) 0;
		}
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = err;
		_tmp2_ = _tmp1_->message;
		g_warning ("ext-fts.vala:174: %s", _tmp2_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_debug ("ext-fts.vala:177: %s, this.ref_count = %u", "Zeitgeist.SearchEngine.unload", ((GObject*) self)->ref_count);
}

static void
zeitgeist_search_engine_real_search_data_free (gpointer _data)
{
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineSearchData, _data_);
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
zeitgeist_search_engine_real_search (ZeitgeistRemoteSearchEngine* base,
                                     const gchar* query_string,
                                     GVariant* time_range,
                                     GVariant* filter_templates,
                                     guint offset,
                                     guint count,
                                     guint result_type,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	ZeitgeistSearchEngine * self;
	ZeitgeistSearchEngineSearchData* _data_;
	ZeitgeistSearchEngine* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (query_string != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (filter_templates != NULL);
	self = (ZeitgeistSearchEngine*) base;
	_data_ = g_slice_new0 (ZeitgeistSearchEngineSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_search_engine_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query_string);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp1_;
	_tmp2_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_variant_ref0 (filter_templates);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp3_;
	_data_->offset = offset;
	_data_->count = count;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_search_engine_real_search_co (_data_);
}

static void
zeitgeist_search_engine_search_finish (ZeitgeistRemoteSearchEngine* base,
                                       GAsyncResult* _res_,
                                       GVariant** events,
                                       guint* matches,
                                       GError** error)
{
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}

static void
zeitgeist_search_engine_search_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	ZeitgeistSearchEngineSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_search_engine_real_search_co (_data_);
}

static gboolean
zeitgeist_search_engine_real_search_co (ZeitgeistSearchEngineSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->siin;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		zeitgeist_search_engine_wait_for_proxy (_data_->self, zeitgeist_search_engine_search_ready, _data_);
		return FALSE;
		_state_1:
		zeitgeist_search_engine_wait_for_proxy_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_variant_unref0 (_data_->events);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = g_timer_new ();
	_data_->timer = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->siin;
	_data_->_tmp3_ = NULL;
	_data_->_tmp4_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search (_data_->_tmp2_, _data_->query_string, _data_->time_range, _data_->filter_templates, _data_->offset, _data_->count, _data_->result_type, _data_->cancellable, zeitgeist_search_engine_search_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, &_data_->_tmp4_, &_data_->_inner_error0_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp3_;
	_data_->matches = _data_->_tmp4_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->timer);
		_g_variant_unref0 (_data_->events);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp5_ = _data_->events;
	_data_->_tmp6_ = _data_->timer;
	g_debug ("ext-fts.vala:191: Got %u[/%u] results from indexer (in %f seconds)", (guint) g_variant_n_children (_data_->_tmp5_), _data_->matches, g_timer_elapsed (_data_->_tmp6_, NULL));
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
zeitgeist_search_engine_real_search_with_relevancies_data_free (gpointer _data)
{
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	_data_ = _data;
	_g_free0 (_data_->query_string);
	_g_variant_unref0 (_data_->time_range);
	_g_variant_unref0 (_data_->filter_templates);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (ZeitgeistSearchEngineSearchWithRelevanciesData, _data_);
}

static void
zeitgeist_search_engine_real_search_with_relevancies (ZeitgeistRemoteSearchEngine* base,
                                                      const gchar* query_string,
                                                      GVariant* time_range,
                                                      GVariant* filter_templates,
                                                      guint storage_state,
                                                      guint offset,
                                                      guint count,
                                                      guint result_type,
                                                      GCancellable* cancellable,
                                                      GAsyncReadyCallback _callback_,
                                                      gpointer _user_data_)
{
	ZeitgeistSearchEngine * self;
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	ZeitgeistSearchEngine* _tmp0_;
	gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (query_string != NULL);
	g_return_if_fail (time_range != NULL);
	g_return_if_fail (filter_templates != NULL);
	self = (ZeitgeistSearchEngine*) base;
	_data_ = g_slice_new0 (ZeitgeistSearchEngineSearchWithRelevanciesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, zeitgeist_search_engine_real_search_with_relevancies_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (query_string);
	_g_free0 (_data_->query_string);
	_data_->query_string = _tmp1_;
	_tmp2_ = _g_variant_ref0 (time_range);
	_g_variant_unref0 (_data_->time_range);
	_data_->time_range = _tmp2_;
	_tmp3_ = _g_variant_ref0 (filter_templates);
	_g_variant_unref0 (_data_->filter_templates);
	_data_->filter_templates = _tmp3_;
	_data_->storage_state = storage_state;
	_data_->offset = offset;
	_data_->count = count;
	_data_->result_type = result_type;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	zeitgeist_search_engine_real_search_with_relevancies_co (_data_);
}

static void
zeitgeist_search_engine_search_with_relevancies_finish (ZeitgeistRemoteSearchEngine* base,
                                                        GAsyncResult* _res_,
                                                        GVariant** events,
                                                        gdouble** relevancies,
                                                        gint* relevancies_length1,
                                                        guint* matches,
                                                        GError** error)
{
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (events) {
		*events = _data_->events;
	} else {
		_g_variant_unref0 (_data_->events);
	}
	_data_->events = NULL;
	if (relevancies) {
		*relevancies = _data_->relevancies;
	} else {
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
	}
	if (relevancies_length1) {
		*relevancies_length1 = _data_->relevancies_length1;
	}
	_data_->relevancies = NULL;
	if (matches) {
		*matches = _data_->matches;
	}
}

static void
zeitgeist_search_engine_search_with_relevancies_ready (GObject* source_object,
                                                       GAsyncResult* _res_,
                                                       gpointer _user_data_)
{
	ZeitgeistSearchEngineSearchWithRelevanciesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	zeitgeist_search_engine_real_search_with_relevancies_co (_data_);
}

static gboolean
zeitgeist_search_engine_real_search_with_relevancies_co (ZeitgeistSearchEngineSearchWithRelevanciesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->siin;
	if (_data_->_tmp0_ == NULL) {
		_data_->_state_ = 1;
		zeitgeist_search_engine_wait_for_proxy (_data_->self, zeitgeist_search_engine_search_with_relevancies_ready, _data_);
		return FALSE;
		_state_1:
		zeitgeist_search_engine_wait_for_proxy_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_variant_unref0 (_data_->events);
			_data_->relevancies = (g_free (_data_->relevancies), NULL);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp1_ = g_timer_new ();
	_data_->timer = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->siin;
	_data_->_tmp3_ = NULL;
	_data_->_tmp4_ = NULL;
	_data_->_tmp5_ = 0;
	_data_->_tmp6_ = 0U;
	_data_->_state_ = 2;
	zeitgeist_remote_simple_indexer_search_with_relevancies (_data_->_tmp2_, _data_->query_string, _data_->time_range, _data_->filter_templates, _data_->storage_state, _data_->offset, _data_->count, _data_->result_type, _data_->cancellable, zeitgeist_search_engine_search_with_relevancies_ready, _data_);
	return FALSE;
	_state_2:
	zeitgeist_remote_simple_indexer_search_with_relevancies_finish (_data_->_tmp2_, _data_->_res_, &_data_->_tmp3_, &_data_->_tmp4_, &_data_->_tmp5_, &_data_->_tmp6_, &_data_->_inner_error0_);
	_g_variant_unref0 (_data_->events);
	_data_->events = _data_->_tmp3_;
	_data_->relevancies = (g_free (_data_->relevancies), NULL);
	_data_->relevancies = _data_->_tmp4_;
	_data_->relevancies_length1 = _data_->_tmp5_;
	_data_->matches = _data_->_tmp6_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_timer_destroy0 (_data_->timer);
		_g_variant_unref0 (_data_->events);
		_data_->relevancies = (g_free (_data_->relevancies), NULL);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = _data_->events;
	_data_->_tmp8_ = _data_->timer;
	g_debug ("ext-fts.vala:210: Got %u[/%u] results from indexer (in %f seconds)", (guint) g_variant_n_children (_data_->_tmp7_), _data_->matches, g_timer_elapsed (_data_->_tmp8_, NULL));
	_g_timer_destroy0 (_data_->timer);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static GVariant*
_variant_new1 (GHashTable* value)
{
	GVariantBuilder _tmp21_;
	GHashTableIter _tmp22_;
	gpointer _tmp23_;
	gpointer _tmp24_;
	g_hash_table_iter_init (&_tmp22_, value);
	g_variant_builder_init (&_tmp21_, G_VARIANT_TYPE ("a{ss}"));
	while (g_hash_table_iter_next (&_tmp22_, &_tmp23_, &_tmp24_)) {
		gchar* _key;
		gchar* _value;
		_key = (gchar*) _tmp23_;
		_value = (gchar*) _tmp24_;
		g_variant_builder_add (&_tmp21_, "{?*}", g_variant_new_string (_key), g_variant_new_string (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp21_));
}

static void
_zeitgeist_search_engine_proxy_acquired_gasync_ready_callback (GObject* source_object,
                                                               GAsyncResult* res,
                                                               gpointer self)
{
	zeitgeist_search_engine_proxy_acquired ((ZeitgeistSearchEngine*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
zeitgeist_search_engine_constructor (GType type,
                                     guint n_construct_properties,
                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ZeitgeistSearchEngine * self;
	ZeitgeistMonitorManager* _tmp0_;
	ZeitgeistMonitorManager* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	ZeitgeistTimeRange* _tmp4_;
	ZeitgeistTimeRange* _tmp5_;
	GPtrArray* _tmp6_;
	GPtrArray* _tmp7_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (zeitgeist_search_engine_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine);
	if (zeitgeist_utils_using_in_memory_database ()) {
		return obj;
	}
	_tmp0_ = zeitgeist_monitor_manager_get_default ();
	_g_object_unref0 (self->priv->notifier);
	self->priv->notifier = _tmp0_;
	_tmp1_ = self->priv->notifier;
	_tmp2_ = g_strdup (ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME);
	_tmp3_ = _tmp2_;
	_tmp4_ = zeitgeist_time_range_new_anytime ();
	_tmp5_ = _tmp4_;
	_tmp6_ = g_ptr_array_new_full ((guint) 0, _g_object_unref0_);
	_tmp7_ = _tmp6_;
	zeitgeist_monitor_manager_install_monitor (_tmp1_, _tmp3_, "/org/gnome/zeitgeist/monitor/special", _tmp5_, _tmp7_);
	_g_ptr_array_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_free0 (_tmp3_);
	{
		GDBusConnection* connection = NULL;
		GDBusConnection* _tmp8_;
		guint _tmp9_ = 0U;
		GDBusConnection* _tmp10_;
		guint _tmp11_;
		GDBusConnection* _tmp30_;
		_tmp8_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error0_);
		connection = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp10_ = connection;
		_tmp11_ = zeitgeist_remote_search_engine_register_object ((ZeitgeistRemoteSearchEngine*) self, _tmp10_, "/org/gnome/zeitgeist/index/activity", &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch0_g_error;
		}
		self->priv->registration_id = _tmp9_;
		{
			GHashTable* env = NULL;
			GHashFunc _tmp12_;
			GEqualFunc _tmp13_;
			GHashTable* _tmp14_;
			GHashTable* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			GDBusConnection* _tmp19_;
			GHashTable* _tmp20_;
			GVariant* _tmp25_;
			GVariant** _tmp26_;
			GVariant** _tmp27_;
			gint _tmp27__length1;
			GVariant* _tmp28_;
			GVariant* _tmp29_;
			_tmp12_ = g_str_hash;
			_tmp13_ = g_str_equal;
			_tmp14_ = g_hash_table_new_full (_tmp12_, _tmp13_, _g_free0_, _g_free0_);
			env = _tmp14_;
			_tmp15_ = env;
			_tmp16_ = g_strdup ("ZEITGEIST_DATA_PATH");
			_tmp17_ = zeitgeist_utils_get_data_path ();
			_tmp18_ = g_strdup (_tmp17_);
			g_hash_table_insert (_tmp15_, _tmp16_, _tmp18_);
			_tmp19_ = connection;
			_tmp20_ = env;
			_tmp25_ = _variant_new1 (_tmp20_);
			_tmp26_ = g_new0 (GVariant*, 1 + 1);
			_tmp26_[0] = _tmp25_;
			_tmp27_ = _tmp26_;
			_tmp27__length1 = 1;
			_tmp28_ = g_variant_new_tuple (_tmp27_, 1);
			g_variant_ref_sink (_tmp28_);
			_tmp29_ = _tmp28_;
			g_dbus_connection_call (_tmp19_, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus", "UpdateActivationEnvironment", _tmp29_, NULL, 0, -1, NULL, NULL, NULL);
			_g_variant_unref0 (_tmp29_);
			_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_variant_unref), NULL);
			_g_hash_table_unref0 (env);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
			g_warning ("ext-fts.vala:97: Unable to set environment for FTS daemon!");
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (connection);
			goto __catch0_g_error;
		}
		_tmp30_ = connection;
		g_async_initable_new_async (ZEITGEIST_TYPE_REMOTE_SIMPLE_INDEXER_PROXY, 0, NULL, _zeitgeist_search_engine_proxy_acquired_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", ZEITGEIST_SEARCH_ENGINE_INDEXER_NAME, "g-connection", _tmp30_, "g-object-path", "/org/gnome/zeitgeist/index/activity", "g-interface-name", "org.gnome.zeitgeist.Index", NULL);
		_g_object_unref0 (connection);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp31_ = err;
		_tmp32_ = _tmp31_->message;
		g_warning ("ext-fts.vala:109: %s", _tmp32_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
zeitgeist_search_engine_class_init (ZeitgeistSearchEngineClass * klass,
                                    gpointer klass_data)
{
	zeitgeist_search_engine_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ZeitgeistSearchEngine_private_offset);
	((ZeitgeistExtensionClass *) klass)->unload = (void (*) (ZeitgeistExtension*)) zeitgeist_search_engine_real_unload;
	G_OBJECT_CLASS (klass)->constructor = zeitgeist_search_engine_constructor;
	G_OBJECT_CLASS (klass)->finalize = zeitgeist_search_engine_finalize;
}

static void
zeitgeist_search_engine_zeitgeist_remote_search_engine_interface_init (ZeitgeistRemoteSearchEngineIface * iface,
                                                                       gpointer iface_data)
{
	zeitgeist_search_engine_zeitgeist_remote_search_engine_parent_iface = g_type_interface_peek_parent (iface);
	iface->search = (void (*) (ZeitgeistRemoteSearchEngine*, const gchar*, GVariant*, GVariant*, guint, guint, guint, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_search_engine_real_search;
	iface->search_finish = (void (*) (ZeitgeistRemoteSearchEngine*, GAsyncResult*, GVariant**, guint*, GError**)) zeitgeist_search_engine_search_finish;
	iface->search_with_relevancies = (void (*) (ZeitgeistRemoteSearchEngine*, const gchar*, GVariant*, GVariant*, guint, guint, guint, guint, GCancellable*, GAsyncReadyCallback, gpointer)) zeitgeist_search_engine_real_search_with_relevancies;
	iface->search_with_relevancies_finish = (void (*) (ZeitgeistRemoteSearchEngine*, GAsyncResult*, GVariant**, gdouble**, gint*, guint*, GError**)) zeitgeist_search_engine_search_with_relevancies_finish;
}

static void
zeitgeist_search_engine_instance_init (ZeitgeistSearchEngine * self,
                                       gpointer klass)
{
	self->priv = zeitgeist_search_engine_get_instance_private (self);
	self->priv->siin_connection_failed = FALSE;
}

static void
zeitgeist_search_engine_finalize (GObject * obj)
{
	ZeitgeistSearchEngine * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZEITGEIST_TYPE_SEARCH_ENGINE, ZeitgeistSearchEngine);
	_g_object_unref0 (self->priv->siin);
	_g_object_unref0 (self->priv->notifier);
	G_OBJECT_CLASS (zeitgeist_search_engine_parent_class)->finalize (obj);
}

GType
zeitgeist_search_engine_get_type (void)
{
	return zeitgeist_search_engine_type_id;
}

GType
zeitgeist_search_engine_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (ZeitgeistSearchEngineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zeitgeist_search_engine_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ZeitgeistSearchEngine), 0, (GInstanceInitFunc) zeitgeist_search_engine_instance_init, NULL };
	static const GInterfaceInfo zeitgeist_remote_search_engine_info = { (GInterfaceInitFunc) zeitgeist_search_engine_zeitgeist_remote_search_engine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	zeitgeist_search_engine_type_id = g_type_module_register_type (module, ZEITGEIST_TYPE_EXTENSION, "ZeitgeistSearchEngine", &g_define_type_info, 0);
	g_type_module_add_interface (module, zeitgeist_search_engine_type_id, ZEITGEIST_TYPE_REMOTE_SEARCH_ENGINE, &zeitgeist_remote_search_engine_info);
	ZeitgeistSearchEngine_private_offset = sizeof (ZeitgeistSearchEnginePrivate);
	return zeitgeist_search_engine_type_id;
}

GType
zeitgeist_fts_init (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	zeitgeist_remote_search_engine_register_type (module);
	zeitgeist_remote_search_engine_proxy_register_dynamic_type (module);
	zeitgeist_search_engine_register_type (module);
	result = ZEITGEIST_TYPE_SEARCH_ENGINE;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

