/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSClipboard.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSClipboardItem.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "Navigator.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include "WorkerNavigator.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsClipboardPrototypeFunction_read);
static JSC_DECLARE_HOST_FUNCTION(jsClipboardPrototypeFunction_readText);
static JSC_DECLARE_HOST_FUNCTION(jsClipboardPrototypeFunction_write);
static JSC_DECLARE_HOST_FUNCTION(jsClipboardPrototypeFunction_writeText);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsClipboardConstructor);

class JSClipboardPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSClipboardPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSClipboardPrototype* ptr = new (NotNull, JSC::allocateCell<JSClipboardPrototype>(vm)) JSClipboardPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSClipboardPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSClipboardPrototype, JSClipboardPrototype::Base);

using JSClipboardDOMConstructor = JSDOMConstructorNotConstructable<JSClipboard>;

template<> const ClassInfo JSClipboardDOMConstructor::s_info = { "Clipboard"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardDOMConstructor) };

template<> JSValue JSClipboardDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSClipboardDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Clipboard"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSClipboard::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 5> JSClipboardPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsClipboardConstructor, 0 } },
    HashTableValue { "read"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardPrototypeFunction_read, 0 } },
    HashTableValue { "readText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardPrototypeFunction_readText, 0 } },
    HashTableValue { "write"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardPrototypeFunction_write, 1 } },
    HashTableValue { "writeText"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsClipboardPrototypeFunction_writeText, 1 } },
};

const ClassInfo JSClipboardPrototype::s_info = { "Clipboard"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboardPrototype) };

void JSClipboardPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSClipboard::info(), JSClipboardPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSClipboard::s_info = { "Clipboard"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSClipboard) };

JSClipboard::JSClipboard(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Clipboard>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<Clipboard> JSClipboard::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, Clipboard>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSClipboard::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSClipboardPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSClipboardPrototype::create(vm, &globalObject, structure);
}

JSObject* JSClipboard::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSClipboard>(vm, globalObject);
}

JSValue JSClipboard::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSClipboardDOMConstructor, DOMConstructorID::Clipboard>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsClipboardConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSClipboardPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSClipboard::getConstructor(vm, prototype->globalObject()));
}

static inline JSC::EncodedJSValue jsClipboardPrototypeFunction_readBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboard>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLSequence<IDLInterface<ClipboardItem>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.read(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardPrototypeFunction_read, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSClipboard>::call<jsClipboardPrototypeFunction_readBody>(*lexicalGlobalObject, *callFrame, "read");
}

static inline JSC::EncodedJSValue jsClipboardPrototypeFunction_readTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboard>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.readText(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardPrototypeFunction_readText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSClipboard>::call<jsClipboardPrototypeFunction_readTextBody>(*lexicalGlobalObject, *callFrame, "readText");
}

static inline JSC::EncodedJSValue jsClipboardPrototypeFunction_writeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboard>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLSequence<IDLInterface<ClipboardItem>>>(*lexicalGlobalObject, argument0.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.write(dataConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardPrototypeFunction_write, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSClipboard>::call<jsClipboardPrototypeFunction_writeBody>(*lexicalGlobalObject, *callFrame, "write");
}

static inline JSC::EncodedJSValue jsClipboardPrototypeFunction_writeTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSClipboard>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto dataConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (dataConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.writeText(dataConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsClipboardPrototypeFunction_writeText, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSClipboard>::call<jsClipboardPrototypeFunction_writeTextBody>(*lexicalGlobalObject, *callFrame, "writeText");
}

JSC::GCClient::IsoSubspace* JSClipboard::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSClipboard, UseCustomHeapCellType::No>(vm, "JSClipboard"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForClipboard.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForClipboard = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForClipboard.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForClipboard = std::forward<decltype(space)>(space); }
    );
}

void JSClipboard::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSClipboard*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSClipboardOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsClipboard = jsCast<JSClipboard*>(handle.slot()->asCell());
    NavigatorBase* owner = WTF::getPtr(jsClipboard->wrapped().navigator());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Navigator"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSClipboardOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsClipboard = static_cast<JSClipboard*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsClipboard->protectedWrapped().ptr(), jsClipboard);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Clipboard@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9ClipboardE[]; }
#endif
template<std::same_as<Clipboard> T>
static inline void verifyVTable(Clipboard* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Clipboard@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore9ClipboardE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Clipboard has subclasses. If Clipboard has subclasses that get passed
        // to toJS() we currently require Clipboard you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Clipboard>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Clipboard>(impl.ptr());
#endif
    return createWrapper<Clipboard>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Clipboard& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Clipboard* JSClipboard::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSClipboard*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
