// This file is generated by "./lib/proto/generate"

package proto

/*

Autofill

Defines commands and events for Autofill.

*/

// AutofillCreditCard ...
type AutofillCreditCard struct {
	// Number 16-digit credit card number.
	Number string `json:"number"`

	// Name of the credit card owner.
	Name string `json:"name"`

	// ExpiryMonth 2-digit expiry month.
	ExpiryMonth string `json:"expiryMonth"`

	// ExpiryYear 4-digit expiry year.
	ExpiryYear string `json:"expiryYear"`

	// Cvc 3-digit card verification code.
	Cvc string `json:"cvc"`
}

// AutofillAddressField ...
type AutofillAddressField struct {
	// Name address field name, for example GIVEN_NAME.
	Name string `json:"name"`

	// Value address field value, for example Jon Doe.
	Value string `json:"value"`
}

// AutofillAddressFields A list of address fields.
type AutofillAddressFields struct {
	// Fields ...
	Fields []*AutofillAddressField `json:"fields"`
}

// AutofillAddress ...
type AutofillAddress struct {
	// Fields fields and values defining an address.
	Fields []*AutofillAddressField `json:"fields"`
}

// AutofillAddressUI Defines how an address can be displayed like in chrome://settings/addresses.
// Address UI is a two dimensional array, each inner array is an "address information line", and when rendered in a UI surface should be displayed as such.
// The following address UI for instance:
// [[{name: "GIVE_NAME", value: "Jon"}, {name: "FAMILY_NAME", value: "Doe"}], [{name: "CITY", value: "Munich"}, {name: "ZIP", value: "81456"}]]
// should allow the receiver to render:
// Jon Doe
// Munich 81456.
type AutofillAddressUI struct {
	// AddressFields A two dimension array containing the representation of values from an address profile.
	AddressFields []*AutofillAddressFields `json:"addressFields"`
}

// AutofillFillingStrategy Specified whether a filled field was done so by using the html autocomplete attribute or autofill heuristics.
type AutofillFillingStrategy string

const (
	// AutofillFillingStrategyAutocompleteAttribute enum const.
	AutofillFillingStrategyAutocompleteAttribute AutofillFillingStrategy = "autocompleteAttribute"

	// AutofillFillingStrategyAutofillInferred enum const.
	AutofillFillingStrategyAutofillInferred AutofillFillingStrategy = "autofillInferred"
)

// AutofillFilledField ...
type AutofillFilledField struct {
	// HTMLType The type of the field, e.g text, password etc.
	HTMLType string `json:"htmlType"`

	// ID the html id
	ID string `json:"id"`

	// Name the html name
	Name string `json:"name"`

	// Value the field value
	Value string `json:"value"`

	// AutofillType The actual field type, e.g FAMILY_NAME
	AutofillType string `json:"autofillType"`

	// FillingStrategy The filling strategy
	FillingStrategy AutofillFillingStrategy `json:"fillingStrategy"`

	// FrameID The frame the field belongs to
	FrameID PageFrameID `json:"frameId"`

	// FieldID The form field's DOM node
	FieldID DOMBackendNodeID `json:"fieldId"`
}

// AutofillTrigger Trigger autofill on a form identified by the fieldId.
// If the field and related form cannot be autofilled, returns an error.
type AutofillTrigger struct {
	// FieldID Identifies a field that serves as an anchor for autofill.
	FieldID DOMBackendNodeID `json:"fieldId"`

	// FrameID (optional) Identifies the frame that field belongs to.
	FrameID PageFrameID `json:"frameId,omitempty"`

	// Card Credit card information to fill out the form. Credit card data is not saved.
	Card *AutofillCreditCard `json:"card"`
}

// ProtoReq name.
func (m AutofillTrigger) ProtoReq() string { return "Autofill.trigger" }

// Call sends the request.
func (m AutofillTrigger) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AutofillSetAddresses Set addresses so that developers can verify their forms implementation.
type AutofillSetAddresses struct {
	// Addresses ...
	Addresses []*AutofillAddress `json:"addresses"`
}

// ProtoReq name.
func (m AutofillSetAddresses) ProtoReq() string { return "Autofill.setAddresses" }

// Call sends the request.
func (m AutofillSetAddresses) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AutofillDisable Disables autofill domain notifications.
type AutofillDisable struct{}

// ProtoReq name.
func (m AutofillDisable) ProtoReq() string { return "Autofill.disable" }

// Call sends the request.
func (m AutofillDisable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AutofillEnable Enables autofill domain notifications.
type AutofillEnable struct{}

// ProtoReq name.
func (m AutofillEnable) ProtoReq() string { return "Autofill.enable" }

// Call sends the request.
func (m AutofillEnable) Call(c Client) error {
	return call(m.ProtoReq(), m, nil, c)
}

// AutofillAddressFormFilled Emitted when an address form is filled.
type AutofillAddressFormFilled struct {
	// FilledFields Information about the fields that were filled
	FilledFields []*AutofillFilledField `json:"filledFields"`

	// AddressUI An UI representation of the address used to fill the form.
	// Consists of a 2D array where each child represents an address/profile line.
	AddressUI *AutofillAddressUI `json:"addressUi"`
}

// ProtoEvent name.
func (evt AutofillAddressFormFilled) ProtoEvent() string {
	return "Autofill.addressFormFilled"
}
