// Code generated by go-swagger; DO NOT EDIT.

package project_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ProjectServiceGetIamPolicyReader is a Reader for the ProjectServiceGetIamPolicy structure.
type ProjectServiceGetIamPolicyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProjectServiceGetIamPolicyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProjectServiceGetIamPolicyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProjectServiceGetIamPolicyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProjectServiceGetIamPolicyOK creates a ProjectServiceGetIamPolicyOK with default headers values
func NewProjectServiceGetIamPolicyOK() *ProjectServiceGetIamPolicyOK {
	return &ProjectServiceGetIamPolicyOK{}
}

/*
ProjectServiceGetIamPolicyOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProjectServiceGetIamPolicyOK struct {
	Payload *models.HashicorpCloudResourcemanagerProjectGetIamPolicyResponse
}

// IsSuccess returns true when this project service get iam policy o k response has a 2xx status code
func (o *ProjectServiceGetIamPolicyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this project service get iam policy o k response has a 3xx status code
func (o *ProjectServiceGetIamPolicyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this project service get iam policy o k response has a 4xx status code
func (o *ProjectServiceGetIamPolicyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this project service get iam policy o k response has a 5xx status code
func (o *ProjectServiceGetIamPolicyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this project service get iam policy o k response a status code equal to that given
func (o *ProjectServiceGetIamPolicyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the project service get iam policy o k response
func (o *ProjectServiceGetIamPolicyOK) Code() int {
	return 200
}

func (o *ProjectServiceGetIamPolicyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/{id}/iam-policy][%d] projectServiceGetIamPolicyOK %s", 200, payload)
}

func (o *ProjectServiceGetIamPolicyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/{id}/iam-policy][%d] projectServiceGetIamPolicyOK %s", 200, payload)
}

func (o *ProjectServiceGetIamPolicyOK) GetPayload() *models.HashicorpCloudResourcemanagerProjectGetIamPolicyResponse {
	return o.Payload
}

func (o *ProjectServiceGetIamPolicyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerProjectGetIamPolicyResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProjectServiceGetIamPolicyDefault creates a ProjectServiceGetIamPolicyDefault with default headers values
func NewProjectServiceGetIamPolicyDefault(code int) *ProjectServiceGetIamPolicyDefault {
	return &ProjectServiceGetIamPolicyDefault{
		_statusCode: code,
	}
}

/*
ProjectServiceGetIamPolicyDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProjectServiceGetIamPolicyDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this project service get iam policy default response has a 2xx status code
func (o *ProjectServiceGetIamPolicyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this project service get iam policy default response has a 3xx status code
func (o *ProjectServiceGetIamPolicyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this project service get iam policy default response has a 4xx status code
func (o *ProjectServiceGetIamPolicyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this project service get iam policy default response has a 5xx status code
func (o *ProjectServiceGetIamPolicyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this project service get iam policy default response a status code equal to that given
func (o *ProjectServiceGetIamPolicyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the project service get iam policy default response
func (o *ProjectServiceGetIamPolicyDefault) Code() int {
	return o._statusCode
}

func (o *ProjectServiceGetIamPolicyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/{id}/iam-policy][%d] ProjectService_GetIamPolicy default %s", o._statusCode, payload)
}

func (o *ProjectServiceGetIamPolicyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/projects/{id}/iam-policy][%d] ProjectService_GetIamPolicy default %s", o._statusCode, payload)
}

func (o *ProjectServiceGetIamPolicyDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ProjectServiceGetIamPolicyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
