/* valatypeparameter.c generated by valac, the Vala compiler
 * generated from valatypeparameter.vala, do not modify */

/* valatypeparameter.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

static gpointer vala_typeparameter_parent_class = NULL;

static void vala_typeparameter_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static GType vala_typeparameter_get_type_once (void);

/**
 * Creates a new generic type parameter.
 *
 * @param name              parameter name
 * @param source_reference  reference to source code
 * @return                  newly created generic type parameter
 */
ValaTypeParameter*
vala_typeparameter_construct (GType object_type,
                              const gchar* name,
                              ValaSourceReference* source_reference)
{
	ValaTypeParameter* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaTypeParameter*) vala_typesymbol_construct (object_type, name, source_reference, NULL);
	vala_symbol_set_access ((ValaSymbol*) self, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	return self;
}

ValaTypeParameter*
vala_typeparameter_new (const gchar* name,
                        ValaSourceReference* source_reference)
{
	return vala_typeparameter_construct (VALA_TYPE_TYPEPARAMETER, name, source_reference);
}

static void
vala_typeparameter_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaTypeParameter * self;
	self = (ValaTypeParameter*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_type_parameter (visitor, self);
}

/**
 * Checks two type parameters for equality.
 *
 * @param param2 a type parameter
 * @return      true if this type parameter is equal to param2, false
 *              otherwise
 */
gboolean
vala_typeparameter_equals (ValaTypeParameter* self,
                           ValaTypeParameter* param2)
{
	gboolean _tmp0_ = FALSE;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	ValaScope* _tmp3_;
	ValaScope* _tmp4_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (param2 != NULL, FALSE);
	_tmp1_ = vala_symbol_get_owner ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_owner ((ValaSymbol*) param2);
	_tmp4_ = _tmp3_;
	if (!vala_scope_is_subscope_of (_tmp2_, _tmp4_)) {
		ValaScope* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaScope* _tmp8_;
		_tmp5_ = vala_symbol_get_owner ((ValaSymbol*) param2);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_symbol_get_owner ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp0_ = !vala_scope_is_subscope_of (_tmp6_, _tmp8_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "internal error: comparing type parameters from different scopes");
		result = FALSE;
		return result;
	}
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_symbol_get_name ((ValaSymbol*) param2);
	_tmp15_ = _tmp14_;
	if (g_strcmp0 (_tmp13_, _tmp15_) == 0) {
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_parent_symbol ((ValaSymbol*) param2);
		_tmp19_ = _tmp18_;
		_tmp11_ = _tmp17_ == _tmp19_;
	} else {
		_tmp11_ = FALSE;
	}
	result = _tmp11_;
	return result;
}

static void
vala_typeparameter_class_init (ValaTypeParameterClass * klass,
                               gpointer klass_data)
{
	vala_typeparameter_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_typeparameter_real_accept;
}

static void
vala_typeparameter_instance_init (ValaTypeParameter * self,
                                  gpointer klass)
{
}

/**
 * Represents a generic type parameter in the source code.
 */
static GType
vala_typeparameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaTypeParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeparameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeParameter), 0, (GInstanceInitFunc) vala_typeparameter_instance_init, NULL };
	GType vala_typeparameter_type_id;
	vala_typeparameter_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaTypeParameter", &g_define_type_info, 0);
	return vala_typeparameter_type_id;
}

GType
vala_typeparameter_get_type (void)
{
	static volatile gsize vala_typeparameter_type_id__once = 0;
	if (g_once_init_enter (&vala_typeparameter_type_id__once)) {
		GType vala_typeparameter_type_id;
		vala_typeparameter_type_id = vala_typeparameter_get_type_once ();
		g_once_init_leave (&vala_typeparameter_type_id__once, vala_typeparameter_type_id);
	}
	return vala_typeparameter_type_id__once;
}

