const char metrics_tarantool_lua[] =
"local log = require(\"log\")\n"
"\n"
"local metrics_api = require('metrics.api')\n"
"local utils = require('metrics.utils')\n"
"local const = require('metrics.const')\n"
"\n"
"local default_metrics = {\n"
"    network             = require('metrics.tarantool.network'),\n"
"    operations          = require('metrics.tarantool.operations'),\n"
"    system              = require('metrics.tarantool.system'),\n"
"    replicas            = require('metrics.tarantool.replicas'),\n"
"    info                = require('metrics.tarantool.info'),\n"
"    slab                = require('metrics.tarantool.slab'),\n"
"    runtime             = require('metrics.tarantool.runtime'),\n"
"    memory              = require('metrics.tarantool.memory'),\n"
"    spaces              = require('metrics.tarantool.spaces'),\n"
"    fibers              = require('metrics.tarantool.fibers'),\n"
"    cpu                 = require('metrics.tarantool.cpu'),\n"
"    vinyl               = require('metrics.tarantool.vinyl'),\n"
"    memtx               = require('metrics.tarantool.memtx'),\n"
"    luajit              = require('metrics.tarantool.luajit'),\n"
"    cartridge_issues    = require('metrics.cartridge.issues'),\n"
"    cartridge_failover  = require('metrics.cartridge.failover'),\n"
"    clock               = require('metrics.tarantool.clock'),\n"
"    event_loop          = require('metrics.tarantool.event_loop'),\n"
"}\n"
"\n"
"local function check_metrics_name(name, raise_if_unknown)\n"
"    if default_metrics[name] == nil then\n"
"        if raise_if_unknown then\n"
"            error(string.format(\"Unknown metrics %q provided\", name))\n"
"        else\n"
"            log.warn(\"Unknown metrics %q provided, this will raise an error in the future\", name)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function enable_impl(include, exclude, raise_if_unknown)\n"
"    include = include or const.ALL\n"
"    exclude = exclude or {}\n"
"\n"
"    local include_map = {}\n"
"\n"
"    if include == const.ALL then\n"
"        for name, _ in pairs(default_metrics) do\n"
"            include_map[name] = true\n"
"        end\n"
"    elseif type(include) == 'table' then\n"
"        for _, name in pairs(include) do\n"
"            check_metrics_name(name, raise_if_unknown)\n"
"            include_map[name] = true\n"
"        end\n"
"    elseif include == const.NONE then\n"
"        include_map = {}\n"
"    else\n"
"        error('Unexpected value provided: include must be \"all\", {...} or \"none\"')\n"
"    end\n"
"\n"
"    for _, name in pairs(exclude) do\n"
"        check_metrics_name(name, raise_if_unknown)\n"
"        include_map[name] = false\n"
"    end\n"
"\n"
"    for name, value in pairs(default_metrics) do\n"
"        if include_map[name] then\n"
"            metrics_api.register_callback(value.update)\n"
"        else\n"
"            metrics_api.unregister_callback(value.update)\n"
"            utils.delete_collectors(value.list)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function is_empty_table(v)\n"
"    return (type(v) == 'table') and (next(v) == nil)\n"
"end\n"
"\n"
"local function enable(include, exclude)\n"
"    -- Compatibility with v1.\n"
"    if is_empty_table(include) then\n"
"        log.warn('Providing {} in enable_default_metrics include is treated ' ..\n"
"                 'as a default value now (i.e. include all), ' ..\n"
"                 'but it will change in the future. Use \"all\" instead')\n"
"        include = const.ALL\n"
"    end\n"
"\n"
"    return enable_impl(include, exclude, false)\n"
"end\n"
"\n"
"local function enable_v2(include, exclude)\n"
"    return enable_impl(include, exclude, true)\n"
"end\n"
"\n"
"return {\n"
"    enable = enable,\n"
"    enable_v2 = enable_v2,\n"
"}\n"
""
;
