const char load_cfg_lua[] =
"-- load_cfg.lua - internal file\n"
"\n"
"local log = require('log')\n"
"local json = require('json')\n"
"local private = box.internal\n"
"local urilib = require('uri')\n"
"local math = require('math')\n"
"local fiber = require('fiber')\n"
"local fio = require('fio')\n"
"local compat = require('compat')\n"
"\n"
"local function nop() end\n"
"\n"
"-- Function decorator that is used to prevent box.cfg() from\n"
"-- being called concurrently by different fibers.\n"
"local lock = fiber.channel(1)\n"
"local function locked(f)\n"
"    return function(...)\n"
"        lock:put(true)\n"
"        local status, err = pcall(f, ...)\n"
"        lock:get()\n"
"        if not status then\n"
"            error(err)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function is_locked()\n"
"    return lock:is_full()\n"
"end\n"
"\n"
"--\n"
"-- When a feature is disabled, every single mentioning of it should\n"
"-- be eliminated. Even box.cfg{} should not accept any parameters\n"
"-- related to the feature as valid. This is why they are set to nil\n"
"-- when the feature is disabled.\n"
"--\n"
"\n"
"-- Feedback daemon.\n"
"local function ifdef_feedback(value)\n"
"    if private.feedback_daemon ~= nil then\n"
"        return value\n"
"    end\n"
"end\n"
"\n"
"local ifdef_feedback_set_params =\n"
"    private.feedback_daemon ~= nil and\n"
"    private.feedback_daemon.set_feedback_params or nil\n"
"\n"
"-- Audit log.\n"
"local has_audit = pcall(require, 'audit')\n"
"\n"
"local function ifdef_audit(value)\n"
"    if has_audit then\n"
"        return value\n"
"    end\n"
"end\n"
"\n"
"-- Flight recorder.\n"
"local has_flightrec, flightrec = pcall(require, 'flightrec')\n"
"\n"
"local function ifdef_flightrec(value)\n"
"    if has_flightrec then\n"
"        return value\n"
"    end\n"
"end\n"
"\n"
"local ifdef_flightrec_set_params = has_flightrec and flightrec.cfg or nil\n"
"\n"
"-- WAL extensions.\n"
"local function ifdef_wal_ext(value)\n"
"    if private.cfg_set_wal_ext ~= nil then\n"
"        return value\n"
"    end\n"
"end\n"
"\n"
"-- Security enhancements.\n"
"local function ifdef_security(value)\n"
"    if private.cfg_set_security ~= nil then\n"
"        return value\n"
"    end\n"
"end\n"
"\n"
"-- all available options\n"
"local default_cfg = {\n"
"    listen              = nil,\n"
"    memtx_memory        = 256 * 1024 *1024,\n"
"    strip_core          = true,\n"
"    memtx_min_tuple_size = 16,\n"
"    memtx_max_tuple_size = 1024 * 1024,\n"
"    slab_alloc_granularity = 8,\n"
"    slab_alloc_factor   = 1.05,\n"
"    iproto_threads      = 1,\n"
"    memtx_allocator     = \"small\",\n"
"    work_dir            = nil,\n"
"    memtx_dir           = \".\",\n"
"    wal_dir             = \".\",\n"
"\n"
"    vinyl_dir           = '.',\n"
"    vinyl_memory        = 128 * 1024 * 1024,\n"
"    vinyl_cache         = 128 * 1024 * 1024,\n"
"    vinyl_max_tuple_size = 1024 * 1024,\n"
"    vinyl_read_threads  = 1,\n"
"    vinyl_write_threads = 4,\n"
"    vinyl_timeout       = 60,\n"
"    vinyl_defer_deletes = false,\n"
"    vinyl_run_count_per_level = 2,\n"
"    vinyl_run_size_ratio      = 3.5,\n"
"    vinyl_range_size          = nil, -- set automatically\n"
"    vinyl_page_size           = 8 * 1024,\n"
"    vinyl_bloom_fpr           = 0.05,\n"
"\n"
"    log                 = log.cfg.log,\n"
"    log_nonblock        = log.cfg.nonblock,\n"
"    log_level           = log.cfg.level,\n"
"    log_modules         = log.cfg.modules,\n"
"    log_format          = log.cfg.format,\n"
"\n"
"    audit_log           = ifdef_audit(nil),\n"
"    audit_nonblock      = ifdef_audit(true),\n"
"    audit_format        = ifdef_audit('json'),\n"
"    audit_filter        = ifdef_audit('compatibility'),\n"
"\n"
"    auth_type           = 'chap-sha1',\n"
"    auth_delay          = ifdef_security(0),\n"
"    disable_guest       = ifdef_security(false),\n"
"    password_lifetime_days = ifdef_security(0),\n"
"    password_min_length = ifdef_security(0),\n"
"    password_enforce_uppercase = ifdef_security(false),\n"
"    password_enforce_lowercase = ifdef_security(false),\n"
"    password_enforce_digits = ifdef_security(false),\n"
"    password_enforce_specialchars = ifdef_security(false),\n"
"    password_history_length = ifdef_security(0),\n"
"\n"
"    flightrec_enabled = ifdef_flightrec(false),\n"
"    flightrec_logs_size = ifdef_flightrec(10485760),\n"
"    flightrec_logs_max_msg_size = ifdef_flightrec(4096),\n"
"    flightrec_logs_log_level = ifdef_flightrec(6),\n"
"    flightrec_metrics_interval = ifdef_flightrec(1.0),\n"
"    flightrec_metrics_period = ifdef_flightrec(60 * 3),\n"
"    flightrec_requests_size = ifdef_flightrec(10485760),\n"
"    flightrec_requests_max_req_size = ifdef_flightrec(16384),\n"
"    flightrec_requests_max_res_size = ifdef_flightrec(16384),\n"
"\n"
"    io_collect_interval = nil,\n"
"    readahead           = 16320,\n"
"    snap_io_rate_limit  = nil, -- no limit\n"
"    too_long_threshold  = 0.5,\n"
"    wal_mode            = \"write\",\n"
"    wal_max_size        = 256 * 1024 * 1024,\n"
"    wal_dir_rescan_delay= 2,\n"
"    wal_queue_max_size  = 16 * 1024 * 1024,\n"
"    wal_cleanup_delay   = 4 * 3600,\n"
"    wal_ext             = ifdef_wal_ext(nil),\n"
"    force_recovery      = false,\n"
"    replication         = nil,\n"
"    instance_uuid       = nil,\n"
"    replicaset_uuid     = nil,\n"
"    custom_proc_title   = nil,\n"
"    pid_file            = nil,\n"
"    background          = false,\n"
"    username            = nil,\n"
"    coredump            = false,\n"
"    read_only           = false,\n"
"    hot_standby         = false,\n"
"    memtx_use_mvcc_engine = false,\n"
"    checkpoint_interval = 3600,\n"
"    checkpoint_wal_threshold = 1e18,\n"
"    checkpoint_count    = 2,\n"
"    worker_pool_threads = 4,\n"
"    election_mode       = 'off',\n"
"    election_timeout    = 5,\n"
"    election_fencing_mode = 'soft',\n"
"    replication_timeout = 1,\n"
"    replication_sync_lag = 10,\n"
"    replication_sync_timeout = 300,\n"
"    replication_synchro_quorum = \"N / 2 + 1\",\n"
"    replication_synchro_timeout = 5,\n"
"    replication_connect_timeout = 30,\n"
"    replication_connect_quorum = nil, -- connect all\n"
"    replication_skip_conflict = false,\n"
"    replication_anon      = false,\n"
"    replication_threads   = 1,\n"
"    bootstrap_strategy    = \"auto\",\n"
"    feedback_enabled      = ifdef_feedback(true),\n"
"    feedback_crashinfo    = ifdef_feedback(true),\n"
"    feedback_host         = ifdef_feedback(\"https://feedback.tarantool.io\"),\n"
"    feedback_interval     = ifdef_feedback(3600),\n"
"    feedback_send_metrics = ifdef_feedback(true),\n"
"    feedback_metrics_collect_interval = ifdef_feedback(60),\n"
"    feedback_metrics_limit = ifdef_feedback(1024 * 1024),\n"
"    net_msg_max           = 768,\n"
"    sql_cache_size        = 5 * 1024 * 1024,\n"
"    txn_timeout           = 365 * 100 * 86400,\n"
"    txn_isolation         = \"best-effort\",\n"
"\n"
"    metrics     = {\n"
"        include = 'all',\n"
"        exclude = {},\n"
"        labels = {},\n"
"    },\n"
"}\n"
"\n"
"-- We need to track cfg changes done through API of distinct modules (log.cfg of\n"
"-- log module for example). We cannot use just box.cfg because it is not\n"
"-- available before box.cfg() call and other modules can be configured before\n"
"-- this moment.\n"
"local pre_load_cfg = table.copy(default_cfg)\n"
"\n"
"-- On first box.cfg{} we need to know options that were already configured\n"
"-- in standalone modules (like log module). We should not apply env vars\n"
"-- for these options. pre_load_cfg is not suitable for this purpose because\n"
"-- of nil values.\n"
"local pre_load_cfg_is_set = {}\n"
"\n"
"\n"
"-- Whether box is loaded.\n"
"--\n"
"-- `false` when box is not configured or when the initialization\n"
"-- is in progress.\n"
"--\n"
"-- `true` when box is configured.\n"
"--\n"
"-- Use locked() wrapper to obtain reliable results.\n"
"local box_is_configured = false\n"
"\n"
"local replication_sync_timeout_brief = [[\n"
"Sets the default value for box.cfg.replication_sync_timeout.\n"
"Old is 300 seconds, new is 0 seconds. New behaviour makes\n"
"box.cfg{replication = ...} call exit without waiting for\n"
"synchronisation with all the remote nodes. This means that the node\n"
"might be in 'orphan' state for some time after the box.cfg{} call\n"
"returns. Set before first box.cfg{} call in order for the option to take effect.\n"
"\n"
"https://tarantool.io/compat/box_cfg_replication_sync_timeout\n"
"]]\n"
"\n"
"-- A list of box.cfg options whose defaults are managed by compat.\n"
"local compat_options = {\n"
"    {\n"
"        name = 'replication_sync_timeout',\n"
"        brief = replication_sync_timeout_brief,\n"
"        oldval = 300,\n"
"        newval = 0,\n"
"        obsolete = nil,\n"
"        default = 'old',\n"
"    },\n"
"}\n"
"\n"
"for _, option in ipairs(compat_options) do\n"
"    local option_name = 'box_cfg_' .. option.name\n"
"    compat.add_option({\n"
"        name = option_name,\n"
"        default = option.default,\n"
"        obsolete = option.obsolete,\n"
"        brief = option.brief,\n"
"        action = function(is_new)\n"
"            if is_locked() or box_is_configured then\n"
"                error(\"The compat  option '\" .. option_name .. \"' takes \" ..\n"
"                      \"effect only before the initial box.cfg() call\")\n"
"            end\n"
"            local val = is_new and option.newval or option.oldval\n"
"            default_cfg[option.name] = val\n"
"            pre_load_cfg[option.name] = val\n"
"        end,\n"
"        run_action_now = true,\n"
"    })\n"
"end\n"
"\n"
"-- types of available options\n"
"-- could be comma separated lua types or 'any' if any type is allowed\n"
"--\n"
"-- get_option_from_env() leans on the set of types in use: don't\n"
"-- forget to update it when add a new type or a combination of\n"
"-- types here.\n"
"local template_cfg = {\n"
"    listen              = 'string, number, table',\n"
"    memtx_memory        = 'number',\n"
"    strip_core          = 'boolean',\n"
"    memtx_min_tuple_size  = 'number',\n"
"    memtx_max_tuple_size  = 'number',\n"
"    slab_alloc_granularity = 'number',\n"
"    slab_alloc_factor   = 'number',\n"
"    iproto_threads      = 'number',\n"
"    memtx_allocator     = 'string',\n"
"    work_dir            = 'string',\n"
"    memtx_dir            = 'string',\n"
"    wal_dir             = 'string',\n"
"    vinyl_dir           = 'string',\n"
"    vinyl_memory        = 'number',\n"
"    vinyl_cache               = 'number',\n"
"    vinyl_max_tuple_size      = 'number',\n"
"    vinyl_read_threads        = 'number',\n"
"    vinyl_write_threads       = 'number',\n"
"    vinyl_timeout             = 'number',\n"
"    vinyl_defer_deletes       = 'boolean',\n"
"    vinyl_run_count_per_level = 'number',\n"
"    vinyl_run_size_ratio      = 'number',\n"
"    vinyl_range_size          = 'number',\n"
"    vinyl_page_size           = 'number',\n"
"    vinyl_bloom_fpr           = 'number',\n"
"\n"
"    log                 = 'string',\n"
"    log_nonblock        = 'boolean',\n"
"    log_level           = 'number, string',\n"
"    log_modules         = 'table',\n"
"    log_format          = 'string',\n"
"\n"
"    audit_log           = ifdef_audit('string'),\n"
"    audit_nonblock      = ifdef_audit('boolean'),\n"
"    audit_format        = ifdef_audit('string'),\n"
"    audit_filter        = ifdef_audit('string'),\n"
"\n"
"    auth_type           = 'string',\n"
"    auth_delay          = ifdef_security('number'),\n"
"    disable_guest       = ifdef_security('boolean'),\n"
"    password_lifetime_days = ifdef_security('number'),\n"
"    password_min_length = ifdef_security('number'),\n"
"    password_enforce_uppercase = ifdef_security('boolean'),\n"
"    password_enforce_lowercase = ifdef_security('boolean'),\n"
"    password_enforce_digits = ifdef_security('boolean'),\n"
"    password_enforce_specialchars = ifdef_security('boolean'),\n"
"    password_history_length = ifdef_security('number'),\n"
"\n"
"    flightrec_enabled = ifdef_flightrec('boolean'),\n"
"    flightrec_logs_size = ifdef_flightrec('number'),\n"
"    flightrec_logs_max_msg_size = ifdef_flightrec('number'),\n"
"    flightrec_logs_log_level = ifdef_flightrec('number'),\n"
"    flightrec_metrics_interval = ifdef_flightrec('number'),\n"
"    flightrec_metrics_period = ifdef_flightrec('number'),\n"
"    flightrec_requests_size = ifdef_flightrec('number'),\n"
"    flightrec_requests_max_req_size = ifdef_flightrec('number'),\n"
"    flightrec_requests_max_res_size = ifdef_flightrec('number'),\n"
"\n"
"    io_collect_interval = 'number',\n"
"    readahead           = 'number',\n"
"    snap_io_rate_limit  = 'number',\n"
"    too_long_threshold  = 'number',\n"
"    wal_mode            = 'string',\n"
"    wal_max_size        = 'number',\n"
"    wal_dir_rescan_delay= 'number',\n"
"    wal_cleanup_delay   = 'number',\n"
"    wal_ext             = ifdef_wal_ext('table'),\n"
"    force_recovery      = 'boolean',\n"
"    replication         = 'string, number, table',\n"
"    instance_uuid       = 'string',\n"
"    replicaset_uuid     = 'string',\n"
"    custom_proc_title   = 'string',\n"
"    pid_file            = 'string',\n"
"    background          = 'boolean',\n"
"    username            = 'string',\n"
"    coredump            = 'boolean',\n"
"    checkpoint_interval = 'number',\n"
"    checkpoint_wal_threshold = 'number',\n"
"    wal_queue_max_size  = 'number',\n"
"    checkpoint_count    = 'number',\n"
"    read_only           = 'boolean',\n"
"    hot_standby         = 'boolean',\n"
"    memtx_use_mvcc_engine = 'boolean',\n"
"    txn_isolation = 'string, number',\n"
"    worker_pool_threads = 'number',\n"
"    election_mode       = 'string',\n"
"    election_timeout    = 'number',\n"
"    election_fencing_mode = 'string',\n"
"    replication_timeout = 'number',\n"
"    replication_sync_lag = 'number',\n"
"    replication_sync_timeout = 'number',\n"
"    replication_synchro_quorum = 'string, number',\n"
"    replication_synchro_timeout = 'number',\n"
"    replication_connect_timeout = 'number',\n"
"    replication_connect_quorum = 'number',\n"
"    replication_skip_conflict = 'boolean',\n"
"    replication_anon      = 'boolean',\n"
"    replication_threads   = 'number',\n"
"    bootstrap_strategy    = 'string',\n"
"    feedback_enabled      = ifdef_feedback('boolean'),\n"
"    feedback_crashinfo    = ifdef_feedback('boolean'),\n"
"    feedback_host         = ifdef_feedback('string'),\n"
"    feedback_interval     = ifdef_feedback('number'),\n"
"    feedback_send_metrics = ifdef_feedback('boolean'),\n"
"    feedback_metrics_collect_interval = ifdef_feedback('number'),\n"
"    feedback_metrics_limit = ifdef_feedback('number'),\n"
"    net_msg_max           = 'number',\n"
"    sql_cache_size        = 'number',\n"
"    txn_timeout           = 'number',\n"
"\n"
"    metrics = 'table',\n"
"}\n"
"\n"
"local function normalize_uri_list_for_replication(port_list)\n"
"    if type(port_list) == 'table' then\n"
"        return port_list\n"
"    end\n"
"    return {port_list}\n"
"end\n"
"\n"
"-- options that require special handling\n"
"local modify_cfg = {\n"
"    replication        = normalize_uri_list_for_replication,\n"
"}\n"
"\n"
"local function purge_password_from_uri(uri)\n"
"    local parsed = urilib.parse(uri)\n"
"    if parsed ~= nil and parsed.password ~= nil then\n"
"        return urilib.format(parsed, false)\n"
"    end\n"
"    return uri\n"
"end\n"
"\n"
"local function purge_password_from_uris(uri)\n"
"    if uri == nil then\n"
"        return nil\n"
"    end\n"
"    if type(uri) == 'table' then\n"
"        local new_table = {}\n"
"        for k, v in pairs(uri) do\n"
"            new_table[k] = purge_password_from_uri(v)\n"
"        end\n"
"        return new_table\n"
"    end\n"
"    return purge_password_from_uri(uri)\n"
"end\n"
"\n"
"-- options that require modification for logging\n"
"local log_cfg_option = {\n"
"    replication = purge_password_from_uris,\n"
"}\n"
"\n"
"\n"
"local function check_instance_uuid()\n"
"    if box.cfg.instance_uuid ~= box.info.uuid then\n"
"        box.error(box.error.RELOAD_CFG, 'instance_uuid')\n"
"    end\n"
"end\n"
"\n"
"local function check_replicaset_uuid()\n"
"    if box.cfg.replicaset_uuid ~= box.info.cluster.uuid then\n"
"        box.error(box.error.RELOAD_CFG, 'replicaset_uuid')\n"
"    end\n"
"end\n"
"\n"
"-- dynamically settable options\n"
"--\n"
"-- Note: An option should be in <dynamic_cfg_skip_at_load> table\n"
"-- or should be verified in box_check_config(). Otherwise\n"
"-- load_cfg() may report an error, but box will be configured in\n"
"-- fact.\n"
"local dynamic_cfg = {\n"
"    replication             = private.cfg_set_replication,\n"
"    io_collect_interval     = private.cfg_set_io_collect_interval,\n"
"    readahead               = private.cfg_set_readahead,\n"
"    too_long_threshold      = private.cfg_set_too_long_threshold,\n"
"    snap_io_rate_limit      = private.cfg_set_snap_io_rate_limit,\n"
"    read_only               = private.cfg_set_read_only,\n"
"    memtx_memory            = private.cfg_set_memtx_memory,\n"
"    memtx_max_tuple_size    = private.cfg_set_memtx_max_tuple_size,\n"
"    vinyl_memory            = private.cfg_set_vinyl_memory,\n"
"    vinyl_max_tuple_size    = private.cfg_set_vinyl_max_tuple_size,\n"
"    vinyl_cache             = private.cfg_set_vinyl_cache,\n"
"    vinyl_timeout           = private.cfg_set_vinyl_timeout,\n"
"    vinyl_defer_deletes     = nop,\n"
"    checkpoint_count        = private.cfg_set_checkpoint_count,\n"
"    checkpoint_interval     = private.cfg_set_checkpoint_interval,\n"
"    checkpoint_wal_threshold = private.cfg_set_checkpoint_wal_threshold,\n"
"    wal_queue_max_size      = private.cfg_set_wal_queue_max_size,\n"
"    worker_pool_threads     = private.cfg_set_worker_pool_threads,\n"
"    -- do nothing, affects new replicas, which query this value on start\n"
"    wal_dir_rescan_delay    = nop,\n"
"    wal_cleanup_delay       = private.cfg_set_wal_cleanup_delay,\n"
"    custom_proc_title       = function()\n"
"        require('title').update(box.cfg.custom_proc_title)\n"
"    end,\n"
"    force_recovery          = private.cfg_set_force_recovery,\n"
"    election_mode           = private.cfg_set_election_mode,\n"
"    election_timeout        = private.cfg_set_election_timeout,\n"
"    election_fencing_mode = private.cfg_set_election_fencing_mode,\n"
"    replication_timeout     = private.cfg_set_replication_timeout,\n"
"    replication_connect_timeout = private.cfg_set_replication_connect_timeout,\n"
"    replication_connect_quorum = private.cfg_set_replication_connect_quorum,\n"
"    replication_sync_lag    = private.cfg_set_replication_sync_lag,\n"
"    replication_sync_timeout = private.cfg_set_replication_sync_timeout,\n"
"    replication_synchro_quorum = private.cfg_set_replication_synchro_quorum,\n"
"    replication_synchro_timeout = private.cfg_set_replication_synchro_timeout,\n"
"    replication_skip_conflict = private.cfg_set_replication_skip_conflict,\n"
"    replication_anon        = private.cfg_set_replication_anon,\n"
"    bootstrap_strategy      = private.cfg_set_bootstrap_strategy,\n"
"    instance_uuid           = check_instance_uuid,\n"
"    replicaset_uuid         = check_replicaset_uuid,\n"
"    net_msg_max             = private.cfg_set_net_msg_max,\n"
"    sql_cache_size          = private.cfg_set_sql_cache_size,\n"
"    txn_timeout             = private.cfg_set_txn_timeout,\n"
"    txn_isolation           = private.cfg_set_txn_isolation,\n"
"    auth_type               = private.cfg_set_auth_type,\n"
"    auth_delay              = private.cfg_set_security,\n"
"    disable_guest           = private.cfg_set_security,\n"
"    password_lifetime_days  = private.cfg_set_security,\n"
"    password_min_length     = ifdef_security(nop),\n"
"    password_enforce_uppercase = ifdef_security(nop),\n"
"    password_enforce_lowercase = ifdef_security(nop),\n"
"    password_enforce_digits = ifdef_security(nop),\n"
"    password_enforce_specialchars = ifdef_security(nop),\n"
"    password_history_length = ifdef_security(nop),\n"
"    wal_ext                 = private.cfg_set_wal_ext,\n"
"\n"
"    metrics = function()\n"
"        require('metrics').cfg(box.cfg.metrics)\n"
"    end,\n"
"}\n"
"\n"
"-- The modules that can apply all new options with single call. The\n"
"-- application should be atomic, that is if it fails the module should\n"
"-- work as before. If `cfg` is not atomic then `revert_cfg` and\n"
"-- `revert_fallback` should be set.\n"
"--\n"
"-- `revert_cfg` is used to revert config to the state before failed\n"
"-- reconfiguration. If the reverting fails too then we try to revert\n"
"-- to \"safe\" value given in `revert_fallback`. \"safe\" in sense that\n"
"-- reverting to it should always be successful.\n"
"local dynamic_cfg_modules = {\n"
"    listen = {\n"
"        cfg = private.cfg_set_listen,\n"
"        options = {\n"
"            listen = true,\n"
"        },\n"
"        skip_at_load = true,\n"
"        revert_cfg = private.cfg_set_listen,\n"
"        revert_fallback = {\n"
"            listen = nil,\n"
"        },\n"
"    },\n"
"    feedback = {\n"
"        cfg = ifdef_feedback_set_params,\n"
"        options = {\n"
"            feedback_enabled = true,\n"
"            feedback_crashinfo = true,\n"
"            feedback_host = true,\n"
"            feedback_interval = true,\n"
"            feedback_send_metrics = true,\n"
"            feedback_metrics_collect_interval = true,\n"
"            feedback_metrics_limit = true,\n"
"        },\n"
"    },\n"
"    flightrec = {\n"
"        cfg = ifdef_flightrec_set_params,\n"
"        options = {\n"
"            flightrec_enabled = true,\n"
"            flightrec_logs_size = true,\n"
"            flightrec_logs_max_msg_size = true,\n"
"            flightrec_logs_log_level = true,\n"
"            flightrec_metrics_interval = true,\n"
"            flightrec_metrics_period = true,\n"
"            flightrec_requests_size = true,\n"
"            flightrec_requests_max_req_size = true,\n"
"            flightrec_requests_max_res_size = true,\n"
"        },\n"
"    },\n"
"    log = {\n"
"        cfg = log.box_api.cfg,\n"
"        options = {\n"
"            log = true,\n"
"            log_level = true,\n"
"            log_modules = true,\n"
"            log_format = true,\n"
"            log_nonblock = true,\n"
"        },\n"
"        skip_at_load = true,\n"
"    }\n"
"}\n"
"\n"
"--\n"
"-- For some options it is important in which order they are set.\n"
"-- For example, setting 'replication', including self, before\n"
"-- 'listen' makes no sense:\n"
"--\n"
"--     box.cfg{replication = {'localhost:3301'}, listen = 3301}\n"
"--\n"
"-- Replication won't be able to connect to a not being listened\n"
"-- port. In the table below for each option can be set a number.\n"
"-- An option is set before all other options having a bigger\n"
"-- number. Options without a number are installed after others in\n"
"-- an undefined order. The table works for reconfiguration only.\n"
"-- Order of first configuration is hardcoded in C and can't be\n"
"-- changed.\n"
"--\n"
"local dynamic_cfg_order = {\n"
"    listen                  = 100,\n"
"    -- Order of replication_* options does not matter. The only\n"
"    -- rule - apply before replication itself.\n"
"    replication_timeout     = 150,\n"
"    replication_sync_lag    = 150,\n"
"    replication_sync_timeout    = 150,\n"
"    replication_synchro_quorum  = 150,\n"
"    replication_synchro_timeout = 150,\n"
"    replication_connect_timeout = 150,\n"
"    replication_connect_quorum  = 150,\n"
"    -- Apply bootstrap_strategy before replication, but after\n"
"    -- replication_connect_quorum. The latter might influence its value.\n"
"    bootstrap_strategy      = 175,\n"
"    replication             = 200,\n"
"    -- Anon is set after `replication` as a temporary workaround\n"
"    -- for the problem, that `replication` and `replication_anon`\n"
"    -- depend on each other. If anon would be configured before\n"
"    -- `replication`, it could lead to a bug, when anon is changed\n"
"    -- from true to false together with `replication`, and it\n"
"    -- would try to deanon the old `replication` before applying\n"
"    -- the new one. This should be fixed when box.cfg is able to\n"
"    -- apply some parameters together and atomically.\n"
"    replication_anon        = 250,\n"
"    -- Cleanup delay should be ignored if replication_anon is set.\n"
"    wal_cleanup_delay       = 260,\n"
"    election_mode           = 300,\n"
"    election_timeout        = 320,\n"
"    election_fencing_mode   = 320,\n"
"}\n"
"\n"
"local function sort_cfg_cb(l, r)\n"
"    l = dynamic_cfg_order[l] or math.huge\n"
"    r = dynamic_cfg_order[r] or math.huge\n"
"    return l < r\n"
"end\n"
"\n"
"local dynamic_cfg_skip_at_load = {\n"
"    memtx_memory            = true,\n"
"    memtx_max_tuple_size    = true,\n"
"    vinyl_memory            = true,\n"
"    vinyl_max_tuple_size    = true,\n"
"    vinyl_cache             = true,\n"
"    vinyl_timeout           = true,\n"
"    too_long_threshold      = true,\n"
"    election_mode           = true,\n"
"    election_timeout        = true,\n"
"    election_fencing_mode   = true,\n"
"    replication             = true,\n"
"    replication_timeout     = true,\n"
"    replication_connect_timeout = true,\n"
"    replication_connect_quorum = true,\n"
"    replication_sync_lag    = true,\n"
"    replication_sync_timeout = true,\n"
"    replication_synchro_quorum = true,\n"
"    replication_synchro_timeout = true,\n"
"    replication_skip_conflict = true,\n"
"    replication_anon        = true,\n"
"    bootstrap_strategy      = true,\n"
"    wal_dir_rescan_delay    = true,\n"
"    custom_proc_title       = true,\n"
"    force_recovery          = true,\n"
"    instance_uuid           = true,\n"
"    replicaset_uuid         = true,\n"
"    net_msg_max             = true,\n"
"    readahead               = true,\n"
"    auth_type               = true,\n"
"    auth_delay              = ifdef_security(true),\n"
"    disable_guest           = ifdef_security(true),\n"
"    password_lifetime_days  = ifdef_security(true),\n"
"}\n"
"\n"
"-- Options that are not part of dynamic_cfg_modules and applied individually\n"
"-- can be considered as modules with single option. Load all these options\n"
"-- into dynamic_cfg_modules.\n"
"for option, api in pairs(dynamic_cfg) do\n"
"    assert(dynamic_cfg_modules[option] == nil,\n"
"           'name clash in dynamic_cfg_modules and dynamic_cfg')\n"
"    dynamic_cfg_modules[option] = {\n"
"        cfg = api,\n"
"        options = {[option] = true},\n"
"        skip_at_load = dynamic_cfg_skip_at_load[option],\n"
"    }\n"
"end\n"
"\n"
"local option2module_name = {}\n"
"\n"
"for module, info in pairs(dynamic_cfg_modules) do\n"
"    for option in pairs(info.options) do\n"
"        option2module_name[option] = module\n"
"    end\n"
"end\n"
"\n"
"local function convert_gb(size)\n"
"    return math.floor(size * 1024 * 1024 * 1024)\n"
"end\n"
"\n"
"-- Old to new config translation tables. In case a translation is\n"
"-- not 1-to-1, then a function can be used. It takes 2 parameters:\n"
"-- value of the old option, value of the new if present. It\n"
"-- returns two values - value to replace the old option and to\n"
"-- replace the new one.\n"
"local translate_cfg = {\n"
"    snapshot_count = {'checkpoint_count'},\n"
"    snapshot_period = {'checkpoint_interval'},\n"
"    slab_alloc_arena = {'memtx_memory', function(old)\n"
"        return nil, convert_gb(old)\n"
"    end},\n"
"    slab_alloc_minimal = {'memtx_min_tuple_size'},\n"
"    slab_alloc_maximal = {'memtx_max_tuple_size'},\n"
"    snap_dir = {'memtx_dir'},\n"
"    logger = {'log'},\n"
"    logger_nonblock = {'log_nonblock'},\n"
"    panic_on_snap_error = {'force_recovery', function(old)\n"
"        return nil, not old end\n"
"    },\n"
"    panic_on_wal_error = {'force_recovery', function(old)\n"
"        return nil, not old end\n"
"    },\n"
"    replication_source = {'replication'},\n"
"    rows_per_wal = {'wal_max_size', function(old, new)\n"
"        return old, new\n"
"    end},\n"
"    election_fencing_enabled = {'election_fencing_mode', function(old, new)\n"
"        if new ~= nil then return nil, new\n"
"        elseif old == false then return nil, 'off'\n"
"        elseif old == true then return nil, 'soft'\n"
"        end\n"
"    end},\n"
"    replication_connect_quorum = {'bootstrap_strategy', function(old, new)\n"
"        if new ~= nil then\n"
"            return old, new\n"
"        elseif old ~= nil then\n"
"            return old, 'legacy'\n"
"        end\n"
"    end},\n"
"}\n"
"\n"
"-- Upgrade old config\n"
"local function upgrade_cfg(cfg, translate_cfg)\n"
"    if cfg == nil then\n"
"        return {}\n"
"    end\n"
"    local result_cfg = {}\n"
"    for k, v in pairs(cfg) do\n"
"        local translation = translate_cfg[k]\n"
"        if translation ~= nil then\n"
"            local new_key = translation[1]\n"
"            local transform = translation[2]\n"
"            log.warn('Deprecated option %s, please use %s instead', k, new_key)\n"
"            local new_val_orig = cfg[new_key]\n"
"            local old_val, new_val\n"
"            if transform == nil then\n"
"                new_val = v\n"
"            else\n"
"                old_val, new_val = transform(v, new_val_orig)\n"
"            end\n"
"            if new_val_orig ~= nil and\n"
"               new_val_orig ~= new_val then\n"
"                box.error(box.error.CFG, k,\n"
"                          'can not override a value for a deprecated option')\n"
"            end\n"
"            result_cfg[k] = old_val\n"
"            result_cfg[new_key] = new_val\n"
"        else\n"
"            result_cfg[k] = v\n"
"        end\n"
"    end\n"
"    return result_cfg\n"
"end\n"
"\n"
"local function check_cfg_option_type(template, name, value)\n"
"    if template == 'any' then\n"
"        return\n"
"    elseif (string.find(template, ',') == nil) then\n"
"        if type(value) ~= template then\n"
"            box.error(box.error.CFG, name, \"should be of type \" ..\n"
"                      template)\n"
"        end\n"
"    else\n"
"        local prepared_tmpl = ',' .. string.gsub(template, ' ', '') .. ','\n"
"        local prepared_type = ',' .. type(value) .. ','\n"
"        if string.find(prepared_tmpl, prepared_type) == nil then\n"
"            box.error(box.error.CFG, name, \"should be one of types \" ..\n"
"                      template)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function prepare_cfg(cfg, default_cfg, template_cfg, modify_cfg)\n"
"    if cfg == nil then\n"
"        return {}\n"
"    end\n"
"    if type(cfg) ~= 'table' then\n"
"        error(\"Error: cfg should be a table\")\n"
"    end\n"
"    local new_cfg = {}\n"
"    for k, v in pairs(cfg) do\n"
"        if template_cfg[k] == nil then\n"
"            box.error(box.error.CFG, k , \"unexpected option\")\n"
"        elseif v == \"\" or v == nil then\n"
"            -- \"\" and NULL = ffi.cast('void *', 0) set option to default value\n"
"            v = default_cfg[k]\n"
"        else\n"
"            check_cfg_option_type(template_cfg[k], k, v)\n"
"        end\n"
"        if modify_cfg ~= nil and type(modify_cfg[k]) == 'function' then\n"
"            v = modify_cfg[k](v)\n"
"        end\n"
"        new_cfg[k] = v\n"
"    end\n"
"    return new_cfg\n"
"end\n"
"\n"
"-- Transfer options from env_cfg to cfg.\n"
"-- If skip_cfg is given then skip transferring options from this set.\n"
"local function apply_env_cfg(cfg, env_cfg, skip_cfg)\n"
"    -- Add options passed through environment variables.\n"
"    -- Here we only add options without overloading the ones set\n"
"    -- by the user.\n"
"    for k, v in pairs(env_cfg) do\n"
"        if cfg[k] == nil and (skip_cfg == nil or skip_cfg[k] == nil) then\n"
"            cfg[k] = v\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"local function merge_cfg(cfg, cur_cfg)\n"
"    for k,v in pairs(cur_cfg) do\n"
"        if cfg[k] == nil then\n"
"            cfg[k] = v\n"
"        elseif type(v) == 'table' then\n"
"            merge_cfg(cfg[k], v)\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- Return true if two configurations are equivalent.\n"
"local function compare_cfg(cfg1, cfg2)\n"
"    if type(cfg1) ~= type(cfg2) then\n"
"        return false\n"
"    end\n"
"    if type(cfg1) ~= 'table' then\n"
"        return cfg1 == cfg2\n"
"    end\n"
"    return table.equals(cfg1, cfg2)\n"
"end\n"
"\n"
"local function rollback_module(module, oldcfg, keys, values)\n"
"    for key in pairs(keys) do\n"
"        oldcfg[key] = values[key]\n"
"    end\n"
"    if module.revert_cfg == nil then\n"
"        return\n"
"    end\n"
"    local save_err = box.error.last()\n"
"    local result, err = pcall(module.revert_cfg)\n"
"    if not result then\n"
"        for key in pairs(keys) do\n"
"            log.error(\"failed to revert '%s' configuration option: %s\",\n"
"                      key, err)\n"
"        end\n"
"\n"
"        for key in pairs(module.options) do\n"
"            oldcfg[key] = module.revert_fallback[key]\n"
"        end\n"
"        -- Setting to this special value should not fail\n"
"        assert(pcall(module.revert_cfg))\n"
"    end\n"
"    box.error.set(save_err)\n"
"end\n"
"\n"
"local function log_changed_options(oldcfg, keys, log_basecfg)\n"
"    for key in pairs(keys) do\n"
"        local val = oldcfg[key]\n"
"        if log_basecfg == nil or\n"
"           not compare_cfg(val, log_basecfg[key]) then\n"
"            if log_cfg_option[key] ~= nil then\n"
"                val = log_cfg_option[key](val)\n"
"            end\n"
"            log.info(\"set '%s' configuration option to %s\",\n"
"                     key, json.encode(val))\n"
"        end\n"
"    end\n"
"end\n"
"\n"
"-- Call dynamic config API for all config modules/options.\n"
"--\n"
"-- @oldcfg is current global config used by config API\n"
"-- @newcfg if it is not nil then first apply it to @oldcfg\n"
"-- @log_basecfg if it is not nil then only log option that differ from\n"
"--      this cfg\n"
"--\n"
"local function reconfig_modules(module_keys, oldcfg, newcfg, log_basecfg)\n"
"    local ordered = {}\n"
"    for name in pairs(module_keys) do\n"
"        table.insert(ordered, name)\n"
"    end\n"
"    table.sort(ordered, sort_cfg_cb)\n"
"\n"
"    for _, name in pairs(ordered) do\n"
"        local oldvals\n"
"        local keys = module_keys[name]\n"
"        if newcfg ~= nil then\n"
"            oldvals = {}\n"
"            for key in pairs(keys) do\n"
"                oldvals[key] = oldcfg[key]\n"
"                oldcfg[key] = newcfg[key]\n"
"            end\n"
"        end\n"
"        local module = dynamic_cfg_modules[name]\n"
"        local result, err = pcall(module.cfg)\n"
"        if not result then\n"
"            if oldvals ~= nil then\n"
"                rollback_module(module, oldcfg, keys, oldvals)\n"
"            end\n"
"            error(err)\n"
"        end\n"
"\n"
"        log_changed_options(oldcfg, keys, log_basecfg)\n"
"    end\n"
"end\n"
"\n"
"local function reload_cfg(oldcfg, cfg)\n"
"    cfg = upgrade_cfg(cfg, translate_cfg)\n"
"    local newcfg = prepare_cfg(cfg, default_cfg, template_cfg, modify_cfg)\n"
"\n"
"    local module_keys = {}\n"
"    -- iterate over original table because prepare_cfg() may store NILs\n"
"    for key in pairs(cfg) do\n"
"        if not compare_cfg(oldcfg[key], newcfg[key]) then\n"
"            local name = option2module_name[key]\n"
"            if name == nil then\n"
"                box.error(box.error.RELOAD_CFG, key);\n"
"            end\n"
"            if module_keys[name] == nil then\n"
"                module_keys[name] = {}\n"
"            end\n"
"            module_keys[name][key] = true\n"
"        end\n"
"    end\n"
"\n"
"    reconfig_modules(module_keys, oldcfg, newcfg, nil)\n"
"\n"
"    if type(box.on_reload_configuration) == 'function' then\n"
"        box.on_reload_configuration()\n"
"    end\n"
"end\n"
"\n"
"local function load_cfg_apply_dynamic(oldcfg)\n"
"    local module_keys = {}\n"
"    for name, module in pairs(dynamic_cfg_modules) do\n"
"        if module.skip_at_load then\n"
"            log_changed_options(oldcfg, module.options, default_cfg)\n"
"        else\n"
"            for key in pairs(module.options) do\n"
"                if oldcfg[key] ~= nil then\n"
"                    module_keys[name] = module.options\n"
"                    break\n"
"                end\n"
"            end\n"
"        end\n"
"    end\n"
"\n"
"    reconfig_modules(module_keys, oldcfg, nil, default_cfg)\n"
"end\n"
"\n"
"local box_cfg_guard_whitelist = {\n"
"    error = true;\n"
"    internal = true;\n"
"    index = true;\n"
"    lib = true;\n"
"    session = true;\n"
"    tuple = true;\n"
"    runtime = true;\n"
"    malloc = true;\n"
"    ctl = true;\n"
"    watch = true;\n"
"    broadcast = true;\n"
"    txn_isolation_level = true;\n"
"    NULL = true;\n"
"    info = true;\n"
"    iproto = true;\n"
"};\n"
"\n"
"-- List of box members that requires full box loading.\n"
"local box_restore_after_full_load_list = {\n"
"    execute = true,\n"
"}\n"
"\n"
"local box = require('box')\n"
"-- Move all box members except the whitelisted to box_configured\n"
"local box_configured = {}\n"
"for k, v in pairs(box) do\n"
"    box_configured[k] = v\n"
"    if not box_cfg_guard_whitelist[k] then\n"
"        box[k] = nil\n"
"    end\n"
"end\n"
"\n"
"setmetatable(box, {\n"
"    __index = function()\n"
"        box.error(box.error.UNCONFIGURED)\n"
"     end\n"
"})\n"
"\n"
"local raw_cfg\n"
"\n"
"local function load_cfg(cfg)\n"
"    -- A user may save box.cfg (this function) before box loading\n"
"    -- and call it afterwards. We should reconfigure box in the\n"
"    -- case.\n"
"    if box_is_configured then\n"
"        reload_cfg(raw_cfg, cfg)\n"
"        return\n"
"    end\n"
"\n"
"    cfg = upgrade_cfg(cfg, translate_cfg)\n"
"\n"
"    -- Set options passed through environment variables.\n"
"    apply_env_cfg(cfg, box.internal.cfg.env, pre_load_cfg_is_set)\n"
"\n"
"    cfg = prepare_cfg(cfg, default_cfg, template_cfg, modify_cfg)\n"
"    merge_cfg(cfg, pre_load_cfg);\n"
"\n"
"    -- Save new box.cfg\n"
"    box.cfg = cfg\n"
"    local status, err = pcall(private.cfg_check)\n"
"    if not status then\n"
"        box.cfg = locked(load_cfg) -- restore original box.cfg\n"
"        return error(err)\n"
"    end\n"
"\n"
"    -- NB: After this point the function should not raise an\n"
"    -- error.\n"
"    --\n"
"    -- This is important to have right <box_is_configured> (this\n"
"    -- file) and <is_box_configured> (box.cc) values.\n"
"    --\n"
"    -- It also would be counter-intuitive to receive an error from\n"
"    -- box.cfg({<...>}), but find that box is actually configured.\n"
"\n"
"    -- Restore box members after initial configuration.\n"
"    for k, v in pairs(box_configured) do\n"
"        if not box_restore_after_full_load_list[k] then\n"
"            box[k] = v\n"
"        end\n"
"    end\n"
"\n"
"    setmetatable(box, nil)\n"
"    -- There is only a single way for setting a value to a box option -\n"
"    -- call 'box.cfg{ option_name=option_value }'. Direct modifications\n"
"    -- of table box.cfg are not allowed. On attempt to make a direct\n"
"    -- modifications (setting a new option or updating an existing one) we raise\n"
"    -- an error. For implementation this we are using metamethods __newindex\n"
"    -- and __index. Both __index and __newindex are relevant only when the\n"
"    -- index does not exist in the table. The only way to catch all accesses to\n"
"    -- a table is to keep it empty. So we use an empty proxy table and proxying\n"
"    -- setting and reading to another table.\n"
"    raw_cfg = table.copy(cfg)\n"
"    local proxy_table = {}\n"
"    box.cfg = setmetatable(proxy_table,\n"
"        {\n"
"            -- tarantoolctl (extra/dist/tarantoolctl.in) expects a metatable\n"
"            -- with metamethods, not a string. Thus we couldn't use __metatable\n"
"            -- instead.\n"
"            __name = 'box_cfg',\n"
"            __index = raw_cfg,\n"
"            __newindex = function(self, key, value) -- luacheck: no unused args\n"
"                if template_cfg[key] ~= nil then\n"
"                    local v = '<...>'\n"
"                    local t = type(value)\n"
"                    if t == 'boolean' or\n"
"                       t == 'nil' or\n"
"                       t == 'number' or\n"
"                       t == 'string' then\n"
"                        v = value\n"
"                    end\n"
"                    local err_msg_fmt = 'Use box.cfg{%s = %s} for update'\n"
"                    error(err_msg_fmt:format(key, v))\n"
"                end\n"
"                error('Attempt to modify a read-only table')\n"
"            end,\n"
"            __call = function(self, ...)\n"
"                assert(next(proxy_table) == nil,\n"
"                       'length of proxy table is not zero')\n"
"                return locked(reload_cfg)(raw_cfg, ...)\n"
"            end,\n"
"            __serialize = function()\n"
"                return raw_cfg\n"
"            end,\n"
"        })\n"
"\n"
"    -- Check schema version of the snapshot we're about to recover, if any.\n"
"    -- Some schema versions (below 1.7.5) are incompatible with Tarantool 2.x\n"
"    -- When recovering from such an old snapshot, special recovery triggers on\n"
"    -- system spaces are needed in order to be able to recover and upgrade\n"
"    -- the schema then.\n"
"    -- This code is executed before load_cfg, so work_dir is not yet set.\n"
"    local snap_dir = box.cfg.memtx_dir\n"
"    if not snap_dir:startswith('/') and box.cfg.work_dir ~= nil then\n"
"        snap_dir = fio.pathjoin(box.cfg.work_dir, snap_dir)\n"
"    end\n"
"    local snap_version = private.get_snapshot_version(snap_dir)\n"
"    if snap_version then\n"
"        private.set_recovery_triggers(snap_version)\n"
"    end\n"
"\n"
"    -- This call either succeeds or calls panic() / exit().\n"
"    private.cfg_load()\n"
"\n"
"    if snap_version then\n"
"        private.clear_recovery_triggers()\n"
"    end\n"
"    -- This block does not raise an error: all necessary checks\n"
"    -- already performed in private.cfg_check(). See <dynamic_cfg>\n"
"    -- comment.\n"
"    --\n"
"    -- FIXME we have issues here:\n"
"    -- 1. private.cfg_check does not make all nessesery checks now\n"
"    --    (it does not check invalid config for feedback_host for example).\n"
"    -- 2. Configuring options can throw errors but we don't panic here\n"
"    --    and thus end up with not complete configuration.\n"
"    load_cfg_apply_dynamic(raw_cfg)\n"
"\n"
"    -- Restore box members that requires full box loading.\n"
"    for k, v in pairs(box_configured) do\n"
"        if box_restore_after_full_load_list[k] then\n"
"            box[k] = v\n"
"        end\n"
"    end\n"
"    box_configured = nil\n"
"\n"
"    box_is_configured = true\n"
"\n"
"    -- Check if schema version matches Tarantool version and print\n"
"    -- warning if it's not (in case user forgot to call\n"
"    -- box.schema.upgrade()).\n"
"    local needs, schema_version_str = private.schema_needs_upgrade()\n"
"    if needs then\n"
"        local msg = string.format(\n"
"            'Your schema version is %s while Tarantool %s requires a more'..\n"
"            ' recent schema version. Please, consider using box.'..\n"
"            'schema.upgrade().', schema_version_str, box.info.version)\n"
"        log.warn(msg)\n"
"    end\n"
"end\n"
"box.cfg = locked(load_cfg)\n"
"\n"
"--\n"
"-- Parse TT_* environment variable that corresponds to given\n"
"-- option.\n"
"--\n"
"local function get_option_from_env(option)\n"
"    local param_type = template_cfg[option]\n"
"    assert(type(param_type) == 'string')\n"
"\n"
"    local env_var_name = 'TT_' .. option:upper()\n"
"    local raw_value = os.getenv(env_var_name)\n"
"\n"
"    if raw_value == nil or raw_value == '' then\n"
"        return nil\n"
"    end\n"
"\n"
"    local err_msg_fmt = 'Environment variable %s has ' ..\n"
"        'incorrect value for option \"%s\": should be %s'\n"
"\n"
"    -- This code lean on the existing set of template_cfg\n"
"    -- types for simplicity.\n"
"    if param_type:find('table') and (raw_value:startswith('{') or\n"
"                                     raw_value:startswith('[')) then\n"
"        return json.decode(raw_value)\n"
"    elseif param_type:find('table') and raw_value:find('=') then\n"
"        assert(not param_type:find('boolean'))\n"
"        local res = {}\n"
"        for _, v in ipairs(raw_value:split(',')) do\n"
"            local eq = v:find('=')\n"
"            if eq == nil then\n"
"                error(err_msg_fmt:format(env_var_name, option,\n"
"                                         'in `key=value` or `value` format'))\n"
"            end\n"
"            local lhs = string.sub(v, 1, eq - 1)\n"
"            local rhs = string.sub(v, eq + 1)\n"
"\n"
"            if lhs == '' then\n"
"                error(err_msg_fmt:format(env_var_name, option,\n"
"                                         'in `key=value` or `value` format, ' ..\n"
"                                         '`key` must not be empty'))\n"
"            end\n"
"            res[lhs] = tonumber(rhs) or rhs\n"
"        end\n"
"        return res\n"
"    elseif param_type:find('table') and raw_value:find(',') then\n"
"        assert(not param_type:find('boolean'))\n"
"        local res = {}\n"
"        for i, v in ipairs(raw_value:split(',')) do\n"
"            res[i] = tonumber(v) or v\n"
"        end\n"
"        return res\n"
"    elseif param_type:find('boolean') then\n"
"        assert(param_type == 'boolean')\n"
"        if raw_value:lower() == 'false' then\n"
"            return false\n"
"        elseif raw_value:lower() == 'true' then\n"
"            return true\n"
"        end\n"
"        error(err_msg_fmt:format(env_var_name, option, '\"true\" or \"false\"'))\n"
"    elseif param_type == 'number' then\n"
"        local res = tonumber(raw_value)\n"
"        if res == nil then\n"
"            error(err_msg_fmt:format(env_var_name, option,\n"
"                'convertible to a number'))\n"
"        end\n"
"        return res\n"
"    elseif param_type:find('number') then\n"
"        assert(not param_type:find('boolean'))\n"
"        return tonumber(raw_value) or raw_value\n"
"    else\n"
"        assert(param_type == 'string')\n"
"        return raw_value\n"
"    end\n"
"end\n"
"\n"
"-- Get options from env vars for given set.\n"
"local function env_cfg(options)\n"
"    local cfg = {}\n"
"    for option in pairs(options) do\n"
"        cfg[option] = get_option_from_env(option)\n"
"    end\n"
"    return cfg\n"
"end\n"
"\n"
"-- Used to propagate cfg changes done thru API of distinct modules (\n"
"-- log.cfg of log module for example).\n"
"local function update_cfg(option, value)\n"
"    if box_is_configured then\n"
"        raw_cfg[option] = value\n"
"    else\n"
"        pre_load_cfg[option] = value\n"
"        pre_load_cfg_is_set[option] = true\n"
"    end\n"
"end\n"
"\n"
"box.internal.prepare_cfg = prepare_cfg\n"
"box.internal.apply_env_cfg = apply_env_cfg\n"
"box.internal.merge_cfg = merge_cfg\n"
"box.internal.check_cfg_option_type = check_cfg_option_type\n"
"box.internal.update_cfg = update_cfg\n"
"box.internal.env_cfg = env_cfg\n"
"\n"
"---\n"
"--- Read box configuration from environment variables.\n"
"---\n"
"box.internal.cfg = setmetatable({}, {\n"
"    __index = function(self, key)\n"
"        if key == 'env' then\n"
"            return env_cfg(template_cfg)\n"
"        end\n"
"        assert(false)\n"
"    end,\n"
"    __newindex = function(self, key, value) -- luacheck: no unused args\n"
"        error('Attempt to modify a read-only table')\n"
"    end,\n"
"})\n"
"\n"
"-- gh-810:\n"
"-- hack luajit default cpath\n"
"-- commented out because we fixed luajit to build properly, see\n"
"-- https://github.com/luajit/luajit/issues/76\n"
"-- local format = require('tarantool').build.mod_format\n"
"-- package.cpath = package.cpath:gsub(\n"
"--     '\?.so', '\?.' .. format\n"
"-- ):gsub('loadall.so', 'loadall.' .. format)\n"
""
;
