/* CropView.c generated by valac 0.56.17, the Vala compiler
 * generated from CropView.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014-2023 elementary, Inc. (https://elementary.io)
 * Authored by: Tom Beckmann
 *              Marvin Beckers <beckersmarvin@gmail.com>
 */

#include "useraccounts.h"
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <cairo-gobject.h>

#define SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS 12
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_0_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXEL_SIZE_PROPERTY,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_PROPERTIES
};
static GParamSpec* switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL,
	SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_SIGNALS
};
static guint switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_NUM_SIGNALS] = {0};

struct _SwitchboardPlugUserAccountsWidgetsCropViewPrivate {
	GdkPixbuf* _pixbuf;
	gint _pixel_size;
	GdkRectangle area;
	gdouble current_scale;
	gint* pos;
	gint pos_length1;
	gint pos_length2;
	gchar* cursor_name;
	gint temp_x;
	gint temp_y;
	gint offset_x;
	gint offset_y;
	gboolean mouse_button_down;
	GtkGestureClick* click_gesture;
};

static gint SwitchboardPlugUserAccountsWidgetsCropView_private_offset;
static gpointer switchboard_plug_user_accounts_widgets_crop_view_parent_class = NULL;

static void switchboard_plug_user_accounts_widgets_crop_view_gesture_press_event (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                           gint n_press,
                                                                           gdouble x,
                                                                           gdouble y);
static void switchboard_plug_user_accounts_widgets_crop_view_gesture_release_event (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                             gint n_press,
                                                                             gdouble x,
                                                                             gdouble y);
static void switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (SwitchboardPlugUserAccountsWidgetsCropView* self);
static void switchboard_plug_user_accounts_widgets_crop_view_motion_event (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                    gdouble event_x,
                                                                    gdouble event_y);
static gboolean switchboard_plug_user_accounts_widgets_crop_view_in_quad (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint qx,
                                                                   gint qy,
                                                                   gint qw,
                                                                   gint qh,
                                                                   gint x,
                                                                   gint y);
static gint switchboard_plug_user_accounts_widgets_crop_view_x_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint ax);
static gint switchboard_plug_user_accounts_widgets_crop_view_y_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint ay);
static gint switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                       gint aw,
                                                                       gint ax);
static gint switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                        gint ah,
                                                                        gint ay);
static void switchboard_plug_user_accounts_widgets_crop_view_draw_func (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                 GtkDrawingArea* drawing_area,
                                                                 cairo_t* cr,
                                                                 gint width,
                                                                 gint height);
static GObject * switchboard_plug_user_accounts_widgets_crop_view_constructor (GType type,
                                                                        guint n_construct_properties,
                                                                        GObjectConstructParam * construct_properties);
static void _switchboard_plug_user_accounts_widgets_crop_view_gesture_press_event_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                                      gint n_press,
                                                                                                      gdouble x,
                                                                                                      gdouble y,
                                                                                                      gpointer self);
static void _switchboard_plug_user_accounts_widgets_crop_view_gesture_release_event_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                                         gint n_press,
                                                                                                         gdouble x,
                                                                                                         gdouble y,
                                                                                                         gpointer self);
static void _switchboard_plug_user_accounts_widgets_crop_view_motion_event_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                                                        gdouble x,
                                                                                                        gdouble y,
                                                                                                        gpointer self);
static void _switchboard_plug_user_accounts_widgets_crop_view_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                                             cairo_t* cr,
                                                                                             gint width,
                                                                                             gint height,
                                                                                             gpointer self);
static void switchboard_plug_user_accounts_widgets_crop_view_finalize (GObject * obj);
static GType switchboard_plug_user_accounts_widgets_crop_view_get_type_once (void);
static void _vala_switchboard_plug_user_accounts_widgets_crop_view_get_property (GObject * object,
                                                                          guint property_id,
                                                                          GValue * value,
                                                                          GParamSpec * pspec);
static void _vala_switchboard_plug_user_accounts_widgets_crop_view_set_property (GObject * object,
                                                                          guint property_id,
                                                                          const GValue * value,
                                                                          GParamSpec * pspec);

static inline gpointer
switchboard_plug_user_accounts_widgets_crop_view_get_instance_private (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	return G_STRUCT_MEMBER_P (self, SwitchboardPlugUserAccountsWidgetsCropView_private_offset);
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_construct (GType object_type,
                                                            GdkPixbuf* pixbuf,
                                                            gint pixel_size)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self = NULL;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	self = (SwitchboardPlugUserAccountsWidgetsCropView*) g_object_new (object_type, "pixbuf", pixbuf, "pixel-size", pixel_size, NULL);
	return self;
}

SwitchboardPlugUserAccountsWidgetsCropView*
switchboard_plug_user_accounts_widgets_crop_view_new (GdkPixbuf* pixbuf,
                                                      gint pixel_size)
{
	return switchboard_plug_user_accounts_widgets_crop_view_construct (SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, pixbuf, pixel_size);
}

/**
     * returns the current selected area as pixbuf
     */
GdkPixbuf*
switchboard_plug_user_accounts_widgets_crop_view_get_selection (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	GdkPixbuf* _tmp0_;
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	_tmp1_ = self->priv->area;
	_tmp2_ = self->priv->area;
	_tmp3_ = self->priv->area;
	_tmp4_ = self->priv->area;
	_tmp5_ = gdk_pixbuf_new_subpixbuf (_tmp0_, _tmp1_.x, _tmp2_.y, _tmp3_.width, _tmp4_.height);
	result = _tmp5_;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_gesture_press_event (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                      gint n_press,
                                                                      gdouble x,
                                                                      gdouble y)
{
	GtkGestureClick* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->click_gesture;
	gtk_gesture_set_state ((GtkGesture*) _tmp0_, GTK_EVENT_SEQUENCE_CLAIMED);
	self->priv->mouse_button_down = TRUE;
	self->priv->temp_x = (gint) x;
	self->priv->temp_y = (gint) y;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_gesture_release_event (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                        gint n_press,
                                                                        gdouble x,
                                                                        gdouble y)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("auto");
	_g_free0 (self->priv->cursor_name);
	self->priv->cursor_name = _tmp0_;
	self->priv->mouse_button_down = FALSE;
	switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (self);
}

static void
switchboard_plug_user_accounts_widgets_crop_view_motion_event (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                               gdouble event_x,
                                                               gdouble event_y)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->mouse_button_down) {
		gboolean determined_cursortype = FALSE;
		static const gchar* CURSOR[8] = {"nw-resize", "n-resize", "ne-resize", "e-resize", "se-resize", "s-resize", "sw-resize", "w-resize"};
		determined_cursortype = FALSE;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					gint* _tmp2_;
					gint _tmp2__length1;
					gint _tmp2__length2;
					gint _tmp3_;
					gint* _tmp4_;
					gint _tmp4__length1;
					gint _tmp4__length2;
					gint _tmp5_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					if (!(i < 8)) {
						break;
					}
					_tmp2_ = self->priv->pos;
					_tmp2__length1 = self->priv->pos_length1;
					_tmp2__length2 = self->priv->pos_length2;
					_tmp3_ = _tmp2_[(i * _tmp2__length2) + 0];
					_tmp4_ = self->priv->pos;
					_tmp4__length1 = self->priv->pos_length1;
					_tmp4__length2 = self->priv->pos_length2;
					_tmp5_ = _tmp4_[(i * _tmp4__length2) + 1];
					if (switchboard_plug_user_accounts_widgets_crop_view_in_quad (self, _tmp3_ - SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS, _tmp5_ - SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS * 2, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_RADIUS * 2, (gint) event_x, (gint) event_y)) {
						const gchar* _tmp6_;
						gchar* _tmp7_;
						_tmp6_ = CURSOR[i];
						_tmp7_ = g_strdup (_tmp6_);
						_g_free0 (self->priv->cursor_name);
						self->priv->cursor_name = _tmp7_;
						determined_cursortype = TRUE;
						break;
					}
				}
			}
		}
		if (!determined_cursortype) {
			GdkRectangle _tmp8_;
			GdkRectangle _tmp9_;
			GdkRectangle _tmp10_;
			GdkRectangle _tmp11_;
			_tmp8_ = self->priv->area;
			_tmp9_ = self->priv->area;
			_tmp10_ = self->priv->area;
			_tmp11_ = self->priv->area;
			if (switchboard_plug_user_accounts_widgets_crop_view_in_quad (self, (gint) floor (_tmp8_.x * self->priv->current_scale), (gint) floor (_tmp9_.y * self->priv->current_scale), (gint) floor (_tmp10_.width * self->priv->current_scale), (gint) floor (_tmp11_.height * self->priv->current_scale), (gint) (event_x - self->priv->offset_x), (gint) (event_y - self->priv->offset_y))) {
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("grab");
				_g_free0 (self->priv->cursor_name);
				self->priv->cursor_name = _tmp12_;
			} else {
				gchar* _tmp13_;
				_tmp13_ = g_strdup ("auto");
				_g_free0 (self->priv->cursor_name);
				self->priv->cursor_name = _tmp13_;
			}
		}
		switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (self);
		return;
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		GQuark _tmp17_ = 0U;
		static GQuark _tmp16_label0 = 0;
		static GQuark _tmp16_label1 = 0;
		static GQuark _tmp16_label2 = 0;
		static GQuark _tmp16_label3 = 0;
		static GQuark _tmp16_label4 = 0;
		static GQuark _tmp16_label5 = 0;
		static GQuark _tmp16_label6 = 0;
		static GQuark _tmp16_label7 = 0;
		static GQuark _tmp16_label8 = 0;
		GdkRectangle _tmp66_;
		GdkRectangle _tmp67_;
		_tmp14_ = self->priv->cursor_name;
		_tmp15_ = _tmp14_;
		_tmp17_ = (NULL == _tmp15_) ? 0 : g_quark_from_string (_tmp15_);
		if (_tmp17_ == ((0 != _tmp16_label0) ? _tmp16_label0 : (_tmp16_label0 = g_quark_from_static_string ("grab")))) {
			switch (0) {
				default:
				{
					gint motion_x = 0;
					GdkRectangle _tmp18_;
					gint motion_y = 0;
					GdkRectangle _tmp19_;
					_tmp18_ = self->priv->area;
					motion_x = (gint) (_tmp18_.x + ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
					_tmp19_ = self->priv->area;
					motion_y = (gint) (_tmp19_.y + ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					switch (switchboard_plug_user_accounts_widgets_crop_view_x_in_pixbuf (self, motion_x)) {
						case 0:
						{
							self->priv->area.x = motion_x;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.x = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp20_;
							GdkRectangle _tmp21_;
							_tmp20_ = self->priv->_pixbuf;
							_tmp21_ = self->priv->area;
							self->priv->area.x = gdk_pixbuf_get_width (_tmp20_) - _tmp21_.width;
							break;
						}
						default:
						break;
					}
					switch (switchboard_plug_user_accounts_widgets_crop_view_y_in_pixbuf (self, motion_y)) {
						case 0:
						{
							self->priv->area.y = motion_y;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.y = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp22_;
							GdkRectangle _tmp23_;
							_tmp22_ = self->priv->_pixbuf;
							_tmp23_ = self->priv->area;
							self->priv->area.y = gdk_pixbuf_get_height (_tmp22_) - _tmp23_.height;
							break;
						}
						default:
						break;
					}
					break;
				}
			}
		} else if ((_tmp17_ == ((0 != _tmp16_label1) ? _tmp16_label1 : (_tmp16_label1 = g_quark_from_static_string ("ne-resize")))) || (_tmp17_ == ((0 != _tmp16_label2) ? _tmp16_label2 : (_tmp16_label2 = g_quark_from_static_string ("nw-resize"))))) {
			switch (0) {
				default:
				{
					gint motion_width = 0;
					gint motion_height = 0;
					const gchar* _tmp24_;
					GdkRectangle _tmp29_;
					GdkRectangle _tmp33_;
					motion_width = 0;
					motion_height = 0;
					_tmp24_ = self->priv->cursor_name;
					if (g_strcmp0 (_tmp24_, "ne-resize") == 0) {
						GdkRectangle _tmp25_;
						GdkRectangle _tmp26_;
						_tmp25_ = self->priv->area;
						motion_width = (gint) (_tmp25_.width + ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
						_tmp26_ = self->priv->area;
						motion_height = (gint) (_tmp26_.height - ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					} else {
						GdkRectangle _tmp27_;
						GdkRectangle _tmp28_;
						_tmp27_ = self->priv->area;
						motion_width = (gint) (_tmp27_.width - ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
						_tmp28_ = self->priv->area;
						motion_height = (gint) (_tmp28_.height - ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					}
					if (motion_width >= motion_height) {
						motion_height = motion_width;
					} else {
						if (motion_width < motion_height) {
							motion_width = motion_height;
						}
					}
					_tmp29_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp29_.x)) {
						case 0:
						{
							GdkRectangle _tmp30_;
							_tmp30_ = self->priv->area;
							if (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp30_.y) == 0) {
								self->priv->area.width = motion_width;
								self->priv->area.height = motion_height;
								g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							}
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp31_;
							GdkRectangle _tmp32_;
							_tmp31_ = self->priv->_pixbuf;
							_tmp32_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp31_) - _tmp32_.x;
							break;
						}
						default:
						break;
					}
					_tmp33_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp33_.y)) {
						case 0:
						{
							GdkRectangle _tmp34_;
							_tmp34_ = self->priv->area;
							if (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp34_.x) == 0) {
								self->priv->area.height = motion_height;
								self->priv->area.width = motion_width;
								g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							}
							break;
						}
						case 1:
						{
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp35_;
							GdkRectangle _tmp36_;
							_tmp35_ = self->priv->_pixbuf;
							_tmp36_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp35_) - _tmp36_.y;
							break;
						}
						default:
						break;
					}
					break;
				}
			}
		} else if ((_tmp17_ == ((0 != _tmp16_label3) ? _tmp16_label3 : (_tmp16_label3 = g_quark_from_static_string ("se-resize")))) || (_tmp17_ == ((0 != _tmp16_label4) ? _tmp16_label4 : (_tmp16_label4 = g_quark_from_static_string ("sw-resize"))))) {
			switch (0) {
				default:
				{
					gint motion_width = 0;
					gint motion_height = 0;
					const gchar* _tmp37_;
					GdkRectangle _tmp42_;
					GdkRectangle _tmp46_;
					motion_width = 0;
					motion_height = 0;
					_tmp37_ = self->priv->cursor_name;
					if (g_strcmp0 (_tmp37_, "se-resize") == 0) {
						GdkRectangle _tmp38_;
						GdkRectangle _tmp39_;
						_tmp38_ = self->priv->area;
						motion_width = (gint) (_tmp38_.width + ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
						_tmp39_ = self->priv->area;
						motion_height = (gint) (_tmp39_.height + ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					} else {
						GdkRectangle _tmp40_;
						GdkRectangle _tmp41_;
						_tmp40_ = self->priv->area;
						motion_width = (gint) (_tmp40_.width - ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
						_tmp41_ = self->priv->area;
						motion_height = (gint) (_tmp41_.height + ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					}
					if (motion_width >= motion_height) {
						motion_height = motion_width;
					} else {
						if (motion_width < motion_height) {
							motion_width = motion_height;
						}
					}
					_tmp42_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp42_.x)) {
						case 0:
						{
							GdkRectangle _tmp43_;
							_tmp43_ = self->priv->area;
							if (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp43_.y) == 0) {
								self->priv->area.width = motion_width;
								self->priv->area.height = motion_height;
								g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							}
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp44_;
							GdkRectangle _tmp45_;
							_tmp44_ = self->priv->_pixbuf;
							_tmp45_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp44_) - _tmp45_.x;
							break;
						}
						default:
						break;
					}
					_tmp46_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp46_.y)) {
						case 0:
						{
							GdkRectangle _tmp47_;
							_tmp47_ = self->priv->area;
							if (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp47_.x) == 0) {
								self->priv->area.height = motion_height;
								self->priv->area.width = motion_width;
								g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							}
							break;
						}
						case 1:
						{
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp48_;
							GdkRectangle _tmp49_;
							_tmp48_ = self->priv->_pixbuf;
							_tmp49_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp48_) - _tmp49_.y;
							break;
						}
						default:
						break;
					}
					break;
				}
			}
		} else if ((_tmp17_ == ((0 != _tmp16_label5) ? _tmp16_label5 : (_tmp16_label5 = g_quark_from_static_string ("n-resize")))) || (_tmp17_ == ((0 != _tmp16_label6) ? _tmp16_label6 : (_tmp16_label6 = g_quark_from_static_string ("s-resize"))))) {
			switch (0) {
				default:
				{
					gint motion_height = 0;
					const gchar* _tmp50_;
					GdkRectangle _tmp53_;
					motion_height = 0;
					_tmp50_ = self->priv->cursor_name;
					if (g_strcmp0 (_tmp50_, "s-resize") == 0) {
						GdkRectangle _tmp51_;
						_tmp51_ = self->priv->area;
						motion_height = (gint) (_tmp51_.height + ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					} else {
						GdkRectangle _tmp52_;
						_tmp52_ = self->priv->area;
						motion_height = (gint) (_tmp52_.height - ((((gint) event_y) - self->priv->temp_y) / self->priv->current_scale));
					}
					_tmp53_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (self, motion_height, _tmp53_.y)) {
						case 0:
						{
							self->priv->area.width = motion_height;
							self->priv->area.height = motion_height;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp54_;
							GdkRectangle _tmp55_;
							GdkPixbuf* _tmp56_;
							GdkRectangle _tmp57_;
							_tmp54_ = self->priv->_pixbuf;
							_tmp55_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp54_) - _tmp55_.x;
							_tmp56_ = self->priv->_pixbuf;
							_tmp57_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp56_) - _tmp57_.y;
							break;
						}
						default:
						break;
					}
					break;
				}
			}
		} else if ((_tmp17_ == ((0 != _tmp16_label7) ? _tmp16_label7 : (_tmp16_label7 = g_quark_from_static_string ("e-resize")))) || (_tmp17_ == ((0 != _tmp16_label8) ? _tmp16_label8 : (_tmp16_label8 = g_quark_from_static_string ("w-resize"))))) {
			switch (0) {
				default:
				{
					gint motion_width = 0;
					const gchar* _tmp58_;
					GdkRectangle _tmp61_;
					motion_width = 0;
					_tmp58_ = self->priv->cursor_name;
					if (g_strcmp0 (_tmp58_, "e-resize") == 0) {
						GdkRectangle _tmp59_;
						_tmp59_ = self->priv->area;
						motion_width = (gint) (_tmp59_.width + ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
					} else {
						GdkRectangle _tmp60_;
						_tmp60_ = self->priv->area;
						motion_width = (gint) (_tmp60_.width - ((((gint) event_x) - self->priv->temp_x) / self->priv->current_scale));
					}
					_tmp61_ = self->priv->area;
					switch (switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (self, motion_width, _tmp61_.x)) {
						case 0:
						{
							self->priv->area.width = motion_width;
							self->priv->area.height = motion_width;
							g_signal_emit (self, switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL], 0);
							break;
						}
						case 1:
						{
							self->priv->area.width = 0;
							self->priv->area.height = 0;
							break;
						}
						case 2:
						{
							GdkPixbuf* _tmp62_;
							GdkRectangle _tmp63_;
							GdkPixbuf* _tmp64_;
							GdkRectangle _tmp65_;
							_tmp62_ = self->priv->_pixbuf;
							_tmp63_ = self->priv->area;
							self->priv->area.width = gdk_pixbuf_get_width (_tmp62_) - _tmp63_.x;
							_tmp64_ = self->priv->_pixbuf;
							_tmp65_ = self->priv->area;
							self->priv->area.height = gdk_pixbuf_get_height (_tmp64_) - _tmp65_.y;
							break;
						}
						default:
						break;
					}
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					break;
				}
			}
		}
		_tmp66_ = self->priv->area;
		_tmp67_ = self->priv->area;
		if (_tmp66_.width != _tmp67_.height) {
			gint _tmp68_ = 0;
			GdkRectangle _tmp69_;
			GdkRectangle _tmp70_;
			gint smallest = 0;
			_tmp69_ = self->priv->area;
			_tmp70_ = self->priv->area;
			if (_tmp69_.width > _tmp70_.height) {
				GdkRectangle _tmp71_;
				_tmp71_ = self->priv->area;
				_tmp68_ = _tmp71_.height;
			} else {
				GdkRectangle _tmp72_;
				_tmp72_ = self->priv->area;
				_tmp68_ = _tmp72_.width;
			}
			smallest = _tmp68_;
			self->priv->area.width = smallest;
			self->priv->area.height = smallest;
		}
		self->priv->temp_x = (gint) event_x;
		self->priv->temp_y = (gint) event_y;
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}

static void
switchboard_plug_user_accounts_widgets_crop_view_draw_func (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                            GtkDrawingArea* drawing_area,
                                                            cairo_t* cr,
                                                            gint width,
                                                            gint height)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	gint pixbuf_width = 0;
	GdkPixbuf* _tmp1_;
	gint pixbuf_height = 0;
	GdkPixbuf* _tmp2_;
	gdouble scale = 0.0;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp6_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* _tmp10_;
	GtkAllocation _tmp11_;
	GtkAllocation _tmp12_;
	GdkPixbuf* _tmp13_;
	gint x = 0;
	GdkRectangle _tmp14_;
	gint y = 0;
	GdkRectangle _tmp15_;
	gint w = 0;
	GdkRectangle _tmp16_;
	gint h = 0;
	GdkRectangle _tmp17_;
	gint* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (drawing_area != NULL);
	g_return_if_fail (cr != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = self->priv->_pixbuf;
	pixbuf_width = gdk_pixbuf_get_width (_tmp1_);
	_tmp2_ = self->priv->_pixbuf;
	pixbuf_height = gdk_pixbuf_get_height (_tmp2_);
	scale = 1.0;
	_tmp3_ = alloc;
	if (pixbuf_width > _tmp3_.width) {
		GtkAllocation _tmp4_;
		GtkAllocation _tmp5_;
		_tmp4_ = alloc;
		scale = _tmp4_.width / ((gdouble) pixbuf_width);
		pixbuf_height = (gint) floor (scale * pixbuf_height);
		_tmp5_ = alloc;
		pixbuf_width = _tmp5_.width;
	}
	_tmp6_ = alloc;
	if (pixbuf_height > _tmp6_.height) {
		GtkAllocation _tmp7_;
		GtkAllocation _tmp8_;
		_tmp7_ = alloc;
		scale = _tmp7_.height / ((gdouble) pixbuf_height);
		pixbuf_width = (gint) floor (scale * pixbuf_width);
		_tmp8_ = alloc;
		pixbuf_height = _tmp8_.height;
	}
	_tmp9_ = self->priv->_pixbuf;
	_tmp10_ = gdk_pixbuf_scale_simple (_tmp9_, pixbuf_width, pixbuf_height, GDK_INTERP_BILINEAR);
	pixbuf = _tmp10_;
	_tmp11_ = alloc;
	self->priv->offset_x = (_tmp11_.width / 2) - (pixbuf_width / 2);
	_tmp12_ = alloc;
	self->priv->offset_y = (_tmp12_.height / 2) - (pixbuf_height / 2);
	gdk_cairo_set_source_pixbuf (cr, pixbuf, (gdouble) self->priv->offset_x, (gdouble) self->priv->offset_y);
	cairo_paint (cr);
	_tmp13_ = self->priv->_pixbuf;
	scale = pixbuf_width / ((gdouble) gdk_pixbuf_get_width (_tmp13_));
	_tmp14_ = self->priv->area;
	x = self->priv->offset_x + ((gint) floor (_tmp14_.x * scale));
	_tmp15_ = self->priv->area;
	y = self->priv->offset_y + ((gint) floor (_tmp15_.y * scale));
	_tmp16_ = self->priv->area;
	w = (gint) floor (_tmp16_.width * scale);
	_tmp17_ = self->priv->area;
	h = (gint) floor (_tmp17_.height * scale);
	_tmp18_ = g_new0 (gint, 8 * 2);
	_tmp18_[0] = x;
	_tmp18_[1] = y;
	_tmp18_[2] = x + (w / 2);
	_tmp18_[3] = y;
	_tmp18_[4] = x + w;
	_tmp18_[5] = y;
	_tmp18_[6] = x + w;
	_tmp18_[7] = y + (h / 2);
	_tmp18_[8] = x + w;
	_tmp18_[9] = y + h;
	_tmp18_[10] = x + (w / 2);
	_tmp18_[11] = y + h;
	_tmp18_[12] = x;
	_tmp18_[13] = y + h;
	_tmp18_[14] = x;
	_tmp18_[15] = y + (h / 2);
	self->priv->pos = (g_free (self->priv->pos), NULL);
	self->priv->pos = _tmp18_;
	self->priv->pos_length1 = 8;
	self->priv->pos_length2 = 2;
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_set_source_rgba (cr, 0.1, 0.1, 0.1, 0.2);
	cairo_fill (cr);
	cairo_rectangle (cr, (gdouble) x, (gdouble) y, (gdouble) w, (gdouble) h);
	cairo_set_source_rgb (cr, 1.0, 1.0, 1.0);
	cairo_set_line_width (cr, 1.0);
	cairo_stroke (cr);
	self->priv->current_scale = scale;
	_g_object_unref0 (pixbuf);
}

static gboolean
switchboard_plug_user_accounts_widgets_crop_view_in_quad (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                          gint qx,
                                                          gint qy,
                                                          gint qw,
                                                          gint qh,
                                                          gint x,
                                                          gint y)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (x > qx) {
		_tmp2_ = x < (qx + qw);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = y > qy;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = y < (qy + qh);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_apply_cursor (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	GtkRoot* _tmp0_;
	GdkSurface* _tmp1_;
	const gchar* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp1_ = gtk_native_get_surface ((GtkNative*) _tmp0_);
	_tmp2_ = self->priv->cursor_name;
	_tmp3_ = gdk_cursor_new_from_name (_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	gdk_surface_set_cursor (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_x_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                              gint ax)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (ax < 0) {
		result = 1;
		return result;
	} else {
		GdkRectangle _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = self->priv->area;
		_tmp1_ = self->priv->_pixbuf;
		if ((ax + _tmp0_.width) > gdk_pixbuf_get_width (_tmp1_)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_y_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                              gint ay)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (ay < 0) {
		result = 1;
		return result;
	} else {
		GdkRectangle _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = self->priv->area;
		_tmp1_ = self->priv->_pixbuf;
		if ((ay + _tmp0_.height) > gdk_pixbuf_get_height (_tmp1_)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_width_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                  gint aw,
                                                                  gint ax)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (aw < 0) {
		result = 1;
		return result;
	} else {
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->_pixbuf;
		if (aw > (gdk_pixbuf_get_width (_tmp0_) - ax)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

static gint
switchboard_plug_user_accounts_widgets_crop_view_height_in_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                   gint ah,
                                                                   gint ay)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	if (ah < 0) {
		result = 1;
		return result;
	} else {
		GdkPixbuf* _tmp0_;
		_tmp0_ = self->priv->_pixbuf;
		if (ah > (gdk_pixbuf_get_height (_tmp0_) - ay)) {
			result = 2;
			return result;
		}
	}
	result = 0;
	return result;
}

GdkPixbuf*
switchboard_plug_user_accounts_widgets_crop_view_get_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	GdkPixbuf* result;
	GdkPixbuf* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_pixbuf;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_set_pixbuf (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                             GdkPixbuf* value)
{
	GdkPixbuf* old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_crop_view_get_pixbuf (self);
	if (old_value != value) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_pixbuf);
		self->priv->_pixbuf = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY]);
	}
}

gint
switchboard_plug_user_accounts_widgets_crop_view_get_pixel_size (SwitchboardPlugUserAccountsWidgetsCropView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_pixel_size;
	return result;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_set_pixel_size (SwitchboardPlugUserAccountsWidgetsCropView* self,
                                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = switchboard_plug_user_accounts_widgets_crop_view_get_pixel_size (self);
	if (old_value != value) {
		self->priv->_pixel_size = value;
		g_object_notify_by_pspec ((GObject *) self, switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXEL_SIZE_PROPERTY]);
	}
}

static void
_switchboard_plug_user_accounts_widgets_crop_view_gesture_press_event_gtk_gesture_click_pressed (GtkGestureClick* _sender,
                                                                                                 gint n_press,
                                                                                                 gdouble x,
                                                                                                 gdouble y,
                                                                                                 gpointer self)
{
	switchboard_plug_user_accounts_widgets_crop_view_gesture_press_event ((SwitchboardPlugUserAccountsWidgetsCropView*) self, n_press, x, y);
}

static void
_switchboard_plug_user_accounts_widgets_crop_view_gesture_release_event_gtk_gesture_click_released (GtkGestureClick* _sender,
                                                                                                    gint n_press,
                                                                                                    gdouble x,
                                                                                                    gdouble y,
                                                                                                    gpointer self)
{
	switchboard_plug_user_accounts_widgets_crop_view_gesture_release_event ((SwitchboardPlugUserAccountsWidgetsCropView*) self, n_press, x, y);
}

static void
_switchboard_plug_user_accounts_widgets_crop_view_motion_event_gtk_event_controller_motion_motion (GtkEventControllerMotion* _sender,
                                                                                                   gdouble x,
                                                                                                   gdouble y,
                                                                                                   gpointer self)
{
	switchboard_plug_user_accounts_widgets_crop_view_motion_event ((SwitchboardPlugUserAccountsWidgetsCropView*) self, x, y);
}

static void
_switchboard_plug_user_accounts_widgets_crop_view_draw_func_gtk_drawing_area_draw_func (GtkDrawingArea* drawing_area,
                                                                                        cairo_t* cr,
                                                                                        gint width,
                                                                                        gint height,
                                                                                        gpointer self)
{
	switchboard_plug_user_accounts_widgets_crop_view_draw_func ((SwitchboardPlugUserAccountsWidgetsCropView*) self, drawing_area, cr, width, height);
}

static GObject *
switchboard_plug_user_accounts_widgets_crop_view_constructor (GType type,
                                                              guint n_construct_properties,
                                                              GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	gint area_dimension = 0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	gint area_position_x = 0;
	GdkPixbuf* _tmp2_;
	gint area_position_y = 0;
	GdkPixbuf* _tmp3_;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_;
	gint _tmp6_;
	GdkPixbuf* _tmp7_;
	GdkPixbuf* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	GdkPixbuf* _tmp11_;
	GdkPixbuf* _tmp12_;
	GtkGestureClick* _tmp13_;
	GtkGestureClick* _tmp14_;
	GtkGestureClick* _tmp15_;
	GtkEventControllerMotion* motion_event_controller = NULL;
	GtkEventControllerMotion* _tmp16_;
	GtkEventControllerMotion* _tmp17_;
	GtkGestureClick* _tmp18_;
	GtkEventController* _tmp19_;
	GtkEventControllerMotion* _tmp20_;
	GtkEventController* _tmp21_;
	parent_class = G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_crop_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	_tmp0_ = self->priv->_pixbuf;
	_tmp1_ = self->priv->_pixbuf;
	area_dimension = (MIN (gdk_pixbuf_get_width (_tmp0_), gdk_pixbuf_get_height (_tmp1_)) * 3) / 4;
	_tmp2_ = self->priv->_pixbuf;
	area_position_x = (gdk_pixbuf_get_width (_tmp2_) - area_dimension) / 2;
	_tmp3_ = self->priv->_pixbuf;
	area_position_y = (gdk_pixbuf_get_height (_tmp3_) - area_dimension) / 2;
	_tmp4_.x = area_position_x;
	_tmp4_.y = area_position_y;
	_tmp4_.width = area_dimension;
	_tmp4_.height = area_dimension;
	self->priv->area = _tmp4_;
	_tmp5_ = self->priv->_pixel_size;
	_tmp6_ = self->priv->_pixel_size;
	_tmp7_ = self->priv->_pixbuf;
	_tmp8_ = self->priv->_pixbuf;
	g_object_set ((GtkWidget*) self, "width-request", MIN (_tmp5_, (_tmp6_ * gdk_pixbuf_get_width (_tmp7_)) / gdk_pixbuf_get_height (_tmp8_)), NULL);
	_tmp9_ = self->priv->_pixel_size;
	_tmp10_ = self->priv->_pixel_size;
	_tmp11_ = self->priv->_pixbuf;
	_tmp12_ = self->priv->_pixbuf;
	g_object_set ((GtkWidget*) self, "height-request", MIN (_tmp9_, (_tmp10_ * gdk_pixbuf_get_height (_tmp11_)) / gdk_pixbuf_get_width (_tmp12_)), NULL);
	_tmp13_ = (GtkGestureClick*) gtk_gesture_click_new ();
	_g_object_unref0 (self->priv->click_gesture);
	self->priv->click_gesture = _tmp13_;
	_tmp14_ = self->priv->click_gesture;
	g_signal_connect_object (_tmp14_, "pressed", (GCallback) _switchboard_plug_user_accounts_widgets_crop_view_gesture_press_event_gtk_gesture_click_pressed, self, 0);
	_tmp15_ = self->priv->click_gesture;
	g_signal_connect_object (_tmp15_, "released", (GCallback) _switchboard_plug_user_accounts_widgets_crop_view_gesture_release_event_gtk_gesture_click_released, self, 0);
	_tmp16_ = (GtkEventControllerMotion*) gtk_event_controller_motion_new ();
	motion_event_controller = _tmp16_;
	_tmp17_ = motion_event_controller;
	g_signal_connect_object (_tmp17_, "motion", (GCallback) _switchboard_plug_user_accounts_widgets_crop_view_motion_event_gtk_event_controller_motion_motion, self, 0);
	_tmp18_ = self->priv->click_gesture;
	_tmp19_ = _g_object_ref0 ((GtkEventController*) _tmp18_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp19_);
	_tmp20_ = motion_event_controller;
	_tmp21_ = _g_object_ref0 ((GtkEventController*) _tmp20_);
	gtk_widget_add_controller ((GtkWidget*) self, _tmp21_);
	gtk_drawing_area_set_draw_func ((GtkDrawingArea*) self, _switchboard_plug_user_accounts_widgets_crop_view_draw_func_gtk_drawing_area_draw_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (motion_event_controller);
	return obj;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_class_init (SwitchboardPlugUserAccountsWidgetsCropViewClass * klass,
                                                             gpointer klass_data)
{
	switchboard_plug_user_accounts_widgets_crop_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SwitchboardPlugUserAccountsWidgetsCropView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_switchboard_plug_user_accounts_widgets_crop_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_switchboard_plug_user_accounts_widgets_crop_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = switchboard_plug_user_accounts_widgets_crop_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = switchboard_plug_user_accounts_widgets_crop_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY, switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY] = g_param_spec_object ("pixbuf", "pixbuf", "pixbuf", gdk_pixbuf_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXEL_SIZE_PROPERTY, switchboard_plug_user_accounts_widgets_crop_view_properties[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXEL_SIZE_PROPERTY] = g_param_spec_int ("pixel-size", "pixel-size", "pixel-size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	     * signal that is emitted when the selection area is changed in any way
	     */
	switchboard_plug_user_accounts_widgets_crop_view_signals[SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_AREA_CHANGED_SIGNAL] = g_signal_new ("area-changed", SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
switchboard_plug_user_accounts_widgets_crop_view_instance_init (SwitchboardPlugUserAccountsWidgetsCropView * self,
                                                                gpointer klass)
{
	gint* _tmp0_;
	gchar* _tmp1_;
	self->priv = switchboard_plug_user_accounts_widgets_crop_view_get_instance_private (self);
	_tmp0_ = g_new0 (gint, 8 * 2);
	_tmp0_[0] = 0;
	_tmp0_[1] = 0;
	_tmp0_[2] = 0;
	_tmp0_[3] = 0;
	_tmp0_[4] = 0;
	_tmp0_[5] = 0;
	_tmp0_[6] = 0;
	_tmp0_[7] = 0;
	_tmp0_[8] = 0;
	_tmp0_[9] = 0;
	_tmp0_[10] = 0;
	_tmp0_[11] = 0;
	_tmp0_[12] = 0;
	_tmp0_[13] = 0;
	_tmp0_[14] = 0;
	_tmp0_[15] = 0;
	self->priv->pos = _tmp0_;
	self->priv->pos_length1 = 8;
	self->priv->pos_length2 = 2;
	_tmp1_ = g_strdup ("auto");
	self->priv->cursor_name = _tmp1_;
	self->priv->mouse_button_down = FALSE;
}

static void
switchboard_plug_user_accounts_widgets_crop_view_finalize (GObject * obj)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	_g_object_unref0 (self->priv->_pixbuf);
	self->priv->pos = (g_free (self->priv->pos), NULL);
	_g_free0 (self->priv->cursor_name);
	_g_object_unref0 (self->priv->click_gesture);
	G_OBJECT_CLASS (switchboard_plug_user_accounts_widgets_crop_view_parent_class)->finalize (obj);
}

static GType
switchboard_plug_user_accounts_widgets_crop_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SwitchboardPlugUserAccountsWidgetsCropViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) switchboard_plug_user_accounts_widgets_crop_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwitchboardPlugUserAccountsWidgetsCropView), 0, (GInstanceInitFunc) switchboard_plug_user_accounts_widgets_crop_view_instance_init, NULL };
	GType switchboard_plug_user_accounts_widgets_crop_view_type_id;
	switchboard_plug_user_accounts_widgets_crop_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SwitchboardPlugUserAccountsWidgetsCropView", &g_define_type_info, 0);
	SwitchboardPlugUserAccountsWidgetsCropView_private_offset = g_type_add_instance_private (switchboard_plug_user_accounts_widgets_crop_view_type_id, sizeof (SwitchboardPlugUserAccountsWidgetsCropViewPrivate));
	return switchboard_plug_user_accounts_widgets_crop_view_type_id;
}

GType
switchboard_plug_user_accounts_widgets_crop_view_get_type (void)
{
	static volatile gsize switchboard_plug_user_accounts_widgets_crop_view_type_id__once = 0;
	if (g_once_init_enter (&switchboard_plug_user_accounts_widgets_crop_view_type_id__once)) {
		GType switchboard_plug_user_accounts_widgets_crop_view_type_id;
		switchboard_plug_user_accounts_widgets_crop_view_type_id = switchboard_plug_user_accounts_widgets_crop_view_get_type_once ();
		g_once_init_leave (&switchboard_plug_user_accounts_widgets_crop_view_type_id__once, switchboard_plug_user_accounts_widgets_crop_view_type_id);
	}
	return switchboard_plug_user_accounts_widgets_crop_view_type_id__once;
}

static void
_vala_switchboard_plug_user_accounts_widgets_crop_view_get_property (GObject * object,
                                                                     guint property_id,
                                                                     GValue * value,
                                                                     GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY:
		g_value_set_object (value, switchboard_plug_user_accounts_widgets_crop_view_get_pixbuf (self));
		break;
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXEL_SIZE_PROPERTY:
		g_value_set_int (value, switchboard_plug_user_accounts_widgets_crop_view_get_pixel_size (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_switchboard_plug_user_accounts_widgets_crop_view_set_property (GObject * object,
                                                                     guint property_id,
                                                                     const GValue * value,
                                                                     GParamSpec * pspec)
{
	SwitchboardPlugUserAccountsWidgetsCropView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_TYPE_CROP_VIEW, SwitchboardPlugUserAccountsWidgetsCropView);
	switch (property_id) {
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXBUF_PROPERTY:
		switchboard_plug_user_accounts_widgets_crop_view_set_pixbuf (self, g_value_get_object (value));
		break;
		case SWITCHBOARD_PLUG_USER_ACCOUNTS_WIDGETS_CROP_VIEW_PIXEL_SIZE_PROPERTY:
		switchboard_plug_user_accounts_widgets_crop_view_set_pixel_size (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

