/* WifiPage.c generated by valac 0.56.17, the Vala compiler
 * generated from WifiPage.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-2.1-or-later
 * SPDX-FileCopyrightText: 2015-2024 elementary, Inc. (https://elementary.io)
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include "network.h"
#include <NetworkManager.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib-object.h>
#include <switchboard.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <granite-7.h>
#include <gio/gio.h>
#include <nma-wifi-dialog.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_WIFI_INTERFACE_0_PROPERTY,
	NETWORK_WIFI_INTERFACE_NUM_PROPERTIES
};
static GParamSpec* network_wifi_interface_properties[NETWORK_WIFI_INTERFACE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rf_kill_device_unref0(var) ((var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _NetworkWifiInterfaceConnectToNetworkData NetworkWifiInterfaceConnectToNetworkData;

struct _NetworkWifiInterfacePrivate {
	RFKillManager* rfkill;
	NMAccessPoint* active_ap;
	GtkListBox* wifi_list;
	NetworkWifiMenuItem* _active_wifi_item;
	GtkStack* placeholder;
	gboolean locked;
	gboolean software_locked;
	gboolean hardware_locked;
	guint timeout_scan;
};

struct _Block9Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	GraniteMessageDialog* settings_dialog;
};

struct _Block10Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMClient* client;
};

struct _Block11Data {
	int _ref_count_;
	Block10Data * _data10_;
	NMAWifiDialog* wifi_dialog;
};

struct _Block12Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMAWifiDialog* hidden_dialog;
};

struct _Block13Data {
	int _ref_count_;
	NetworkWifiInterface* self;
	NMConnection* fuzzy;
	NMConnection* dialog_connection;
	gpointer _async_data_;
};

struct _NetworkWifiInterfaceConnectToNetworkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkWifiInterface* self;
	NMAWifiDialog* wifi_dialog;
	Block13Data* _data13_;
	NMDevice* dialog_device;
	NMAccessPoint* dialog_ap;
	NMDevice* _tmp0_;
	NMAccessPoint* _tmp1_;
	NMConnection* _tmp2_;
	NetworkNetworkManager* network_manager;
	NetworkNetworkManager* _tmp3_;
	NMClient* client;
	NetworkNetworkManager* _tmp4_;
	NMClient* _tmp5_;
	NMClient* _tmp6_;
	NMClient* _tmp7_;
	GPtrArray* _tmp8_;
	gchar* path;
	NMAccessPoint* _tmp9_;
	NMAccessPoint* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	NMConnection* _tmp13_;
	NMClient* _tmp14_;
	NMConnection* _tmp15_;
	NMDeviceWifi* _tmp16_;
	const gchar* _tmp17_;
	NMActiveConnection* _tmp18_;
	NMActiveConnection* _tmp19_;
	GError* _error_;
	GError* _tmp20_;
	const gchar* _tmp21_;
	gchar* mode;
	NMSettingWireless* setting_wireless;
	NMConnection* _tmp22_;
	NMSettingWireless* _tmp23_;
	NMSettingWireless* _tmp24_;
	NMSettingWireless* _tmp25_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	const gchar* _tmp28_;
	NMSettingConnection* connection_setting;
	NMConnection* _tmp29_;
	NMSettingConnection* _tmp30_;
	NMSettingConnection* _tmp31_;
	NMSettingConnection* _tmp32_;
	NMSettingConnection* _tmp33_;
	NMConnection* _tmp34_;
	NMSettingConnection* _tmp35_;
	NMSetting* _tmp36_;
	NMClient* _tmp37_;
	NMConnection* _tmp38_;
	NMDevice* _tmp39_;
	const gchar* _tmp40_;
	NMActiveConnection* _tmp41_;
	NMActiveConnection* _tmp42_;
	GError* _vala1__error_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	GError* _inner_error0_;
};

static gint NetworkWifiInterface_private_offset;
static gpointer network_wifi_interface_parent_class = NULL;

static void network_wifi_interface_real_update_name (NetworkWidgetsPage* base,
                                              gint count);
static void network_wifi_interface_access_point_added_cb (NetworkWifiInterface* self,
                                                   GObject* ap_);
static void network_wifi_interface_wifi_activate_cb (NetworkWifiInterface* self,
                                              NetworkWifiMenuItem* row);
static void _network_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action (NetworkWifiMenuItem* _sender,
                                                                                  gpointer self);
static void network_wifi_interface_update_active_ap (NetworkWifiInterface* self);
static NetworkWifiMenuItem* network_wifi_interface_get_active_wifi_item (NetworkWifiInterface* self);
static void network_wifi_interface_set_active_wifi_item (NetworkWifiInterface* self,
                                                  NetworkWifiMenuItem* value);
static void network_wifi_interface_access_point_removed_cb (NetworkWifiInterface* self,
                                                     GObject* ap_);
static void network_wifi_interface_real_update (NetworkWidgetsPage* base);
static void network_wifi_interface_cancel_scan (NetworkWifiInterface* self);
static void network_wifi_interface_set_scan_placeholder (NetworkWifiInterface* self);
static void _rf_kill_device_unref0_ (gpointer var);
static inline void _g_list_free__rf_kill_device_unref0_ (GList* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void _gtk_window_present_network_wifi_menu_item_settings_request (NetworkWifiMenuItem* _sender,
                                                                  gpointer self);
static void ____lambda28_ (Block9Data* _data9_,
                    gint response);
static void _____lambda28__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void network_wifi_interface_real_update_status (NetworkWidgetsPage* base);
static void network_wifi_interface_real_update_switch (NetworkWidgetsPage* base);
static void network_wifi_interface_real_control_switch_activated (NetworkWidgetsPage* base);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static NMConnection* network_wifi_interface_get_valid_connection (NetworkWifiInterface* self,
                                                           NMAccessPoint* ap,
                                                           GPtrArray* ap_connections);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void ___lambda23_ (Block11Data* _data11_,
                   gint response);
static void network_wifi_interface_connect_to_network (NetworkWifiInterface* self,
                                                NMAWifiDialog* wifi_dialog,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void network_wifi_interface_connect_to_network_finish (NetworkWifiInterface* self,
                                                       GAsyncResult* _res_);
static void ____lambda23__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void ___lambda25_ (Block10Data* _data10_,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda25__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static gboolean __lambda26_ (NetworkWifiInterface* self);
static gboolean ___lambda26__gsource_func (gpointer self);
static void network_wifi_interface_connect_to_hidden (NetworkWifiInterface* self);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static void __lambda29_ (Block12Data* _data12_,
                  gint response);
static void ___lambda29__gtk_dialog_response (GtkDialog* _sender,
                                       gint response_id,
                                       gpointer self);
static void network_wifi_interface_connect_to_network_data_free (gpointer _data);
static gboolean network_wifi_interface_connect_to_network_co (NetworkWifiInterfaceConnectToNetworkData* _data_);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void __lambda24_ (Block13Data* _data13_,
                  NMRemoteConnection* possible);
static void ___lambda24__gfunc (gconstpointer data,
                         gpointer self);
static void network_wifi_interface_connect_to_network_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static gboolean ___lambda27_ (NetworkWifiInterface* self);
static gboolean ____lambda27__gsource_func (gpointer self);
static gint network_wifi_interface_sort_func (NetworkWifiInterface* self,
                                       GtkListBoxRow* r1,
                                       GtkListBoxRow* r2);
static GObject * network_wifi_interface_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static gint _network_wifi_interface_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                               GtkListBoxRow* row2,
                                                               gpointer self);
static void _network_widgets_page_edit_connections_gtk_button_clicked (GtkButton* _sender,
                                                                gpointer self);
static void _network_wifi_interface_connect_to_hidden_gtk_button_clicked (GtkButton* _sender,
                                                                   gpointer self);
static void _network_widgets_page_update_rf_kill_manager_device_added (RFKillManager* _sender,
                                                                RFKillDevice* device,
                                                                gpointer self);
static void _network_widgets_page_update_rf_kill_manager_device_changed (RFKillManager* _sender,
                                                                  RFKillDevice* device,
                                                                  gpointer self);
static void _network_widgets_page_update_rf_kill_manager_device_deleted (RFKillManager* _sender,
                                                                  RFKillDevice* device,
                                                                  gpointer self);
static void _network_widgets_page_update_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self);
static void _network_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added (NMDeviceWifi* _sender,
                                                                                      GObject* ap,
                                                                                      gpointer self);
static void _network_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed (NMDeviceWifi* _sender,
                                                                                          GObject* ap,
                                                                                          gpointer self);
static void _network_widgets_page_update_nm_device_state_changed (NMDevice* _sender,
                                                           guint new_state,
                                                           guint old_state,
                                                           guint reason,
                                                           gpointer self);
static void _network_wifi_interface_access_point_added_cb_gfunc (gconstpointer data,
                                                          gpointer self);
static void network_wifi_interface_finalize (GObject * obj);
static GType network_wifi_interface_get_type_once (void);
static void _vala_network_wifi_interface_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_network_wifi_interface_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
network_wifi_interface_get_instance_private (NetworkWifiInterface* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkWifiInterface_private_offset);
}

NetworkWifiInterface*
network_wifi_interface_construct (GType object_type,
                                  NMDevice* device)
{
	NetworkWifiInterface * self = NULL;
	g_return_val_if_fail (device != NULL, NULL);
	self = (NetworkWifiInterface*) g_object_new (object_type, "activatable", TRUE, "device", device, NULL);
	return self;
}

NetworkWifiInterface*
network_wifi_interface_new (NMDevice* device)
{
	return network_wifi_interface_construct (NETWORK_TYPE_WIFI_INTERFACE, device);
}

static void
network_wifi_interface_real_update_name (NetworkWidgetsPage* base,
                                         gint count)
{
	NetworkWifiInterface * self;
	self = (NetworkWifiInterface*) base;
	if (count <= 1) {
		switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _ ("Wireless"));
	} else {
		NMDevice* _tmp0_;
		NMDevice* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = nm_device_get_description (_tmp1_);
		switchboard_settings_page_set_title ((SwitchboardSettingsPage*) self, _tmp2_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_network_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action (NetworkWifiMenuItem* _sender,
                                                                             gpointer self)
{
	network_wifi_interface_wifi_activate_cb ((NetworkWifiInterface*) self, _sender);
}

static void
network_wifi_interface_access_point_added_cb (NetworkWifiInterface* self,
                                              GObject* ap_)
{
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp0_;
	gboolean found = FALSE;
	NMAccessPoint* _tmp1_;
	GBytes* _tmp2_;
	GBytes* _tmp3_;
	gboolean _tmp20_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap_ != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ap_, nm_access_point_get_type (), NMAccessPoint));
	ap = _tmp0_;
	found = FALSE;
	_tmp1_ = ap;
	_tmp2_ = nm_access_point_get_ssid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		GtkWidget* child = NULL;
		GtkListBox* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = self->priv->wifi_list;
		_tmp5_ = gtk_widget_get_first_child ((GtkWidget*) _tmp4_);
		child = _tmp5_;
		while (TRUE) {
			GtkWidget* _tmp6_;
			GtkWidget* _tmp7_;
			GtkWidget* _tmp18_;
			GtkWidget* _tmp19_;
			_tmp6_ = child;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = child;
			if (NETWORK_IS_WIFI_MENU_ITEM (_tmp7_)) {
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp8_;
				NetworkWifiMenuItem* _tmp9_;
				NMAccessPoint* _tmp10_;
				GBytes* _tmp11_;
				GBytes* _tmp12_;
				NetworkWifiMenuItem* _tmp13_;
				GBytes* _tmp14_;
				GBytes* _tmp15_;
				_tmp8_ = child;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp9_;
				_tmp10_ = ap;
				_tmp11_ = nm_access_point_get_ssid (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = menu_item;
				_tmp14_ = network_wifi_menu_item_get_ssid (_tmp13_);
				_tmp15_ = _tmp14_;
				if (g_bytes_compare (_tmp12_, _tmp15_) == 0) {
					NetworkWifiMenuItem* _tmp16_;
					NMAccessPoint* _tmp17_;
					found = TRUE;
					_tmp16_ = menu_item;
					_tmp17_ = ap;
					network_wifi_menu_item_add_ap (_tmp16_, _tmp17_);
					_g_object_unref0 (menu_item);
					break;
				}
				_g_object_unref0 (menu_item);
			}
			_tmp18_ = child;
			_tmp19_ = gtk_widget_get_next_sibling (_tmp18_);
			child = _tmp19_;
		}
	}
	if (!found) {
		NMAccessPoint* _tmp21_;
		GBytes* _tmp22_;
		GBytes* _tmp23_;
		_tmp21_ = ap;
		_tmp22_ = nm_access_point_get_ssid (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp20_ = _tmp23_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		NetworkWifiMenuItem* item = NULL;
		NMAccessPoint* _tmp24_;
		NetworkWifiMenuItem* _tmp25_;
		NetworkWifiMenuItem* _tmp26_;
		GtkListBox* _tmp27_;
		NetworkWifiMenuItem* _tmp28_;
		_tmp24_ = ap;
		_tmp25_ = network_wifi_menu_item_new (_tmp24_);
		g_object_ref_sink (_tmp25_);
		item = _tmp25_;
		_tmp26_ = item;
		g_signal_connect_object (_tmp26_, "user-action", (GCallback) _network_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action, self, 0);
		_tmp27_ = self->priv->wifi_list;
		_tmp28_ = item;
		gtk_list_box_append (_tmp27_, (GtkWidget*) _tmp28_);
		network_widgets_page_update ((NetworkWidgetsPage*) self);
		_g_object_unref0 (item);
	}
	_g_object_unref0 (ap);
}

static void
network_wifi_interface_update_active_ap (NetworkWifiInterface* self)
{
	NMDeviceWifi* _tmp0_;
	NMAccessPoint* _tmp1_;
	NMAccessPoint* _tmp2_;
	NetworkWifiMenuItem* _tmp3_;
	NMAccessPoint* _tmp8_;
	g_return_if_fail (self != NULL);
	g_debug ("WifiPage.vala:192: Update active AP");
	_tmp0_ = self->wifi_device;
	_tmp1_ = nm_device_wifi_get_active_access_point (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->active_ap);
	self->priv->active_ap = _tmp2_;
	_tmp3_ = self->priv->_active_wifi_item;
	if (_tmp3_ != NULL) {
		NetworkWifiMenuItem* _tmp4_;
		NMDeviceState _tmp5_;
		NMDeviceState _tmp6_;
		_tmp4_ = self->priv->_active_wifi_item;
		_tmp5_ = network_wifi_menu_item_get_state (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NM_DEVICE_STATE_PREPARE) {
			NetworkWifiMenuItem* _tmp7_;
			_tmp7_ = self->priv->_active_wifi_item;
			network_wifi_menu_item_set_state (_tmp7_, NM_DEVICE_STATE_DISCONNECTED);
		}
		network_wifi_interface_set_active_wifi_item (self, NULL);
	}
	_tmp8_ = self->priv->active_ap;
	if (_tmp8_ == NULL) {
		g_debug ("WifiPage.vala:204: No active AP");
	} else {
		NMAccessPoint* _tmp9_;
		GBytes* _tmp10_;
		gsize _tmp11_ = 0;
		guint8* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gboolean found = FALSE;
		GtkWidget* child = NULL;
		GtkListBox* _tmp15_;
		GtkWidget* _tmp16_;
		_tmp9_ = self->priv->active_ap;
		_tmp10_ = nm_access_point_get_ssid (_tmp9_);
		_tmp12_ = g_bytes_get_data (_tmp10_, &_tmp11_);
		_tmp13_ = nm_utils_ssid_to_utf8 (_tmp12_, (gsize) _tmp11_);
		_tmp14_ = _tmp13_;
		g_debug ("WifiPage.vala:206: Active ap: %s", _tmp14_);
		_g_free0 (_tmp14_);
		found = FALSE;
		_tmp15_ = self->priv->wifi_list;
		_tmp16_ = gtk_widget_get_first_child ((GtkWidget*) _tmp15_);
		child = _tmp16_;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			GtkWidget* _tmp18_;
			GtkWidget* _tmp19_;
			GtkWidget* _tmp33_;
			GtkWidget* _tmp34_;
			_tmp18_ = child;
			if (_tmp18_ != NULL) {
				_tmp17_ = !found;
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp19_ = child;
			if (NETWORK_IS_WIFI_MENU_ITEM (_tmp19_)) {
				NetworkWifiMenuItem* menu_item = NULL;
				GtkWidget* _tmp20_;
				NetworkWifiMenuItem* _tmp21_;
				NMAccessPoint* _tmp22_;
				GBytes* _tmp23_;
				GBytes* _tmp24_;
				NetworkWifiMenuItem* _tmp25_;
				GBytes* _tmp26_;
				GBytes* _tmp27_;
				_tmp20_ = child;
				_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
				menu_item = _tmp21_;
				_tmp22_ = self->priv->active_ap;
				_tmp23_ = nm_access_point_get_ssid (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = menu_item;
				_tmp26_ = network_wifi_menu_item_get_ssid (_tmp25_);
				_tmp27_ = _tmp26_;
				if (g_bytes_compare (_tmp24_, _tmp27_) == 0) {
					NetworkWifiMenuItem* _tmp28_;
					NetworkWifiMenuItem* _tmp29_;
					NetworkWifiMenuItem* _tmp30_;
					NMDeviceState _tmp31_;
					NMDeviceState _tmp32_;
					found = TRUE;
					_tmp28_ = menu_item;
					network_wifi_menu_item_set_active (_tmp28_, TRUE);
					_tmp29_ = menu_item;
					network_wifi_interface_set_active_wifi_item (self, _tmp29_);
					_tmp30_ = self->priv->_active_wifi_item;
					_tmp31_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
					_tmp32_ = _tmp31_;
					network_wifi_menu_item_set_state (_tmp30_, _tmp32_);
				}
				_g_object_unref0 (menu_item);
			}
			_tmp33_ = child;
			_tmp34_ = gtk_widget_get_next_sibling (_tmp33_);
			child = _tmp34_;
		}
		if (!found) {
			g_debug ("WifiPage.vala:227: Active AP not added");
		}
	}
}

static void
network_wifi_interface_access_point_removed_cb (NetworkWifiInterface* self,
                                                GObject* ap_)
{
	NMAccessPoint* ap = NULL;
	NMAccessPoint* _tmp0_;
	NetworkWifiMenuItem* found_item = NULL;
	GtkWidget* child = NULL;
	GtkListBox* _tmp1_;
	GtkWidget* _tmp2_;
	NetworkWifiMenuItem* _tmp19_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ap_ != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (ap_, nm_access_point_get_type (), NMAccessPoint));
	ap = _tmp0_;
	found_item = NULL;
	_tmp1_ = self->priv->wifi_list;
	_tmp2_ = gtk_widget_get_first_child ((GtkWidget*) _tmp1_);
	child = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		GtkWidget* _tmp4_;
		GtkWidget* _tmp6_;
		GtkWidget* _tmp17_;
		GtkWidget* _tmp18_;
		_tmp4_ = child;
		if (_tmp4_ != NULL) {
			NetworkWifiMenuItem* _tmp5_;
			_tmp5_ = found_item;
			_tmp3_ = _tmp5_ == NULL;
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = child;
		if (NETWORK_IS_WIFI_MENU_ITEM (_tmp6_)) {
			NetworkWifiMenuItem* menu_item = NULL;
			GtkWidget* _tmp7_;
			NetworkWifiMenuItem* _tmp8_;
			NMAccessPoint* _tmp9_;
			GBytes* _tmp10_;
			GBytes* _tmp11_;
			NetworkWifiMenuItem* _tmp12_;
			GBytes* _tmp13_;
			GBytes* _tmp14_;
			_tmp7_ = child;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
			menu_item = _tmp8_;
			_tmp9_ = ap;
			_tmp10_ = nm_access_point_get_ssid (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = menu_item;
			_tmp13_ = network_wifi_menu_item_get_ssid (_tmp12_);
			_tmp14_ = _tmp13_;
			if (g_bytes_compare (_tmp11_, _tmp14_) == 0) {
				NetworkWifiMenuItem* _tmp15_;
				NetworkWifiMenuItem* _tmp16_;
				_tmp15_ = menu_item;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_g_object_unref0 (found_item);
				found_item = _tmp16_;
			}
			_g_object_unref0 (menu_item);
		}
		_tmp17_ = child;
		_tmp18_ = gtk_widget_get_next_sibling (_tmp17_);
		child = _tmp18_;
	}
	_tmp19_ = found_item;
	if (_tmp19_ == NULL) {
		g_critical ("WifiPage.vala:250: Couldn't remove an access point which has not been " \
"added.");
	} else {
		NetworkWifiMenuItem* _tmp20_;
		NMAccessPoint* _tmp21_;
		_tmp20_ = found_item;
		_tmp21_ = ap;
		if (!network_wifi_menu_item_remove_ap (_tmp20_, _tmp21_)) {
			NetworkWifiMenuItem* _tmp22_;
			_tmp22_ = found_item;
			g_signal_emit_by_name ((GtkWidget*) _tmp22_, "destroy");
		}
	}
	network_widgets_page_update ((NetworkWidgetsPage*) self);
	_g_object_unref0 (found_item);
	_g_object_unref0 (ap);
}

static gpointer
_rf_kill_device_ref0 (gpointer self)
{
	return self ? rf_kill_device_ref (self) : NULL;
}

static void
_rf_kill_device_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (rf_kill_device_unref (var), NULL));
}

static inline void
_g_list_free__rf_kill_device_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _rf_kill_device_unref0_);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data9_->self;
		_g_object_unref0 (_data9_->settings_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}

static void
_gtk_window_present_network_wifi_menu_item_settings_request (NetworkWifiMenuItem* _sender,
                                                             gpointer self)
{
	gtk_window_present ((GtkWindow*) self);
}

static void
____lambda28_ (Block9Data* _data9_,
               gint response)
{
	NetworkWifiInterface* self;
	GraniteMessageDialog* _tmp0_;
	self = _data9_->self;
	if (response == 0) {
		network_widgets_page_open_advanced_settings ((NetworkWidgetsPage*) self);
	}
	_tmp0_ = _data9_->settings_dialog;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
_____lambda28__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	____lambda28_ (self, response_id);
}

static void
network_wifi_interface_real_update (NetworkWidgetsPage* base)
{
	NetworkWifiInterface * self;
	gboolean sensitive = FALSE;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	GtkButton* _tmp2_;
	NetworkWifiMenuItem* old_active = NULL;
	NetworkWifiMenuItem* _tmp6_;
	NetworkWifiMenuItem* _tmp7_;
	NMDeviceWifi* _tmp8_;
	NMDeviceWifi* _tmp9_;
	NMDeviceState _tmp10_;
	NMDeviceState _tmp11_;
	NMDeviceWifi* _tmp17_;
	NMDeviceState _tmp18_;
	NMDeviceState _tmp19_;
	NMDeviceState _tmp20_;
	NMDeviceState _tmp21_;
	GEnumValue* _tmp22_;
	RFKillManager* _tmp23_;
	GList* _tmp24_;
	gboolean _tmp35_ = FALSE;
	gboolean is_hotspot = FALSE;
	NMDeviceWifi* _tmp36_;
	NMAccessPoint* active_access_point = NULL;
	NMDeviceWifi* _tmp37_;
	NMAccessPoint* _tmp38_;
	NMAccessPoint* _tmp39_;
	gboolean _tmp40_ = FALSE;
	NMAccessPoint* _tmp41_;
	GtkRevealer* _tmp42_;
	gboolean _tmp47_ = FALSE;
	NMAccessPoint* _tmp48_;
	self = (NetworkWifiInterface*) base;
	_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp1_ = _tmp0_;
	sensitive = nm_device_get_state (_tmp1_) == NM_DEVICE_STATE_ACTIVATED;
	_tmp2_ = self->hidden_btn;
	if (_tmp2_ != NULL) {
		GtkButton* _tmp3_;
		NMDeviceState _tmp4_;
		NMDeviceState _tmp5_;
		_tmp3_ = self->hidden_btn;
		_tmp4_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
		_tmp5_ = _tmp4_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_ != NM_DEVICE_STATE_UNAVAILABLE);
	}
	_tmp6_ = self->priv->_active_wifi_item;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	old_active = _tmp7_;
	_tmp8_ = self->wifi_device;
	if (network_utils_get_device_is_hotspot (_tmp8_)) {
		network_widgets_page_set_state ((NetworkWidgetsPage*) self, NM_DEVICE_STATE_DISCONNECTED);
		_g_object_unref0 (old_active);
		return;
	}
	_tmp9_ = self->wifi_device;
	_tmp10_ = nm_device_get_state ((NMDevice*) _tmp9_);
	_tmp11_ = _tmp10_;
	switch (_tmp11_) {
		case NM_DEVICE_STATE_UNKNOWN:
		case NM_DEVICE_STATE_UNMANAGED:
		case NM_DEVICE_STATE_FAILED:
		{
			NetworkWifiMenuItem* _tmp12_;
			_tmp12_ = self->priv->_active_wifi_item;
			if (_tmp12_ != NULL) {
				NetworkWifiMenuItem* _tmp13_;
				NMDeviceState _tmp14_;
				NMDeviceState _tmp15_;
				_tmp13_ = self->priv->_active_wifi_item;
				_tmp14_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
				_tmp15_ = _tmp14_;
				network_wifi_menu_item_set_state (_tmp13_, _tmp15_);
			}
			network_wifi_interface_cancel_scan (self);
			break;
		}
		case NM_DEVICE_STATE_DEACTIVATING:
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			GtkStack* _tmp16_;
			network_wifi_interface_cancel_scan (self);
			_tmp16_ = self->priv->placeholder;
			gtk_stack_set_visible_child_name (_tmp16_, "wireless-off");
			break;
		}
		default:
		{
			network_wifi_interface_set_scan_placeholder (self);
			break;
		}
	}
	_tmp17_ = self->wifi_device;
	_tmp18_ = nm_device_get_state ((NMDevice*) _tmp17_);
	_tmp19_ = _tmp18_;
	network_widgets_page_set_state ((NetworkWidgetsPage*) self, _tmp19_);
	_tmp20_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_enum_get_value (g_type_class_ref (nm_device_state_get_type ()), _tmp21_);
	g_debug ("WifiPage.vala:295: New network state: %s", (_tmp22_ != NULL) ? _tmp22_->value_name : NULL);
	self->priv->software_locked = FALSE;
	self->priv->hardware_locked = FALSE;
	_tmp23_ = self->priv->rfkill;
	_tmp24_ = rf_kill_manager_get_devices (_tmp23_);
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp24_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			RFKillDevice* _tmp25_;
			RFKillDevice* device = NULL;
			_tmp25_ = _rf_kill_device_ref0 ((RFKillDevice*) device_it->data);
			device = _tmp25_;
			{
				RFKillDevice* _tmp26_;
				RFKillDeviceType _tmp27_;
				RFKillDeviceType _tmp28_;
				RFKillDevice* _tmp29_;
				gboolean _tmp30_;
				gboolean _tmp31_;
				RFKillDevice* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp26_ = device;
				_tmp27_ = rf_kill_device_get_device_type (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ != RF_KILL_DEVICE_TYPE_WLAN) {
					_rf_kill_device_unref0 (device);
					continue;
				}
				_tmp29_ = device;
				_tmp30_ = rf_kill_device_get_software_lock (_tmp29_);
				_tmp31_ = _tmp30_;
				if (_tmp31_) {
					self->priv->software_locked = TRUE;
				}
				_tmp32_ = device;
				_tmp33_ = rf_kill_device_get_hardware_lock (_tmp32_);
				_tmp34_ = _tmp33_;
				if (_tmp34_) {
					self->priv->hardware_locked = TRUE;
				}
				_rf_kill_device_unref0 (device);
			}
		}
		(device_collection == NULL) ? NULL : (device_collection = (_g_list_free__rf_kill_device_unref0_ (device_collection), NULL));
	}
	if (self->priv->hardware_locked) {
		_tmp35_ = TRUE;
	} else {
		_tmp35_ = self->priv->software_locked;
	}
	self->priv->locked = _tmp35_;
	network_wifi_interface_update_active_ap (self);
	NETWORK_WIDGETS_PAGE_CLASS (network_wifi_interface_parent_class)->update (G_TYPE_CHECK_INSTANCE_CAST (self, NETWORK_WIDGETS_TYPE_PAGE, NetworkWidgetsPage));
	_tmp36_ = self->wifi_device;
	is_hotspot = network_utils_get_device_is_hotspot (_tmp36_);
	_tmp37_ = self->wifi_device;
	_tmp38_ = nm_device_wifi_get_active_access_point (_tmp37_);
	_tmp39_ = _tmp38_;
	active_access_point = _tmp39_;
	_tmp41_ = active_access_point;
	if (_tmp41_ != NULL) {
		_tmp40_ = !is_hotspot;
	} else {
		_tmp40_ = FALSE;
	}
	_tmp42_ = self->top_revealer;
	gtk_revealer_set_reveal_child (_tmp42_, _tmp40_);
	if (is_hotspot) {
		GtkStack* _tmp43_;
		GtkBox* _tmp44_;
		_tmp43_ = self->list_stack;
		_tmp44_ = self->hotspot_mode_alert;
		gtk_stack_set_visible_child (_tmp43_, (GtkWidget*) _tmp44_);
	} else {
		GtkStack* _tmp45_;
		GtkScrolledWindow* _tmp46_;
		_tmp45_ = self->list_stack;
		_tmp46_ = self->scrolled;
		gtk_stack_set_visible_child (_tmp45_, (GtkWidget*) _tmp46_);
	}
	_tmp48_ = active_access_point;
	if (_tmp48_ == NULL) {
		NetworkWifiMenuItem* _tmp49_;
		_tmp49_ = old_active;
		_tmp47_ = _tmp49_ != NULL;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		NetworkWifiMenuItem* _tmp50_;
		gboolean _tmp51_ = FALSE;
		GtkFrame* _tmp52_;
		_tmp50_ = old_active;
		gtk_widget_set_visible ((GtkWidget*) _tmp50_, TRUE);
		_tmp52_ = self->connected_frame;
		if (_tmp52_ != NULL) {
			GtkFrame* _tmp53_;
			GtkWidget* _tmp54_;
			_tmp53_ = self->connected_frame;
			_tmp54_ = gtk_frame_get_child (_tmp53_);
			_tmp51_ = _tmp54_ != NULL;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			GtkFrame* _tmp55_;
			GtkWidget* _tmp56_;
			_tmp55_ = self->connected_frame;
			_tmp56_ = gtk_frame_get_child (_tmp55_);
			g_signal_emit_by_name (_tmp56_, "destroy");
		}
	} else {
		gboolean _tmp57_ = FALSE;
		NMAccessPoint* _tmp58_;
		_tmp58_ = active_access_point;
		if (_tmp58_ != NULL) {
			NetworkWifiMenuItem* _tmp59_;
			NetworkWifiMenuItem* _tmp60_;
			_tmp59_ = self->priv->_active_wifi_item;
			_tmp60_ = old_active;
			_tmp57_ = _tmp59_ != _tmp60_;
		} else {
			_tmp57_ = FALSE;
		}
		if (_tmp57_) {
			Block9Data* _data9_;
			NetworkWifiMenuItem* _tmp61_;
			NetworkWifiMenuItem* _tmp69_;
			NetworkWifiMenuItem* top_item = NULL;
			NMAccessPoint* _tmp70_;
			NetworkWifiMenuItem* _tmp71_ = NULL;
			GtkListBox* connected_listbox = NULL;
			GtkListBox* _tmp72_ = NULL;
			GtkListBox* _tmp73_;
			GtkListBox* _tmp74_;
			NetworkWifiMenuItem* _tmp75_;
			GtkListBox* _tmp76_;
			GtkWidget* _tmp77_;
			GtkFrame* _tmp78_;
			GtkListBox* _tmp79_;
			NetworkWifiMenuItem* _tmp80_;
			GtkLabel* _tmp81_;
			GtkLabel* _tmp82_;
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			NetworkWifiMenuItem* _tmp85_;
			GtkLabel* _tmp86_;
			GtkLabel* _tmp87_;
			const gchar* _tmp88_;
			const gchar* _tmp89_;
			NetworkWifiMenuItem* _tmp90_;
			GtkImage* _tmp91_;
			GtkImage* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			gchar* _tmp95_;
			GApplication* _tmp96_;
			GtkWindow* _tmp97_;
			GtkWindow* _tmp98_;
			GtkWindow* _tmp99_;
			GraniteMessageDialog* _tmp100_ = NULL;
			GraniteMessageDialog* _tmp101_;
			GraniteMessageDialog* _tmp102_;
			GraniteMessageDialog* _tmp103_;
			GraniteMessageDialog* _tmp104_;
			GtkBox* _tmp105_;
			GtkBox* _tmp106_;
			NetworkWidgetsInfoBox* _tmp107_;
			NetworkWifiMenuItem* _tmp108_;
			NetworkWifiMenuItem* _tmp109_;
			GraniteMessageDialog* _tmp110_;
			GraniteMessageDialog* _tmp111_;
			_data9_ = g_slice_new0 (Block9Data);
			_data9_->_ref_count_ = 1;
			_data9_->self = g_object_ref (self);
			_tmp61_ = old_active;
			if (_tmp61_ != NULL) {
				NetworkWifiMenuItem* _tmp62_;
				gboolean _tmp63_ = FALSE;
				GtkFrame* _tmp64_;
				_tmp62_ = old_active;
				gtk_widget_set_visible ((GtkWidget*) _tmp62_, TRUE);
				_tmp64_ = self->connected_frame;
				if (_tmp64_ != NULL) {
					GtkFrame* _tmp65_;
					GtkWidget* _tmp66_;
					_tmp65_ = self->connected_frame;
					_tmp66_ = gtk_frame_get_child (_tmp65_);
					_tmp63_ = _tmp66_ != NULL;
				} else {
					_tmp63_ = FALSE;
				}
				if (_tmp63_) {
					GtkFrame* _tmp67_;
					GtkWidget* _tmp68_;
					_tmp67_ = self->connected_frame;
					_tmp68_ = gtk_frame_get_child (_tmp67_);
					g_signal_emit_by_name (_tmp68_, "destroy");
				}
			}
			_tmp69_ = self->priv->_active_wifi_item;
			gtk_widget_set_visible ((GtkWidget*) _tmp69_, FALSE);
			_tmp70_ = active_access_point;
			_tmp71_ = network_wifi_menu_item_new (_tmp70_);
			network_wifi_menu_item_set_state (_tmp71_, NM_DEVICE_STATE_ACTIVATED);
			g_object_ref_sink (_tmp71_);
			top_item = _tmp71_;
			_tmp72_ = (GtkListBox*) gtk_list_box_new ();
			gtk_list_box_set_selection_mode (_tmp72_, GTK_SELECTION_NONE);
			g_object_ref_sink (_tmp72_);
			connected_listbox = _tmp72_;
			_tmp73_ = connected_listbox;
			gtk_widget_add_css_class ((GtkWidget*) _tmp73_, GRANITE_STYLE_CLASS_RICH_LIST);
			_tmp74_ = connected_listbox;
			_tmp75_ = top_item;
			gtk_list_box_append (_tmp74_, (GtkWidget*) _tmp75_);
			_tmp76_ = connected_listbox;
			_tmp77_ = gtk_widget_get_first_child ((GtkWidget*) _tmp76_);
			gtk_widget_set_focusable (_tmp77_, FALSE);
			_tmp78_ = self->connected_frame;
			_tmp79_ = connected_listbox;
			gtk_frame_set_child (_tmp78_, (GtkWidget*) _tmp79_);
			_tmp80_ = top_item;
			_tmp81_ = network_wifi_menu_item_get_ssid_label (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = gtk_label_get_label (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = top_item;
			_tmp86_ = network_wifi_menu_item_get_status_label (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = gtk_label_get_label (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = top_item;
			_tmp91_ = network_wifi_menu_item_get_img_strength (_tmp90_);
			_tmp92_ = _tmp91_;
			g_object_get (_tmp92_, "icon-name", &_tmp93_, NULL);
			_tmp94_ = _tmp93_;
			_tmp95_ = _tmp94_;
			_tmp96_ = g_application_get_default ();
			_tmp97_ = gtk_application_get_active_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp96_, gtk_application_get_type (), GtkApplication));
			_tmp98_ = _tmp97_;
			_tmp99_ = _g_object_ref0 (_tmp98_);
			_tmp100_ = granite_message_dialog_new_with_image_from_icon_name (_tmp84_, _tmp89_, _tmp95_, GTK_BUTTONS_NONE);
			gtk_window_set_modal ((GtkWindow*) _tmp100_, TRUE);
			gtk_window_set_transient_for ((GtkWindow*) _tmp100_, _tmp99_);
			_g_object_unref0 (_tmp99_);
			g_object_ref_sink (_tmp100_);
			_tmp101_ = _tmp100_;
			_g_free0 (_tmp95_);
			_data9_->settings_dialog = _tmp101_;
			_tmp102_ = _data9_->settings_dialog;
			granite_dialog_add_button ((GraniteDialog*) _tmp102_, _ ("Advanced…"), 0);
			_tmp103_ = _data9_->settings_dialog;
			granite_dialog_add_button ((GraniteDialog*) _tmp103_, _ ("Close"), (gint) GTK_RESPONSE_CLOSE);
			_tmp104_ = _data9_->settings_dialog;
			_tmp105_ = granite_message_dialog_get_custom_bin (_tmp104_);
			_tmp106_ = _tmp105_;
			_tmp107_ = ((NetworkWidgetsPage*) self)->info_box;
			gtk_box_append (_tmp106_, (GtkWidget*) _tmp107_);
			_tmp108_ = top_item;
			g_signal_connect_object (_tmp108_, "user-action", (GCallback) _network_wifi_interface_wifi_activate_cb_network_wifi_menu_item_user_action, self, 0);
			_tmp109_ = top_item;
			_tmp110_ = _data9_->settings_dialog;
			g_signal_connect_object (_tmp109_, "settings-request", (GCallback) _gtk_window_present_network_wifi_menu_item_settings_request, (GtkWindow*) _tmp110_, 0);
			_tmp111_ = _data9_->settings_dialog;
			g_signal_connect_data ((GtkDialog*) _tmp111_, "response", (GCallback) _____lambda28__gtk_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
			_g_object_unref0 (connected_listbox);
			_g_object_unref0 (top_item);
			block9_data_unref (_data9_);
			_data9_ = NULL;
		}
	}
	_g_object_unref0 (old_active);
}

static void
network_wifi_interface_real_update_status (NetworkWidgetsPage* base)
{
	NetworkWifiInterface * self;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceState _tmp2_;
	NMDeviceState _tmp3_;
	NMDevice* _tmp4_;
	NMDevice* _tmp5_;
	NMDeviceState _tmp6_;
	NMDeviceState _tmp7_;
	self = (NetworkWifiInterface*) base;
	_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = nm_device_get_state (_tmp1_);
	_tmp3_ = _tmp2_;
	switch (_tmp3_) {
		case NM_DEVICE_STATE_ACTIVATED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_SUCCESS);
			break;
		}
		case NM_DEVICE_STATE_DISCONNECTED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_OFFLINE);
			break;
		}
		case NM_DEVICE_STATE_FAILED:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_ERROR);
			break;
		}
		default:
		{
			switchboard_settings_page_set_status_type ((SwitchboardSettingsPage*) self, SWITCHBOARD_SETTINGS_PAGE_STATUS_TYPE_WARNING);
			break;
		}
	}
	_tmp4_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = nm_device_get_state (_tmp5_);
	_tmp7_ = _tmp6_;
	switch (_tmp7_) {
		case NM_DEVICE_STATE_UNAVAILABLE:
		{
			switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _ ("Disabled"));
			break;
		}
		case NM_DEVICE_STATE_ACTIVATED:
		{
			NMDevice* _tmp8_;
			NMDevice* _tmp9_;
			NMAccessPoint* _tmp10_;
			NMAccessPoint* _tmp11_;
			GBytes* _tmp12_;
			gsize _tmp13_ = 0;
			guint8* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp8_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = nm_device_wifi_get_active_access_point (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, nm_device_wifi_get_type (), NMDeviceWifi));
			_tmp11_ = _tmp10_;
			_tmp12_ = nm_access_point_get_ssid (_tmp11_);
			_tmp14_ = g_bytes_get_data (_tmp12_, &_tmp13_);
			_tmp15_ = nm_utils_ssid_to_utf8 (_tmp14_, (gsize) _tmp13_);
			_tmp16_ = _tmp15_;
			switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _tmp16_);
			_g_free0 (_tmp16_);
			break;
		}
		default:
		{
			NMDevice* _tmp17_;
			NMDevice* _tmp18_;
			NMDeviceState _tmp19_;
			NMDeviceState _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp17_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = nm_device_get_state (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = network_utils_state_to_string (_tmp20_);
			_tmp22_ = _tmp21_;
			switchboard_settings_page_set_status ((SwitchboardSettingsPage*) self, _tmp22_);
			_g_free0 (_tmp22_);
			break;
		}
	}
}

static void
network_wifi_interface_real_update_switch (NetworkWidgetsPage* base)
{
	NetworkWifiInterface * self;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	self = (NetworkWifiInterface*) base;
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	gtk_switch_set_active (_tmp1_, !self->priv->software_locked);
}

static void
network_wifi_interface_real_control_switch_activated (NetworkWidgetsPage* base)
{
	NetworkWifiInterface * self;
	gboolean active = FALSE;
	GtkSwitch* _tmp0_;
	GtkSwitch* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (NetworkWifiInterface*) base;
	_tmp0_ = switchboard_settings_page_get_status_switch ((SwitchboardSettingsPage*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_switch_get_active (_tmp1_);
	_tmp3_ = _tmp2_;
	active = _tmp3_;
	if (active == self->priv->software_locked) {
		RFKillManager* _tmp4_;
		NetworkNetworkManager* network_manager = NULL;
		NetworkNetworkManager* _tmp5_;
		NetworkNetworkManager* _tmp6_;
		NMClient* _tmp7_;
		NMClient* _tmp8_;
		_tmp4_ = self->priv->rfkill;
		rf_kill_manager_set_software_lock (_tmp4_, RF_KILL_DEVICE_TYPE_WLAN, !active);
		_tmp5_ = network_network_manager_get_default ();
		network_manager = _tmp5_;
		_tmp6_ = network_manager;
		_tmp7_ = network_network_manager_get_client (_tmp6_);
		_tmp8_ = _tmp7_;
		nm_client_wireless_set_enabled (_tmp8_, active);
	}
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data10_->self;
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static gpointer
_g_ptr_array_ref0 (gpointer self)
{
	return self ? g_ptr_array_ref (self) : NULL;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data11_->_data10_->self;
		_g_object_unref0 (_data11_->wifi_dialog);
		block10_data_unref (_data11_->_data10_);
		_data11_->_data10_ = NULL;
		g_slice_free (Block11Data, _data11_);
	}
}

static void
___lambda23_ (Block11Data* _data11_,
              gint response)
{
	Block10Data* _data10_;
	NetworkWifiInterface* self;
	NMAWifiDialog* _tmp1_;
	_data10_ = _data11_->_data10_;
	self = _data10_->self;
	if (response == ((gint) GTK_RESPONSE_OK)) {
		NMAWifiDialog* _tmp0_;
		_tmp0_ = _data11_->wifi_dialog;
		network_wifi_interface_connect_to_network (self, _tmp0_, NULL, NULL);
	}
	_tmp1_ = _data11_->wifi_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp1_);
}

static void
____lambda23__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
	___lambda23_ (self, response_id);
}

static gpointer
_g_bytes_ref0 (gpointer self)
{
	return self ? g_bytes_ref (self) : NULL;
}

static void
___lambda25_ (Block10Data* _data10_,
              GObject* obj,
              GAsyncResult* res)
{
	NetworkWifiInterface* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	{
		NMClient* _tmp0_;
		NMActiveConnection* _tmp1_;
		NMActiveConnection* _tmp2_;
		_tmp0_ = _data10_->client;
		_tmp1_ = nm_client_add_and_activate_connection_finish (_tmp0_, res, &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		g_warning ("WifiPage.vala:539: %s", _tmp4_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda25__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda25_ (self, source_object, res);
	block10_data_unref (self);
}

static gboolean
__lambda26_ (NetworkWifiInterface* self)
{
	gboolean result;
	network_widgets_page_update ((NetworkWidgetsPage*) self);
	result = FALSE;
	return result;
}

static gboolean
___lambda26__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda26_ ((NetworkWifiInterface*) self);
	return result;
}

static void
network_wifi_interface_wifi_activate_cb (NetworkWifiInterface* self,
                                         NetworkWifiMenuItem* row)
{
	Block10Data* _data10_;
	NMDevice* _tmp0_;
	NMDevice* _tmp1_;
	NMDeviceWifi* _tmp2_;
	NMAccessPoint* _tmp3_;
	NMAccessPoint* _tmp4_;
	NMAccessPoint* _tmp5_;
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp10_;
	NetworkNetworkManager* _tmp11_;
	NMClient* _tmp12_;
	NMClient* _tmp13_;
	GPtrArray* connections = NULL;
	NMClient* _tmp14_;
	GPtrArray* _tmp15_;
	GPtrArray* _tmp16_;
	GPtrArray* device_connections = NULL;
	NMDeviceWifi* _tmp17_;
	GPtrArray* _tmp18_;
	GPtrArray* _tmp19_;
	GPtrArray* ap_connections = NULL;
	NMAccessPoint* _tmp20_;
	NMAccessPoint* _tmp21_;
	GPtrArray* _tmp22_;
	GPtrArray* _tmp23_;
	NMConnection* valid_connection = NULL;
	NMAccessPoint* _tmp24_;
	NMAccessPoint* _tmp25_;
	GPtrArray* _tmp26_;
	NMConnection* _tmp27_;
	NMConnection* _tmp28_;
	NMConnection* connection = NULL;
	NMConnection* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp2_ = self->wifi_device;
	_tmp3_ = nm_device_wifi_get_active_access_point (_tmp2_);
	_tmp4_ = network_wifi_menu_item_get_ap (row);
	_tmp5_ = _tmp4_;
	if (_tmp3_ == _tmp5_) {
		{
			NMDevice* _tmp6_;
			NMDevice* _tmp7_;
			_tmp6_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
			_tmp7_ = _tmp6_;
			nm_device_disconnect (_tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_warning ("WifiPage.vala:442: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block10_data_unref (_data10_);
			_data10_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp10_ = network_network_manager_get_default ();
	network_manager = _tmp10_;
	_tmp11_ = network_manager;
	_tmp12_ = network_network_manager_get_client (_tmp11_);
	_tmp13_ = _tmp12_;
	_data10_->client = _tmp13_;
	_tmp14_ = _data10_->client;
	_tmp15_ = nm_client_get_connections (_tmp14_);
	_tmp16_ = _g_ptr_array_ref0 (_tmp15_);
	connections = _tmp16_;
	_tmp17_ = self->wifi_device;
	_tmp18_ = connections;
	_tmp19_ = nm_device_filter_connections ((NMDevice*) _tmp17_, _tmp18_);
	device_connections = _tmp19_;
	_tmp20_ = network_wifi_menu_item_get_ap (row);
	_tmp21_ = _tmp20_;
	_tmp22_ = device_connections;
	_tmp23_ = nm_access_point_filter_connections (_tmp21_, _tmp22_);
	ap_connections = _tmp23_;
	_tmp24_ = network_wifi_menu_item_get_ap (row);
	_tmp25_ = _tmp24_;
	_tmp26_ = ap_connections;
	_tmp27_ = network_wifi_interface_get_valid_connection (self, _tmp25_, _tmp26_);
	valid_connection = _tmp27_;
	_tmp28_ = valid_connection;
	if (_tmp28_ != NULL) {
		NMClient* _tmp29_;
		NMConnection* _tmp30_;
		NMDeviceWifi* _tmp31_;
		NMAccessPoint* _tmp32_;
		NMAccessPoint* _tmp33_;
		const gchar* _tmp34_;
		_tmp29_ = _data10_->client;
		_tmp30_ = valid_connection;
		_tmp31_ = self->wifi_device;
		_tmp32_ = network_wifi_menu_item_get_ap (row);
		_tmp33_ = _tmp32_;
		_tmp34_ = nm_object_get_path ((NMObject*) _tmp33_);
		nm_client_activate_connection_async (_tmp29_, _tmp30_, (NMDevice*) _tmp31_, _tmp34_, NULL, NULL, NULL);
		_g_object_unref0 (valid_connection);
		_g_ptr_array_unref0 (ap_connections);
		_g_ptr_array_unref0 (device_connections);
		_g_ptr_array_unref0 (connections);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp35_ = nm_simple_connection_new ();
	connection = _tmp35_;
	_tmp36_ = network_wifi_menu_item_get_is_secured (row);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		Block11Data* _data11_;
		NMSettingConnection* s_con = NULL;
		gchar* _tmp38_;
		NMSettingConnection* _tmp39_ = NULL;
		NMConnection* _tmp40_;
		NMSettingConnection* _tmp41_;
		NMSetting* _tmp42_;
		gboolean _tmp43_ = FALSE;
		NMAccessPoint* _tmp44_;
		NMAccessPoint* _tmp45_;
		NMSettingWireless* s_wifi = NULL;
		NMSettingWireless* _tmp53_;
		NMSettingWireless* _tmp54_;
		NMAccessPoint* _tmp55_;
		NMAccessPoint* _tmp56_;
		GBytes* _tmp57_;
		NMConnection* _tmp58_;
		NMSettingWireless* _tmp59_;
		NMSetting* _tmp60_;
		gboolean _tmp61_ = FALSE;
		NMAccessPoint* _tmp62_;
		NMAccessPoint* _tmp63_;
		NMClient* _tmp77_;
		NMConnection* _tmp78_;
		NMDeviceWifi* _tmp79_;
		NMAccessPoint* _tmp80_;
		NMAccessPoint* _tmp81_;
		GtkRoot* _tmp82_;
		GtkWindow* _tmp83_;
		NMAWifiDialog* _tmp84_ = NULL;
		NMAWifiDialog* _tmp85_;
		NMAWifiDialog* _tmp86_;
		_data11_ = g_slice_new0 (Block11Data);
		_data11_->_ref_count_ = 1;
		_data11_->_data10_ = block10_data_ref (_data10_);
		_tmp38_ = nm_utils_uuid_generate ();
		_tmp39_ = (NMSettingConnection*) nm_setting_connection_new ();
		g_object_set (_tmp39_, "uuid", _tmp38_, NULL);
		_g_free0 (_tmp38_);
		s_con = _tmp39_;
		_tmp40_ = connection;
		_tmp41_ = s_con;
		_tmp42_ = _g_object_ref0 ((NMSetting*) _tmp41_);
		nm_connection_add_setting (_tmp40_, _tmp42_);
		_tmp44_ = network_wifi_menu_item_get_ap (row);
		_tmp45_ = _tmp44_;
		if ((nm_access_point_get_rsn_flags (_tmp45_) & NM_802_11_AP_SEC_KEY_MGMT_SAE) == NM_802_11_AP_SEC_KEY_MGMT_SAE) {
			_tmp43_ = TRUE;
		} else {
			NMAccessPoint* _tmp46_;
			NMAccessPoint* _tmp47_;
			_tmp46_ = network_wifi_menu_item_get_ap (row);
			_tmp47_ = _tmp46_;
			_tmp43_ = (nm_access_point_get_wpa_flags (_tmp47_) & NM_802_11_AP_SEC_KEY_MGMT_SAE) == NM_802_11_AP_SEC_KEY_MGMT_SAE;
		}
		if (_tmp43_) {
			NMSettingWirelessSecurity* s_wsec = NULL;
			NMSettingWirelessSecurity* _tmp48_;
			NMSettingWirelessSecurity* _tmp49_;
			NMConnection* _tmp50_;
			NMSettingWirelessSecurity* _tmp51_;
			NMSetting* _tmp52_;
			_tmp48_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
			s_wsec = _tmp48_;
			_tmp49_ = s_wsec;
			g_object_set (_tmp49_, "key-mgmt", "sae", NULL);
			_tmp50_ = connection;
			_tmp51_ = s_wsec;
			_tmp52_ = _g_object_ref0 ((NMSetting*) _tmp51_);
			nm_connection_add_setting (_tmp50_, _tmp52_);
			_g_object_unref0 (s_wsec);
		}
		_tmp53_ = (NMSettingWireless*) nm_setting_wireless_new ();
		s_wifi = _tmp53_;
		_tmp54_ = s_wifi;
		_tmp55_ = network_wifi_menu_item_get_ap (row);
		_tmp56_ = _tmp55_;
		_tmp57_ = nm_access_point_get_ssid (_tmp56_);
		g_object_set (_tmp54_, "ssid", _tmp57_, NULL);
		_tmp58_ = connection;
		_tmp59_ = s_wifi;
		_tmp60_ = _g_object_ref0 ((NMSetting*) _tmp59_);
		nm_connection_add_setting (_tmp58_, _tmp60_);
		_tmp62_ = network_wifi_menu_item_get_ap (row);
		_tmp63_ = _tmp62_;
		if ((nm_access_point_get_rsn_flags (_tmp63_) & NM_802_11_AP_SEC_KEY_MGMT_802_1X) == NM_802_11_AP_SEC_KEY_MGMT_802_1X) {
			_tmp61_ = TRUE;
		} else {
			NMAccessPoint* _tmp64_;
			NMAccessPoint* _tmp65_;
			_tmp64_ = network_wifi_menu_item_get_ap (row);
			_tmp65_ = _tmp64_;
			_tmp61_ = (nm_access_point_get_wpa_flags (_tmp65_) & NM_802_11_AP_SEC_KEY_MGMT_802_1X) == NM_802_11_AP_SEC_KEY_MGMT_802_1X;
		}
		if (_tmp61_) {
			NMSettingWirelessSecurity* s_wsec = NULL;
			gchar* _tmp66_;
			NMSettingWirelessSecurity* _tmp67_ = NULL;
			NMConnection* _tmp68_;
			NMSettingWirelessSecurity* _tmp69_;
			NMSetting* _tmp70_;
			NMSetting8021x* s_8021x = NULL;
			NMSetting8021x* _tmp71_;
			NMSetting8021x* _tmp72_;
			NMSetting8021x* _tmp73_;
			NMConnection* _tmp74_;
			NMSetting8021x* _tmp75_;
			NMSetting* _tmp76_;
			_tmp66_ = g_strdup ("wpa-eap");
			_tmp67_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
			g_object_set (_tmp67_, "key-mgmt", _tmp66_, NULL);
			_g_free0 (_tmp66_);
			s_wsec = _tmp67_;
			_tmp68_ = connection;
			_tmp69_ = s_wsec;
			_tmp70_ = _g_object_ref0 ((NMSetting*) _tmp69_);
			nm_connection_add_setting (_tmp68_, _tmp70_);
			_tmp71_ = (NMSetting8021x*) nm_setting_802_1x_new ();
			s_8021x = _tmp71_;
			_tmp72_ = s_8021x;
			nm_setting_802_1x_add_eap_method (_tmp72_, "ttls");
			_tmp73_ = s_8021x;
			g_object_set (_tmp73_, "phase2-auth", "mschapv2", NULL);
			_tmp74_ = connection;
			_tmp75_ = s_8021x;
			_tmp76_ = _g_object_ref0 ((NMSetting*) _tmp75_);
			nm_connection_add_setting (_tmp74_, _tmp76_);
			_g_object_unref0 (s_8021x);
			_g_object_unref0 (s_wsec);
		}
		_tmp77_ = _data10_->client;
		_tmp78_ = connection;
		_tmp79_ = self->wifi_device;
		_tmp80_ = network_wifi_menu_item_get_ap (row);
		_tmp81_ = _tmp80_;
		_tmp82_ = gtk_widget_get_root ((GtkWidget*) self);
		_tmp83_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, gtk_window_get_type (), GtkWindow));
		_tmp84_ = (NMAWifiDialog*) nma_wifi_dialog_new (_tmp77_, _tmp78_, (NMDevice*) _tmp79_, _tmp81_, FALSE);
		gtk_window_set_deletable ((GtkWindow*) _tmp84_, FALSE);
		gtk_window_set_modal ((GtkWindow*) _tmp84_, TRUE);
		gtk_window_set_transient_for ((GtkWindow*) _tmp84_, _tmp83_);
		_g_object_unref0 (_tmp83_);
		g_object_ref_sink (_tmp84_);
		_data11_->wifi_dialog = _tmp84_;
		_tmp85_ = _data11_->wifi_dialog;
		gtk_window_present ((GtkWindow*) _tmp85_);
		_tmp86_ = _data11_->wifi_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp86_, "response", (GCallback) ____lambda23__gtk_dialog_response, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
		_g_object_unref0 (s_wifi);
		_g_object_unref0 (s_con);
		block11_data_unref (_data11_);
		_data11_ = NULL;
	} else {
		gboolean _tmp87_ = FALSE;
		NMAccessPoint* _tmp88_;
		NMAccessPoint* _tmp89_;
		NMClient* _tmp110_;
		NMConnection* _tmp111_;
		NMDeviceWifi* _tmp112_;
		NMAccessPoint* _tmp113_;
		NMAccessPoint* _tmp114_;
		const gchar* _tmp115_;
		_tmp88_ = network_wifi_menu_item_get_ap (row);
		_tmp89_ = _tmp88_;
		if ((nm_access_point_get_rsn_flags (_tmp89_) & NM_802_11_AP_SEC_KEY_MGMT_OWE) == NM_802_11_AP_SEC_KEY_MGMT_OWE) {
			_tmp87_ = TRUE;
		} else {
			NMAccessPoint* _tmp90_;
			NMAccessPoint* _tmp91_;
			_tmp90_ = network_wifi_menu_item_get_ap (row);
			_tmp91_ = _tmp90_;
			_tmp87_ = (nm_access_point_get_wpa_flags (_tmp91_) & NM_802_11_AP_SEC_KEY_MGMT_OWE) == NM_802_11_AP_SEC_KEY_MGMT_OWE;
		}
		if (_tmp87_) {
			NMSettingConnection* s_con = NULL;
			gchar* _tmp92_;
			NMSettingConnection* _tmp93_ = NULL;
			NMConnection* _tmp94_;
			NMSettingConnection* _tmp95_;
			NMSetting* _tmp96_;
			NMSettingWirelessSecurity* s_wsec = NULL;
			gchar* _tmp97_;
			NMSettingWirelessSecurity* _tmp98_ = NULL;
			NMConnection* _tmp99_;
			NMSettingWirelessSecurity* _tmp100_;
			NMSetting* _tmp101_;
			NMSettingWireless* s_wifi = NULL;
			NMAccessPoint* _tmp102_;
			NMAccessPoint* _tmp103_;
			GBytes* _tmp104_;
			GBytes* _tmp105_;
			NMSettingWireless* _tmp106_ = NULL;
			NMConnection* _tmp107_;
			NMSettingWireless* _tmp108_;
			NMSetting* _tmp109_;
			_tmp92_ = nm_utils_uuid_generate ();
			_tmp93_ = (NMSettingConnection*) nm_setting_connection_new ();
			g_object_set (_tmp93_, "uuid", _tmp92_, NULL);
			_g_free0 (_tmp92_);
			s_con = _tmp93_;
			_tmp94_ = connection;
			_tmp95_ = s_con;
			_tmp96_ = _g_object_ref0 ((NMSetting*) _tmp95_);
			nm_connection_add_setting (_tmp94_, _tmp96_);
			_tmp97_ = g_strdup ("owe");
			_tmp98_ = (NMSettingWirelessSecurity*) nm_setting_wireless_security_new ();
			g_object_set (_tmp98_, "key-mgmt", _tmp97_, NULL);
			_g_free0 (_tmp97_);
			s_wsec = _tmp98_;
			_tmp99_ = connection;
			_tmp100_ = s_wsec;
			_tmp101_ = _g_object_ref0 ((NMSetting*) _tmp100_);
			nm_connection_add_setting (_tmp99_, _tmp101_);
			_tmp102_ = network_wifi_menu_item_get_ap (row);
			_tmp103_ = _tmp102_;
			_tmp104_ = nm_access_point_get_ssid (_tmp103_);
			_tmp105_ = _g_bytes_ref0 (_tmp104_);
			_tmp106_ = (NMSettingWireless*) nm_setting_wireless_new ();
			g_object_set (_tmp106_, "ssid", _tmp105_, NULL);
			_g_bytes_unref0 (_tmp105_);
			s_wifi = _tmp106_;
			_tmp107_ = connection;
			_tmp108_ = s_wifi;
			_tmp109_ = _g_object_ref0 ((NMSetting*) _tmp108_);
			nm_connection_add_setting (_tmp107_, _tmp109_);
			_g_object_unref0 (s_wifi);
			_g_object_unref0 (s_wsec);
			_g_object_unref0 (s_con);
		}
		_tmp110_ = _data10_->client;
		_tmp111_ = connection;
		_tmp112_ = self->wifi_device;
		_tmp113_ = network_wifi_menu_item_get_ap (row);
		_tmp114_ = _tmp113_;
		_tmp115_ = nm_object_get_path ((NMObject*) _tmp114_);
		nm_client_add_and_activate_connection_async (_tmp110_, _tmp111_, (NMDevice*) _tmp112_, _tmp115_, NULL, ____lambda25__gasync_ready_callback, block10_data_ref (_data10_));
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda26__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (connection);
	_g_object_unref0 (valid_connection);
	_g_ptr_array_unref0 (ap_connections);
	_g_ptr_array_unref0 (device_connections);
	_g_ptr_array_unref0 (connections);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static NMConnection*
network_wifi_interface_get_valid_connection (NetworkWifiInterface* self,
                                             NMAccessPoint* ap,
                                             GPtrArray* ap_connections)
{
	NMConnection* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ap != NULL, NULL);
	g_return_val_if_fail (ap_connections != NULL, NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				NMConnection* connection = NULL;
				gconstpointer _tmp4_;
				NMConnection* _tmp5_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = vala_g_ptr_array_get_length (ap_connections);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				_tmp4_ = g_ptr_array_index (ap_connections, (guint) i);
				connection = (NMConnection*) _tmp4_;
				_tmp5_ = connection;
				if (nm_access_point_connection_valid (ap, _tmp5_)) {
					NMConnection* _tmp6_;
					NMConnection* _tmp7_;
					_tmp6_ = connection;
					_tmp7_ = _g_object_ref0 (_tmp6_);
					result = _tmp7_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static Block12Data*
block12_data_ref (Block12Data* _data12_)
{
	g_atomic_int_inc (&_data12_->_ref_count_);
	return _data12_;
}

static void
block12_data_unref (void * _userdata_)
{
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data12_->self;
		_g_object_unref0 (_data12_->hidden_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block12Data, _data12_);
	}
}

static void
__lambda29_ (Block12Data* _data12_,
             gint response)
{
	NetworkWifiInterface* self;
	self = _data12_->self;
	if (response == ((gint) GTK_RESPONSE_OK)) {
		network_wifi_interface_connect_to_network (self, _data12_->hidden_dialog, NULL, NULL);
	}
	gtk_window_destroy ((GtkWindow*) _data12_->hidden_dialog);
}

static void
___lambda29__gtk_dialog_response (GtkDialog* _sender,
                                  gint response_id,
                                  gpointer self)
{
	__lambda29_ (self, response_id);
}

static void
network_wifi_interface_connect_to_hidden (NetworkWifiInterface* self)
{
	Block12Data* _data12_;
	NetworkNetworkManager* network_manager = NULL;
	NetworkNetworkManager* _tmp0_;
	NMClient* _tmp1_;
	NMClient* _tmp2_;
	GtkRoot* _tmp3_;
	GtkWindow* _tmp4_;
	NMAWifiDialog* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_data12_ = g_slice_new0 (Block12Data);
	_data12_->_ref_count_ = 1;
	_data12_->self = g_object_ref (self);
	_tmp0_ = network_network_manager_get_default ();
	network_manager = _tmp0_;
	_tmp1_ = network_network_manager_get_client (network_manager);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_get_root ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_window_get_type (), GtkWindow));
	_tmp5_ = (NMAWifiDialog*) nma_wifi_dialog_new_for_other (_tmp2_);
	gtk_window_set_deletable ((GtkWindow*) _tmp5_, FALSE);
	gtk_window_set_modal ((GtkWindow*) _tmp5_, TRUE);
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	_data12_->hidden_dialog = _tmp5_;
	gtk_window_present ((GtkWindow*) _data12_->hidden_dialog);
	g_signal_connect_data ((GtkDialog*) _data12_->hidden_dialog, "response", (GCallback) ___lambda29__gtk_dialog_response, block12_data_ref (_data12_), (GClosureNotify) block12_data_unref, 0);
	block12_data_unref (_data12_);
	_data12_ = NULL;
}

static void
network_wifi_interface_connect_to_network_data_free (gpointer _data)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->wifi_dialog);
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkWifiInterfaceConnectToNetworkData, _data_);
}

static void
network_wifi_interface_connect_to_network (NetworkWifiInterface* self,
                                           NMAWifiDialog* wifi_dialog,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	NetworkWifiInterface* _tmp0_;
	NMAWifiDialog* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (wifi_dialog != NULL);
	_data_ = g_slice_new0 (NetworkWifiInterfaceConnectToNetworkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_wifi_interface_connect_to_network_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (wifi_dialog);
	_g_object_unref0 (_data_->wifi_dialog);
	_data_->wifi_dialog = _tmp1_;
	network_wifi_interface_connect_to_network_co (_data_);
}

static void
network_wifi_interface_connect_to_network_finish (NetworkWifiInterface* self,
                                                  GAsyncResult* _res_)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		NetworkWifiInterface* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->dialog_connection);
		_g_object_unref0 (_data13_->fuzzy);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
__lambda24_ (Block13Data* _data13_,
             NMRemoteConnection* possible)
{
	NetworkWifiInterface* self;
	NMConnection* _tmp0_;
	self = _data13_->self;
	g_return_if_fail (possible != NULL);
	_tmp0_ = _data13_->dialog_connection;
	if (nm_connection_compare (_tmp0_, (NMConnection*) possible, NM_SETTING_COMPARE_FLAG_FUZZY | NM_SETTING_COMPARE_FLAG_IGNORE_ID)) {
		NMConnection* _tmp1_;
		_tmp1_ = _g_object_ref0 ((NMConnection*) possible);
		_g_object_unref0 (_data13_->fuzzy);
		_data13_->fuzzy = _tmp1_;
	}
}

static void
___lambda24__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda24_ (self, (NMRemoteConnection*) data);
}

static void
network_wifi_interface_connect_to_network_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	NetworkWifiInterfaceConnectToNetworkData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	network_wifi_interface_connect_to_network_co (_data_);
}

static gboolean
network_wifi_interface_connect_to_network_co (NetworkWifiInterfaceConnectToNetworkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data13_ = g_slice_new0 (Block13Data);
	_data_->_data13_->_ref_count_ = 1;
	_data_->_data13_->self = g_object_ref (_data_->self);
	_data_->_data13_->_async_data_ = _data_;
	_data_->_data13_->fuzzy = NULL;
	_data_->dialog_ap = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = NULL;
	_data_->_tmp2_ = nma_wifi_dialog_get_connection (_data_->wifi_dialog, &_data_->_tmp0_, &_data_->_tmp1_);
	_g_object_unref0 (_data_->dialog_device);
	_data_->dialog_device = _data_->_tmp0_;
	_g_object_unref0 (_data_->dialog_ap);
	_data_->dialog_ap = _data_->_tmp1_;
	_data_->_data13_->dialog_connection = _data_->_tmp2_;
	_data_->_tmp3_ = network_network_manager_get_default ();
	_data_->network_manager = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->network_manager;
	_data_->_tmp5_ = network_network_manager_get_client (_data_->_tmp4_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_data_->client = _data_->_tmp6_;
	_data_->_tmp7_ = _data_->client;
	_data_->_tmp8_ = nm_client_get_connections (_data_->_tmp7_);
	g_ptr_array_foreach (_data_->_tmp8_, ___lambda24__gfunc, _data_->_data13_);
	_data_->path = NULL;
	_data_->_tmp9_ = _data_->dialog_ap;
	if (_data_->_tmp9_ != NULL) {
		_data_->_tmp10_ = _data_->dialog_ap;
		_data_->_tmp11_ = nm_object_get_path ((NMObject*) _data_->_tmp10_);
		_data_->_tmp12_ = g_strdup (_data_->_tmp11_);
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp12_;
	}
	_data_->_tmp13_ = _data_->_data13_->fuzzy;
	if (_data_->_tmp13_ != NULL) {
		{
			_data_->_tmp14_ = _data_->client;
			_data_->_tmp15_ = _data_->_data13_->fuzzy;
			_data_->_tmp16_ = _data_->self->wifi_device;
			_data_->_tmp17_ = _data_->path;
			_data_->_state_ = 1;
			nm_client_activate_connection_async (_data_->_tmp14_, _data_->_tmp15_, (NMDevice*) _data_->_tmp16_, _data_->_tmp17_, NULL, network_wifi_interface_connect_to_network_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp18_ = nm_client_activate_connection_finish (_data_->_tmp14_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp19_ = _data_->_tmp18_;
			_g_object_unref0 (_data_->_tmp19_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->_error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp20_ = _data_->_error_;
			_data_->_tmp21_ = _data_->_tmp20_->message;
			g_critical ("WifiPage.vala:603: %s", _data_->_tmp21_);
			_g_error_free0 (_data_->_error_);
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->dialog_ap);
			_g_object_unref0 (_data_->dialog_device);
			block13_data_unref (_data_->_data13_);
			_data_->_data13_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	} else {
		_data_->mode = NULL;
		_data_->_tmp22_ = _data_->_data13_->dialog_connection;
		_data_->_tmp23_ = nm_connection_get_setting_wireless (_data_->_tmp22_);
		_data_->setting_wireless = _data_->_tmp23_;
		_data_->_tmp24_ = _data_->setting_wireless;
		if (_data_->_tmp24_ != NULL) {
			_data_->_tmp25_ = _data_->setting_wireless;
			_data_->_tmp26_ = nm_setting_wireless_get_mode (_data_->_tmp25_);
			_data_->_tmp27_ = g_strdup (_data_->_tmp26_);
			_g_free0 (_data_->mode);
			_data_->mode = _data_->_tmp27_;
		}
		_data_->_tmp28_ = _data_->mode;
		if (g_strcmp0 (_data_->_tmp28_, "adhoc") == 0) {
			_data_->_tmp29_ = _data_->_data13_->dialog_connection;
			_data_->_tmp30_ = nm_connection_get_setting_connection (_data_->_tmp29_);
			_data_->_tmp31_ = _g_object_ref0 (_data_->_tmp30_);
			_data_->connection_setting = _data_->_tmp31_;
			_data_->_tmp32_ = _data_->connection_setting;
			if (_data_->_tmp32_ == NULL) {
				_data_->_tmp33_ = (NMSettingConnection*) nm_setting_connection_new ();
				_g_object_unref0 (_data_->connection_setting);
				_data_->connection_setting = _data_->_tmp33_;
			}
			_data_->_tmp34_ = _data_->_data13_->dialog_connection;
			_data_->_tmp35_ = _data_->connection_setting;
			_data_->_tmp36_ = _g_object_ref0 ((NMSetting*) _data_->_tmp35_);
			nm_connection_add_setting (_data_->_tmp34_, _data_->_tmp36_);
			_g_object_unref0 (_data_->connection_setting);
		}
		{
			_data_->_tmp37_ = _data_->client;
			_data_->_tmp38_ = _data_->_data13_->dialog_connection;
			_data_->_tmp39_ = _data_->dialog_device;
			_data_->_tmp40_ = _data_->path;
			_data_->_state_ = 2;
			nm_client_add_and_activate_connection_async (_data_->_tmp37_, _data_->_tmp38_, _data_->_tmp39_, _data_->_tmp40_, NULL, network_wifi_interface_connect_to_network_ready, _data_);
			return FALSE;
			_state_2:
			_data_->_tmp41_ = nm_client_add_and_activate_connection_finish (_data_->_tmp37_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp42_ = _data_->_tmp41_;
			_g_object_unref0 (_data_->_tmp42_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			_data_->_vala1__error_ = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp43_ = _data_->_vala1__error_;
			_data_->_tmp44_ = _data_->_tmp43_->message;
			g_critical ("WifiPage.vala:624: %s", _data_->_tmp44_);
			_g_error_free0 (_data_->_vala1__error_);
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_free0 (_data_->mode);
			_g_free0 (_data_->path);
			_g_object_unref0 (_data_->dialog_ap);
			_g_object_unref0 (_data_->dialog_device);
			block13_data_unref (_data_->_data13_);
			_data_->_data13_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_g_free0 (_data_->mode);
	}
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->dialog_ap);
	_g_object_unref0 (_data_->dialog_device);
	block13_data_unref (_data_->_data13_);
	_data_->_data13_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
network_wifi_interface_cancel_scan (NetworkWifiInterface* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_scan > ((guint) 0)) {
		g_source_remove (self->priv->timeout_scan);
		self->priv->timeout_scan = (guint) 0;
	}
}

static gboolean
___lambda27_ (NetworkWifiInterface* self)
{
	NMDeviceWifi* _tmp0_;
	GtkStack* _tmp1_;
	gboolean result;
	_tmp0_ = self->wifi_device;
	if (network_utils_get_device_is_hotspot (_tmp0_)) {
		result = FALSE;
		return result;
	}
	self->priv->timeout_scan = (guint) 0;
	_tmp1_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp1_, "no-aps");
	result = FALSE;
	return result;
}

static gboolean
____lambda27__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda27_ ((NetworkWifiInterface*) self);
	return result;
}

static void
network_wifi_interface_set_scan_placeholder (NetworkWifiInterface* self)
{
	NMDeviceState _tmp0_;
	NMDeviceState _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = network_widgets_page_get_state ((NetworkWidgetsPage*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NM_DEVICE_STATE_DISCONNECTED) {
		GtkStack* _tmp2_;
		NMDeviceWifi* _tmp3_;
		_tmp2_ = self->priv->placeholder;
		gtk_stack_set_visible_child_name (_tmp2_, "scanning");
		network_wifi_interface_cancel_scan (self);
		_tmp3_ = self->wifi_device;
		nm_device_wifi_request_scan_async (_tmp3_, NULL, NULL, NULL);
		self->priv->timeout_scan = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 5000, ____lambda27__gsource_func, g_object_ref (self), g_object_unref);
	}
}

static gint
network_wifi_interface_sort_func (NetworkWifiInterface* self,
                                  GtkListBoxRow* r1,
                                  GtkListBoxRow* r2)
{
	gboolean _tmp0_ = FALSE;
	NMAccessPoint* _tmp1_;
	NMAccessPoint* _tmp2_;
	guint8 _tmp3_;
	guint8 _tmp4_;
	NMAccessPoint* _tmp5_;
	NMAccessPoint* _tmp6_;
	guint8 _tmp7_;
	guint8 _tmp8_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (r1 != NULL, 0);
	g_return_val_if_fail (r2 != NULL, 0);
	if (r1 == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = r2 == NULL;
	}
	if (_tmp0_) {
		result = 0;
		return result;
	}
	_tmp1_ = network_wifi_menu_item_get_ap (G_TYPE_CHECK_INSTANCE_CAST (r2, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	_tmp2_ = _tmp1_;
	_tmp3_ = nm_access_point_get_strength (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = network_wifi_menu_item_get_ap (G_TYPE_CHECK_INSTANCE_CAST (r1, NETWORK_TYPE_WIFI_MENU_ITEM, NetworkWifiMenuItem));
	_tmp6_ = _tmp5_;
	_tmp7_ = nm_access_point_get_strength (_tmp6_);
	_tmp8_ = _tmp7_;
	result = (gint) (_tmp4_ - _tmp8_);
	return result;
}

static NetworkWifiMenuItem*
network_wifi_interface_get_active_wifi_item (NetworkWifiInterface* self)
{
	NetworkWifiMenuItem* result;
	NetworkWifiMenuItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_active_wifi_item;
	result = _tmp0_;
	return result;
}

static void
network_wifi_interface_set_active_wifi_item (NetworkWifiInterface* self,
                                             NetworkWifiMenuItem* value)
{
	NetworkWifiMenuItem* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_active_wifi_item);
	self->priv->_active_wifi_item = _tmp0_;
}

static gint
_network_wifi_interface_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                          GtkListBoxRow* row2,
                                                          gpointer self)
{
	gint result;
	result = network_wifi_interface_sort_func ((NetworkWifiInterface*) self, row1, row2);
	return result;
}

static void
_network_widgets_page_edit_connections_gtk_button_clicked (GtkButton* _sender,
                                                           gpointer self)
{
	network_widgets_page_edit_connections ((NetworkWidgetsPage*) self);
}

static void
_network_wifi_interface_connect_to_hidden_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self)
{
	network_wifi_interface_connect_to_hidden ((NetworkWifiInterface*) self);
}

static void
_network_widgets_page_update_rf_kill_manager_device_added (RFKillManager* _sender,
                                                           RFKillDevice* device,
                                                           gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_page_update_rf_kill_manager_device_changed (RFKillManager* _sender,
                                                             RFKillDevice* device,
                                                             gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_page_update_rf_kill_manager_device_deleted (RFKillManager* _sender,
                                                             RFKillDevice* device,
                                                             gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_widgets_page_update_g_object_notify (GObject* _sender,
                                              GParamSpec* pspec,
                                              gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added (NMDeviceWifi* _sender,
                                                                                 GObject* ap,
                                                                                 gpointer self)
{
	network_wifi_interface_access_point_added_cb ((NetworkWifiInterface*) self, ap);
}

static void
_network_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed (NMDeviceWifi* _sender,
                                                                                     GObject* ap,
                                                                                     gpointer self)
{
	network_wifi_interface_access_point_removed_cb ((NetworkWifiInterface*) self, ap);
}

static void
_network_widgets_page_update_nm_device_state_changed (NMDevice* _sender,
                                                      guint new_state,
                                                      guint old_state,
                                                      guint reason,
                                                      gpointer self)
{
	network_widgets_page_update ((NetworkWidgetsPage*) self);
}

static void
_network_wifi_interface_access_point_added_cb_gfunc (gconstpointer data,
                                                     gpointer self)
{
	network_wifi_interface_access_point_added_cb ((NetworkWifiInterface*) self, (GObject*) data);
}

static GObject *
network_wifi_interface_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	NetworkWifiInterface * self;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkStack* _tmp2_ = NULL;
	GtkListBox* _tmp3_ = NULL;
	GtkListBox* _tmp4_;
	GtkListBox* _tmp5_;
	GtkStack* _tmp6_;
	GtkListBox* _tmp7_;
	GranitePlaceholder* hotspot_mode_alert = NULL;
	gchar* _tmp8_;
	GranitePlaceholder* _tmp9_ = NULL;
	GtkListBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkScrolledWindow* _tmp12_ = NULL;
	GtkStack* _tmp13_;
	GtkStack* _tmp14_;
	GranitePlaceholder* _tmp15_;
	GtkStack* _tmp16_;
	GtkScrolledWindow* _tmp17_;
	GtkStack* _tmp18_;
	GtkScrolledWindow* _tmp19_;
	GtkFrame* main_frame = NULL;
	GtkStack* _tmp20_;
	GtkWidget* _tmp21_;
	GtkFrame* _tmp22_ = NULL;
	GtkFrame* _tmp23_;
	GtkFrame* _tmp24_ = NULL;
	GtkFrame* _tmp25_;
	GtkWidget* _tmp26_;
	GtkRevealer* _tmp27_ = NULL;
	GtkButton* settings_button = NULL;
	GtkButton* _tmp28_;
	GtkButton* _tmp29_;
	GtkButton* _tmp30_;
	GtkButton* _tmp31_;
	NMDevice* _tmp32_;
	NMDevice* _tmp33_;
	NMDeviceWifi* _tmp34_;
	GranitePlaceholder* no_aps_alert = NULL;
	gchar* _tmp35_;
	GranitePlaceholder* _tmp36_ = NULL;
	GranitePlaceholder* wireless_off_alert = NULL;
	gchar* _tmp37_;
	GranitePlaceholder* _tmp38_ = NULL;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp39_ = NULL;
	GtkSpinner* _tmp40_;
	GtkLabel* scanning = NULL;
	GtkLabel* _tmp41_ = NULL;
	GtkLabel* _tmp42_;
	GtkBox* scanning_box = NULL;
	GtkBox* _tmp43_ = NULL;
	GtkBox* _tmp44_;
	GtkLabel* _tmp45_;
	GtkBox* _tmp46_;
	GtkSpinner* _tmp47_;
	GtkStack* _tmp48_;
	GranitePlaceholder* _tmp49_;
	GtkStack* _tmp50_;
	GranitePlaceholder* _tmp51_;
	GtkStack* _tmp52_;
	GtkBox* _tmp53_;
	GtkStack* _tmp54_;
	RFKillManager* _tmp55_;
	RFKillManager* _tmp56_;
	RFKillManager* _tmp57_;
	RFKillManager* _tmp58_;
	RFKillManager* _tmp59_;
	NMDeviceWifi* _tmp60_;
	NMDeviceWifi* _tmp61_;
	NMDeviceWifi* _tmp62_;
	NMDeviceWifi* _tmp63_;
	GPtrArray* aps = NULL;
	NMDeviceWifi* _tmp64_;
	GPtrArray* _tmp65_;
	GPtrArray* _tmp66_;
	gboolean _tmp67_ = FALSE;
	GPtrArray* _tmp68_;
	GtkBox* content_box = NULL;
	GtkBox* _tmp73_;
	GtkBox* _tmp74_;
	GtkRevealer* _tmp75_;
	GtkBox* _tmp76_;
	GtkFrame* _tmp77_;
	GtkBox* _tmp78_;
	parent_class = G_OBJECT_CLASS (network_wifi_interface_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("network-wireless");
	_tmp1_ = _tmp0_;
	switchboard_settings_page_set_icon ((SwitchboardSettingsPage*) self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkStack*) gtk_stack_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->placeholder);
	self->priv->placeholder = _tmp2_;
	_tmp3_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_activate_on_single_click (_tmp3_, FALSE);
	gtk_list_box_set_selection_mode (_tmp3_, GTK_SELECTION_SINGLE);
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, TRUE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->wifi_list);
	self->priv->wifi_list = _tmp3_;
	_tmp4_ = self->priv->wifi_list;
	gtk_list_box_set_sort_func (_tmp4_, _network_wifi_interface_sort_func_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp5_ = self->priv->wifi_list;
	_tmp6_ = self->priv->placeholder;
	gtk_list_box_set_placeholder (_tmp5_, (GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->wifi_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp7_, GRANITE_STYLE_CLASS_RICH_LIST);
	_tmp8_ = g_strdup (_ ("Turn off the Hotspot Mode to connect to other Access Points."));
	_tmp9_ = granite_placeholder_new (_ ("This device is in Hotspot Mode"));
	granite_placeholder_set_description (_tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	hotspot_mode_alert = _tmp9_;
	_tmp10_ = self->priv->wifi_list;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp12_, _tmp11_);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->scrolled);
	self->scrolled = _tmp12_;
	_tmp13_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->list_stack);
	self->list_stack = _tmp13_;
	_tmp14_ = self->list_stack;
	_tmp15_ = hotspot_mode_alert;
	gtk_stack_add_child (_tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->list_stack;
	_tmp17_ = self->scrolled;
	gtk_stack_add_child (_tmp16_, (GtkWidget*) _tmp17_);
	_tmp18_ = self->list_stack;
	_tmp19_ = self->scrolled;
	gtk_stack_set_visible_child (_tmp18_, (GtkWidget*) _tmp19_);
	_tmp20_ = self->list_stack;
	_tmp21_ = _g_object_ref0 ((GtkWidget*) _tmp20_);
	_tmp22_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_frame_set_child (_tmp22_, _tmp21_);
	_g_object_unref0 (_tmp21_);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp22_, TRUE);
	g_object_ref_sink (_tmp22_);
	main_frame = _tmp22_;
	_tmp23_ = main_frame;
	gtk_widget_add_css_class ((GtkWidget*) _tmp23_, GRANITE_STYLE_CLASS_VIEW);
	_tmp24_ = (GtkFrame*) gtk_frame_new (NULL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp24_, 12);
	g_object_ref_sink (_tmp24_);
	_g_object_unref0 (self->connected_frame);
	self->connected_frame = _tmp24_;
	_tmp25_ = self->connected_frame;
	_tmp26_ = _g_object_ref0 ((GtkWidget*) _tmp25_);
	_tmp27_ = (GtkRevealer*) gtk_revealer_new ();
	gtk_revealer_set_child (_tmp27_, _tmp26_);
	_g_object_unref0 (_tmp26_);
	gtk_revealer_set_transition_type (_tmp27_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_DOWN);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->top_revealer);
	self->top_revealer = _tmp27_;
	_tmp28_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Edit Connections…"));
	settings_button = _tmp28_;
	_tmp29_ = settings_button;
	g_signal_connect_object (_tmp29_, "clicked", (GCallback) _network_widgets_page_edit_connections_gtk_button_clicked, (NetworkWidgetsPage*) self, 0);
	_tmp30_ = switchboard_settings_page_add_button ((SwitchboardSettingsPage*) self, _ ("Connect to Hidden Network…"));
	_g_object_unref0 (self->hidden_btn);
	self->hidden_btn = _tmp30_;
	_tmp31_ = self->hidden_btn;
	g_signal_connect_object (_tmp31_, "clicked", (GCallback) _network_wifi_interface_connect_to_hidden_gtk_button_clicked, self, 0);
	_tmp32_ = network_widgets_page_get_device ((NetworkWidgetsPage*) self);
	_tmp33_ = _tmp32_;
	_tmp34_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, nm_device_wifi_get_type (), NMDeviceWifi));
	_g_object_unref0 (self->wifi_device);
	self->wifi_device = _tmp34_;
	network_wifi_interface_set_active_wifi_item (self, NULL);
	_tmp35_ = g_strdup (_ ("There are no wireless access points within range."));
	_tmp36_ = granite_placeholder_new (_ ("No Access Points Available"));
	granite_placeholder_set_description (_tmp36_, _tmp35_);
	_g_free0 (_tmp35_);
	g_object_ref_sink (_tmp36_);
	no_aps_alert = _tmp36_;
	_tmp37_ = g_strdup (_ ("Enable wireless to discover nearby wireless access points."));
	_tmp38_ = granite_placeholder_new (_ ("Wireless Is Disabled"));
	granite_placeholder_set_description (_tmp38_, _tmp37_);
	_g_free0 (_tmp37_);
	g_object_ref_sink (_tmp38_);
	wireless_off_alert = _tmp38_;
	_tmp39_ = (GtkSpinner*) gtk_spinner_new ();
	gtk_widget_set_visible ((GtkWidget*) _tmp39_, TRUE);
	gtk_widget_set_halign ((GtkWidget*) _tmp39_, GTK_ALIGN_CENTER);
	gtk_widget_set_valign ((GtkWidget*) _tmp39_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp39_);
	spinner = _tmp39_;
	_tmp40_ = spinner;
	gtk_spinner_start (_tmp40_);
	_tmp41_ = (GtkLabel*) gtk_label_new (_ ("Scanning for Access Points…"));
	gtk_widget_set_visible ((GtkWidget*) _tmp41_, TRUE);
	gtk_label_set_wrap (_tmp41_, TRUE);
	gtk_label_set_wrap_mode (_tmp41_, PANGO_WRAP_WORD_CHAR);
	gtk_label_set_max_width_chars (_tmp41_, 30);
	gtk_label_set_justify (_tmp41_, GTK_JUSTIFY_CENTER);
	g_object_ref_sink (_tmp41_);
	scanning = _tmp41_;
	_tmp42_ = scanning;
	gtk_widget_add_css_class ((GtkWidget*) _tmp42_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp43_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	gtk_widget_set_visible ((GtkWidget*) _tmp43_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp43_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp43_);
	scanning_box = _tmp43_;
	_tmp44_ = scanning_box;
	_tmp45_ = scanning;
	gtk_box_append (_tmp44_, (GtkWidget*) _tmp45_);
	_tmp46_ = scanning_box;
	_tmp47_ = spinner;
	gtk_box_append (_tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = self->priv->placeholder;
	_tmp49_ = no_aps_alert;
	gtk_stack_add_named (_tmp48_, (GtkWidget*) _tmp49_, "no-aps");
	_tmp50_ = self->priv->placeholder;
	_tmp51_ = wireless_off_alert;
	gtk_stack_add_named (_tmp50_, (GtkWidget*) _tmp51_, "wireless-off");
	_tmp52_ = self->priv->placeholder;
	_tmp53_ = scanning_box;
	gtk_stack_add_named (_tmp52_, (GtkWidget*) _tmp53_, "scanning");
	_tmp54_ = self->priv->placeholder;
	gtk_stack_set_visible_child_name (_tmp54_, "no-aps");
	_tmp55_ = rf_kill_manager_new ();
	_g_object_unref0 (self->priv->rfkill);
	self->priv->rfkill = _tmp55_;
	_tmp56_ = self->priv->rfkill;
	rf_kill_manager_open (_tmp56_);
	_tmp57_ = self->priv->rfkill;
	g_signal_connect_object (_tmp57_, "device-added", (GCallback) _network_widgets_page_update_rf_kill_manager_device_added, (NetworkWidgetsPage*) self, 0);
	_tmp58_ = self->priv->rfkill;
	g_signal_connect_object (_tmp58_, "device-changed", (GCallback) _network_widgets_page_update_rf_kill_manager_device_changed, (NetworkWidgetsPage*) self, 0);
	_tmp59_ = self->priv->rfkill;
	g_signal_connect_object (_tmp59_, "device-deleted", (GCallback) _network_widgets_page_update_rf_kill_manager_device_deleted, (NetworkWidgetsPage*) self, 0);
	_tmp60_ = self->wifi_device;
	g_signal_connect_object ((GObject*) _tmp60_, "notify::active-access-point", (GCallback) _network_widgets_page_update_g_object_notify, (NetworkWidgetsPage*) self, 0);
	_tmp61_ = self->wifi_device;
	g_signal_connect_object (_tmp61_, "access-point-added", (GCallback) _network_wifi_interface_access_point_added_cb_nm_device_wifi_access_point_added, self, 0);
	_tmp62_ = self->wifi_device;
	g_signal_connect_object (_tmp62_, "access-point-removed", (GCallback) _network_wifi_interface_access_point_removed_cb_nm_device_wifi_access_point_removed, self, 0);
	_tmp63_ = self->wifi_device;
	g_signal_connect_object ((NMDevice*) _tmp63_, "state-changed", (GCallback) _network_widgets_page_update_nm_device_state_changed, (NetworkWidgetsPage*) self, 0);
	_tmp64_ = self->wifi_device;
	_tmp65_ = nm_device_wifi_get_access_points (_tmp64_);
	_tmp66_ = _g_ptr_array_ref0 (_tmp65_);
	aps = _tmp66_;
	_tmp68_ = aps;
	if (_tmp68_ != NULL) {
		GPtrArray* _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
		_tmp69_ = aps;
		_tmp70_ = vala_g_ptr_array_get_length (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp67_ = _tmp71_ > 0;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		GPtrArray* _tmp72_;
		_tmp72_ = aps;
		g_ptr_array_foreach (_tmp72_, _network_wifi_interface_access_point_added_cb_gfunc, self);
	}
	_tmp73_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp73_);
	content_box = _tmp73_;
	_tmp74_ = content_box;
	_tmp75_ = self->top_revealer;
	gtk_box_append (_tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = content_box;
	_tmp77_ = main_frame;
	gtk_box_append (_tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = content_box;
	switchboard_settings_page_set_child ((SwitchboardSettingsPage*) self, (GtkWidget*) _tmp78_);
	network_widgets_page_update ((NetworkWidgetsPage*) self);
	_g_object_unref0 (content_box);
	_g_ptr_array_unref0 (aps);
	_g_object_unref0 (scanning_box);
	_g_object_unref0 (scanning);
	_g_object_unref0 (spinner);
	_g_object_unref0 (wireless_off_alert);
	_g_object_unref0 (no_aps_alert);
	_g_object_unref0 (settings_button);
	_g_object_unref0 (main_frame);
	_g_object_unref0 (hotspot_mode_alert);
	return obj;
}

static void
network_wifi_interface_class_init (NetworkWifiInterfaceClass * klass,
                                   gpointer klass_data)
{
	network_wifi_interface_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkWifiInterface_private_offset);
	((NetworkWidgetsPageClass *) klass)->update_name = (void (*) (NetworkWidgetsPage*, gint)) network_wifi_interface_real_update_name;
	((NetworkWidgetsPageClass *) klass)->update = (void (*) (NetworkWidgetsPage*)) network_wifi_interface_real_update;
	((NetworkWidgetsPageClass *) klass)->update_status = (void (*) (NetworkWidgetsPage*)) network_wifi_interface_real_update_status;
	((NetworkWidgetsPageClass *) klass)->update_switch = (void (*) (NetworkWidgetsPage*)) network_wifi_interface_real_update_switch;
	((NetworkWidgetsPageClass *) klass)->control_switch_activated = (void (*) (NetworkWidgetsPage*)) network_wifi_interface_real_control_switch_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_network_wifi_interface_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_network_wifi_interface_set_property;
	G_OBJECT_CLASS (klass)->constructor = network_wifi_interface_constructor;
	G_OBJECT_CLASS (klass)->finalize = network_wifi_interface_finalize;
}

static void
network_wifi_interface_instance_init (NetworkWifiInterface * self,
                                      gpointer klass)
{
	self->priv = network_wifi_interface_get_instance_private (self);
	self->priv->timeout_scan = (guint) 0;
}

static void
network_wifi_interface_finalize (GObject * obj)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	_g_object_unref0 (self->priv->rfkill);
	_g_object_unref0 (self->wifi_device);
	_g_object_unref0 (self->priv->active_ap);
	_g_object_unref0 (self->priv->wifi_list);
	_g_object_unref0 (self->priv->_active_wifi_item);
	_g_object_unref0 (self->priv->placeholder);
	_g_object_unref0 (self->connected_frame);
	_g_object_unref0 (self->list_stack);
	_g_object_unref0 (self->scrolled);
	_g_object_unref0 (self->hotspot_mode_alert);
	_g_object_unref0 (self->top_revealer);
	_g_object_unref0 (self->hidden_btn);
	G_OBJECT_CLASS (network_wifi_interface_parent_class)->finalize (obj);
}

static GType
network_wifi_interface_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkWifiInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_wifi_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkWifiInterface), 0, (GInstanceInitFunc) network_wifi_interface_instance_init, NULL };
	GType network_wifi_interface_type_id;
	network_wifi_interface_type_id = g_type_register_static (NETWORK_WIDGETS_TYPE_PAGE, "NetworkWifiInterface", &g_define_type_info, 0);
	NetworkWifiInterface_private_offset = g_type_add_instance_private (network_wifi_interface_type_id, sizeof (NetworkWifiInterfacePrivate));
	return network_wifi_interface_type_id;
}

GType
network_wifi_interface_get_type (void)
{
	static volatile gsize network_wifi_interface_type_id__once = 0;
	if (g_once_init_enter (&network_wifi_interface_type_id__once)) {
		GType network_wifi_interface_type_id;
		network_wifi_interface_type_id = network_wifi_interface_get_type_once ();
		g_once_init_leave (&network_wifi_interface_type_id__once, network_wifi_interface_type_id);
	}
	return network_wifi_interface_type_id__once;
}

static void
_vala_network_wifi_interface_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_network_wifi_interface_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	NetworkWifiInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETWORK_TYPE_WIFI_INTERFACE, NetworkWifiInterface);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

