/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
 * Copyright (c) 2011-2018 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "mouse-touchpad.h"
#include <gtk/gtk.h>
#include <glib.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	MOUSE_TOUCHPAD_PLUG_0_PROPERTY,
	MOUSE_TOUCHPAD_PLUG_NUM_PROPERTIES
};
static GParamSpec* mouse_touchpad_plug_properties[MOUSE_TOUCHPAD_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _MouseTouchpadPlugSearchData MouseTouchpadPlugSearchData;

struct _MouseTouchpadPlugPrivate {
	GtkStack* stack;
	GtkPaned* hpaned;
	MouseTouchpadClickingView* clicking_view;
	MouseTouchpadMouseView* mouse_view;
	MouseTouchpadPointingView* pointing_view;
	MouseTouchpadTouchpadView* touchpad_view;
	MouseTouchpadGesturesView* gestures_view;
	gboolean show_gestures_view;
};

struct _MouseTouchpadPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	MouseTouchpadPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	GeeTreeMap* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeTreeMap* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GeeTreeMap* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GeeTreeMap* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	GeeTreeMap* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	GeeTreeMap* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	GeeTreeMap* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GeeTreeMap* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	GeeTreeMap* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GeeTreeMap* _tmp48_;
	const gchar* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GeeTreeMap* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GeeTreeMap* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GeeTreeMap* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GeeTreeMap* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GeeTreeMap* _tmp73_;
	const gchar* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	GeeTreeMap* _tmp78_;
	const gchar* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	gchar* _tmp82_;
	GeeTreeMap* _tmp83_;
	const gchar* _tmp84_;
	const gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	GeeTreeMap* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* _tmp91_;
	gchar* _tmp92_;
	GeeTreeMap* _tmp93_;
	const gchar* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	gchar* _tmp97_;
	GeeTreeMap* _tmp98_;
	const gchar* _tmp99_;
	const gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	GeeTreeMap* _tmp103_;
	const gchar* _tmp104_;
	const gchar* _tmp105_;
	gchar* _tmp106_;
	gchar* _tmp107_;
	GeeTreeMap* _tmp108_;
	const gchar* _tmp109_;
	const gchar* _tmp110_;
	gchar* _tmp111_;
	gchar* _tmp112_;
	GeeTreeMap* _tmp113_;
	const gchar* _tmp114_;
	const gchar* _tmp115_;
	gchar* _tmp116_;
	gchar* _tmp117_;
	GeeTreeMap* _tmp118_;
	const gchar* _tmp119_;
	const gchar* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	GeeTreeMap* _tmp123_;
	const gchar* _tmp124_;
	const gchar* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	GeeTreeMap* _tmp128_;
	const gchar* _tmp129_;
	const gchar* _tmp130_;
	gchar* _tmp131_;
	gchar* _tmp132_;
	GeeTreeMap* _tmp133_;
	const gchar* _tmp134_;
	const gchar* _tmp135_;
	gchar* _tmp136_;
	gchar* _tmp137_;
};

static gint MouseTouchpadPlug_private_offset;
static gpointer mouse_touchpad_plug_parent_class = NULL;

static GtkWidget* mouse_touchpad_plug_real_get_widget (SwitchboardPlug* base);
static void mouse_touchpad_plug_real_shown (SwitchboardPlug* base);
static void mouse_touchpad_plug_real_hidden (SwitchboardPlug* base);
static void mouse_touchpad_plug_real_search_callback (SwitchboardPlug* base,
                                               const gchar* location);
static void mouse_touchpad_plug_real_search_data_free (gpointer _data);
static void mouse_touchpad_plug_real_search (SwitchboardPlug* base,
                                      const gchar* search,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static gboolean mouse_touchpad_plug_real_search_co (MouseTouchpadPlugSearchData* _data_);
static GObject * mouse_touchpad_plug_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void mouse_touchpad_plug_finalize (GObject * obj);
static GType mouse_touchpad_plug_get_type_once (void);

static inline gpointer
mouse_touchpad_plug_get_instance_private (MouseTouchpadPlug* self)
{
	return G_STRUCT_MEMBER_P (self, MouseTouchpadPlug_private_offset);
}

MouseTouchpadPlug*
mouse_touchpad_plug_construct (GType object_type)
{
	MouseTouchpadPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointer/clicking", "clicking");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointer/mouse", "mouse");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointer/pointing", "pointing");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointer/touch", "touchpad");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointer/gestures", "gestures");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/pointer", "clicking");
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/mouse", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "input/touch", "touchpad");
	self = (MouseTouchpadPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_HARDWARE, "code-name", "io.elementary.settings.mouse-touchpad", "display-name", _ ("Mouse & Touchpad"), "description", _ ("Configure mouse and touchpad"), "icon", "preferences-desktop-peripherals", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

MouseTouchpadPlug*
mouse_touchpad_plug_new (void)
{
	return mouse_touchpad_plug_construct (MOUSE_TOUCHPAD_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
mouse_touchpad_plug_real_get_widget (SwitchboardPlug* base)
{
	MouseTouchpadPlug * self;
	GtkPaned* _tmp0_;
	GtkPaned* _tmp34_;
	GtkWidget* _tmp35_;
	GtkWidget* result;
	self = (MouseTouchpadPlug*) base;
	_tmp0_ = self->priv->hpaned;
	if (_tmp0_ == NULL) {
		GdkDisplay* _tmp1_;
		GtkIconTheme* _tmp2_;
		MouseTouchpadClickingView* _tmp3_;
		MouseTouchpadMouseView* _tmp4_;
		MouseTouchpadPointingView* _tmp5_;
		MouseTouchpadTouchpadView* _tmp6_;
		GtkStack* _tmp7_;
		GtkStack* _tmp8_;
		MouseTouchpadClickingView* _tmp9_;
		GtkStack* _tmp10_;
		MouseTouchpadPointingView* _tmp11_;
		GtkStack* _tmp15_;
		MouseTouchpadMouseView* _tmp16_;
		GtkStack* _tmp17_;
		MouseTouchpadTouchpadView* _tmp18_;
		SwitchboardSettingsSidebar* switcher = NULL;
		GtkStack* _tmp19_;
		SwitchboardSettingsSidebar* _tmp20_ = NULL;
		SwitchboardSettingsSidebar* _tmp21_;
		GtkWidget* _tmp22_;
		GtkStack* _tmp23_;
		GtkWidget* _tmp24_;
		GtkPaned* _tmp25_ = NULL;
		GSettingsSchema* sss = NULL;
		GSettingsSchemaSource* _tmp26_;
		GSettingsSchema* _tmp27_;
		gboolean _tmp28_ = FALSE;
		GSettingsSchema* _tmp29_;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gtk_icon_theme_get_for_display (_tmp1_);
		gtk_icon_theme_add_resource_path (_tmp2_, "/io/elementary/settings/mouse-touchpad");
		_tmp3_ = mouse_touchpad_clicking_view_new ();
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->clicking_view);
		self->priv->clicking_view = _tmp3_;
		_tmp4_ = mouse_touchpad_mouse_view_new ();
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->mouse_view);
		self->priv->mouse_view = _tmp4_;
		_tmp5_ = mouse_touchpad_pointing_view_new ();
		g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->pointing_view);
		self->priv->pointing_view = _tmp5_;
		_tmp6_ = mouse_touchpad_touchpad_view_new ();
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (self->priv->touchpad_view);
		self->priv->touchpad_view = _tmp6_;
		_tmp7_ = (GtkStack*) gtk_stack_new ();
		g_object_ref_sink (_tmp7_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp7_;
		_tmp8_ = self->priv->stack;
		_tmp9_ = self->priv->clicking_view;
		gtk_stack_add_named (_tmp8_, (GtkWidget*) _tmp9_, "clicking");
		_tmp10_ = self->priv->stack;
		_tmp11_ = self->priv->pointing_view;
		gtk_stack_add_named (_tmp10_, (GtkWidget*) _tmp11_, "pointing");
		if (self->priv->show_gestures_view) {
			MouseTouchpadGesturesView* _tmp12_;
			GtkStack* _tmp13_;
			MouseTouchpadGesturesView* _tmp14_;
			_tmp12_ = mouse_touchpad_gestures_view_new ();
			g_object_ref_sink (_tmp12_);
			_g_object_unref0 (self->priv->gestures_view);
			self->priv->gestures_view = _tmp12_;
			_tmp13_ = self->priv->stack;
			_tmp14_ = self->priv->gestures_view;
			gtk_stack_add_named (_tmp13_, (GtkWidget*) _tmp14_, "gestures");
		}
		_tmp15_ = self->priv->stack;
		_tmp16_ = self->priv->mouse_view;
		gtk_stack_add_named (_tmp15_, (GtkWidget*) _tmp16_, "mouse");
		_tmp17_ = self->priv->stack;
		_tmp18_ = self->priv->touchpad_view;
		gtk_stack_add_named (_tmp17_, (GtkWidget*) _tmp18_, "touchpad");
		_tmp19_ = self->priv->stack;
		_tmp20_ = switchboard_settings_sidebar_new (_tmp19_);
		switchboard_settings_sidebar_set_show_title_buttons (_tmp20_, TRUE);
		g_object_ref_sink (_tmp20_);
		switcher = _tmp20_;
		_tmp21_ = switcher;
		_tmp22_ = _g_object_ref0 ((GtkWidget*) _tmp21_);
		_tmp23_ = self->priv->stack;
		_tmp24_ = _g_object_ref0 ((GtkWidget*) _tmp23_);
		_tmp25_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
		gtk_paned_set_start_child (_tmp25_, _tmp22_);
		_g_object_unref0 (_tmp22_);
		gtk_paned_set_resize_start_child (_tmp25_, FALSE);
		gtk_paned_set_shrink_start_child (_tmp25_, FALSE);
		gtk_paned_set_end_child (_tmp25_, _tmp24_);
		_g_object_unref0 (_tmp24_);
		gtk_paned_set_shrink_end_child (_tmp25_, FALSE);
		g_object_ref_sink (_tmp25_);
		_g_object_unref0 (self->priv->hpaned);
		self->priv->hpaned = _tmp25_;
		_tmp26_ = g_settings_schema_source_get_default ();
		_tmp27_ = g_settings_schema_source_lookup (_tmp26_, "io.elementary.settings", TRUE);
		sss = _tmp27_;
		_tmp29_ = sss;
		if (_tmp29_ != NULL) {
			GSettingsSchema* _tmp30_;
			_tmp30_ = sss;
			_tmp28_ = g_settings_schema_has_key (_tmp30_, "sidebar-position");
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			GSettings* settings = NULL;
			GSettings* _tmp31_;
			GSettings* _tmp32_;
			GtkPaned* _tmp33_;
			_tmp31_ = g_settings_new ("io.elementary.settings");
			settings = _tmp31_;
			_tmp32_ = settings;
			_tmp33_ = self->priv->hpaned;
			g_settings_bind (_tmp32_, "sidebar-position", (GObject*) _tmp33_, "position", G_SETTINGS_BIND_DEFAULT);
			_g_object_unref0 (settings);
		}
		_g_settings_schema_unref0 (sss);
		_g_object_unref0 (switcher);
	}
	_tmp34_ = self->priv->hpaned;
	_tmp35_ = _g_object_ref0 ((GtkWidget*) _tmp34_);
	result = _tmp35_;
	return result;
}

static void
mouse_touchpad_plug_real_shown (SwitchboardPlug* base)
{
	MouseTouchpadPlug * self;
	self = (MouseTouchpadPlug*) base;
}

static void
mouse_touchpad_plug_real_hidden (SwitchboardPlug* base)
{
	MouseTouchpadPlug * self;
	self = (MouseTouchpadPlug*) base;
}

static void
mouse_touchpad_plug_real_search_callback (SwitchboardPlug* base,
                                          const gchar* location)
{
	MouseTouchpadPlug * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	self = (MouseTouchpadPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("mouse")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp3_;
				_tmp3_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp3_, "mouse");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("pointing")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp4_;
				_tmp4_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp4_, "pointing");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("touchpad")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp5_;
				_tmp5_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp5_, "touchpad");
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("gestures")))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp6_;
				_tmp6_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp6_, "gestures");
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkStack* _tmp7_;
				_tmp7_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp7_, "clicking");
				break;
			}
		}
	}
}

static void
mouse_touchpad_plug_real_search_data_free (gpointer _data)
{
	MouseTouchpadPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (MouseTouchpadPlugSearchData, _data_);
}

static void
mouse_touchpad_plug_real_search (SwitchboardPlug* base,
                                 const gchar* search,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	MouseTouchpadPlug * self;
	MouseTouchpadPlugSearchData* _data_;
	MouseTouchpadPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (MouseTouchpadPlug*) base;
	_data_ = g_slice_new0 (MouseTouchpadPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, mouse_touchpad_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	mouse_touchpad_plug_real_search_co (_data_);
}

static GeeTreeMap*
mouse_touchpad_plug_search_finish (SwitchboardPlug* base,
                                   GAsyncResult* _res_)
{
	GeeTreeMap* result;
	MouseTouchpadPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
mouse_touchpad_plug_real_search_co (MouseTouchpadPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->search_results;
	_data_->_tmp4_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = g_strdup_printf ("%s → %s", _data_->_tmp5_, _ ("Clicking"));
	_data_->_tmp7_ = _data_->_tmp6_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp3_, _data_->_tmp7_, "clicking");
	_g_free0 (_data_->_tmp7_);
	_data_->_tmp8_ = _data_->search_results;
	_data_->_tmp9_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = g_strdup_printf ("%s → %s", _data_->_tmp10_, _ ("Double-click Speed"));
	_data_->_tmp12_ = _data_->_tmp11_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp8_, _data_->_tmp12_, "clicking");
	_g_free0 (_data_->_tmp12_);
	_data_->_tmp13_ = _data_->search_results;
	_data_->_tmp14_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = g_strdup_printf ("%s → %s", _data_->_tmp15_, _ ("Dwell Click"));
	_data_->_tmp17_ = _data_->_tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp13_, _data_->_tmp17_, "clicking");
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp18_ = _data_->search_results;
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s", _data_->_tmp20_, _ ("Primary Button"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp18_, _data_->_tmp22_, "clicking");
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = _data_->search_results;
	_data_->_tmp24_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp25_ = _data_->_tmp24_;
	_data_->_tmp26_ = g_strdup_printf ("%s → %s", _data_->_tmp25_, _ ("Long-press Secondary Click"));
	_data_->_tmp27_ = _data_->_tmp26_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp23_, _data_->_tmp27_, "clicking");
	_g_free0 (_data_->_tmp27_);
	_data_->_tmp28_ = _data_->search_results;
	_data_->_tmp29_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp30_ = _data_->_tmp29_;
	_data_->_tmp31_ = g_strdup_printf ("%s → %s", _data_->_tmp30_, _ ("Middle Click Paste"));
	_data_->_tmp32_ = _data_->_tmp31_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp28_, _data_->_tmp32_, "clicking");
	_g_free0 (_data_->_tmp32_);
	_data_->_tmp33_ = _data_->search_results;
	_data_->_tmp34_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp35_ = _data_->_tmp34_;
	_data_->_tmp36_ = g_strdup_printf ("%s → %s", _data_->_tmp35_, _ ("Mouse"));
	_data_->_tmp37_ = _data_->_tmp36_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp33_, _data_->_tmp37_, "mouse");
	_g_free0 (_data_->_tmp37_);
	_data_->_tmp38_ = _data_->search_results;
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp40_, _ ("Mouse"), _ ("Pointer Speed"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp38_, _data_->_tmp42_, "mouse");
	_g_free0 (_data_->_tmp42_);
	_data_->_tmp43_ = _data_->search_results;
	_data_->_tmp44_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp45_ = _data_->_tmp44_;
	_data_->_tmp46_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp45_, _ ("Mouse"), _ ("Pointer Acceleration"));
	_data_->_tmp47_ = _data_->_tmp46_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp43_, _data_->_tmp47_, "mouse");
	_g_free0 (_data_->_tmp47_);
	_data_->_tmp48_ = _data_->search_results;
	_data_->_tmp49_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp50_ = _data_->_tmp49_;
	_data_->_tmp51_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp50_, _ ("Mouse"), _ ("Natural Scrolling"));
	_data_->_tmp52_ = _data_->_tmp51_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp48_, _data_->_tmp52_, "mouse");
	_g_free0 (_data_->_tmp52_);
	_data_->_tmp53_ = _data_->search_results;
	_data_->_tmp54_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp55_ = _data_->_tmp54_;
	_data_->_tmp56_ = g_strdup_printf ("%s → %s", _data_->_tmp55_, _ ("Pointing"));
	_data_->_tmp57_ = _data_->_tmp56_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp53_, _data_->_tmp57_, "pointing");
	_g_free0 (_data_->_tmp57_);
	_data_->_tmp58_ = _data_->search_results;
	_data_->_tmp59_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp60_ = _data_->_tmp59_;
	_data_->_tmp61_ = g_strdup_printf ("%s → %s", _data_->_tmp60_, _ ("Pointer Size"));
	_data_->_tmp62_ = _data_->_tmp61_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp58_, _data_->_tmp62_, "pointing");
	_g_free0 (_data_->_tmp62_);
	_data_->_tmp63_ = _data_->search_results;
	_data_->_tmp64_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp65_ = _data_->_tmp64_;
	_data_->_tmp66_ = g_strdup_printf ("%s → %s", _data_->_tmp65_, _ ("Reveal Pointer"));
	_data_->_tmp67_ = _data_->_tmp66_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp63_, _data_->_tmp67_, "pointing");
	_g_free0 (_data_->_tmp67_);
	_data_->_tmp68_ = _data_->search_results;
	_data_->_tmp69_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp70_ = _data_->_tmp69_;
	_data_->_tmp71_ = g_strdup_printf ("%s → %s", _data_->_tmp70_, _ ("Control Pointer Using Keypad"));
	_data_->_tmp72_ = _data_->_tmp71_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp68_, _data_->_tmp72_, "pointing");
	_g_free0 (_data_->_tmp72_);
	_data_->_tmp73_ = _data_->search_results;
	_data_->_tmp74_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp75_ = _data_->_tmp74_;
	_data_->_tmp76_ = g_strdup_printf ("%s → %s", _data_->_tmp75_, _ ("Touchpad"));
	_data_->_tmp77_ = _data_->_tmp76_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp73_, _data_->_tmp77_, "touchpad");
	_g_free0 (_data_->_tmp77_);
	_data_->_tmp78_ = _data_->search_results;
	_data_->_tmp79_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp80_ = _data_->_tmp79_;
	_data_->_tmp81_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp80_, _ ("Touchpad"), _ ("Pointer Speed"));
	_data_->_tmp82_ = _data_->_tmp81_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp78_, _data_->_tmp82_, "touchpad");
	_g_free0 (_data_->_tmp82_);
	_data_->_tmp83_ = _data_->search_results;
	_data_->_tmp84_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp85_ = _data_->_tmp84_;
	_data_->_tmp86_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp85_, _ ("Touchpad"), _ ("Tap to click"));
	_data_->_tmp87_ = _data_->_tmp86_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp83_, _data_->_tmp87_, "touchpad");
	_g_free0 (_data_->_tmp87_);
	_data_->_tmp88_ = _data_->search_results;
	_data_->_tmp89_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp90_ = _data_->_tmp89_;
	_data_->_tmp91_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp90_, _ ("Touchpad"), _ ("Double-tap and move to drag"));
	_data_->_tmp92_ = _data_->_tmp91_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp88_, _data_->_tmp92_, "touchpad");
	_g_free0 (_data_->_tmp92_);
	_data_->_tmp93_ = _data_->search_results;
	_data_->_tmp94_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp95_ = _data_->_tmp94_;
	_data_->_tmp96_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp95_, _ ("Touchpad"), _ ("Physical Secondary Clicking"));
	_data_->_tmp97_ = _data_->_tmp96_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp93_, _data_->_tmp97_, "touchpad");
	_g_free0 (_data_->_tmp97_);
	_data_->_tmp98_ = _data_->search_results;
	_data_->_tmp99_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp100_ = _data_->_tmp99_;
	_data_->_tmp101_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp100_, _ ("Touchpad"), _ ("Scroll Method"));
	_data_->_tmp102_ = _data_->_tmp101_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp98_, _data_->_tmp102_, "touchpad");
	_g_free0 (_data_->_tmp102_);
	_data_->_tmp103_ = _data_->search_results;
	_data_->_tmp104_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp105_ = _data_->_tmp104_;
	_data_->_tmp106_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp105_, _ ("Touchpad"), _ ("Natural Scrolling"));
	_data_->_tmp107_ = _data_->_tmp106_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp103_, _data_->_tmp107_, "touchpad");
	_g_free0 (_data_->_tmp107_);
	_data_->_tmp108_ = _data_->search_results;
	_data_->_tmp109_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp110_ = _data_->_tmp109_;
	_data_->_tmp111_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp110_, _ ("Touchpad"), _ ("Ignore while typing"));
	_data_->_tmp112_ = _data_->_tmp111_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp108_, _data_->_tmp112_, "touchpad");
	_g_free0 (_data_->_tmp112_);
	_data_->_tmp113_ = _data_->search_results;
	_data_->_tmp114_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp115_ = _data_->_tmp114_;
	_data_->_tmp116_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp115_, _ ("Touchpad"), _ ("Ignore when mouse is connected"));
	_data_->_tmp117_ = _data_->_tmp116_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp113_, _data_->_tmp117_, "touchpad");
	_g_free0 (_data_->_tmp117_);
	if (_data_->self->priv->show_gestures_view) {
		_data_->_tmp118_ = _data_->search_results;
		_data_->_tmp119_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
		_data_->_tmp120_ = _data_->_tmp119_;
		_data_->_tmp121_ = g_strdup_printf ("%s → %s", _data_->_tmp120_, _ ("Gestures"));
		_data_->_tmp122_ = _data_->_tmp121_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp118_, _data_->_tmp122_, "gestures");
		_g_free0 (_data_->_tmp122_);
		_data_->_tmp123_ = _data_->search_results;
		_data_->_tmp124_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
		_data_->_tmp125_ = _data_->_tmp124_;
		_data_->_tmp126_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp125_, _ ("Gestures"), _ ("Multitasking View"));
		_data_->_tmp127_ = _data_->_tmp126_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp123_, _data_->_tmp127_, "gestures");
		_g_free0 (_data_->_tmp127_);
		_data_->_tmp128_ = _data_->search_results;
		_data_->_tmp129_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
		_data_->_tmp130_ = _data_->_tmp129_;
		_data_->_tmp131_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp130_, _ ("Gestures"), _ ("Switch Workspaces"));
		_data_->_tmp132_ = _data_->_tmp131_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp128_, _data_->_tmp132_, "gestures");
		_g_free0 (_data_->_tmp132_);
		_data_->_tmp133_ = _data_->search_results;
		_data_->_tmp134_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
		_data_->_tmp135_ = _data_->_tmp134_;
		_data_->_tmp136_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp135_, _ ("Gestures"), _ ("Maximize Window"));
		_data_->_tmp137_ = _data_->_tmp136_;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp133_, _data_->_tmp137_, "gestures");
		_g_free0 (_data_->_tmp137_);
	}
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static GObject *
mouse_touchpad_plug_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MouseTouchpadPlug * self;
	MouseTouchpadToucheggSettings* _tmp0_;
	MouseTouchpadToucheggSettings* _tmp1_;
	parent_class = G_OBJECT_CLASS (mouse_touchpad_plug_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOUSE_TOUCHPAD_TYPE_PLUG, MouseTouchpadPlug);
	_tmp0_ = mouse_touchpad_touchegg_settings_new ();
	_tmp1_ = _tmp0_;
	self->priv->show_gestures_view = mouse_touchpad_touchegg_settings_is_installed (_tmp1_);
	_g_object_unref0 (_tmp1_);
	return obj;
}

static void
mouse_touchpad_plug_class_init (MouseTouchpadPlugClass * klass,
                                gpointer klass_data)
{
	mouse_touchpad_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MouseTouchpadPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) mouse_touchpad_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) mouse_touchpad_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) mouse_touchpad_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) mouse_touchpad_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) mouse_touchpad_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) mouse_touchpad_plug_search_finish;
	G_OBJECT_CLASS (klass)->constructor = mouse_touchpad_plug_constructor;
	G_OBJECT_CLASS (klass)->finalize = mouse_touchpad_plug_finalize;
}

static void
mouse_touchpad_plug_instance_init (MouseTouchpadPlug * self,
                                   gpointer klass)
{
	self->priv = mouse_touchpad_plug_get_instance_private (self);
}

static void
mouse_touchpad_plug_finalize (GObject * obj)
{
	MouseTouchpadPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MOUSE_TOUCHPAD_TYPE_PLUG, MouseTouchpadPlug);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->hpaned);
	_g_object_unref0 (self->priv->clicking_view);
	_g_object_unref0 (self->priv->mouse_view);
	_g_object_unref0 (self->priv->pointing_view);
	_g_object_unref0 (self->priv->touchpad_view);
	_g_object_unref0 (self->priv->gestures_view);
	G_OBJECT_CLASS (mouse_touchpad_plug_parent_class)->finalize (obj);
}

static GType
mouse_touchpad_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MouseTouchpadPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mouse_touchpad_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MouseTouchpadPlug), 0, (GInstanceInitFunc) mouse_touchpad_plug_instance_init, NULL };
	GType mouse_touchpad_plug_type_id;
	mouse_touchpad_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "MouseTouchpadPlug", &g_define_type_info, 0);
	MouseTouchpadPlug_private_offset = g_type_add_instance_private (mouse_touchpad_plug_type_id, sizeof (MouseTouchpadPlugPrivate));
	return mouse_touchpad_plug_type_id;
}

GType
mouse_touchpad_plug_get_type (void)
{
	static volatile gsize mouse_touchpad_plug_type_id__once = 0;
	if (g_once_init_enter (&mouse_touchpad_plug_type_id__once)) {
		GType mouse_touchpad_plug_type_id;
		mouse_touchpad_plug_type_id = mouse_touchpad_plug_get_type_once ();
		g_once_init_leave (&mouse_touchpad_plug_type_id__once, mouse_touchpad_plug_type_id);
	}
	return mouse_touchpad_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	MouseTouchpadPlug* plug = NULL;
	MouseTouchpadPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:175: Activating Mouse-Touchpad plug");
	_tmp0_ = mouse_touchpad_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

