/* ThumbnailGenerator.c generated by valac 0.56.17, the Vala compiler
 * generated from ThumbnailGenerator.vala, do not modify */

/*
* Copyright (c) 2017 elementary LLC. (https://elementary.io)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: David Hewitt <davidmhewitt@gmail.com>
*/

#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "desktop.h"
#include <gee.h>
#include <gobject/gvaluecollector.h>

#define PANTHEON_SHELL_THUMBNAIL_GENERATOR_THUMBNAILER_DBUS_ID "org.freedesktop.thumbnails.Thumbnailer1"
#define PANTHEON_SHELL_THUMBNAIL_GENERATOR_THUMBNAILER_DBUS_PATH "/org/freedesktop/thumbnails/Thumbnailer1"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PANTHEON_SHELL_TYPE_THUMBNAILER (pantheon_shell_thumbnailer_get_type ())
#define PANTHEON_SHELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PANTHEON_SHELL_TYPE_THUMBNAILER, PantheonShellThumbnailer))
#define PANTHEON_SHELL_IS_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PANTHEON_SHELL_TYPE_THUMBNAILER))
#define PANTHEON_SHELL_THUMBNAILER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PANTHEON_SHELL_TYPE_THUMBNAILER, PantheonShellThumbnailerIface))

typedef struct _PantheonShellThumbnailer PantheonShellThumbnailer;
typedef struct _PantheonShellThumbnailerIface PantheonShellThumbnailerIface;

#define PANTHEON_SHELL_TYPE_THUMBNAILER_PROXY (pantheon_shell_thumbnailer_proxy_get_type ())
enum  {
	PANTHEON_SHELL_THUMBNAILER_READY_SIGNAL,
	PANTHEON_SHELL_THUMBNAILER_FINISHED_SIGNAL,
	PANTHEON_SHELL_THUMBNAILER_NUM_SIGNALS
};
static guint pantheon_shell_thumbnailer_signals[PANTHEON_SHELL_THUMBNAILER_NUM_SIGNALS] = {0};
typedef GDBusProxy PantheonShellThumbnailerProxy;
typedef GDBusProxyClass PantheonShellThumbnailerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pantheon_shell_thumbnail_generator_unref0(var) ((var == NULL) ? NULL : (var = (pantheon_shell_thumbnail_generator_unref (var), NULL)))
#define _pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref0(var) ((var == NULL) ? NULL : (var = (pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PantheonShellThumbnailGeneratorParamSpecThumbnailReadyWrapper PantheonShellThumbnailGeneratorParamSpecThumbnailReadyWrapper;
typedef struct _PantheonShellParamSpecThumbnailGenerator PantheonShellParamSpecThumbnailGenerator;

struct _PantheonShellThumbnailerIface {
	GTypeInterface parent_iface;
	guint32 (*queue) (PantheonShellThumbnailer* self, gchar** uris, gint uris_length1, gchar** mime_types, gint mime_types_length1, const gchar* flavor, const gchar* scheduler, guint32 dequeue, GError** error);
	void (*dequeue) (PantheonShellThumbnailer* self, guint32 handle, GError** error);
};

struct _PantheonShellThumbnailGeneratorPrivate {
	PantheonShellThumbnailer* thumbnailer;
	GeeHashMap* queued_delegates;
	GeeArrayList* handles;
};

struct _PantheonShellThumbnailGeneratorThumbnailReadyWrapperPrivate {
	PantheonShellThumbnailGeneratorThumbnailReady _cb;
	gpointer _cb_target;
};

struct _PantheonShellThumbnailGeneratorParamSpecThumbnailReadyWrapper {
	GParamSpec parent_instance;
};

struct _PantheonShellParamSpecThumbnailGenerator {
	GParamSpec parent_instance;
};

static gint PantheonShellThumbnailGenerator_private_offset;
static gpointer pantheon_shell_thumbnail_generator_parent_class = NULL;
static PantheonShellThumbnailGenerator* pantheon_shell_thumbnail_generator_instance;
static PantheonShellThumbnailGenerator* pantheon_shell_thumbnail_generator_instance = NULL;
static gint PantheonShellThumbnailGeneratorThumbnailReadyWrapper_private_offset;
static gpointer pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_parent_class = NULL;

VALA_EXTERN GType pantheon_shell_thumbnailer_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pantheon_shell_thumbnailer_register_object (void* object,
                                                  GDBusConnection* connection,
                                                  const gchar* path,
                                                  GError** error);
VALA_EXTERN GType pantheon_shell_thumbnailer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint32 pantheon_shell_thumbnailer_queue (PantheonShellThumbnailer* self,
                                          gchar** uris,
                                          gint uris_length1,
                                          gchar** mime_types,
                                          gint mime_types_length1,
                                          const gchar* flavor,
                                          const gchar* scheduler,
                                          guint32 dequeue,
                                          GError** error);
VALA_EXTERN void pantheon_shell_thumbnailer_dequeue (PantheonShellThumbnailer* self,
                                         guint32 handle,
                                         GError** error);
static void g_cclosure_user_marshal_VOID__UINT_BOXED_INT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static GType pantheon_shell_thumbnailer_get_type_once (void);
static void pantheon_shell_thumbnailer_proxy_g_signal (GDBusProxy* proxy,
                                                const gchar* sender_name,
                                                const gchar* signal_name,
                                                GVariant* parameters);
static void _dbus_handle_pantheon_shell_thumbnailer_ready (PantheonShellThumbnailer* self,
                                                    GVariant* parameters);
static void _dbus_handle_pantheon_shell_thumbnailer_finished (PantheonShellThumbnailer* self,
                                                       GVariant* parameters);
static guint32 pantheon_shell_thumbnailer_proxy_queue (PantheonShellThumbnailer* self,
                                                gchar** uris,
                                                gint uris_length1,
                                                gchar** mime_types,
                                                gint mime_types_length1,
                                                const gchar* flavor,
                                                const gchar* scheduler,
                                                guint32 dequeue,
                                                GError** error);
static void pantheon_shell_thumbnailer_proxy_dequeue (PantheonShellThumbnailer* self,
                                               guint32 handle,
                                               GError** error);
static void pantheon_shell_thumbnailer_proxy_pantheon_shell_thumbnailer_interface_init (PantheonShellThumbnailerIface* iface);
static void _dbus_pantheon_shell_thumbnailer_queue (PantheonShellThumbnailer* self,
                                             GVariant* _parameters_,
                                             GDBusMethodInvocation* invocation);
static void _dbus_pantheon_shell_thumbnailer_dequeue (PantheonShellThumbnailer* self,
                                               GVariant* _parameters_,
                                               GDBusMethodInvocation* invocation);
static void pantheon_shell_thumbnailer_dbus_interface_method_call (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* method_name,
                                                            GVariant* parameters,
                                                            GDBusMethodInvocation* invocation,
                                                            gpointer user_data);
static GVariant* pantheon_shell_thumbnailer_dbus_interface_get_property (GDBusConnection* connection,
                                                                  const gchar* sender,
                                                                  const gchar* object_path,
                                                                  const gchar* interface_name,
                                                                  const gchar* property_name,
                                                                  GError** error,
                                                                  gpointer user_data);
static gboolean pantheon_shell_thumbnailer_dbus_interface_set_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GVariant* value,
                                                                 GError** error,
                                                                 gpointer user_data);
static void _dbus_pantheon_shell_thumbnailer_ready (GObject* _sender,
                                             guint32 handle,
                                             gchar** uris,
                                             gint uris_length1,
                                             gpointer* _data);
static void _dbus_pantheon_shell_thumbnailer_finished (GObject* _sender,
                                                guint32 handle,
                                                gpointer* _data);
static void _pantheon_shell_thumbnailer_unregister_object (gpointer user_data);
static void ___lambda4_ (PantheonShellThumbnailGenerator* self,
                  guint32 handle,
                  gchar** uris,
                  gint uris_length1);
static void ____lambda4__pantheon_shell_thumbnailer_ready (PantheonShellThumbnailer* _sender,
                                                    guint32 handle,
                                                    gchar** uris,
                                                    gint uris_length1,
                                                    gpointer self);
static void ___lambda5_ (PantheonShellThumbnailGenerator* self,
                  guint32 handle);
static void ____lambda5__pantheon_shell_thumbnailer_finished (PantheonShellThumbnailer* _sender,
                                                       guint32 handle,
                                                       gpointer self);
static gchar* pantheon_shell_thumbnail_generator_get_mime_type (PantheonShellThumbnailGenerator* self,
                                                         const gchar* uri);
static void pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_finalize (PantheonShellThumbnailGeneratorThumbnailReadyWrapper * obj);
static GType pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_type_once (void);
static void pantheon_shell_thumbnail_generator_finalize (PantheonShellThumbnailGenerator * obj);
static GType pantheon_shell_thumbnail_generator_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_queue_uris = {-1, "uris", "as", NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_queue_mime_types = {-1, "mime_types", "as", NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_queue_flavor = {-1, "flavor", "s", NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_queue_scheduler = {-1, "scheduler", "s", NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_queue_dequeue = {-1, "dequeue", "u", NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_queue_result = {-1, "result", "u", NULL};
static const GDBusArgInfo * const _pantheon_shell_thumbnailer_dbus_arg_info_queue_in[] = {&_pantheon_shell_thumbnailer_dbus_arg_info_queue_uris, &_pantheon_shell_thumbnailer_dbus_arg_info_queue_mime_types, &_pantheon_shell_thumbnailer_dbus_arg_info_queue_flavor, &_pantheon_shell_thumbnailer_dbus_arg_info_queue_scheduler, &_pantheon_shell_thumbnailer_dbus_arg_info_queue_dequeue, NULL};
static const GDBusArgInfo * const _pantheon_shell_thumbnailer_dbus_arg_info_queue_out[] = {&_pantheon_shell_thumbnailer_dbus_arg_info_queue_result, NULL};
static const GDBusMethodInfo _pantheon_shell_thumbnailer_dbus_method_info_queue = {-1, "Queue", (GDBusArgInfo **) (&_pantheon_shell_thumbnailer_dbus_arg_info_queue_in), (GDBusArgInfo **) (&_pantheon_shell_thumbnailer_dbus_arg_info_queue_out), NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_dequeue_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo * const _pantheon_shell_thumbnailer_dbus_arg_info_dequeue_in[] = {&_pantheon_shell_thumbnailer_dbus_arg_info_dequeue_handle, NULL};
static const GDBusArgInfo * const _pantheon_shell_thumbnailer_dbus_arg_info_dequeue_out[] = {NULL};
static const GDBusMethodInfo _pantheon_shell_thumbnailer_dbus_method_info_dequeue = {-1, "Dequeue", (GDBusArgInfo **) (&_pantheon_shell_thumbnailer_dbus_arg_info_dequeue_in), (GDBusArgInfo **) (&_pantheon_shell_thumbnailer_dbus_arg_info_dequeue_out), NULL};
static const GDBusMethodInfo * const _pantheon_shell_thumbnailer_dbus_method_info[] = {&_pantheon_shell_thumbnailer_dbus_method_info_queue, &_pantheon_shell_thumbnailer_dbus_method_info_dequeue, NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_ready_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_ready_uris = {-1, "uris", "as", NULL};
static const GDBusArgInfo * const _pantheon_shell_thumbnailer_dbus_arg_info_ready[] = {&_pantheon_shell_thumbnailer_dbus_arg_info_ready_handle, &_pantheon_shell_thumbnailer_dbus_arg_info_ready_uris, NULL};
static const GDBusSignalInfo _pantheon_shell_thumbnailer_dbus_signal_info_ready = {-1, "Ready", (GDBusArgInfo **) (&_pantheon_shell_thumbnailer_dbus_arg_info_ready), NULL};
static const GDBusArgInfo _pantheon_shell_thumbnailer_dbus_arg_info_finished_handle = {-1, "handle", "u", NULL};
static const GDBusArgInfo * const _pantheon_shell_thumbnailer_dbus_arg_info_finished[] = {&_pantheon_shell_thumbnailer_dbus_arg_info_finished_handle, NULL};
static const GDBusSignalInfo _pantheon_shell_thumbnailer_dbus_signal_info_finished = {-1, "Finished", (GDBusArgInfo **) (&_pantheon_shell_thumbnailer_dbus_arg_info_finished), NULL};
static const GDBusSignalInfo * const _pantheon_shell_thumbnailer_dbus_signal_info[] = {&_pantheon_shell_thumbnailer_dbus_signal_info_ready, &_pantheon_shell_thumbnailer_dbus_signal_info_finished, NULL};
static const GDBusPropertyInfo * const _pantheon_shell_thumbnailer_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _pantheon_shell_thumbnailer_dbus_interface_info = {-1, "org.freedesktop.thumbnails.Thumbnailer1", (GDBusMethodInfo **) (&_pantheon_shell_thumbnailer_dbus_method_info), (GDBusSignalInfo **) (&_pantheon_shell_thumbnailer_dbus_signal_info), (GDBusPropertyInfo **) (&_pantheon_shell_thumbnailer_dbus_property_info), NULL};
static const GDBusInterfaceVTable _pantheon_shell_thumbnailer_dbus_interface_vtable = {pantheon_shell_thumbnailer_dbus_interface_method_call, pantheon_shell_thumbnailer_dbus_interface_get_property, pantheon_shell_thumbnailer_dbus_interface_set_property};

guint32
pantheon_shell_thumbnailer_queue (PantheonShellThumbnailer* self,
                                  gchar** uris,
                                  gint uris_length1,
                                  gchar** mime_types,
                                  gint mime_types_length1,
                                  const gchar* flavor,
                                  const gchar* scheduler,
                                  guint32 dequeue,
                                  GError** error)
{
	PantheonShellThumbnailerIface* _iface_;
	g_return_val_if_fail (self != NULL, 0U);
	_iface_ = PANTHEON_SHELL_THUMBNAILER_GET_INTERFACE (self);
	if (_iface_->queue) {
		return _iface_->queue (self, uris, uris_length1, mime_types, mime_types_length1, flavor, scheduler, dequeue, error);
	}
	return 0U;
}

void
pantheon_shell_thumbnailer_dequeue (PantheonShellThumbnailer* self,
                                    guint32 handle,
                                    GError** error)
{
	PantheonShellThumbnailerIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = PANTHEON_SHELL_THUMBNAILER_GET_INTERFACE (self);
	if (_iface_->dequeue) {
		_iface_->dequeue (self, handle, error);
	}
}

static void
g_cclosure_user_marshal_VOID__UINT_BOXED_INT (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT_BOXED_INT) (gpointer data1, guint32 arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
pantheon_shell_thumbnailer_default_init (PantheonShellThumbnailerIface * iface,
                                         gpointer iface_data)
{
	pantheon_shell_thumbnailer_signals[PANTHEON_SHELL_THUMBNAILER_READY_SIGNAL] = g_signal_new ("ready", PANTHEON_SHELL_TYPE_THUMBNAILER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED_INT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_STRV, G_TYPE_INT);
	pantheon_shell_thumbnailer_signals[PANTHEON_SHELL_THUMBNAILER_FINISHED_SIGNAL] = g_signal_new ("finished", PANTHEON_SHELL_TYPE_THUMBNAILER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
}

static GType
pantheon_shell_thumbnailer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellThumbnailerIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_thumbnailer_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType pantheon_shell_thumbnailer_type_id;
	pantheon_shell_thumbnailer_type_id = g_type_register_static (G_TYPE_INTERFACE, "PantheonShellThumbnailer", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (pantheon_shell_thumbnailer_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (pantheon_shell_thumbnailer_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) pantheon_shell_thumbnailer_proxy_get_type);
	g_type_set_qdata (pantheon_shell_thumbnailer_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.thumbnails.Thumbnailer1");
	g_type_set_qdata (pantheon_shell_thumbnailer_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_pantheon_shell_thumbnailer_dbus_interface_info));
	g_type_set_qdata (pantheon_shell_thumbnailer_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) pantheon_shell_thumbnailer_register_object);
	return pantheon_shell_thumbnailer_type_id;
}

GType
pantheon_shell_thumbnailer_get_type (void)
{
	static volatile gsize pantheon_shell_thumbnailer_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_thumbnailer_type_id__once)) {
		GType pantheon_shell_thumbnailer_type_id;
		pantheon_shell_thumbnailer_type_id = pantheon_shell_thumbnailer_get_type_once ();
		g_once_init_leave (&pantheon_shell_thumbnailer_type_id__once, pantheon_shell_thumbnailer_type_id);
	}
	return pantheon_shell_thumbnailer_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (PantheonShellThumbnailerProxy, pantheon_shell_thumbnailer_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (PANTHEON_SHELL_TYPE_THUMBNAILER, pantheon_shell_thumbnailer_proxy_pantheon_shell_thumbnailer_interface_init) )
static void
pantheon_shell_thumbnailer_proxy_class_init (PantheonShellThumbnailerProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = pantheon_shell_thumbnailer_proxy_g_signal;
}

static void
_dbus_handle_pantheon_shell_thumbnailer_ready (PantheonShellThumbnailer* self,
                                               GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint32 handle = 0U;
	GVariant* _tmp4_;
	gchar** uris = NULL;
	gint uris_length1;
	GVariant* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length;
	gint _tmp6__size;
	gint _tmp6__length1;
	GVariantIter _tmp7_;
	GVariant* _tmp8_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	uris_length1 = 0;
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp6_ = g_new (gchar*, 5);
	_tmp6__length = 0;
	_tmp6__size = 4;
	_tmp6__length1 = 0;
	g_variant_iter_init (&_tmp7_, _tmp5_);
	for (; (_tmp8_ = g_variant_iter_next_value (&_tmp7_)) != NULL; _tmp6__length1++) {
		if (_tmp6__size == _tmp6__length) {
			_tmp6__size = 2 * _tmp6__size;
			_tmp6_ = g_renew (gchar*, _tmp6_, _tmp6__size + 1);
		}
		_tmp6_[_tmp6__length++] = g_variant_dup_string (_tmp8_, NULL);
		g_variant_unref (_tmp8_);
	}
	uris_length1 = _tmp6__length1;
	_tmp6_[_tmp6__length] = NULL;
	uris = _tmp6_;
	g_variant_unref (_tmp5_);
	g_signal_emit_by_name (self, "ready", handle, uris, uris_length1);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
}

static void
_dbus_handle_pantheon_shell_thumbnailer_finished (PantheonShellThumbnailer* self,
                                                  GVariant* parameters)
{
	GVariantIter _arguments_iter;
	guint32 handle = 0U;
	GVariant* _tmp9_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp9_);
	g_variant_unref (_tmp9_);
	g_signal_emit_by_name (self, "finished", handle);
}

static void
pantheon_shell_thumbnailer_proxy_g_signal (GDBusProxy* proxy,
                                           const gchar* sender_name,
                                           const gchar* signal_name,
                                           GVariant* parameters)
{
	if (strcmp (signal_name, "Ready") == 0) {
		_dbus_handle_pantheon_shell_thumbnailer_ready ((PantheonShellThumbnailer*) proxy, parameters);
	} else if (strcmp (signal_name, "Finished") == 0) {
		_dbus_handle_pantheon_shell_thumbnailer_finished ((PantheonShellThumbnailer*) proxy, parameters);
	}
}

static void
pantheon_shell_thumbnailer_proxy_init (PantheonShellThumbnailerProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_pantheon_shell_thumbnailer_dbus_interface_info));
}

static guint32
pantheon_shell_thumbnailer_proxy_queue (PantheonShellThumbnailer* self,
                                        gchar** uris,
                                        gint uris_length1,
                                        gchar** mime_types,
                                        gint mime_types_length1,
                                        const gchar* flavor,
                                        const gchar* scheduler,
                                        guint32 dequeue,
                                        GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp10_;
	GVariantBuilder _tmp11_;
	gint _tmp12_;
	gchar** _tmp13_;
	GVariantBuilder _tmp14_;
	gint _tmp15_;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	guint32 _result = 0U;
	GVariant* _tmp18_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.thumbnails.Thumbnailer1", "Queue");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_tmp10_ = uris;
	g_variant_builder_init (&_tmp11_, G_VARIANT_TYPE ("as"));
	for (_tmp12_ = 0; _tmp12_ < uris_length1; _tmp12_++) {
		g_variant_builder_add_value (&_tmp11_, g_variant_new_string (*_tmp10_));
		_tmp10_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp11_));
	_tmp13_ = mime_types;
	g_variant_builder_init (&_tmp14_, G_VARIANT_TYPE ("as"));
	for (_tmp15_ = 0; _tmp15_ < mime_types_length1; _tmp15_++) {
		g_variant_builder_add_value (&_tmp14_, g_variant_new_string (*_tmp13_));
		_tmp13_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp14_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (flavor));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (scheduler));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (dequeue));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		guint32 _tmp16_ = 0U;
		return _tmp16_;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		guint32 _tmp17_ = 0U;
		g_object_unref (_reply_message);
		return _tmp17_;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp18_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_get_uint32 (_tmp18_);
	g_variant_unref (_tmp18_);
	g_object_unref (_reply_message);
	return _result;
}

static void
pantheon_shell_thumbnailer_proxy_dequeue (PantheonShellThumbnailer* self,
                                          guint32 handle,
                                          GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.thumbnails.Thumbnailer1", "Dequeue");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
pantheon_shell_thumbnailer_proxy_pantheon_shell_thumbnailer_interface_init (PantheonShellThumbnailerIface* iface)
{
	iface->queue = pantheon_shell_thumbnailer_proxy_queue;
	iface->dequeue = pantheon_shell_thumbnailer_proxy_dequeue;
}

static void
_dbus_pantheon_shell_thumbnailer_queue (PantheonShellThumbnailer* self,
                                        GVariant* _parameters_,
                                        GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar** uris = NULL;
	gint uris_length1 = 0;
	GVariant* _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length;
	gint _tmp20__size;
	gint _tmp20__length1;
	GVariantIter _tmp21_;
	GVariant* _tmp22_;
	gchar** mime_types = NULL;
	gint mime_types_length1 = 0;
	GVariant* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length;
	gint _tmp24__size;
	gint _tmp24__length1;
	GVariantIter _tmp25_;
	GVariant* _tmp26_;
	gchar* flavor = NULL;
	GVariant* _tmp27_;
	gchar* scheduler = NULL;
	GVariant* _tmp28_;
	guint32 dequeue = 0U;
	GVariant* _tmp29_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint32 result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp19_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp20_ = g_new (gchar*, 5);
	_tmp20__length = 0;
	_tmp20__size = 4;
	_tmp20__length1 = 0;
	g_variant_iter_init (&_tmp21_, _tmp19_);
	for (; (_tmp22_ = g_variant_iter_next_value (&_tmp21_)) != NULL; _tmp20__length1++) {
		if (_tmp20__size == _tmp20__length) {
			_tmp20__size = 2 * _tmp20__size;
			_tmp20_ = g_renew (gchar*, _tmp20_, _tmp20__size + 1);
		}
		_tmp20_[_tmp20__length++] = g_variant_dup_string (_tmp22_, NULL);
		g_variant_unref (_tmp22_);
	}
	uris_length1 = _tmp20__length1;
	_tmp20_[_tmp20__length] = NULL;
	uris = _tmp20_;
	g_variant_unref (_tmp19_);
	_tmp23_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp24_ = g_new (gchar*, 5);
	_tmp24__length = 0;
	_tmp24__size = 4;
	_tmp24__length1 = 0;
	g_variant_iter_init (&_tmp25_, _tmp23_);
	for (; (_tmp26_ = g_variant_iter_next_value (&_tmp25_)) != NULL; _tmp24__length1++) {
		if (_tmp24__size == _tmp24__length) {
			_tmp24__size = 2 * _tmp24__size;
			_tmp24_ = g_renew (gchar*, _tmp24_, _tmp24__size + 1);
		}
		_tmp24_[_tmp24__length++] = g_variant_dup_string (_tmp26_, NULL);
		g_variant_unref (_tmp26_);
	}
	mime_types_length1 = _tmp24__length1;
	_tmp24_[_tmp24__length] = NULL;
	mime_types = _tmp24_;
	g_variant_unref (_tmp23_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	flavor = g_variant_dup_string (_tmp27_, NULL);
	g_variant_unref (_tmp27_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	scheduler = g_variant_dup_string (_tmp28_, NULL);
	g_variant_unref (_tmp28_);
	_tmp29_ = g_variant_iter_next_value (&_arguments_iter);
	dequeue = g_variant_get_uint32 (_tmp29_);
	g_variant_unref (_tmp29_);
	result = pantheon_shell_thumbnailer_queue (self, uris, uris_length1, mime_types, mime_types_length1, flavor, scheduler, dequeue, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) g_free), NULL);
	mime_types = (_vala_array_free (mime_types, mime_types_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (flavor);
	_g_free0 (scheduler);
	;
}

static void
_dbus_pantheon_shell_thumbnailer_dequeue (PantheonShellThumbnailer* self,
                                          GVariant* _parameters_,
                                          GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint32 handle = 0U;
	GVariant* _tmp30_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp30_ = g_variant_iter_next_value (&_arguments_iter);
	handle = g_variant_get_uint32 (_tmp30_);
	g_variant_unref (_tmp30_);
	pantheon_shell_thumbnailer_dequeue (self, handle, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
pantheon_shell_thumbnailer_dbus_interface_method_call (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* method_name,
                                                       GVariant* parameters,
                                                       GDBusMethodInvocation* invocation,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Queue") == 0) {
		_dbus_pantheon_shell_thumbnailer_queue (object, parameters, invocation);
	} else if (strcmp (method_name, "Dequeue") == 0) {
		_dbus_pantheon_shell_thumbnailer_dequeue (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
pantheon_shell_thumbnailer_dbus_interface_get_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
pantheon_shell_thumbnailer_dbus_interface_set_property (GDBusConnection* connection,
                                                        const gchar* sender,
                                                        const gchar* object_path,
                                                        const gchar* interface_name,
                                                        const gchar* property_name,
                                                        GVariant* value,
                                                        GError** error,
                                                        gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

static void
_dbus_pantheon_shell_thumbnailer_ready (GObject* _sender,
                                        guint32 handle,
                                        gchar** uris,
                                        gint uris_length1,
                                        gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	gchar** _tmp31_;
	GVariantBuilder _tmp32_;
	gint _tmp33_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_tmp31_ = uris;
	g_variant_builder_init (&_tmp32_, G_VARIANT_TYPE ("as"));
	for (_tmp33_ = 0; _tmp33_ < uris_length1; _tmp33_++) {
		g_variant_builder_add_value (&_tmp32_, g_variant_new_string (*_tmp31_));
		_tmp31_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp32_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.thumbnails.Thumbnailer1", "Ready", _arguments, NULL);
}

static void
_dbus_pantheon_shell_thumbnailer_finished (GObject* _sender,
                                           guint32 handle,
                                           gpointer* _data)
{
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (handle));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.freedesktop.thumbnails.Thumbnailer1", "Finished", _arguments, NULL);
}

guint
pantheon_shell_thumbnailer_register_object (gpointer object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_pantheon_shell_thumbnailer_dbus_interface_info), &_pantheon_shell_thumbnailer_dbus_interface_vtable, data, _pantheon_shell_thumbnailer_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "ready", (GCallback) _dbus_pantheon_shell_thumbnailer_ready, data);
	g_signal_connect (object, "finished", (GCallback) _dbus_pantheon_shell_thumbnailer_finished, data);
	return result;
}

static void
_pantheon_shell_thumbnailer_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pantheon_shell_thumbnailer_ready, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_pantheon_shell_thumbnailer_finished, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
pantheon_shell_thumbnail_generator_get_instance_private (PantheonShellThumbnailGenerator* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellThumbnailGenerator_private_offset);
}

static gpointer
_pantheon_shell_thumbnail_generator_ref0 (gpointer self)
{
	return self ? pantheon_shell_thumbnail_generator_ref (self) : NULL;
}

PantheonShellThumbnailGenerator*
pantheon_shell_thumbnail_generator_get_default (void)
{
	PantheonShellThumbnailGenerator* _tmp0_;
	PantheonShellThumbnailGenerator* _tmp2_;
	PantheonShellThumbnailGenerator* _tmp3_;
	PantheonShellThumbnailGenerator* result;
	_tmp0_ = pantheon_shell_thumbnail_generator_instance;
	if (_tmp0_ == NULL) {
		PantheonShellThumbnailGenerator* _tmp1_;
		_tmp1_ = pantheon_shell_thumbnail_generator_new ();
		_pantheon_shell_thumbnail_generator_unref0 (pantheon_shell_thumbnail_generator_instance);
		pantheon_shell_thumbnail_generator_instance = _tmp1_;
	}
	_tmp2_ = pantheon_shell_thumbnail_generator_instance;
	_tmp3_ = _pantheon_shell_thumbnail_generator_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
___lambda4_ (PantheonShellThumbnailGenerator* self,
             guint32 handle,
             gchar** uris,
             gint uris_length1)
{
	GeeHashMap* _tmp0_;
	_tmp0_ = self->priv->queued_delegates;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) handle))) {
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		PantheonShellThumbnailGeneratorThumbnailReadyWrapper* _tmp3_;
		PantheonShellThumbnailGeneratorThumbnailReady _tmp4_ = NULL;
		gpointer _tmp4__target = NULL;
		PantheonShellThumbnailGeneratorThumbnailReady _tmp5_;
		gpointer _tmp5__target;
		_tmp1_ = self->priv->queued_delegates;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) handle));
		_tmp3_ = (PantheonShellThumbnailGeneratorThumbnailReadyWrapper*) _tmp2_;
		_tmp4_ = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_cb (_tmp3_, &_tmp4__target);
		_tmp5_ = _tmp4_;
		_tmp5__target = _tmp4__target;
		_tmp5_ (_tmp5__target);
		_pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref0 (_tmp3_);
	}
}

static void
____lambda4__pantheon_shell_thumbnailer_ready (PantheonShellThumbnailer* _sender,
                                               guint32 handle,
                                               gchar** uris,
                                               gint uris_length1,
                                               gpointer self)
{
	___lambda4_ ((PantheonShellThumbnailGenerator*) self, handle, uris, uris_length1);
}

static void
___lambda5_ (PantheonShellThumbnailGenerator* self,
             guint32 handle)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	_tmp0_ = self->priv->queued_delegates;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) handle), NULL);
	_tmp1_ = self->priv->handles;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp1_, (gpointer) ((guintptr) handle));
}

static void
____lambda5__pantheon_shell_thumbnailer_finished (PantheonShellThumbnailer* _sender,
                                                  guint32 handle,
                                                  gpointer self)
{
	___lambda5_ ((PantheonShellThumbnailGenerator*) self, handle);
}

PantheonShellThumbnailGenerator*
pantheon_shell_thumbnail_generator_construct (GType object_type)
{
	PantheonShellThumbnailGenerator* self = NULL;
	GError* _inner_error0_ = NULL;
	self = (PantheonShellThumbnailGenerator*) g_type_create_instance (object_type);
	{
		PantheonShellThumbnailer* _tmp0_ = NULL;
		PantheonShellThumbnailer* _tmp1_;
		PantheonShellThumbnailer* _tmp2_;
		PantheonShellThumbnailer* _tmp3_;
		PantheonShellThumbnailer* _tmp4_;
		_tmp1_ = (PantheonShellThumbnailer*) g_initable_new (PANTHEON_SHELL_TYPE_THUMBNAILER_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", PANTHEON_SHELL_THUMBNAIL_GENERATOR_THUMBNAILER_DBUS_ID, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", PANTHEON_SHELL_THUMBNAIL_GENERATOR_THUMBNAILER_DBUS_PATH, "g-interface-name", "org.freedesktop.thumbnails.Thumbnailer1", NULL);
		_tmp0_ = (PantheonShellThumbnailer*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->thumbnailer);
		self->priv->thumbnailer = _tmp2_;
		_tmp3_ = self->priv->thumbnailer;
		g_signal_connect (_tmp3_, "ready", (GCallback) ____lambda4__pantheon_shell_thumbnailer_ready, self);
		_tmp4_ = self->priv->thumbnailer;
		g_signal_connect (_tmp4_, "finished", (GCallback) ____lambda5__pantheon_shell_thumbnailer_finished, self);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("ThumbnailGenerator.vala:66: Unable to connect to system thumbnailer: %" \
"s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

PantheonShellThumbnailGenerator*
pantheon_shell_thumbnail_generator_new (void)
{
	return pantheon_shell_thumbnail_generator_construct (PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR);
}

void
pantheon_shell_thumbnail_generator_dequeue_all (PantheonShellThumbnailGenerator* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _handle_list = NULL;
		GeeArrayList* _tmp0_;
		gint _handle_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _handle_index = 0;
		_tmp0_ = self->priv->handles;
		_handle_list = _tmp0_;
		_tmp1_ = _handle_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_handle_size = _tmp3_;
		_handle_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			guint32 handle = 0U;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_handle_index = _handle_index + 1;
			_tmp4_ = _handle_index;
			_tmp5_ = _handle_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _handle_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _handle_index);
			handle = (guint32) ((guintptr) _tmp7_);
			{
				PantheonShellThumbnailer* _tmp8_;
				_tmp8_ = self->priv->thumbnailer;
				pantheon_shell_thumbnailer_dequeue (_tmp8_, handle, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp9_;
				const gchar* _tmp10_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp9_ = e;
				_tmp10_ = _tmp9_->message;
				g_warning ("ThumbnailGenerator.vala:75: Unable to tell thumbnailer to stop creatin" \
"g thumbnails: %s", _tmp10_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

void
pantheon_shell_thumbnail_generator_get_thumbnail (PantheonShellThumbnailGenerator* self,
                                                  const gchar* uri,
                                                  guint size,
                                                  PantheonShellThumbnailGeneratorThumbnailReady callback,
                                                  gpointer callback_target)
{
	gchar* thumb_size = NULL;
	gchar* _tmp0_;
	PantheonShellThumbnailer* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = g_strdup ("normal");
	thumb_size = _tmp0_;
	if (size > ((guint) 128)) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("large");
		_g_free0 (thumb_size);
		thumb_size = _tmp1_;
	}
	_tmp2_ = self->priv->thumbnailer;
	if (_tmp2_ != NULL) {
		PantheonShellThumbnailGeneratorThumbnailReadyWrapper* wrapper = NULL;
		PantheonShellThumbnailGeneratorThumbnailReadyWrapper* _tmp3_;
		PantheonShellThumbnailGeneratorThumbnailReadyWrapper* _tmp4_;
		_tmp3_ = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_new ();
		wrapper = _tmp3_;
		_tmp4_ = wrapper;
		pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_set_cb (_tmp4_, callback, callback_target);
		{
			guint32 handle = 0U;
			PantheonShellThumbnailer* _tmp5_;
			gchar* _tmp6_;
			gchar** _tmp7_;
			gchar** _tmp8_;
			gint _tmp8__length1;
			gchar* _tmp9_;
			gchar** _tmp10_;
			gchar** _tmp11_;
			gint _tmp11__length1;
			const gchar* _tmp12_;
			guint32 _tmp13_;
			GeeArrayList* _tmp14_;
			GeeHashMap* _tmp15_;
			PantheonShellThumbnailGeneratorThumbnailReadyWrapper* _tmp16_;
			_tmp5_ = self->priv->thumbnailer;
			_tmp6_ = g_strdup (uri);
			_tmp7_ = g_new0 (gchar*, 1 + 1);
			_tmp7_[0] = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp8__length1 = 1;
			_tmp9_ = pantheon_shell_thumbnail_generator_get_mime_type (self, uri);
			_tmp10_ = g_new0 (gchar*, 1 + 1);
			_tmp10_[0] = _tmp9_;
			_tmp11_ = _tmp10_;
			_tmp11__length1 = 1;
			_tmp12_ = thumb_size;
			_tmp13_ = pantheon_shell_thumbnailer_queue (_tmp5_, _tmp8_, (gint) 1, _tmp11_, (gint) 1, _tmp12_, "default", (guint32) 0, &_inner_error0_);
			_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
			_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
			handle = _tmp13_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp14_ = self->priv->handles;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, (gpointer) ((guintptr) handle));
			_tmp15_ = self->priv->queued_delegates;
			_tmp16_ = wrapper;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, (gpointer) ((guintptr) handle), _tmp16_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp17_;
			const gchar* _tmp18_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp17_ = e;
			_tmp18_ = _tmp17_->message;
			g_warning ("ThumbnailGenerator.vala:96: Unable to queue thumbnail generation for '" \
"%s': %s", uri, _tmp18_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref0 (wrapper);
			_g_free0 (thumb_size);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref0 (wrapper);
	}
	_g_free0 (thumb_size);
}

static gchar*
pantheon_shell_thumbnail_generator_get_mime_type (PantheonShellThumbnailGenerator* self,
                                                  const gchar* uri)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_filename_from_uri (uri, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
				goto __catch0_g_convert_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = g_content_type_guess (_tmp0_, NULL, (gsize) 0, NULL);
		result = _tmp2_;
		_g_free0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("ThumbnailGenerator.vala:105: Error converting filename '%s' while gues" \
"sing mime type: %s", uri, _tmp4_);
		_tmp5_ = g_strdup ("");
		result = _tmp5_;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static inline gpointer
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_instance_private (PantheonShellThumbnailGeneratorThumbnailReadyWrapper* self)
{
	return G_STRUCT_MEMBER_P (self, PantheonShellThumbnailGeneratorThumbnailReadyWrapper_private_offset);
}

PantheonShellThumbnailGeneratorThumbnailReadyWrapper*
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_construct (GType object_type)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper* self = NULL;
	self = (PantheonShellThumbnailGeneratorThumbnailReadyWrapper*) g_type_create_instance (object_type);
	return self;
}

PantheonShellThumbnailGeneratorThumbnailReadyWrapper*
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_new (void)
{
	return pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_construct (PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER);
}

PantheonShellThumbnailGeneratorThumbnailReady
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_cb (PantheonShellThumbnailGeneratorThumbnailReadyWrapper* self,
                                                                   gpointer* result_target)
{
	PantheonShellThumbnailGeneratorThumbnailReady result;
	PantheonShellThumbnailGeneratorThumbnailReady _tmp0_;
	gpointer _tmp0__target;
	PantheonShellThumbnailGeneratorThumbnailReady _tmp1_;
	gpointer _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cb;
	_tmp0__target = self->priv->_cb_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}

void
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_set_cb (PantheonShellThumbnailGeneratorThumbnailReadyWrapper* self,
                                                                   PantheonShellThumbnailGeneratorThumbnailReady value,
                                                                   gpointer value_target)
{
	g_return_if_fail (self != NULL);
	self->priv->_cb = value;
	self->priv->_cb_target = value_target;
}

static void
pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref (value->data[0].v_pointer);
	}
}

static void
pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_copy_value (const GValue* src_value,
                                                                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_collect_value (GValue* value,
                                                                                guint n_collect_values,
                                                                                GTypeCValue* collect_values,
                                                                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PantheonShellThumbnailGeneratorThumbnailReadyWrapper * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_lcopy_value (const GValue* value,
                                                                              guint n_collect_values,
                                                                              GTypeCValue* collect_values,
                                                                              guint collect_flags)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
pantheon_shell_thumbnail_generator_param_spec_thumbnail_ready_wrapper (const gchar* name,
                                                                       const gchar* nick,
                                                                       const gchar* blurb,
                                                                       GType object_type,
                                                                       GParamFlags flags)
{
	PantheonShellThumbnailGeneratorParamSpecThumbnailReadyWrapper* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
pantheon_shell_thumbnail_generator_value_get_thumbnail_ready_wrapper (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER), NULL);
	return value->data[0].v_pointer;
}

void
pantheon_shell_thumbnail_generator_value_set_thumbnail_ready_wrapper (GValue* value,
                                                                      gpointer v_object)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref (old);
	}
}

void
pantheon_shell_thumbnail_generator_value_take_thumbnail_ready_wrapper (GValue* value,
                                                                       gpointer v_object)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref (old);
	}
}

static void
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_class_init (PantheonShellThumbnailGeneratorThumbnailReadyWrapperClass * klass,
                                                                       gpointer klass_data)
{
	pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_parent_class = g_type_class_peek_parent (klass);
	((PantheonShellThumbnailGeneratorThumbnailReadyWrapperClass *) klass)->finalize = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_finalize;
	g_type_class_adjust_private_offset (klass, &PantheonShellThumbnailGeneratorThumbnailReadyWrapper_private_offset);
}

static void
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_instance_init (PantheonShellThumbnailGeneratorThumbnailReadyWrapper * self,
                                                                          gpointer klass)
{
	self->priv = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_instance_private (self);
	self->ref_count = 1;
}

static void
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_finalize (PantheonShellThumbnailGeneratorThumbnailReadyWrapper * obj)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER, PantheonShellThumbnailGeneratorThumbnailReadyWrapper);
	g_signal_handlers_destroy (self);
}

static GType
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_init, pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_free_value, pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_copy_value, pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_peek_pointer, "p", pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_collect_value, "p", pantheon_shell_thumbnail_generator_value_thumbnail_ready_wrapper_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellThumbnailGeneratorThumbnailReadyWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellThumbnailGeneratorThumbnailReadyWrapper), 0, (GInstanceInitFunc) pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id;
	pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PantheonShellThumbnailGeneratorThumbnailReadyWrapper", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper_private_offset = g_type_add_instance_private (pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id, sizeof (PantheonShellThumbnailGeneratorThumbnailReadyWrapperPrivate));
	return pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id;
}

GType
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_type (void)
{
	static volatile gsize pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id__once)) {
		GType pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id;
		pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id = pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_get_type_once ();
		g_once_init_leave (&pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id__once, pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id);
	}
	return pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_type_id__once;
}

gpointer
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_ref (gpointer instance)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref (gpointer instance)
{
	PantheonShellThumbnailGeneratorThumbnailReadyWrapper * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PANTHEON_SHELL_THUMBNAIL_GENERATOR_THUMBNAIL_READY_WRAPPER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
pantheon_shell_value_thumbnail_generator_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
pantheon_shell_value_thumbnail_generator_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		pantheon_shell_thumbnail_generator_unref (value->data[0].v_pointer);
	}
}

static void
pantheon_shell_value_thumbnail_generator_copy_value (const GValue* src_value,
                                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = pantheon_shell_thumbnail_generator_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
pantheon_shell_value_thumbnail_generator_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
pantheon_shell_value_thumbnail_generator_collect_value (GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PantheonShellThumbnailGenerator * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = pantheon_shell_thumbnail_generator_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
pantheon_shell_value_thumbnail_generator_lcopy_value (const GValue* value,
                                                      guint n_collect_values,
                                                      GTypeCValue* collect_values,
                                                      guint collect_flags)
{
	PantheonShellThumbnailGenerator ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = pantheon_shell_thumbnail_generator_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
pantheon_shell_param_spec_thumbnail_generator (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags)
{
	PantheonShellParamSpecThumbnailGenerator* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
pantheon_shell_value_get_thumbnail_generator (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR), NULL);
	return value->data[0].v_pointer;
}

void
pantheon_shell_value_set_thumbnail_generator (GValue* value,
                                              gpointer v_object)
{
	PantheonShellThumbnailGenerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		pantheon_shell_thumbnail_generator_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pantheon_shell_thumbnail_generator_unref (old);
	}
}

void
pantheon_shell_value_take_thumbnail_generator (GValue* value,
                                               gpointer v_object)
{
	PantheonShellThumbnailGenerator * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		pantheon_shell_thumbnail_generator_unref (old);
	}
}

static void
pantheon_shell_thumbnail_generator_class_init (PantheonShellThumbnailGeneratorClass * klass,
                                               gpointer klass_data)
{
	pantheon_shell_thumbnail_generator_parent_class = g_type_class_peek_parent (klass);
	((PantheonShellThumbnailGeneratorClass *) klass)->finalize = pantheon_shell_thumbnail_generator_finalize;
	g_type_class_adjust_private_offset (klass, &PantheonShellThumbnailGenerator_private_offset);
}

static void
pantheon_shell_thumbnail_generator_instance_init (PantheonShellThumbnailGenerator * self,
                                                  gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	self->priv = pantheon_shell_thumbnail_generator_get_instance_private (self);
	self->priv->thumbnailer = NULL;
	_tmp0_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, PANTHEON_SHELL_THUMBNAIL_GENERATOR_TYPE_THUMBNAIL_READY_WRAPPER, (GBoxedCopyFunc) pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_ref, (GDestroyNotify) pantheon_shell_thumbnail_generator_thumbnail_ready_wrapper_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->queued_delegates = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_UINT, NULL, NULL, NULL, NULL, NULL);
	self->priv->handles = _tmp1_;
	self->ref_count = 1;
}

static void
pantheon_shell_thumbnail_generator_finalize (PantheonShellThumbnailGenerator * obj)
{
	PantheonShellThumbnailGenerator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PANTHEON_SHELL_TYPE_THUMBNAIL_GENERATOR, PantheonShellThumbnailGenerator);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->thumbnailer);
	_g_object_unref0 (self->priv->queued_delegates);
	_g_object_unref0 (self->priv->handles);
}

static GType
pantheon_shell_thumbnail_generator_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { pantheon_shell_value_thumbnail_generator_init, pantheon_shell_value_thumbnail_generator_free_value, pantheon_shell_value_thumbnail_generator_copy_value, pantheon_shell_value_thumbnail_generator_peek_pointer, "p", pantheon_shell_value_thumbnail_generator_collect_value, "p", pantheon_shell_value_thumbnail_generator_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PantheonShellThumbnailGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pantheon_shell_thumbnail_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PantheonShellThumbnailGenerator), 0, (GInstanceInitFunc) pantheon_shell_thumbnail_generator_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType pantheon_shell_thumbnail_generator_type_id;
	pantheon_shell_thumbnail_generator_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PantheonShellThumbnailGenerator", &g_define_type_info, &g_define_type_fundamental_info, 0);
	PantheonShellThumbnailGenerator_private_offset = g_type_add_instance_private (pantheon_shell_thumbnail_generator_type_id, sizeof (PantheonShellThumbnailGeneratorPrivate));
	return pantheon_shell_thumbnail_generator_type_id;
}

GType
pantheon_shell_thumbnail_generator_get_type (void)
{
	static volatile gsize pantheon_shell_thumbnail_generator_type_id__once = 0;
	if (g_once_init_enter (&pantheon_shell_thumbnail_generator_type_id__once)) {
		GType pantheon_shell_thumbnail_generator_type_id;
		pantheon_shell_thumbnail_generator_type_id = pantheon_shell_thumbnail_generator_get_type_once ();
		g_once_init_leave (&pantheon_shell_thumbnail_generator_type_id__once, pantheon_shell_thumbnail_generator_type_id);
	}
	return pantheon_shell_thumbnail_generator_type_id__once;
}

gpointer
pantheon_shell_thumbnail_generator_ref (gpointer instance)
{
	PantheonShellThumbnailGenerator * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
pantheon_shell_thumbnail_generator_unref (gpointer instance)
{
	PantheonShellThumbnailGenerator * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PANTHEON_SHELL_THUMBNAIL_GENERATOR_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

