/* LibraryFiles.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from LibraryFiles.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "metadata.h"
#include <gee.h>
#include <glib-object.h>
#include <stdio.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;

#define TYPE_VIDEO_READER (video_reader_get_type ())
#define VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_READER, VideoReader))
#define VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_READER, VideoReaderClass))
#define IS_VIDEO_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_READER))
#define IS_VIDEO_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_READER))
#define VIDEO_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_READER, VideoReaderClass))

typedef struct _VideoReader VideoReader;
typedef struct _VideoReaderClass VideoReaderClass;

#define TYPE_VIDEO_METADATA (video_metadata_get_type ())
#define VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_METADATA, VideoMetadata))
#define VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_METADATA, VideoMetadataClass))
#define IS_VIDEO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_METADATA))
#define IS_VIDEO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_METADATA))
#define VIDEO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_METADATA, VideoMetadataClass))

typedef struct _VideoMetadata VideoMetadata;
typedef struct _VideoMetadataClass VideoMetadataClass;
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _video_reader_unref0(var) ((var == NULL) ? NULL : (var = (video_reader_unref (var), NULL)))

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

VALA_EXTERN gboolean library_files_use_fallback_copy_func;
gboolean library_files_use_fallback_copy_func = FALSE;

VALA_EXTERN void library_files_select_copy_function (void);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
VALA_EXTERN GFile* library_files_generate_unique_file (const gchar* basename,
                                           MediaMetadata* metadata,
                                           GDateTime* ts,
                                           gboolean* collision,
                                           GError** error);
VALA_EXTERN GFile* app_dirs_get_baked_import_dir (GDateTime* tm);
VALA_EXTERN gchar* library_files_convert_basename (const gchar* basename);
VALA_EXTERN GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GeeCollection* used,
                             GError** error);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gboolean configuration_facade_get_use_lowercase_filenames (ConfigurationFacade* self);
VALA_EXTERN GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                gpointer progress_callback_target,
                                gboolean blacklist,
                                GError** error);
VALA_EXTERN GDateTime* query_file_modified (GFile* file,
                                GError** error);
VALA_EXTERN gboolean video_reader_is_supported_video_file (GFile* file);
VALA_EXTERN gpointer video_reader_ref (gpointer instance);
VALA_EXTERN void video_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_video_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void value_set_video_reader (GValue* value,
                             gpointer v_object);
VALA_EXTERN void value_take_video_reader (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer value_get_video_reader (const GValue* value);
VALA_EXTERN GType video_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoReader, video_reader_unref)
VALA_EXTERN VideoReader* video_reader_new (GFile* file);
VALA_EXTERN VideoReader* video_reader_construct (GType object_type,
                                     GFile* file);
VALA_EXTERN GType video_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMetadata, media_metadata_unref)
VALA_EXTERN VideoMetadata* video_reader_read_metadata (VideoReader* self,
                                           GError** error);
VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileFormat photo_file_format_get_by_file_extension (GFile* file);
VALA_EXTERN PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self,
                                                  const gchar* filepath);
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self,
                                                GError** error);
VALA_EXTERN void library_monitor_blacklist_file (GFile* file,
                                     const gchar* reason);
VALA_EXTERN void library_files_fallback_copy (GFile* src,
                                  GFile* dst,
                                  GFileProgressCallback callback,
                                  gpointer callback_target,
                                  GError** error);
VALA_EXTERN void library_monitor_unblacklist_file (GFile* file);
VALA_EXTERN gchar* md5_file (GFile* file,
                 GError** error);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

void
library_files_select_copy_function (void)
{
	GFile* import_dir = NULL;
	GFile* _tmp0_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = app_dirs_get_import_dir ();
	import_dir = _tmp0_;
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = g_file_query_filesystem_info (import_dir, "filesystem::type", NULL, &_inner_error0_);
		info = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = g_file_info_get_attribute_as_string (info, "filesystem::type");
		_tmp3_ = _tmp2_;
		library_files_use_fallback_copy_func = g_strcmp0 (_tmp3_, "nfs") == 0;
		_g_free0 (_tmp3_);
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = _error_;
		_tmp5_ = _tmp4_->message;
		g_critical ("LibraryFiles.vala:18: Failed to query fs type: %s", _tmp5_);
		library_files_use_fallback_copy_func = TRUE;
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (import_dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = bool_to_string (library_files_use_fallback_copy_func);
	_tmp7_ = _tmp6_;
	g_info ("LibraryFiles.vala:22: Using fallback copy: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_object_unref0 (import_dir);
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

GFile*
library_files_generate_unique_file (const gchar* basename,
                                    MediaMetadata* metadata,
                                    GDateTime* ts,
                                    gboolean* collision,
                                    GError** error)
{
	gboolean _vala_collision = FALSE;
	GDateTime* timestamp = NULL;
	GDateTime* _tmp0_;
	GFile* dir = NULL;
	GDateTime* _tmp7_;
	GFile* _tmp8_;
	gchar* newbasename = NULL;
	gchar* _tmp13_;
	GFile* _tmp14_ = NULL;
	GFile* _tmp15_;
	gboolean _tmp16_ = FALSE;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (basename != NULL, NULL);
	g_return_val_if_fail ((metadata == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (metadata, TYPE_MEDIA_METADATA), NULL);
	g_return_val_if_fail (ts != NULL, NULL);
	_tmp0_ = _g_date_time_ref0 (ts);
	timestamp = _tmp0_;
	if (metadata != NULL) {
		MetadataDateTime* date_time = NULL;
		MetadataDateTime* _tmp1_;
		MetadataDateTime* _tmp2_;
		_tmp1_ = media_metadata_get_creation_date_time (metadata);
		date_time = _tmp1_;
		_tmp2_ = date_time;
		if (_tmp2_ != NULL) {
			MetadataDateTime* _tmp3_;
			GDateTime* _tmp4_;
			_tmp3_ = date_time;
			_tmp4_ = metadata_date_time_get_timestamp (_tmp3_);
			_g_date_time_unref0 (timestamp);
			timestamp = _tmp4_;
		} else {
			GDateTime* _tmp5_;
			_tmp5_ = timestamp;
			if (_tmp5_ == NULL) {
				GDateTime* _tmp6_;
				_tmp6_ = g_date_time_new_now_utc ();
				_g_date_time_unref0 (timestamp);
				timestamp = _tmp6_;
			}
		}
		_metadata_date_time_unref0 (date_time);
	}
	_tmp7_ = timestamp;
	_tmp8_ = app_dirs_get_baked_import_dir (_tmp7_);
	dir = _tmp8_;
	{
		GFile* _tmp9_;
		_tmp9_ = dir;
		g_file_make_directory_with_parents (_tmp9_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = err;
		if (!g_error_matches (_tmp10_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
			GError* _tmp11_;
			GError* _tmp12_;
			_tmp11_ = err;
			_tmp12_ = _g_error_copy0 (_tmp11_);
			_inner_error0_ = _tmp12_;
			_g_error_free0 (err);
			goto __finally0;
		}
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dir);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	_tmp13_ = library_files_convert_basename (basename);
	newbasename = _tmp13_;
	_tmp15_ = dir;
	_tmp17_ = generate_unique_file (_tmp15_, newbasename, &_tmp16_, NULL, &_inner_error0_);
	_vala_collision = _tmp16_;
	_tmp14_ = _tmp17_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (newbasename);
		_g_object_unref0 (dir);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	_tmp18_ = _tmp14_;
	_tmp14_ = NULL;
	result = _tmp18_;
	_g_object_unref0 (_tmp14_);
	_g_free0 (newbasename);
	_g_object_unref0 (dir);
	_g_date_time_unref0 (timestamp);
	if (collision) {
		*collision = _vala_collision;
	}
	return result;
}

gchar*
library_files_convert_basename (const gchar* basename)
{
	ConfigFacade* _tmp0_;
	ConfigFacade* _tmp1_;
	gboolean _tmp2_;
	gchar* result;
	g_return_val_if_fail (basename != NULL, NULL);
	_tmp0_ = config_facade_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = configuration_facade_get_use_lowercase_filenames (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		gchar* _tmp3_;
		_tmp3_ = g_utf8_strdown (basename, (gssize) -1);
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup (basename);
		result = _tmp4_;
		return result;
	}
}

GFile*
library_files_duplicate (GFile* src,
                         GFileProgressCallback progress_callback,
                         gpointer progress_callback_target,
                         gboolean blacklist,
                         GError** error)
{
	GDateTime* timestamp = NULL;
	MediaMetadata* metadata = NULL;
	gboolean collision = FALSE;
	GFile* dest = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_;
	MediaMetadata* _tmp22_;
	GDateTime* _tmp23_;
	gboolean _tmp24_ = FALSE;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (src, g_file_get_type ()), NULL);
	timestamp = NULL;
	{
		GDateTime* _tmp0_ = NULL;
		GDateTime* _tmp1_;
		GDateTime* _tmp2_;
		_tmp1_ = query_file_modified (src, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_date_time_unref0 (timestamp);
		timestamp = _tmp2_;
		_g_date_time_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = g_file_get_path (src);
		_tmp4_ = _tmp3_;
		_tmp5_ = err;
		_tmp6_ = _tmp5_->message;
		g_critical ("LibraryFiles.vala:78: Unable to access file modification for %s: %s", _tmp4_, _tmp6_);
		_g_free0 (_tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	metadata = NULL;
	if (video_reader_is_supported_video_file (src)) {
		VideoReader* reader = NULL;
		VideoReader* _tmp7_;
		_tmp7_ = video_reader_new (src);
		reader = _tmp7_;
		{
			VideoMetadata* _tmp8_ = NULL;
			VideoReader* _tmp9_;
			VideoMetadata* _tmp10_;
			VideoMetadata* _tmp11_;
			_tmp9_ = reader;
			_tmp10_ = video_reader_read_metadata (_tmp9_, &_inner_error0_);
			_tmp8_ = _tmp10_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp11_ = _tmp8_;
			_tmp8_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_MEDIA_METADATA, MediaMetadata);
			_media_metadata_unref0 (_tmp8_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_video_reader_unref0 (reader);
			_media_metadata_unref0 (metadata);
			_g_date_time_unref0 (timestamp);
			return NULL;
		}
		_video_reader_unref0 (reader);
	} else {
		PhotoFileReader* reader = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		PhotoFileReader* _tmp14_;
		PhotoFileReader* _tmp15_;
		_tmp12_ = g_file_get_path (src);
		_tmp13_ = _tmp12_;
		_tmp14_ = photo_file_format_create_reader (photo_file_format_get_by_file_extension (src), _tmp13_);
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		reader = _tmp15_;
		{
			PhotoMetadata* _tmp16_ = NULL;
			PhotoFileReader* _tmp17_;
			PhotoMetadata* _tmp18_;
			PhotoMetadata* _tmp19_;
			_tmp17_ = reader;
			_tmp18_ = photo_file_reader_read_metadata (_tmp17_, &_inner_error0_);
			_tmp16_ = _tmp18_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp19_ = _tmp16_;
			_tmp16_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_MEDIA_METADATA, MediaMetadata);
			_media_metadata_unref0 (_tmp16_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (reader);
			_media_metadata_unref0 (metadata);
			_g_date_time_unref0 (timestamp);
			return NULL;
		}
		_photo_file_adapter_unref0 (reader);
	}
	_tmp20_ = g_file_get_basename (src);
	_tmp21_ = _tmp20_;
	_tmp22_ = metadata;
	_tmp23_ = timestamp;
	_tmp25_ = library_files_generate_unique_file (_tmp21_, _tmp22_, _tmp23_, &_tmp24_, &_inner_error0_);
	collision = _tmp24_;
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp21_);
	dest = _tmp26_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	_tmp27_ = dest;
	if (_tmp27_ == NULL) {
		GError* _tmp28_;
		_tmp28_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Unable to generate unique pathname for destination");
		_inner_error0_ = _tmp28_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_media_metadata_unref0 (metadata);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	if (blacklist) {
		GFile* _tmp29_;
		_tmp29_ = dest;
		library_monitor_blacklist_file (_tmp29_, "LibraryFiles.duplicate");
	}
	{
		if (library_files_use_fallback_copy_func) {
			GFile* _tmp30_;
			_tmp30_ = dest;
			library_files_fallback_copy (src, _tmp30_, progress_callback, progress_callback_target, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
		} else {
			GFile* _tmp31_;
			_tmp31_ = dest;
			g_file_copy (src, _tmp31_, G_FILE_COPY_ALL_METADATA | G_FILE_COPY_OVERWRITE, NULL, progress_callback, progress_callback_target, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		if (blacklist) {
			GFile* _tmp32_;
			_tmp32_ = dest;
			library_monitor_unblacklist_file (_tmp32_);
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* err = NULL;
		gchar* _tmp33_;
		gchar* _tmp34_;
		GError* _tmp35_;
		const gchar* _tmp36_;
		gboolean _tmp37_ = FALSE;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = g_file_get_path (src);
		_tmp34_ = _tmp33_;
		_tmp35_ = err;
		_tmp36_ = _tmp35_->message;
		g_message ("LibraryFiles.vala:116: There was a problem copying %s: %s", _tmp34_, _tmp36_);
		_g_free0 (_tmp34_);
		if (blacklist) {
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			gchar* _tmp40_ = NULL;
			GFile* _tmp41_;
			gchar* _tmp42_;
			_tmp39_ = md5_file (src, &_inner_error0_);
			_tmp38_ = _tmp39_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				goto __finally3;
			}
			_tmp41_ = dest;
			_tmp42_ = md5_file (_tmp41_, &_inner_error0_);
			_tmp40_ = _tmp42_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (_tmp38_);
				_g_error_free0 (err);
				goto __finally3;
			}
			_tmp37_ = g_strcmp0 (_tmp38_, _tmp40_) != 0;
			_g_free0 (_tmp40_);
			_g_free0 (_tmp38_);
		} else {
			_tmp37_ = FALSE;
		}
		if (_tmp37_) {
			GFile* _tmp43_;
			_tmp43_ = dest;
			library_monitor_unblacklist_file (_tmp43_);
		}
		_g_error_free0 (err);
	}
	__finally3:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_media_metadata_unref0 (metadata);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	{
		GFileInfo* info = NULL;
		GFile* _tmp44_;
		GFileInfo* _tmp45_;
		guint32 mode = 0U;
		GFileInfo* _tmp46_;
		gboolean _tmp47_ = FALSE;
		GFile* _tmp48_;
		_tmp44_ = dest;
		_tmp45_ = g_file_query_info (_tmp44_, G_FILE_ATTRIBUTE_UNIX_MODE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp45_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp46_ = info;
		mode = g_file_info_get_attribute_uint32 (_tmp46_, G_FILE_ATTRIBUTE_UNIX_MODE) | 0600;
		_tmp48_ = dest;
		_tmp47_ = g_file_set_attribute_uint32 (_tmp48_, G_FILE_ATTRIBUTE_UNIX_MODE, mode, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (info);
			goto __catch4_g_error;
		}
		if (!_tmp47_) {
			g_warning ("LibraryFiles.vala:126: Could not make file writable");
		}
		_g_object_unref0 (info);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* err = NULL;
		GError* _tmp49_;
		const gchar* _tmp50_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp49_ = err;
		_tmp50_ = _tmp49_->message;
		g_warning ("LibraryFiles.vala:129: Could not make file writable: %s", _tmp50_);
		_g_error_free0 (err);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest);
		_media_metadata_unref0 (metadata);
		_g_date_time_unref0 (timestamp);
		return NULL;
	}
	result = dest;
	_media_metadata_unref0 (metadata);
	_g_date_time_unref0 (timestamp);
	return result;
}

void
library_files_fallback_copy (GFile* src,
                             GFile* dst,
                             GFileProgressCallback callback,
                             gpointer callback_target,
                             GError** error)
{
	gboolean _tmp0_ = FALSE;
	FILE* f = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	FILE* _tmp3_;
	FILE* _tmp4_;
	FILE* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail ((src == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (src, g_file_get_type ()));
	g_return_if_fail ((dst == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (dst, g_file_get_type ()));
	if (src == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = dst == NULL;
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = g_file_get_path (src);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_fopen (_tmp2_, "rb");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	f = _tmp4_;
	_tmp5_ = f;
	if (_tmp5_ != NULL) {
		FILE* _tmp6_;
		glong size = 0L;
		FILE* _tmp7_;
		FILE* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		FILE* g = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		FILE* _tmp15_;
		FILE* _tmp16_;
		FILE* _tmp17_;
		_tmp6_ = f;
		fseek (_tmp6_, (glong) 0, SEEK_END);
		_tmp7_ = f;
		size = ftell (_tmp7_);
		_tmp8_ = f;
		fseek (_tmp8_, (glong) 0, SEEK_SET);
		_tmp9_ = g_file_get_path (src);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_file_get_path (dst);
		_tmp12_ = _tmp11_;
		g_debug ("LibraryFiles.vala:145: Copying %s to %s, size is %ld", _tmp10_, _tmp12_, size);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		_tmp13_ = g_file_get_path (dst);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_fopen (_tmp14_, "wb");
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		g = _tmp16_;
		_tmp17_ = g;
		if (_tmp17_ != NULL) {
			guint8 buffer[4096] = {0};
			gsize written = 0UL;
			written = (gsize) 0;
			while (TRUE) {
				FILE* _tmp18_;
				gsize len = 0UL;
				FILE* _tmp19_;
				_tmp18_ = f;
				if (!(!feof (_tmp18_))) {
					break;
				}
				_tmp19_ = f;
				len = fread (buffer, (gsize) 1, (gint) 4096, _tmp19_);
				if (len > ((gsize) 0)) {
					gsize out_len = 0UL;
					FILE* _tmp20_;
					_tmp20_ = g;
					out_len = fwrite (buffer + 0, (gsize) 1, (gint) (((gint) len) - 0), _tmp20_);
					if (out_len < ((gsize) 0)) {
						gchar* _tmp21_;
						gchar* _tmp22_;
						gchar* _tmp23_;
						gchar* _tmp24_;
						GError* _tmp25_;
						GError* _tmp26_;
						_tmp21_ = g_file_get_path (dst);
						_tmp22_ = _tmp21_;
						g_critical ("LibraryFiles.vala:157: Failed to write to file %s: %m", _tmp22_);
						_g_free0 (_tmp22_);
						_tmp23_ = g_file_get_path (dst);
						_tmp24_ = _tmp23_;
						_tmp25_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to write to %s", _tmp24_);
						_tmp26_ = _tmp25_;
						_g_free0 (_tmp24_);
						_inner_error0_ = _tmp26_;
						g_propagate_error (error, _inner_error0_);
						_fclose0 (g);
						_fclose0 (f);
						return;
					}
					written += len;
					if (callback != NULL) {
						callback ((gint64) written, (gint64) size, callback_target);
					}
				} else {
					if (len < ((gsize) 0)) {
						gchar* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						gchar* _tmp30_;
						GError* _tmp31_;
						GError* _tmp32_;
						_tmp27_ = g_file_get_path (src);
						_tmp28_ = _tmp27_;
						g_critical ("LibraryFiles.vala:165: Failed to read from file %s: %m", _tmp28_);
						_g_free0 (_tmp28_);
						_tmp29_ = g_file_get_path (src);
						_tmp30_ = _tmp29_;
						_tmp31_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to read from %s", _tmp30_);
						_tmp32_ = _tmp31_;
						_g_free0 (_tmp30_);
						_inner_error0_ = _tmp32_;
						g_propagate_error (error, _inner_error0_);
						_fclose0 (g);
						_fclose0 (f);
						return;
					}
				}
			}
		} else {
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			GError* _tmp37_;
			GError* _tmp38_;
			_tmp33_ = g_file_get_path (dst);
			_tmp34_ = _tmp33_;
			g_critical ("LibraryFiles.vala:170: Failed to open %s: %m", _tmp34_);
			_g_free0 (_tmp34_);
			_tmp35_ = g_file_get_path (dst);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open %s", _tmp36_);
			_tmp38_ = _tmp37_;
			_g_free0 (_tmp36_);
			_inner_error0_ = _tmp38_;
			g_propagate_error (error, _inner_error0_);
			_fclose0 (g);
			_fclose0 (f);
			return;
		}
		_fclose0 (g);
	} else {
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GError* _tmp43_;
		GError* _tmp44_;
		_tmp39_ = g_file_get_path (src);
		_tmp40_ = _tmp39_;
		g_critical ("LibraryFiles.vala:174: Failed to open %s: %m", _tmp40_);
		_g_free0 (_tmp40_);
		_tmp41_ = g_file_get_path (src);
		_tmp42_ = _tmp41_;
		_tmp43_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "Failed to open %s", _tmp42_);
		_tmp44_ = _tmp43_;
		_g_free0 (_tmp42_);
		_inner_error0_ = _tmp44_;
		g_propagate_error (error, _inner_error0_);
		_fclose0 (f);
		return;
	}
	_fclose0 (f);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

