/* Photo.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Photo.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Specifies how pixel data is fetched from the backing file on disk.  MASTER is the original*/
/* backing photo of any supported photo file format; SOURCE is either the master or the editable*/
/* file, that is, the appropriate reference file for user display; BASELINE is an appropriate*/
/* file with the proviso that it may be a suitable substitute for the master and/or the editable.*/
/* UNMODIFIED represents the photo with no edits, i.e. the head of the pipeline.*/
/**/
/* In general, callers want to use the BASELINE unless requirements are specific.*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "metadata.h"
#include <float.h>
#include <math.h>
#include "shotwell-graphics-processor.h"
#include <glib/gstdio.h>
#include <gdk/gdk.h>
#include <config.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>

#define PHOTO_TYPENAME "thumb"
#define PHOTO_SCALING_FUDGE 64
#define PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC 10
#define PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT 1
#define PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT 3
#define PHOTO_MIN_EMBEDDED_SIZE 1024
#define DATA_OBJECT_INVALID_OBJECT_ID ((gint64) -1)
#define BACKING_PHOTO_ID_INVALID ((gint64) -1)
#define UTIL_FILE_ATTRIBUTES "standard::*,time::*,id::file,id::filesystem,etag::value"
#define DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES UTIL_FILE_ATTRIBUTES
#define PHOTO_ID_INVALID ((gint64) -1)
#define EVENT_ID_INVALID ((gint64) -1)
#define RESOURCES_APP_TITLE "Shotwell"
#define RESOURCES_APP_VERSION _VERSION
#define LIBRARY_PHOTO_FLAG_HIDDEN ((guint64) 0x0000000000000001)
#define LIBRARY_PHOTO_FLAG_FAVORITE ((guint64) 0x0000000000000002)
#define LIBRARY_PHOTO_FLAG_TRASH ((guint64) 0x0000000000000004)
#define LIBRARY_PHOTO_FLAG_OFFLINE ((guint64) 0x0000000000000008)
#define LIBRARY_PHOTO_FLAG_FLAGGED ((guint64) 0x0000000000000010)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	BACKING_FETCH_MODE_SOURCE,
	BACKING_FETCH_MODE_BASELINE,
	BACKING_FETCH_MODE_MASTER,
	BACKING_FETCH_MODE_UNMODIFIED
} BackingFetchMode;

#define TYPE_BACKING_FETCH_MODE (backing_fetch_mode_get_type ())

#define TYPE_PHOTO_IMPORT_PARAMS (photo_import_params_get_type ())
#define PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams))
#define PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))
#define IS_PHOTO_IMPORT_PARAMS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_IMPORT_PARAMS))
#define IS_PHOTO_IMPORT_PARAMS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_IMPORT_PARAMS))
#define PHOTO_IMPORT_PARAMS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParamsClass))

typedef struct _PhotoImportParams PhotoImportParams;
typedef struct _PhotoImportParamsClass PhotoImportParamsClass;
typedef struct _PhotoImportParamsPrivate PhotoImportParamsPrivate;

#define TYPE_IMPORT_ID (import_id_get_type ())
typedef struct _ImportID ImportID;
typedef enum  {
	PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL = 0x00000000,
	PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5 = 0x00000001
} PhotoFileSnifferOptions;

#define PHOTO_FILE_SNIFFER_TYPE_OPTIONS (photo_file_sniffer_options_get_type ())

#define TYPE_THUMBNAILS (thumbnails_get_type ())
#define THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAILS, Thumbnails))
#define THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAILS, ThumbnailsClass))
#define IS_THUMBNAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAILS))
#define IS_THUMBNAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAILS))
#define THUMBNAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAILS, ThumbnailsClass))

typedef struct _Thumbnails Thumbnails;
typedef struct _ThumbnailsClass ThumbnailsClass;

#define TYPE_PHOTO_ROW (photo_row_get_type ())
#define PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_ROW, PhotoRow))
#define PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_ROW, PhotoRowClass))
#define IS_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_ROW))
#define IS_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_ROW))
#define PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_ROW, PhotoRowClass))

typedef struct _PhotoRow PhotoRow;
typedef struct _PhotoRowClass PhotoRowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
#define _photo_row_unref0(var) ((var == NULL) ? NULL : (var = (photo_row_unref (var), NULL)))
typedef struct _ParamSpecPhotoImportParams ParamSpecPhotoImportParams;

#define TYPE_PHOTO_TRANSFORMATION_STATE (photo_transformation_state_get_type ())
#define PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState))
#define PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))
#define IS_PHOTO_TRANSFORMATION_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TRANSFORMATION_STATE))
#define IS_PHOTO_TRANSFORMATION_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TRANSFORMATION_STATE))
#define PHOTO_TRANSFORMATION_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationStateClass))

typedef struct _PhotoTransformationState PhotoTransformationState;
typedef struct _PhotoTransformationStateClass PhotoTransformationStateClass;
typedef struct _PhotoTransformationStatePrivate PhotoTransformationStatePrivate;
enum  {
	PHOTO_TRANSFORMATION_STATE_0_PROPERTY,
	PHOTO_TRANSFORMATION_STATE_NUM_PROPERTIES
};
static GParamSpec* photo_transformation_state_properties[PHOTO_TRANSFORMATION_STATE_NUM_PROPERTIES];
enum  {
	PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL,
	PHOTO_TRANSFORMATION_STATE_NUM_SIGNALS
};
static guint photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_NUM_SIGNALS] = {0};
typedef enum  {
	RATING_REJECTED = -1,
	RATING_UNRATED = 0,
	RATING_ONE = 1,
	RATING_TWO = 2,
	RATING_THREE = 3,
	RATING_FOUR = 4,
	RATING_FIVE = 5
} Rating;

#define TYPE_RATING (rating_get_type ())

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;
typedef struct _DataObjectPrivate DataObjectPrivate;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;
typedef struct _DataSourcePrivate DataSourcePrivate;

#define TYPE_SOURCE_HOLDING_TANK (source_holding_tank_get_type ())
#define SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank))
#define SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))
#define IS_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_HOLDING_TANK))
#define IS_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_HOLDING_TANK))
#define SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTankClass))

typedef struct _SourceHoldingTank SourceHoldingTank;
typedef struct _SourceHoldingTankClass SourceHoldingTankClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_SOURCE_SNAPSHOT (source_snapshot_get_type ())
#define SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshot))
#define SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))
#define IS_SOURCE_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_SNAPSHOT))
#define IS_SOURCE_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_SNAPSHOT))
#define SOURCE_SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_SNAPSHOT, SourceSnapshotClass))

typedef struct _SourceSnapshot SourceSnapshot;
typedef struct _SourceSnapshotClass SourceSnapshotClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;
typedef struct _ThumbnailSourcePrivate ThumbnailSourcePrivate;
typedef enum  {
	PHOTO_FILE_FORMAT_JFIF,
	PHOTO_FILE_FORMAT_RAW,
	PHOTO_FILE_FORMAT_PNG,
	PHOTO_FILE_FORMAT_TIFF,
	PHOTO_FILE_FORMAT_BMP,
	PHOTO_FILE_FORMAT_GIF,
	PHOTO_FILE_FORMAT_WEBP,
	PHOTO_FILE_FORMAT_AVIF,
	PHOTO_FILE_FORMAT_HEIF,
	PHOTO_FILE_FORMAT_JPEGXL,
	PHOTO_FILE_FORMAT_UNKNOWN
} PhotoFileFormat;

#define TYPE_PHOTO_FILE_FORMAT (photo_file_format_get_type ())

#define TYPE_INDEXABLE (indexable_get_type ())
#define INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INDEXABLE, Indexable))
#define IS_INDEXABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INDEXABLE))
#define INDEXABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_INDEXABLE, IndexableIface))

typedef struct _Indexable Indexable;
typedef struct _IndexableIface IndexableIface;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
typedef struct _MediaSourcePrivate MediaSourcePrivate;

#define TYPE_EVENT_ID (event_id_get_type ())
typedef struct _EventID EventID;

#define TYPE_BACKING_FILE_STATE (backing_file_state_get_type ())
#define BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_FILE_STATE, BackingFileState))
#define BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_FILE_STATE, BackingFileStateClass))
#define IS_BACKING_FILE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_FILE_STATE))
#define IS_BACKING_FILE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_FILE_STATE))
#define BACKING_FILE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_FILE_STATE, BackingFileStateClass))

typedef struct _BackingFileState BackingFileState;
typedef struct _BackingFileStateClass BackingFileStateClass;
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define TYPE_SCALING (scaling_get_type ())
typedef struct _Scaling Scaling;
typedef enum  {
	SCALE_CONSTRAINT_ORIGINAL,
	SCALE_CONSTRAINT_DIMENSIONS,
	SCALE_CONSTRAINT_WIDTH,
	SCALE_CONSTRAINT_HEIGHT,
	SCALE_CONSTRAINT_FILL_VIEWPORT
} ScaleConstraint;

#define TYPE_SCALE_CONSTRAINT (scale_constraint_get_type ())

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;
typedef struct _PhotoSourcePrivate PhotoSourcePrivate;

#define TYPE_PHOTO_METADATA (photo_metadata_get_type ())
#define PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_METADATA, PhotoMetadata))
#define PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_METADATA, PhotoMetadataClass))
#define IS_PHOTO_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_METADATA))
#define IS_PHOTO_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_METADATA))
#define PHOTO_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_METADATA, PhotoMetadataClass))

typedef struct _PhotoMetadata PhotoMetadata;
typedef struct _PhotoMetadataClass PhotoMetadataClass;

#define TYPE_DATEABLE (dateable_get_type ())
#define DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATEABLE, Dateable))
#define IS_DATEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATEABLE))
#define DATEABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_DATEABLE, DateableIface))

typedef struct _Dateable Dateable;
typedef struct _DateableIface DateableIface;

#define TYPE_POSITIONABLE (positionable_get_type ())
#define POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITIONABLE, Positionable))
#define IS_POSITIONABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITIONABLE))
#define POSITIONABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_POSITIONABLE, PositionableIface))

typedef struct _Positionable Positionable;
typedef struct _PositionableIface PositionableIface;

#define TYPE_GPS_COORDS (gps_coords_get_type ())
typedef struct _GpsCoords GpsCoords;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef struct _PhotoPrivate PhotoPrivate;
typedef enum  {
	ROTATION_CLOCKWISE,
	ROTATION_COUNTERCLOCKWISE,
	ROTATION_MIRROR,
	ROTATION_UPSIDE_DOWN
} Rotation;

#define TYPE_ROTATION (rotation_get_type ())

#define TYPE_BACKING_PHOTO_ROW (backing_photo_row_get_type ())
#define BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRow))
#define BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))
#define IS_BACKING_PHOTO_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_ROW))
#define IS_BACKING_PHOTO_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_ROW))
#define BACKING_PHOTO_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_ROW, BackingPhotoRowClass))

typedef struct _BackingPhotoRow BackingPhotoRow;
typedef struct _BackingPhotoRowClass BackingPhotoRowClass;

#define PHOTO_TYPE_BACKING_READERS (photo_backing_readers_get_type ())
#define PHOTO_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders))
#define PHOTO_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))
#define PHOTO_IS_BACKING_READERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_IS_BACKING_READERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_BACKING_READERS))
#define PHOTO_BACKING_READERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_BACKING_READERS, PhotoBackingReadersClass))

typedef struct _PhotoBackingReaders PhotoBackingReaders;
typedef struct _PhotoBackingReadersClass PhotoBackingReadersClass;

#define TYPE_ONE_SHOT_SCHEDULER (one_shot_scheduler_get_type ())
#define ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotScheduler))
#define ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))
#define IS_ONE_SHOT_SCHEDULER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ONE_SHOT_SCHEDULER))
#define IS_ONE_SHOT_SCHEDULER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ONE_SHOT_SCHEDULER))
#define ONE_SHOT_SCHEDULER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ONE_SHOT_SCHEDULER, OneShotSchedulerClass))

typedef struct _OneShotScheduler OneShotScheduler;
typedef struct _OneShotSchedulerClass OneShotSchedulerClass;
typedef enum  {
	RAW_DEVELOPER_SHOTWELL = 0,
	RAW_DEVELOPER_CAMERA,
	RAW_DEVELOPER_EMBEDDED
} RawDeveloper;

#define TYPE_RAW_DEVELOPER (raw_developer_get_type ())
enum  {
	PHOTO_0_PROPERTY,
	PHOTO_NUM_PROPERTIES
};
static GParamSpec* photo_properties[PHOTO_NUM_PROPERTIES];
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

#define PHOTO_TYPE_CACHED_PIXBUF (photo_cached_pixbuf_get_type ())
#define PHOTO_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbuf))
#define PHOTO_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))
#define PHOTO_IS_CACHED_PIXBUF(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_IS_CACHED_PIXBUF_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_CACHED_PIXBUF))
#define PHOTO_CACHED_PIXBUF_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbufClass))

typedef struct _PhotoCachedPixbuf PhotoCachedPixbuf;
typedef struct _PhotoCachedPixbufClass PhotoCachedPixbufClass;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _photo_backing_readers_unref0(var) ((var == NULL) ? NULL : (var = (photo_backing_readers_unref (var), NULL)))
#define _pixel_transformer_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformer_unref (var), NULL)))
#define _pixel_transformation_bundle_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_bundle_unref (var), NULL)))
#define _one_shot_scheduler_unref0(var) ((var == NULL) ? NULL : (var = (one_shot_scheduler_unref (var), NULL)))
typedef struct _PhotoRowPrivate PhotoRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())

#define TYPE_BACKING_PHOTO_ID (backing_photo_id_get_type ())
typedef struct _BackingPhotoID BackingPhotoID;
typedef struct _BackingPhotoRowPrivate BackingPhotoRowPrivate;

#define TYPE_PHOTO_FILE_ADAPTER (photo_file_adapter_get_type ())
#define PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter))
#define PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))
#define IS_PHOTO_FILE_ADAPTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_ADAPTER))
#define IS_PHOTO_FILE_ADAPTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_ADAPTER))
#define PHOTO_FILE_ADAPTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapterClass))

typedef struct _PhotoFileAdapter PhotoFileAdapter;
typedef struct _PhotoFileAdapterClass PhotoFileAdapterClass;

#define TYPE_PHOTO_FILE_READER (photo_file_reader_get_type ())
#define PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReader))
#define PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))
#define IS_PHOTO_FILE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_READER))
#define IS_PHOTO_FILE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_READER))
#define PHOTO_FILE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_READER, PhotoFileReaderClass))

typedef struct _PhotoFileReader PhotoFileReader;
typedef struct _PhotoFileReaderClass PhotoFileReaderClass;
typedef struct _PhotoBackingReadersPrivate PhotoBackingReadersPrivate;
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_PHOTO_TABLE (photo_table_get_type ())
#define PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_TABLE, PhotoTable))
#define PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_TABLE, PhotoTableClass))
#define IS_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_TABLE))
#define IS_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_TABLE))
#define PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_TABLE, PhotoTableClass))

typedef struct _PhotoTable PhotoTable;
typedef struct _PhotoTableClass PhotoTableClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_BACKING_PHOTO_TABLE (backing_photo_table_get_type ())
#define BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTable))
#define BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))
#define IS_BACKING_PHOTO_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKING_PHOTO_TABLE))
#define IS_BACKING_PHOTO_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKING_PHOTO_TABLE))
#define BACKING_PHOTO_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKING_PHOTO_TABLE, BackingPhotoTableClass))

typedef struct _BackingPhotoTable BackingPhotoTable;
typedef struct _BackingPhotoTableClass BackingPhotoTableClass;

#define TYPE_PHOTO_PREVIEW (photo_preview_get_type ())
#define PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_PREVIEW, PhotoPreview))
#define PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))
#define IS_PHOTO_PREVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_PREVIEW))
#define IS_PHOTO_PREVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_PREVIEW))
#define PHOTO_PREVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_PREVIEW, PhotoPreviewClass))

typedef struct _PhotoPreview PhotoPreview;
typedef struct _PhotoPreviewClass PhotoPreviewClass;
#define _photo_preview_unref0(var) ((var == NULL) ? NULL : (var = (photo_preview_unref (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _alteration_unref0(var) ((var == NULL) ? NULL : (var = (alteration_unref (var), NULL)))

#define TYPE_PHOTO_FILE_INTERROGATOR (photo_file_interrogator_get_type ())
#define PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogator))
#define PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))
#define IS_PHOTO_FILE_INTERROGATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_INTERROGATOR))
#define IS_PHOTO_FILE_INTERROGATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_INTERROGATOR))
#define PHOTO_FILE_INTERROGATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_INTERROGATOR, PhotoFileInterrogatorClass))

typedef struct _PhotoFileInterrogator PhotoFileInterrogator;
typedef struct _PhotoFileInterrogatorClass PhotoFileInterrogatorClass;
#define _photo_file_interrogator_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_interrogator_unref (var), NULL)))

#define TYPE_DETECTED_PHOTO_INFORMATION (detected_photo_information_get_type ())
#define DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformation))
#define DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))
#define IS_DETECTED_PHOTO_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DETECTED_PHOTO_INFORMATION))
#define IS_DETECTED_PHOTO_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DETECTED_PHOTO_INFORMATION))
#define DETECTED_PHOTO_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DETECTED_PHOTO_INFORMATION, DetectedPhotoInformationClass))

typedef struct _DetectedPhotoInformation DetectedPhotoInformation;
typedef struct _DetectedPhotoInformationClass DetectedPhotoInformationClass;
#define _detected_photo_information_unref0(var) ((var == NULL) ? NULL : (var = (detected_photo_information_unref (var), NULL)))
typedef struct _DetectedPhotoInformationPrivate DetectedPhotoInformationPrivate;

#define TYPE_PHOTO_FILE_WRITER (photo_file_writer_get_type ())
#define PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriter))
#define PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))
#define IS_PHOTO_FILE_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_WRITER))
#define IS_PHOTO_FILE_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_WRITER))
#define PHOTO_FILE_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_WRITER, PhotoFileWriterClass))

typedef struct _PhotoFileWriter PhotoFileWriter;
typedef struct _PhotoFileWriterClass PhotoFileWriterClass;

#define TYPE_PHOTO_FORMAT_ERROR (photo_format_error_get_type ())
typedef enum  {
	JPEG_QUALITY_LOW = 50,
	JPEG_QUALITY_MEDIUM = 75,
	JPEG_QUALITY_HIGH = 90,
	JPEG_QUALITY_MAXIMUM = 100
} JpegQuality;

#define JPEG_TYPE_QUALITY (jpeg_quality_get_type ())

#define TYPE_PHOTO_FILE_METADATA_WRITER (photo_file_metadata_writer_get_type ())
#define PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriter))
#define PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))
#define IS_PHOTO_FILE_METADATA_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_METADATA_WRITER))
#define IS_PHOTO_FILE_METADATA_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_METADATA_WRITER))
#define PHOTO_FILE_METADATA_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_METADATA_WRITER, PhotoFileMetadataWriterClass))

typedef struct _PhotoFileMetadataWriter PhotoFileMetadataWriter;
typedef struct _PhotoFileMetadataWriterClass PhotoFileMetadataWriterClass;
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))

#define TYPE_EXPORT_FORMAT_PARAMETERS (export_format_parameters_get_type ())
typedef struct _ExportFormatParameters ExportFormatParameters;
typedef enum  {
	EXPORT_FORMAT_MODE_UNMODIFIED,
	EXPORT_FORMAT_MODE_CURRENT,
	EXPORT_FORMAT_MODE_SPECIFIED,
	EXPORT_FORMAT_MODE_LAST
} ExportFormatMode;

#define TYPE_EXPORT_FORMAT_MODE (export_format_mode_get_type ())
typedef enum  {
	IMPORT_RESULT_SUCCESS,
	IMPORT_RESULT_FILE_ERROR,
	IMPORT_RESULT_DECODE_ERROR,
	IMPORT_RESULT_DATABASE_ERROR,
	IMPORT_RESULT_USER_ABORT,
	IMPORT_RESULT_NOT_A_FILE,
	IMPORT_RESULT_PHOTO_EXISTS,
	IMPORT_RESULT_UNSUPPORTED_FORMAT,
	IMPORT_RESULT_NOT_AN_IMAGE,
	IMPORT_RESULT_DISK_FAILURE,
	IMPORT_RESULT_DISK_FULL,
	IMPORT_RESULT_CAMERA_ERROR,
	IMPORT_RESULT_FILE_WRITE_ERROR,
	IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE
} ImportResult;

#define TYPE_IMPORT_RESULT (import_result_get_type ())
#define _metadata_date_time_unref0(var) ((var == NULL) ? NULL : (var = (metadata_date_time_unref (var), NULL)))
typedef enum  {
	PHOTO_FILE_READER_ROLE_DEFAULT,
	PHOTO_FILE_READER_ROLE_THUMBNAIL
} PhotoFileReaderRole;

#define PHOTO_FILE_READER_TYPE_ROLE (photo_file_reader_role_get_type ())

#define PHOTO_TYPE_REIMPORT_MASTER_STATE (photo_reimport_master_state_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState))
#define PHOTO_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_IS_REIMPORT_MASTER_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE))
#define PHOTO_REIMPORT_MASTER_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterStateClass))

typedef struct _PhotoReimportMasterState PhotoReimportMasterState;
typedef struct _PhotoReimportMasterStateClass PhotoReimportMasterStateClass;
#define _photo_reimport_master_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_master_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL (photo_reimport_master_state_impl_get_type ())
#define PHOTO_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_IS_REIMPORT_MASTER_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL))
#define PHOTO_REIMPORT_MASTER_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImplClass))

typedef struct _PhotoReimportMasterStateImpl PhotoReimportMasterStateImpl;
typedef struct _PhotoReimportMasterStateImplClass PhotoReimportMasterStateImplClass;
typedef struct _PhotoReimportMasterStatePrivate PhotoReimportMasterStatePrivate;
typedef struct _PhotoReimportMasterStateImplPrivate PhotoReimportMasterStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE (photo_reimport_editable_state_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState))
#define PHOTO_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE))
#define PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableStateClass))

typedef struct _PhotoReimportEditableState PhotoReimportEditableState;
typedef struct _PhotoReimportEditableStateClass PhotoReimportEditableStateClass;
#define _photo_reimport_editable_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_editable_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL (photo_reimport_editable_state_impl_get_type ())
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_IS_REIMPORT_EDITABLE_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL))
#define PHOTO_REIMPORT_EDITABLE_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImplClass))

typedef struct _PhotoReimportEditableStateImpl PhotoReimportEditableStateImpl;
typedef struct _PhotoReimportEditableStateImplClass PhotoReimportEditableStateImplClass;
typedef struct _PhotoReimportEditableStatePrivate PhotoReimportEditableStatePrivate;
typedef struct _PhotoReimportEditableStateImplPrivate PhotoReimportEditableStateImplPrivate;

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE (photo_reimport_raw_development_state_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentStateClass))

typedef struct _PhotoReimportRawDevelopmentState PhotoReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateClass PhotoReimportRawDevelopmentStateClass;
#define _photo_reimport_raw_development_state_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_unref (var), NULL)))

#define PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (photo_reimport_raw_development_state_impl_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImplClass))

typedef struct _PhotoReimportRawDevelopmentStateImpl PhotoReimportRawDevelopmentStateImpl;
typedef struct _PhotoReimportRawDevelopmentStateImplClass PhotoReimportRawDevelopmentStateImplClass;

#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT (photo_reimport_raw_development_state_impl_dev_to_reimport_get_type ())
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_IS_DEV_TO_REIMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT))
#define PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimportClass))

typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimport PhotoReimportRawDevelopmentStateImplDevToReimport;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass PhotoReimportRawDevelopmentStateImplDevToReimportClass;
typedef struct _PhotoReimportRawDevelopmentStatePrivate PhotoReimportRawDevelopmentStatePrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplPrivate PhotoReimportRawDevelopmentStateImplPrivate;
typedef struct _PhotoReimportRawDevelopmentStateImplDevToReimportPrivate PhotoReimportRawDevelopmentStateImplDevToReimportPrivate;
#define _photo_reimport_raw_development_state_impl_dev_to_reimport_unref0(var) ((var == NULL) ? NULL : (var = (photo_reimport_raw_development_state_impl_dev_to_reimport_unref (var), NULL)))

#define TYPE_LIBRARY_PHOTO (library_photo_get_type ())
#define LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO, LibraryPhoto))
#define LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))
#define IS_LIBRARY_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO))
#define IS_LIBRARY_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO))
#define LIBRARY_PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO, LibraryPhotoClass))

typedef struct _LibraryPhoto LibraryPhoto;
typedef struct _LibraryPhotoClass LibraryPhotoClass;
typedef enum  {
	PHOTO_METADATA_SET_OPTION_ALL_DOMAINS,
	PHOTO_METADATA_SET_OPTION_ONLY_IF_DOMAIN_PRESENT,
	PHOTO_METADATA_SET_OPTION_AT_LEAST_DEFAULT_DOMAIN
} PhotoMetadataSetOption;

#define PHOTO_METADATA_TYPE_SET_OPTION (photo_metadata_set_option_get_type ())

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
#define _key_value_map_unref0(var) ((var == NULL) ? NULL : (var = (key_value_map_unref (var), NULL)))
#define _pixel_transformation_unref0(var) ((var == NULL) ? NULL : (var = (pixel_transformation_unref (var), NULL)))

#define PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL (photo_photo_transformation_state_impl_get_type ())
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL))
#define PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImplClass))

typedef struct _PhotoPhotoTransformationStateImpl PhotoPhotoTransformationStateImpl;
typedef struct _PhotoPhotoTransformationStateImplClass PhotoPhotoTransformationStateImplClass;

#define EDITING_TOOLS_TYPE_REDEYE_INSTANCE (editing_tools_redeye_instance_get_type ())
typedef struct _EditingToolsRedeyeInstance EditingToolsRedeyeInstance;
typedef struct _PhotoCachedPixbufPrivate PhotoCachedPixbufPrivate;
#define _photo_cached_pixbuf_unref0(var) ((var == NULL) ? NULL : (var = (photo_cached_pixbuf_unref (var), NULL)))

#define TYPE_PHOTO_FILE_FORMAT_PROPERTIES (photo_file_format_properties_get_type ())
#define PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatProperties))
#define PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define IS_PHOTO_FILE_FORMAT_PROPERTIES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_FILE_FORMAT_PROPERTIES))
#define PHOTO_FILE_FORMAT_PROPERTIES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_FILE_FORMAT_PROPERTIES, PhotoFileFormatPropertiesClass))

typedef struct _PhotoFileFormatProperties PhotoFileFormatProperties;
typedef struct _PhotoFileFormatPropertiesClass PhotoFileFormatPropertiesClass;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))

#define TYPE_CONFIGURATION_FACADE (configuration_facade_get_type ())
#define CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacade))
#define CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))
#define IS_CONFIGURATION_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONFIGURATION_FACADE))
#define IS_CONFIGURATION_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONFIGURATION_FACADE))
#define CONFIGURATION_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONFIGURATION_FACADE, ConfigurationFacadeClass))

typedef struct _ConfigurationFacade ConfigurationFacade;
typedef struct _ConfigurationFacadeClass ConfigurationFacadeClass;

#define CONFIG_TYPE_FACADE (config_facade_get_type ())
#define CONFIG_FACADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_FACADE, ConfigFacade))
#define CONFIG_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_FACADE, ConfigFacadeClass))
#define CONFIG_IS_FACADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_FACADE))
#define CONFIG_IS_FACADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_FACADE))
#define CONFIG_FACADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_FACADE, ConfigFacadeClass))

typedef struct _ConfigFacade ConfigFacade;
typedef struct _ConfigFacadeClass ConfigFacadeClass;
typedef void (*OneShotCallback) (gpointer user_data);
typedef struct _PhotoPhotoTransformationStateImplPrivate PhotoPhotoTransformationStateImplPrivate;
enum  {
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_0_PROPERTY,
	PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_NUM_PROPERTIES
};
static GParamSpec* photo_photo_transformation_state_impl_properties[PHOTO_PHOTO_TRANSFORMATION_STATE_IMPL_NUM_PROPERTIES];
typedef struct _PhotoParamSpecBackingReaders PhotoParamSpecBackingReaders;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _PhotoParamSpecCachedPixbuf PhotoParamSpecCachedPixbuf;
typedef struct _PhotoParamSpecReimportMasterState PhotoParamSpecReimportMasterState;
typedef struct _PhotoParamSpecReimportEditableState PhotoParamSpecReimportEditableState;
typedef struct _PhotoParamSpecReimportRawDevelopmentState PhotoParamSpecReimportRawDevelopmentState;
typedef struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport;
enum  {
	PHOTO_EDITABLE_REPLACED_SIGNAL,
	PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL,
	PHOTO_BASELINE_REPLACED_SIGNAL,
	PHOTO_MASTER_REIMPORTED_SIGNAL,
	PHOTO_EDITABLE_REIMPORTED_SIGNAL,
	PHOTO_BASELINE_REIMPORTED_SIGNAL,
	PHOTO_SOURCE_REIMPORTED_SIGNAL,
	PHOTO_NUM_SIGNALS
};
static guint photo_signals[PHOTO_NUM_SIGNALS] = {0};
typedef struct _DataCollectionPrivate DataCollectionPrivate;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef struct _MediaSourceCollectionPrivate MediaSourceCollectionPrivate;

#define TYPE_DATABASE_SOURCE_HOLDING_TANK (database_source_holding_tank_get_type ())
#define DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTank))
#define DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))
#define IS_DATABASE_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define IS_DATABASE_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_HOLDING_TANK))
#define DATABASE_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_HOLDING_TANK, DatabaseSourceHoldingTankClass))

typedef struct _DatabaseSourceHoldingTank DatabaseSourceHoldingTank;
typedef struct _DatabaseSourceHoldingTankClass DatabaseSourceHoldingTankClass;

#define TYPE_MEDIA_SOURCE_HOLDING_TANK (media_source_holding_tank_get_type ())
#define MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank))
#define MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))
#define IS_MEDIA_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define IS_MEDIA_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_HOLDING_TANK))
#define MEDIA_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTankClass))

typedef struct _MediaSourceHoldingTank MediaSourceHoldingTank;
typedef struct _MediaSourceHoldingTankClass MediaSourceHoldingTankClass;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION (library_photo_source_collection_get_type ())
#define LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define IS_LIBRARY_PHOTO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION))
#define LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollectionClass))

typedef struct _LibraryPhotoSourceCollection LibraryPhotoSourceCollection;
typedef struct _LibraryPhotoSourceCollectionClass LibraryPhotoSourceCollectionClass;
typedef struct _LibraryPhotoSourceCollectionPrivate LibraryPhotoSourceCollectionPrivate;
typedef enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE,
	LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER
} LibraryPhotoSourceCollectionState;

#define LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE (library_photo_source_collection_state_get_type ())
#define _transaction_controller_unref0(var) ((var == NULL) ? NULL : (var = (transaction_controller_unref (var), NULL)))
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, gpointer user_data);
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
typedef gboolean (*SourceHoldingTankCheckToKeep) (DataSource* source, Alteration* alteration, gpointer user_data);

#define TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (library_photo_source_holding_tank_get_type ())
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK))
#define LIBRARY_PHOTO_SOURCE_HOLDING_TANK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTankClass))

typedef struct _LibraryPhotoSourceHoldingTank LibraryPhotoSourceHoldingTank;
typedef struct _LibraryPhotoSourceHoldingTankClass LibraryPhotoSourceHoldingTankClass;

#define TYPE_PHOTO_MONITOR (photo_monitor_get_type ())
#define PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_MONITOR, PhotoMonitor))
#define PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_MONITOR, PhotoMonitorClass))
#define IS_PHOTO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_MONITOR))
#define IS_PHOTO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_MONITOR))
#define PHOTO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_MONITOR, PhotoMonitorClass))

typedef struct _PhotoMonitor PhotoMonitor;
typedef struct _PhotoMonitorClass PhotoMonitorClass;

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_HIERARCHICAL_TAG_INDEX (hierarchical_tag_index_get_type ())
#define HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndex))
#define HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))
#define IS_HIERARCHICAL_TAG_INDEX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HIERARCHICAL_TAG_INDEX))
#define IS_HIERARCHICAL_TAG_INDEX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HIERARCHICAL_TAG_INDEX))
#define HIERARCHICAL_TAG_INDEX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HIERARCHICAL_TAG_INDEX, HierarchicalTagIndexClass))

typedef struct _HierarchicalTagIndex HierarchicalTagIndex;
typedef struct _HierarchicalTagIndexClass HierarchicalTagIndexClass;
#define _hierarchical_tag_index_unref0(var) ((var == NULL) ? NULL : (var = (hierarchical_tag_index_unref (var), NULL)))

#define TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER (media_source_transaction_controller_get_type ())
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionController))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define IS_MEDIA_SOURCE_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER))
#define MEDIA_SOURCE_TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_TRANSACTION_CONTROLLER, MediaSourceTransactionControllerClass))

typedef struct _MediaSourceTransactionController MediaSourceTransactionController;
typedef struct _MediaSourceTransactionControllerClass MediaSourceTransactionControllerClass;
enum  {
	LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL,
	LIBRARY_PHOTO_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_NUM_SIGNALS] = {0};

#define TYPE_FLAGGABLE (flaggable_get_type ())
#define FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLAGGABLE, Flaggable))
#define IS_FLAGGABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLAGGABLE))
#define FLAGGABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_FLAGGABLE, FlaggableIface))

typedef struct _Flaggable Flaggable;
typedef struct _FlaggableIface FlaggableIface;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;
typedef struct _LibraryPhotoPrivate LibraryPhotoPrivate;
enum  {
	LIBRARY_PHOTO_0_PROPERTY,
	LIBRARY_PHOTO_NUM_PROPERTIES
};
static GParamSpec* library_photo_properties[LIBRARY_PHOTO_NUM_PROPERTIES];
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef enum  {
	THUMBNAIL_CACHE_SIZE_LARGEST = 512,
	THUMBNAIL_CACHE_SIZE_LARGE = 512,
	THUMBNAIL_CACHE_SIZE_BIG = 360,
	THUMBNAIL_CACHE_SIZE_MEDIUM = 128,
	THUMBNAIL_CACHE_SIZE_SMALLEST = 128
} ThumbnailCacheSize;

#define THUMBNAIL_CACHE_TYPE_SIZE (thumbnail_cache_size_get_type ())

#define TYPE_EVENT_SOURCE (event_source_get_type ())
#define EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT_SOURCE, EventSource))
#define EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT_SOURCE, EventSourceClass))
#define IS_EVENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT_SOURCE))
#define IS_EVENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT_SOURCE))
#define EVENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT_SOURCE, EventSourceClass))

typedef struct _EventSource EventSource;
typedef struct _EventSourceClass EventSourceClass;

#define TYPE_EVENT (event_get_type ())
#define EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EVENT, Event))
#define EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EVENT, EventClass))
#define IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EVENT))
#define IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EVENT))
#define EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EVENT, EventClass))

typedef struct _Event Event;
typedef struct _EventClass EventClass;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;

#define TYPE_TAG_SOURCE_COLLECTION (tag_source_collection_get_type ())
#define TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollection))
#define TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))
#define IS_TAG_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG_SOURCE_COLLECTION))
#define IS_TAG_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG_SOURCE_COLLECTION))
#define TAG_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG_SOURCE_COLLECTION, TagSourceCollectionClass))

typedef struct _TagSourceCollection TagSourceCollection;
typedef struct _TagSourceCollectionClass TagSourceCollectionClass;

#define TYPE_FACE (face_get_type ())
#define FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE, Face))
#define FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE, FaceClass))
#define IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE))
#define IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE))
#define FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE, FaceClass))

typedef struct _Face Face;
typedef struct _FaceClass FaceClass;

#define TYPE_FACE_SOURCE_COLLECTION (face_source_collection_get_type ())
#define FACE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollection))
#define FACE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollectionClass))
#define IS_FACE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_SOURCE_COLLECTION))
#define IS_FACE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_SOURCE_COLLECTION))
#define FACE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_SOURCE_COLLECTION, FaceSourceCollectionClass))

typedef struct _FaceSourceCollection FaceSourceCollection;
typedef struct _FaceSourceCollectionClass FaceSourceCollectionClass;

#define TYPE_FACE_LOCATION (face_location_get_type ())
#define FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION, FaceLocation))
#define FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION, FaceLocationClass))
#define IS_FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION))
#define IS_FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION))
#define FACE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION, FaceLocationClass))

typedef struct _FaceLocation FaceLocation;
typedef struct _FaceLocationClass FaceLocationClass;

#define TYPE_FACE_ID (face_id_get_type ())
typedef struct _FaceID FaceID;

#define TYPE_FACE_LOCATION_DATA (face_location_data_get_type ())
typedef struct _FaceLocationData FaceLocationData;
typedef struct _SourceHoldingTankPrivate SourceHoldingTankPrivate;
typedef struct _DatabaseSourceHoldingTankPrivate DatabaseSourceHoldingTankPrivate;
typedef struct _MediaSourceHoldingTankPrivate MediaSourceHoldingTankPrivate;
typedef struct _LibraryPhotoSourceHoldingTankPrivate LibraryPhotoSourceHoldingTankPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ImportID {
	gint64 id;
};

struct _PhotoImportParams {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoImportParamsPrivate * priv;
	GFile* file;
	GFile* final_associated_file;
	ImportID import_id;
	PhotoFileSnifferOptions sniffer_options;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	Thumbnails* thumbnails;
	PhotoRow* row;
	GeeCollection* keywords;
};

struct _PhotoImportParamsClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoImportParams *self);
};

struct _ParamSpecPhotoImportParams {
	GParamSpec parent_instance;
};

struct _PhotoTransformationState {
	GObject parent_instance;
	PhotoTransformationStatePrivate * priv;
};

struct _PhotoTransformationStateClass {
	GObjectClass parent_class;
	void (*broken) (PhotoTransformationState* self);
};

struct _PhotoTransformationStatePrivate {
	gboolean is_broke;
};

struct _DataObject {
	GObject parent_instance;
	DataObjectPrivate * priv;
};

struct _DataObjectClass {
	GObjectClass parent_class;
	void (*notify_altered) (DataObject* self, Alteration* alteration);
	void (*notify_membership_changed) (DataObject* self, DataCollection* collection);
	void (*notify_collection_property_set) (DataObject* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_collection_property_cleared) (DataObject* self, const gchar* name);
	gchar* (*get_name) (DataObject* self);
	gchar* (*to_string) (DataObject* self);
};

struct _DataSource {
	DataObject parent_instance;
	DataSourcePrivate * priv;
};

struct _DataSourceClass {
	DataObjectClass parent_class;
	void (*notify_held_in_tank) (DataSource* self, SourceHoldingTank* holding_tank);
	void (*notify_unlinking) (DataSource* self, SourceCollection* collection);
	void (*notify_unlinked) (DataSource* self);
	void (*notify_relinking) (DataSource* self, SourceCollection* collection);
	void (*notify_relinked) (DataSource* self);
	gchar* (*get_typename) (DataSource* self);
	gint64 (*get_instance_id) (DataSource* self);
	gchar* (*get_source_id) (DataSource* self);
	void (*commit_backlinks) (DataSource* self, SourceCollection* sources, const gchar* dehydrated);
	SourceSnapshot* (*save_snapshot) (DataSource* self);
	gboolean (*internal_delete_backing) (DataSource* self, GError** error);
	gboolean (*equals) (DataSource* self, DataSource* source);
	void (*destroy) (DataSource* self);
	void (*unlinked) (DataSource* self, SourceCollection* sources);
	void (*relinked) (DataSource* self, SourceCollection* sources);
	void (*destroyed) (DataSource* self);
};

struct _ThumbnailSource {
	DataSource parent_instance;
	ThumbnailSourcePrivate * priv;
};

struct _ThumbnailSourceClass {
	DataSourceClass parent_class;
	void (*notify_thumbnail_altered) (ThumbnailSource* self);
	GdkPixbuf* (*get_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	GdkPixbuf* (*create_thumbnail) (ThumbnailSource* self, gint scale, GError** error);
	gchar* (*get_representative_id) (ThumbnailSource* self);
	PhotoFileFormat (*get_preferred_thumbnail_format) (ThumbnailSource* self);
	void (*thumbnail_altered) (ThumbnailSource* self);
};

struct _IndexableIface {
	GTypeInterface parent_iface;
	const gchar* (*get_indexable_keywords) (Indexable* self);
};

struct _EventID {
	gint64 id;
};

struct _Dimensions {
	gint width;
	gint height;
};

struct _Scaling {
	ScaleConstraint constraint;
	gint scale;
	Dimensions viewport;
	gboolean scale_up;
};

struct _MediaSource {
	ThumbnailSource parent_instance;
	MediaSourcePrivate * priv;
};

struct _MediaSourceClass {
	ThumbnailSourceClass parent_class;
	void (*notify_master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
	gboolean (*set_event_id) (MediaSource* self, EventID* id);
	gchar* (*get_basename) (MediaSource* self);
	GFile* (*get_file) (MediaSource* self);
	GFile* (*get_master_file) (MediaSource* self);
	guint64 (*get_master_filesize) (MediaSource* self);
	guint64 (*get_filesize) (MediaSource* self);
	GDateTime* (*get_timestamp) (MediaSource* self);
	BackingFileState** (*get_backing_files_state) (MediaSource* self, gint* result_length1);
	gchar* (*get_title) (MediaSource* self);
	gchar* (*get_comment) (MediaSource* self);
	void (*set_title) (MediaSource* self, const gchar* title);
	gboolean (*set_comment) (MediaSource* self, const gchar* comment);
	Rating (*get_rating) (MediaSource* self);
	void (*set_rating) (MediaSource* self, Rating rating);
	void (*increase_rating) (MediaSource* self);
	void (*decrease_rating) (MediaSource* self);
	void (*get_dimensions) (MediaSource* self, PhotoException disallowed_steps, Dimensions* result);
	GdkPixbuf* (*get_preview_pixbuf) (MediaSource* self, Scaling* scaling, GError** error);
	gboolean (*is_trashed) (MediaSource* self);
	void (*trash) (MediaSource* self);
	void (*untrash) (MediaSource* self);
	gboolean (*is_offline) (MediaSource* self);
	void (*mark_offline) (MediaSource* self);
	void (*mark_online) (MediaSource* self);
	gchar* (*get_master_md5) (MediaSource* self);
	void (*get_event_id) (MediaSource* self, EventID* result);
	GDateTime* (*get_exposure_time) (MediaSource* self);
	void (*get_import_id) (MediaSource* self, ImportID* result);
	void (*master_replaced) (MediaSource* self, GFile* old_file, GFile* new_file);
};

struct _PhotoSource {
	MediaSource parent_instance;
	PhotoSourcePrivate * priv;
};

struct _PhotoSourceClass {
	MediaSourceClass parent_class;
	PhotoMetadata* (*get_metadata) (PhotoSource* self);
	GdkPixbuf* (*get_pixbuf) (PhotoSource* self, Scaling* scaling, GError** error);
};

struct _DateableIface {
	GTypeInterface parent_iface;
	void (*set_exposure_time) (Dateable* self, GDateTime* target_time);
	GDateTime* (*get_exposure_time) (Dateable* self);
};

struct _GpsCoords {
	gint has_gps;
	gdouble latitude;
	gdouble longitude;
};

struct _PositionableIface {
	GTypeInterface parent_iface;
	void (*get_gps_coords) (Positionable* self, GpsCoords* result);
	void (*set_gps_coords) (Positionable* self, GpsCoords* gps_coords);
};

struct _Photo {
	PhotoSource parent_instance;
	PhotoPrivate * priv;
	PhotoRow* row;
	gboolean can_rotate_now;
	BackingPhotoRow* backing_photo_row;
};

struct _PhotoClass {
	PhotoSourceClass parent_class;
	void (*notify_editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*notify_raw_development_modified) (Photo* self);
	void (*notify_baseline_replaced) (Photo* self);
	void (*notify_master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_source_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*apply_user_metadata_for_reimport) (Photo* self, PhotoMetadata* metadata);
	void (*rotate) (Photo* self, Rotation rotation);
	gboolean (*has_user_generated_metadata) (Photo* self);
	void (*set_user_metadata_for_export) (Photo* self, PhotoMetadata* metadata);
	void (*editable_replaced) (Photo* self, GFile* old_file, GFile* new_file);
	void (*raw_development_modified) (Photo* self);
	void (*baseline_replaced) (Photo* self);
	void (*master_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*editable_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*baseline_reimported) (Photo* self, PhotoMetadata* metadata);
	void (*source_reimported) (Photo* self, PhotoMetadata* metadata);
};

struct _PhotoPrivate {
	GDateTime* cached_exposure_time;
	GRecMutex __lock_row;
	BackingPhotoRow* editable;
	PhotoBackingReaders* readers;
	GRecMutex __lock_readers;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
	gchar* file_title;
	GFileMonitor* editable_monitor;
	OneShotScheduler* reimport_editable_scheduler;
	OneShotScheduler* update_editable_attributes_scheduler;
	OneShotScheduler* remove_editable_scheduler;
	GeeHashMap* developments;
	GRecMutex __lock_developments;
};

struct _PhotoID {
	gint64 id;
};

struct _BackingPhotoID {
	gint64 id;
};

struct _PhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoRowPrivate * priv;
	PhotoID photo_id;
	BackingPhotoRow* master;
	GDateTime* exposure_time;
	ImportID import_id;
	EventID event_id;
	Orientation orientation;
	GeeHashMap* transformations;
	gchar* md5;
	gchar* thumbnail_md5;
	gchar* exif_md5;
	gint64 time_created;
	guint64 flags;
	Rating rating;
	gchar* title;
	GpsCoords gps_coords;
	gchar* comment;
	gchar* backlinks;
	gint64 time_reimported;
	BackingPhotoID editable_id;
	gboolean metadata_dirty;
	RawDeveloper developer;
	BackingPhotoID* development_ids;
	gint development_ids_length1;
};

struct _PhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoRow *self);
};

struct _BackingPhotoRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackingPhotoRowPrivate * priv;
	BackingPhotoID id;
	gint64 time_created;
	gchar* filepath;
	gint64 filesize;
	GDateTime* timestamp;
	PhotoFileFormat file_format;
	Dimensions dim;
	Orientation original_orientation;
};

struct _BackingPhotoRowClass {
	GTypeClass parent_class;
	void (*finalize) (BackingPhotoRow *self);
};

struct _PhotoBackingReaders {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoBackingReadersPrivate * priv;
	PhotoFileReader* master;
	PhotoFileReader* developer;
	PhotoFileReader* editable;
};

struct _PhotoBackingReadersClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoBackingReaders *self);
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _DetectedPhotoInformation {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DetectedPhotoInformationPrivate * priv;
	PhotoFileFormat file_format;
	PhotoMetadata* metadata;
	gchar* md5;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* format_name;
	Dimensions image_dim;
	GdkColorspace colorspace;
	gint channels;
	gint bits_per_channel;
};

struct _DetectedPhotoInformationClass {
	GTypeClass parent_class;
	void (*finalize) (DetectedPhotoInformation *self);
};

typedef enum  {
	PHOTO_FORMAT_ERROR_READ_ONLY
} PhotoFormatError;
#define PHOTO_FORMAT_ERROR photo_format_error_quark ()

struct _ExportFormatParameters {
	ExportFormatMode mode;
	PhotoFileFormat specified_format;
	JpegQuality quality;
	gboolean export_metadata;
};

struct _PhotoReimportMasterState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportMasterStatePrivate * priv;
};

struct _PhotoReimportMasterStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportMasterState *self);
};

struct _PhotoReimportMasterStateImpl {
	PhotoReimportMasterState parent_instance;
	PhotoReimportMasterStateImplPrivate * priv;
	PhotoRow* row;
	PhotoMetadata* metadata;
	gchar** alterations;
	gint alterations_length1;
	gint _alterations_size_;
	gboolean metadata_only;
};

struct _PhotoReimportMasterStateImplClass {
	PhotoReimportMasterStateClass parent_class;
};

struct _PhotoReimportEditableState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportEditableStatePrivate * priv;
};

struct _PhotoReimportEditableStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportEditableState *self);
};

struct _PhotoReimportEditableStateImpl {
	PhotoReimportEditableState parent_instance;
	PhotoReimportEditableStateImplPrivate * priv;
	BackingPhotoRow* backing_state;
	PhotoMetadata* metadata;
	gboolean metadata_only;
};

struct _PhotoReimportEditableStateImplClass {
	PhotoReimportEditableStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStatePrivate * priv;
};

struct _PhotoReimportRawDevelopmentStateClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentState *self);
};

struct _PhotoReimportRawDevelopmentStateImpl {
	PhotoReimportRawDevelopmentState parent_instance;
	PhotoReimportRawDevelopmentStateImplPrivate * priv;
	GeeCollection* list;
	gboolean metadata_only;
};

struct _PhotoReimportRawDevelopmentStateImplClass {
	PhotoReimportRawDevelopmentStateClass parent_class;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimport {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoReimportRawDevelopmentStateImplDevToReimportPrivate * priv;
	BackingPhotoRow* backing;
	PhotoMetadata* metadata;
};

struct _PhotoReimportRawDevelopmentStateImplDevToReimportClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoReimportRawDevelopmentStateImplDevToReimport *self);
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _EditingToolsRedeyeInstance {
	GdkPoint center;
	gint radius;
};

struct _PhotoCachedPixbuf {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PhotoCachedPixbufPrivate * priv;
	Photo* photo;
	GdkPixbuf* pixbuf;
	GTimer* last_touched;
};

struct _PhotoCachedPixbufClass {
	GTypeClass parent_class;
	void (*finalize) (PhotoCachedPixbuf *self);
};

struct _PhotoPhotoTransformationStateImpl {
	PhotoTransformationState parent_instance;
	PhotoPhotoTransformationStateImplPrivate * priv;
};

struct _PhotoPhotoTransformationStateImplClass {
	PhotoTransformationStateClass parent_class;
};

struct _PhotoPhotoTransformationStateImplPrivate {
	Photo* photo;
	Orientation orientation;
	GeeHashMap* transformations;
	PixelTransformer* transformer;
	PixelTransformationBundle* adjustments;
};

struct _PhotoParamSpecBackingReaders {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecCachedPixbuf {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportMasterState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportEditableState {
	GParamSpec parent_instance;
};

struct _PhotoParamSpecReimportRawDevelopmentState {
	GParamSpec parent_instance;
};

struct _PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport {
	GParamSpec parent_instance;
};

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _MediaSourceCollection {
	DatabaseSourceCollection parent_instance;
	MediaSourceCollectionPrivate * priv;
};

struct _MediaSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	MediaSourceHoldingTank* (*create_trashcan) (MediaSourceCollection* self);
	MediaSourceHoldingTank* (*create_offline_bin) (MediaSourceCollection* self);
	MediaMonitor* (*create_media_monitor) (MediaSourceCollection* self, Workers* workers, GCancellable* cancellable);
	gchar* (*get_typename) (MediaSourceCollection* self);
	gboolean (*is_file_recognized) (MediaSourceCollection* self, GFile* file);
	MediaSource* (*fetch_by_numeric_id) (MediaSourceCollection* self, gint64 numeric_id);
	void (*notify_import_roll_altered) (MediaSourceCollection* self);
	void (*notify_flagged_contents_altered) (MediaSourceCollection* self);
	void (*notify_media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*notify_media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	MediaSource* (*fetch_by_source_id) (MediaSourceCollection* self, const gchar* source_id);
	GeeCollection* (*get_event_source_ids) (MediaSourceCollection* self, EventID* event_id);
	void (*import_many) (MediaSourceCollection* self, GeeCollection* media);
	void (*postprocess_imported_media) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_starting) (MediaSourceCollection* self, GeeCollection* media);
	void (*media_import_completed) (MediaSourceCollection* self, GeeCollection* media);
	void (*master_file_replaced) (MediaSourceCollection* self, MediaSource* media, GFile* old_file, GFile* new_file);
	void (*trashcan_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*import_roll_altered) (MediaSourceCollection* self);
	void (*offline_contents_altered) (MediaSourceCollection* self, GeeCollection* added, GeeCollection* removed);
	void (*flagged_contents_altered) (MediaSourceCollection* self);
	TransactionController* (*get_transaction_controller) (MediaSourceCollection* self);
};

struct _LibraryPhotoSourceCollection {
	MediaSourceCollection parent_instance;
	LibraryPhotoSourceCollectionPrivate * priv;
};

struct _LibraryPhotoSourceCollectionClass {
	MediaSourceCollectionClass parent_class;
	void (*notify_master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*notify_baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*master_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*editable_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*baseline_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
	void (*source_reimported) (LibraryPhotoSourceCollection* self, LibraryPhoto* photo, PhotoMetadata* metadata);
};

struct _LibraryPhotoSourceCollectionPrivate {
	TransactionController* _transaction_controller;
	GeeHashMap* by_editable_file;
	GeeHashMap* by_raw_development_file;
	GeeMultiMap* filesize_to_photo;
	GeeHashMap* photo_to_master_filesize;
	GeeHashMap* photo_to_editable_filesize;
	GeeMultiMap* photo_to_raw_development_filesize;
};

struct _FlaggableIface {
	GTypeInterface parent_iface;
	gboolean (*is_flagged) (Flaggable* self);
	void (*mark_flagged) (Flaggable* self);
	void (*mark_unflagged) (Flaggable* self);
};

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _LibraryPhoto {
	Photo parent_instance;
	LibraryPhotoPrivate * priv;
};

struct _LibraryPhotoClass {
	PhotoClass parent_class;
};

struct _LibraryPhotoPrivate {
	gboolean block_thumbnail_generation;
	OneShotScheduler* thumbnail_scheduler;
	GeeCollection* import_keywords;
};

struct _FaceID {
	gint64 id;
};

struct _FaceLocationData {
	gchar* geometry;
	gchar* vec;
};

struct _SourceHoldingTank {
	GTypeInstance parent_instance;
	volatile int ref_count;
	SourceHoldingTankPrivate * priv;
};

struct _SourceHoldingTankClass {
	GTypeClass parent_class;
	void (*finalize) (SourceHoldingTank *self);
	void (*notify_contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
	void (*contents_altered) (SourceHoldingTank* self, GeeCollection* added, GeeCollection* removed);
};

struct _DatabaseSourceHoldingTank {
	SourceHoldingTank parent_instance;
	DatabaseSourceHoldingTankPrivate * priv;
};

struct _DatabaseSourceHoldingTankClass {
	SourceHoldingTankClass parent_class;
};

struct _MediaSourceHoldingTank {
	DatabaseSourceHoldingTank parent_instance;
	MediaSourceHoldingTankPrivate * priv;
};

struct _MediaSourceHoldingTankClass {
	DatabaseSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTank {
	MediaSourceHoldingTank parent_instance;
	LibraryPhotoSourceHoldingTankPrivate * priv;
};

struct _LibraryPhotoSourceHoldingTankClass {
	MediaSourceHoldingTankClass parent_class;
};

struct _LibraryPhotoSourceHoldingTankPrivate {
	GeeHashMap* editable_file_map;
	GeeHashMap* development_file_map;
	GeeMultiMap* reverse_editable_file_map;
	GeeMultiMap* reverse_development_file_map;
};

static gpointer photo_import_params_parent_class = NULL;
static gint PhotoTransformationState_private_offset;
static gpointer photo_transformation_state_parent_class = NULL;
static gint Photo_private_offset;
static gpointer photo_parent_class = NULL;
static GeeLinkedList* photo_source_pixbuf_cache;
static GRecMutex __lock_photo_photo_source_pixbuf_cache = {0};
static GeeLinkedList* photo_source_pixbuf_cache = NULL;
static guint photo_discard_source_id;
static guint photo_discard_source_id = (guint) 0;
static gboolean photo__develop_raw_photos_to_files;
static gboolean photo__develop_raw_photos_to_files = FALSE;
static gint PhotoPhotoTransformationStateImpl_private_offset;
static gpointer photo_photo_transformation_state_impl_parent_class = NULL;
static gpointer photo_backing_readers_parent_class = NULL;
static gpointer photo_cached_pixbuf_parent_class = NULL;
static gpointer photo_reimport_master_state_parent_class = NULL;
static gpointer photo_reimport_master_state_impl_parent_class = NULL;
static gpointer photo_reimport_editable_state_parent_class = NULL;
static gpointer photo_reimport_editable_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_parent_class = NULL;
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = NULL;
static DateableIface * photo_dateable_parent_iface = NULL;
static PositionableIface * photo_positionable_parent_iface = NULL;
static gint LibraryPhotoSourceCollection_private_offset;
static gpointer library_photo_source_collection_parent_class = NULL;
static gint LibraryPhoto_private_offset;
static gpointer library_photo_parent_class = NULL;
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_global;
LibraryPhotoSourceCollection* library_photo_global = NULL;
VALA_EXTERN TagSourceCollection* tag_global;
VALA_EXTERN FaceSourceCollection* face_global;
static FlaggableIface * library_photo_flaggable_parent_iface = NULL;
static MonitorableIface * library_photo_monitorable_parent_iface = NULL;
static gint LibraryPhotoSourceHoldingTank_private_offset;
static gpointer library_photo_source_holding_tank_parent_class = NULL;

VALA_EXTERN GType backing_fetch_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer photo_import_params_ref (gpointer instance);
VALA_EXTERN void photo_import_params_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_import_params (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_photo_import_params (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_photo_import_params (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_photo_import_params (const GValue* value);
VALA_EXTERN GType photo_import_params_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoImportParams, photo_import_params_unref)
VALA_EXTERN GType import_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportID* import_id_dup (const ImportID* self);
VALA_EXTERN void import_id_free (ImportID* self);
VALA_EXTERN GType photo_file_sniffer_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer thumbnails_ref (gpointer instance);
VALA_EXTERN void thumbnails_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_thumbnails (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_thumbnails (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_thumbnails (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_thumbnails (const GValue* value);
VALA_EXTERN GType thumbnails_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Thumbnails, thumbnails_unref)
VALA_EXTERN gpointer photo_row_ref (gpointer instance);
VALA_EXTERN void photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_row (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_photo_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_photo_row (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_photo_row (const GValue* value);
VALA_EXTERN GType photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoRow, photo_row_unref)
VALA_EXTERN PhotoRow* photo_row_new (void);
VALA_EXTERN PhotoRow* photo_row_construct (GType object_type);
VALA_EXTERN PhotoImportParams* photo_import_params_new (GFile* file,
                                            GFile* final_associated_file,
                                            ImportID* import_id,
                                            PhotoFileSnifferOptions sniffer_options,
                                            const gchar* exif_md5,
                                            const gchar* thumbnail_md5,
                                            const gchar* full_md5,
                                            Thumbnails* thumbnails);
VALA_EXTERN PhotoImportParams* photo_import_params_construct (GType object_type,
                                                  GFile* file,
                                                  GFile* final_associated_file,
                                                  ImportID* import_id,
                                                  PhotoFileSnifferOptions sniffer_options,
                                                  const gchar* exif_md5,
                                                  const gchar* thumbnail_md5,
                                                  const gchar* full_md5,
                                                  Thumbnails* thumbnails);
VALA_EXTERN PhotoImportParams* photo_import_params_new_create_placeholder (GFile* file,
                                                               ImportID* import_id);
VALA_EXTERN PhotoImportParams* photo_import_params_construct_create_placeholder (GType object_type,
                                                                     GFile* file,
                                                                     ImportID* import_id);
static void photo_import_params_finalize (PhotoImportParams * obj);
static GType photo_import_params_get_type_once (void);
VALA_EXTERN GType photo_transformation_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoTransformationState, g_object_unref)
VALA_EXTERN gboolean photo_transformation_state_is_broken (PhotoTransformationState* self);
VALA_EXTERN PhotoTransformationState* photo_transformation_state_construct (GType object_type);
static void photo_transformation_state_real_broken (PhotoTransformationState* self);
static void photo_transformation_state_finalize (GObject * obj);
static GType photo_transformation_state_get_type_once (void);
VALA_EXTERN GType rating_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean rating_can_increase (Rating self);
VALA_EXTERN gboolean rating_can_decrease (Rating self);
VALA_EXTERN gboolean rating_is_valid (Rating self);
VALA_EXTERN Rating rating_increase (Rating self);
VALA_EXTERN Rating rating_decrease (Rating self);
VALA_EXTERN gint rating_serialize (Rating self);
VALA_EXTERN Rating rating_unserialize (gint value);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_holding_tank_ref (gpointer instance);
VALA_EXTERN void source_holding_tank_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_holding_tank (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_source_holding_tank (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_source_holding_tank (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_source_holding_tank (const GValue* value);
VALA_EXTERN GType source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN gpointer source_snapshot_ref (gpointer instance);
VALA_EXTERN void source_snapshot_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_snapshot (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_snapshot (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_snapshot (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_snapshot (const GValue* value);
VALA_EXTERN GType source_snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceSnapshot, source_snapshot_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType photo_file_format_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType indexable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Indexable, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType event_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EventID* event_id_dup (const EventID* self);
VALA_EXTERN void event_id_free (EventID* self);
VALA_EXTERN gpointer backing_file_state_ref (gpointer instance);
VALA_EXTERN void backing_file_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_file_state (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_backing_file_state (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_backing_file_state (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_backing_file_state (const GValue* value);
VALA_EXTERN GType backing_file_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingFileState, backing_file_state_unref)
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType scaling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType scale_constraint_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Scaling* scaling_dup (const Scaling* self);
VALA_EXTERN void scaling_free (Scaling* self);
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_metadata_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMetadata, media_metadata_unref)
VALA_EXTERN GType dateable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Dateable, g_object_unref)
VALA_EXTERN GType gps_coords_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GpsCoords* gps_coords_dup (const GpsCoords* self);
VALA_EXTERN void gps_coords_free (GpsCoords* self);
VALA_EXTERN GType positionable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Positionable, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GType rotation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer backing_photo_row_ref (gpointer instance);
VALA_EXTERN void backing_photo_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_backing_photo_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_backing_photo_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_backing_photo_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_backing_photo_row (const GValue* value);
VALA_EXTERN GType backing_photo_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoRow, backing_photo_row_unref)
static gpointer photo_backing_readers_ref (gpointer instance);
static void photo_backing_readers_unref (gpointer instance);
static GParamSpec* photo_param_spec_backing_readers (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags) G_GNUC_UNUSED ;
static void photo_value_set_backing_readers (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED ;
static void photo_value_take_backing_readers (GValue* value,
                                       gpointer v_object) G_GNUC_UNUSED ;
static gpointer photo_value_get_backing_readers (const GValue* value) G_GNUC_UNUSED ;
static GType photo_backing_readers_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoBackingReaders, photo_backing_readers_unref)
VALA_EXTERN gpointer one_shot_scheduler_ref (gpointer instance);
VALA_EXTERN void one_shot_scheduler_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_one_shot_scheduler (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_one_shot_scheduler (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_one_shot_scheduler (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_one_shot_scheduler (const GValue* value);
VALA_EXTERN GType one_shot_scheduler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (OneShotScheduler, one_shot_scheduler_unref)
VALA_EXTERN GType raw_developer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_notify_editable_replaced (Photo* self,
                                     GFile* old_file,
                                     GFile* new_file);
VALA_EXTERN void photo_notify_raw_development_modified (Photo* self);
VALA_EXTERN void photo_notify_baseline_replaced (Photo* self);
VALA_EXTERN void photo_notify_master_reimported (Photo* self,
                                     PhotoMetadata* metadata);
VALA_EXTERN void photo_notify_editable_reimported (Photo* self,
                                       PhotoMetadata* metadata);
VALA_EXTERN void photo_notify_source_reimported (Photo* self,
                                     PhotoMetadata* metadata);
VALA_EXTERN void photo_notify_baseline_reimported (Photo* self,
                                       PhotoMetadata* metadata);
VALA_EXTERN gboolean data_source_internal_delete_backing (DataSource* self,
                                              GError** error);
VALA_EXTERN BackingFileState** media_source_get_backing_files_state (MediaSource* self,
                                                         gint* result_length1);
VALA_EXTERN void photo_apply_user_metadata_for_reimport (Photo* self,
                                             PhotoMetadata* metadata);
VALA_EXTERN gchar* data_source_get_typename (DataSource* self);
VALA_EXTERN gint64 data_source_get_instance_id (DataSource* self);
VALA_EXTERN gchar* data_source_get_source_id (DataSource* self);
VALA_EXTERN PhotoFileFormat thumbnail_source_get_preferred_thumbnail_format (ThumbnailSource* self);
VALA_EXTERN GdkPixbuf* thumbnail_source_create_thumbnail (ThumbnailSource* self,
                                              gint scale,
                                              GError** error);
VALA_EXTERN GFile* media_source_get_file (MediaSource* self);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN GDateTime* media_source_get_timestamp (MediaSource* self);
VALA_EXTERN void media_source_get_event_id (MediaSource* self,
                                EventID* result);
VALA_EXTERN void media_source_get_import_id (MediaSource* self,
                                 ImportID* result);
VALA_EXTERN gchar* media_source_get_master_md5 (MediaSource* self);
VALA_EXTERN Rating media_source_get_rating (MediaSource* self);
VALA_EXTERN void media_source_set_rating (MediaSource* self,
                              Rating rating);
VALA_EXTERN void media_source_increase_rating (MediaSource* self);
VALA_EXTERN void media_source_decrease_rating (MediaSource* self);
VALA_EXTERN void data_source_commit_backlinks (DataSource* self,
                                   SourceCollection* sources,
                                   const gchar* dehydrated);
VALA_EXTERN gboolean media_source_set_event_id (MediaSource* self,
                                    EventID* id);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN gboolean data_source_equals (DataSource* self,
                             DataSource* source);
VALA_EXTERN guint64 media_source_get_filesize (MediaSource* self);
VALA_EXTERN guint64 media_source_get_master_filesize (MediaSource* self);
VALA_EXTERN GDateTime* media_source_get_exposure_time (MediaSource* self);
VALA_EXTERN gchar* media_source_get_basename (MediaSource* self);
VALA_EXTERN gchar* media_source_get_title (MediaSource* self);
VALA_EXTERN gchar* media_source_get_comment (MediaSource* self);
VALA_EXTERN void media_source_set_title (MediaSource* self,
                             const gchar* title);
VALA_EXTERN gboolean media_source_set_comment (MediaSource* self,
                                   const gchar* comment);
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN PhotoMetadata* photo_source_get_metadata (PhotoSource* self);
VALA_EXTERN void photo_rotate (Photo* self,
                   Rotation rotation);
VALA_EXTERN GdkPixbuf* photo_source_get_pixbuf (PhotoSource* self,
                                    Scaling* scaling,
                                    GError** error);
VALA_EXTERN gboolean photo_has_user_generated_metadata (Photo* self);
VALA_EXTERN void photo_set_user_metadata_for_export (Photo* self,
                                         PhotoMetadata* metadata);
VALA_EXTERN gboolean photo_exception_prohibits (PhotoException self,
                                    PhotoException exception);
VALA_EXTERN gboolean photo_exception_allows (PhotoException self,
                                 PhotoException exception);
static gpointer photo_cached_pixbuf_ref (gpointer instance);
static void photo_cached_pixbuf_unref (gpointer instance);
static GParamSpec* photo_param_spec_cached_pixbuf (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags) G_GNUC_UNUSED ;
static void photo_value_set_cached_pixbuf (GValue* value,
                                    gpointer v_object) G_GNUC_UNUSED ;
static void photo_value_take_cached_pixbuf (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED ;
static gpointer photo_value_get_cached_pixbuf (const GValue* value) G_GNUC_UNUSED ;
static GType photo_cached_pixbuf_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoCachedPixbuf, photo_cached_pixbuf_unref)
VALA_EXTERN BackingPhotoRow* backing_photo_row_new (void);
VALA_EXTERN BackingPhotoRow* backing_photo_row_construct (GType object_type);
static PhotoBackingReaders* photo_backing_readers_new (void);
static PhotoBackingReaders* photo_backing_readers_construct (GType object_type);
VALA_EXTERN Photo* photo_construct (GType object_type,
                        PhotoRow* row);
VALA_EXTERN PhotoSource* photo_source_construct (GType object_type,
                                     gint64 object_id);
VALA_EXTERN gchar* media_source_prep_title (const gchar* title);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType backing_photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BackingPhotoID* backing_photo_id_dup (const BackingPhotoID* self);
VALA_EXTERN void backing_photo_id_free (BackingPhotoID* self);
VALA_EXTERN gchar* media_source_prep_comment (const gchar* comment);
VALA_EXTERN gpointer photo_file_adapter_ref (gpointer instance);
VALA_EXTERN void photo_file_adapter_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_adapter (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_photo_file_adapter (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_photo_file_adapter (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_adapter (const GValue* value);
VALA_EXTERN GType photo_file_adapter_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileAdapter, photo_file_adapter_unref)
VALA_EXTERN GType photo_file_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileReader, photo_file_adapter_unref)
VALA_EXTERN PhotoFileReader* photo_file_format_create_reader (PhotoFileFormat self,
                                                  const gchar* filepath);
VALA_EXTERN gboolean is_string_empty (const gchar* s);
static BackingPhotoRow* photo_get_backing_row (Photo* self,
                                        BackingPhotoID* id);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType photo_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoTable, database_table_unref)
VALA_EXTERN PhotoTable* photo_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_table_detach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  GError** error);
VALA_EXTERN void photo_remove_all_transformations (Photo* self,
                                       gboolean notify);
VALA_EXTERN RawDeveloper* raw_developer_as_array (gint* result_length1);
VALA_EXTERN void photo_init_photo (void);
VALA_EXTERN void photo_terminate_photo (void);
static void photo_real_notify_editable_replaced (Photo* self,
                                          GFile* old_file,
                                          GFile* new_file);
static void photo_real_notify_raw_development_modified (Photo* self);
static void photo_real_notify_baseline_replaced (Photo* self);
static void photo_real_notify_master_reimported (Photo* self,
                                          PhotoMetadata* metadata);
static void photo_real_notify_editable_reimported (Photo* self,
                                            PhotoMetadata* metadata);
static void photo_real_notify_source_reimported (Photo* self,
                                          PhotoMetadata* metadata);
static void photo_real_notify_baseline_reimported (Photo* self,
                                            PhotoMetadata* metadata);
static gboolean photo_real_internal_delete_backing (DataSource* base,
                                             GError** error);
VALA_EXTERN GFile* photo_file_adapter_get_file (PhotoFileAdapter* self);
static void photo_detach_editable (Photo* self,
                            gboolean delete_editable,
                            gboolean remove_transformations,
                            gboolean notify);
VALA_EXTERN PhotoFileFormat photo_get_master_file_format (Photo* self);
static gboolean photo_delete_raw_development (Photo* self,
                                       RawDeveloper d);
VALA_EXTERN GType backing_photo_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackingPhotoTable, database_table_unref)
VALA_EXTERN BackingPhotoTable* backing_photo_table_get_instance (void);
VALA_EXTERN BackingPhotoRow* backing_photo_table_fetch (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            GError** error);
VALA_EXTERN void backing_photo_table_remove (BackingPhotoTable* self,
                                 BackingPhotoID* backing_id,
                                 GError** error);
VALA_EXTERN gboolean photo_is_raw_developer_complete (Photo* self,
                                          RawDeveloper d);
VALA_EXTERN gboolean photo_is_raw_developer_available (Photo* self,
                                           RawDeveloper d);
VALA_EXTERN PhotoMetadata* photo_get_master_metadata (Photo* self,
                                          GError** error);
VALA_EXTERN guint photo_metadata_get_preview_count (PhotoMetadata* self);
VALA_EXTERN gpointer photo_preview_ref (gpointer instance);
VALA_EXTERN void photo_preview_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_preview (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_photo_preview (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_photo_preview (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_photo_preview (const GValue* value);
VALA_EXTERN GType photo_preview_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoPreview, photo_preview_unref)
VALA_EXTERN PhotoPreview* photo_metadata_get_preview (PhotoMetadata* self,
                                          guint number);
VALA_EXTERN void photo_preview_get_pixel_dimensions (PhotoPreview* self,
                                         Dimensions* result);
VALA_EXTERN void photo_add_backing_photo_for_development (Photo* self,
                                              RawDeveloper d,
                                              BackingPhotoRow* bpr,
                                              gboolean notify,
                                              GError** error);
VALA_EXTERN void photo_import_developed_backing_photo (PhotoRow* row,
                                           RawDeveloper d,
                                           BackingPhotoRow* bpr,
                                           GError** error);
VALA_EXTERN void data_object_notify_altered (DataObject* self,
                                 Alteration* alteration);
VALA_EXTERN Alteration* alteration_new (const gchar* subject,
                            const gchar* detail);
VALA_EXTERN Alteration* alteration_construct (GType object_type,
                                  const gchar* subject,
                                  const gchar* detail);
VALA_EXTERN GDateTime* coarsify_date_time (GDateTime* dt);
VALA_EXTERN gpointer photo_file_interrogator_ref (gpointer instance);
VALA_EXTERN void photo_file_interrogator_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_interrogator (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void value_set_photo_file_interrogator (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void value_take_photo_file_interrogator (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_interrogator (const GValue* value);
VALA_EXTERN GType photo_file_interrogator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileInterrogator, photo_file_interrogator_unref)
VALA_EXTERN PhotoFileInterrogator* photo_file_interrogator_new (GFile* file,
                                                    PhotoFileSnifferOptions options);
VALA_EXTERN PhotoFileInterrogator* photo_file_interrogator_construct (GType object_type,
                                                          GFile* file,
                                                          PhotoFileSnifferOptions options);
VALA_EXTERN void photo_file_interrogator_interrogate (PhotoFileInterrogator* self,
                                          GError** error);
VALA_EXTERN gpointer detected_photo_information_ref (gpointer instance);
VALA_EXTERN void detected_photo_information_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_detected_photo_information (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void value_set_detected_photo_information (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void value_take_detected_photo_information (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer value_get_detected_photo_information (const GValue* value);
VALA_EXTERN GType detected_photo_information_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DetectedPhotoInformation, detected_photo_information_unref)
VALA_EXTERN DetectedPhotoInformation* photo_file_interrogator_get_detected_photo_information (PhotoFileInterrogator* self);
VALA_EXTERN gboolean photo_file_interrogator_get_is_photo_corrupted (PhotoFileInterrogator* self);
VALA_EXTERN Orientation photo_metadata_get_orientation (PhotoMetadata* self);
VALA_EXTERN void backing_photo_table_add (BackingPhotoTable* self,
                              BackingPhotoRow* state,
                              GError** error);
VALA_EXTERN void photo_table_update_raw_development (PhotoTable* self,
                                         PhotoRow* row,
                                         RawDeveloper rd,
                                         BackingPhotoID* backing_photo_id,
                                         GError** error);
static void photo_develop_photo (Photo* self,
                          RawDeveloper d,
                          gboolean notify);
VALA_EXTERN BackingPhotoRow* raw_developer_create_backing_row_for_development (RawDeveloper self,
                                                                   const gchar* raw_filepath,
                                                                   const gchar* camera_development_filename,
                                                                   GError** error);
VALA_EXTERN GdkPixbuf* photo_get_master_pixbuf (Photo* self,
                                    Scaling* scaling,
                                    gboolean rotate,
                                    GError** error);
VALA_EXTERN void scaling_for_original (Scaling* result);
VALA_EXTERN GType photo_file_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileWriter, photo_file_adapter_unref)
VALA_EXTERN GQuark photo_format_error_quark (void);
VALA_EXTERN GType photo_format_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoFileWriter* photo_file_format_create_writer (PhotoFileFormat self,
                                                  const gchar* filepath,
                                                  GError** error);
VALA_EXTERN GType jpeg_quality_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_file_writer_write (PhotoFileWriter* self,
                              GdkPixbuf* pixbuf,
                              JpegQuality quality,
                              GError** error);
VALA_EXTERN GType photo_file_metadata_writer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileMetadataWriter, photo_file_adapter_unref)
VALA_EXTERN PhotoFileMetadataWriter* photo_file_format_create_metadata_writer (PhotoFileFormat self,
                                                                   const gchar* filepath,
                                                                   GError** error);
VALA_EXTERN void photo_file_metadata_writer_write_metadata (PhotoFileMetadataWriter* self,
                                                PhotoMetadata* metadata,
                                                GError** error);
VALA_EXTERN GBytes* photo_preview_flatten (PhotoPreview* self,
                               GError** error);
VALA_EXTERN gboolean jpeg_is_jpeg_bytes (GBytes* bytes,
                             GError** error);
VALA_EXTERN GdkPixbuf* photo_preview_get_pixbuf (PhotoPreview* self,
                                     GError** error);
VALA_EXTERN void photo_set_default_raw_developer (Photo* self,
                                      RawDeveloper d);
VALA_EXTERN void photo_set_raw_developer (Photo* self,
                              RawDeveloper d,
                              gboolean notify);
VALA_EXTERN void photo_revert_to_master (Photo* self,
                             gboolean notify);
VALA_EXTERN GdkPixbuf* photo_get_prefetched_copy (Photo* self,
                                      GError** error);
VALA_EXTERN gboolean photo_set_orientation (Photo* self,
                                Orientation orientation);
VALA_EXTERN void photo_discard_prefetched (Photo* self);
VALA_EXTERN RawDeveloper photo_get_raw_developer (Photo* self);
VALA_EXTERN gchar* raw_developer_to_string (RawDeveloper self);
VALA_EXTERN void photo_table_remove_development (PhotoTable* self,
                                     PhotoRow* row,
                                     RawDeveloper rd,
                                     GError** error);
VALA_EXTERN void photo_redevelop_raw (Photo* self,
                          RawDeveloper d);
static BackingFileState** photo_real_get_backing_files_state (MediaSource* base,
                                                       gint* result_length1);
VALA_EXTERN BackingFileState* backing_file_state_new_from_photo_row (BackingPhotoRow* photo_row,
                                                         const gchar* md5);
VALA_EXTERN BackingFileState* backing_file_state_construct_from_photo_row (GType object_type,
                                                               BackingPhotoRow* photo_row,
                                                               const gchar* md5);
static void _vala_array_add83 (BackingFileState** * array,
                        gint* length,
                        gint* size,
                        BackingFileState* value);
VALA_EXTERN gboolean photo_has_editable (Photo* self);
static void _vala_array_add84 (BackingFileState** * array,
                        gint* length,
                        gint* size,
                        BackingFileState* value);
VALA_EXTERN gboolean photo_is_developed (Photo* self);
VALA_EXTERN GeeCollection* photo_get_raw_development_photo_rows (Photo* self);
static void _vala_array_add85 (BackingFileState** * array,
                        gint* length,
                        gint* size,
                        BackingFileState* value);
static PhotoFileReader* photo_get_backing_reader (Photo* self,
                                           BackingFetchMode mode);
static PhotoFileReader* photo_get_master_reader (Photo* self);
static PhotoFileReader* photo_get_baseline_reader (Photo* self);
static PhotoFileReader* photo_get_source_reader (Photo* self);
static PhotoFileReader* photo_get_raw_developer_reader (Photo* self);
VALA_EXTERN PhotoFileReader* photo_get_editable_reader (Photo* self);
VALA_EXTERN gboolean photo_does_master_exist (Photo* self);
VALA_EXTERN gboolean photo_file_adapter_file_exists (PhotoFileAdapter* self);
VALA_EXTERN gboolean photo_does_editable_exist (Photo* self);
VALA_EXTERN gboolean photo_is_master_baseline (Photo* self);
VALA_EXTERN gboolean photo_is_master_source (Photo* self);
VALA_EXTERN gboolean photo_is_editable_baseline (Photo* self);
VALA_EXTERN gboolean photo_is_editable_source (Photo* self);
VALA_EXTERN BackingPhotoRow* photo_get_master_photo_row (Photo* self);
VALA_EXTERN BackingPhotoRow* photo_get_editable_photo_row (Photo* self);
VALA_EXTERN gboolean backing_photo_id_is_valid (BackingPhotoID *self);
VALA_EXTERN BackingPhotoRow* photo_get_raw_development_photo_row (Photo* self,
                                                      RawDeveloper d);
VALA_EXTERN PhotoFileFormat* photo_get_editable_file_format (Photo* self);
VALA_EXTERN PhotoFileFormat photo_file_adapter_get_file_format (PhotoFileAdapter* self);
static PhotoFileFormat* _photo_file_format_dup (PhotoFileFormat* self);
VALA_EXTERN GType export_format_parameters_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType export_format_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ExportFormatParameters* export_format_parameters_dup (const ExportFormatParameters* self);
VALA_EXTERN void export_format_parameters_free (ExportFormatParameters* self);
VALA_EXTERN PhotoFileFormat photo_get_export_format_for_parameters (Photo* self,
                                                        ExportFormatParameters* params);
VALA_EXTERN PhotoFileFormat photo_file_format_get_system_default_format (void);
VALA_EXTERN PhotoFileFormat photo_get_best_export_file_format (Photo* self);
VALA_EXTERN gchar* photo_get_export_basename_for_parameters (Photo* self,
                                                 ExportFormatParameters* params);
VALA_EXTERN gchar* photo_get_export_basename (Photo* self,
                                  PhotoFileFormat* file_format);
VALA_EXTERN GType import_result_get_type (void) G_GNUC_CONST ;
VALA_EXTERN ImportResult photo_prepare_for_import (PhotoImportParams* params);
VALA_EXTERN gboolean photo_is_file_image (GFile* file);
VALA_EXTERN gboolean photo_file_format_is_file_supported (GFile* file);
VALA_EXTERN MetadataDateTime* photo_metadata_get_exposure_date_time (PhotoMetadata* self);
VALA_EXTERN void photo_metadata_get_gps_coords (PhotoMetadata* self,
                                    GpsCoords* result);
VALA_EXTERN GeeSet* photo_metadata_get_keywords (PhotoMetadata* self,
                                     GCompareDataFunc compare_func,
                                     gpointer compare_func_target,
                                     GDestroyNotify compare_func_target_destroy_notify);
VALA_EXTERN Rating photo_metadata_get_rating (PhotoMetadata* self);
VALA_EXTERN void photo_id_init (PhotoID *self,
                    gint64 id);
VALA_EXTERN void event_id_init (EventID *self,
                    gint64 id);
VALA_EXTERN GType photo_file_reader_role_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_file_reader_set_role (PhotoFileReader* self,
                                 PhotoFileReaderRole role);
VALA_EXTERN void thumbnail_cache_generate_for_photo (Thumbnails* thumbnails,
                                         PhotoFileReader* reader,
                                         Orientation orientation,
                                         Dimensions* original_dim,
                                         GError** error);
VALA_EXTERN ImportResult import_result_convert_error (GError* err,
                                          ImportResult default_result);
VALA_EXTERN void photo_create_pre_import (PhotoImportParams* params);
VALA_EXTERN void dimensions_init (Dimensions *self,
                      gint width,
                      gint height);
VALA_EXTERN BackingPhotoRow* photo_query_backing_photo_row (Photo* self,
                                                GFile* file,
                                                PhotoFileSnifferOptions options,
                                                DetectedPhotoInformation** detected,
                                                GError** error);
VALA_EXTERN gpointer photo_reimport_master_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_master_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_master_state (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_master_state (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_master_state (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_master_state (const GValue* value);
VALA_EXTERN GType photo_reimport_master_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportMasterState, photo_reimport_master_state_unref)
VALA_EXTERN gboolean photo_prepare_for_reimport_master (Photo* self,
                                            PhotoReimportMasterState** reimport_state,
                                            GError** error);
static void _vala_array_add86 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add87 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add88 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add89 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static gboolean _gps_coords_equal (const GpsCoords * s1,
                            const GpsCoords * s2);
static void _vala_array_add90 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add91 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add92 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_new (PhotoRow* row,
                                                                    PhotoMetadata* metadata,
                                                                    gchar** alterations,
                                                                    gint alterations_length1);
static PhotoReimportMasterStateImpl* photo_reimport_master_state_impl_construct (GType object_type,
                                                                          PhotoRow* row,
                                                                          PhotoMetadata* metadata,
                                                                          gchar** alterations,
                                                                          gint alterations_length1);
static GType photo_reimport_master_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportMasterStateImpl, photo_reimport_master_state_unref)
static void photo_real_apply_user_metadata_for_reimport (Photo* self,
                                                  PhotoMetadata* metadata);
VALA_EXTERN void photo_finish_reimport_master (Photo* self,
                                   PhotoReimportMasterState* state,
                                   GError** error);
VALA_EXTERN void photo_table_reimport (PhotoTable* self,
                           PhotoRow* row,
                           GError** error);
VALA_EXTERN void backing_photo_row_copy_from (BackingPhotoRow* self,
                                  BackingPhotoRow* from);
static void _vala_array_add93 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add94 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN Alteration* alteration_new_from_array (gchar** array,
                                       gint array_length1);
VALA_EXTERN Alteration* alteration_construct_from_array (GType object_type,
                                             gchar** array,
                                             gint array_length1);
static gboolean photo_verify_file_for_reimport (Photo* self,
                                         GFile* file,
                                         BackingPhotoRow** backing,
                                         DetectedPhotoInformation** detected,
                                         GError** error);
VALA_EXTERN gpointer photo_reimport_editable_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_editable_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_editable_state (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_editable_state (GValue* value,
                                              gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_editable_state (GValue* value,
                                               gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_editable_state (const GValue* value);
VALA_EXTERN GType photo_reimport_editable_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportEditableState, photo_reimport_editable_state_unref)
VALA_EXTERN gboolean photo_prepare_for_reimport_editable (Photo* self,
                                              PhotoReimportEditableState** state,
                                              GError** error);
VALA_EXTERN GFile* photo_get_editable_file (Photo* self);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state,
                                                                        PhotoMetadata* metadata);
static PhotoReimportEditableStateImpl* photo_reimport_editable_state_impl_construct (GType object_type,
                                                                              BackingPhotoRow* backing_state,
                                                                              PhotoMetadata* metadata);
static GType photo_reimport_editable_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportEditableStateImpl, photo_reimport_editable_state_unref)
VALA_EXTERN void photo_finish_reimport_editable (Photo* self,
                                     PhotoReimportEditableState* state,
                                     GError** error);
VALA_EXTERN void photo_get_editable_id (Photo* self,
                            BackingPhotoID* result);
VALA_EXTERN gboolean backing_photo_id_is_invalid (BackingPhotoID *self);
VALA_EXTERN void backing_photo_table_update (BackingPhotoTable* self,
                                 BackingPhotoRow* row,
                                 GError** error);
VALA_EXTERN void positionable_set_gps_coords (Positionable* self,
                                  GpsCoords* gps_coords);
VALA_EXTERN Alteration* alteration_new_from_list (const gchar* list);
VALA_EXTERN Alteration* alteration_construct_from_list (GType object_type,
                                            const gchar* list);
VALA_EXTERN gpointer photo_reimport_raw_development_state_ref (gpointer instance);
VALA_EXTERN void photo_reimport_raw_development_state_unref (gpointer instance);
VALA_EXTERN GParamSpec* photo_param_spec_reimport_raw_development_state (const gchar* name,
                                                             const gchar* nick,
                                                             const gchar* blurb,
                                                             GType object_type,
                                                             GParamFlags flags);
VALA_EXTERN void photo_value_set_reimport_raw_development_state (GValue* value,
                                                     gpointer v_object);
VALA_EXTERN void photo_value_take_reimport_raw_development_state (GValue* value,
                                                      gpointer v_object);
VALA_EXTERN gpointer photo_value_get_reimport_raw_development_state (const GValue* value);
VALA_EXTERN GType photo_reimport_raw_development_state_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportRawDevelopmentState, photo_reimport_raw_development_state_unref)
VALA_EXTERN gboolean photo_prepare_for_reimport_raw_development (Photo* self,
                                                     PhotoReimportRawDevelopmentState** state,
                                                     GError** error);
VALA_EXTERN GeeCollection* photo_get_raw_developer_files (Photo* self);
static GType photo_reimport_raw_development_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportRawDevelopmentStateImpl, photo_reimport_raw_development_state_unref)
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_new (void);
static PhotoReimportRawDevelopmentStateImpl* photo_reimport_raw_development_state_impl_construct (GType object_type);
static void photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self,
                                                    BackingPhotoRow* backing,
                                                    PhotoMetadata* metadata);
static gint photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self);
VALA_EXTERN void photo_finish_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState* state,
                                            GError** error);
static gpointer photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance);
static GParamSpec* photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name,
                                                                                  const gchar* nick,
                                                                                  const gchar* blurb,
                                                                                  GType object_type,
                                                                                  GParamFlags flags) G_GNUC_UNUSED ;
static void photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value,
                                                                          gpointer v_object) G_GNUC_UNUSED ;
static void photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value,
                                                                           gpointer v_object) G_GNUC_UNUSED ;
static gpointer photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value) G_GNUC_UNUSED ;
VALA_EXTERN GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoReimportRawDevelopmentStateImplDevToReimport, photo_reimport_raw_development_state_impl_dev_to_reimport_unref)
static gchar* photo_real_get_typename (DataSource* base);
static gint64 photo_real_get_instance_id (DataSource* base);
VALA_EXTERN void photo_get_photo_id (Photo* self,
                         PhotoID* result);
static gchar* photo_real_get_source_id (DataSource* base);
VALA_EXTERN void photo_set_master_timestamp (Photo* self,
                                 GFileInfo* info);
VALA_EXTERN void photo_table_update_timestamp (PhotoTable* self,
                                   PhotoID* photo_id,
                                   GDateTime* timestamp,
                                   GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN void photo_update_editable_modification_time (Photo* self,
                                              GFileInfo* info,
                                              GError** error);
VALA_EXTERN void backing_photo_table_update_timestamp (BackingPhotoTable* self,
                                           BackingPhotoID* id,
                                           GDateTime* timestamp,
                                           GError** error);
VALA_EXTERN void photo_update_many_editable_timestamps (GeeMap* map,
                                            GError** error);
VALA_EXTERN void database_table_begin_transaction (void);
VALA_EXTERN void database_table_commit_transaction (GError** error);
static PhotoFileFormat photo_real_get_preferred_thumbnail_format (ThumbnailSource* base);
VALA_EXTERN PhotoFileFormat photo_get_file_format (Photo* self);
VALA_EXTERN gboolean photo_file_format_can_write_image (PhotoFileFormat self);
static GdkPixbuf* photo_real_create_thumbnail (ThumbnailSource* base,
                                        gint scale,
                                        GError** error);
VALA_EXTERN void scaling_for_best_fit (gint pixels,
                           gboolean scale_up,
                           Scaling* result);
static gboolean photo_is_extension_found (const gchar* basename,
                                   gchar** extensions,
                                   gint extensions_length1);
VALA_EXTERN void disassemble_filename (const gchar* basename,
                           gchar** name,
                           gchar** ext);
VALA_EXTERN gboolean photo_is_duplicate (GFile* file,
                             const gchar* thumbnail_md5,
                             const gchar* full_md5,
                             PhotoFileFormat file_format);
VALA_EXTERN gboolean photo_table_has_duplicate (PhotoTable* self,
                                    GFile* file,
                                    const gchar* thumbnail_md5,
                                    const gchar* md5,
                                    PhotoFileFormat file_format);
VALA_EXTERN PhotoID* photo_get_duplicate_ids (GFile* file,
                                  const gchar* thumbnail_md5,
                                  const gchar* full_md5,
                                  PhotoFileFormat file_format,
                                  gint* result_length1);
VALA_EXTERN PhotoID* photo_table_get_duplicate_ids (PhotoTable* self,
                                        GFile* file,
                                        const gchar* thumbnail_md5,
                                        const gchar* md5,
                                        PhotoFileFormat file_format,
                                        gint* result_length1);
VALA_EXTERN gint64 photo_get_photo_key (DataSource* source);
VALA_EXTERN GType library_photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhoto, g_object_unref)
static GFile* photo_real_get_file (MediaSource* base);
VALA_EXTERN void photo_set_master_file (Photo* self,
                            GFile* file);
VALA_EXTERN void photo_table_set_filepath (PhotoTable* self,
                               PhotoID* photo_id,
                               const gchar* filepath,
                               GError** error);
VALA_EXTERN void media_source_notify_master_replaced (MediaSource* self,
                                          GFile* old_file,
                                          GFile* new_file);
static void _vala_array_add95 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add96 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add97 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add98 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
VALA_EXTERN void photo_set_editable_file (Photo* self,
                              GFile* file);
VALA_EXTERN void backing_photo_table_set_filepath (BackingPhotoTable* self,
                                       BackingPhotoID* id,
                                       const gchar* filepath,
                                       GError** error);
static void _vala_array_add99 (gchar** * array,
                        gint* length,
                        gint* size,
                        gchar* value);
static void _vala_array_add100 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
static void _vala_array_add101 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
VALA_EXTERN void photo_set_many_editable_file (GeeMap* map,
                                   GError** error);
VALA_EXTERN GFile* photo_get_actual_file (Photo* self);
static GFile* photo_real_get_master_file (MediaSource* base);
VALA_EXTERN GFile* photo_get_source_file (Photo* self);
VALA_EXTERN gboolean photo_file_format_can_write (PhotoFileFormat self);
static GDateTime* photo_real_get_timestamp (MediaSource* base);
static inline void photo_real_get_event_id (MediaSource* base,
                              EventID* result);
VALA_EXTERN gint64 photo_get_raw_event_id (Photo* self);
static void photo_real_get_import_id (MediaSource* base,
                               ImportID* result);
static gchar* photo_real_get_master_md5 (MediaSource* base);
VALA_EXTERN guint64 photo_get_flags (Photo* self);
static void photo_notify_flags_altered (Photo* self,
                                 Alteration* additional_alteration);
VALA_EXTERN Alteration* alteration_compress (Alteration* self,
                                 Alteration* other);
VALA_EXTERN guint64 photo_replace_flags (Photo* self,
                             guint64 flags,
                             Alteration* additional_alteration);
VALA_EXTERN gboolean photo_table_replace_flags (PhotoTable* self,
                                    PhotoID* photo_id,
                                    guint64 flags);
VALA_EXTERN gboolean photo_is_flag_set (Photo* self,
                            guint64 mask);
VALA_EXTERN gboolean media_source_internal_is_flag_set (guint64 flags,
                                            guint64 selector);
VALA_EXTERN guint64 photo_add_flags (Photo* self,
                         guint64 mask,
                         Alteration* additional_alteration);
VALA_EXTERN guint64 media_source_internal_add_flags (guint64 flags,
                                         guint64 selector);
VALA_EXTERN guint64 photo_remove_flags (Photo* self,
                            guint64 mask,
                            Alteration* additional_alteration);
VALA_EXTERN guint64 media_source_internal_remove_flags (guint64 flags,
                                            guint64 selector);
VALA_EXTERN guint64 photo_add_remove_flags (Photo* self,
                                guint64 add,
                                guint64 remove,
                                Alteration* additional_alteration);
VALA_EXTERN void photo_add_remove_many_flags (GeeCollection* add,
                                  guint64 add_mask,
                                  Alteration* additional_add_alteration,
                                  GeeCollection* remove,
                                  guint64 remove_mask,
                                  Alteration* additional_remove_alteration,
                                  GError** error);
VALA_EXTERN guint64 photo_toggle_flags (Photo* self,
                            guint64 mask,
                            Alteration* additional_alteration);
VALA_EXTERN gboolean photo_is_master_metadata_dirty (Photo* self);
VALA_EXTERN void photo_set_master_metadata_dirty (Photo* self,
                                      gboolean dirty,
                                      GError** error);
VALA_EXTERN void photo_table_set_metadata_dirty (PhotoTable* self,
                                     PhotoID* photo_id,
                                     gboolean dirty,
                                     GError** error);
static Rating photo_real_get_rating (MediaSource* base);
static void photo_real_set_rating (MediaSource* base,
                            Rating rating);
VALA_EXTERN gboolean photo_table_set_rating (PhotoTable* self,
                                 PhotoID* photo_id,
                                 Rating rating);
static void photo_real_increase_rating (MediaSource* base);
static void photo_real_decrease_rating (MediaSource* base);
static void photo_real_commit_backlinks (DataSource* base,
                                  SourceCollection* sources,
                                  const gchar* backlinks);
VALA_EXTERN void photo_table_update_backlinks (PhotoTable* self,
                                   PhotoID* photo_id,
                                   const gchar* backlinks,
                                   GError** error);
static gboolean photo_real_set_event_id (MediaSource* base,
                                  EventID* event_id);
VALA_EXTERN gboolean photo_table_set_event (PhotoTable* self,
                                PhotoID* photo_id,
                                EventID* event_id);
static gchar* photo_real_to_string (DataObject* base);
VALA_EXTERN gchar* photo_file_adapter_get_filepath (PhotoFileAdapter* self);
static gboolean photo_real_equals (DataSource* base,
                            DataSource* source);
static void photo_file_exif_updated (Photo* self);
VALA_EXTERN gboolean photo_table_master_exif_updated (PhotoTable* self,
                                          PhotoID* photoID,
                                          gint64 filesize,
                                          GDateTime* timestamp,
                                          const gchar* md5,
                                          const gchar* exif_md5,
                                          const gchar* thumbnail_md5,
                                          PhotoRow* row);
static guint64 photo_real_get_filesize (MediaSource* base);
static guint64 photo_real_get_master_filesize (MediaSource* base);
VALA_EXTERN guint64 photo_get_editable_filesize (Photo* self);
static GDateTime* photo_real_get_exposure_time (Dateable* base);
static gchar* photo_real_get_basename (MediaSource* base);
static gchar* photo_real_get_title (MediaSource* base);
static gchar* photo_real_get_comment (MediaSource* base);
static void photo_real_set_title (MediaSource* base,
                           const gchar* title);
VALA_EXTERN gboolean photo_table_set_title (PhotoTable* self,
                                PhotoID* photo_id,
                                const gchar* new_title);
static void photo_real_get_gps_coords (Positionable* base,
                                GpsCoords* result);
static void photo_real_set_gps_coords (Positionable* base,
                                GpsCoords* gps_coords);
VALA_EXTERN void photo_table_set_gps_coords (PhotoTable* self,
                                 PhotoID* photo_id,
                                 GpsCoords* new_gps_coords,
                                 GError** error);
static gboolean photo_real_set_comment (MediaSource* base,
                                 const gchar* comment);
VALA_EXTERN gboolean photo_table_set_comment (PhotoTable* self,
                                  PhotoID* photo_id,
                                  const gchar* new_comment);
VALA_EXTERN void photo_set_import_id (Photo* self,
                          ImportID* import_id);
VALA_EXTERN void photo_table_set_import_id (PhotoTable* self,
                                PhotoID* photo_id,
                                ImportID* import_id,
                                GError** error);
VALA_EXTERN void photo_set_title_persistent (Photo* self,
                                 const gchar* title,
                                 GError** error);
VALA_EXTERN gboolean photo_file_format_can_write_metadata (PhotoFileFormat self);
VALA_EXTERN PhotoMetadata* photo_file_reader_read_metadata (PhotoFileReader* self,
                                                GError** error);
VALA_EXTERN GType photo_metadata_set_option_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void photo_metadata_set_title (PhotoMetadata* self,
                               const gchar* title,
                               PhotoMetadataSetOption option);
VALA_EXTERN PhotoFileMetadataWriter* photo_file_reader_create_metadata_writer (PhotoFileReader* self,
                                                                   GError** error);
VALA_EXTERN void library_monitor_blacklist_file (GFile* file,
                                     const gchar* reason);
VALA_EXTERN void library_monitor_unblacklist_file (GFile* file);
VALA_EXTERN void photo_set_comment_persistent (Photo* self,
                                   const gchar* comment,
                                   GError** error);
VALA_EXTERN void photo_metadata_set_comment (PhotoMetadata* self,
                                 const gchar* comment,
                                 PhotoMetadataSetOption option);
static void photo_real_set_exposure_time (Dateable* base,
                                   GDateTime* time);
VALA_EXTERN gboolean photo_table_set_exposure_time (PhotoTable* self,
                                        PhotoID* photo_id,
                                        GDateTime* time);
VALA_EXTERN void photo_set_exposure_time_persistent (Photo* self,
                                         GDateTime* time,
                                         GError** error);
VALA_EXTERN void dateable_set_exposure_time (Dateable* self,
                                 GDateTime* target_time);
VALA_EXTERN void photo_metadata_set_exposure_date_time (PhotoMetadata* self,
                                            MetadataDateTime* date_time,
                                            PhotoMetadataSetOption option);
static void photo_real_get_dimensions (MediaSource* base,
                                PhotoException disallowed_steps,
                                Dimensions* result);
VALA_EXTERN void photo_get_raw_dimensions (Photo* self,
                               Dimensions* result);
VALA_EXTERN Orientation photo_get_orientation (Photo* self);
VALA_EXTERN gboolean photo_get_straighten (Photo* self,
                               gdouble* theta);
VALA_EXTERN void compute_arb_rotated_size (gdouble src_width,
                               gdouble src_height,
                               gdouble angle,
                               gdouble* dest_width,
                               gdouble* dest_height);
VALA_EXTERN GType box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Box* box_dup (const Box* self);
VALA_EXTERN void box_free (Box* self);
VALA_EXTERN gboolean photo_get_crop (Photo* self,
                         Box* crop,
                         PhotoException exceptions);
VALA_EXTERN void box_get_dimensions (Box *self,
                         Dimensions* result);
static void photo_locked_create_adjustments_from_data (Photo* self);
static KeyValueMap* photo_get_transformation (Photo* self,
                                       const gchar* name);
VALA_EXTERN PixelTransformationBundle* photo_get_color_adjustments (Photo* self);
VALA_EXTERN PixelTransformer* photo_get_pixel_transformer (Photo* self);
VALA_EXTERN gboolean photo_has_color_adjustments (Photo* self);
static gboolean photo_has_transformation (Photo* self,
                                   const gchar* name);
VALA_EXTERN PixelTransformation* photo_get_color_adjustment (Photo* self,
                                                 PixelTransformationType type);
VALA_EXTERN void photo_set_color_adjustments (Photo* self,
                                  PixelTransformationBundle* new_adjustments);
static gboolean photo_remove_transformation (Photo* self,
                                      const gchar* name);
static gboolean photo_set_transformation (Photo* self,
                                   KeyValueMap* trans);
static PhotoMetadata* photo_real_get_metadata (PhotoSource* base);
VALA_EXTERN PhotoMetadata* photo_get_editable_metadata (Photo* self,
                                            GError** error);
VALA_EXTERN gboolean photo_persist_master_metadata (Photo* self,
                                        PhotoMetadata* metadata,
                                        PhotoReimportMasterState** state,
                                        GError** error);
VALA_EXTERN void photo_finish_update_master_metadata (Photo* self,
                                          PhotoReimportMasterState* state,
                                          GError** error);
VALA_EXTERN gboolean photo_persist_editable_metadata (Photo* self,
                                          PhotoMetadata* metadata,
                                          PhotoReimportEditableState** state,
                                          GError** error);
VALA_EXTERN void photo_finish_update_editable_metadata (Photo* self,
                                            PhotoReimportEditableState* state,
                                            GError** error);
VALA_EXTERN gboolean photo_has_transformations (Photo* self);
VALA_EXTERN gboolean photo_only_metadata_changed (Photo* self);
VALA_EXTERN gboolean photo_has_alterations (Photo* self);
VALA_EXTERN gint64 nullsafe_date_time_comperator (GDateTime* time_a,
                                      GDateTime* time_b);
VALA_EXTERN PhotoTransformationState* photo_save_transformation_state (Photo* self);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_new (Photo* photo,
                                                                              Orientation orientation,
                                                                              GeeHashMap* transformations,
                                                                              PixelTransformer* transformer,
                                                                              PixelTransformationBundle* adjustments);
static PhotoPhotoTransformationStateImpl* photo_photo_transformation_state_impl_construct (GType object_type,
                                                                                    Photo* photo,
                                                                                    Orientation orientation,
                                                                                    GeeHashMap* transformations,
                                                                                    PixelTransformer* transformer,
                                                                                    PixelTransformationBundle* adjustments);
static GType photo_photo_transformation_state_impl_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoPhotoTransformationStateImpl, g_object_unref)
VALA_EXTERN gboolean photo_load_transformation_state (Photo* self,
                                          PhotoTransformationState* state);
static Orientation photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self);
static GeeHashMap* photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self);
static PixelTransformer* photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self);
static PixelTransformationBundle* photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self);
VALA_EXTERN gboolean photo_table_set_transformation_state (PhotoTable* self,
                                               PhotoID* photo_id,
                                               Orientation orientation,
                                               GeeHashMap* transformations);
VALA_EXTERN gboolean photo_table_remove_all_transformations (PhotoTable* self,
                                                 PhotoID* photo_id);
VALA_EXTERN gboolean photo_table_set_orientation (PhotoTable* self,
                                      PhotoID* photo_id,
                                      Orientation orientation);
VALA_EXTERN Orientation photo_get_original_orientation (Photo* self);
VALA_EXTERN gboolean photo_check_can_rotate (Photo* self);
static void photo_real_rotate (Photo* self,
                        Rotation rotation);
VALA_EXTERN Orientation orientation_perform (Orientation self,
                                 Rotation rotation);
VALA_EXTERN gboolean photo_table_set_transformation (PhotoTable* self,
                                         PhotoID* photo_id,
                                         KeyValueMap* map);
VALA_EXTERN gboolean photo_table_remove_transformation (PhotoTable* self,
                                            PhotoID* photo_id,
                                            const gchar* object);
VALA_EXTERN gboolean photo_has_crop (Photo* self);
VALA_EXTERN gboolean photo_get_raw_crop (Photo* self,
                             Box* crop);
VALA_EXTERN void box_init (Box *self,
               gint left,
               gint top,
               gint right,
               gint bottom);
static void photo_set_raw_crop (Photo* self,
                         Box* crop);
static gboolean photo_get_raw_straighten (Photo* self,
                                   gdouble* angle);
static void photo_set_raw_straighten (Photo* self,
                               gdouble theta);
VALA_EXTERN GType editing_tools_redeye_instance_get_type (void) G_GNUC_CONST ;
VALA_EXTERN EditingToolsRedeyeInstance* editing_tools_redeye_instance_dup (const EditingToolsRedeyeInstance* self);
VALA_EXTERN void editing_tools_redeye_instance_free (EditingToolsRedeyeInstance* self);
static EditingToolsRedeyeInstance* photo_get_raw_redeye_instances (Photo* self,
                                                            gint* result_length1);
VALA_EXTERN gboolean photo_has_redeye_transformations (Photo* self);
VALA_EXTERN void photo_add_redeye_instance (Photo* self,
                                EditingToolsRedeyeInstance* redeye);
static gboolean photo_calculate_pixbuf_dimensions (Photo* self,
                                            Scaling* scaling,
                                            PhotoException exceptions,
                                            Dimensions* scaled_image,
                                            Dimensions* scaled_to_viewport);
static gboolean photo_locked_calculate_pixbuf_dimensions (Photo* self,
                                                   Scaling* scaling,
                                                   PhotoException exceptions,
                                                   Dimensions* scaled_image,
                                                   Dimensions* scaled_to_viewport);
VALA_EXTERN gboolean scaling_is_unscaled (Scaling *self);
VALA_EXTERN void orientation_rotate_box (Orientation self,
                             Dimensions* space,
                             Box* box,
                             Box* result);
VALA_EXTERN void orientation_rotate_dimensions (Orientation self,
                                    Dimensions* dim,
                                    Dimensions* result);
VALA_EXTERN void box_get_scaled (Box *self,
                     Dimensions* scaled,
                     Box* result);
VALA_EXTERN void scaling_get_scaled_dimensions (Scaling *self,
                                    Dimensions* original,
                                    Dimensions* result);
VALA_EXTERN gint box_get_width (Box *self);
VALA_EXTERN gint box_get_height (Box *self);
VALA_EXTERN void dimensions_get_scaled_similar (Dimensions *self,
                                    Dimensions* original,
                                    Dimensions* scaled,
                                    Dimensions* result);
VALA_EXTERN void orientation_derotate_dimensions (Orientation self,
                                      Dimensions* dim,
                                      Dimensions* result);
VALA_EXTERN gboolean dimensions_has_area (Dimensions *self);
static GdkPixbuf* photo_load_raw_pixbuf (Photo* self,
                                  Scaling* scaling,
                                  PhotoException exceptions,
                                  BackingFetchMode fetch_mode,
                                  GError** error);
VALA_EXTERN GdkPixbuf* photo_file_reader_unscaled_read (PhotoFileReader* self,
                                            GError** error);
VALA_EXTERN GdkPixbuf* photo_file_reader_scaled_read (PhotoFileReader* self,
                                          Dimensions* full,
                                          Dimensions* scaled,
                                          GError** error);
VALA_EXTERN gboolean dimensions_approx_equals (Dimensions *self,
                                   Dimensions* dim,
                                   gint fudge);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
static GdkPixbuf* photo_get_untransformed_pixbuf (Photo* self,
                                           Scaling* scaling,
                                           gboolean rotate,
                                           BackingFetchMode fetch_mode,
                                           GError** error);
VALA_EXTERN GdkPixbuf* photo_get_unmodified_pixbuf (Photo* self,
                                        Scaling* scaling,
                                        gboolean rotate,
                                        GError** error);
VALA_EXTERN GdkPixbuf* orientation_rotate_pixbuf (Orientation self,
                                      GdkPixbuf* pixbuf);
static GdkPixbuf* photo_real_get_pixbuf (PhotoSource* base,
                                  Scaling* scaling,
                                  GError** error);
VALA_EXTERN GdkPixbuf* photo_get_pixbuf_with_options (Photo* self,
                                          Scaling* scaling,
                                          PhotoException exceptions,
                                          BackingFetchMode fetch_mode,
                                          GError** error);
static GdkPixbuf* photo_run_source_pixbuf_cache (Photo* locate,
                                          gboolean keep,
                                          GError** error);
static PhotoCachedPixbuf* photo_cached_pixbuf_new (Photo* photo,
                                            GdkPixbuf* pixbuf);
static PhotoCachedPixbuf* photo_cached_pixbuf_construct (GType object_type,
                                                  Photo* photo,
                                                  GdkPixbuf* pixbuf);
static gboolean photo_trim_source_pixbuf_cache (void);
static gboolean _photo_trim_source_pixbuf_cache_gsource_func (gpointer self);
VALA_EXTERN gboolean photo_get_develop_raw_photos_to_files (void);
VALA_EXTERN gboolean dimensions_equals (Dimensions *self,
                            Dimensions* dim);
static GdkPixbuf* photo_do_redeye (Photo* self,
                            GdkPixbuf* pixbuf,
                            EditingToolsRedeyeInstance* inst);
VALA_EXTERN GdkPixbuf* rotate_arb (GdkPixbuf* source_pixbuf,
                       gdouble angle);
static gboolean photo_real_has_user_generated_metadata (Photo* self);
static void photo_real_set_user_metadata_for_export (Photo* self,
                                              PhotoMetadata* metadata);
VALA_EXTERN gpointer photo_file_format_properties_ref (gpointer instance);
VALA_EXTERN void photo_file_format_properties_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_photo_file_format_properties (const gchar* name,
                                                     const gchar* nick,
                                                     const gchar* blurb,
                                                     GType object_type,
                                                     GParamFlags flags);
VALA_EXTERN void value_set_photo_file_format_properties (GValue* value,
                                             gpointer v_object);
VALA_EXTERN void value_take_photo_file_format_properties (GValue* value,
                                              gpointer v_object);
VALA_EXTERN gpointer value_get_photo_file_format_properties (const GValue* value);
VALA_EXTERN GType photo_file_format_properties_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoFileFormatProperties, photo_file_format_properties_unref)
VALA_EXTERN PhotoFileFormatProperties* photo_file_format_get_properties (PhotoFileFormat self);
VALA_EXTERN GFile* photo_file_format_properties_convert_file_extension (PhotoFileFormatProperties* self,
                                                            GFile* file);
static gboolean photo_export_fullsized_backing (Photo* self,
                                         GFile* file,
                                         gboolean export_metadata,
                                         GError** error);
VALA_EXTERN PhotoMetadata* photo_file_format_create_metadata (PhotoFileFormat self);
VALA_EXTERN void photo_metadata_set_pixel_dimensions (PhotoMetadata* self,
                                          Dimensions* dim,
                                          PhotoMetadataSetOption option);
VALA_EXTERN void photo_metadata_set_orientation (PhotoMetadata* self,
                                     Orientation orientation);
VALA_EXTERN void photo_metadata_set_software (PhotoMetadata* self,
                                  const gchar* software,
                                  const gchar* version);
VALA_EXTERN void photo_metadata_remove_exif_thumbnail (PhotoMetadata* self);
VALA_EXTERN void photo_metadata_clear (PhotoMetadata* self);
VALA_EXTERN gboolean photo_is_export_required (Photo* self,
                                   Scaling* scaling,
                                   PhotoFileFormat export_format);
VALA_EXTERN void photo_export (Photo* self,
                   GFile* dest_file,
                   Scaling* scaling,
                   JpegQuality quality,
                   PhotoFileFormat export_format,
                   gboolean direct_copy_unmodified,
                   gboolean export_metadata,
                   GError** error);
VALA_EXTERN void photo_metadata_remove_tag (PhotoMetadata* self,
                                const gchar* tag);
static GFile* photo_generate_new_editable_file (Photo* self,
                                         PhotoFileFormat* file_format,
                                         GError** error);
VALA_EXTERN gboolean photo_file_format_properties_is_recognized_extension (PhotoFileFormatProperties* self,
                                                               const gchar* ext);
VALA_EXTERN gchar* photo_file_format_properties_get_default_extension (PhotoFileFormatProperties* self);
VALA_EXTERN GFile* generate_unique_file (GFile* dir,
                             const gchar* basename,
                             gboolean* collision,
                             GeeCollection* used,
                             GError** error);
static gboolean photo_launch_editor (GFile* file,
                              PhotoFileFormat file_format,
                              GError** error);
VALA_EXTERN GType configuration_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigurationFacade, g_object_unref)
VALA_EXTERN GType config_facade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigFacade, g_object_unref)
VALA_EXTERN ConfigFacade* config_facade_get_instance (void);
VALA_EXTERN gchar* configuration_facade_get_external_raw_app (ConfigurationFacade* self);
VALA_EXTERN gchar* configuration_facade_get_external_photo_app (ConfigurationFacade* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN void photo_open_with_raw_external_editor (Photo* self,
                                          GError** error);
VALA_EXTERN void photo_open_with_external_editor (Photo* self,
                                      GError** error);
static void photo_halt_monitoring_editable (Photo* self);
static void photo_attach_editable (Photo* self,
                            PhotoFileFormat file_format,
                            GFile* file,
                            GError** error);
static void photo_start_monitoring_editable (Photo* self,
                                      GFile* file,
                                      GError** error);
static void photo_on_editable_file_changed (Photo* self,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event);
static void _photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                             GFile* file,
                                                             GFile* other_file,
                                                             GFileMonitorEvent event_type,
                                                             gpointer self);
static void photo_update_editable (Photo* self,
                            gboolean only_attributes,
                            PhotoFileReader* new_reader,
                            GError** error);
static void photo_update_editable_attributes (Photo* self,
                                       GError** error);
VALA_EXTERN void photo_reimport_editable (Photo* self,
                              GError** error);
VALA_EXTERN void photo_table_attach_editable (PhotoTable* self,
                                  PhotoRow* row,
                                  BackingPhotoID* editable_id,
                                  GError** error);
VALA_EXTERN void backing_photo_table_update_attributes (BackingPhotoTable* self,
                                            BackingPhotoID* id,
                                            GDateTime* timestamp,
                                            gint64 filesize,
                                            GError** error);
static void _vala_array_add102 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
static void _vala_array_add103 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
static void _vala_array_add104 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
static void _vala_array_add105 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
static void _vala_array_add106 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
static void _vala_array_add107 (gchar** * array,
                         gint* length,
                         gint* size,
                         gchar* value);
VALA_EXTERN void backing_photo_id_init (BackingPhotoID *self,
                            gint64 id);
static void photo_on_reimport_editable (Photo* self);
static void _photo_on_reimport_editable_one_shot_callback (gpointer self);
VALA_EXTERN OneShotScheduler* one_shot_scheduler_new (const gchar* name,
                                          OneShotCallback callback,
                                          gpointer callback_target);
VALA_EXTERN OneShotScheduler* one_shot_scheduler_construct (GType object_type,
                                                const gchar* name,
                                                OneShotCallback callback,
                                                gpointer callback_target);
VALA_EXTERN void one_shot_scheduler_after_timeout (OneShotScheduler* self,
                                       guint msec,
                                       gboolean reschedule);
static void photo_on_update_editable_attributes (Photo* self);
static void _photo_on_update_editable_attributes_one_shot_callback (gpointer self);
static void photo_on_remove_editable (Photo* self);
static void _photo_on_remove_editable_one_shot_callback (gpointer self);
VALA_EXTERN void photo_get_original_dimensions (Photo* self,
                                    Dimensions* result);
VALA_EXTERN void photo_get_master_dimensions (Photo* self,
                                  Dimensions* result);
VALA_EXTERN void photo_set_crop (Photo* self,
                     Box* crop);
VALA_EXTERN void orientation_derotate_box (Orientation self,
                               Dimensions* space,
                               Box* box,
                               Box* result);
VALA_EXTERN void photo_set_straighten (Photo* self,
                           gdouble theta);
static GdkPixbuf* photo_red_reduce_pixel (Photo* self,
                                   GdkPixbuf* pixbuf,
                                   gint x,
                                   gint y);
VALA_EXTERN void photo_unscaled_to_raw_point (Photo* self,
                                  GdkPoint* unscaled_point,
                                  GdkPoint* result);
VALA_EXTERN void orientation_derotate_point (Orientation self,
                                 Dimensions* space,
                                 GdkPoint* point,
                                 GdkPoint* result);
VALA_EXTERN void photo_unscaled_to_raw_rect (Photo* self,
                                 GdkRectangle* unscaled_rect,
                                 GdkRectangle* result);
VALA_EXTERN PixelTransformationBundle* photo_get_enhance_transformations (Photo* self);
VALA_EXTERN gboolean photo_enhance (Photo* self);
VALA_EXTERN void photo_set_develop_raw_photos_to_files (gboolean value);
static void photo_real_editable_replaced (Photo* self,
                                   GFile* old_file,
                                   GFile* new_file);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void photo_real_raw_development_modified (Photo* self);
static void photo_real_baseline_replaced (Photo* self);
static void photo_real_master_reimported (Photo* self,
                                   PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void photo_real_editable_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_baseline_reimported (Photo* self,
                                     PhotoMetadata* metadata);
static void photo_real_source_reimported (Photo* self,
                                   PhotoMetadata* metadata);
static void photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self);
static void _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender,
                                                                                                gpointer self);
static GeeHashMap* photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original);
static void photo_photo_transformation_state_impl_finalize (GObject * obj);
static GType photo_photo_transformation_state_impl_get_type_once (void);
static void photo_backing_readers_finalize (PhotoBackingReaders * obj);
static GType photo_backing_readers_get_type_once (void);
static void photo_cached_pixbuf_finalize (PhotoCachedPixbuf * obj);
static GType photo_cached_pixbuf_get_type_once (void);
VALA_EXTERN PhotoReimportMasterState* photo_reimport_master_state_construct (GType object_type);
static void photo_reimport_master_state_finalize (PhotoReimportMasterState * obj);
static GType photo_reimport_master_state_get_type_once (void);
static gchar** _vala_array_dup33 (gchar** self,
                           gssize length);
static void photo_reimport_master_state_impl_finalize (PhotoReimportMasterState * obj);
static GType photo_reimport_master_state_impl_get_type_once (void);
VALA_EXTERN PhotoReimportEditableState* photo_reimport_editable_state_construct (GType object_type);
static void photo_reimport_editable_state_finalize (PhotoReimportEditableState * obj);
static GType photo_reimport_editable_state_get_type_once (void);
static void photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState * obj);
static GType photo_reimport_editable_state_impl_get_type_once (void);
VALA_EXTERN PhotoReimportRawDevelopmentState* photo_reimport_raw_development_state_construct (GType object_type);
static void photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState * obj);
static GType photo_reimport_raw_development_state_get_type_once (void);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing,
                                                                                                                  PhotoMetadata* metadata);
static PhotoReimportRawDevelopmentStateImplDevToReimport* photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type,
                                                                                                                        BackingPhotoRow* backing,
                                                                                                                        PhotoMetadata* metadata);
static void photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport * obj);
static GType photo_reimport_raw_development_state_impl_dev_to_reimport_get_type_once (void);
static void photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState * obj);
static GType photo_reimport_raw_development_state_impl_get_type_once (void);
VALA_EXTERN GDateTime* dateable_get_exposure_time (Dateable* self);
VALA_EXTERN void positionable_get_gps_coords (Positionable* self,
                                  GpsCoords* result);
static void photo_finalize (GObject * obj);
static GType photo_get_type_once (void);
static void _vala_photo_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec);
static void _vala_photo_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN GType media_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceHoldingTank, source_holding_tank_unref)
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN GType media_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaMonitor, g_object_unref)
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN GType library_photo_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceCollection, data_collection_unref)
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_create_trashcan (MediaSourceCollection* self);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_create_offline_bin (MediaSourceCollection* self);
VALA_EXTERN MediaMonitor* media_source_collection_create_media_monitor (MediaSourceCollection* self,
                                                            Workers* workers,
                                                            GCancellable* cancellable);
VALA_EXTERN gboolean source_collection_holds_type_of_source (SourceCollection* self,
                                                 DataSource* source);
VALA_EXTERN gchar* media_source_collection_get_typename (MediaSourceCollection* self);
VALA_EXTERN gboolean media_source_collection_is_file_recognized (MediaSourceCollection* self,
                                                     GFile* file);
VALA_EXTERN void data_collection_notify_contents_altered (DataCollection* self,
                                              GeeIterable* added,
                                              GeeIterable* removed);
VALA_EXTERN void data_collection_items_altered (DataCollection* self,
                                    GeeMap* items);
VALA_EXTERN void media_source_collection_postprocess_imported_media (MediaSourceCollection* self,
                                                         GeeCollection* media);
VALA_EXTERN void library_photo_source_collection_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
VALA_EXTERN void library_photo_source_collection_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata);
VALA_EXTERN void library_photo_source_collection_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
VALA_EXTERN void library_photo_source_collection_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_numeric_id (MediaSourceCollection* self,
                                                          gint64 numeric_id);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_source_id (MediaSourceCollection* self,
                                                         const gchar* source_id);
VALA_EXTERN GeeCollection* media_source_collection_get_event_source_ids (MediaSourceCollection* self,
                                                             EventID* event_id);
VALA_EXTERN gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
VALA_EXTERN void source_collection_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink);
VALA_EXTERN TransactionController* media_source_collection_get_transaction_controller (MediaSourceCollection* self);
VALA_EXTERN GType library_photo_source_collection_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint file_hash (GFile* file);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
VALA_EXTERN gboolean file_equal (GFile* a,
                     GFile* b);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
VALA_EXTERN gint int64_compare (gint64* a,
                    gint64* b);
static gint _int64_compare_gcompare_data_func (gconstpointer a,
                                        gconstpointer b,
                                        gpointer self);
static gint64* _int64_dup (gint64* self);
VALA_EXTERN gboolean int64_equal (gint64* a,
                      gint64* b);
static gboolean _int64_equal_gee_equal_data_func (gconstpointer a,
                                           gconstpointer b,
                                           gpointer self);
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_source_collection_new (void);
VALA_EXTERN LibraryPhotoSourceCollection* library_photo_source_collection_construct (GType object_type);
static gint64 _photo_get_photo_key_get_source_database_key (DataSource* source,
                                                     gpointer self);
VALA_EXTERN MediaSourceCollection* media_source_collection_construct (GType object_type,
                                                          const gchar* name,
                                                          GetSourceDatabaseKey source_key_func,
                                                          gpointer source_key_func_target);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_get_trashcan (MediaSourceCollection* self);
static void library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self,
                                                                   GeeCollection* added,
                                                                   GeeCollection* removed);
static void _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                         GeeCollection* added,
                                                                                                         GeeCollection* removed,
                                                                                                         gpointer self);
VALA_EXTERN MediaSourceHoldingTank* media_source_collection_get_offline_bin (MediaSourceCollection* self);
static void library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self,
                                                                  GeeCollection* added,
                                                                  GeeCollection* removed);
static void _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                        GeeCollection* added,
                                                                                                        GeeCollection* removed,
                                                                                                        gpointer self);
static MediaSourceHoldingTank* library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self,
                                                                 DataSource* source,
                                                                 Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                                    Alteration* alteration,
                                                                                                    gpointer self);
VALA_EXTERN LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_new (LibraryPhotoSourceCollection* sources,
                                                                      SourceHoldingTankCheckToKeep check_to_keep,
                                                                      gpointer check_to_keep_target,
                                                                      GetSourceDatabaseKey get_key,
                                                                      gpointer get_key_target);
VALA_EXTERN LibraryPhotoSourceHoldingTank* library_photo_source_holding_tank_construct (GType object_type,
                                                                            LibraryPhotoSourceCollection* sources,
                                                                            SourceHoldingTankCheckToKeep check_to_keep,
                                                                            gpointer check_to_keep_target,
                                                                            GetSourceDatabaseKey get_key,
                                                                            gpointer get_key_target);
VALA_EXTERN GType library_photo_source_holding_tank_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibraryPhotoSourceHoldingTank, source_holding_tank_unref)
static MediaSourceHoldingTank* library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base);
static gboolean library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self,
                                                                 DataSource* source,
                                                                 Alteration* alteration);
static gboolean _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                                    Alteration* alteration,
                                                                                                    gpointer self);
static MediaMonitor* library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                                         Workers* workers,
                                                                         GCancellable* cancellable);
VALA_EXTERN PhotoMonitor* photo_monitor_new (Workers* workers,
                                 GCancellable* cancellable);
VALA_EXTERN PhotoMonitor* photo_monitor_construct (GType object_type,
                                       Workers* workers,
                                       GCancellable* cancellable);
VALA_EXTERN GType photo_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoMonitor, g_object_unref)
static gboolean library_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                                    DataSource* source);
static gchar* library_photo_source_collection_real_get_typename (MediaSourceCollection* base);
static gboolean library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                                  GFile* file);
static void library_photo_source_collection_real_notify_contents_altered (DataCollection* base,
                                                                   GeeIterable* added,
                                                                   GeeIterable* removed);
static void library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self,
                                                           Photo* photo,
                                                           GFile* old_file,
                                                           GFile* new_file);
static void _library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                    GFile* old_file,
                                                                                    GFile* new_file,
                                                                                    gpointer self);
static void library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self,
                                                                  Photo* _photo);
static void _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                                  gpointer self);
static void library_photo_source_collection_real_items_altered (DataCollection* base,
                                                         GeeMap* items);
VALA_EXTERN gboolean alteration_has_detail (Alteration* self,
                                const gchar* subject,
                                const gchar* detail);
static void library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base,
                                                                      GeeCollection* media_sources);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN gpointer hierarchical_tag_index_ref (gpointer instance);
VALA_EXTERN void hierarchical_tag_index_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_hierarchical_tag_index (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_hierarchical_tag_index (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_hierarchical_tag_index (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_hierarchical_tag_index (const GValue* value);
VALA_EXTERN GType hierarchical_tag_index_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HierarchicalTagIndex, hierarchical_tag_index_unref)
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_index_get_global_index (void);
VALA_EXTERN gboolean photo_metadata_has_hierarchical_keywords (PhotoMetadata* self);
VALA_EXTERN HierarchicalTagIndex* hierarchical_tag_utilities_process_hierarchical_import_keywords (GeeCollection* h_keywords);
VALA_EXTERN GeeSet* photo_metadata_get_hierarchical_keywords (PhotoMetadata* self);
VALA_EXTERN GeeCollection* library_photo_get_import_keywords (LibraryPhoto* self);
VALA_EXTERN gboolean hierarchical_tag_index_is_tag_in_index (HierarchicalTagIndex* self,
                                                 const gchar* tag);
VALA_EXTERN gchar* tag_prep_tag_name (const gchar* name);
VALA_EXTERN gchar* hierarchical_tag_index_get_path_for_name (HierarchicalTagIndex* self,
                                                 const gchar* name);
VALA_EXTERN Tag* tag_for_path (const gchar* name);
VALA_EXTERN GeeCollection* hierarchical_tag_index_get_all_paths (HierarchicalTagIndex* self);
VALA_EXTERN void library_photo_clear_import_keywords (LibraryPhoto* self);
VALA_EXTERN void tag_attach_many (Tag* self,
                      GeeCollection* sources);
static void library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                                    LibraryPhoto* photo,
                                                                    PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                      LibraryPhoto* photo,
                                                                      PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                                    LibraryPhoto* photo,
                                                                    PhotoMetadata* metadata);
static void library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                      LibraryPhoto* photo,
                                                                      PhotoMetadata* metadata);
static MediaSource* library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                                       gint64 numeric_id);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self,
                                                     PhotoID* photo_id);
VALA_EXTERN gboolean media_source_is_trashed (MediaSource* self);
VALA_EXTERN gboolean media_source_is_offline (MediaSource* self);
static MediaSource* library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base,
                                                                      const gchar* source_id);
static GeeCollection* library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                                          EventID* event_id);
VALA_EXTERN GeeArrayList* photo_table_get_event_source_ids (PhotoTable* self,
                                                EventID* event_id);
VALA_EXTERN DataSource* database_source_collection_fetch_by_key (DatabaseSourceCollection* self,
                                                     gint64 key);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_fetch_by_editable_file (LibraryPhotoSourceCollection* self,
                                                                      GFile* file);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_fetch_by_raw_development_file (LibraryPhotoSourceCollection* self,
                                                                             GFile* file);
static void library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self,
                                                      LibraryPhoto* photo,
                                                      GFileInfo* info,
                                                      GeeCollection* matches_master,
                                                      GeeCollection* matches_editable,
                                                      GeeCollection* matches_development);
VALA_EXTERN gboolean backing_photo_row_matches_file_info (BackingPhotoRow* self,
                                              GFileInfo* info);
VALA_EXTERN void library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self,
                                                                GFileInfo* info,
                                                                GeeCollection* matches_master,
                                                                GeeCollection* matches_editable,
                                                                GeeCollection* matched_development);
VALA_EXTERN GeeCollection* media_source_collection_get_offline_bin_contents (MediaSourceCollection* self);
VALA_EXTERN void library_photo_source_collection_get_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                      const gchar* basename,
                                                                      gint64 filesize,
                                                                      PhotoID* result);
VALA_EXTERN gint utf8_ci_compare (const gchar* a,
                      const gchar* b);
VALA_EXTERN gboolean library_photo_source_collection_has_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                          const gchar* basename,
                                                                          gint64 filesize);
VALA_EXTERN gboolean photo_id_is_valid (PhotoID *self);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_get_trashed_by_file (LibraryPhotoSourceCollection* self,
                                                                   GFile* file);
VALA_EXTERN MediaSource* media_source_holding_tank_fetch_by_master_file (MediaSourceHoldingTank* self,
                                                             GFile* file);
VALA_EXTERN LibraryPhoto* library_photo_source_holding_tank_fetch_by_backing_file (LibraryPhotoSourceHoldingTank* self,
                                                                       GFile* file);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_get_trashed_by_md5 (LibraryPhotoSourceCollection* self,
                                                                  const gchar* md5);
VALA_EXTERN MediaSource* media_source_holding_tank_fetch_by_md5 (MediaSourceHoldingTank* self,
                                                     const gchar* md5);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_get_offline_by_file (LibraryPhotoSourceCollection* self,
                                                                   GFile* file);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_get_offline_by_md5 (LibraryPhotoSourceCollection* self,
                                                                  const gchar* md5);
VALA_EXTERN gint library_photo_source_collection_get_offline_count (LibraryPhotoSourceCollection* self);
VALA_EXTERN gint source_holding_tank_get_count (SourceHoldingTank* self);
VALA_EXTERN LibraryPhoto* library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self,
                                                                 GFile* file,
                                                                 LibraryPhotoSourceCollectionState* state);
VALA_EXTERN MediaSource* media_source_collection_fetch_by_master_file (MediaSourceCollection* self,
                                                           GFile* file);
static gboolean library_photo_source_collection_real_has_backlink (SourceCollection* base,
                                                            SourceBacklink* backlink);
VALA_EXTERN gboolean source_holding_tank_has_backlink (SourceHoldingTank* self,
                                           SourceBacklink* backlink);
static void library_photo_source_collection_real_remove_backlink (SourceCollection* base,
                                                           SourceBacklink* backlink);
VALA_EXTERN void source_holding_tank_remove_backlink (SourceHoldingTank* self,
                                          SourceBacklink* backlink);
VALA_EXTERN MediaSourceTransactionController* media_source_transaction_controller_new (MediaSourceCollection* sources);
VALA_EXTERN MediaSourceTransactionController* media_source_transaction_controller_construct (GType object_type,
                                                                                 MediaSourceCollection* sources);
VALA_EXTERN GType media_source_transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceTransactionController, transaction_controller_unref)
static void library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self,
                                                             LibraryPhoto* photo,
                                                             PhotoMetadata* metadata);
static void g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data);
static void library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata);
static void library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self,
                                                             LibraryPhoto* photo,
                                                             PhotoMetadata* metadata);
static void library_photo_source_collection_finalize (DataCollection * obj);
static GType library_photo_source_collection_get_type_once (void);
VALA_EXTERN GType flaggable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Flaggable, g_object_unref)
VALA_EXTERN GType monitorable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitorable, g_object_unref)
VALA_EXTERN GdkPixbuf* media_source_get_preview_pixbuf (MediaSource* self,
                                            Scaling* scaling,
                                            GError** error);
VALA_EXTERN GdkPixbuf* thumbnail_source_get_thumbnail (ThumbnailSource* self,
                                           gint scale,
                                           GError** error);
VALA_EXTERN void media_source_trash (MediaSource* self);
VALA_EXTERN void media_source_untrash (MediaSource* self);
VALA_EXTERN void media_source_mark_offline (MediaSource* self);
VALA_EXTERN void media_source_mark_online (MediaSource* self);
VALA_EXTERN void data_source_destroy (DataSource* self);
static LibraryPhoto* library_photo_new (PhotoRow* row);
static LibraryPhoto* library_photo_construct (GType object_type,
                                       PhotoRow* row);
static void library_photo_generate_thumbnails (LibraryPhoto* self);
static void _library_photo_generate_thumbnails_one_shot_callback (gpointer self);
static void library_photo_import_gps_metadata (LibraryPhoto* self);
static void _library_photo_import_gps_metadata_one_shot_callback (gpointer self);
VALA_EXTERN void one_shot_scheduler_at_priority_idle (OneShotScheduler* self,
                                          gint priority);
VALA_EXTERN void data_source_rehydrate_backlinks (DataSource* self,
                                      SourceCollection* unlinked_from,
                                      const gchar* dehydrated);
static void library_photo_upgrade_rating_flags (LibraryPhoto* self,
                                         guint64 flags);
static LibraryPhoto* library_photo_new_from_import_params (PhotoImportParams* import_params);
static LibraryPhoto* library_photo_construct_from_import_params (GType object_type,
                                                          PhotoImportParams* import_params);
VALA_EXTERN void library_photo_init (ProgressMonitor monitor,
                         gpointer monitor_target);
VALA_EXTERN GeeArrayList* photo_table_get_all (PhotoTable* self);
VALA_EXTERN GeeCollection* data_collection_add_many (DataCollection* self,
                                         GeeCollection* objects,
                                         ProgressMonitor monitor,
                                         gpointer monitor_target);
VALA_EXTERN void media_source_collection_add_many_to_trash (MediaSourceCollection* self,
                                                GeeCollection* sources);
VALA_EXTERN void media_source_collection_add_many_to_offline (MediaSourceCollection* self,
                                                  GeeCollection* sources);
VALA_EXTERN void library_photo_terminate (void);
VALA_EXTERN ImportResult library_photo_import_create (PhotoImportParams* params,
                                          LibraryPhoto** photo);
VALA_EXTERN void photo_table_add (PhotoTable* self,
                      PhotoRow* photo_row,
                      PhotoID* result);
VALA_EXTERN gboolean photo_id_is_invalid (PhotoID *self);
VALA_EXTERN void library_photo_import_failed (LibraryPhoto* photo);
VALA_EXTERN void photo_table_remove (PhotoTable* self,
                         PhotoID* photo_id,
                         GError** error);
static void library_photo_real_notify_master_reimported (Photo* base,
                                                  PhotoMetadata* metadata);
static void library_photo_real_notify_editable_reimported (Photo* base,
                                                    PhotoMetadata* metadata);
static void library_photo_real_notify_source_reimported (Photo* base,
                                                  PhotoMetadata* metadata);
static void library_photo_real_notify_baseline_reimported (Photo* base,
                                                    PhotoMetadata* metadata);
VALA_EXTERN void thumbnail_cache_import_from_source (ThumbnailSource* source,
                                         gboolean force,
                                         GError** error);
VALA_EXTERN void thumbnail_source_notify_thumbnail_altered (ThumbnailSource* self);
static void library_photo_real_notify_altered (DataObject* base,
                                        Alteration* alteration);
VALA_EXTERN gboolean alteration_has_subject (Alteration* self,
                                 const gchar* subject);
static GdkPixbuf* library_photo_real_get_preview_pixbuf (MediaSource* base,
                                                  Scaling* scaling,
                                                  GError** error);
VALA_EXTERN GType thumbnail_cache_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GdkPixbuf* scaling_perform_on_pixbuf (Scaling *self,
                                      GdkPixbuf* pixbuf,
                                      GdkInterpType interp,
                                      gboolean scale_up);
static void library_photo_real_rotate (Photo* base,
                                Rotation rotation);
VALA_EXTERN void thumbnail_cache_rotate (ThumbnailSource* source,
                             Rotation rotation,
                             GError** error);
static GdkPixbuf* library_photo_real_get_thumbnail (ThumbnailSource* base,
                                             gint scale,
                                             GError** error);
VALA_EXTERN GdkPixbuf* thumbnail_cache_fetch (ThumbnailSource* source,
                                  gint scale,
                                  GError** error);
static void library_photo_duplicate_backing_photo (LibraryPhoto* self,
                                            BackingPhotoRow* backing,
                                            BackingPhotoID* result,
                                            GError** error);
VALA_EXTERN GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                gpointer progress_callback_target,
                                gboolean blacklist,
                                GError** error);
static void library_photo_on_duplicate_progress (LibraryPhoto* self,
                                          gint64 current,
                                          gint64 total);
static void _library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                                   gint64 total_num_bytes,
                                                                   gpointer self);
VALA_EXTERN LibraryPhoto* library_photo_duplicate (LibraryPhoto* self,
                                       GError** error);
VALA_EXTERN void photo_table_duplicate (PhotoTable* self,
                            PhotoID* photo_id,
                            const gchar* new_filename,
                            BackingPhotoID* editable_id,
                            BackingPhotoID* develop_shotwell,
                            BackingPhotoID* develop_camera_id,
                            BackingPhotoID* develop_embedded_id,
                            PhotoID* result);
VALA_EXTERN PhotoRow* photo_table_get_row (PhotoTable* self,
                               PhotoID* photo_id);
VALA_EXTERN void thumbnail_cache_duplicate (ThumbnailSource* src_source,
                                ThumbnailSource* dest_source);
VALA_EXTERN gboolean data_collection_add (DataCollection* self,
                              DataObject* object);
VALA_EXTERN GType event_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EventSource, g_object_unref)
VALA_EXTERN GType event_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Event, g_object_unref)
VALA_EXTERN Event* media_source_get_event (MediaSource* self);
VALA_EXTERN void event_attach (Event* self,
                   MediaSource* source);
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType tag_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TagSourceCollection, data_collection_unref)
VALA_EXTERN GeeList* tag_source_collection_fetch_for_source (TagSourceCollection* self,
                                                 MediaSource* source);
VALA_EXTERN void tag_attach (Tag* self,
                 MediaSource* source);
VALA_EXTERN GType face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Face, g_object_unref)
VALA_EXTERN GType face_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceSourceCollection, data_collection_unref)
VALA_EXTERN GeeList* face_source_collection_fetch_for_source (FaceSourceCollection* self,
                                                  MediaSource* source);
VALA_EXTERN GType face_location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocation, g_object_unref)
VALA_EXTERN GType face_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceID* face_id_dup (const FaceID* self);
VALA_EXTERN void face_id_free (FaceID* self);
VALA_EXTERN FaceLocation* face_location_get_face_location (FaceID* face_id,
                                               PhotoID* photo_id);
VALA_EXTERN void face_get_face_id (Face* self,
                       FaceID* result);
VALA_EXTERN void face_attach (Face* self,
                  MediaSource* source);
VALA_EXTERN GType face_location_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceLocationData* face_location_data_dup (const FaceLocationData* self);
VALA_EXTERN void face_location_data_free (FaceLocationData* self);
VALA_EXTERN void face_location_data_copy (const FaceLocationData* self,
                              FaceLocationData* dest);
VALA_EXTERN void face_location_data_destroy (FaceLocationData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FaceLocationData, face_location_data_destroy)
VALA_EXTERN FaceLocation* face_location_create (FaceID* face_id,
                                    PhotoID* photo_id,
                                    FaceLocationData* face_data);
VALA_EXTERN void face_location_get_face_data (FaceLocation* self,
                                  FaceLocationData* result);
VALA_EXTERN void spin_event_loop (void);
static gboolean library_photo_real_is_trashed (MediaSource* base);
static void library_photo_real_trash (MediaSource* base);
static void library_photo_real_untrash (MediaSource* base);
static gboolean library_photo_real_is_offline (Monitorable* base);
static void library_photo_real_mark_offline (Monitorable* base);
static void library_photo_real_mark_online (Monitorable* base);
static gboolean library_photo_real_is_flagged (Flaggable* base);
static void library_photo_real_mark_flagged (Flaggable* base);
static void library_photo_real_mark_unflagged (Flaggable* base);
static gboolean library_photo_real_internal_delete_backing (DataSource* base,
                                                     GError** error);
VALA_EXTERN gboolean media_source_delete_original_file (MediaSource* self);
static void library_photo_real_destroy (DataSource* base);
VALA_EXTERN void thumbnail_cache_remove (ThumbnailSource* source);
VALA_EXTERN gboolean library_photo_has_nontrash_duplicate (GFile* file,
                                               const gchar* thumbnail_md5,
                                               const gchar* full_md5,
                                               PhotoFileFormat file_format);
VALA_EXTERN void library_photo_get_nontrash_duplicate (GFile* file,
                                           const gchar* thumbnail_md5,
                                           const gchar* full_md5,
                                           PhotoFileFormat file_format,
                                           PhotoID* result);
static gboolean library_photo_real_has_user_generated_metadata (Photo* base);
VALA_EXTERN gboolean gps_coords_equals (GpsCoords *self,
                            GpsCoords* gps);
VALA_EXTERN gchar* data_object_get_name (DataObject* self);
static void library_photo_real_set_user_metadata_for_export (Photo* base,
                                                      PhotoMetadata* metadata);
VALA_EXTERN void photo_metadata_set_keywords (PhotoMetadata* self,
                                  GeeCollection* keywords,
                                  PhotoMetadataSetOption option);
VALA_EXTERN void photo_metadata_set_rating (PhotoMetadata* self,
                                Rating rating);
VALA_EXTERN void photo_metadata_set_gps_coords (PhotoMetadata* self,
                                    GpsCoords* gps_coords);
static void library_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                          PhotoMetadata* metadata);
VALA_EXTERN gchar* hierarchical_tag_utilities_make_flat_tag_safe (const gchar* in_tag);
VALA_EXTERN gchar* hierarchical_tag_utilities_flat_to_hierarchical (const gchar* name);
VALA_EXTERN gboolean tag_source_collection_exists (TagSourceCollection* self,
                                       const gchar* name,
                                       gboolean treat_htags_as_root);
VALA_EXTERN gboolean flaggable_is_flagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_flagged (Flaggable* self);
VALA_EXTERN void flaggable_mark_unflagged (Flaggable* self);
VALA_EXTERN gboolean monitorable_is_offline (Monitorable* self);
VALA_EXTERN void monitorable_mark_offline (Monitorable* self);
VALA_EXTERN void monitorable_mark_online (Monitorable* self);
static void library_photo_finalize (GObject * obj);
static GType library_photo_get_type_once (void);
VALA_EXTERN void source_holding_tank_notify_contents_altered (SourceHoldingTank* self,
                                                  GeeCollection* added,
                                                  GeeCollection* removed);
VALA_EXTERN MediaSourceHoldingTank* media_source_holding_tank_new (MediaSourceCollection* sources,
                                                       SourceHoldingTankCheckToKeep check_to_keep,
                                                       gpointer check_to_keep_target,
                                                       GetSourceDatabaseKey get_key,
                                                       gpointer get_key_target);
VALA_EXTERN MediaSourceHoldingTank* media_source_holding_tank_construct (GType object_type,
                                                             MediaSourceCollection* sources,
                                                             SourceHoldingTankCheckToKeep check_to_keep,
                                                             gpointer check_to_keep_target,
                                                             GetSourceDatabaseKey get_key,
                                                             gpointer get_key_target);
static void library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                                     GeeCollection* added,
                                                                     GeeCollection* removed);
static void library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self,
                                                             Photo* _photo,
                                                             GFile* old_file,
                                                             GFile* new_file);
static void _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                      GFile* old_file,
                                                                                      GFile* new_file,
                                                                                      gpointer self);
static void library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self,
                                                                    Photo* _photo);
static void _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                                    gpointer self);
static void library_photo_source_holding_tank_finalize (SourceHoldingTank * obj);
static GType library_photo_source_holding_tank_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const gchar* PHOTO_IMAGE_EXTENSIONS[70] = {"jpg", "jpeg", "jpe", "tiff", "tif", "png", "gif", "bmp", "ppm", "pgm", "pbm", "pnm", "thm", "tga", "ilbm", "pcx", "ecw", "img", "sid", "cd5", "fits", "pgf", "cgm", "svg", "odg", "eps", "pdf", "swf", "wmf", "emf", "xps", "pns", "jps", "mpo", "3fr", "arw", "srf", "sr2", "bay", "crw", "cr2", "cr3", "cap", "iiq", "eip", "dcs", "dcr", "drf", "k25", "kdc", "dng", "erf", "fff", "mef", "mos", "mrw", "nef", "nrw", "orf", "ptx", "pef", "pxn", "r3d", "raf", "raw", "rw2", "rwl", "rwz", "x3f", "srw"};

static GType
backing_fetch_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{BACKING_FETCH_MODE_SOURCE, "BACKING_FETCH_MODE_SOURCE", "source"}, {BACKING_FETCH_MODE_BASELINE, "BACKING_FETCH_MODE_BASELINE", "baseline"}, {BACKING_FETCH_MODE_MASTER, "BACKING_FETCH_MODE_MASTER", "master"}, {BACKING_FETCH_MODE_UNMODIFIED, "BACKING_FETCH_MODE_UNMODIFIED", "unmodified"}, {0, NULL, NULL}};
	GType backing_fetch_mode_type_id;
	backing_fetch_mode_type_id = g_enum_register_static ("BackingFetchMode", values);
	return backing_fetch_mode_type_id;
}

GType
backing_fetch_mode_get_type (void)
{
	static volatile gsize backing_fetch_mode_type_id__once = 0;
	if (g_once_init_enter (&backing_fetch_mode_type_id__once)) {
		GType backing_fetch_mode_type_id;
		backing_fetch_mode_type_id = backing_fetch_mode_get_type_once ();
		g_once_init_leave (&backing_fetch_mode_type_id__once, backing_fetch_mode_type_id);
	}
	return backing_fetch_mode_type_id__once;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_thumbnails_ref0 (gpointer self)
{
	return self ? thumbnails_ref (self) : NULL;
}

PhotoImportParams*
photo_import_params_construct (GType object_type,
                               GFile* file,
                               GFile* final_associated_file,
                               ImportID* import_id,
                               PhotoFileSnifferOptions sniffer_options,
                               const gchar* exif_md5,
                               const gchar* thumbnail_md5,
                               const gchar* full_md5,
                               Thumbnails* thumbnails)
{
	PhotoImportParams* self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	ImportID _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	Thumbnails* _tmp6_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail ((final_associated_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (final_associated_file, g_file_get_type ()), NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	g_return_val_if_fail ((thumbnails == NULL) || IS_THUMBNAILS (thumbnails), NULL);
	self = (PhotoImportParams*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	_tmp1_ = _g_object_ref0 (final_associated_file);
	_g_object_unref0 (self->final_associated_file);
	self->final_associated_file = _tmp1_;
	_tmp2_ = *import_id;
	self->import_id = _tmp2_;
	self->sniffer_options = sniffer_options;
	_tmp3_ = g_strdup (exif_md5);
	_g_free0 (self->exif_md5);
	self->exif_md5 = _tmp3_;
	_tmp4_ = g_strdup (thumbnail_md5);
	_g_free0 (self->thumbnail_md5);
	self->thumbnail_md5 = _tmp4_;
	_tmp5_ = g_strdup (full_md5);
	_g_free0 (self->full_md5);
	self->full_md5 = _tmp5_;
	_tmp6_ = _thumbnails_ref0 (thumbnails);
	_thumbnails_unref0 (self->thumbnails);
	self->thumbnails = _tmp6_;
	return self;
}

PhotoImportParams*
photo_import_params_new (GFile* file,
                         GFile* final_associated_file,
                         ImportID* import_id,
                         PhotoFileSnifferOptions sniffer_options,
                         const gchar* exif_md5,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         Thumbnails* thumbnails)
{
	return photo_import_params_construct (TYPE_PHOTO_IMPORT_PARAMS, file, final_associated_file, import_id, sniffer_options, exif_md5, thumbnail_md5, full_md5, thumbnails);
}

PhotoImportParams*
photo_import_params_construct_create_placeholder (GType object_type,
                                                  GFile* file,
                                                  ImportID* import_id)
{
	PhotoImportParams* self = NULL;
	GFile* _tmp0_;
	ImportID _tmp1_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	self = (PhotoImportParams*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp0_;
	_tmp1_ = *import_id;
	self->import_id = _tmp1_;
	self->sniffer_options = PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
	_g_free0 (self->exif_md5);
	self->exif_md5 = NULL;
	_g_free0 (self->thumbnail_md5);
	self->thumbnail_md5 = NULL;
	_g_free0 (self->full_md5);
	self->full_md5 = NULL;
	_thumbnails_unref0 (self->thumbnails);
	self->thumbnails = NULL;
	return self;
}

PhotoImportParams*
photo_import_params_new_create_placeholder (GFile* file,
                                            ImportID* import_id)
{
	return photo_import_params_construct_create_placeholder (TYPE_PHOTO_IMPORT_PARAMS, file, import_id);
}

static void
value_photo_import_params_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_photo_import_params_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_import_params_unref (value->data[0].v_pointer);
	}
}

static void
value_photo_import_params_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_import_params_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_photo_import_params_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_photo_import_params_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoImportParams * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_import_params_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_photo_import_params_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	PhotoImportParams ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_import_params_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_photo_import_params (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecPhotoImportParams* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PHOTO_IMPORT_PARAMS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_photo_import_params (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_photo_import_params (GValue* value,
                               gpointer v_object)
{
	PhotoImportParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_import_params_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_import_params_unref (old);
	}
}

void
value_take_photo_import_params (GValue* value,
                                gpointer v_object)
{
	PhotoImportParams * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PHOTO_IMPORT_PARAMS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PHOTO_IMPORT_PARAMS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_import_params_unref (old);
	}
}

static void
photo_import_params_class_init (PhotoImportParamsClass * klass,
                                gpointer klass_data)
{
	photo_import_params_parent_class = g_type_class_peek_parent (klass);
	((PhotoImportParamsClass *) klass)->finalize = photo_import_params_finalize;
}

static void
photo_import_params_instance_init (PhotoImportParams * self,
                                   gpointer klass)
{
	PhotoRow* _tmp0_;
	self->final_associated_file = NULL;
	_tmp0_ = photo_row_new ();
	self->row = _tmp0_;
	self->keywords = NULL;
	self->ref_count = 1;
}

static void
photo_import_params_finalize (PhotoImportParams * obj)
{
	PhotoImportParams * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_IMPORT_PARAMS, PhotoImportParams);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->final_associated_file);
	_g_free0 (self->exif_md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->full_md5);
	_thumbnails_unref0 (self->thumbnails);
	_photo_row_unref0 (self->row);
	_g_object_unref0 (self->keywords);
}

static GType
photo_import_params_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_photo_import_params_init, value_photo_import_params_free_value, value_photo_import_params_copy_value, value_photo_import_params_peek_pointer, "p", value_photo_import_params_collect_value, "p", value_photo_import_params_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoImportParamsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_import_params_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoImportParams), 0, (GInstanceInitFunc) photo_import_params_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_import_params_type_id;
	photo_import_params_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoImportParams", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_import_params_type_id;
}

GType
photo_import_params_get_type (void)
{
	static volatile gsize photo_import_params_type_id__once = 0;
	if (g_once_init_enter (&photo_import_params_type_id__once)) {
		GType photo_import_params_type_id;
		photo_import_params_type_id = photo_import_params_get_type_once ();
		g_once_init_leave (&photo_import_params_type_id__once, photo_import_params_type_id);
	}
	return photo_import_params_type_id__once;
}

gpointer
photo_import_params_ref (gpointer instance)
{
	PhotoImportParams * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_import_params_unref (gpointer instance)
{
	PhotoImportParams * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_IMPORT_PARAMS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
photo_transformation_state_get_instance_private (PhotoTransformationState* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoTransformationState_private_offset);
}

gboolean
photo_transformation_state_is_broken (PhotoTransformationState* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (self), FALSE);
	result = self->priv->is_broke;
	return result;
}

PhotoTransformationState*
photo_transformation_state_construct (GType object_type)
{
	PhotoTransformationState * self = NULL;
	self = (PhotoTransformationState*) g_object_new (object_type, NULL);
	return self;
}

static void
photo_transformation_state_real_broken (PhotoTransformationState* self)
{
	self->priv->is_broke = TRUE;
}

static void
photo_transformation_state_class_init (PhotoTransformationStateClass * klass,
                                       gpointer klass_data)
{
	photo_transformation_state_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotoTransformationState_private_offset);
	((PhotoTransformationStateClass *) klass)->broken = photo_transformation_state_real_broken;
	G_OBJECT_CLASS (klass)->finalize = photo_transformation_state_finalize;
	photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL] = g_signal_new ("broken", TYPE_PHOTO_TRANSFORMATION_STATE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoTransformationStateClass, broken), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
photo_transformation_state_instance_init (PhotoTransformationState * self,
                                          gpointer klass)
{
	self->priv = photo_transformation_state_get_instance_private (self);
	self->priv->is_broke = FALSE;
}

static void
photo_transformation_state_finalize (GObject * obj)
{
	PhotoTransformationState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
	G_OBJECT_CLASS (photo_transformation_state_parent_class)->finalize (obj);
}

static GType
photo_transformation_state_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoTransformationStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_transformation_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoTransformationState), 0, (GInstanceInitFunc) photo_transformation_state_instance_init, NULL };
	GType photo_transformation_state_type_id;
	photo_transformation_state_type_id = g_type_register_static (G_TYPE_OBJECT, "PhotoTransformationState", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	PhotoTransformationState_private_offset = g_type_add_instance_private (photo_transformation_state_type_id, sizeof (PhotoTransformationStatePrivate));
	return photo_transformation_state_type_id;
}

GType
photo_transformation_state_get_type (void)
{
	static volatile gsize photo_transformation_state_type_id__once = 0;
	if (g_once_init_enter (&photo_transformation_state_type_id__once)) {
		GType photo_transformation_state_type_id;
		photo_transformation_state_type_id = photo_transformation_state_get_type_once ();
		g_once_init_leave (&photo_transformation_state_type_id__once, photo_transformation_state_type_id);
	}
	return photo_transformation_state_type_id__once;
}

gboolean
rating_can_increase (Rating self)
{
	gboolean result;
	result = self < RATING_FIVE;
	return result;
}

gboolean
rating_can_decrease (Rating self)
{
	gboolean result;
	result = self > RATING_REJECTED;
	return result;
}

gboolean
rating_is_valid (Rating self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (self >= RATING_REJECTED) {
		_tmp0_ = self <= RATING_FIVE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Rating
rating_increase (Rating self)
{
	Rating _tmp0_ = 0;
	Rating result;
	if (rating_can_increase (self)) {
		_tmp0_ = self + 1;
	} else {
		_tmp0_ = self;
	}
	result = _tmp0_;
	return result;
}

Rating
rating_decrease (Rating self)
{
	Rating _tmp0_ = 0;
	Rating result;
	if (rating_can_decrease (self)) {
		_tmp0_ = self - 1;
	} else {
		_tmp0_ = self;
	}
	result = _tmp0_;
	return result;
}

gint
rating_serialize (Rating self)
{
	gint result;
	switch (self) {
		case RATING_REJECTED:
		{
			result = -1;
			return result;
		}
		case RATING_UNRATED:
		{
			result = 0;
			return result;
		}
		case RATING_ONE:
		{
			result = 1;
			return result;
		}
		case RATING_TWO:
		{
			result = 2;
			return result;
		}
		case RATING_THREE:
		{
			result = 3;
			return result;
		}
		case RATING_FOUR:
		{
			result = 4;
			return result;
		}
		case RATING_FIVE:
		{
			result = 5;
			return result;
		}
		default:
		{
			result = 0;
			return result;
		}
	}
}

Rating
rating_unserialize (gint value)
{
	Rating result;
	if (value > ((gint) RATING_FIVE)) {
		result = RATING_FIVE;
		return result;
	} else {
		if (value < ((gint) RATING_REJECTED)) {
			result = RATING_REJECTED;
			return result;
		}
	}
	switch (value) {
		case -1:
		{
			result = RATING_REJECTED;
			return result;
		}
		case 0:
		{
			result = RATING_UNRATED;
			return result;
		}
		case 1:
		{
			result = RATING_ONE;
			return result;
		}
		case 2:
		{
			result = RATING_TWO;
			return result;
		}
		case 3:
		{
			result = RATING_THREE;
			return result;
		}
		case 4:
		{
			result = RATING_FOUR;
			return result;
		}
		case 5:
		{
			result = RATING_FIVE;
			return result;
		}
		default:
		{
			result = RATING_UNRATED;
			return result;
		}
	}
}

static GType
rating_get_type_once (void)
{
	static const GEnumValue values[] = {{RATING_REJECTED, "RATING_REJECTED", "rejected"}, {RATING_UNRATED, "RATING_UNRATED", "unrated"}, {RATING_ONE, "RATING_ONE", "one"}, {RATING_TWO, "RATING_TWO", "two"}, {RATING_THREE, "RATING_THREE", "three"}, {RATING_FOUR, "RATING_FOUR", "four"}, {RATING_FIVE, "RATING_FIVE", "five"}, {0, NULL, NULL}};
	GType rating_type_id;
	rating_type_id = g_enum_register_static ("Rating", values);
	return rating_type_id;
}

GType
rating_get_type (void)
{
	static volatile gsize rating_type_id__once = 0;
	if (g_once_init_enter (&rating_type_id__once)) {
		GType rating_type_id;
		rating_type_id = rating_get_type_once ();
		g_once_init_leave (&rating_type_id__once, rating_type_id);
	}
	return rating_type_id__once;
}

static inline gpointer
photo_get_instance_private (Photo* self)
{
	return G_STRUCT_MEMBER_P (self, Photo_private_offset);
}

gboolean
photo_exception_prohibits (PhotoException self,
                           PhotoException exception)
{
	gboolean result;
	result = (self & exception) != 0;
	return result;
}

gboolean
photo_exception_allows (PhotoException self,
                        PhotoException exception)
{
	gboolean result;
	result = (self & exception) == 0;
	return result;
}

static GType
photo_exception_get_type_once (void)
{
	static const GEnumValue values[] = {{PHOTO_EXCEPTION_NONE, "PHOTO_EXCEPTION_NONE", "none"}, {PHOTO_EXCEPTION_ORIENTATION, "PHOTO_EXCEPTION_ORIENTATION", "orientation"}, {PHOTO_EXCEPTION_CROP, "PHOTO_EXCEPTION_CROP", "crop"}, {PHOTO_EXCEPTION_REDEYE, "PHOTO_EXCEPTION_REDEYE", "redeye"}, {PHOTO_EXCEPTION_ADJUST, "PHOTO_EXCEPTION_ADJUST", "adjust"}, {PHOTO_EXCEPTION_STRAIGHTEN, "PHOTO_EXCEPTION_STRAIGHTEN", "straighten"}, {PHOTO_EXCEPTION_ALL, "PHOTO_EXCEPTION_ALL", "all"}, {0, NULL, NULL}};
	GType photo_exception_type_id;
	photo_exception_type_id = g_enum_register_static ("PhotoException", values);
	return photo_exception_type_id;
}

GType
photo_exception_get_type (void)
{
	static volatile gsize photo_exception_type_id__once = 0;
	if (g_once_init_enter (&photo_exception_type_id__once)) {
		GType photo_exception_type_id;
		photo_exception_type_id = photo_exception_get_type_once ();
		g_once_init_leave (&photo_exception_type_id__once, photo_exception_type_id);
	}
	return photo_exception_type_id__once;
}

static gpointer
_photo_row_ref0 (gpointer self)
{
	return self ? photo_row_ref (self) : NULL;
}

static gpointer
_backing_photo_row_ref0 (gpointer self)
{
	return self ? backing_photo_row_ref (self) : NULL;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

Photo*
photo_construct (GType object_type,
                 PhotoRow* row)
{
	Photo * self = NULL;
	PhotoRow* _tmp0_;
	PhotoRow* _tmp1_;
	PhotoRow* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	PhotoRow* _tmp5_;
	PhotoRow* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	PhotoBackingReaders* _tmp9_;
	BackingPhotoRow* _tmp10_;
	BackingPhotoRow* _tmp11_;
	const gchar* _tmp12_;
	PhotoFileReader* _tmp13_;
	BackingPhotoRow* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	BackingPhotoID _tmp21_;
	BackingPhotoRow* _tmp35_;
	gboolean _tmp47_ = FALSE;
	BackingPhotoRow* _tmp48_;
	PhotoBackingReaders* _tmp57_;
	PhotoFileReader* _tmp58_;
	PhotoRow* _tmp71_;
	GDateTime* _tmp72_;
	GDateTime* _tmp73_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
	self = (Photo*) photo_source_construct (object_type, DATA_OBJECT_INVALID_OBJECT_ID);
	_tmp0_ = _photo_row_ref0 (row);
	_photo_row_unref0 (self->row);
	self->row = _tmp0_;
	_tmp1_ = self->row;
	_tmp2_ = self->row;
	_tmp3_ = _tmp2_->title;
	_tmp4_ = media_source_prep_title (_tmp3_);
	_g_free0 (_tmp1_->title);
	_tmp1_->title = _tmp4_;
	_tmp5_ = self->row;
	_tmp6_ = self->row;
	_tmp7_ = _tmp6_->comment;
	_tmp8_ = media_source_prep_comment (_tmp7_);
	_g_free0 (_tmp5_->comment);
	_tmp5_->comment = _tmp8_;
	_tmp9_ = self->priv->readers;
	_tmp10_ = row->master;
	_tmp11_ = row->master;
	_tmp12_ = _tmp11_->filepath;
	_tmp13_ = photo_file_format_create_reader (_tmp10_->file_format, _tmp12_);
	_photo_file_adapter_unref0 (_tmp9_->master);
	_tmp9_->master = _tmp13_;
	_tmp14_ = row->master;
	_tmp15_ = _tmp14_->filepath;
	_tmp16_ = g_path_get_basename (_tmp15_);
	_g_free0 (self->priv->file_title);
	self->priv->file_title = _tmp16_;
	_tmp17_ = self->priv->file_title;
	if (is_string_empty (_tmp17_)) {
		BackingPhotoRow* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = row->master;
		_tmp19_ = _tmp18_->filepath;
		_tmp20_ = g_strdup (_tmp19_);
		_g_free0 (self->priv->file_title);
		self->priv->file_title = _tmp20_;
	}
	_tmp21_ = row->editable_id;
	if (_tmp21_.id != BACKING_PHOTO_ID_INVALID) {
		BackingPhotoRow* e = NULL;
		BackingPhotoID _tmp22_;
		BackingPhotoRow* _tmp23_;
		BackingPhotoRow* _tmp24_;
		_tmp22_ = row->editable_id;
		_tmp23_ = photo_get_backing_row (self, &_tmp22_);
		e = _tmp23_;
		_tmp24_ = e;
		if (_tmp24_ != NULL) {
			BackingPhotoRow* _tmp25_;
			BackingPhotoRow* _tmp26_;
			PhotoBackingReaders* _tmp27_;
			BackingPhotoRow* _tmp28_;
			BackingPhotoRow* _tmp29_;
			const gchar* _tmp30_;
			PhotoFileReader* _tmp31_;
			_tmp25_ = e;
			_tmp26_ = _backing_photo_row_ref0 (_tmp25_);
			_backing_photo_row_unref0 (self->priv->editable);
			self->priv->editable = _tmp26_;
			_tmp27_ = self->priv->readers;
			_tmp28_ = self->priv->editable;
			_tmp29_ = self->priv->editable;
			_tmp30_ = _tmp29_->filepath;
			_tmp31_ = photo_file_format_create_reader (_tmp28_->file_format, _tmp30_);
			_photo_file_adapter_unref0 (_tmp27_->editable);
			_tmp27_->editable = _tmp31_;
		} else {
			{
				PhotoTable* _tmp32_;
				PhotoTable* _tmp33_;
				PhotoRow* _tmp34_;
				_tmp32_ = photo_table_get_instance ();
				_tmp33_ = _tmp32_;
				_tmp34_ = self->row;
				photo_table_detach_editable (_tmp33_, _tmp34_, &_inner_error0_);
				_database_table_unref0 (_tmp33_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch0_database_error;
					}
					_backing_photo_row_unref0 (e);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally0;
			__catch0_database_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_backing_photo_row_unref0 (e);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			photo_remove_all_transformations (self, FALSE);
		}
		_backing_photo_row_unref0 (e);
	}
	_tmp35_ = row->master;
	if (_tmp35_->file_format == PHOTO_FILE_FORMAT_RAW) {
		GeeHashMap* _tmp36_;
		gint _tmp37_ = 0;
		RawDeveloper* _tmp38_;
		_tmp36_ = gee_hash_map_new (TYPE_RAW_DEVELOPER, NULL, NULL, TYPE_BACKING_PHOTO_ROW, (GBoxedCopyFunc) backing_photo_row_ref, (GDestroyNotify) backing_photo_row_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->developments);
		self->priv->developments = _tmp36_;
		_tmp38_ = raw_developer_as_array (&_tmp37_);
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
			d_collection = _tmp38_;
			d_collection_length1 = _tmp37_;
			for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
				RawDeveloper d = 0;
				d = d_collection[d_it];
				{
					BackingPhotoID id = {0};
					BackingPhotoID* _tmp39_;
					gint _tmp39__length1;
					BackingPhotoID _tmp40_;
					BackingPhotoID _tmp41_;
					_tmp39_ = row->development_ids;
					_tmp39__length1 = row->development_ids_length1;
					_tmp40_ = _tmp39_[d];
					id = _tmp40_;
					_tmp41_ = id;
					if (_tmp41_.id != BACKING_PHOTO_ID_INVALID) {
						BackingPhotoRow* bpr = NULL;
						BackingPhotoID _tmp42_;
						BackingPhotoRow* _tmp43_;
						BackingPhotoRow* _tmp44_;
						_tmp42_ = id;
						_tmp43_ = photo_get_backing_row (self, &_tmp42_);
						bpr = _tmp43_;
						_tmp44_ = bpr;
						if (_tmp44_ != NULL) {
							GeeHashMap* _tmp45_;
							BackingPhotoRow* _tmp46_;
							_tmp45_ = self->priv->developments;
							_tmp46_ = bpr;
							gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d), _tmp46_);
						}
						_backing_photo_row_unref0 (bpr);
					}
				}
			}
			d_collection = (g_free (d_collection), NULL);
		}
	}
	_tmp48_ = row->master;
	if (_tmp48_->file_format == PHOTO_FILE_FORMAT_RAW) {
		GeeHashMap* _tmp49_;
		_tmp49_ = self->priv->developments;
		_tmp47_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) row->developer));
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		BackingPhotoRow* r = NULL;
		GeeHashMap* _tmp50_;
		gpointer _tmp51_;
		PhotoBackingReaders* _tmp52_;
		BackingPhotoRow* _tmp53_;
		BackingPhotoRow* _tmp54_;
		const gchar* _tmp55_;
		PhotoFileReader* _tmp56_;
		_tmp50_ = self->priv->developments;
		_tmp51_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) row->developer));
		r = (BackingPhotoRow*) _tmp51_;
		_tmp52_ = self->priv->readers;
		_tmp53_ = r;
		_tmp54_ = r;
		_tmp55_ = _tmp54_->filepath;
		_tmp56_ = photo_file_format_create_reader (_tmp53_->file_format, _tmp55_);
		_photo_file_adapter_unref0 (_tmp52_->developer);
		_tmp52_->developer = _tmp56_;
		_backing_photo_row_unref0 (r);
	}
	_tmp57_ = self->priv->readers;
	_tmp58_ = _tmp57_->editable;
	if (_tmp58_ != NULL) {
		BackingPhotoRow* _tmp59_;
		BackingPhotoRow* _tmp60_;
		_tmp59_ = self->priv->editable;
		_tmp60_ = _backing_photo_row_ref0 (_tmp59_);
		_backing_photo_row_unref0 (self->backing_photo_row);
		self->backing_photo_row = _tmp60_;
	} else {
		BackingPhotoRow* _tmp61_;
		_tmp61_ = row->master;
		if (_tmp61_->file_format != PHOTO_FILE_FORMAT_RAW) {
			PhotoRow* _tmp62_;
			BackingPhotoRow* _tmp63_;
			BackingPhotoRow* _tmp64_;
			_tmp62_ = self->row;
			_tmp63_ = _tmp62_->master;
			_tmp64_ = _backing_photo_row_ref0 (_tmp63_);
			_backing_photo_row_unref0 (self->backing_photo_row);
			self->backing_photo_row = _tmp64_;
		} else {
			GeeHashMap* _tmp65_;
			_tmp65_ = self->priv->developments;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) row->developer))) {
				GeeHashMap* _tmp66_;
				gpointer _tmp67_;
				_tmp66_ = self->priv->developments;
				_tmp67_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) row->developer));
				_backing_photo_row_unref0 (self->backing_photo_row);
				self->backing_photo_row = (BackingPhotoRow*) _tmp67_;
			} else {
				PhotoRow* _tmp68_;
				BackingPhotoRow* _tmp69_;
				BackingPhotoRow* _tmp70_;
				_tmp68_ = self->row;
				_tmp69_ = _tmp68_->master;
				_tmp70_ = _backing_photo_row_ref0 (_tmp69_);
				_backing_photo_row_unref0 (self->backing_photo_row);
				self->backing_photo_row = _tmp70_;
			}
		}
	}
	_tmp71_ = self->row;
	_tmp72_ = _tmp71_->exposure_time;
	_tmp73_ = _g_date_time_ref0 (_tmp72_);
	_g_date_time_unref0 (self->priv->cached_exposure_time);
	self->priv->cached_exposure_time = _tmp73_;
	return self;
}

void
photo_init_photo (void)
{
	GeeLinkedList* _tmp0_;
	_tmp0_ = gee_linked_list_new (PHOTO_TYPE_CACHED_PIXBUF, (GBoxedCopyFunc) photo_cached_pixbuf_ref, (GDestroyNotify) photo_cached_pixbuf_unref, NULL, NULL, NULL);
	_g_object_unref0 (photo_source_pixbuf_cache);
	photo_source_pixbuf_cache = _tmp0_;
}

void
photo_terminate_photo (void)
{
	_g_object_unref0 (photo_source_pixbuf_cache);
	photo_source_pixbuf_cache = NULL;
	if (photo_discard_source_id != ((guint) 0)) {
		g_source_remove (photo_discard_source_id);
		photo_discard_source_id = (guint) 0;
	}
}

static void
photo_real_notify_editable_replaced (Photo* self,
                                     GFile* old_file,
                                     GFile* new_file)
{
	g_return_if_fail ((old_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail ((new_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	g_signal_emit (self, photo_signals[PHOTO_EDITABLE_REPLACED_SIGNAL], 0, old_file, new_file);
}

void
photo_notify_editable_replaced (Photo* self,
                                GFile* old_file,
                                GFile* new_file)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_editable_replaced) {
		_klass_->notify_editable_replaced (self, old_file, new_file);
	}
}

static void
photo_real_notify_raw_development_modified (Photo* self)
{
	g_signal_emit (self, photo_signals[PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL], 0);
}

void
photo_notify_raw_development_modified (Photo* self)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_raw_development_modified) {
		_klass_->notify_raw_development_modified (self);
	}
}

static void
photo_real_notify_baseline_replaced (Photo* self)
{
	g_signal_emit (self, photo_signals[PHOTO_BASELINE_REPLACED_SIGNAL], 0);
}

void
photo_notify_baseline_replaced (Photo* self)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_baseline_replaced) {
		_klass_->notify_baseline_replaced (self);
	}
}

static void
photo_real_notify_master_reimported (Photo* self,
                                     PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, photo_signals[PHOTO_MASTER_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_master_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_master_reimported) {
		_klass_->notify_master_reimported (self, metadata);
	}
}

static void
photo_real_notify_editable_reimported (Photo* self,
                                       PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, photo_signals[PHOTO_EDITABLE_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_editable_reimported (Photo* self,
                                  PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_editable_reimported) {
		_klass_->notify_editable_reimported (self, metadata);
	}
}

static void
photo_real_notify_source_reimported (Photo* self,
                                     PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, photo_signals[PHOTO_SOURCE_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_source_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_source_reimported) {
		_klass_->notify_source_reimported (self, metadata);
	}
}

static void
photo_real_notify_baseline_reimported (Photo* self,
                                       PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, photo_signals[PHOTO_BASELINE_REIMPORTED_SIGNAL], 0, metadata);
}

void
photo_notify_baseline_reimported (Photo* self,
                                  PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->notify_baseline_reimported) {
		_klass_->notify_baseline_reimported (self, metadata);
	}
}

static gboolean
photo_real_internal_delete_backing (DataSource* base,
                                    GError** error)
{
	Photo * self;
	gboolean ret = FALSE;
	GFile* file = NULL;
	GFile* _tmp10_;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	ret = TRUE;
	file = NULL;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
				_g_object_unref0 (file);
				file = _tmp5_;
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp6_;
			_tmp6_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp7_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			return _tmp7_;
		}
	}
	photo_detach_editable (self, TRUE, FALSE, TRUE);
	if (photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW) {
		gint _tmp8_ = 0;
		RawDeveloper* _tmp9_;
		_tmp9_ = raw_developer_as_array (&_tmp8_);
		{
			RawDeveloper* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
			d_collection = _tmp9_;
			d_collection_length1 = _tmp8_;
			for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
				RawDeveloper d = 0;
				d = d_collection[d_it];
				{
					photo_delete_raw_development (self, d);
				}
			}
			d_collection = (g_free (d_collection), NULL);
		}
	}
	_tmp10_ = file;
	if (_tmp10_ != NULL) {
		{
			gboolean _tmp11_ = FALSE;
			GFile* _tmp12_;
			_tmp12_ = file;
			_tmp11_ = g_file_trash (_tmp12_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			ret = _tmp11_;
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GError* _tmp18_;
			const gchar* _tmp19_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			ret = FALSE;
			_tmp13_ = file;
			_tmp14_ = g_file_get_path (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
			_tmp17_ = _tmp16_;
			_tmp18_ = err;
			_tmp19_ = _tmp18_->message;
			g_message ("Photo.vala:531: Unable to move editable %s for %s to trash: %s", _tmp15_, _tmp17_, _tmp19_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp20_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			return _tmp20_;
		}
	}
	_tmp22_ = DATA_SOURCE_CLASS (photo_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp23_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return _tmp23_;
	}
	if (_tmp22_) {
		_tmp21_ = ret;
	} else {
		_tmp21_ = FALSE;
	}
	result = _tmp21_;
	_g_object_unref0 (file);
	return result;
}

static BackingPhotoRow*
photo_get_backing_row (Photo* self,
                       BackingPhotoID* id)
{
	BackingPhotoID _tmp0_;
	BackingPhotoRow* backing_row = NULL;
	BackingPhotoRow* _tmp12_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_tmp0_ = *id;
	if (_tmp0_.id == BACKING_PHOTO_ID_INVALID) {
		result = NULL;
		return result;
	}
	backing_row = NULL;
	{
		BackingPhotoRow* _tmp1_ = NULL;
		BackingPhotoTable* _tmp2_;
		BackingPhotoTable* _tmp3_;
		BackingPhotoID _tmp4_;
		BackingPhotoRow* _tmp5_;
		BackingPhotoRow* _tmp6_;
		BackingPhotoRow* _tmp7_;
		_tmp2_ = backing_photo_table_get_instance ();
		_tmp3_ = _tmp2_;
		_tmp4_ = *id;
		_tmp5_ = backing_photo_table_fetch (_tmp3_, &_tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_database_table_unref0 (_tmp3_);
		_tmp1_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_backing_photo_row_unref0 (backing_row);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp7_ = _tmp1_;
		_tmp1_ = NULL;
		_backing_photo_row_unref0 (backing_row);
		backing_row = _tmp7_;
		_backing_photo_row_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		GError* _tmp10_;
		const gchar* _tmp11_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp9_ = _tmp8_;
		_tmp10_ = err;
		_tmp11_ = _tmp10_->message;
		g_warning ("Photo.vala:550: Unable to fetch backing state for %s: %s", _tmp9_, _tmp11_);
		_g_free0 (_tmp9_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_backing_photo_row_unref0 (backing_row);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp12_ = backing_row;
	if (_tmp12_ == NULL) {
		{
			BackingPhotoTable* _tmp13_;
			BackingPhotoTable* _tmp14_;
			BackingPhotoID _tmp15_;
			_tmp13_ = backing_photo_table_get_instance ();
			_tmp14_ = _tmp13_;
			_tmp15_ = *id;
			backing_photo_table_remove (_tmp14_, &_tmp15_, &_inner_error0_);
			_database_table_unref0 (_tmp14_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch1_database_error;
				}
				_backing_photo_row_unref0 (backing_row);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		goto __finally1;
		__catch1_database_error:
		{
			g_clear_error (&_inner_error0_);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_backing_photo_row_unref0 (backing_row);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		result = NULL;
		_backing_photo_row_unref0 (backing_row);
		return result;
	}
	result = backing_row;
	return result;
}

gboolean
photo_is_raw_developer_complete (Photo* self,
                                 RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		GeeHashMap* _tmp0_;
		gboolean _tmp9_ = FALSE;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			gboolean _tmp1_ = FALSE;
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
				GeeHashMap* _tmp3_;
				gpointer _tmp4_;
				BackingPhotoRow* _tmp5_;
				const gchar* _tmp6_;
				_tmp3_ = self->priv->developments;
				_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
				_tmp5_ = (BackingPhotoRow*) _tmp4_;
				_tmp6_ = _tmp5_->filepath;
				_tmp1_ = g_file_test (_tmp6_, G_FILE_TEST_EXISTS);
				_backing_photo_row_unref0 (_tmp5_);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			{
				GeeHashMap* _tmp7_;
				_tmp7_ = self->priv->developments;
				g_rec_mutex_unlock (&self->priv->__lock_developments);
			}
			return result;
		}
		__finally0:
		{
			GeeHashMap* _tmp8_;
			_tmp8_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp9_;
	}
}

gboolean
photo_is_raw_developer_available (Photo* self,
                                  RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->developments;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
				result = TRUE;
				{
					GeeHashMap* _tmp2_;
					_tmp2_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return result;
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp3_;
			_tmp3_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp4_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
	}
	switch (d) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			result = TRUE;
			return result;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			result = FALSE;
			return result;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp5_;
				guint num_previews = 0U;
				PhotoMetadata* _tmp6_;
				_tmp5_ = photo_get_master_metadata (self, &_inner_error0_);
				meta = _tmp5_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp6_ = meta;
				num_previews = photo_metadata_get_preview_count (_tmp6_);
				if (num_previews > ((guint) 0)) {
					PhotoPreview* prev = NULL;
					PhotoMetadata* _tmp7_;
					PhotoPreview* _tmp8_;
					PhotoPreview* _tmp9_;
					Dimensions dims = {0};
					PhotoPreview* _tmp10_;
					Dimensions _tmp11_ = {0};
					gint _tmp12_ = 0;
					Dimensions _tmp13_;
					Dimensions _tmp14_;
					gint preview_major_axis = 0;
					_tmp7_ = meta;
					_tmp8_ = photo_metadata_get_preview (_tmp7_, num_previews - 1);
					prev = _tmp8_;
					_tmp9_ = prev;
					if (_tmp9_ == NULL) {
						result = FALSE;
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						return result;
					}
					_tmp10_ = prev;
					photo_preview_get_pixel_dimensions (_tmp10_, &_tmp11_);
					dims = _tmp11_;
					_tmp13_ = dims;
					_tmp14_ = dims;
					if (_tmp13_.width > _tmp14_.height) {
						Dimensions _tmp15_;
						_tmp15_ = dims;
						_tmp12_ = _tmp15_.width;
					} else {
						Dimensions _tmp16_;
						_tmp16_ = dims;
						_tmp12_ = _tmp16_.height;
					}
					preview_major_axis = _tmp12_;
					if (preview_major_axis < PHOTO_MIN_EMBEDDED_SIZE) {
						result = FALSE;
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						return result;
					}
					result = TRUE;
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					return result;
				}
				result = FALSE;
				_media_metadata_unref0 (meta);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* e = NULL;
				GError* _tmp17_;
				const gchar* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				g_debug ("Photo.vala:614: Error accessing embedded preview. Message: %s", _tmp18_);
				_g_error_free0 (e);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp19_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp19_;
			}
			result = FALSE;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

void
photo_add_backing_photo_for_development (Photo* self,
                                         RawDeveloper d,
                                         BackingPhotoRow* bpr,
                                         gboolean notify,
                                         GError** error)
{
	PhotoRow* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
	_tmp0_ = self->row;
	photo_import_developed_backing_photo (_tmp0_, d, bpr, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	{
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d), bpr);
		}
		__finally0:
		{
			GeeHashMap* _tmp3_;
			_tmp3_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	if (notify) {
		Alteration* _tmp4_;
		Alteration* _tmp5_;
		_tmp4_ = alteration_new ("image", "developer");
		_tmp5_ = _tmp4_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp5_);
		_alteration_unref0 (_tmp5_);
	}
}

void
photo_import_developed_backing_photo (PhotoRow* row,
                                      RawDeveloper d,
                                      BackingPhotoRow* bpr,
                                      GError** error)
{
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFile* _tmp2_;
	GFileInfo* _tmp3_;
	GDateTime* timestamp = NULL;
	GFileInfo* _tmp4_;
	GDateTime* _tmp5_;
	GDateTime* _tmp6_;
	GDateTime* _tmp7_;
	GDateTime* _tmp8_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp9_;
	PhotoFileInterrogator* _tmp10_;
	PhotoFileInterrogator* _tmp11_;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp12_;
	DetectedPhotoInformation* _tmp13_;
	gboolean _tmp14_ = FALSE;
	DetectedPhotoInformation* _tmp15_;
	DetectedPhotoInformation* _tmp17_;
	Dimensions _tmp18_;
	GFileInfo* _tmp19_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	Orientation _tmp22_ = 0;
	DetectedPhotoInformation* _tmp23_;
	PhotoMetadata* _tmp24_;
	BackingPhotoTable* _tmp27_;
	BackingPhotoTable* _tmp28_;
	PhotoTable* _tmp29_;
	PhotoTable* _tmp30_;
	BackingPhotoID _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_ROW (row));
	g_return_if_fail (IS_BACKING_PHOTO_ROW (bpr));
	_tmp0_ = bpr->filepath;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_query_info (_tmp2_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	info = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_modification_date_time (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = coarsify_date_time (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_date_time_unref0 (_tmp6_);
	timestamp = _tmp8_;
	_tmp9_ = file;
	_tmp10_ = photo_file_interrogator_new (_tmp9_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
	interrogator = _tmp10_;
	_tmp11_ = interrogator;
	photo_file_interrogator_interrogate (_tmp11_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_tmp12_ = interrogator;
	_tmp13_ = photo_file_interrogator_get_detected_photo_information (_tmp12_);
	detected = _tmp13_;
	_tmp15_ = detected;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		PhotoFileInterrogator* _tmp16_;
		_tmp16_ = interrogator;
		_tmp14_ = photo_file_interrogator_get_is_photo_corrupted (_tmp16_);
	}
	if (_tmp14_) {
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_tmp17_ = detected;
	_tmp18_ = _tmp17_->image_dim;
	bpr->dim = _tmp18_;
	_tmp19_ = info;
	bpr->filesize = g_file_info_get_size (_tmp19_);
	_tmp20_ = timestamp;
	_tmp21_ = _g_date_time_ref0 (_tmp20_);
	_g_date_time_unref0 (bpr->timestamp);
	bpr->timestamp = _tmp21_;
	_tmp23_ = detected;
	_tmp24_ = _tmp23_->metadata;
	if (_tmp24_ != NULL) {
		DetectedPhotoInformation* _tmp25_;
		PhotoMetadata* _tmp26_;
		_tmp25_ = detected;
		_tmp26_ = _tmp25_->metadata;
		_tmp22_ = photo_metadata_get_orientation (_tmp26_);
	} else {
		_tmp22_ = ORIENTATION_TOP_LEFT;
	}
	bpr->original_orientation = _tmp22_;
	_tmp27_ = backing_photo_table_get_instance ();
	_tmp28_ = _tmp27_;
	backing_photo_table_add (_tmp28_, bpr, &_inner_error0_);
	_database_table_unref0 (_tmp28_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_tmp29_ = photo_table_get_instance ();
	_tmp30_ = _tmp29_;
	_tmp31_ = bpr->id;
	photo_table_update_raw_development (_tmp30_, row, d, &_tmp31_, &_inner_error0_);
	_database_table_unref0 (_tmp30_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	_detected_photo_information_unref0 (detected);
	_photo_file_interrogator_unref0 (interrogator);
	_g_date_time_unref0 (timestamp);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}

static void
photo_develop_photo (Photo* self,
                     RawDeveloper d,
                     gboolean notify)
{
	gboolean wrote_img_to_disk = FALSE;
	BackingPhotoRow* bps = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	wrote_img_to_disk = FALSE;
	bps = NULL;
	switch (d) {
		case RAW_DEVELOPER_SHOTWELL:
		{
			{
				BackingPhotoRow* _tmp0_ = NULL;
				PhotoRow* _tmp1_;
				BackingPhotoRow* _tmp2_;
				const gchar* _tmp3_;
				BackingPhotoRow* _tmp4_;
				BackingPhotoRow* _tmp5_;
				GdkPixbuf* pix = NULL;
				GdkPixbuf* _tmp13_;
				PhotoFileWriter* writer = NULL;
				BackingPhotoRow* _tmp17_;
				const gchar* _tmp18_;
				PhotoFileWriter* _tmp19_;
				PhotoFileWriter* _tmp20_;
				GdkPixbuf* _tmp21_;
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp22_;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp23_;
				const gchar* _tmp24_;
				PhotoFileMetadataWriter* _tmp25_;
				PhotoFileMetadataWriter* _tmp26_;
				PhotoMetadata* _tmp27_;
				_tmp1_ = self->row;
				_tmp2_ = _tmp1_->master;
				_tmp3_ = _tmp2_->filepath;
				_tmp4_ = raw_developer_create_backing_row_for_development (d, _tmp3_, NULL, &_inner_error0_);
				_tmp0_ = _tmp4_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = _tmp0_;
				_tmp0_ = NULL;
				_backing_photo_row_unref0 (bps);
				bps = _tmp5_;
				pix = NULL;
				{
					PhotoBackingReaders* _tmp6_;
					_tmp6_ = self->priv->readers;
					g_rec_mutex_lock (&self->priv->__lock_readers);
					{
						GdkPixbuf* _tmp7_ = NULL;
						Scaling _tmp8_ = {0};
						GdkPixbuf* _tmp9_;
						GdkPixbuf* _tmp10_;
						scaling_for_original (&_tmp8_);
						_tmp9_ = photo_get_master_pixbuf (self, &_tmp8_, FALSE, &_inner_error0_);
						_tmp7_ = _tmp9_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp10_ = _tmp7_;
						_tmp7_ = NULL;
						_g_object_unref0 (pix);
						pix = _tmp10_;
						_g_object_unref0 (_tmp7_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* _lock_error_ = NULL;
						GError* _tmp11_;
						_lock_error_ = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp11_ = _lock_error_;
						_lock_error_ = NULL;
						_inner_error0_ = _tmp11_;
						_g_error_free0 (_lock_error_);
						goto __finally1;
					}
					__finally1:
					{
						GError* _inner_error1_ = NULL;
						PhotoBackingReaders* _tmp12_;
						_tmp12_ = self->priv->readers;
						g_rec_mutex_unlock (&self->priv->__lock_readers);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (pix);
						_backing_photo_row_unref0 (_tmp0_);
						goto __catch0_g_error;
					}
				}
				_tmp13_ = pix;
				if (_tmp13_ == NULL) {
					g_debug ("Photo.vala:686: Could not get preview pixbuf");
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp14_;
								_tmp14_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp14_, notify, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch2_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally2;
							__catch2_g_error:
							{
								GError* e = NULL;
								GError* _tmp15_;
								const gchar* _tmp16_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp15_ = e;
								_tmp16_ = _tmp15_->message;
								g_debug ("Photo.vala:718: Error adding backing photo as development. Message: %s", _tmp16_);
								_g_error_free0 (e);
							}
							__finally2:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch0_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp17_ = bps;
				_tmp18_ = _tmp17_->filepath;
				_tmp19_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp18_, &_inner_error0_);
				writer = _tmp19_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_tmp20_ = writer;
				_tmp21_ = pix;
				photo_file_writer_write (_tmp20_, _tmp21_, JPEG_QUALITY_HIGH, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				wrote_img_to_disk = TRUE;
				_tmp22_ = photo_get_master_metadata (self, &_inner_error0_);
				meta = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_tmp23_ = bps;
				_tmp24_ = _tmp23_->filepath;
				_tmp25_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp24_, &_inner_error0_);
				mwriter = _tmp25_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_media_metadata_unref0 (meta);
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_tmp26_ = mwriter;
				_tmp27_ = meta;
				photo_file_metadata_writer_write_metadata (_tmp26_, _tmp27_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (mwriter);
					_media_metadata_unref0 (meta);
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pix);
					_backing_photo_row_unref0 (_tmp0_);
					goto __catch0_g_error;
				}
				_photo_file_adapter_unref0 (mwriter);
				_media_metadata_unref0 (meta);
				_photo_file_adapter_unref0 (writer);
				_g_object_unref0 (pix);
				_backing_photo_row_unref0 (_tmp0_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = err;
				_tmp29_ = _tmp28_->message;
				g_debug ("Photo.vala:709: Error developing photo: %s", _tmp29_);
				_g_error_free0 (err);
			}
			__finally0:
			{
				GError* _inner_error1_ = NULL;
				if (wrote_img_to_disk) {
					{
						BackingPhotoRow* _tmp30_;
						_tmp30_ = bps;
						photo_add_backing_photo_for_development (self, d, _tmp30_, notify, &_inner_error1_);
						if (G_UNLIKELY (_inner_error1_ != NULL)) {
							goto __catch3_g_error;
						}
						photo_notify_raw_development_modified (self);
					}
					goto __finally3;
					__catch3_g_error:
					{
						GError* e = NULL;
						GError* _tmp31_;
						const gchar* _tmp32_;
						e = _inner_error1_;
						_inner_error1_ = NULL;
						_tmp31_ = e;
						_tmp32_ = _tmp31_->message;
						g_debug ("Photo.vala:718: Error adding backing photo as development. Message: %s", _tmp32_);
						_g_error_free0 (e);
					}
					__finally3:
					if (G_UNLIKELY (_inner_error1_ != NULL)) {
						_backing_photo_row_unref0 (bps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error1_->message, g_quark_to_string (_inner_error1_->domain), _inner_error1_->code);
						g_clear_error (&_inner_error1_);
						return;
					}
				}
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_backing_photo_row_unref0 (bps);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
		case RAW_DEVELOPER_CAMERA:
		{
			break;
		}
		case RAW_DEVELOPER_EMBEDDED:
		{
			{
				PhotoMetadata* meta = NULL;
				PhotoMetadata* _tmp33_;
				guint c = 0U;
				PhotoMetadata* _tmp34_;
				PhotoPreview* prev = NULL;
				PhotoMetadata* _tmp38_;
				PhotoPreview* _tmp39_;
				PhotoPreview* _tmp40_;
				GBytes* pix = NULL;
				PhotoPreview* _tmp44_;
				GBytes* _tmp45_;
				GBytes* _tmp46_;
				BackingPhotoRow* _tmp50_ = NULL;
				PhotoRow* _tmp51_;
				BackingPhotoRow* _tmp52_;
				const gchar* _tmp53_;
				BackingPhotoRow* _tmp54_;
				BackingPhotoRow* _tmp55_;
				gboolean _tmp56_ = FALSE;
				GBytes* _tmp57_;
				PhotoFileMetadataWriter* mwriter = NULL;
				BackingPhotoRow* _tmp76_;
				const gchar* _tmp77_;
				PhotoFileMetadataWriter* _tmp78_;
				PhotoFileMetadataWriter* _tmp79_;
				PhotoMetadata* _tmp80_;
				_tmp33_ = photo_get_master_metadata (self, &_inner_error0_);
				meta = _tmp33_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch4_g_error;
				}
				_tmp34_ = meta;
				c = photo_metadata_get_preview_count (_tmp34_);
				if (c <= ((guint) 0)) {
					_media_metadata_unref0 (meta);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp35_;
								_tmp35_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp35_, notify, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch5_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally5;
							__catch5_g_error:
							{
								GError* e = NULL;
								GError* _tmp36_;
								const gchar* _tmp37_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp36_ = e;
								_tmp37_ = _tmp36_->message;
								g_debug ("Photo.vala:788: Error adding backing photo as development. Message: %s", _tmp37_);
								_g_error_free0 (e);
							}
							__finally5:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch4_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp38_ = meta;
				_tmp39_ = photo_metadata_get_preview (_tmp38_, c - 1);
				prev = _tmp39_;
				_tmp40_ = prev;
				if (_tmp40_ == NULL) {
					g_debug ("Photo.vala:739: Could not get preview from metadata");
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp41_;
								_tmp41_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp41_, notify, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch6_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally6;
							__catch6_g_error:
							{
								GError* e = NULL;
								GError* _tmp42_;
								const gchar* _tmp43_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp42_ = e;
								_tmp43_ = _tmp42_->message;
								g_debug ("Photo.vala:788: Error adding backing photo as development. Message: %s", _tmp43_);
								_g_error_free0 (e);
							}
							__finally6:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch4_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp44_ = prev;
				_tmp45_ = photo_preview_flatten (_tmp44_, &_inner_error0_);
				pix = _tmp45_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp46_ = pix;
				if (_tmp46_ == NULL) {
					g_debug ("Photo.vala:745: Could not get preview pixbuf");
					_g_bytes_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					{
						GError* _inner_error0_ = NULL;
						if (wrote_img_to_disk) {
							{
								BackingPhotoRow* _tmp47_;
								_tmp47_ = bps;
								photo_add_backing_photo_for_development (self, d, _tmp47_, notify, &_inner_error0_);
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch7_g_error;
								}
								photo_notify_raw_development_modified (self);
							}
							goto __finally7;
							__catch7_g_error:
							{
								GError* e = NULL;
								GError* _tmp48_;
								const gchar* _tmp49_;
								e = _inner_error0_;
								_inner_error0_ = NULL;
								_tmp48_ = e;
								_tmp49_ = _tmp48_->message;
								g_debug ("Photo.vala:788: Error adding backing photo as development. Message: %s", _tmp49_);
								_g_error_free0 (e);
							}
							__finally7:
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch4_g_error;
							}
						}
					}
					_backing_photo_row_unref0 (bps);
					return;
				}
				_tmp51_ = self->row;
				_tmp52_ = _tmp51_->master;
				_tmp53_ = _tmp52_->filepath;
				_tmp54_ = raw_developer_create_backing_row_for_development (d, _tmp53_, NULL, &_inner_error0_);
				_tmp50_ = _tmp54_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_bytes_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp55_ = _tmp50_;
				_tmp50_ = NULL;
				_backing_photo_row_unref0 (bps);
				bps = _tmp55_;
				_tmp57_ = pix;
				_tmp56_ = jpeg_is_jpeg_bytes (_tmp57_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_backing_photo_row_unref0 (_tmp50_);
					_g_bytes_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				if (_tmp56_) {
					GFile* outfile = NULL;
					BackingPhotoRow* _tmp58_;
					const gchar* _tmp59_;
					GFile* _tmp60_;
					GFile* _tmp61_;
					GBytes* _tmp62_;
					gsize _tmp63_ = 0;
					guint8* _tmp64_;
					_tmp58_ = bps;
					_tmp59_ = _tmp58_->filepath;
					_tmp60_ = g_file_new_for_path (_tmp59_);
					outfile = _tmp60_;
					_tmp61_ = outfile;
					_tmp62_ = pix;
					_tmp64_ = g_bytes_get_data (_tmp62_, &_tmp63_);
					g_file_replace_contents (_tmp61_, (const char*) _tmp64_, (gsize) _tmp63_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (outfile);
						_backing_photo_row_unref0 (_tmp50_);
						_g_bytes_unref0 (pix);
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						goto __catch4_g_error;
					}
					_g_object_unref0 (outfile);
				} else {
					GdkPixbuf* pixbuf = NULL;
					PhotoPreview* _tmp65_;
					GdkPixbuf* _tmp66_;
					GdkPixbuf* _tmp67_;
					PhotoFileWriter* writer = NULL;
					BackingPhotoRow* _tmp71_;
					const gchar* _tmp72_;
					PhotoFileWriter* _tmp73_;
					PhotoFileWriter* _tmp74_;
					GdkPixbuf* _tmp75_;
					_tmp65_ = prev;
					_tmp66_ = photo_preview_get_pixbuf (_tmp65_, &_inner_error0_);
					pixbuf = _tmp66_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_backing_photo_row_unref0 (_tmp50_);
						_g_bytes_unref0 (pix);
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						goto __catch4_g_error;
					}
					_tmp67_ = pixbuf;
					if (_tmp67_ == NULL) {
						g_debug ("Photo.vala:761: Could not get preview pixbuf");
						_g_object_unref0 (pixbuf);
						_backing_photo_row_unref0 (_tmp50_);
						_g_bytes_unref0 (pix);
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						{
							GError* _inner_error0_ = NULL;
							if (wrote_img_to_disk) {
								{
									BackingPhotoRow* _tmp68_;
									_tmp68_ = bps;
									photo_add_backing_photo_for_development (self, d, _tmp68_, notify, &_inner_error0_);
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
										goto __catch8_g_error;
									}
									photo_notify_raw_development_modified (self);
								}
								goto __finally8;
								__catch8_g_error:
								{
									GError* e = NULL;
									GError* _tmp69_;
									const gchar* _tmp70_;
									e = _inner_error0_;
									_inner_error0_ = NULL;
									_tmp69_ = e;
									_tmp70_ = _tmp69_->message;
									g_debug ("Photo.vala:788: Error adding backing photo as development. Message: %s", _tmp70_);
									_g_error_free0 (e);
								}
								__finally8:
								if (G_UNLIKELY (_inner_error0_ != NULL)) {
									goto __catch4_g_error;
								}
							}
						}
						_backing_photo_row_unref0 (bps);
						return;
					}
					_tmp71_ = bps;
					_tmp72_ = _tmp71_->filepath;
					_tmp73_ = photo_file_format_create_writer (PHOTO_FILE_FORMAT_JFIF, _tmp72_, &_inner_error0_);
					writer = _tmp73_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (pixbuf);
						_backing_photo_row_unref0 (_tmp50_);
						_g_bytes_unref0 (pix);
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						goto __catch4_g_error;
					}
					_tmp74_ = writer;
					_tmp75_ = pixbuf;
					photo_file_writer_write (_tmp74_, _tmp75_, JPEG_QUALITY_HIGH, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_photo_file_adapter_unref0 (writer);
						_g_object_unref0 (pixbuf);
						_backing_photo_row_unref0 (_tmp50_);
						_g_bytes_unref0 (pix);
						_photo_preview_unref0 (prev);
						_media_metadata_unref0 (meta);
						goto __catch4_g_error;
					}
					_photo_file_adapter_unref0 (writer);
					_g_object_unref0 (pixbuf);
				}
				wrote_img_to_disk = TRUE;
				_tmp76_ = bps;
				_tmp77_ = _tmp76_->filepath;
				_tmp78_ = photo_file_format_create_metadata_writer (PHOTO_FILE_FORMAT_JFIF, _tmp77_, &_inner_error0_);
				mwriter = _tmp78_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_backing_photo_row_unref0 (_tmp50_);
					_g_bytes_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_tmp79_ = mwriter;
				_tmp80_ = meta;
				photo_file_metadata_writer_write_metadata (_tmp79_, _tmp80_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_photo_file_adapter_unref0 (mwriter);
					_backing_photo_row_unref0 (_tmp50_);
					_g_bytes_unref0 (pix);
					_photo_preview_unref0 (prev);
					_media_metadata_unref0 (meta);
					goto __catch4_g_error;
				}
				_photo_file_adapter_unref0 (mwriter);
				_backing_photo_row_unref0 (_tmp50_);
				_g_bytes_unref0 (pix);
				_photo_preview_unref0 (prev);
				_media_metadata_unref0 (meta);
			}
			goto __finally4;
			__catch4_g_error:
			{
				GError* e = NULL;
				GError* _tmp81_;
				const gchar* _tmp82_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp81_ = e;
				_tmp82_ = _tmp81_->message;
				g_debug ("Photo.vala:778: Error accessing embedded preview. Message: %s", _tmp82_);
				_g_error_free0 (e);
				{
					GError* _inner_error0_ = NULL;
					if (wrote_img_to_disk) {
						{
							BackingPhotoRow* _tmp83_;
							_tmp83_ = bps;
							photo_add_backing_photo_for_development (self, d, _tmp83_, notify, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch9_g_error;
							}
							photo_notify_raw_development_modified (self);
						}
						goto __finally9;
						__catch9_g_error:
						{
							GError* e = NULL;
							GError* _tmp84_;
							const gchar* _tmp85_;
							e = _inner_error0_;
							_inner_error0_ = NULL;
							_tmp84_ = e;
							_tmp85_ = _tmp84_->message;
							g_debug ("Photo.vala:788: Error adding backing photo as development. Message: %s", _tmp85_);
							_g_error_free0 (e);
						}
						__finally9:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_backing_photo_row_unref0 (bps);
						}
					}
				}
				_backing_photo_row_unref0 (bps);
				return;
			}
			__finally4:
			{
				GError* _inner_error1_ = NULL;
				if (wrote_img_to_disk) {
					{
						BackingPhotoRow* _tmp86_;
						_tmp86_ = bps;
						photo_add_backing_photo_for_development (self, d, _tmp86_, notify, &_inner_error1_);
						if (G_UNLIKELY (_inner_error1_ != NULL)) {
							goto __catch10_g_error;
						}
						photo_notify_raw_development_modified (self);
					}
					goto __finally10;
					__catch10_g_error:
					{
						GError* e = NULL;
						GError* _tmp87_;
						const gchar* _tmp88_;
						e = _inner_error1_;
						_inner_error1_ = NULL;
						_tmp87_ = e;
						_tmp88_ = _tmp87_->message;
						g_debug ("Photo.vala:788: Error adding backing photo as development. Message: %s", _tmp88_);
						_g_error_free0 (e);
					}
					__finally10:
					if (G_UNLIKELY (_inner_error1_ != NULL)) {
						_backing_photo_row_unref0 (bps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error1_->message, g_quark_to_string (_inner_error1_->domain), _inner_error1_->code);
						g_clear_error (&_inner_error1_);
						return;
					}
				}
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_backing_photo_row_unref0 (bps);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_backing_photo_row_unref0 (bps);
}

void
photo_set_default_raw_developer (Photo* self,
                                 RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			_tmp1_->developer = d;
		}
		__finally0:
		{
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_set_raw_developer (Photo* self,
                         RawDeveloper d,
                         gboolean notify)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
		return;
	}
	if (photo_is_raw_developer_available (self, RAW_DEVELOPER_CAMERA)) {
		_tmp0_ = d == RAW_DEVELOPER_EMBEDDED;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		d = RAW_DEVELOPER_CAMERA;
	}
	if (!photo_is_raw_developer_available (self, RAW_DEVELOPER_EMBEDDED)) {
		_tmp1_ = d != RAW_DEVELOPER_CAMERA;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		d = RAW_DEVELOPER_SHOTWELL;
	}
	{
		GeeHashMap* _tmp2_;
		_tmp2_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			RawDeveloper stale_raw_developer = 0;
			PhotoRow* _tmp3_;
			GeeHashMap* _tmp4_;
			PhotoRow* _tmp6_;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			PhotoBackingReaders* _tmp9_;
			BackingPhotoRow* _tmp10_;
			BackingPhotoRow* _tmp11_;
			const gchar* _tmp12_;
			PhotoFileReader* _tmp13_;
			BackingPhotoRow* _tmp17_;
			gboolean _tmp25_ = FALSE;
			_tmp3_ = self->row;
			stale_raw_developer = _tmp3_->developer;
			if (!photo_is_raw_developer_complete (self, d)) {
				photo_develop_photo (self, d, notify);
			}
			_tmp4_ = self->priv->developments;
			if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
				{
					GeeHashMap* _tmp5_;
					_tmp5_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return;
			}
			photo_revert_to_master (self, FALSE);
			_tmp6_ = self->row;
			_tmp6_->developer = d;
			_tmp7_ = self->priv->developments;
			_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
			_backing_photo_row_unref0 (self->backing_photo_row);
			self->backing_photo_row = (BackingPhotoRow*) _tmp8_;
			_tmp9_ = self->priv->readers;
			_tmp10_ = self->backing_photo_row;
			_tmp11_ = self->backing_photo_row;
			_tmp12_ = _tmp11_->filepath;
			_tmp13_ = photo_file_format_create_reader (_tmp10_->file_format, _tmp12_);
			_photo_file_adapter_unref0 (_tmp9_->developer);
			_tmp9_->developer = _tmp13_;
			{
				GdkPixbuf* _tmp14_;
				GdkPixbuf* _tmp15_;
				_tmp14_ = photo_get_prefetched_copy (self, &_inner_error0_);
				_tmp15_ = _tmp14_;
				_g_object_unref0 (_tmp15_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				g_clear_error (&_inner_error0_);
				{
					GeeHashMap* _tmp16_;
					_tmp16_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return;
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp17_ = self->backing_photo_row;
			photo_set_orientation (self, _tmp17_->original_orientation);
			{
				PhotoTable* _tmp18_;
				PhotoTable* _tmp19_;
				PhotoRow* _tmp20_;
				BackingPhotoRow* _tmp21_;
				BackingPhotoID _tmp22_;
				_tmp18_ = photo_table_get_instance ();
				_tmp19_ = _tmp18_;
				_tmp20_ = self->row;
				_tmp21_ = self->backing_photo_row;
				_tmp22_ = _tmp21_->id;
				photo_table_update_raw_development (_tmp19_, _tmp20_, d, &_tmp22_, &_inner_error0_);
				_database_table_unref0 (_tmp19_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp23_;
				const gchar* _tmp24_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp23_ = e;
				_tmp24_ = _tmp23_->message;
				g_warning ("Photo.vala:853: Error updating database: %s", _tmp24_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (stale_raw_developer != RAW_DEVELOPER_CAMERA) {
				PhotoRow* _tmp26_;
				_tmp26_ = self->row;
				_tmp25_ = stale_raw_developer != _tmp26_->developer;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				photo_delete_raw_development (self, stale_raw_developer);
			}
		}
		__finally0:
		{
			GeeHashMap* _tmp27_;
			_tmp27_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (notify) {
		Alteration* _tmp28_;
		Alteration* _tmp29_;
		_tmp28_ = alteration_new ("image", "developer");
		_tmp29_ = _tmp28_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp29_);
		_alteration_unref0 (_tmp29_);
	}
	photo_discard_prefetched (self);
}

RawDeveloper
photo_get_raw_developer (Photo* self)
{
	PhotoRow* _tmp0_;
	RawDeveloper result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	_tmp0_ = self->row;
	result = _tmp0_->developer;
	return result;
}

static gboolean
photo_delete_raw_development (Photo* self,
                              RawDeveloper d)
{
	gboolean ret = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	ret = FALSE;
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			GeeHashMap* _tmp1_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			BackingPhotoRow* bpr = NULL;
			GeeHashMap* _tmp7_;
			gpointer _tmp8_;
			BackingPhotoRow* _tmp9_;
			const gchar* _tmp10_;
			GeeHashMap* _tmp31_;
			_tmp1_ = self->priv->developments;
			if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d))) {
				result = FALSE;
				{
					GeeHashMap* _tmp2_;
					_tmp2_ = self->priv->developments;
					g_rec_mutex_unlock (&self->priv->__lock_developments);
				}
				return result;
			}
			_tmp3_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
			_tmp4_ = _tmp3_;
			_tmp5_ = raw_developer_to_string (d);
			_tmp6_ = _tmp5_;
			g_debug ("Photo.vala:891: Delete raw development: %s %s", _tmp4_, _tmp6_);
			_g_free0 (_tmp6_);
			_g_free0 (_tmp4_);
			_tmp7_ = self->priv->developments;
			_tmp8_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
			bpr = (BackingPhotoRow*) _tmp8_;
			_tmp9_ = bpr;
			_tmp10_ = _tmp9_->filepath;
			if (_tmp10_ != NULL) {
				GFile* f = NULL;
				BackingPhotoRow* _tmp11_;
				const gchar* _tmp12_;
				GFile* _tmp13_;
				_tmp11_ = bpr;
				_tmp12_ = _tmp11_->filepath;
				_tmp13_ = g_file_new_for_path (_tmp12_);
				f = _tmp13_;
				{
					if (d == RAW_DEVELOPER_CAMERA) {
						GFile* _tmp14_;
						_tmp14_ = f;
						g_file_trash (_tmp14_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					} else {
						GFile* _tmp15_;
						_tmp15_ = f;
						g_file_delete (_tmp15_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch1_g_error;
						}
					}
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					BackingPhotoRow* _tmp16_;
					const gchar* _tmp17_;
					GError* _tmp18_;
					const gchar* _tmp19_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp16_ = bpr;
					_tmp17_ = _tmp16_->filepath;
					_tmp18_ = e;
					_tmp19_ = _tmp18_->message;
					g_warning ("Photo.vala:901: Unable to delete RAW development: %s error: %s", _tmp17_, _tmp19_);
					_g_error_free0 (e);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp20_ = FALSE;
					_g_object_unref0 (f);
					_backing_photo_row_unref0 (bpr);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp20_;
				}
				_g_object_unref0 (f);
			}
			{
				PhotoTable* _tmp21_;
				PhotoTable* _tmp22_;
				PhotoRow* _tmp23_;
				BackingPhotoTable* _tmp24_;
				BackingPhotoTable* _tmp25_;
				BackingPhotoRow* _tmp26_;
				BackingPhotoID _tmp27_;
				_tmp21_ = photo_table_get_instance ();
				_tmp22_ = _tmp21_;
				_tmp23_ = self->row;
				photo_table_remove_development (_tmp22_, _tmp23_, d, &_inner_error0_);
				_database_table_unref0 (_tmp22_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
				_tmp24_ = backing_photo_table_get_instance ();
				_tmp25_ = _tmp24_;
				_tmp26_ = bpr;
				_tmp27_ = _tmp26_->id;
				backing_photo_table_remove (_tmp25_, &_tmp27_, &_inner_error0_);
				_database_table_unref0 (_tmp25_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* e = NULL;
				GError* _tmp28_;
				const gchar* _tmp29_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = e;
				_tmp29_ = _tmp28_->message;
				g_warning ("Photo.vala:910: Database error while deleting RAW development: %s", _tmp29_);
				_g_error_free0 (e);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp30_ = FALSE;
				_backing_photo_row_unref0 (bpr);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp30_;
			}
			_tmp31_ = self->priv->developments;
			ret = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d), NULL);
			_backing_photo_row_unref0 (bpr);
		}
		__finally0:
		{
			GeeHashMap* _tmp32_;
			_tmp32_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp33_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp33_;
		}
	}
	photo_notify_raw_development_modified (self);
	result = ret;
	return result;
}

void
photo_redevelop_raw (Photo* self,
                     RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	{
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->developments;
		g_rec_mutex_lock (&self->priv->__lock_developments);
		{
			RawDeveloper dev = 0;
			photo_delete_raw_development (self, d);
			dev = d;
			if (dev == RAW_DEVELOPER_CAMERA) {
				dev = RAW_DEVELOPER_EMBEDDED;
			}
			photo_set_raw_developer (self, dev, TRUE);
		}
		__finally0:
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->developments;
			g_rec_mutex_unlock (&self->priv->__lock_developments);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
_vala_array_add83 (BackingFileState** * array,
                   gint* length,
                   gint* size,
                   BackingFileState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add84 (BackingFileState** * array,
                   gint* length,
                   gint* size,
                   BackingFileState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add85 (BackingFileState** * array,
                   gint* length,
                   gint* size,
                   BackingFileState* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (BackingFileState*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static BackingFileState**
photo_real_get_backing_files_state (MediaSource* base,
                                    gint* result_length1)
{
	Photo * self;
	BackingFileState** backing = NULL;
	BackingFileState** _tmp0_;
	gint backing_length1;
	gint _backing_size_;
	BackingFileState** _tmp21_;
	gint _tmp21__length1;
	GError* _inner_error0_ = NULL;
	BackingFileState** result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = g_new0 (BackingFileState*, 0 + 1);
	backing = _tmp0_;
	backing_length1 = 0;
	_backing_size_ = backing_length1;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
			PhotoRow* _tmp4_;
			const gchar* _tmp5_;
			BackingFileState* _tmp6_;
			_tmp2_ = self->row;
			_tmp3_ = _tmp2_->master;
			_tmp4_ = self->row;
			_tmp5_ = _tmp4_->md5;
			_tmp6_ = backing_file_state_new_from_photo_row (_tmp3_, _tmp5_);
			_vala_array_add83 (&backing, &backing_length1, &_backing_size_, _tmp6_);
			if (photo_has_editable (self)) {
				BackingPhotoRow* _tmp7_;
				BackingFileState* _tmp8_;
				_tmp7_ = self->priv->editable;
				_tmp8_ = backing_file_state_new_from_photo_row (_tmp7_, NULL);
				_vala_array_add84 (&backing, &backing_length1, &_backing_size_, _tmp8_);
			}
			if (photo_is_developed (self)) {
				GeeCollection* dev_rows = NULL;
				GeeCollection* _tmp9_;
				GeeCollection* _tmp10_;
				_tmp9_ = photo_get_raw_development_photo_rows (self);
				dev_rows = _tmp9_;
				_tmp10_ = dev_rows;
				if (_tmp10_ != NULL) {
					{
						GeeIterator* _r_it = NULL;
						GeeCollection* _tmp11_;
						GeeIterator* _tmp12_;
						_tmp11_ = dev_rows;
						_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
						_r_it = _tmp12_;
						while (TRUE) {
							GeeIterator* _tmp13_;
							BackingPhotoRow* r = NULL;
							GeeIterator* _tmp14_;
							gpointer _tmp15_;
							BackingPhotoRow* _tmp16_;
							const gchar* _tmp17_;
							BackingPhotoRow* _tmp18_;
							BackingFileState* _tmp19_;
							_tmp13_ = _r_it;
							if (!gee_iterator_next (_tmp13_)) {
								break;
							}
							_tmp14_ = _r_it;
							_tmp15_ = gee_iterator_get (_tmp14_);
							r = (BackingPhotoRow*) _tmp15_;
							_tmp16_ = r;
							_tmp17_ = _tmp16_->filepath;
							g_debug ("Photo.vala:943: adding: %s", _tmp17_);
							_tmp18_ = r;
							_tmp19_ = backing_file_state_new_from_photo_row (_tmp18_, NULL);
							_vala_array_add85 (&backing, &backing_length1, &_backing_size_, _tmp19_);
							_backing_photo_row_unref0 (r);
						}
						_g_object_unref0 (_r_it);
					}
				}
				_g_object_unref0 (dev_rows);
			}
		}
		__finally0:
		{
			PhotoRow* _tmp20_;
			_tmp20_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			backing = (_vala_array_free (backing, backing_length1, (GDestroyNotify) backing_file_state_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp21_ = backing;
	_tmp21__length1 = backing_length1;
	if (result_length1) {
		*result_length1 = _tmp21__length1;
	}
	result = _tmp21_;
	return result;
}

static PhotoFileReader*
photo_get_backing_reader (Photo* self,
                          BackingFetchMode mode)
{
	PhotoFileReader* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	switch (mode) {
		case BACKING_FETCH_MODE_MASTER:
		{
			PhotoFileReader* _tmp0_;
			_tmp0_ = photo_get_master_reader (self);
			result = _tmp0_;
			return result;
		}
		case BACKING_FETCH_MODE_BASELINE:
		{
			PhotoFileReader* _tmp1_;
			_tmp1_ = photo_get_baseline_reader (self);
			result = _tmp1_;
			return result;
		}
		case BACKING_FETCH_MODE_SOURCE:
		{
			PhotoFileReader* _tmp2_;
			_tmp2_ = photo_get_source_reader (self);
			result = _tmp2_;
			return result;
		}
		case BACKING_FETCH_MODE_UNMODIFIED:
		{
			if (photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW) {
				PhotoFileReader* _tmp3_;
				_tmp3_ = photo_get_raw_developer_reader (self);
				result = _tmp3_;
				return result;
			} else {
				PhotoFileReader* _tmp4_;
				_tmp4_ = photo_get_master_reader (self);
				result = _tmp4_;
				return result;
			}
		}
		default:
		{
			GEnumValue* _tmp5_;
			_tmp5_ = g_enum_get_value (g_type_class_ref (TYPE_BACKING_FETCH_MODE), mode);
			g_error ("Photo.vala:971: Unknown backing fetch mode %s", (_tmp5_ != NULL) ? _tmp5_->value_name : NULL);
		}
	}
}

static gpointer
_photo_file_adapter_ref0 (gpointer self)
{
	return self ? photo_file_adapter_ref (self) : NULL;
}

static PhotoFileReader*
photo_get_master_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->master;
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoBackingReaders* _tmp4_;
				_tmp4_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp5_;
			_tmp5_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

PhotoFileReader*
photo_get_editable_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoBackingReaders* _tmp4_;
				_tmp4_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp5_;
			_tmp5_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileReader*
photo_get_baseline_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp7_;
			PhotoFileReader* _tmp8_;
			PhotoBackingReaders* _tmp13_;
			PhotoFileReader* _tmp14_;
			PhotoFileReader* _tmp15_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
				result = _tmp5_;
				{
					PhotoBackingReaders* _tmp6_;
					_tmp6_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp7_ = self->priv->readers;
			_tmp8_ = _tmp7_->developer;
			if (_tmp8_ != NULL) {
				PhotoBackingReaders* _tmp9_;
				PhotoFileReader* _tmp10_;
				PhotoFileReader* _tmp11_;
				_tmp9_ = self->priv->readers;
				_tmp10_ = _tmp9_->developer;
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
				result = _tmp11_;
				{
					PhotoBackingReaders* _tmp12_;
					_tmp12_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp13_ = self->priv->readers;
			_tmp14_ = _tmp13_->master;
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
			result = _tmp15_;
			{
				PhotoBackingReaders* _tmp16_;
				_tmp16_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp17_;
			_tmp17_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileReader*
photo_get_source_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp7_;
			PhotoFileReader* _tmp8_;
			PhotoBackingReaders* _tmp13_;
			PhotoFileReader* _tmp14_;
			PhotoFileReader* _tmp15_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = _photo_file_adapter_ref0 (_tmp4_);
				result = _tmp5_;
				{
					PhotoBackingReaders* _tmp6_;
					_tmp6_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp7_ = self->priv->readers;
			_tmp8_ = _tmp7_->developer;
			if (_tmp8_ != NULL) {
				PhotoBackingReaders* _tmp9_;
				PhotoFileReader* _tmp10_;
				PhotoFileReader* _tmp11_;
				_tmp9_ = self->priv->readers;
				_tmp10_ = _tmp9_->developer;
				_tmp11_ = _photo_file_adapter_ref0 (_tmp10_);
				result = _tmp11_;
				{
					PhotoBackingReaders* _tmp12_;
					_tmp12_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return result;
			}
			_tmp13_ = self->priv->readers;
			_tmp14_ = _tmp13_->master;
			_tmp15_ = _photo_file_adapter_ref0 (_tmp14_);
			result = _tmp15_;
			{
				PhotoBackingReaders* _tmp16_;
				_tmp16_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp17_;
			_tmp17_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileReader*
photo_get_raw_developer_reader (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileReader* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->developer;
			_tmp3_ = _photo_file_adapter_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoBackingReaders* _tmp4_;
				_tmp4_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp5_;
			_tmp5_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

gboolean
photo_is_developed (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->developer;
			result = _tmp2_ != NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_has_editable (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			result = _tmp2_ != NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_does_master_exist (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->master;
			result = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_does_editable_exist (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp8_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp2_ = self->priv->readers;
			_tmp3_ = _tmp2_->editable;
			if (_tmp3_ != NULL) {
				PhotoBackingReaders* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp4_ = self->priv->readers;
				_tmp5_ = _tmp4_->editable;
				_tmp1_ = photo_file_adapter_file_exists (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			{
				PhotoBackingReaders* _tmp6_;
				_tmp6_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp7_;
			_tmp7_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
}

gboolean
photo_is_master_baseline (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			result = _tmp2_ == NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_is_master_source (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	result = !photo_has_editable (self);
	return result;
}

gboolean
photo_is_editable_baseline (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoBackingReaders* _tmp0_;
		gboolean _tmp5_ = FALSE;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			result = _tmp2_ != NULL;
			{
				PhotoBackingReaders* _tmp3_;
				_tmp3_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			return result;
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp4_;
			_tmp4_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

gboolean
photo_is_editable_source (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	result = photo_has_editable (self);
	return result;
}

BackingPhotoRow*
photo_get_master_photo_row (Photo* self)
{
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			BackingPhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->master;
			_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

BackingPhotoRow*
photo_get_editable_photo_row (Photo* self)
{
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (backing_photo_id_is_valid (&_tmp1_->editable_id)) {
				BackingPhotoRow* _tmp2_;
				BackingPhotoRow* _tmp3_;
				_tmp2_ = self->priv->editable;
				_tmp3_ = _backing_photo_row_ref0 (_tmp2_);
				result = _tmp3_;
				{
					PhotoRow* _tmp4_;
					_tmp4_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				return result;
			} else {
				result = NULL;
				{
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				return result;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

GeeCollection*
photo_get_raw_development_photo_rows (Photo* self)
{
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			GeeCollection* _tmp1_ = NULL;
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
				_tmp3_ = self->priv->developments;
				_tmp4_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
				_tmp5_ = _tmp4_;
				_g_object_unref0 (_tmp1_);
				_tmp1_ = _tmp5_;
			} else {
				_g_object_unref0 (_tmp1_);
				_tmp1_ = NULL;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

BackingPhotoRow*
photo_get_raw_development_photo_row (Photo* self,
                                     RawDeveloper d)
{
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_ = NULL;
			GeeHashMap* _tmp2_;
			_tmp2_ = self->priv->developments;
			if (_tmp2_ != NULL) {
				GeeHashMap* _tmp3_;
				gpointer _tmp4_;
				_tmp3_ = self->priv->developments;
				_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d));
				_backing_photo_row_unref0 (_tmp1_);
				_tmp1_ = (BackingPhotoRow*) _tmp4_;
			} else {
				_backing_photo_row_unref0 (_tmp1_);
				_tmp1_ = NULL;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp5_;
				_tmp5_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static PhotoFileFormat*
_photo_file_format_dup (PhotoFileFormat* self)
{
	PhotoFileFormat* dup;
	dup = g_new0 (PhotoFileFormat, 1);
	memcpy (dup, self, sizeof (PhotoFileFormat));
	return dup;
}

static gpointer
__photo_file_format_dup0 (gpointer self)
{
	return self ? _photo_file_format_dup (self) : NULL;
}

PhotoFileFormat*
photo_get_editable_file_format (Photo* self)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileFormat _tmp3_;
	PhotoFileFormat* _tmp4_;
	PhotoFileFormat* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp1_ = reader;
	if (_tmp1_ == NULL) {
		result = NULL;
		_photo_file_adapter_unref0 (reader);
		return result;
	}
	_tmp2_ = reader;
	_tmp3_ = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp4_ = __photo_file_format_dup0 (&_tmp3_);
	result = _tmp4_;
	_photo_file_adapter_unref0 (reader);
	return result;
}

PhotoFileFormat
photo_get_export_format_for_parameters (Photo* self,
                                        ExportFormatParameters* params)
{
	PhotoFileFormat _result_ = 0;
	ExportFormatParameters _tmp0_;
	PhotoFileFormat result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	g_return_val_if_fail (params != NULL, 0);
	_result_ = photo_file_format_get_system_default_format ();
	_tmp0_ = *params;
	switch (_tmp0_.mode) {
		case EXPORT_FORMAT_MODE_UNMODIFIED:
		{
			_result_ = photo_get_master_file_format (self);
			break;
		}
		case EXPORT_FORMAT_MODE_CURRENT:
		{
			_result_ = photo_get_best_export_file_format (self);
			break;
		}
		case EXPORT_FORMAT_MODE_SPECIFIED:
		{
			ExportFormatParameters _tmp1_;
			_tmp1_ = *params;
			_result_ = _tmp1_.specified_format;
			break;
		}
		default:
		{
			g_error ("Photo.vala:1119: get_export_format_for_parameters: unsupported export " \
"format mode");
		}
	}
	result = _result_;
	return result;
}

gchar*
photo_get_export_basename_for_parameters (Photo* self,
                                          ExportFormatParameters* params)
{
	gchar* _result_ = NULL;
	ExportFormatParameters _tmp0_;
	const gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (params != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = *params;
	switch (_tmp0_.mode) {
		case EXPORT_FORMAT_MODE_UNMODIFIED:
		{
			GFile* _tmp1_;
			GFile* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp2_ = _tmp1_;
			_tmp3_ = g_file_get_basename (_tmp2_);
			_g_free0 (_result_);
			_result_ = _tmp3_;
			_g_object_unref0 (_tmp2_);
			break;
		}
		case EXPORT_FORMAT_MODE_CURRENT:
		case EXPORT_FORMAT_MODE_SPECIFIED:
		{
			ExportFormatParameters _tmp4_;
			PhotoFileFormat _tmp5_;
			gchar* _tmp6_;
			_tmp4_ = *params;
			_tmp5_ = photo_get_export_format_for_parameters (self, &_tmp4_);
			_tmp6_ = photo_get_export_basename (self, &_tmp5_);
			result = _tmp6_;
			_g_free0 (_result_);
			return result;
		}
		default:
		{
			g_error ("Photo.vala:1138: get_export_basename_for_parameters: unsupported expor" \
"t format mode");
		}
	}
	_tmp7_ = _result_;
	_vala_assert (_tmp7_ != NULL, "result != null");
	result = _result_;
	return result;
}

ImportResult
photo_prepare_for_import (PhotoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileInfo* info = NULL;
	GFileInfo* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp11_;
	GDateTime* timestamp = NULL;
	GFileInfo* _tmp15_;
	GDateTime* _tmp16_;
	GDateTime* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* _tmp19_;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	const gchar* _tmp22_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp25_;
	PhotoFileInterrogator* _tmp26_;
	PhotoFileInterrogator* _tmp33_;
	DetectedPhotoInformation* detected = NULL;
	PhotoFileInterrogator* _tmp34_;
	DetectedPhotoInformation* _tmp35_;
	gboolean _tmp36_ = FALSE;
	DetectedPhotoInformation* _tmp37_;
	Orientation orientation = 0;
	GDateTime* exposure_time = NULL;
	gchar* title = NULL;
	gchar* _tmp48_;
	GpsCoords gps_coords = {0};
	gchar* comment = NULL;
	gchar* _tmp49_;
	Rating rating = 0;
	DetectedPhotoInformation* _tmp50_;
	PhotoMetadata* _tmp51_;
	gboolean _tmp74_ = FALSE;
	gboolean _tmp75_ = FALSE;
	DetectedPhotoInformation* _tmp76_;
	PhotoRow* _tmp82_;
	PhotoRow* _tmp83_;
	BackingPhotoRow* _tmp84_;
	GFile* _tmp85_;
	gchar* _tmp86_;
	PhotoRow* _tmp87_;
	BackingPhotoRow* _tmp88_;
	DetectedPhotoInformation* _tmp89_;
	Dimensions _tmp90_;
	PhotoRow* _tmp91_;
	BackingPhotoRow* _tmp92_;
	GFileInfo* _tmp93_;
	PhotoRow* _tmp94_;
	BackingPhotoRow* _tmp95_;
	GDateTime* _tmp96_;
	GDateTime* _tmp97_;
	PhotoRow* _tmp98_;
	GDateTime* _tmp99_;
	GDateTime* _tmp100_;
	PhotoRow* _tmp101_;
	PhotoRow* _tmp102_;
	BackingPhotoRow* _tmp103_;
	PhotoRow* _tmp104_;
	ImportID _tmp105_;
	PhotoRow* _tmp106_;
	PhotoRow* _tmp107_;
	PhotoRow* _tmp108_;
	DetectedPhotoInformation* _tmp109_;
	const gchar* _tmp110_;
	gchar* _tmp111_;
	PhotoRow* _tmp112_;
	DetectedPhotoInformation* _tmp113_;
	const gchar* _tmp114_;
	gchar* _tmp115_;
	PhotoRow* _tmp116_;
	DetectedPhotoInformation* _tmp117_;
	const gchar* _tmp118_;
	gchar* _tmp119_;
	PhotoRow* _tmp120_;
	PhotoRow* _tmp121_;
	PhotoRow* _tmp122_;
	BackingPhotoRow* _tmp123_;
	DetectedPhotoInformation* _tmp124_;
	PhotoRow* _tmp125_;
	const gchar* _tmp126_;
	gchar* _tmp127_;
	PhotoRow* _tmp128_;
	GpsCoords _tmp129_;
	PhotoRow* _tmp130_;
	const gchar* _tmp131_;
	gchar* _tmp132_;
	PhotoRow* _tmp133_;
	Thumbnails* _tmp134_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (IS_PHOTO_IMPORT_PARAMS (params), 0);
	_tmp0_ = params->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	info = NULL;
	{
		GFileInfo* _tmp2_ = NULL;
		GFile* _tmp3_;
		GFileInfo* _tmp4_;
		GFileInfo* _tmp5_;
		_tmp3_ = file;
		_tmp4_ = g_file_query_info (_tmp3_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (info);
		info = _tmp5_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = IMPORT_RESULT_FILE_ERROR;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp6_ = info;
	if (g_file_info_get_file_type (_tmp6_) != G_FILE_TYPE_REGULAR) {
		result = IMPORT_RESULT_NOT_A_FILE;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp7_ = file;
	if (!photo_is_file_image (_tmp7_)) {
		GFile* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = file;
		_tmp9_ = g_file_get_path (_tmp8_);
		_tmp10_ = _tmp9_;
		g_message ("Photo.vala:1175: Not importing %s: Not an image file", _tmp10_);
		_g_free0 (_tmp10_);
		result = IMPORT_RESULT_NOT_AN_IMAGE;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp11_ = file;
	if (!photo_file_format_is_file_supported (_tmp11_)) {
		GFile* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = file;
		_tmp13_ = g_file_get_path (_tmp12_);
		_tmp14_ = _tmp13_;
		g_message ("Photo.vala:1181: Not importing %s: Unsupported extension", _tmp14_);
		_g_free0 (_tmp14_);
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp15_ = info;
	_tmp16_ = g_file_info_get_modification_date_time (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = coarsify_date_time (_tmp17_);
	_tmp19_ = _tmp18_;
	_g_date_time_unref0 (_tmp17_);
	timestamp = _tmp19_;
	_tmp22_ = params->exif_md5;
	if (_tmp22_ != NULL) {
		const gchar* _tmp23_;
		_tmp23_ = params->thumbnail_md5;
		_tmp21_ = _tmp23_ != NULL;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		const gchar* _tmp24_;
		_tmp24_ = params->full_md5;
		_tmp20_ = _tmp24_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		params->sniffer_options = params->sniffer_options | PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5;
	}
	_tmp25_ = file;
	_tmp26_ = photo_file_interrogator_new (_tmp25_, params->sniffer_options);
	interrogator = _tmp26_;
	{
		PhotoFileInterrogator* _tmp27_;
		_tmp27_ = interrogator;
		photo_file_interrogator_interrogate (_tmp27_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		GFile* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp28_ = file;
		_tmp29_ = g_file_get_path (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = err;
		_tmp32_ = _tmp31_->message;
		g_warning ("Photo.vala:1197: Unable to interrogate photo file %s: %s", _tmp30_, _tmp32_);
		_g_free0 (_tmp30_);
		result = IMPORT_RESULT_DECODE_ERROR;
		_g_error_free0 (err);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp33_ = interrogator;
	if (photo_file_interrogator_get_is_photo_corrupted (_tmp33_)) {
		result = IMPORT_RESULT_NOT_AN_IMAGE;
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp34_ = interrogator;
	_tmp35_ = photo_file_interrogator_get_detected_photo_information (_tmp34_);
	detected = _tmp35_;
	_tmp37_ = detected;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp38_;
		_tmp38_ = detected;
		_tmp36_ = _tmp38_->file_format == PHOTO_FILE_FORMAT_UNKNOWN;
	}
	if (_tmp36_) {
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	if ((params->sniffer_options & PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5) != 0) {
		DetectedPhotoInformation* _tmp39_;
		const gchar* _tmp40_;
		gchar* _tmp41_;
		DetectedPhotoInformation* _tmp42_;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		DetectedPhotoInformation* _tmp45_;
		const gchar* _tmp46_;
		gchar* _tmp47_;
		_tmp39_ = detected;
		_tmp40_ = params->exif_md5;
		_tmp41_ = g_strdup (_tmp40_);
		_g_free0 (_tmp39_->exif_md5);
		_tmp39_->exif_md5 = _tmp41_;
		_tmp42_ = detected;
		_tmp43_ = params->thumbnail_md5;
		_tmp44_ = g_strdup (_tmp43_);
		_g_free0 (_tmp42_->thumbnail_md5);
		_tmp42_->thumbnail_md5 = _tmp44_;
		_tmp45_ = detected;
		_tmp46_ = params->full_md5;
		_tmp47_ = g_strdup (_tmp46_);
		_g_free0 (_tmp45_->md5);
		_tmp45_->md5 = _tmp47_;
	}
	orientation = ORIENTATION_TOP_LEFT;
	exposure_time = NULL;
	_tmp48_ = g_strdup ("");
	title = _tmp48_;
	memset (&gps_coords, 0, sizeof (GpsCoords));
	_tmp49_ = g_strdup ("");
	comment = _tmp49_;
	rating = RATING_UNRATED;
	_tmp50_ = detected;
	_tmp51_ = _tmp50_->metadata;
	if (_tmp51_ != NULL) {
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp52_;
		PhotoMetadata* _tmp53_;
		MetadataDateTime* _tmp54_;
		MetadataDateTime* _tmp55_;
		DetectedPhotoInformation* _tmp58_;
		PhotoMetadata* _tmp59_;
		DetectedPhotoInformation* _tmp60_;
		PhotoMetadata* _tmp61_;
		gchar* _tmp62_;
		DetectedPhotoInformation* _tmp63_;
		PhotoMetadata* _tmp64_;
		GpsCoords _tmp65_ = {0};
		DetectedPhotoInformation* _tmp66_;
		PhotoMetadata* _tmp67_;
		gchar* _tmp68_;
		DetectedPhotoInformation* _tmp69_;
		PhotoMetadata* _tmp70_;
		GeeSet* _tmp71_;
		DetectedPhotoInformation* _tmp72_;
		PhotoMetadata* _tmp73_;
		_tmp52_ = detected;
		_tmp53_ = _tmp52_->metadata;
		_tmp54_ = photo_metadata_get_exposure_date_time (_tmp53_);
		date_time = _tmp54_;
		_tmp55_ = date_time;
		if (_tmp55_ != NULL) {
			MetadataDateTime* _tmp56_;
			GDateTime* _tmp57_;
			_tmp56_ = date_time;
			_tmp57_ = metadata_date_time_get_timestamp (_tmp56_);
			_g_date_time_unref0 (exposure_time);
			exposure_time = _tmp57_;
		}
		_tmp58_ = detected;
		_tmp59_ = _tmp58_->metadata;
		orientation = photo_metadata_get_orientation (_tmp59_);
		_tmp60_ = detected;
		_tmp61_ = _tmp60_->metadata;
		_tmp62_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_MEDIA_METADATA, MediaMetadata));
		_g_free0 (title);
		title = _tmp62_;
		_tmp63_ = detected;
		_tmp64_ = _tmp63_->metadata;
		photo_metadata_get_gps_coords (_tmp64_, &_tmp65_);
		gps_coords = _tmp65_;
		_tmp66_ = detected;
		_tmp67_ = _tmp66_->metadata;
		_tmp68_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, TYPE_MEDIA_METADATA, MediaMetadata));
		_g_free0 (comment);
		comment = _tmp68_;
		_tmp69_ = detected;
		_tmp70_ = _tmp69_->metadata;
		_tmp71_ = photo_metadata_get_keywords (_tmp70_, NULL, NULL, NULL);
		_g_object_unref0 (params->keywords);
		params->keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, GEE_TYPE_COLLECTION, GeeCollection);
		_tmp72_ = detected;
		_tmp73_ = _tmp72_->metadata;
		rating = photo_metadata_get_rating (_tmp73_);
		_metadata_date_time_unref0 (date_time);
	}
	_tmp76_ = detected;
	if (_tmp76_->colorspace != GDK_COLORSPACE_RGB) {
		_tmp75_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp77_;
		_tmp77_ = detected;
		_tmp75_ = _tmp77_->channels < 3;
	}
	if (_tmp75_) {
		_tmp74_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp78_;
		_tmp78_ = detected;
		_tmp74_ = _tmp78_->bits_per_channel != 8;
	}
	if (_tmp74_) {
		GFile* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		_tmp79_ = file;
		_tmp80_ = g_file_get_path (_tmp79_);
		_tmp81_ = _tmp80_;
		g_message ("Photo.vala:1246: Not importing %s: Unsupported color format", _tmp81_);
		_g_free0 (_tmp81_);
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		_g_free0 (comment);
		_g_free0 (title);
		_g_date_time_unref0 (exposure_time);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp82_ = params->row;
	photo_id_init (&_tmp82_->photo_id, PHOTO_ID_INVALID);
	_tmp83_ = params->row;
	_tmp84_ = _tmp83_->master;
	_tmp85_ = file;
	_tmp86_ = g_file_get_path (_tmp85_);
	_g_free0 (_tmp84_->filepath);
	_tmp84_->filepath = _tmp86_;
	_tmp87_ = params->row;
	_tmp88_ = _tmp87_->master;
	_tmp89_ = detected;
	_tmp90_ = _tmp89_->image_dim;
	_tmp88_->dim = _tmp90_;
	_tmp91_ = params->row;
	_tmp92_ = _tmp91_->master;
	_tmp93_ = info;
	_tmp92_->filesize = g_file_info_get_size (_tmp93_);
	_tmp94_ = params->row;
	_tmp95_ = _tmp94_->master;
	_tmp96_ = timestamp;
	_tmp97_ = _g_date_time_ref0 (_tmp96_);
	_g_date_time_unref0 (_tmp95_->timestamp);
	_tmp95_->timestamp = _tmp97_;
	_tmp98_ = params->row;
	_tmp99_ = exposure_time;
	_tmp100_ = _g_date_time_ref0 (_tmp99_);
	_g_date_time_unref0 (_tmp98_->exposure_time);
	_tmp98_->exposure_time = _tmp100_;
	_tmp101_ = params->row;
	_tmp101_->orientation = orientation;
	_tmp102_ = params->row;
	_tmp103_ = _tmp102_->master;
	_tmp103_->original_orientation = orientation;
	_tmp104_ = params->row;
	_tmp105_ = params->import_id;
	_tmp104_->import_id = _tmp105_;
	_tmp106_ = params->row;
	event_id_init (&_tmp106_->event_id, EVENT_ID_INVALID);
	_tmp107_ = params->row;
	_g_object_unref0 (_tmp107_->transformations);
	_tmp107_->transformations = NULL;
	_tmp108_ = params->row;
	_tmp109_ = detected;
	_tmp110_ = _tmp109_->md5;
	_tmp111_ = g_strdup (_tmp110_);
	_g_free0 (_tmp108_->md5);
	_tmp108_->md5 = _tmp111_;
	_tmp112_ = params->row;
	_tmp113_ = detected;
	_tmp114_ = _tmp113_->thumbnail_md5;
	_tmp115_ = g_strdup (_tmp114_);
	_g_free0 (_tmp112_->thumbnail_md5);
	_tmp112_->thumbnail_md5 = _tmp115_;
	_tmp116_ = params->row;
	_tmp117_ = detected;
	_tmp118_ = _tmp117_->exif_md5;
	_tmp119_ = g_strdup (_tmp118_);
	_g_free0 (_tmp116_->exif_md5);
	_tmp116_->exif_md5 = _tmp119_;
	_tmp120_ = params->row;
	_tmp120_->time_created = (gint64) 0;
	_tmp121_ = params->row;
	_tmp121_->flags = (guint64) 0;
	_tmp122_ = params->row;
	_tmp123_ = _tmp122_->master;
	_tmp124_ = detected;
	_tmp123_->file_format = _tmp124_->file_format;
	_tmp125_ = params->row;
	_tmp126_ = title;
	_tmp127_ = g_strdup (_tmp126_);
	_g_free0 (_tmp125_->title);
	_tmp125_->title = _tmp127_;
	_tmp128_ = params->row;
	_tmp129_ = gps_coords;
	_tmp128_->gps_coords = _tmp129_;
	_tmp130_ = params->row;
	_tmp131_ = comment;
	_tmp132_ = g_strdup (_tmp131_);
	_g_free0 (_tmp130_->comment);
	_tmp130_->comment = _tmp132_;
	_tmp133_ = params->row;
	_tmp133_->rating = rating;
	_tmp134_ = params->thumbnails;
	if (_tmp134_ != NULL) {
		PhotoFileReader* reader = NULL;
		PhotoRow* _tmp135_;
		BackingPhotoRow* _tmp136_;
		PhotoRow* _tmp137_;
		BackingPhotoRow* _tmp138_;
		const gchar* _tmp139_;
		PhotoFileReader* _tmp140_;
		PhotoFileReader* _tmp141_;
		_tmp135_ = params->row;
		_tmp136_ = _tmp135_->master;
		_tmp137_ = params->row;
		_tmp138_ = _tmp137_->master;
		_tmp139_ = _tmp138_->filepath;
		_tmp140_ = photo_file_format_create_reader (_tmp136_->file_format, _tmp139_);
		reader = _tmp140_;
		_tmp141_ = reader;
		photo_file_reader_set_role (_tmp141_, PHOTO_FILE_READER_ROLE_THUMBNAIL);
		{
			Thumbnails* _tmp142_;
			PhotoFileReader* _tmp143_;
			PhotoRow* _tmp144_;
			PhotoRow* _tmp145_;
			BackingPhotoRow* _tmp146_;
			Dimensions _tmp147_;
			_tmp142_ = params->thumbnails;
			_tmp143_ = reader;
			_tmp144_ = params->row;
			_tmp145_ = params->row;
			_tmp146_ = _tmp145_->master;
			_tmp147_ = _tmp146_->dim;
			thumbnail_cache_generate_for_photo (_tmp142_, _tmp143_, _tmp144_->orientation, &_tmp147_, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* err = NULL;
			GError* _tmp148_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp148_ = err;
			result = import_result_convert_error (_tmp148_, IMPORT_RESULT_FILE_ERROR);
			_g_error_free0 (err);
			_photo_file_adapter_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_g_date_time_unref0 (exposure_time);
			_detected_photo_information_unref0 (detected);
			_photo_file_interrogator_unref0 (interrogator);
			_g_date_time_unref0 (timestamp);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			return result;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_photo_file_adapter_unref0 (reader);
			_g_free0 (comment);
			_g_free0 (title);
			_g_date_time_unref0 (exposure_time);
			_detected_photo_information_unref0 (detected);
			_photo_file_interrogator_unref0 (interrogator);
			_g_date_time_unref0 (timestamp);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		_photo_file_adapter_unref0 (reader);
	}
	result = IMPORT_RESULT_SUCCESS;
	_g_free0 (comment);
	_g_free0 (title);
	_g_date_time_unref0 (exposure_time);
	_detected_photo_information_unref0 (detected);
	_photo_file_interrogator_unref0 (interrogator);
	_g_date_time_unref0 (timestamp);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
}

void
photo_create_pre_import (PhotoImportParams* params)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	PhotoRow* _tmp2_;
	PhotoRow* _tmp3_;
	BackingPhotoRow* _tmp4_;
	gchar* _tmp5_;
	PhotoRow* _tmp6_;
	BackingPhotoRow* _tmp7_;
	PhotoRow* _tmp8_;
	BackingPhotoRow* _tmp9_;
	PhotoRow* _tmp10_;
	BackingPhotoRow* _tmp11_;
	PhotoRow* _tmp12_;
	PhotoRow* _tmp13_;
	PhotoRow* _tmp14_;
	BackingPhotoRow* _tmp15_;
	PhotoRow* _tmp16_;
	ImportID _tmp17_;
	PhotoRow* _tmp18_;
	PhotoRow* _tmp19_;
	PhotoRow* _tmp20_;
	PhotoRow* _tmp21_;
	PhotoRow* _tmp22_;
	PhotoRow* _tmp23_;
	PhotoRow* _tmp24_;
	PhotoRow* _tmp25_;
	BackingPhotoRow* _tmp26_;
	PhotoRow* _tmp27_;
	PhotoRow* _tmp28_;
	PhotoRow* _tmp29_;
	PhotoRow* _tmp30_;
	PhotoFileInterrogator* interrogator = NULL;
	GFile* _tmp31_;
	PhotoFileInterrogator* _tmp32_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO_IMPORT_PARAMS (params));
	_tmp0_ = params->file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	file = _tmp1_;
	_tmp2_ = params->row;
	photo_id_init (&_tmp2_->photo_id, PHOTO_ID_INVALID);
	_tmp3_ = params->row;
	_tmp4_ = _tmp3_->master;
	_tmp5_ = g_file_get_path (file);
	_g_free0 (_tmp4_->filepath);
	_tmp4_->filepath = _tmp5_;
	_tmp6_ = params->row;
	_tmp7_ = _tmp6_->master;
	dimensions_init (&_tmp7_->dim, 0, 0);
	_tmp8_ = params->row;
	_tmp9_ = _tmp8_->master;
	_tmp9_->filesize = (gint64) 0;
	_tmp10_ = params->row;
	_tmp11_ = _tmp10_->master;
	_g_date_time_unref0 (_tmp11_->timestamp);
	_tmp11_->timestamp = NULL;
	_tmp12_ = params->row;
	_g_date_time_unref0 (_tmp12_->exposure_time);
	_tmp12_->exposure_time = NULL;
	_tmp13_ = params->row;
	_tmp13_->orientation = ORIENTATION_TOP_LEFT;
	_tmp14_ = params->row;
	_tmp15_ = _tmp14_->master;
	_tmp15_->original_orientation = ORIENTATION_TOP_LEFT;
	_tmp16_ = params->row;
	_tmp17_ = params->import_id;
	_tmp16_->import_id = _tmp17_;
	_tmp18_ = params->row;
	event_id_init (&_tmp18_->event_id, EVENT_ID_INVALID);
	_tmp19_ = params->row;
	_g_object_unref0 (_tmp19_->transformations);
	_tmp19_->transformations = NULL;
	_tmp20_ = params->row;
	_g_free0 (_tmp20_->md5);
	_tmp20_->md5 = NULL;
	_tmp21_ = params->row;
	_g_free0 (_tmp21_->thumbnail_md5);
	_tmp21_->thumbnail_md5 = NULL;
	_tmp22_ = params->row;
	_g_free0 (_tmp22_->exif_md5);
	_tmp22_->exif_md5 = NULL;
	_tmp23_ = params->row;
	_tmp23_->time_created = (gint64) 0;
	_tmp24_ = params->row;
	_tmp24_->flags = (guint64) 0;
	_tmp25_ = params->row;
	_tmp26_ = _tmp25_->master;
	_tmp26_->file_format = PHOTO_FILE_FORMAT_JFIF;
	_tmp27_ = params->row;
	_g_free0 (_tmp27_->title);
	_tmp27_->title = NULL;
	_tmp28_ = params->row;
	memset (&_tmp28_->gps_coords, 0, sizeof (GpsCoords));
	_tmp29_ = params->row;
	_g_free0 (_tmp29_->comment);
	_tmp29_->comment = NULL;
	_tmp30_ = params->row;
	_tmp30_->rating = RATING_UNRATED;
	_tmp31_ = params->file;
	_tmp32_ = photo_file_interrogator_new (_tmp31_, params->sniffer_options);
	interrogator = _tmp32_;
	{
		DetectedPhotoInformation* detected = NULL;
		DetectedPhotoInformation* _tmp33_;
		gboolean _tmp34_ = FALSE;
		gboolean _tmp35_ = FALSE;
		DetectedPhotoInformation* _tmp36_;
		photo_file_interrogator_interrogate (interrogator, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp33_ = photo_file_interrogator_get_detected_photo_information (interrogator);
		detected = _tmp33_;
		_tmp36_ = detected;
		if (_tmp36_ != NULL) {
			_tmp35_ = !photo_file_interrogator_get_is_photo_corrupted (interrogator);
		} else {
			_tmp35_ = FALSE;
		}
		if (_tmp35_) {
			DetectedPhotoInformation* _tmp37_;
			_tmp37_ = detected;
			_tmp34_ = _tmp37_->file_format != PHOTO_FILE_FORMAT_UNKNOWN;
		} else {
			_tmp34_ = FALSE;
		}
		if (_tmp34_) {
			PhotoRow* _tmp38_;
			BackingPhotoRow* _tmp39_;
			DetectedPhotoInformation* _tmp40_;
			_tmp38_ = params->row;
			_tmp39_ = _tmp38_->master;
			_tmp40_ = detected;
			_tmp39_->file_format = _tmp40_->file_format;
		}
		_detected_photo_information_unref0 (detected);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_;
		GError* _tmp43_;
		const gchar* _tmp44_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = g_file_get_path (file);
		_tmp42_ = _tmp41_;
		_tmp43_ = err;
		_tmp44_ = _tmp43_->message;
		g_debug ("Photo.vala:1325: Unable to interrogate photo file %s: %s", _tmp42_, _tmp44_);
		_g_free0 (_tmp42_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (file);
}

BackingPhotoRow*
photo_query_backing_photo_row (Photo* self,
                               GFile* file,
                               PhotoFileSnifferOptions options,
                               DetectedPhotoInformation** detected,
                               GError** error)
{
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* backing = NULL;
	BackingPhotoRow* _tmp0_;
	GFileInfo* info = NULL;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp8_;
	PhotoFileInterrogator* _tmp9_;
	PhotoFileInterrogator* _tmp10_;
	DetectedPhotoInformation* _tmp11_;
	gboolean _tmp12_ = FALSE;
	DetectedPhotoInformation* _tmp13_;
	GDateTime* modification_time = NULL;
	GFileInfo* _tmp17_;
	GDateTime* _tmp18_;
	GDateTime* _tmp19_;
	GDateTime* _tmp20_;
	GDateTime* _tmp21_;
	BackingPhotoRow* _tmp22_;
	gchar* _tmp23_;
	BackingPhotoRow* _tmp24_;
	GDateTime* _tmp25_;
	GDateTime* _tmp26_;
	BackingPhotoRow* _tmp27_;
	GFileInfo* _tmp28_;
	BackingPhotoRow* _tmp29_;
	DetectedPhotoInformation* _tmp30_;
	BackingPhotoRow* _tmp31_;
	DetectedPhotoInformation* _tmp32_;
	Dimensions _tmp33_;
	Orientation _tmp34_ = 0;
	DetectedPhotoInformation* _tmp35_;
	PhotoMetadata* _tmp36_;
	BackingPhotoRow* _tmp39_;
	GError* _inner_error0_ = NULL;
	BackingPhotoRow* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_detected_photo_information_unref0 (_vala_detected);
	_vala_detected = NULL;
	_tmp0_ = backing_photo_row_new ();
	backing = _tmp0_;
	info = NULL;
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = g_file_get_path (file);
		_tmp5_ = _tmp4_;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_critical ("Photo.vala:1340: Unable to read file information for %s: %s", _tmp5_, _tmp7_);
		_g_free0 (_tmp5_);
		result = NULL;
		_g_error_free0 (err);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (_vala_detected);
		return NULL;
	}
	_tmp8_ = photo_file_interrogator_new (file, options);
	interrogator = _tmp8_;
	_tmp9_ = interrogator;
	photo_file_interrogator_interrogate (_tmp9_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (_vala_detected);
		return NULL;
	}
	_tmp10_ = interrogator;
	_tmp11_ = photo_file_interrogator_get_detected_photo_information (_tmp10_);
	_detected_photo_information_unref0 (_vala_detected);
	_vala_detected = _tmp11_;
	_tmp13_ = _vala_detected;
	if (_tmp13_ == NULL) {
		_tmp12_ = TRUE;
	} else {
		PhotoFileInterrogator* _tmp14_;
		_tmp14_ = interrogator;
		_tmp12_ = photo_file_interrogator_get_is_photo_corrupted (_tmp14_);
	}
	if (_tmp12_) {
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp15_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp16_ = _tmp15_;
		g_critical ("Photo.vala:1350: Photo update: %s no longer a recognized image", _tmp16_);
		_g_free0 (_tmp16_);
		result = NULL;
		_photo_file_interrogator_unref0 (interrogator);
		_g_object_unref0 (info);
		_backing_photo_row_unref0 (backing);
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	_tmp17_ = info;
	_tmp18_ = g_file_info_get_modification_date_time (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = coarsify_date_time (_tmp19_);
	_tmp21_ = _tmp20_;
	_g_date_time_unref0 (_tmp19_);
	modification_time = _tmp21_;
	_tmp22_ = backing;
	_tmp23_ = g_file_get_path (file);
	_g_free0 (_tmp22_->filepath);
	_tmp22_->filepath = _tmp23_;
	_tmp24_ = backing;
	_tmp25_ = modification_time;
	_tmp26_ = _g_date_time_ref0 (_tmp25_);
	_g_date_time_unref0 (_tmp24_->timestamp);
	_tmp24_->timestamp = _tmp26_;
	_tmp27_ = backing;
	_tmp28_ = info;
	_tmp27_->filesize = g_file_info_get_size (_tmp28_);
	_tmp29_ = backing;
	_tmp30_ = _vala_detected;
	_tmp29_->file_format = _tmp30_->file_format;
	_tmp31_ = backing;
	_tmp32_ = _vala_detected;
	_tmp33_ = _tmp32_->image_dim;
	_tmp31_->dim = _tmp33_;
	_tmp35_ = _vala_detected;
	_tmp36_ = _tmp35_->metadata;
	if (_tmp36_ != NULL) {
		DetectedPhotoInformation* _tmp37_;
		PhotoMetadata* _tmp38_;
		_tmp37_ = _vala_detected;
		_tmp38_ = _tmp37_->metadata;
		_tmp34_ = photo_metadata_get_orientation (_tmp38_);
	} else {
		_tmp34_ = ORIENTATION_TOP_LEFT;
	}
	_tmp39_ = backing;
	_tmp39_->original_orientation = _tmp34_;
	result = backing;
	_g_date_time_unref0 (modification_time);
	_photo_file_interrogator_unref0 (interrogator);
	_g_object_unref0 (info);
	if (detected) {
		*detected = _vala_detected;
	} else {
		_detected_photo_information_unref0 (_vala_detected);
	}
	return result;
}

static void
_vala_array_add86 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add87 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add88 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add89 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gboolean
_gps_coords_equal (const GpsCoords * s1,
                   const GpsCoords * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->has_gps != s2->has_gps) {
		return FALSE;
	}
	if (s1->latitude != s2->latitude) {
		return FALSE;
	}
	if (s1->longitude != s2->longitude) {
		return FALSE;
	}
	return TRUE;
}

static void
_vala_array_add90 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add91 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add92 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gpointer
_media_metadata_ref0 (gpointer self)
{
	return self ? media_metadata_ref (self) : NULL;
}

gboolean
photo_prepare_for_reimport_master (Photo* self,
                                   PhotoReimportMasterState** reimport_state,
                                   GError** error)
{
	PhotoReimportMasterState* _vala_reimport_state = NULL;
	GFile* file = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp4_;
	DetectedPhotoInformation* _tmp5_ = NULL;
	BackingPhotoRow* _tmp6_;
	BackingPhotoRow* _tmp8_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	DetectedPhotoInformation* _tmp14_;
	PhotoRow* updated_row = NULL;
	PhotoRow* _tmp20_;
	gchar** list = NULL;
	gchar** _tmp26_;
	gint list_length1;
	gint _list_size_;
	PhotoRow* _tmp27_;
	const gchar* _tmp28_;
	DetectedPhotoInformation* _tmp29_;
	const gchar* _tmp30_;
	PhotoRow* _tmp32_;
	BackingPhotoRow* _tmp33_;
	BackingPhotoRow* _tmp34_;
	GpsCoords gps_coords = {0};
	DetectedPhotoInformation* _tmp39_;
	PhotoMetadata* _tmp40_;
	PhotoRow* _tmp82_;
	BackingPhotoRow* _tmp83_;
	BackingPhotoRow* _tmp84_;
	PhotoRow* _tmp85_;
	DetectedPhotoInformation* _tmp86_;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	PhotoRow* _tmp89_;
	DetectedPhotoInformation* _tmp90_;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	PhotoRow* _tmp93_;
	DetectedPhotoInformation* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	PhotoMetadata* metadata = NULL;
	DetectedPhotoInformation* _tmp97_;
	PhotoMetadata* _tmp98_;
	PhotoRow* _tmp122_;
	PhotoMetadata* _tmp123_;
	gchar** _tmp124_;
	gint _tmp124__length1;
	PhotoReimportMasterStateImpl* _tmp125_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
	_vala_reimport_state = NULL;
	_tmp0_ = photo_get_master_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp6_ = photo_query_backing_photo_row (self, _tmp4_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, &_tmp5_, &_inner_error0_);
	_detected_photo_information_unref0 (detected);
	detected = _tmp5_;
	backing = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
		return _tmp7_;
	}
	_tmp8_ = backing;
	if (_tmp8_ == NULL) {
		GFile* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp9_ = file;
		_tmp10_ = g_file_get_path (_tmp9_);
		_tmp11_ = _tmp10_;
		g_warning ("Photo.vala:1438: Unable to retrieve photo state from %s for reimport", _tmp11_);
		_g_free0 (_tmp11_);
		result = FALSE;
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		if (reimport_state) {
			*reimport_state = _vala_reimport_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
		}
		return result;
	}
	_tmp14_ = detected;
	if (_tmp14_->colorspace != GDK_COLORSPACE_RGB) {
		_tmp13_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp15_;
		_tmp15_ = detected;
		_tmp13_ = _tmp15_->channels < 3;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp16_;
		_tmp16_ = detected;
		_tmp12_ = _tmp16_->bits_per_channel != 8;
	}
	if (_tmp12_) {
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp17_ = file;
		_tmp18_ = g_file_get_path (_tmp17_);
		_tmp19_ = _tmp18_;
		g_warning ("Photo.vala:1446: Not re-importing %s: Unsupported color format", _tmp19_);
		_g_free0 (_tmp19_);
		result = FALSE;
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		if (reimport_state) {
			*reimport_state = _vala_reimport_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
		}
		return result;
	}
	_tmp20_ = photo_row_new ();
	updated_row = _tmp20_;
	{
		PhotoRow* _tmp21_;
		_tmp21_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp22_;
			PhotoRow* _tmp23_;
			_tmp22_ = self->row;
			_tmp23_ = _photo_row_ref0 (_tmp22_);
			_photo_row_unref0 (updated_row);
			updated_row = _tmp23_;
		}
		__finally0:
		{
			PhotoRow* _tmp24_;
			_tmp24_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp25_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_photo_row_unref0 (updated_row);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_reimport_master_state_unref0 (_vala_reimport_state);
			return _tmp25_;
		}
	}
	_tmp26_ = g_new0 (gchar*, 0 + 1);
	list = _tmp26_;
	list_length1 = 0;
	_list_size_ = list_length1;
	_tmp27_ = updated_row;
	_tmp28_ = _tmp27_->md5;
	_tmp29_ = detected;
	_tmp30_ = _tmp29_->md5;
	if (g_strcmp0 (_tmp28_, _tmp30_) != 0) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("metadata:md5");
		_vala_array_add86 (&list, &list_length1, &_list_size_, _tmp31_);
	}
	_tmp32_ = updated_row;
	_tmp33_ = _tmp32_->master;
	_tmp34_ = backing;
	if (_tmp33_->original_orientation != _tmp34_->original_orientation) {
		gchar* _tmp35_;
		PhotoRow* _tmp36_;
		BackingPhotoRow* _tmp37_;
		BackingPhotoRow* _tmp38_;
		_tmp35_ = g_strdup ("image:orientation");
		_vala_array_add87 (&list, &list_length1, &_list_size_, _tmp35_);
		_tmp36_ = updated_row;
		_tmp37_ = _tmp36_->master;
		_tmp38_ = backing;
		_tmp37_->original_orientation = _tmp38_->original_orientation;
	}
	memset (&gps_coords, 0, sizeof (GpsCoords));
	_tmp39_ = detected;
	_tmp40_ = _tmp39_->metadata;
	if (_tmp40_ != NULL) {
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp41_;
		PhotoMetadata* _tmp42_;
		MetadataDateTime* _tmp43_;
		gboolean _tmp44_ = FALSE;
		gboolean _tmp45_ = FALSE;
		MetadataDateTime* _tmp46_;
		PhotoRow* _tmp55_;
		const gchar* _tmp56_;
		DetectedPhotoInformation* _tmp57_;
		PhotoMetadata* _tmp58_;
		gchar* _tmp59_;
		gchar* _tmp60_;
		gboolean _tmp61_;
		DetectedPhotoInformation* _tmp63_;
		PhotoMetadata* _tmp64_;
		GpsCoords _tmp65_ = {0};
		PhotoRow* _tmp66_;
		GpsCoords _tmp67_;
		GpsCoords _tmp68_;
		PhotoRow* _tmp70_;
		const gchar* _tmp71_;
		DetectedPhotoInformation* _tmp72_;
		PhotoMetadata* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		gboolean _tmp76_;
		PhotoRow* _tmp78_;
		DetectedPhotoInformation* _tmp79_;
		PhotoMetadata* _tmp80_;
		_tmp41_ = detected;
		_tmp42_ = _tmp41_->metadata;
		_tmp43_ = photo_metadata_get_exposure_date_time (_tmp42_);
		date_time = _tmp43_;
		_tmp46_ = date_time;
		if (_tmp46_ != NULL) {
			PhotoRow* _tmp47_;
			GDateTime* _tmp48_;
			_tmp47_ = updated_row;
			_tmp48_ = _tmp47_->exposure_time;
			_tmp45_ = _tmp48_ != NULL;
		} else {
			_tmp45_ = FALSE;
		}
		if (_tmp45_) {
			PhotoRow* _tmp49_;
			GDateTime* _tmp50_;
			MetadataDateTime* _tmp51_;
			GDateTime* _tmp52_;
			GDateTime* _tmp53_;
			_tmp49_ = updated_row;
			_tmp50_ = _tmp49_->exposure_time;
			_tmp51_ = date_time;
			_tmp52_ = metadata_date_time_get_timestamp (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp44_ = !g_date_time_equal (_tmp50_, _tmp53_);
			_g_date_time_unref0 (_tmp53_);
		} else {
			_tmp44_ = FALSE;
		}
		if (_tmp44_) {
			gchar* _tmp54_;
			_tmp54_ = g_strdup ("metadata:exposure-time");
			_vala_array_add88 (&list, &list_length1, &_list_size_, _tmp54_);
		}
		_tmp55_ = updated_row;
		_tmp56_ = _tmp55_->title;
		_tmp57_ = detected;
		_tmp58_ = _tmp57_->metadata;
		_tmp59_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, TYPE_MEDIA_METADATA, MediaMetadata));
		_tmp60_ = _tmp59_;
		_tmp61_ = g_strcmp0 (_tmp56_, _tmp60_) != 0;
		_g_free0 (_tmp60_);
		if (_tmp61_) {
			gchar* _tmp62_;
			_tmp62_ = g_strdup ("metadata:name");
			_vala_array_add89 (&list, &list_length1, &_list_size_, _tmp62_);
		}
		_tmp63_ = detected;
		_tmp64_ = _tmp63_->metadata;
		photo_metadata_get_gps_coords (_tmp64_, &_tmp65_);
		gps_coords = _tmp65_;
		_tmp66_ = updated_row;
		_tmp67_ = _tmp66_->gps_coords;
		_tmp68_ = gps_coords;
		if (_gps_coords_equal (&_tmp67_, &_tmp68_) != TRUE) {
			gchar* _tmp69_;
			_tmp69_ = g_strdup ("metadata:gps");
			_vala_array_add90 (&list, &list_length1, &_list_size_, _tmp69_);
		}
		_tmp70_ = updated_row;
		_tmp71_ = _tmp70_->comment;
		_tmp72_ = detected;
		_tmp73_ = _tmp72_->metadata;
		_tmp74_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, TYPE_MEDIA_METADATA, MediaMetadata));
		_tmp75_ = _tmp74_;
		_tmp76_ = g_strcmp0 (_tmp71_, _tmp75_) != 0;
		_g_free0 (_tmp75_);
		if (_tmp76_) {
			gchar* _tmp77_;
			_tmp77_ = g_strdup ("metadata:comment");
			_vala_array_add91 (&list, &list_length1, &_list_size_, _tmp77_);
		}
		_tmp78_ = updated_row;
		_tmp79_ = detected;
		_tmp80_ = _tmp79_->metadata;
		if (_tmp78_->rating != photo_metadata_get_rating (_tmp80_)) {
			gchar* _tmp81_;
			_tmp81_ = g_strdup ("metadata:rating");
			_vala_array_add92 (&list, &list_length1, &_list_size_, _tmp81_);
		}
		_metadata_date_time_unref0 (date_time);
	}
	_tmp82_ = updated_row;
	_tmp83_ = backing;
	_tmp84_ = _backing_photo_row_ref0 (_tmp83_);
	_backing_photo_row_unref0 (_tmp82_->master);
	_tmp82_->master = _tmp84_;
	_tmp85_ = updated_row;
	_tmp86_ = detected;
	_tmp87_ = _tmp86_->md5;
	_tmp88_ = g_strdup (_tmp87_);
	_g_free0 (_tmp85_->md5);
	_tmp85_->md5 = _tmp88_;
	_tmp89_ = updated_row;
	_tmp90_ = detected;
	_tmp91_ = _tmp90_->exif_md5;
	_tmp92_ = g_strdup (_tmp91_);
	_g_free0 (_tmp89_->exif_md5);
	_tmp89_->exif_md5 = _tmp92_;
	_tmp93_ = updated_row;
	_tmp94_ = detected;
	_tmp95_ = _tmp94_->thumbnail_md5;
	_tmp96_ = g_strdup (_tmp95_);
	_g_free0 (_tmp93_->thumbnail_md5);
	_tmp93_->thumbnail_md5 = _tmp96_;
	metadata = NULL;
	_tmp97_ = detected;
	_tmp98_ = _tmp97_->metadata;
	if (_tmp98_ != NULL) {
		DetectedPhotoInformation* _tmp99_;
		PhotoMetadata* _tmp100_;
		PhotoMetadata* _tmp101_;
		MetadataDateTime* date_time = NULL;
		DetectedPhotoInformation* _tmp102_;
		PhotoMetadata* _tmp103_;
		MetadataDateTime* _tmp104_;
		MetadataDateTime* _tmp105_;
		PhotoRow* _tmp109_;
		GpsCoords _tmp110_;
		PhotoRow* _tmp111_;
		DetectedPhotoInformation* _tmp112_;
		PhotoMetadata* _tmp113_;
		gchar* _tmp114_;
		PhotoRow* _tmp115_;
		DetectedPhotoInformation* _tmp116_;
		PhotoMetadata* _tmp117_;
		gchar* _tmp118_;
		PhotoRow* _tmp119_;
		DetectedPhotoInformation* _tmp120_;
		PhotoMetadata* _tmp121_;
		_tmp99_ = detected;
		_tmp100_ = _tmp99_->metadata;
		_tmp101_ = _media_metadata_ref0 (_tmp100_);
		_media_metadata_unref0 (metadata);
		metadata = _tmp101_;
		_tmp102_ = detected;
		_tmp103_ = _tmp102_->metadata;
		_tmp104_ = photo_metadata_get_exposure_date_time (_tmp103_);
		date_time = _tmp104_;
		_tmp105_ = date_time;
		if (_tmp105_ != NULL) {
			PhotoRow* _tmp106_;
			MetadataDateTime* _tmp107_;
			GDateTime* _tmp108_;
			_tmp106_ = updated_row;
			_tmp107_ = date_time;
			_tmp108_ = metadata_date_time_get_timestamp (_tmp107_);
			_g_date_time_unref0 (_tmp106_->exposure_time);
			_tmp106_->exposure_time = _tmp108_;
		}
		_tmp109_ = updated_row;
		_tmp110_ = gps_coords;
		_tmp109_->gps_coords = _tmp110_;
		_tmp111_ = updated_row;
		_tmp112_ = detected;
		_tmp113_ = _tmp112_->metadata;
		_tmp114_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp113_, TYPE_MEDIA_METADATA, MediaMetadata));
		_g_free0 (_tmp111_->title);
		_tmp111_->title = _tmp114_;
		_tmp115_ = updated_row;
		_tmp116_ = detected;
		_tmp117_ = _tmp116_->metadata;
		_tmp118_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, TYPE_MEDIA_METADATA, MediaMetadata));
		_g_free0 (_tmp115_->comment);
		_tmp115_->comment = _tmp118_;
		_tmp119_ = updated_row;
		_tmp120_ = detected;
		_tmp121_ = _tmp120_->metadata;
		_tmp119_->rating = photo_metadata_get_rating (_tmp121_);
		_metadata_date_time_unref0 (date_time);
	}
	_tmp122_ = updated_row;
	_tmp123_ = metadata;
	_tmp124_ = list;
	_tmp124__length1 = list_length1;
	_tmp125_ = photo_reimport_master_state_impl_new (_tmp122_, _tmp123_, _tmp124_, _tmp124__length1);
	_photo_reimport_master_state_unref0 (_vala_reimport_state);
	_vala_reimport_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp125_, PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState);
	result = TRUE;
	_media_metadata_unref0 (metadata);
	list = (_vala_array_free (list, list_length1, (GDestroyNotify) g_free), NULL);
	_photo_row_unref0 (updated_row);
	_backing_photo_row_unref0 (backing);
	_detected_photo_information_unref0 (detected);
	_g_object_unref0 (file);
	if (reimport_state) {
		*reimport_state = _vala_reimport_state;
	} else {
		_photo_reimport_master_state_unref0 (_vala_reimport_state);
	}
	return result;
}

static void
photo_real_apply_user_metadata_for_reimport (Photo* self,
                                             PhotoMetadata* metadata)
{
	g_critical ("Type `%s' does not implement abstract method `photo_apply_user_metadata_for_reimport'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
photo_apply_user_metadata_for_reimport (Photo* self,
                                        PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->apply_user_metadata_for_reimport) {
		_klass_->apply_user_metadata_for_reimport (self, metadata);
	}
}

static gpointer
_photo_reimport_master_state_ref0 (gpointer self)
{
	return self ? photo_reimport_master_state_ref (self) : NULL;
}

static void
_vala_array_add93 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add94 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
photo_finish_reimport_master (Photo* self,
                              PhotoReimportMasterState* state,
                              GError** error)
{
	PhotoReimportMasterStateImpl* reimport_state = NULL;
	PhotoReimportMasterStateImpl* _tmp0_;
	PhotoTable* _tmp1_;
	PhotoTable* _tmp2_;
	PhotoRow* _tmp3_;
	PhotoMetadata* _tmp18_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	PhotoMetadata* _tmp26_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
	_tmp0_ = _photo_reimport_master_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl));
	reimport_state = _tmp0_;
	_tmp1_ = photo_table_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = reimport_state->row;
	photo_table_reimport (_tmp2_, _tmp3_, &_inner_error0_);
	_database_table_unref0 (_tmp2_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_photo_reimport_master_state_unref0 (reimport_state);
			return;
		} else {
			_photo_reimport_master_state_unref0 (reimport_state);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		PhotoRow* _tmp4_;
		_tmp4_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* original_master = NULL;
			PhotoRow* _tmp5_;
			BackingPhotoRow* _tmp6_;
			BackingPhotoRow* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoRow* _tmp9_;
			PhotoRow* _tmp10_;
			BackingPhotoRow* _tmp11_;
			BackingPhotoRow* _tmp12_;
			PhotoRow* _tmp13_;
			BackingPhotoRow* _tmp14_;
			PhotoRow* _tmp15_;
			BackingPhotoRow* _tmp16_;
			_tmp5_ = self->row;
			_tmp6_ = _tmp5_->master;
			_tmp7_ = _backing_photo_row_ref0 (_tmp6_);
			original_master = _tmp7_;
			_tmp8_ = reimport_state->row;
			_tmp9_ = _photo_row_ref0 (_tmp8_);
			_photo_row_unref0 (self->row);
			self->row = _tmp9_;
			_tmp10_ = self->row;
			_tmp11_ = original_master;
			_tmp12_ = _backing_photo_row_ref0 (_tmp11_);
			_backing_photo_row_unref0 (_tmp10_->master);
			_tmp10_->master = _tmp12_;
			_tmp13_ = self->row;
			_tmp14_ = _tmp13_->master;
			_tmp15_ = reimport_state->row;
			_tmp16_ = _tmp15_->master;
			backing_photo_row_copy_from (_tmp14_, _tmp16_);
			if (!reimport_state->metadata_only) {
				photo_remove_all_transformations (self, FALSE);
			}
			_backing_photo_row_unref0 (original_master);
		}
		__finally0:
		{
			PhotoRow* _tmp17_;
			_tmp17_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_photo_reimport_master_state_unref0 (reimport_state);
				return;
			} else {
				_photo_reimport_master_state_unref0 (reimport_state);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp18_ = reimport_state->metadata;
	if (_tmp18_ != NULL) {
		PhotoMetadata* _tmp19_;
		_tmp19_ = reimport_state->metadata;
		photo_apply_user_metadata_for_reimport (self, _tmp19_);
	}
	if (!reimport_state->metadata_only) {
		gchar* _tmp20_;
		_tmp20_ = g_strdup ("image:master");
		_vala_array_add93 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp20_);
		if (photo_is_master_baseline (self)) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("image:baseline");
			_vala_array_add94 (&reimport_state->alterations, &reimport_state->alterations_length1, &reimport_state->_alterations_size_, _tmp21_);
		}
	}
	_tmp22_ = reimport_state->alterations;
	_tmp22__length1 = reimport_state->alterations_length1;
	if (_tmp22__length1 > 0) {
		gchar** _tmp23_;
		gint _tmp23__length1;
		Alteration* _tmp24_;
		Alteration* _tmp25_;
		_tmp23_ = reimport_state->alterations;
		_tmp23__length1 = reimport_state->alterations_length1;
		_tmp24_ = alteration_new_from_array (_tmp23_, _tmp23__length1);
		_tmp25_ = _tmp24_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
		_alteration_unref0 (_tmp25_);
	}
	_tmp26_ = reimport_state->metadata;
	photo_notify_master_reimported (self, _tmp26_);
	if (photo_is_master_baseline (self)) {
		PhotoMetadata* _tmp27_;
		_tmp27_ = reimport_state->metadata;
		photo_notify_baseline_reimported (self, _tmp27_);
	}
	if (photo_is_master_source (self)) {
		PhotoMetadata* _tmp28_;
		_tmp28_ = reimport_state->metadata;
		photo_notify_source_reimported (self, _tmp28_);
	}
	_photo_reimport_master_state_unref0 (reimport_state);
}

static gboolean
photo_verify_file_for_reimport (Photo* self,
                                GFile* file,
                                BackingPhotoRow** backing,
                                DetectedPhotoInformation** detected,
                                GError** error)
{
	BackingPhotoRow* _vala_backing = NULL;
	DetectedPhotoInformation* _vala_detected = NULL;
	BackingPhotoRow* _tmp0_ = NULL;
	DetectedPhotoInformation* _tmp1_ = NULL;
	BackingPhotoRow* _tmp2_;
	BackingPhotoRow* _tmp4_;
	BackingPhotoRow* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	DetectedPhotoInformation* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp2_ = photo_query_backing_photo_row (self, file, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp1_, &_inner_error0_);
	_detected_photo_information_unref0 (_vala_detected);
	_vala_detected = _tmp1_;
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp3_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_backing_photo_row_unref0 (_vala_backing);
		_detected_photo_information_unref0 (_vala_detected);
		return _tmp3_;
	}
	_tmp4_ = _tmp0_;
	_tmp0_ = NULL;
	_backing_photo_row_unref0 (_vala_backing);
	_vala_backing = _tmp4_;
	_tmp5_ = _vala_backing;
	if (_tmp5_ == NULL) {
		result = FALSE;
		_backing_photo_row_unref0 (_tmp0_);
		if (backing) {
			*backing = _vala_backing;
		} else {
			_backing_photo_row_unref0 (_vala_backing);
		}
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	_tmp8_ = _vala_detected;
	if (_tmp8_->colorspace != GDK_COLORSPACE_RGB) {
		_tmp7_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp9_;
		_tmp9_ = _vala_detected;
		_tmp7_ = _tmp9_->channels < 3;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		DetectedPhotoInformation* _tmp10_;
		_tmp10_ = _vala_detected;
		_tmp6_ = _tmp10_->bits_per_channel != 8;
	}
	if (_tmp6_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp11_ = g_file_get_path (file);
		_tmp12_ = _tmp11_;
		g_warning ("Photo.vala:1567: Not re-importing %s: Unsupported color format", _tmp12_);
		_g_free0 (_tmp12_);
		result = FALSE;
		_backing_photo_row_unref0 (_tmp0_);
		if (backing) {
			*backing = _vala_backing;
		} else {
			_backing_photo_row_unref0 (_vala_backing);
		}
		if (detected) {
			*detected = _vala_detected;
		} else {
			_detected_photo_information_unref0 (_vala_detected);
		}
		return result;
	}
	result = TRUE;
	_backing_photo_row_unref0 (_tmp0_);
	if (backing) {
		*backing = _vala_backing;
	} else {
		_backing_photo_row_unref0 (_vala_backing);
	}
	if (detected) {
		*detected = _vala_detected;
	} else {
		_detected_photo_information_unref0 (_vala_detected);
	}
	return result;
}

gboolean
photo_prepare_for_reimport_editable (Photo* self,
                                     PhotoReimportEditableState** state,
                                     GError** error)
{
	PhotoReimportEditableState* _vala_state = NULL;
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	gboolean _tmp2_ = FALSE;
	GFile* _tmp3_;
	BackingPhotoRow* _tmp4_ = NULL;
	DetectedPhotoInformation* _tmp5_ = NULL;
	gboolean _tmp6_;
	BackingPhotoRow* _tmp8_;
	DetectedPhotoInformation* _tmp9_;
	PhotoMetadata* _tmp10_;
	PhotoReimportEditableStateImpl* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_editable_file (self);
	file = _tmp0_;
	_tmp1_ = file;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (file);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp3_ = file;
	_tmp6_ = photo_verify_file_for_reimport (self, _tmp3_, &_tmp4_, &_tmp5_, &_inner_error0_);
	_backing_photo_row_unref0 (backing);
	backing = _tmp4_;
	_detected_photo_information_unref0 (detected);
	detected = _tmp5_;
	_tmp2_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp7_;
	}
	if (!_tmp2_) {
		result = FALSE;
		_backing_photo_row_unref0 (backing);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp8_ = backing;
	_tmp9_ = detected;
	_tmp10_ = _tmp9_->metadata;
	_tmp11_ = photo_reimport_editable_state_impl_new (_tmp8_, _tmp10_);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState);
	result = TRUE;
	_backing_photo_row_unref0 (backing);
	_detected_photo_information_unref0 (detected);
	_g_object_unref0 (file);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_editable_state_unref0 (_vala_state);
	}
	return result;
}

static gpointer
_photo_reimport_editable_state_ref0 (gpointer self)
{
	return self ? photo_reimport_editable_state_ref (self) : NULL;
}

void
photo_finish_reimport_editable (Photo* self,
                                PhotoReimportEditableState* state,
                                GError** error)
{
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp0_ = {0};
	PhotoReimportEditableStateImpl* reimport_state = NULL;
	PhotoReimportEditableStateImpl* _tmp1_;
	PhotoReimportEditableStateImpl* _tmp2_;
	PhotoReimportEditableStateImpl* _tmp16_;
	PhotoMetadata* _tmp17_;
	gchar* list = NULL;
	gchar* _tmp33_;
	PhotoReimportEditableStateImpl* _tmp34_;
	const gchar* _tmp37_;
	Alteration* _tmp38_;
	Alteration* _tmp39_;
	PhotoReimportEditableStateImpl* _tmp40_;
	PhotoMetadata* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
	photo_get_editable_id (self, &_tmp0_);
	editable_id = _tmp0_;
	if (backing_photo_id_is_invalid (&editable_id)) {
		return;
	}
	_tmp1_ = _photo_reimport_editable_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl));
	reimport_state = _tmp1_;
	_tmp2_ = reimport_state;
	if (!_tmp2_->metadata_only) {
		BackingPhotoTable* _tmp3_;
		BackingPhotoTable* _tmp4_;
		PhotoReimportEditableStateImpl* _tmp5_;
		BackingPhotoRow* _tmp6_;
		_tmp3_ = backing_photo_table_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = reimport_state;
		_tmp6_ = _tmp5_->backing_state;
		backing_photo_table_update (_tmp4_, _tmp6_, &_inner_error0_);
		_database_table_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_photo_reimport_editable_state_unref0 (reimport_state);
				return;
			} else {
				_photo_reimport_editable_state_unref0 (reimport_state);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				PhotoReimportEditableStateImpl* _tmp8_;
				BackingPhotoRow* _tmp9_;
				BackingPhotoRow* _tmp10_;
				PhotoReimportEditableStateImpl* _tmp11_;
				BackingPhotoRow* _tmp12_;
				_tmp8_ = reimport_state;
				_tmp9_ = _tmp8_->backing_state;
				_tmp10_ = _backing_photo_row_ref0 (_tmp9_);
				_backing_photo_row_unref0 (self->priv->editable);
				self->priv->editable = _tmp10_;
				_tmp11_ = reimport_state;
				_tmp12_ = _tmp11_->backing_state;
				photo_set_orientation (self, _tmp12_->original_orientation);
				photo_remove_all_transformations (self, FALSE);
			}
			__finally0:
			{
				PhotoRow* _tmp13_;
				_tmp13_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_photo_reimport_editable_state_unref0 (reimport_state);
					return;
				} else {
					_photo_reimport_editable_state_unref0 (reimport_state);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	} else {
		PhotoReimportEditableStateImpl* _tmp14_;
		BackingPhotoRow* _tmp15_;
		_tmp14_ = reimport_state;
		_tmp15_ = _tmp14_->backing_state;
		photo_set_orientation (self, _tmp15_->original_orientation);
	}
	_tmp16_ = reimport_state;
	_tmp17_ = _tmp16_->metadata;
	if (_tmp17_ != NULL) {
		PhotoReimportEditableStateImpl* _tmp18_;
		PhotoMetadata* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		PhotoReimportEditableStateImpl* _tmp22_;
		PhotoMetadata* _tmp23_;
		GpsCoords _tmp24_ = {0};
		PhotoReimportEditableStateImpl* _tmp25_;
		PhotoMetadata* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		PhotoReimportEditableStateImpl* _tmp29_;
		PhotoMetadata* _tmp30_;
		PhotoReimportEditableStateImpl* _tmp31_;
		PhotoMetadata* _tmp32_;
		_tmp18_ = reimport_state;
		_tmp19_ = _tmp18_->metadata;
		_tmp20_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_MEDIA_METADATA, MediaMetadata));
		_tmp21_ = _tmp20_;
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp21_);
		_g_free0 (_tmp21_);
		_tmp22_ = reimport_state;
		_tmp23_ = _tmp22_->metadata;
		photo_metadata_get_gps_coords (_tmp23_, &_tmp24_);
		positionable_set_gps_coords (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_POSITIONABLE, Positionable), &_tmp24_);
		_tmp25_ = reimport_state;
		_tmp26_ = _tmp25_->metadata;
		_tmp27_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, TYPE_MEDIA_METADATA, MediaMetadata));
		_tmp28_ = _tmp27_;
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp28_);
		_g_free0 (_tmp28_);
		_tmp29_ = reimport_state;
		_tmp30_ = _tmp29_->metadata;
		media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), photo_metadata_get_rating (_tmp30_));
		_tmp31_ = reimport_state;
		_tmp32_ = _tmp31_->metadata;
		photo_apply_user_metadata_for_reimport (self, _tmp32_);
	}
	_tmp33_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
	list = _tmp33_;
	_tmp34_ = reimport_state;
	if (!_tmp34_->metadata_only) {
		const gchar* _tmp35_;
		gchar* _tmp36_;
		_tmp35_ = list;
		_tmp36_ = g_strconcat (_tmp35_, "image:editable,image:baseline", NULL);
		_g_free0 (list);
		list = _tmp36_;
	}
	_tmp37_ = list;
	_tmp38_ = alteration_new_from_list (_tmp37_);
	_tmp39_ = _tmp38_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp39_);
	_alteration_unref0 (_tmp39_);
	_tmp40_ = reimport_state;
	_tmp41_ = _tmp40_->metadata;
	photo_notify_editable_reimported (self, _tmp41_);
	if (photo_is_editable_baseline (self)) {
		PhotoReimportEditableStateImpl* _tmp42_;
		PhotoMetadata* _tmp43_;
		_tmp42_ = reimport_state;
		_tmp43_ = _tmp42_->metadata;
		photo_notify_baseline_reimported (self, _tmp43_);
	}
	if (photo_is_editable_source (self)) {
		PhotoReimportEditableStateImpl* _tmp44_;
		PhotoMetadata* _tmp45_;
		_tmp44_ = reimport_state;
		_tmp45_ = _tmp44_->metadata;
		photo_notify_source_reimported (self, _tmp45_);
	}
	_g_free0 (list);
	_photo_reimport_editable_state_unref0 (reimport_state);
}

static gpointer
_photo_reimport_raw_development_state_ref0 (gpointer self)
{
	return self ? photo_reimport_raw_development_state_ref (self) : NULL;
}

gboolean
photo_prepare_for_reimport_raw_development (Photo* self,
                                            PhotoReimportRawDevelopmentState** state,
                                            GError** error)
{
	PhotoReimportRawDevelopmentState* _vala_state = NULL;
	GeeCollection* files = NULL;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp2_;
	PhotoReimportRawDevelopmentStateImpl* _tmp18_;
	PhotoReimportRawDevelopmentState* _tmp19_;
	PhotoReimportRawDevelopmentStateImpl* _tmp20_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_photo_reimport_raw_development_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_raw_developer_files (self);
	files = _tmp0_;
	_tmp1_ = files;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (files);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_raw_development_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp2_ = photo_reimport_raw_development_state_impl_new ();
	reimport_state = _tmp2_;
	{
		GeeIterator* _file_it = NULL;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp3_ = files;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_file_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			GFile* file = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			DetectedPhotoInformation* detected = NULL;
			BackingPhotoRow* backing = NULL;
			gboolean _tmp8_ = FALSE;
			GFile* _tmp9_;
			BackingPhotoRow* _tmp10_ = NULL;
			DetectedPhotoInformation* _tmp11_ = NULL;
			gboolean _tmp12_;
			PhotoReimportRawDevelopmentStateImpl* _tmp14_;
			BackingPhotoRow* _tmp15_;
			DetectedPhotoInformation* _tmp16_;
			PhotoMetadata* _tmp17_;
			_tmp5_ = _file_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _file_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			file = (GFile*) _tmp7_;
			_tmp9_ = file;
			_tmp12_ = photo_verify_file_for_reimport (self, _tmp9_, &_tmp10_, &_tmp11_, &_inner_error0_);
			_backing_photo_row_unref0 (backing);
			backing = _tmp10_;
			_detected_photo_information_unref0 (detected);
			detected = _tmp11_;
			_tmp8_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp13_ = FALSE;
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_g_object_unref0 (_file_it);
				_photo_reimport_raw_development_state_unref0 (reimport_state);
				_g_object_unref0 (files);
				_photo_reimport_raw_development_state_unref0 (_vala_state);
				return _tmp13_;
			}
			if (!_tmp8_) {
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				continue;
			}
			_tmp14_ = reimport_state;
			_tmp15_ = backing;
			_tmp16_ = detected;
			_tmp17_ = _tmp16_->metadata;
			photo_reimport_raw_development_state_impl_add (_tmp14_, _tmp15_, _tmp17_);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
		}
		_g_object_unref0 (_file_it);
	}
	_tmp18_ = reimport_state;
	_tmp19_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState));
	_photo_reimport_raw_development_state_unref0 (_vala_state);
	_vala_state = _tmp19_;
	_tmp20_ = reimport_state;
	result = photo_reimport_raw_development_state_impl_get_size (_tmp20_) > 0;
	_photo_reimport_raw_development_state_unref0 (reimport_state);
	_g_object_unref0 (files);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_raw_development_state_unref0 (_vala_state);
	}
	return result;
}

void
photo_finish_reimport_raw_development (Photo* self,
                                       PhotoReimportRawDevelopmentState* state,
                                       GError** error)
{
	PhotoReimportRawDevelopmentStateImpl* reimport_state = NULL;
	PhotoReimportRawDevelopmentStateImpl* _tmp0_;
	gchar* list = NULL;
	gchar* _tmp25_;
	PhotoReimportRawDevelopmentStateImpl* _tmp26_;
	const gchar* _tmp29_;
	Alteration* _tmp30_;
	Alteration* _tmp31_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE (state));
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
		return;
	}
	_tmp0_ = _photo_reimport_raw_development_state_ref0 (G_TYPE_CHECK_INSTANCE_CAST (state, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl));
	reimport_state = _tmp0_;
	{
		GeeIterator* _dev_it = NULL;
		PhotoReimportRawDevelopmentStateImpl* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp1_ = reimport_state;
		_tmp2_ = _tmp1_->list;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_dev_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			PhotoReimportRawDevelopmentStateImplDevToReimport* dev = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			PhotoReimportRawDevelopmentStateImpl* _tmp7_;
			_tmp4_ = _dev_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _dev_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			dev = (PhotoReimportRawDevelopmentStateImplDevToReimport*) _tmp6_;
			_tmp7_ = reimport_state;
			if (!_tmp7_->metadata_only) {
				BackingPhotoTable* _tmp8_;
				BackingPhotoTable* _tmp9_;
				PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp10_;
				BackingPhotoRow* _tmp11_;
				_tmp8_ = backing_photo_table_get_instance ();
				_tmp9_ = _tmp8_;
				_tmp10_ = dev;
				_tmp11_ = _tmp10_->backing;
				backing_photo_table_update (_tmp9_, _tmp11_, &_inner_error0_);
				_database_table_unref0 (_tmp9_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
						_g_object_unref0 (_dev_it);
						_photo_reimport_raw_development_state_unref0 (reimport_state);
						return;
					} else {
						_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
						_g_object_unref0 (_dev_it);
						_photo_reimport_raw_development_state_unref0 (reimport_state);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				{
					PhotoRow* _tmp12_;
					_tmp12_ = self->row;
					g_rec_mutex_lock (&self->priv->__lock_row);
					{
						gint _tmp13_ = 0;
						RawDeveloper* _tmp14_;
						_tmp14_ = raw_developer_as_array (&_tmp13_);
						{
							RawDeveloper* d_collection = NULL;
							gint d_collection_length1 = 0;
							gint _d_collection_size_ = 0;
							gint d_it = 0;
							d_collection = _tmp14_;
							d_collection_length1 = _tmp13_;
							for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
								RawDeveloper d = 0;
								d = d_collection[d_it];
								{
									BackingPhotoID id = {0};
									PhotoRow* _tmp15_;
									BackingPhotoID* _tmp16_;
									gint _tmp16__length1;
									BackingPhotoID _tmp17_;
									BackingPhotoID _tmp18_;
									_tmp15_ = self->row;
									_tmp16_ = _tmp15_->development_ids;
									_tmp16__length1 = _tmp15_->development_ids_length1;
									_tmp17_ = _tmp16_[d];
									id = _tmp17_;
									_tmp18_ = id;
									if (_tmp18_.id != BACKING_PHOTO_ID_INVALID) {
										BackingPhotoRow* bpr = NULL;
										BackingPhotoID _tmp19_;
										BackingPhotoRow* _tmp20_;
										BackingPhotoRow* _tmp21_;
										_tmp19_ = id;
										_tmp20_ = photo_get_backing_row (self, &_tmp19_);
										bpr = _tmp20_;
										_tmp21_ = bpr;
										if (_tmp21_ != NULL) {
											GeeHashMap* _tmp22_;
											BackingPhotoRow* _tmp23_;
											_tmp22_ = self->priv->developments;
											_tmp23_ = bpr;
											gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), (gpointer) ((gintptr) d), _tmp23_);
										}
										_backing_photo_row_unref0 (bpr);
									}
								}
							}
							d_collection = (g_free (d_collection), NULL);
						}
					}
					__finally0:
					{
						PhotoRow* _tmp24_;
						_tmp24_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
							_g_object_unref0 (_dev_it);
							_photo_reimport_raw_development_state_unref0 (reimport_state);
							return;
						} else {
							_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
							_g_object_unref0 (_dev_it);
							_photo_reimport_raw_development_state_unref0 (reimport_state);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
			}
			_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (dev);
		}
		_g_object_unref0 (_dev_it);
	}
	_tmp25_ = g_strdup ("metadata:name,image:orientation,metadata:rating,metadata:exposure-time");
	list = _tmp25_;
	_tmp26_ = reimport_state;
	if (!_tmp26_->metadata_only) {
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp27_ = list;
		_tmp28_ = g_strconcat (_tmp27_, "image:editable,image:baseline", NULL);
		_g_free0 (list);
		list = _tmp28_;
	}
	_tmp29_ = list;
	_tmp30_ = alteration_new_from_list (_tmp29_);
	_tmp31_ = _tmp30_;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp31_);
	_alteration_unref0 (_tmp31_);
	photo_notify_raw_development_modified (self);
	_g_free0 (list);
	_photo_reimport_raw_development_state_unref0 (reimport_state);
}

static gchar*
photo_real_get_typename (DataSource* base)
{
	Photo * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gint64
photo_real_get_instance_id (DataSource* base)
{
	Photo * self;
	PhotoID _tmp0_ = {0};
	gint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	photo_get_photo_id (self, &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static gchar*
photo_real_get_source_id (DataSource* base)
{
	Photo * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = data_source_get_typename (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s%016" G_GINT64_MODIFIER "x", _tmp1_, data_source_get_instance_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource)));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
photo_set_master_timestamp (Photo* self,
                            GFileInfo* info)
{
	GDateTime* modification = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = coarsify_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	modification = _tmp3_;
	{
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				PhotoRow* _tmp5_;
				BackingPhotoRow* _tmp6_;
				GDateTime* _tmp7_;
				GDateTime* _tmp8_;
				PhotoTable* _tmp10_;
				PhotoTable* _tmp11_;
				PhotoRow* _tmp12_;
				PhotoID _tmp13_;
				GDateTime* _tmp14_;
				PhotoRow* _tmp15_;
				BackingPhotoRow* _tmp16_;
				GDateTime* _tmp17_;
				GDateTime* _tmp18_;
				_tmp5_ = self->row;
				_tmp6_ = _tmp5_->master;
				_tmp7_ = _tmp6_->timestamp;
				_tmp8_ = modification;
				if (g_date_time_equal (_tmp7_, _tmp8_)) {
					{
						GError* _inner_error0_ = NULL;
						PhotoRow* _tmp9_;
						_tmp9_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					_g_date_time_unref0 (modification);
					return;
				}
				_tmp10_ = photo_table_get_instance ();
				_tmp11_ = _tmp10_;
				_tmp12_ = self->row;
				_tmp13_ = _tmp12_->photo_id;
				_tmp14_ = modification;
				photo_table_update_timestamp (_tmp11_, &_tmp13_, _tmp14_, &_inner_error0_);
				_database_table_unref0 (_tmp11_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp15_ = self->row;
				_tmp16_ = _tmp15_->master;
				_tmp17_ = modification;
				_tmp18_ = _g_date_time_ref0 (_tmp17_);
				_g_date_time_unref0 (_tmp16_->timestamp);
				_tmp16_->timestamp = _tmp18_;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp19_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp19_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp19_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				PhotoRow* _tmp20_;
				_tmp20_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp21_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = err;
		app_window_database_error (_tmp21_);
		_g_error_free0 (err);
		_g_date_time_unref0 (modification);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_date_time_unref0 (modification);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (photo_is_master_baseline (self)) {
		Alteration* _tmp22_;
		Alteration* _tmp23_;
		_tmp22_ = alteration_new_from_list ("metadata:master-timestamp,metadata:baseline-timestamp");
		_tmp23_ = _tmp22_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp23_);
		_alteration_unref0 (_tmp23_);
	} else {
		Alteration* _tmp24_;
		Alteration* _tmp25_;
		_tmp24_ = alteration_new ("metadata", "master-timestamp");
		_tmp25_ = _tmp24_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp25_);
		_alteration_unref0 (_tmp25_);
	}
	_g_date_time_unref0 (modification);
}

void
photo_update_editable_modification_time (Photo* self,
                                         GFileInfo* info,
                                         GError** error)
{
	GDateTime* modification = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	gboolean altered = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	_tmp0_ = g_file_info_get_modification_date_time (info);
	_tmp1_ = _tmp0_;
	_tmp2_ = coarsify_date_time (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	modification = _tmp3_;
	altered = FALSE;
	{
		PhotoRow* _tmp4_;
		_tmp4_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			if (backing_photo_id_is_valid (&_tmp6_->editable_id)) {
				BackingPhotoRow* _tmp7_;
				GDateTime* _tmp8_;
				GDateTime* _tmp9_;
				_tmp7_ = self->priv->editable;
				_tmp8_ = _tmp7_->timestamp;
				_tmp9_ = modification;
				_tmp5_ = !g_date_time_equal (_tmp8_, _tmp9_);
			} else {
				_tmp5_ = FALSE;
			}
			if (_tmp5_) {
				BackingPhotoTable* _tmp10_;
				BackingPhotoTable* _tmp11_;
				PhotoRow* _tmp12_;
				BackingPhotoID _tmp13_;
				GDateTime* _tmp14_;
				BackingPhotoRow* _tmp15_;
				GDateTime* _tmp16_;
				GDateTime* _tmp17_;
				_tmp10_ = backing_photo_table_get_instance ();
				_tmp11_ = _tmp10_;
				_tmp12_ = self->row;
				_tmp13_ = _tmp12_->editable_id;
				_tmp14_ = modification;
				backing_photo_table_update_timestamp (_tmp11_, &_tmp13_, _tmp14_, &_inner_error0_);
				_database_table_unref0 (_tmp11_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp15_ = self->priv->editable;
				_tmp16_ = modification;
				_tmp17_ = _g_date_time_ref0 (_tmp16_);
				_g_date_time_unref0 (_tmp15_->timestamp);
				_tmp15_->timestamp = _tmp17_;
				altered = TRUE;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp18_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp18_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp18_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PhotoRow* _tmp19_;
			_tmp19_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (modification);
			return;
		}
	}
	if (altered) {
		Alteration* _tmp20_;
		Alteration* _tmp21_;
		_tmp20_ = alteration_new_from_list ("metadata:editable-timestamp,metadata:baseline-timestamp");
		_tmp21_ = _tmp20_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp21_);
		_alteration_unref0 (_tmp21_);
	}
	_g_date_time_unref0 (modification);
}

void
photo_update_many_editable_timestamps (GeeMap* map,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	database_table_begin_transaction ();
	{
		GeeIterator* _photo_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (map);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_photo_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			Photo* photo = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			_tmp5_ = _photo_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _photo_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			photo = (Photo*) _tmp7_;
			{
				Photo* _tmp8_;
				Photo* _tmp9_;
				gpointer _tmp10_;
				GFileInfo* _tmp11_;
				_tmp8_ = photo;
				_tmp9_ = photo;
				_tmp10_ = gee_map_get (map, _tmp9_);
				_tmp11_ = (GFileInfo*) _tmp10_;
				photo_update_editable_modification_time (_tmp8_, _tmp11_, &_inner_error0_);
				_g_object_unref0 (_tmp11_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GError* _tmp12_;
				const gchar* _tmp13_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp12_ = err;
				_tmp13_ = _tmp12_->message;
				g_debug ("Photo.vala:1758: Failed to update modification time: %s", _tmp13_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (photo);
					_g_object_unref0 (_photo_it);
					return;
				} else {
					_g_object_unref0 (photo);
					_g_object_unref0 (_photo_it);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static PhotoFileFormat
photo_real_get_preferred_thumbnail_format (ThumbnailSource* base)
{
	Photo * self;
	PhotoFileFormat _tmp0_ = 0;
	PhotoFileFormat result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	if (photo_file_format_can_write_image (photo_get_file_format (self))) {
		_tmp0_ = photo_get_file_format (self);
	} else {
		_tmp0_ = photo_file_format_get_system_default_format ();
	}
	result = _tmp0_;
	return result;
}

static GdkPixbuf*
photo_real_create_thumbnail (ThumbnailSource* base,
                             gint scale,
                             GError** error)
{
	Photo * self;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_ = {0};
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	scaling_for_best_fit (scale, TRUE, &_tmp1_);
	_tmp2_ = photo_source_get_pixbuf (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), &_tmp1_, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

gboolean
photo_is_file_image (GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	if (photo_file_format_is_file_supported (file)) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_file_get_basename (file);
		_tmp2_ = _tmp1_;
		_tmp0_ = photo_is_extension_found (_tmp2_, PHOTO_IMAGE_EXTENSIONS, (gint) G_N_ELEMENTS (PHOTO_IMAGE_EXTENSIONS));
		_g_free0 (_tmp2_);
	}
	result = _tmp0_;
	return result;
}

static gboolean
photo_is_extension_found (const gchar* basename,
                          gchar** extensions,
                          gint extensions_length1)
{
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (basename != NULL, FALSE);
	disassemble_filename (basename, &_tmp0_, &_tmp1_);
	_g_free0 (name);
	name = _tmp0_;
	_g_free0 (ext);
	ext = _tmp1_;
	_tmp2_ = ext;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_free0 (ext);
		_g_free0 (name);
		return result;
	}
	_tmp3_ = ext;
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) -1);
	_g_free0 (ext);
	ext = _tmp4_;
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
		extension_collection = extensions;
		extension_collection_length1 = extensions_length1;
		for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
			gchar* _tmp5_;
			gchar* extension = NULL;
			_tmp5_ = g_strdup (extension_collection[extension_it]);
			extension = _tmp5_;
			{
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp6_ = ext;
				_tmp7_ = extension;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = TRUE;
					_g_free0 (extension);
					_g_free0 (ext);
					_g_free0 (name);
					return result;
				}
				_g_free0 (extension);
			}
		}
	}
	result = FALSE;
	_g_free0 (ext);
	_g_free0 (name);
	return result;
}

gboolean
photo_is_duplicate (GFile* file,
                    const gchar* thumbnail_md5,
                    const gchar* full_md5,
                    PhotoFileFormat file_format)
{
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_table_has_duplicate (_tmp1_, file, thumbnail_md5, full_md5, file_format);
	_database_table_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

PhotoID*
photo_get_duplicate_ids (GFile* file,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         PhotoFileFormat file_format,
                         gint* result_length1)
{
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	gint _tmp2_ = 0;
	PhotoID* _tmp3_;
	PhotoID* _tmp4_;
	gint _tmp4__length1;
	PhotoID* _tmp5_;
	gint _tmp5__length1;
	PhotoID* result;
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp3_ = photo_table_get_duplicate_ids (_tmp1_, file, thumbnail_md5, full_md5, file_format, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_database_table_unref0 (_tmp1_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

gint64
photo_get_photo_key (DataSource* source)
{
	PhotoID _tmp0_ = {0};
	gint64 result;
	g_return_val_if_fail (IS_DATA_SOURCE (source), 0LL);
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_PHOTO, Photo), &_tmp0_);
	result = _tmp0_.id;
	return result;
}

static GFile*
photo_real_get_file (MediaSource* base)
{
	Photo * self;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = photo_get_source_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static void
_vala_array_add95 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add96 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add97 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add98 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
photo_set_master_file (Photo* self,
                       GFile* file)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	gboolean name_changed = FALSE;
	GFile* old_file = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (file);
	filepath = _tmp0_;
	altered = FALSE;
	is_baseline = FALSE;
	is_source = FALSE;
	name_changed = FALSE;
	old_file = NULL;
	{
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				{
					PhotoBackingReaders* _tmp2_;
					_tmp2_ = self->priv->readers;
					g_rec_mutex_lock (&self->priv->__lock_readers);
					{
						PhotoBackingReaders* _tmp3_;
						PhotoFileReader* _tmp4_;
						GFile* _tmp5_;
						GFile* _tmp6_;
						_tmp3_ = self->priv->readers;
						_tmp4_ = _tmp3_->master;
						_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
						_g_object_unref0 (old_file);
						old_file = _tmp5_;
						_tmp6_ = old_file;
						if (!g_file_equal (file, _tmp6_)) {
							PhotoTable* _tmp7_;
							PhotoTable* _tmp8_;
							PhotoID _tmp9_ = {0};
							const gchar* _tmp10_;
							PhotoRow* _tmp11_;
							BackingPhotoRow* _tmp12_;
							const gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							PhotoBackingReaders* _tmp16_;
							PhotoRow* _tmp17_;
							BackingPhotoRow* _tmp18_;
							const gchar* _tmp19_;
							PhotoFileReader* _tmp20_;
							gboolean _tmp21_ = FALSE;
							PhotoRow* _tmp22_;
							const gchar* _tmp23_;
							_tmp7_ = photo_table_get_instance ();
							_tmp8_ = _tmp7_;
							photo_get_photo_id (self, &_tmp9_);
							_tmp10_ = filepath;
							photo_table_set_filepath (_tmp8_, &_tmp9_, _tmp10_, &_inner_error0_);
							_database_table_unref0 (_tmp8_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								goto __catch2_g_error;
							}
							_tmp11_ = self->row;
							_tmp12_ = _tmp11_->master;
							_tmp13_ = filepath;
							_tmp14_ = g_strdup (_tmp13_);
							_g_free0 (_tmp12_->filepath);
							_tmp12_->filepath = _tmp14_;
							_tmp15_ = g_file_get_basename (file);
							_g_free0 (self->priv->file_title);
							self->priv->file_title = _tmp15_;
							_tmp16_ = self->priv->readers;
							_tmp17_ = self->row;
							_tmp18_ = _tmp17_->master;
							_tmp19_ = filepath;
							_tmp20_ = photo_file_format_create_reader (_tmp18_->file_format, _tmp19_);
							_photo_file_adapter_unref0 (_tmp16_->master);
							_tmp16_->master = _tmp20_;
							altered = TRUE;
							is_baseline = photo_is_master_baseline (self);
							is_source = photo_is_master_source (self);
							_tmp22_ = self->row;
							_tmp23_ = _tmp22_->title;
							if (is_string_empty (_tmp23_)) {
								GFile* _tmp24_;
								gchar* _tmp25_;
								gchar* _tmp26_;
								gchar* _tmp27_;
								gchar* _tmp28_;
								_tmp24_ = old_file;
								_tmp25_ = g_file_get_basename (_tmp24_);
								_tmp26_ = _tmp25_;
								_tmp27_ = g_file_get_basename (file);
								_tmp28_ = _tmp27_;
								_tmp21_ = g_strcmp0 (_tmp26_, _tmp28_) != 0;
								_g_free0 (_tmp28_);
								_g_free0 (_tmp26_);
							} else {
								_tmp21_ = FALSE;
							}
							name_changed = _tmp21_;
						}
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* _lock_error_ = NULL;
						GError* _tmp29_;
						_lock_error_ = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp29_ = _lock_error_;
						_lock_error_ = NULL;
						_inner_error0_ = _tmp29_;
						_g_error_free0 (_lock_error_);
						goto __finally2;
					}
					__finally2:
					{
						GError* _inner_error1_ = NULL;
						PhotoBackingReaders* _tmp30_;
						_tmp30_ = self->priv->readers;
						g_rec_mutex_unlock (&self->priv->__lock_readers);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp31_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp31_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp31_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				PhotoRow* _tmp32_;
				_tmp32_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp33_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp33_ = err;
		app_window_database_error (_tmp33_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (old_file);
		_g_free0 (filepath);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (altered) {
		GFile* _tmp34_;
		gchar** alteration_list = NULL;
		gchar** _tmp35_;
		gint alteration_list_length1;
		gint _alteration_list_size_;
		gchar* _tmp36_;
		gchar** _tmp40_;
		gint _tmp40__length1;
		Alteration* _tmp41_;
		Alteration* _tmp42_;
		_tmp34_ = old_file;
		media_source_notify_master_replaced (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), _tmp34_, file);
		if (is_baseline) {
			photo_notify_baseline_replaced (self);
		}
		_tmp35_ = g_new0 (gchar*, 0 + 1);
		alteration_list = _tmp35_;
		alteration_list_length1 = 0;
		_alteration_list_size_ = alteration_list_length1;
		_tmp36_ = g_strdup ("backing:master");
		_vala_array_add95 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp36_);
		if (name_changed) {
			gchar* _tmp37_;
			_tmp37_ = g_strdup ("metadata:name");
			_vala_array_add96 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp37_);
		}
		if (is_source) {
			gchar* _tmp38_;
			_tmp38_ = g_strdup ("backing:source");
			_vala_array_add97 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp38_);
		}
		if (is_baseline) {
			gchar* _tmp39_;
			_tmp39_ = g_strdup ("backing:baseline");
			_vala_array_add98 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp39_);
		}
		_tmp40_ = alteration_list;
		_tmp40__length1 = alteration_list_length1;
		_tmp41_ = alteration_new_from_array (_tmp40_, _tmp40__length1);
		_tmp42_ = _tmp41_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp42_);
		_alteration_unref0 (_tmp42_);
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (old_file);
	_g_free0 (filepath);
}

static void
_vala_array_add99 (gchar** * array,
                   gint* length,
                   gint* size,
                   gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add100 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add101 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

void
photo_set_editable_file (Photo* self,
                         GFile* file)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	gboolean altered = FALSE;
	gboolean is_baseline = FALSE;
	gboolean is_source = FALSE;
	GFile* old_file = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp0_ = g_file_get_path (file);
	filepath = _tmp0_;
	altered = FALSE;
	is_baseline = FALSE;
	is_source = FALSE;
	old_file = NULL;
	{
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				{
					PhotoBackingReaders* _tmp2_;
					_tmp2_ = self->priv->readers;
					g_rec_mutex_lock (&self->priv->__lock_readers);
					{
						GFile* _tmp3_ = NULL;
						PhotoBackingReaders* _tmp4_;
						PhotoFileReader* _tmp5_;
						GFile* _tmp9_;
						gboolean _tmp10_ = FALSE;
						GFile* _tmp11_;
						_tmp4_ = self->priv->readers;
						_tmp5_ = _tmp4_->editable;
						if (_tmp5_ != NULL) {
							PhotoBackingReaders* _tmp6_;
							PhotoFileReader* _tmp7_;
							GFile* _tmp8_;
							_tmp6_ = self->priv->readers;
							_tmp7_ = _tmp6_->editable;
							_tmp8_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
							_g_object_unref0 (_tmp3_);
							_tmp3_ = _tmp8_;
						} else {
							_g_object_unref0 (_tmp3_);
							_tmp3_ = NULL;
						}
						_tmp9_ = _g_object_ref0 (_tmp3_);
						_g_object_unref0 (old_file);
						old_file = _tmp9_;
						_tmp11_ = old_file;
						if (_tmp11_ != NULL) {
							GFile* _tmp12_;
							_tmp12_ = old_file;
							_tmp10_ = !g_file_equal (_tmp12_, file);
						} else {
							_tmp10_ = FALSE;
						}
						if (_tmp10_) {
							BackingPhotoTable* _tmp13_;
							BackingPhotoTable* _tmp14_;
							PhotoRow* _tmp15_;
							BackingPhotoID _tmp16_;
							const gchar* _tmp17_;
							BackingPhotoRow* _tmp18_;
							const gchar* _tmp19_;
							gchar* _tmp20_;
							PhotoBackingReaders* _tmp21_;
							BackingPhotoRow* _tmp22_;
							const gchar* _tmp23_;
							PhotoFileReader* _tmp24_;
							_tmp13_ = backing_photo_table_get_instance ();
							_tmp14_ = _tmp13_;
							_tmp15_ = self->row;
							_tmp16_ = _tmp15_->editable_id;
							_tmp17_ = filepath;
							backing_photo_table_set_filepath (_tmp14_, &_tmp16_, _tmp17_, &_inner_error0_);
							_database_table_unref0 (_tmp14_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (_tmp3_);
								goto __catch2_g_error;
							}
							_tmp18_ = self->priv->editable;
							_tmp19_ = filepath;
							_tmp20_ = g_strdup (_tmp19_);
							_g_free0 (_tmp18_->filepath);
							_tmp18_->filepath = _tmp20_;
							_tmp21_ = self->priv->readers;
							_tmp22_ = self->priv->editable;
							_tmp23_ = filepath;
							_tmp24_ = photo_file_format_create_reader (_tmp22_->file_format, _tmp23_);
							_photo_file_adapter_unref0 (_tmp21_->editable);
							_tmp21_->editable = _tmp24_;
							altered = TRUE;
							is_baseline = photo_is_editable_baseline (self);
							is_source = photo_is_editable_source (self);
						}
						_g_object_unref0 (_tmp3_);
					}
					goto __finally2;
					__catch2_g_error:
					{
						GError* _lock_error_ = NULL;
						GError* _tmp25_;
						_lock_error_ = _inner_error0_;
						_inner_error0_ = NULL;
						_tmp25_ = _lock_error_;
						_lock_error_ = NULL;
						_inner_error0_ = _tmp25_;
						_g_error_free0 (_lock_error_);
						goto __finally2;
					}
					__finally2:
					{
						GError* _inner_error1_ = NULL;
						PhotoBackingReaders* _tmp26_;
						_tmp26_ = self->priv->readers;
						g_rec_mutex_unlock (&self->priv->__lock_readers);
					}
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
				}
			}
			goto __finally1;
			__catch1_g_error:
			{
				GError* _lock_error_ = NULL;
				GError* _tmp27_;
				_lock_error_ = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp27_ = _lock_error_;
				_lock_error_ = NULL;
				_inner_error0_ = _tmp27_;
				_g_error_free0 (_lock_error_);
				goto __finally1;
			}
			__finally1:
			{
				GError* _inner_error1_ = NULL;
				PhotoRow* _tmp28_;
				_tmp28_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp29_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = err;
		app_window_database_error (_tmp29_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (old_file);
		_g_free0 (filepath);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	if (altered) {
		GFile* _tmp30_;
		gchar** alteration_list = NULL;
		gchar** _tmp31_;
		gint alteration_list_length1;
		gint _alteration_list_size_;
		gchar* _tmp32_;
		gchar** _tmp35_;
		gint _tmp35__length1;
		Alteration* _tmp36_;
		Alteration* _tmp37_;
		_tmp30_ = old_file;
		photo_notify_editable_replaced (self, _tmp30_, file);
		if (is_baseline) {
			photo_notify_baseline_replaced (self);
		}
		_tmp31_ = g_new0 (gchar*, 0 + 1);
		alteration_list = _tmp31_;
		alteration_list_length1 = 0;
		_alteration_list_size_ = alteration_list_length1;
		_tmp32_ = g_strdup ("backing:editable");
		_vala_array_add99 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp32_);
		if (is_baseline) {
			gchar* _tmp33_;
			_tmp33_ = g_strdup ("backing:baseline");
			_vala_array_add100 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp33_);
		}
		if (is_source) {
			gchar* _tmp34_;
			_tmp34_ = g_strdup ("backing:source");
			_vala_array_add101 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp34_);
		}
		_tmp35_ = alteration_list;
		_tmp35__length1 = alteration_list_length1;
		_tmp36_ = alteration_new_from_array (_tmp35_, _tmp35__length1);
		_tmp37_ = _tmp36_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp37_);
		_alteration_unref0 (_tmp37_);
		alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_object_unref0 (old_file);
	_g_free0 (filepath);
}

void
photo_set_many_editable_file (GeeMap* map,
                              GError** error)
{
	GeeMapIterator* map_iter = NULL;
	GeeMapIterator* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (map, GEE_TYPE_MAP));
	database_table_begin_transaction ();
	_tmp0_ = gee_map_map_iterator (map);
	map_iter = _tmp0_;
	while (TRUE) {
		GeeMapIterator* _tmp1_;
		GeeMapIterator* _tmp2_;
		gpointer _tmp3_;
		Photo* _tmp4_;
		GeeMapIterator* _tmp5_;
		gpointer _tmp6_;
		GFile* _tmp7_;
		_tmp1_ = map_iter;
		if (!gee_map_iterator_next (_tmp1_)) {
			break;
		}
		_tmp2_ = map_iter;
		_tmp3_ = gee_map_iterator_get_key (_tmp2_);
		_tmp4_ = (Photo*) _tmp3_;
		_tmp5_ = map_iter;
		_tmp6_ = gee_map_iterator_get_value (_tmp5_);
		_tmp7_ = (GFile*) _tmp6_;
		photo_set_editable_file (_tmp4_, _tmp7_);
		_g_object_unref0 (_tmp7_);
		_g_object_unref0 (_tmp4_);
	}
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (map_iter);
			return;
		} else {
			_g_object_unref0 (map_iter);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_g_object_unref0 (map_iter);
}

GFile*
photo_get_actual_file (Photo* self)
{
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_baseline_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GFile*
photo_real_get_master_file (MediaSource* base)
{
	Photo * self;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = photo_get_master_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

GFile*
photo_get_editable_file (Photo* self)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	GFile* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_;
	GFile* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp2_ = reader;
	if (_tmp2_ != NULL) {
		PhotoFileReader* _tmp3_;
		GFile* _tmp4_;
		_tmp3_ = reader;
		_tmp4_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_g_object_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
	} else {
		_g_object_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	_photo_file_adapter_unref0 (reader);
	return result;
}

GeeCollection*
photo_get_raw_developer_files (Photo* self)
{
	GeeArrayList* ret = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeCollection* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	if (photo_get_master_file_format (self) != PHOTO_FILE_FORMAT_RAW) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			{
				GeeIterator* _row_it = NULL;
				GeeHashMap* _tmp2_;
				GeeCollection* _tmp3_;
				GeeCollection* _tmp4_;
				GeeCollection* _tmp5_;
				GeeIterator* _tmp6_;
				GeeIterator* _tmp7_;
				_tmp2_ = self->priv->developments;
				_tmp3_ = gee_abstract_map_get_values (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
				_tmp4_ = _tmp3_;
				_tmp5_ = _tmp4_;
				_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
				_tmp7_ = _tmp6_;
				_g_object_unref0 (_tmp5_);
				_row_it = _tmp7_;
				while (TRUE) {
					GeeIterator* _tmp8_;
					BackingPhotoRow* row = NULL;
					GeeIterator* _tmp9_;
					gpointer _tmp10_;
					GeeArrayList* _tmp11_;
					BackingPhotoRow* _tmp12_;
					const gchar* _tmp13_;
					GFile* _tmp14_;
					GFile* _tmp15_;
					_tmp8_ = _row_it;
					if (!gee_iterator_next (_tmp8_)) {
						break;
					}
					_tmp9_ = _row_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					row = (BackingPhotoRow*) _tmp10_;
					_tmp11_ = ret;
					_tmp12_ = row;
					_tmp13_ = _tmp12_->filepath;
					_tmp14_ = g_file_new_for_path (_tmp13_);
					_tmp15_ = _tmp14_;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp15_);
					_g_object_unref0 (_tmp15_);
					_backing_photo_row_unref0 (row);
				}
				_g_object_unref0 (_row_it);
			}
		}
		__finally0:
		{
			PhotoRow* _tmp16_;
			_tmp16_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = G_TYPE_CHECK_INSTANCE_CAST (ret, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

GFile*
photo_get_source_file (Photo* self)
{
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_source_reader (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp3_ = _tmp2_;
	_photo_file_adapter_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

PhotoFileFormat
photo_get_file_format (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileFormat result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = _tmp1_->file_format;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

PhotoFileFormat
photo_get_best_export_file_format (Photo* self)
{
	PhotoFileFormat file_format = 0;
	PhotoFileFormat result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	file_format = photo_get_file_format (self);
	if (!photo_file_format_can_write (file_format)) {
		file_format = photo_file_format_get_system_default_format ();
	}
	result = file_format;
	return result;
}

PhotoFileFormat
photo_get_master_file_format (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoFileFormat result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->master;
			result = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static GDateTime*
photo_real_get_timestamp (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	GDateTime* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			GDateTime* _tmp2_;
			GDateTime* _tmp3_;
			_tmp1_ = self->backing_photo_row;
			_tmp2_ = _tmp1_->timestamp;
			_tmp3_ = _g_date_time_ref0 (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

void
photo_get_photo_id (Photo* self,
                    PhotoID* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoID _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->photo_id;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline void
photo_real_get_event_id (MediaSource* base,
                         EventID* result)
{
	Photo * self;
	PhotoRow* _tmp0_;
	EventID _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = self->row;
	_tmp1_ = _tmp0_->event_id;
	*result = _tmp1_;
	return;
}

inline gint64
photo_get_raw_event_id (Photo* self)
{
	PhotoRow* _tmp0_;
	EventID _tmp1_;
	gint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0LL);
	_tmp0_ = self->row;
	_tmp1_ = _tmp0_->event_id;
	result = _tmp1_.id;
	return result;
}

static void
photo_real_get_import_id (MediaSource* base,
                          ImportID* result)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			ImportID _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->import_id;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
photo_get_editable_id (Photo* self,
                       BackingPhotoID* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			BackingPhotoID _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->editable_id;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
photo_real_get_master_md5 (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->md5;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

guint64
photo_get_flags (Photo* self)
{
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	{
		PhotoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->flags;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static void
photo_notify_flags_altered (Photo* self,
                            Alteration* additional_alteration)
{
	Alteration* alteration = NULL;
	Alteration* _tmp0_;
	Alteration* _tmp3_;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration));
	_tmp0_ = alteration_new ("metadata", "flags");
	alteration = _tmp0_;
	if (additional_alteration != NULL) {
		Alteration* _tmp1_;
		Alteration* _tmp2_;
		_tmp1_ = alteration;
		_tmp2_ = alteration_compress (_tmp1_, additional_alteration);
		_alteration_unref0 (alteration);
		alteration = _tmp2_;
	}
	_tmp3_ = alteration;
	data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp3_);
	_alteration_unref0 (alteration);
}

guint64
photo_replace_flags (Photo* self,
                     guint64 flags,
                     Alteration* additional_alteration)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoID _tmp3_ = {0};
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			photo_get_photo_id (self, &_tmp3_);
			committed = photo_table_replace_flags (_tmp2_, &_tmp3_, flags);
			_database_table_unref0 (_tmp2_);
			if (committed) {
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				_tmp4_->flags = flags;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp6_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp6_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

gboolean
photo_is_flag_set (Photo* self,
                   guint64 mask)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = media_source_internal_is_flag_set (_tmp1_->flags, mask);
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

guint64
photo_add_flags (Photo* self,
                 guint64 mask,
                 Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = media_source_internal_add_flags (_tmp1_->flags, mask);
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

guint64
photo_remove_flags (Photo* self,
                    guint64 mask,
                    Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = media_source_internal_remove_flags (_tmp1_->flags, mask);
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

guint64
photo_add_remove_flags (Photo* self,
                        guint64 add,
                        guint64 remove,
                        Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = (_tmp1_->flags | add) & (~remove);
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

void
photo_add_remove_many_flags (GeeCollection* add,
                             guint64 add_mask,
                             Alteration* additional_add_alteration,
                             GeeCollection* remove,
                             guint64 remove_mask,
                             Alteration* additional_remove_alteration,
                             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail ((add == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (add, GEE_TYPE_COLLECTION));
	g_return_if_fail ((additional_add_alteration == NULL) || IS_ALTERATION (additional_add_alteration));
	g_return_if_fail ((remove == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (remove, GEE_TYPE_COLLECTION));
	g_return_if_fail ((additional_remove_alteration == NULL) || IS_ALTERATION (additional_remove_alteration));
	database_table_begin_transaction ();
	if (add != NULL) {
		{
			GeeIterator* _photo_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (add, GEE_TYPE_ITERABLE, GeeIterable));
			_photo_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				Photo* photo = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				Photo* _tmp4_;
				_tmp1_ = _photo_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _photo_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				photo = (Photo*) _tmp3_;
				_tmp4_ = photo;
				photo_add_flags (_tmp4_, add_mask, additional_add_alteration);
				_g_object_unref0 (photo);
			}
			_g_object_unref0 (_photo_it);
		}
	}
	if (remove != NULL) {
		{
			GeeIterator* _photo_it = NULL;
			GeeIterator* _tmp5_;
			_tmp5_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (remove, GEE_TYPE_ITERABLE, GeeIterable));
			_photo_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				Photo* photo = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				Photo* _tmp9_;
				_tmp6_ = _photo_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _photo_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				photo = (Photo*) _tmp8_;
				_tmp9_ = photo;
				photo_remove_flags (_tmp9_, remove_mask, additional_remove_alteration);
				_g_object_unref0 (photo);
			}
			_g_object_unref0 (_photo_it);
		}
	}
	database_table_commit_transaction (&_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

guint64
photo_toggle_flags (Photo* self,
                    guint64 mask,
                    Alteration* additional_alteration)
{
	guint64 flags = 0ULL;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	g_return_val_if_fail ((additional_alteration == NULL) || IS_ALTERATION (additional_alteration), 0ULL);
	flags = (guint64) 0;
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			PhotoRow* _tmp2_;
			_tmp1_ = self->row;
			flags = _tmp1_->flags ^ mask;
			_tmp2_ = self->row;
			if (_tmp2_->flags != flags) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_replace_flags (_tmp4_, &_tmp5_, flags);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->flags = flags;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			guint64 _tmp8_ = 0ULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		photo_notify_flags_altered (self, additional_alteration);
	}
	result = flags;
	return result;
}

gboolean
photo_is_master_metadata_dirty (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->metadata_dirty;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

void
photo_set_master_metadata_dirty (Photo* self,
                                 gboolean dirty,
                                 GError** error)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (_tmp1_->metadata_dirty != dirty) {
				PhotoTable* _tmp2_;
				PhotoTable* _tmp3_;
				PhotoID _tmp4_ = {0};
				PhotoRow* _tmp5_;
				_tmp2_ = photo_table_get_instance ();
				_tmp3_ = _tmp2_;
				photo_get_photo_id (self, &_tmp4_);
				photo_table_set_metadata_dirty (_tmp3_, &_tmp4_, dirty, &_inner_error0_);
				_database_table_unref0 (_tmp3_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = self->row;
				_tmp5_->metadata_dirty = dirty;
				committed = TRUE;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp6_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp6_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp8_;
		Alteration* _tmp9_;
		_tmp8_ = alteration_new ("metadata", "master-dirty");
		_tmp9_ = _tmp8_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp9_);
		_alteration_unref0 (_tmp9_);
	}
}

static Rating
photo_real_get_rating (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	Rating result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->rating;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

static void
photo_real_set_rating (MediaSource* base,
                       Rating rating)
{
	Photo * self;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			if (rating != _tmp2_->rating) {
				_tmp1_ = rating_is_valid (rating);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				PhotoTable* _tmp3_;
				PhotoTable* _tmp4_;
				PhotoID _tmp5_ = {0};
				_tmp3_ = photo_table_get_instance ();
				_tmp4_ = _tmp3_;
				photo_get_photo_id (self, &_tmp5_);
				committed = photo_table_set_rating (_tmp4_, &_tmp5_, rating);
				_database_table_unref0 (_tmp4_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->rating = rating;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp8_;
		Alteration* _tmp9_;
		_tmp8_ = alteration_new ("metadata", "rating");
		_tmp9_ = _tmp8_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp9_);
		_alteration_unref0 (_tmp9_);
	}
}

static void
photo_real_increase_rating (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_increase (_tmp1_->rating));
		}
		__finally0:
		{
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
photo_real_decrease_rating (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), rating_decrease (_tmp1_->rating));
		}
		__finally0:
		{
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
photo_real_commit_backlinks (DataSource* base,
                             SourceCollection* sources,
                             const gchar* backlinks)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	g_return_if_fail ((sources == NULL) || IS_SOURCE_COLLECTION (sources));
	{
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		PhotoID _tmp2_ = {0};
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		photo_get_photo_id (self, &_tmp2_);
		photo_table_update_backlinks (_tmp1_, &_tmp2_, backlinks, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				PhotoRow* _tmp4_;
				gchar* _tmp5_;
				_tmp4_ = self->row;
				_tmp5_ = g_strdup (backlinks);
				_g_free0 (_tmp4_->backlinks);
				_tmp4_->backlinks = _tmp5_;
			}
			__finally1:
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					goto __catch0_database_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp8_ = _tmp7_;
		_tmp9_ = err;
		_tmp10_ = _tmp9_->message;
		g_warning ("Photo.vala:2246: Unable to update link state for %s: %s", _tmp8_, _tmp10_);
		_g_free0 (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gboolean
photo_real_set_event_id (MediaSource* base,
                         EventID* event_id)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	g_return_val_if_fail (event_id != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp11_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean committed = FALSE;
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			EventID _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->photo_id;
			_tmp5_ = *event_id;
			_tmp6_ = photo_table_set_event (_tmp2_, &_tmp4_, &_tmp5_);
			_database_table_unref0 (_tmp2_);
			committed = _tmp6_;
			if (committed) {
				PhotoRow* _tmp7_;
				EventID _tmp8_;
				_tmp7_ = self->row;
				_tmp8_ = *event_id;
				_tmp7_->event_id = _tmp8_;
			}
			result = committed;
			{
				PhotoRow* _tmp9_;
				_tmp9_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp10_;
			_tmp10_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
}

static gchar*
photo_real_to_string (DataObject* base)
{
	Photo * self;
	gchar* _tmp0_ = NULL;
	PhotoID _tmp9_ = {0};
	gchar* _tmp10_;
	gchar* _tmp11_;
	PhotoFileReader* _tmp12_;
	PhotoFileReader* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	if (!photo_is_master_baseline (self)) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = photo_get_actual_file (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_file_get_path (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (" (", _tmp4_, NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp6_, ")", NULL);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		_g_object_unref0 (_tmp2_);
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("");
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	photo_get_photo_id (self, &_tmp9_);
	_tmp10_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp9_.id);
	_tmp11_ = _tmp10_;
	_tmp12_ = photo_get_master_reader (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup_printf ("[%s] %s%s", _tmp11_, _tmp15_, _tmp0_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp15_);
	_photo_file_adapter_unref0 (_tmp13_);
	_g_free0 (_tmp11_);
	result = _tmp17_;
	_g_free0 (_tmp0_);
	return result;
}

static gboolean
photo_real_equals (DataSource* base,
                   DataSource* source)
{
	Photo * self;
	Photo* photo = NULL;
	Photo* _tmp0_;
	Photo* _tmp1_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	g_return_val_if_fail ((source == NULL) || IS_DATA_SOURCE (source), FALSE);
	_tmp0_ = _g_object_ref0 (IS_PHOTO (source) ? ((Photo*) source) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (_tmp1_ != NULL) {
		PhotoID photo_id = {0};
		PhotoID _tmp2_ = {0};
		PhotoID other_photo_id = {0};
		Photo* _tmp3_;
		PhotoID _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		Photo* _tmp6_;
		photo_get_photo_id (self, &_tmp2_);
		photo_id = _tmp2_;
		_tmp3_ = photo;
		photo_get_photo_id (_tmp3_, &_tmp4_);
		other_photo_id = _tmp4_;
		_tmp6_ = photo;
		if (self != _tmp6_) {
			PhotoID _tmp7_;
			_tmp7_ = photo_id;
			_tmp5_ = _tmp7_.id != PHOTO_ID_INVALID;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			PhotoID _tmp8_;
			PhotoID _tmp9_;
			_tmp8_ = photo_id;
			_tmp9_ = other_photo_id;
			_vala_assert (_tmp8_.id != _tmp9_.id, "photo_id.id != other_photo_id.id");
		}
	}
	result = DATA_SOURCE_CLASS (photo_parent_class)->equals (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource), TYPE_DATA_SOURCE, DataSource), source);
	_g_object_unref0 (photo);
	return result;
}

static void
photo_file_exif_updated (Photo* self)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* info = NULL;
	GDateTime* timestamp = NULL;
	GFileInfo* _tmp7_;
	GDateTime* _tmp8_;
	GDateTime* _tmp9_;
	GDateTime* _tmp10_;
	GDateTime* _tmp11_;
	PhotoFileInterrogator* interrogator = NULL;
	PhotoFileInterrogator* _tmp12_;
	DetectedPhotoInformation* detected = NULL;
	DetectedPhotoInformation* _tmp17_;
	gboolean _tmp18_ = FALSE;
	DetectedPhotoInformation* _tmp19_;
	gboolean success = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	file = _tmp0_;
	info = NULL;
	{
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		_tmp2_ = g_file_query_info (file, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (info);
		info = _tmp3_;
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp5_ = _tmp4_;
		_tmp6_ = err->message;
		g_error ("Photo.vala:2294: Unable to read file information for %s: %s", _tmp5_, _tmp6_);
		_g_free0 (_tmp5_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp7_ = info;
	_tmp8_ = g_file_info_get_modification_date_time (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = coarsify_date_time (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_date_time_unref0 (_tmp9_);
	timestamp = _tmp11_;
	_tmp12_ = photo_file_interrogator_new (file, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL);
	interrogator = _tmp12_;
	{
		photo_file_interrogator_interrogate (interrogator, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* err = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		GError* _tmp15_;
		const gchar* _tmp16_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp13_ = g_file_get_path (file);
		_tmp14_ = _tmp13_;
		_tmp15_ = err;
		_tmp16_ = _tmp15_->message;
		g_warning ("Photo.vala:2304: Unable to interrogate photo file %s: %s", _tmp14_, _tmp16_);
		_g_free0 (_tmp14_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp17_ = photo_file_interrogator_get_detected_photo_information (interrogator);
	detected = _tmp17_;
	_tmp19_ = detected;
	if (_tmp19_ == NULL) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = photo_file_interrogator_get_is_photo_corrupted (interrogator);
	}
	if (_tmp18_) {
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp21_ = _tmp20_;
		g_critical ("Photo.vala:2309: file_exif_updated: %s no longer an image", _tmp21_);
		_g_free0 (_tmp21_);
		_detected_photo_information_unref0 (detected);
		_photo_file_interrogator_unref0 (interrogator);
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return;
	}
	{
		PhotoRow* _tmp22_;
		_tmp22_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp23_;
			PhotoTable* _tmp24_;
			PhotoID _tmp25_ = {0};
			GFileInfo* _tmp26_;
			DetectedPhotoInformation* _tmp27_;
			const gchar* _tmp28_;
			DetectedPhotoInformation* _tmp29_;
			const gchar* _tmp30_;
			DetectedPhotoInformation* _tmp31_;
			const gchar* _tmp32_;
			PhotoRow* _tmp33_;
			_tmp23_ = photo_table_get_instance ();
			_tmp24_ = _tmp23_;
			photo_get_photo_id (self, &_tmp25_);
			_tmp26_ = info;
			_tmp27_ = detected;
			_tmp28_ = _tmp27_->md5;
			_tmp29_ = detected;
			_tmp30_ = _tmp29_->exif_md5;
			_tmp31_ = detected;
			_tmp32_ = _tmp31_->thumbnail_md5;
			_tmp33_ = self->row;
			success = photo_table_master_exif_updated (_tmp24_, &_tmp25_, g_file_info_get_size (_tmp26_), timestamp, _tmp28_, _tmp30_, _tmp32_, _tmp33_);
			_database_table_unref0 (_tmp24_);
		}
		__finally2:
		{
			PhotoRow* _tmp34_;
			_tmp34_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_detected_photo_information_unref0 (detected);
			_photo_file_interrogator_unref0 (interrogator);
			_g_date_time_unref0 (timestamp);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (success) {
		Alteration* _tmp35_;
		Alteration* _tmp36_;
		_tmp35_ = alteration_new_from_list ("metadata:exif,metadata:md5");
		_tmp36_ = _tmp35_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp36_);
		_alteration_unref0 (_tmp36_);
	}
	_detected_photo_information_unref0 (detected);
	_photo_file_interrogator_unref0 (interrogator);
	_g_date_time_unref0 (timestamp);
	_g_object_unref0 (info);
	_g_object_unref0 (file);
}

static guint64
photo_real_get_filesize (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = (guint64) _tmp1_->filesize;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static guint64
photo_real_get_master_filesize (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	guint64 result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		guint64 _tmp5_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			BackingPhotoRow* _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->master;
			result = (guint64) _tmp2_->filesize;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp5_;
	}
}

guint64
photo_get_editable_filesize (Photo* self)
{
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (IS_PHOTO (self), 0ULL);
	{
		PhotoRow* _tmp0_;
		guint64 _tmp4_ = 0ULL;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->priv->editable;
			result = (guint64) _tmp1_->filesize;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

static GDateTime*
photo_real_get_exposure_time (Dateable* base)
{
	Photo * self;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = self->priv->cached_exposure_time;
	_tmp1_ = _g_date_time_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
photo_real_get_basename (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			const gchar* _tmp1_;
			gchar* _tmp2_;
			_tmp1_ = self->priv->file_title;
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
photo_real_get_title (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->title;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gchar*
photo_real_get_comment (MediaSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->comment;
			_tmp3_ = g_strdup (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static void
photo_real_set_title (MediaSource* base,
                      const gchar* title)
{
	Photo * self;
	gchar* new_title = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = media_source_prep_title (title);
	new_title = _tmp0_;
	committed = FALSE;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			const gchar* _tmp2_;
			PhotoRow* _tmp3_;
			const gchar* _tmp4_;
			PhotoTable* _tmp6_;
			PhotoTable* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoID _tmp9_;
			const gchar* _tmp10_;
			_tmp2_ = new_title;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->title;
			if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
				{
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				_g_free0 (new_title);
				return;
			}
			_tmp6_ = photo_table_get_instance ();
			_tmp7_ = _tmp6_;
			_tmp8_ = self->row;
			_tmp9_ = _tmp8_->photo_id;
			_tmp10_ = new_title;
			committed = photo_table_set_title (_tmp7_, &_tmp9_, _tmp10_);
			_database_table_unref0 (_tmp7_);
			if (committed) {
				PhotoRow* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->row;
				_tmp12_ = new_title;
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (_tmp11_->title);
				_tmp11_->title = _tmp13_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (new_title);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp15_;
		Alteration* _tmp16_;
		_tmp15_ = alteration_new ("metadata", "name");
		_tmp16_ = _tmp15_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp16_);
		_alteration_unref0 (_tmp16_);
	}
	_g_free0 (new_title);
}

static void
photo_real_get_gps_coords (Positionable* base,
                           GpsCoords* result)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GpsCoords _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->gps_coords;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static void
photo_real_set_gps_coords (Positionable* base,
                           GpsCoords* gps_coords)
{
	Photo * self;
	GError* dberr = NULL;
	GError* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	g_return_if_fail (gps_coords != NULL);
	dberr = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			{
				PhotoTable* _tmp1_;
				PhotoTable* _tmp2_;
				PhotoRow* _tmp3_;
				PhotoID _tmp4_;
				GpsCoords _tmp5_;
				PhotoRow* _tmp7_;
				GpsCoords _tmp8_;
				_tmp1_ = photo_table_get_instance ();
				_tmp2_ = _tmp1_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->photo_id;
				_tmp5_ = *gps_coords;
				photo_table_set_gps_coords (_tmp2_, &_tmp4_, &_tmp5_, &_inner_error0_);
				_database_table_unref0 (_tmp2_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						PhotoRow* _tmp6_;
						_tmp6_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					_g_error_free0 (dberr);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp7_ = self->row;
				_tmp8_ = *gps_coords;
				_tmp7_->gps_coords = _tmp8_;
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* err = NULL;
				GError* _tmp9_;
				GError* _tmp10_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp9_ = err;
				_tmp10_ = _g_error_copy0 (_tmp9_);
				_g_error_free0 (dberr);
				dberr = _tmp10_;
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (dberr);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp11_;
			_tmp11_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (dberr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = dberr;
	if (_tmp12_ == NULL) {
		Alteration* _tmp13_;
		Alteration* _tmp14_;
		_tmp13_ = alteration_new ("metadata", "gps");
		_tmp14_ = _tmp13_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp14_);
		_alteration_unref0 (_tmp14_);
	} else {
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp16_ = _tmp15_;
		_tmp17_ = dberr;
		_tmp18_ = _tmp17_->message;
		g_warning ("Photo.vala:2402: Unable to write gps coordinates for %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
	}
	_g_error_free0 (dberr);
}

static gboolean
photo_real_set_comment (MediaSource* base,
                        const gchar* comment)
{
	Photo * self;
	gchar* new_comment = NULL;
	gchar* _tmp0_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	_tmp0_ = media_source_prep_comment (comment);
	new_comment = _tmp0_;
	committed = FALSE;
	{
		PhotoRow* _tmp1_;
		_tmp1_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			const gchar* _tmp2_;
			PhotoRow* _tmp3_;
			const gchar* _tmp4_;
			PhotoTable* _tmp6_;
			PhotoTable* _tmp7_;
			PhotoRow* _tmp8_;
			PhotoID _tmp9_;
			const gchar* _tmp10_;
			_tmp2_ = new_comment;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->comment;
			if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
				result = TRUE;
				{
					PhotoRow* _tmp5_;
					_tmp5_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				_g_free0 (new_comment);
				return result;
			}
			_tmp6_ = photo_table_get_instance ();
			_tmp7_ = _tmp6_;
			_tmp8_ = self->row;
			_tmp9_ = _tmp8_->photo_id;
			_tmp10_ = new_comment;
			committed = photo_table_set_comment (_tmp7_, &_tmp9_, _tmp10_);
			_database_table_unref0 (_tmp7_);
			if (committed) {
				PhotoRow* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->row;
				_tmp12_ = new_comment;
				_tmp13_ = g_strdup (_tmp12_);
				_g_free0 (_tmp11_->comment);
				_tmp11_->comment = _tmp13_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			_g_free0 (new_comment);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	}
	if (committed) {
		Alteration* _tmp16_;
		Alteration* _tmp17_;
		_tmp16_ = alteration_new ("metadata", "comment");
		_tmp17_ = _tmp16_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp17_);
		_alteration_unref0 (_tmp17_);
	}
	result = committed;
	_g_free0 (new_comment);
	return result;
}

void
photo_set_import_id (Photo* self,
                     ImportID* import_id)
{
	GError* dberr = NULL;
	GError* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (import_id != NULL);
	dberr = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			{
				PhotoTable* _tmp1_;
				PhotoTable* _tmp2_;
				PhotoRow* _tmp3_;
				PhotoID _tmp4_;
				ImportID _tmp5_;
				PhotoRow* _tmp7_;
				ImportID _tmp8_;
				_tmp1_ = photo_table_get_instance ();
				_tmp2_ = _tmp1_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->photo_id;
				_tmp5_ = *import_id;
				photo_table_set_import_id (_tmp2_, &_tmp4_, &_tmp5_, &_inner_error0_);
				_database_table_unref0 (_tmp2_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch1_database_error;
					}
					{
						PhotoRow* _tmp6_;
						_tmp6_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					_g_error_free0 (dberr);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp7_ = self->row;
				_tmp8_ = *import_id;
				_tmp7_->import_id = _tmp8_;
			}
			goto __finally1;
			__catch1_database_error:
			{
				GError* err = NULL;
				GError* _tmp9_;
				GError* _tmp10_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp9_ = err;
				_tmp10_ = _g_error_copy0 (_tmp9_);
				_g_error_free0 (dberr);
				dberr = _tmp10_;
				_g_error_free0 (err);
			}
			__finally1:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (dberr);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp11_;
			_tmp11_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_error_free0 (dberr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp12_ = dberr;
	if (_tmp12_ == NULL) {
		Alteration* _tmp13_;
		Alteration* _tmp14_;
		_tmp13_ = alteration_new ("metadata", "import-id");
		_tmp14_ = _tmp13_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp14_);
		_alteration_unref0 (_tmp14_);
	} else {
		gchar* _tmp15_;
		gchar* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		_tmp15_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp16_ = _tmp15_;
		_tmp17_ = dberr;
		_tmp18_ = _tmp17_->message;
		g_warning ("Photo.vala:2439: Unable to write import ID for %s: %s", _tmp16_, _tmp18_);
		_g_free0 (_tmp16_);
	}
	_g_error_free0 (dberr);
}

void
photo_set_title_persistent (Photo* self,
                            const gchar* title,
                            GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp8_;
	PhotoFileMetadataWriter* _tmp9_;
	PhotoFileReader* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = photo_get_source_reader (self);
	source = _tmp0_;
	_tmp1_ = source;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = source;
		_tmp3_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp4_ = _tmp3_;
		g_warning ("Photo.vala:2447: No photo file writer available for %s", _tmp4_);
		_g_free0 (_tmp4_);
		media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), title);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp5_ = source;
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp7_ = metadata;
	photo_metadata_set_title (_tmp7_, title, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	_tmp8_ = source;
	_tmp9_ = photo_file_reader_create_metadata_writer (_tmp8_, &_inner_error0_);
	writer = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp10_ = source;
	_tmp11_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp12_ = _tmp11_;
	library_monitor_blacklist_file (_tmp12_, "Photo.set_persistent_title");
	_g_object_unref0 (_tmp12_);
	{
		PhotoFileMetadataWriter* _tmp13_;
		PhotoMetadata* _tmp14_;
		_tmp13_ = writer;
		_tmp14_ = metadata;
		photo_file_metadata_writer_write_metadata (_tmp13_, _tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		PhotoFileReader* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp15_ = source;
		_tmp16_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp17_ = _tmp16_;
		library_monitor_unblacklist_file (_tmp17_);
		_g_object_unref0 (_tmp17_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	media_source_set_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), title);
	photo_file_exif_updated (self);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (source);
}

void
photo_set_comment_persistent (Photo* self,
                              const gchar* comment,
                              GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp8_;
	PhotoFileMetadataWriter* _tmp9_;
	PhotoFileReader* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = photo_get_source_reader (self);
	source = _tmp0_;
	_tmp1_ = source;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = source;
		_tmp3_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp4_ = _tmp3_;
		g_warning ("Photo.vala:2475: No photo file writer available for %s", _tmp4_);
		_g_free0 (_tmp4_);
		media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), comment);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp5_ = source;
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp7_ = metadata;
	photo_metadata_set_comment (_tmp7_, comment, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	_tmp8_ = source;
	_tmp9_ = photo_file_reader_create_metadata_writer (_tmp8_, &_inner_error0_);
	writer = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp10_ = source;
	_tmp11_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp12_ = _tmp11_;
	library_monitor_blacklist_file (_tmp12_, "Photo.set_persistent_comment");
	_g_object_unref0 (_tmp12_);
	{
		PhotoFileMetadataWriter* _tmp13_;
		PhotoMetadata* _tmp14_;
		_tmp13_ = writer;
		_tmp14_ = metadata;
		photo_file_metadata_writer_write_metadata (_tmp13_, _tmp14_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		PhotoFileReader* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp15_ = source;
		_tmp16_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp17_ = _tmp16_;
		library_monitor_unblacklist_file (_tmp17_);
		_g_object_unref0 (_tmp17_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	media_source_set_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), comment);
	photo_file_exif_updated (self);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (source);
}

static void
photo_real_set_exposure_time (Dateable* base,
                              GDateTime* time)
{
	Photo * self;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	g_return_if_fail (time != NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->photo_id;
			committed = photo_table_set_exposure_time (_tmp2_, &_tmp4_, time);
			_database_table_unref0 (_tmp2_);
			if (committed) {
				PhotoRow* _tmp5_;
				GDateTime* _tmp6_;
				GDateTime* _tmp7_;
				_tmp5_ = self->row;
				_tmp6_ = _g_date_time_ref0 (time);
				_g_date_time_unref0 (_tmp5_->exposure_time);
				_tmp5_->exposure_time = _tmp6_;
				_tmp7_ = _g_date_time_ref0 (time);
				_g_date_time_unref0 (self->priv->cached_exposure_time);
				self->priv->cached_exposure_time = _tmp7_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp8_;
			_tmp8_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp9_;
		Alteration* _tmp10_;
		_tmp9_ = alteration_new ("metadata", "exposure-time");
		_tmp10_ = _tmp9_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp10_);
		_alteration_unref0 (_tmp10_);
	}
}

void
photo_set_exposure_time_persistent (Photo* self,
                                    GDateTime* time,
                                    GError** error)
{
	PhotoFileReader* source = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp5_;
	PhotoMetadata* _tmp6_;
	PhotoMetadata* _tmp7_;
	MetadataDateTime* _tmp8_;
	MetadataDateTime* _tmp9_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp10_;
	PhotoFileMetadataWriter* _tmp11_;
	PhotoFileReader* _tmp12_;
	GFile* _tmp13_;
	GFile* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (time != NULL);
	_tmp0_ = photo_get_source_reader (self);
	source = _tmp0_;
	_tmp1_ = source;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
		PhotoFileReader* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = source;
		_tmp3_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp4_ = _tmp3_;
		g_warning ("Photo.vala:2517: No photo file writer available for %s", _tmp4_);
		_g_free0 (_tmp4_);
		dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), time);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp5_ = source;
	_tmp6_ = photo_file_reader_read_metadata (_tmp5_, &_inner_error0_);
	metadata = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp7_ = metadata;
	_tmp8_ = metadata_date_time_new (time);
	_tmp9_ = _tmp8_;
	photo_metadata_set_exposure_date_time (_tmp7_, _tmp9_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	_metadata_date_time_unref0 (_tmp9_);
	_tmp10_ = source;
	_tmp11_ = photo_file_reader_create_metadata_writer (_tmp10_, &_inner_error0_);
	writer = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	_tmp12_ = source;
	_tmp13_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp14_ = _tmp13_;
	library_monitor_blacklist_file (_tmp14_, "Photo.set_exposure_time_persistent");
	_g_object_unref0 (_tmp14_);
	{
		PhotoFileMetadataWriter* _tmp15_;
		PhotoMetadata* _tmp16_;
		_tmp15_ = writer;
		_tmp16_ = metadata;
		photo_file_metadata_writer_write_metadata (_tmp15_, _tmp16_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __finally0;
		}
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		PhotoFileReader* _tmp17_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		_tmp17_ = source;
		_tmp18_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
		_tmp19_ = _tmp18_;
		library_monitor_unblacklist_file (_tmp19_);
		_g_object_unref0 (_tmp19_);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (source);
		return;
	}
	dateable_set_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATEABLE, Dateable), time);
	photo_file_exif_updated (self);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (source);
}

/**
     * @brief Returns the width and height of the Photo after various
     * arbitrary stages of the pipeline have been applied in
     * the same order they're applied in get_pixbuf_with_options.
     * With no argument passed, it works exactly like the
     * previous incarnation did.
     *
     * @param disallowed_steps Which pipeline steps should NOT
     *      be taken into account when computing image dimensions
     *      (matching the convention set by get_pixbuf_with_options()).
     *      Pipeline steps that do not affect the image geometry are
     *      ignored.
     */
static void
photo_real_get_dimensions (MediaSource* base,
                           PhotoException disallowed_steps,
                           Dimensions* result)
{
	Photo * self;
	Dimensions returned_dims = {0};
	Dimensions _tmp0_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	photo_get_raw_dimensions (self, &_tmp0_);
	returned_dims = _tmp0_;
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_ORIENTATION)) {
		Orientation ori_tmp = 0;
		ori_tmp = photo_get_orientation (self);
		switch (ori_tmp) {
			case ORIENTATION_LEFT_TOP:
			case ORIENTATION_RIGHT_TOP:
			case ORIENTATION_LEFT_BOTTOM:
			case ORIENTATION_RIGHT_BOTTOM:
			{
				gint width_tmp = 0;
				Dimensions _tmp1_;
				Dimensions _tmp2_;
				_tmp1_ = returned_dims;
				width_tmp = _tmp1_.width;
				_tmp2_ = returned_dims;
				returned_dims.width = _tmp2_.height;
				returned_dims.height = width_tmp;
				break;
			}
			default:
			{
				break;
			}
		}
	}
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_STRAIGHTEN)) {
		gdouble x_size = 0.0;
		gdouble y_size = 0.0;
		gdouble angle = 0.0;
		gdouble _tmp3_ = 0.0;
		Dimensions _tmp4_;
		Dimensions _tmp5_;
		gdouble _tmp6_ = 0.0;
		gdouble _tmp7_ = 0.0;
		angle = 0.0;
		photo_get_straighten (self, &_tmp3_);
		angle = _tmp3_;
		_tmp4_ = returned_dims;
		_tmp5_ = returned_dims;
		compute_arb_rotated_size ((gdouble) _tmp4_.width, (gdouble) _tmp5_.height, angle, &_tmp6_, &_tmp7_);
		x_size = _tmp6_;
		y_size = _tmp7_;
		returned_dims.width = (gint) x_size;
		returned_dims.height = (gint) y_size;
	}
	if (photo_exception_allows (disallowed_steps, PHOTO_EXCEPTION_CROP)) {
		Box crop = {0};
		Box _tmp8_ = {0};
		gboolean _tmp9_;
		_tmp9_ = photo_get_crop (self, &_tmp8_, disallowed_steps);
		crop = _tmp8_;
		if (_tmp9_) {
			Dimensions _tmp10_ = {0};
			box_get_dimensions (&crop, &_tmp10_);
			returned_dims = _tmp10_;
		}
	}
	*result = returned_dims;
	return;
}

static void
photo_locked_create_adjustments_from_data (Photo* self)
{
	PixelTransformationBundle* _tmp0_;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	PixelTransformationBundle* _tmp6_;
	PixelTransformer* _tmp7_;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = pixel_transformation_bundle_new ();
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	self->priv->adjustments = _tmp0_;
	_tmp1_ = photo_get_transformation (self, "adjustments");
	map = _tmp1_;
	_tmp2_ = map;
	if (_tmp2_ == NULL) {
		PixelTransformationBundle* _tmp3_;
		_tmp3_ = self->priv->adjustments;
		pixel_transformation_bundle_set_to_identity (_tmp3_);
	} else {
		PixelTransformationBundle* _tmp4_;
		KeyValueMap* _tmp5_;
		_tmp4_ = self->priv->adjustments;
		_tmp5_ = map;
		pixel_transformation_bundle_load (_tmp4_, _tmp5_);
	}
	_tmp6_ = self->priv->adjustments;
	_tmp7_ = pixel_transformation_bundle_generate_transformer (_tmp6_);
	_pixel_transformer_unref0 (self->priv->transformer);
	self->priv->transformer = _tmp7_;
	_key_value_map_unref0 (map);
}

PixelTransformationBundle*
photo_get_color_adjustments (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PixelTransformationBundle* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformationBundle* _tmp1_;
			PixelTransformationBundle* _tmp2_;
			PixelTransformationBundle* _tmp3_;
			_tmp1_ = self->priv->adjustments;
			if (_tmp1_ == NULL) {
				photo_locked_create_adjustments_from_data (self);
			}
			_tmp2_ = self->priv->adjustments;
			_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

PixelTransformer*
photo_get_pixel_transformer (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PixelTransformer* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformer* _tmp1_;
			PixelTransformer* _tmp2_;
			PixelTransformer* _tmp3_;
			_tmp1_ = self->priv->transformer;
			if (_tmp1_ == NULL) {
				photo_locked_create_adjustments_from_data (self);
			}
			_tmp2_ = self->priv->transformer;
			_tmp3_ = pixel_transformer_copy (_tmp2_);
			result = _tmp3_;
			{
				PhotoRow* _tmp4_;
				_tmp4_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp5_;
			_tmp5_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

gboolean
photo_has_color_adjustments (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	result = photo_has_transformation (self, "adjustments");
	return result;
}

PixelTransformation*
photo_get_color_adjustment (Photo* self,
                            PixelTransformationType type)
{
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
	PixelTransformation* _tmp2_;
	PixelTransformation* _tmp3_;
	PixelTransformation* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_color_adjustments (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pixel_transformation_bundle_get_transformation (_tmp1_, type);
	_tmp3_ = _tmp2_;
	_pixel_transformation_bundle_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

void
photo_set_color_adjustments (Photo* self,
                             PixelTransformationBundle* new_adjustments)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp4_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_adjustments, TYPE_PIXEL_TRANSFORMATION_BUNDLE));
	if (pixel_transformation_bundle_is_identity (new_adjustments)) {
		gboolean _result_ = FALSE;
		{
			PhotoRow* _tmp0_;
			_tmp0_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				_result_ = photo_remove_transformation (self, "adjustments");
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = NULL;
				_pixel_transformer_unref0 (self->priv->transformer);
				self->priv->transformer = NULL;
			}
			__finally0:
			{
				PhotoRow* _tmp1_;
				_tmp1_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		if (_result_) {
			Alteration* _tmp2_;
			Alteration* _tmp3_;
			_tmp2_ = alteration_new ("image", "color-adjustments");
			_tmp3_ = _tmp2_;
			data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp3_);
			_alteration_unref0 (_tmp3_);
		}
		return;
	}
	_tmp4_ = pixel_transformation_bundle_save (new_adjustments, "adjustments");
	map = _tmp4_;
	{
		PhotoRow* _tmp5_;
		_tmp5_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp6_ = FALSE;
			PixelTransformer* _tmp7_;
			KeyValueMap* _tmp25_;
			_tmp7_ = self->priv->transformer;
			if (_tmp7_ == NULL) {
				_tmp6_ = TRUE;
			} else {
				PixelTransformationBundle* _tmp8_;
				_tmp8_ = self->priv->adjustments;
				_tmp6_ = _tmp8_ == NULL;
			}
			if (_tmp6_) {
				PixelTransformationBundle* _tmp9_;
				PixelTransformer* _tmp10_;
				_tmp9_ = pixel_transformation_bundle_copy (new_adjustments);
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = _tmp9_;
				_tmp10_ = pixel_transformation_bundle_generate_transformer (new_adjustments);
				_pixel_transformer_unref0 (self->priv->transformer);
				self->priv->transformer = _tmp10_;
			} else {
				PixelTransformationBundle* _tmp24_;
				{
					GeeIterator* _transformation_it = NULL;
					GeeIterable* _tmp11_;
					GeeIterable* _tmp12_;
					GeeIterator* _tmp13_;
					GeeIterator* _tmp14_;
					_tmp11_ = pixel_transformation_bundle_get_transformations (new_adjustments);
					_tmp12_ = _tmp11_;
					_tmp13_ = gee_iterable_iterator (_tmp12_);
					_tmp14_ = _tmp13_;
					_g_object_unref0 (_tmp12_);
					_transformation_it = _tmp14_;
					while (TRUE) {
						GeeIterator* _tmp15_;
						PixelTransformation* transformation = NULL;
						GeeIterator* _tmp16_;
						gpointer _tmp17_;
						PixelTransformer* _tmp18_;
						PixelTransformationBundle* _tmp19_;
						PixelTransformation* _tmp20_;
						PixelTransformation* _tmp21_;
						PixelTransformation* _tmp22_;
						PixelTransformation* _tmp23_;
						_tmp15_ = _transformation_it;
						if (!gee_iterator_next (_tmp15_)) {
							break;
						}
						_tmp16_ = _transformation_it;
						_tmp17_ = gee_iterator_get (_tmp16_);
						transformation = (PixelTransformation*) _tmp17_;
						_tmp18_ = self->priv->transformer;
						_tmp19_ = self->priv->adjustments;
						_tmp20_ = transformation;
						_tmp21_ = pixel_transformation_bundle_get_transformation (_tmp19_, pixel_transformation_get_transformation_type (_tmp20_));
						_tmp22_ = _tmp21_;
						_tmp23_ = transformation;
						pixel_transformer_replace_transformation (_tmp18_, _tmp22_, _tmp23_);
						_pixel_transformation_unref0 (_tmp22_);
						_pixel_transformation_unref0 (transformation);
					}
					_g_object_unref0 (_transformation_it);
				}
				_tmp24_ = pixel_transformation_bundle_copy (new_adjustments);
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = _tmp24_;
			}
			_tmp25_ = map;
			committed = photo_set_transformation (self, _tmp25_);
		}
		__finally1:
		{
			PhotoRow* _tmp26_;
			_tmp26_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_key_value_map_unref0 (map);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (committed) {
		Alteration* _tmp27_;
		Alteration* _tmp28_;
		_tmp27_ = alteration_new ("image", "color-adjustments");
		_tmp28_ = _tmp27_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp28_);
		_alteration_unref0 (_tmp28_);
	}
	_key_value_map_unref0 (map);
}

static PhotoMetadata*
photo_real_get_metadata (PhotoSource* base)
{
	Photo * self;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	{
		PhotoMetadata* _tmp0_ = NULL;
		PhotoFileReader* _tmp1_;
		PhotoFileReader* _tmp2_;
		PhotoMetadata* _tmp3_;
		PhotoMetadata* _tmp4_;
		PhotoMetadata* _tmp5_;
		_tmp1_ = photo_get_source_reader (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error0_);
		_tmp4_ = _tmp3_;
		_photo_file_adapter_unref0 (_tmp2_);
		_tmp0_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp0_;
		_tmp0_ = NULL;
		result = _tmp5_;
		_media_metadata_unref0 (_tmp0_);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = err;
		_tmp7_ = _tmp6_->message;
		g_warning ("Photo.vala:2692: Unable to load metadata: %s", _tmp7_);
		result = NULL;
		_g_error_free0 (err);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

PhotoMetadata*
photo_get_master_metadata (Photo* self,
                           GError** error)
{
	PhotoMetadata* _tmp0_ = NULL;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp4_;
	PhotoMetadata* _tmp5_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp1_ = photo_get_master_reader (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_file_reader_read_metadata (_tmp2_, &_inner_error0_);
	_tmp4_ = _tmp3_;
	_photo_file_adapter_unref0 (_tmp2_);
	_tmp0_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp5_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp5_;
	_media_metadata_unref0 (_tmp0_);
	return result;
}

PhotoMetadata*
photo_get_editable_metadata (Photo* self,
                             GError** error)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoMetadata* _tmp1_ = NULL;
	PhotoFileReader* _tmp2_;
	GError* _inner_error0_ = NULL;
	PhotoMetadata* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp2_ = reader;
	if (_tmp2_ != NULL) {
		PhotoFileReader* _tmp3_;
		PhotoMetadata* _tmp4_;
		_tmp3_ = reader;
		_tmp4_ = photo_file_reader_read_metadata (_tmp3_, &_inner_error0_);
		_media_metadata_unref0 (_tmp1_);
		_tmp1_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_media_metadata_unref0 (_tmp1_);
			_photo_file_adapter_unref0 (reader);
			return NULL;
		}
	} else {
		_media_metadata_unref0 (_tmp1_);
		_tmp1_ = NULL;
	}
	result = _tmp1_;
	_photo_file_adapter_unref0 (reader);
	return result;
}

gboolean
photo_persist_master_metadata (Photo* self,
                               PhotoMetadata* metadata,
                               PhotoReimportMasterState** state,
                               GError** error)
{
	PhotoReimportMasterState* _vala_state = NULL;
	PhotoFileReader* master_reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileMetadataWriter* _tmp2_ = NULL;
	PhotoFileReader* _tmp3_;
	PhotoFileMetadataWriter* _tmp4_;
	gboolean _tmp7_ = FALSE;
	PhotoReimportMasterState* _tmp8_ = NULL;
	gboolean _tmp9_;
	PhotoReimportMasterState* _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
	_photo_reimport_master_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_master_reader (self);
	master_reader = _tmp0_;
	_tmp1_ = master_reader;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
		result = FALSE;
		_photo_file_adapter_unref0 (master_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp3_ = master_reader;
	_tmp4_ = photo_file_reader_create_metadata_writer (_tmp3_, &_inner_error0_);
	_tmp2_ = _tmp4_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (master_reader);
		_photo_reimport_master_state_unref0 (_vala_state);
		return _tmp5_;
	}
	photo_file_metadata_writer_write_metadata (_tmp2_, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp2_);
		_photo_file_adapter_unref0 (master_reader);
		_photo_reimport_master_state_unref0 (_vala_state);
		return _tmp6_;
	}
	_tmp9_ = photo_prepare_for_reimport_master (self, &_tmp8_, &_inner_error0_);
	_photo_reimport_master_state_unref0 (_vala_state);
	_vala_state = _tmp8_;
	_tmp7_ = _tmp9_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp10_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp2_);
		_photo_file_adapter_unref0 (master_reader);
		_photo_reimport_master_state_unref0 (_vala_state);
		return _tmp10_;
	}
	if (!_tmp7_) {
		result = FALSE;
		_photo_file_adapter_unref0 (_tmp2_);
		_photo_file_adapter_unref0 (master_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_master_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp11_ = _vala_state;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl)->metadata_only = TRUE;
	result = TRUE;
	_photo_file_adapter_unref0 (_tmp2_);
	_photo_file_adapter_unref0 (master_reader);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_master_state_unref0 (_vala_state);
	}
	return result;
}

void
photo_finish_update_master_metadata (Photo* self,
                                     PhotoReimportMasterState* state,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (PHOTO_IS_REIMPORT_MASTER_STATE (state));
	photo_finish_reimport_master (self, state, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
photo_persist_editable_metadata (Photo* self,
                                 PhotoMetadata* metadata,
                                 PhotoReimportEditableState** state,
                                 GError** error)
{
	PhotoReimportEditableState* _vala_state = NULL;
	PhotoFileReader* editable_reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileMetadataWriter* _tmp3_ = NULL;
	PhotoFileReader* _tmp4_;
	PhotoFileMetadataWriter* _tmp5_;
	gboolean _tmp8_ = FALSE;
	PhotoReimportEditableState* _tmp9_ = NULL;
	gboolean _tmp10_;
	PhotoReimportEditableState* _tmp12_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (IS_PHOTO_METADATA (metadata), FALSE);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = NULL;
	_tmp0_ = photo_get_editable_reader (self);
	editable_reader = _tmp0_;
	_tmp1_ = editable_reader;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_photo_file_adapter_unref0 (editable_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp2_ = editable_reader;
	if (!photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
		result = FALSE;
		_photo_file_adapter_unref0 (editable_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp4_ = editable_reader;
	_tmp5_ = photo_file_reader_create_metadata_writer (_tmp4_, &_inner_error0_);
	_tmp3_ = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (editable_reader);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp6_;
	}
	photo_file_metadata_writer_write_metadata (_tmp3_, metadata, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp3_);
		_photo_file_adapter_unref0 (editable_reader);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp7_;
	}
	_tmp10_ = photo_prepare_for_reimport_editable (self, &_tmp9_, &_inner_error0_);
	_photo_reimport_editable_state_unref0 (_vala_state);
	_vala_state = _tmp9_;
	_tmp8_ = _tmp10_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp3_);
		_photo_file_adapter_unref0 (editable_reader);
		_photo_reimport_editable_state_unref0 (_vala_state);
		return _tmp11_;
	}
	if (!_tmp8_) {
		result = FALSE;
		_photo_file_adapter_unref0 (_tmp3_);
		_photo_file_adapter_unref0 (editable_reader);
		if (state) {
			*state = _vala_state;
		} else {
			_photo_reimport_editable_state_unref0 (_vala_state);
		}
		return result;
	}
	_tmp12_ = _vala_state;
	G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl)->metadata_only = TRUE;
	result = TRUE;
	_photo_file_adapter_unref0 (_tmp3_);
	_photo_file_adapter_unref0 (editable_reader);
	if (state) {
		*state = _vala_state;
	} else {
		_photo_reimport_editable_state_unref0 (_vala_state);
	}
	return result;
}

void
photo_finish_update_editable_metadata (Photo* self,
                                       PhotoReimportEditableState* state,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (PHOTO_IS_REIMPORT_EDITABLE_STATE (state));
	photo_finish_reimport_editable (self, state, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_get_raw_dimensions (Photo* self,
                          Dimensions* result)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			Dimensions _tmp2_;
			_tmp1_ = self->backing_photo_row;
			_tmp2_ = _tmp1_->dim;
			*result = _tmp2_;
			{
				PhotoRow* _tmp3_;
				_tmp3_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return;
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
photo_has_transformations (Photo* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp8_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			BackingPhotoRow* _tmp3_;
			_tmp2_ = self->row;
			_tmp3_ = self->backing_photo_row;
			if (_tmp2_->orientation != _tmp3_->original_orientation) {
				_tmp1_ = TRUE;
			} else {
				PhotoRow* _tmp4_;
				GeeHashMap* _tmp5_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->transformations;
				_tmp1_ = _tmp5_ != NULL;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
}

gboolean
photo_only_metadata_changed (Photo* self)
{
	MetadataDateTime* date_time = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	date_time = NULL;
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
	metadata = _tmp0_;
	_tmp1_ = metadata;
	if (_tmp1_ != NULL) {
		PhotoMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
		_tmp2_ = metadata;
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
		_metadata_date_time_unref0 (date_time);
		date_time = _tmp3_;
	}
	{
		PhotoRow* _tmp4_;
		gboolean _tmp23_ = FALSE;
		_tmp4_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp5_ = FALSE;
			PhotoRow* _tmp6_;
			GeeHashMap* _tmp7_;
			_tmp6_ = self->row;
			_tmp7_ = _tmp6_->transformations;
			if (_tmp7_ == NULL) {
				gboolean _tmp8_ = FALSE;
				PhotoRow* _tmp9_;
				BackingPhotoRow* _tmp10_;
				_tmp9_ = self->row;
				_tmp10_ = self->backing_photo_row;
				if (_tmp9_->orientation != _tmp10_->original_orientation) {
					_tmp8_ = TRUE;
				} else {
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					MetadataDateTime* _tmp13_;
					_tmp13_ = date_time;
					if (_tmp13_ != NULL) {
						PhotoRow* _tmp14_;
						GDateTime* _tmp15_;
						_tmp14_ = self->row;
						_tmp15_ = _tmp14_->exposure_time;
						_tmp12_ = _tmp15_ != NULL;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						PhotoRow* _tmp16_;
						GDateTime* _tmp17_;
						MetadataDateTime* _tmp18_;
						GDateTime* _tmp19_;
						GDateTime* _tmp20_;
						_tmp16_ = self->row;
						_tmp17_ = _tmp16_->exposure_time;
						_tmp18_ = date_time;
						_tmp19_ = metadata_date_time_get_timestamp (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp11_ = !g_date_time_equal (_tmp17_, _tmp20_);
						_g_date_time_unref0 (_tmp20_);
					} else {
						_tmp11_ = FALSE;
					}
					_tmp8_ = _tmp11_;
				}
				_tmp5_ = _tmp8_;
			} else {
				_tmp5_ = FALSE;
			}
			result = _tmp5_;
			{
				PhotoRow* _tmp21_;
				_tmp21_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			_media_metadata_unref0 (metadata);
			_metadata_date_time_unref0 (date_time);
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp22_;
			_tmp22_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		_media_metadata_unref0 (metadata);
		_metadata_date_time_unref0 (date_time);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp23_;
	}
}

gboolean
photo_has_alterations (Photo* self)
{
	MetadataDateTime* date_time = NULL;
	gchar* title = NULL;
	gchar* comment = NULL;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	MetadataDateTime* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	date_time = NULL;
	title = NULL;
	comment = NULL;
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
	metadata = _tmp0_;
	_tmp1_ = metadata;
	if (_tmp1_ != NULL) {
		PhotoMetadata* _tmp2_;
		MetadataDateTime* _tmp3_;
		PhotoMetadata* _tmp4_;
		gchar* _tmp5_;
		PhotoMetadata* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = metadata;
		_tmp3_ = photo_metadata_get_exposure_date_time (_tmp2_);
		_metadata_date_time_unref0 (date_time);
		date_time = _tmp3_;
		_tmp4_ = metadata;
		_tmp5_ = media_metadata_get_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MEDIA_METADATA, MediaMetadata));
		_g_free0 (title);
		title = _tmp5_;
		_tmp6_ = metadata;
		_tmp7_ = media_metadata_get_comment (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_MEDIA_METADATA, MediaMetadata));
		_g_free0 (comment);
		comment = _tmp7_;
	}
	_tmp8_ = date_time;
	if (_tmp8_ == NULL) {
		{
			PhotoRow* _tmp9_;
			_tmp9_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				BackingPhotoRow* _tmp10_;
				GDateTime* _tmp11_;
				PhotoRow* _tmp12_;
				GDateTime* _tmp13_;
				_tmp10_ = self->backing_photo_row;
				_tmp11_ = _tmp10_->timestamp;
				_tmp12_ = self->row;
				_tmp13_ = _tmp12_->exposure_time;
				if (nullsafe_date_time_comperator (_tmp11_, _tmp13_) != ((gint64) 0)) {
					result = TRUE;
					{
						PhotoRow* _tmp14_;
						_tmp14_ = self->row;
						g_rec_mutex_unlock (&self->priv->__lock_row);
					}
					_media_metadata_unref0 (metadata);
					_g_free0 (comment);
					_g_free0 (title);
					_metadata_date_time_unref0 (date_time);
					return result;
				}
			}
			__finally0:
			{
				PhotoRow* _tmp15_;
				_tmp15_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp16_ = FALSE;
				_media_metadata_unref0 (metadata);
				_g_free0 (comment);
				_g_free0 (title);
				_metadata_date_time_unref0 (date_time);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp16_;
			}
		}
	}
	{
		PhotoRow* _tmp17_;
		gboolean _tmp41_ = FALSE;
		_tmp17_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			gboolean _tmp20_ = FALSE;
			gboolean _tmp21_ = FALSE;
			PhotoRow* _tmp22_;
			GeeHashMap* _tmp23_;
			_tmp22_ = self->row;
			_tmp23_ = _tmp22_->transformations;
			if (_tmp23_ != NULL) {
				_tmp21_ = TRUE;
			} else {
				PhotoRow* _tmp24_;
				BackingPhotoRow* _tmp25_;
				_tmp24_ = self->row;
				_tmp25_ = self->backing_photo_row;
				_tmp21_ = _tmp24_->orientation != _tmp25_->original_orientation;
			}
			if (_tmp21_) {
				_tmp20_ = TRUE;
			} else {
				gboolean _tmp26_ = FALSE;
				MetadataDateTime* _tmp27_;
				_tmp27_ = date_time;
				if (_tmp27_ != NULL) {
					PhotoRow* _tmp28_;
					GDateTime* _tmp29_;
					MetadataDateTime* _tmp30_;
					GDateTime* _tmp31_;
					GDateTime* _tmp32_;
					_tmp28_ = self->row;
					_tmp29_ = _tmp28_->exposure_time;
					_tmp30_ = date_time;
					_tmp31_ = metadata_date_time_get_timestamp (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp26_ = nullsafe_date_time_comperator (_tmp29_, _tmp32_) != ((gint64) 0);
					_g_date_time_unref0 (_tmp32_);
				} else {
					_tmp26_ = FALSE;
				}
				_tmp20_ = _tmp26_;
			}
			if (_tmp20_) {
				_tmp19_ = TRUE;
			} else {
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp33_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
				_tmp34_ = _tmp33_;
				_tmp35_ = comment;
				_tmp19_ = g_strcmp0 (_tmp34_, _tmp35_) != 0;
				_g_free0 (_tmp34_);
			}
			if (_tmp19_) {
				_tmp18_ = TRUE;
			} else {
				gchar* _tmp36_;
				gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
				_tmp37_ = _tmp36_;
				_tmp38_ = title;
				_tmp18_ = g_strcmp0 (_tmp37_, _tmp38_) != 0;
				_g_free0 (_tmp37_);
			}
			result = _tmp18_;
			{
				PhotoRow* _tmp39_;
				_tmp39_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			_media_metadata_unref0 (metadata);
			_g_free0 (comment);
			_g_free0 (title);
			_metadata_date_time_unref0 (date_time);
			return result;
		}
		__finally1:
		{
			PhotoRow* _tmp40_;
			_tmp40_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		_media_metadata_unref0 (metadata);
		_g_free0 (comment);
		_g_free0 (title);
		_metadata_date_time_unref0 (date_time);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp41_;
	}
}

PhotoTransformationState*
photo_save_transformation_state (Photo* self)
{
	GError* _inner_error0_ = NULL;
	PhotoTransformationState* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformer* _tmp1_ = NULL;
			PixelTransformer* _tmp2_;
			PixelTransformationBundle* _tmp5_ = NULL;
			PixelTransformationBundle* _tmp6_;
			PhotoRow* _tmp9_;
			PhotoRow* _tmp10_;
			GeeHashMap* _tmp11_;
			PhotoPhotoTransformationStateImpl* _tmp12_;
			_tmp2_ = self->priv->transformer;
			if (_tmp2_ != NULL) {
				PixelTransformer* _tmp3_;
				PixelTransformer* _tmp4_;
				_tmp3_ = self->priv->transformer;
				_tmp4_ = pixel_transformer_copy (_tmp3_);
				_pixel_transformer_unref0 (_tmp1_);
				_tmp1_ = _tmp4_;
			} else {
				_pixel_transformer_unref0 (_tmp1_);
				_tmp1_ = NULL;
			}
			_tmp6_ = self->priv->adjustments;
			if (_tmp6_ != NULL) {
				PixelTransformationBundle* _tmp7_;
				PixelTransformationBundle* _tmp8_;
				_tmp7_ = self->priv->adjustments;
				_tmp8_ = pixel_transformation_bundle_copy (_tmp7_);
				_pixel_transformation_bundle_unref0 (_tmp5_);
				_tmp5_ = _tmp8_;
			} else {
				_pixel_transformation_bundle_unref0 (_tmp5_);
				_tmp5_ = NULL;
			}
			_tmp9_ = self->row;
			_tmp10_ = self->row;
			_tmp11_ = _tmp10_->transformations;
			_tmp12_ = photo_photo_transformation_state_impl_new (self, _tmp9_->orientation, _tmp11_, _tmp1_, _tmp5_);
			result = G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState);
			_pixel_transformation_bundle_unref0 (_tmp5_);
			_pixel_transformer_unref0 (_tmp1_);
			{
				PhotoRow* _tmp13_;
				_tmp13_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}

static gpointer
_pixel_transformer_ref0 (gpointer self)
{
	return self ? pixel_transformer_ref (self) : NULL;
}

static gpointer
_pixel_transformation_bundle_ref0 (gpointer self)
{
	return self ? pixel_transformation_bundle_ref (self) : NULL;
}

gboolean
photo_load_transformation_state (Photo* self,
                                 PhotoTransformationState* state)
{
	PhotoPhotoTransformationStateImpl* state_impl = NULL;
	PhotoPhotoTransformationStateImpl* _tmp0_;
	PhotoPhotoTransformationStateImpl* _tmp1_;
	Orientation saved_orientation = 0;
	PhotoPhotoTransformationStateImpl* _tmp2_;
	GeeHashMap* saved_transformations = NULL;
	PhotoPhotoTransformationStateImpl* _tmp3_;
	GeeHashMap* _tmp4_;
	PixelTransformer* saved_transformer = NULL;
	PhotoPhotoTransformationStateImpl* _tmp5_;
	PixelTransformer* _tmp6_;
	PixelTransformationBundle* saved_adjustments = NULL;
	PhotoPhotoTransformationStateImpl* _tmp7_;
	PixelTransformationBundle* _tmp8_;
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (IS_PHOTO_TRANSFORMATION_STATE (state), FALSE);
	_tmp0_ = _g_object_ref0 (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (state) ? ((PhotoPhotoTransformationStateImpl*) state) : NULL);
	state_impl = _tmp0_;
	_tmp1_ = state_impl;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (state_impl);
		return result;
	}
	_tmp2_ = state_impl;
	saved_orientation = photo_photo_transformation_state_impl_get_orientation (_tmp2_);
	_tmp3_ = state_impl;
	_tmp4_ = photo_photo_transformation_state_impl_get_transformations (_tmp3_);
	saved_transformations = _tmp4_;
	_tmp5_ = state_impl;
	_tmp6_ = photo_photo_transformation_state_impl_get_transformer (_tmp5_);
	saved_transformer = _tmp6_;
	_tmp7_ = state_impl;
	_tmp8_ = photo_photo_transformation_state_impl_get_color_adjustments (_tmp7_);
	saved_adjustments = _tmp8_;
	{
		PhotoRow* _tmp9_;
		_tmp9_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp10_;
			PhotoTable* _tmp11_;
			PhotoRow* _tmp12_;
			PhotoID _tmp13_;
			GeeHashMap* _tmp14_;
			_tmp10_ = photo_table_get_instance ();
			_tmp11_ = _tmp10_;
			_tmp12_ = self->row;
			_tmp13_ = _tmp12_->photo_id;
			_tmp14_ = saved_transformations;
			committed = photo_table_set_transformation_state (_tmp11_, &_tmp13_, saved_orientation, _tmp14_);
			_database_table_unref0 (_tmp11_);
			if (committed) {
				PhotoRow* _tmp15_;
				PhotoRow* _tmp16_;
				GeeHashMap* _tmp17_;
				GeeHashMap* _tmp18_;
				PixelTransformer* _tmp19_;
				PixelTransformer* _tmp20_;
				PixelTransformationBundle* _tmp21_;
				PixelTransformationBundle* _tmp22_;
				_tmp15_ = self->row;
				_tmp15_->orientation = saved_orientation;
				_tmp16_ = self->row;
				_tmp17_ = saved_transformations;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (_tmp16_->transformations);
				_tmp16_->transformations = _tmp18_;
				_tmp19_ = saved_transformer;
				_tmp20_ = _pixel_transformer_ref0 (_tmp19_);
				_pixel_transformer_unref0 (self->priv->transformer);
				self->priv->transformer = _tmp20_;
				_tmp21_ = saved_adjustments;
				_tmp22_ = _pixel_transformation_bundle_ref0 (_tmp21_);
				_pixel_transformation_bundle_unref0 (self->priv->adjustments);
				self->priv->adjustments = _tmp22_;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp23_;
			_tmp23_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp24_ = FALSE;
			_pixel_transformation_bundle_unref0 (saved_adjustments);
			_pixel_transformer_unref0 (saved_transformer);
			_g_object_unref0 (saved_transformations);
			_g_object_unref0 (state_impl);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp24_;
		}
	}
	if (committed) {
		Alteration* _tmp25_;
		Alteration* _tmp26_;
		_tmp25_ = alteration_new ("image", "transformation-state");
		_tmp26_ = _tmp25_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp26_);
		_alteration_unref0 (_tmp26_);
	}
	result = committed;
	_pixel_transformation_bundle_unref0 (saved_adjustments);
	_pixel_transformer_unref0 (saved_transformer);
	_g_object_unref0 (saved_transformations);
	_g_object_unref0 (state_impl);
	return result;
}

void
photo_remove_all_transformations (Photo* self,
                                  gboolean notify)
{
	gboolean is_altered = FALSE;
	gboolean _tmp16_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	is_altered = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoTable* _tmp1_;
			PhotoTable* _tmp2_;
			PhotoRow* _tmp3_;
			PhotoID _tmp4_;
			PhotoRow* _tmp5_;
			PhotoRow* _tmp6_;
			BackingPhotoRow* _tmp7_;
			_tmp1_ = photo_table_get_instance ();
			_tmp2_ = _tmp1_;
			_tmp3_ = self->row;
			_tmp4_ = _tmp3_->photo_id;
			is_altered = photo_table_remove_all_transformations (_tmp2_, &_tmp4_);
			_database_table_unref0 (_tmp2_);
			_tmp5_ = self->row;
			_g_object_unref0 (_tmp5_->transformations);
			_tmp5_->transformations = NULL;
			_pixel_transformer_unref0 (self->priv->transformer);
			self->priv->transformer = NULL;
			_pixel_transformation_bundle_unref0 (self->priv->adjustments);
			self->priv->adjustments = NULL;
			_tmp6_ = self->row;
			_tmp7_ = self->backing_photo_row;
			if (_tmp6_->orientation != _tmp7_->original_orientation) {
				PhotoTable* _tmp8_;
				PhotoTable* _tmp9_;
				PhotoRow* _tmp10_;
				PhotoID _tmp11_;
				BackingPhotoRow* _tmp12_;
				PhotoRow* _tmp13_;
				BackingPhotoRow* _tmp14_;
				_tmp8_ = photo_table_get_instance ();
				_tmp9_ = _tmp8_;
				_tmp10_ = self->row;
				_tmp11_ = _tmp10_->photo_id;
				_tmp12_ = self->backing_photo_row;
				photo_table_set_orientation (_tmp9_, &_tmp11_, _tmp12_->original_orientation);
				_database_table_unref0 (_tmp9_);
				_tmp13_ = self->row;
				_tmp14_ = self->backing_photo_row;
				_tmp13_->orientation = _tmp14_->original_orientation;
				is_altered = TRUE;
			}
		}
		__finally0:
		{
			PhotoRow* _tmp15_;
			_tmp15_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (is_altered) {
		_tmp16_ = notify;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		Alteration* _tmp17_;
		Alteration* _tmp18_;
		_tmp17_ = alteration_new ("image", "revert");
		_tmp18_ = _tmp17_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
		_alteration_unref0 (_tmp18_);
	}
}

Orientation
photo_get_original_orientation (Photo* self)
{
	GError* _inner_error0_ = NULL;
	Orientation result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			BackingPhotoRow* _tmp1_;
			_tmp1_ = self->backing_photo_row;
			result = _tmp1_->original_orientation;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

Orientation
photo_get_orientation (Photo* self)
{
	GError* _inner_error0_ = NULL;
	Orientation result;
	g_return_val_if_fail (IS_PHOTO (self), 0);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			result = _tmp1_->orientation;
			{
				PhotoRow* _tmp2_;
				_tmp2_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp3_;
			_tmp3_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
}

gboolean
photo_set_orientation (Photo* self,
                       Orientation orientation)
{
	gboolean committed = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	committed = FALSE;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			if (_tmp1_->orientation != orientation) {
				PhotoTable* _tmp2_;
				PhotoTable* _tmp3_;
				PhotoRow* _tmp4_;
				PhotoID _tmp5_;
				_tmp2_ = photo_table_get_instance ();
				_tmp3_ = _tmp2_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->photo_id;
				committed = photo_table_set_orientation (_tmp3_, &_tmp5_, orientation);
				_database_table_unref0 (_tmp3_);
				if (committed) {
					PhotoRow* _tmp6_;
					_tmp6_ = self->row;
					_tmp6_->orientation = orientation;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp8_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp8_;
		}
	}
	if (committed) {
		Alteration* _tmp9_;
		Alteration* _tmp10_;
		_tmp9_ = alteration_new ("image", "orientation");
		_tmp10_ = _tmp9_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp10_);
		_alteration_unref0 (_tmp10_);
	}
	result = committed;
	return result;
}

gboolean
photo_check_can_rotate (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	result = self->can_rotate_now;
	return result;
}

static void
photo_real_rotate (Photo* self,
                   Rotation rotation)
{
	GError* _inner_error0_ = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			photo_set_orientation (self, orientation_perform (photo_get_orientation (self), rotation));
		}
		__finally0:
		{
			PhotoRow* _tmp1_;
			_tmp1_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
photo_rotate (Photo* self,
              Rotation rotation)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->rotate) {
		_klass_->rotate (self, rotation);
	}
}

static gboolean
photo_has_transformation (Photo* self,
                          const gchar* name)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp8_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			gboolean _tmp1_ = FALSE;
			PhotoRow* _tmp2_;
			GeeHashMap* _tmp3_;
			_tmp2_ = self->row;
			_tmp3_ = _tmp2_->transformations;
			if (_tmp3_ != NULL) {
				PhotoRow* _tmp4_;
				GeeHashMap* _tmp5_;
				_tmp4_ = self->row;
				_tmp5_ = _tmp4_->transformations;
				_tmp1_ = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
			} else {
				_tmp1_ = FALSE;
			}
			result = _tmp1_;
			{
				PhotoRow* _tmp6_;
				_tmp6_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp7_;
			_tmp7_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
}

static KeyValueMap*
photo_get_transformation (Photo* self,
                          const gchar* name)
{
	KeyValueMap* map = NULL;
	GError* _inner_error0_ = NULL;
	KeyValueMap* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	map = NULL;
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->transformations;
			if (_tmp2_ != NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				gpointer _tmp5_;
				KeyValueMap* _tmp6_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->transformations;
				_tmp5_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name);
				_key_value_map_unref0 (map);
				map = (KeyValueMap*) _tmp5_;
				_tmp6_ = map;
				if (_tmp6_ != NULL) {
					KeyValueMap* _tmp7_;
					KeyValueMap* _tmp8_;
					_tmp7_ = map;
					_tmp8_ = key_value_map_copy (_tmp7_);
					_key_value_map_unref0 (map);
					map = _tmp8_;
				}
			}
		}
		__finally0:
		{
			PhotoRow* _tmp9_;
			_tmp9_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_key_value_map_unref0 (map);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = map;
	return result;
}

static gboolean
photo_set_transformation (Photo* self,
                          KeyValueMap* trans)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (trans, TYPE_KEY_VALUE_MAP), FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp16_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoRow* _tmp5_;
			GeeHashMap* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			PhotoTable* _tmp9_;
			PhotoTable* _tmp10_;
			PhotoRow* _tmp11_;
			PhotoID _tmp12_;
			gboolean _tmp13_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->transformations;
			if (_tmp2_ == NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				_tmp3_ = self->row;
				_tmp4_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
				_g_object_unref0 (_tmp3_->transformations);
				_tmp3_->transformations = _tmp4_;
			}
			_tmp5_ = self->row;
			_tmp6_ = _tmp5_->transformations;
			_tmp7_ = key_value_map_get_group (trans);
			_tmp8_ = _tmp7_;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp8_, trans);
			_g_free0 (_tmp8_);
			_tmp9_ = photo_table_get_instance ();
			_tmp10_ = _tmp9_;
			_tmp11_ = self->row;
			_tmp12_ = _tmp11_->photo_id;
			_tmp13_ = photo_table_set_transformation (_tmp10_, &_tmp12_, trans);
			_database_table_unref0 (_tmp10_);
			result = _tmp13_;
			{
				PhotoRow* _tmp14_;
				_tmp14_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp15_;
			_tmp15_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp16_;
	}
}

static gboolean
photo_remove_transformation (Photo* self,
                             const gchar* name)
{
	gboolean altered_cache = FALSE;
	gboolean altered_persistent = FALSE;
	gboolean _tmp16_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PhotoRow* _tmp1_;
			GeeHashMap* _tmp2_;
			PhotoTable* _tmp10_;
			PhotoTable* _tmp11_;
			PhotoRow* _tmp12_;
			PhotoID _tmp13_;
			_tmp1_ = self->row;
			_tmp2_ = _tmp1_->transformations;
			if (_tmp2_ != NULL) {
				PhotoRow* _tmp3_;
				GeeHashMap* _tmp4_;
				PhotoRow* _tmp5_;
				GeeHashMap* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp3_ = self->row;
				_tmp4_ = _tmp3_->transformations;
				altered_cache = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), name, NULL);
				_tmp5_ = self->row;
				_tmp6_ = _tmp5_->transformations;
				_tmp7_ = gee_abstract_map_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
				_tmp8_ = _tmp7_;
				if (_tmp8_ == 0) {
					PhotoRow* _tmp9_;
					_tmp9_ = self->row;
					_g_object_unref0 (_tmp9_->transformations);
					_tmp9_->transformations = NULL;
				}
			} else {
				altered_cache = FALSE;
			}
			_tmp10_ = photo_table_get_instance ();
			_tmp11_ = _tmp10_;
			_tmp12_ = self->row;
			_tmp13_ = _tmp12_->photo_id;
			altered_persistent = photo_table_remove_transformation (_tmp11_, &_tmp13_, name);
			_database_table_unref0 (_tmp11_);
		}
		__finally0:
		{
			PhotoRow* _tmp14_;
			_tmp14_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp15_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp15_;
		}
	}
	if (altered_cache) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = altered_persistent;
	}
	result = _tmp16_;
	return result;
}

gboolean
photo_has_crop (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	result = photo_has_transformation (self, "crop");
	return result;
}

gboolean
photo_get_raw_crop (Photo* self,
                    Box* crop)
{
	Box _vala_crop = {0};
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint left = 0;
	KeyValueMap* _tmp2_;
	gint top = 0;
	KeyValueMap* _tmp3_;
	gint right = 0;
	KeyValueMap* _tmp4_;
	gint bottom = 0;
	KeyValueMap* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	box_init (&_vala_crop, 0, 0, 0, 0);
	_tmp0_ = photo_get_transformation (self, "crop");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_key_value_map_unref0 (map);
		if (crop) {
			*crop = _vala_crop;
		}
		return result;
	}
	_tmp2_ = map;
	left = key_value_map_get_int (_tmp2_, "left", -1);
	_tmp3_ = map;
	top = key_value_map_get_int (_tmp3_, "top", -1);
	_tmp4_ = map;
	right = key_value_map_get_int (_tmp4_, "right", -1);
	_tmp5_ = map;
	bottom = key_value_map_get_int (_tmp5_, "bottom", -1);
	if (left == -1) {
		_tmp8_ = TRUE;
	} else {
		_tmp8_ = top == -1;
	}
	if (_tmp8_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = right == -1;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = bottom == -1;
	}
	if (_tmp6_) {
		result = FALSE;
		_key_value_map_unref0 (map);
		if (crop) {
			*crop = _vala_crop;
		}
		return result;
	}
	box_init (&_vala_crop, left, top, right, bottom);
	result = TRUE;
	_key_value_map_unref0 (map);
	if (crop) {
		*crop = _vala_crop;
	}
	return result;
}

static void
photo_set_raw_crop (Photo* self,
                    Box* crop)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	Box _tmp2_;
	KeyValueMap* _tmp3_;
	Box _tmp4_;
	KeyValueMap* _tmp5_;
	Box _tmp6_;
	KeyValueMap* _tmp7_;
	Box _tmp8_;
	KeyValueMap* _tmp9_;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (crop != NULL);
	_tmp0_ = key_value_map_new ("crop");
	map = _tmp0_;
	_tmp1_ = map;
	_tmp2_ = *crop;
	key_value_map_set_int (_tmp1_, "left", _tmp2_.left);
	_tmp3_ = map;
	_tmp4_ = *crop;
	key_value_map_set_int (_tmp3_, "top", _tmp4_.top);
	_tmp5_ = map;
	_tmp6_ = *crop;
	key_value_map_set_int (_tmp5_, "right", _tmp6_.right);
	_tmp7_ = map;
	_tmp8_ = *crop;
	key_value_map_set_int (_tmp7_, "bottom", _tmp8_.bottom);
	_tmp9_ = map;
	if (photo_set_transformation (self, _tmp9_)) {
		Alteration* _tmp10_;
		Alteration* _tmp11_;
		_tmp10_ = alteration_new ("image", "crop");
		_tmp11_ = _tmp10_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp11_);
		_alteration_unref0 (_tmp11_);
	}
	_key_value_map_unref0 (map);
}

static gboolean
photo_get_raw_straighten (Photo* self,
                          gdouble* angle)
{
	gdouble _vala_angle = 0.0;
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_tmp0_ = photo_get_transformation (self, "straighten");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		_vala_angle = 0.0;
		result = FALSE;
		_key_value_map_unref0 (map);
		if (angle) {
			*angle = _vala_angle;
		}
		return result;
	}
	_tmp2_ = map;
	_vala_angle = key_value_map_get_double (_tmp2_, "angle", 0.0);
	result = TRUE;
	_key_value_map_unref0 (map);
	if (angle) {
		*angle = _vala_angle;
	}
	return result;
}

static void
photo_set_raw_straighten (Photo* self,
                          gdouble theta)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	KeyValueMap* _tmp2_;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = key_value_map_new ("straighten");
	map = _tmp0_;
	_tmp1_ = map;
	key_value_map_set_double (_tmp1_, "angle", theta);
	_tmp2_ = map;
	if (photo_set_transformation (self, _tmp2_)) {
		Alteration* _tmp3_;
		Alteration* _tmp4_;
		_tmp3_ = alteration_new ("image", "straighten");
		_tmp4_ = _tmp3_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp4_);
		_alteration_unref0 (_tmp4_);
	}
	_key_value_map_unref0 (map);
}

static EditingToolsRedeyeInstance*
photo_get_raw_redeye_instances (Photo* self,
                                gint* result_length1)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint num_points = 0;
	KeyValueMap* _tmp4_;
	EditingToolsRedeyeInstance* res = NULL;
	EditingToolsRedeyeInstance* _tmp5_;
	gint res_length1;
	gint _res_size_;
	GdkPoint default_point = {0};
	GdkPoint _tmp6_ = {0};
	EditingToolsRedeyeInstance* _tmp29_;
	gint _tmp29__length1;
	EditingToolsRedeyeInstance* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp0_ = photo_get_transformation (self, "redeye");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		EditingToolsRedeyeInstance* _tmp2_;
		EditingToolsRedeyeInstance* _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_new0 (EditingToolsRedeyeInstance, 0);
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		_key_value_map_unref0 (map);
		return result;
	}
	_tmp4_ = map;
	num_points = key_value_map_get_int (_tmp4_, "num_points", -1);
	_vala_assert (num_points > 0, "num_points > 0");
	_tmp5_ = g_new0 (EditingToolsRedeyeInstance, num_points);
	res = _tmp5_;
	res_length1 = num_points;
	_res_size_ = res_length1;
	_tmp6_.x = 0;
	default_point = _tmp6_;
	default_point.x = -1;
	default_point.y = -1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				gchar* center_key = NULL;
				gchar* _tmp9_;
				gchar* radius_key = NULL;
				gchar* _tmp10_;
				EditingToolsRedeyeInstance* _tmp11_;
				gint _tmp11__length1;
				KeyValueMap* _tmp12_;
				const gchar* _tmp13_;
				GdkPoint _tmp14_;
				GdkPoint _tmp15_ = {0};
				EditingToolsRedeyeInstance* _tmp16_;
				gint _tmp16__length1;
				EditingToolsRedeyeInstance _tmp17_;
				GdkPoint _tmp18_;
				GdkPoint _tmp19_;
				EditingToolsRedeyeInstance* _tmp20_;
				gint _tmp20__length1;
				EditingToolsRedeyeInstance _tmp21_;
				GdkPoint _tmp22_;
				GdkPoint _tmp23_;
				EditingToolsRedeyeInstance* _tmp24_;
				gint _tmp24__length1;
				KeyValueMap* _tmp25_;
				const gchar* _tmp26_;
				EditingToolsRedeyeInstance* _tmp27_;
				gint _tmp27__length1;
				EditingToolsRedeyeInstance _tmp28_;
				if (!_tmp7_) {
					gint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < num_points)) {
					break;
				}
				_tmp9_ = g_strdup_printf ("center%d", i);
				center_key = _tmp9_;
				_tmp10_ = g_strdup_printf ("radius%d", i);
				radius_key = _tmp10_;
				_tmp11_ = res;
				_tmp11__length1 = res_length1;
				_tmp12_ = map;
				_tmp13_ = center_key;
				_tmp14_ = default_point;
				key_value_map_get_point (_tmp12_, _tmp13_, &_tmp14_, &_tmp15_);
				_tmp11_[i].center = _tmp15_;
				_tmp16_ = res;
				_tmp16__length1 = res_length1;
				_tmp17_ = _tmp16_[i];
				_tmp18_ = _tmp17_.center;
				_tmp19_ = default_point;
				_vala_assert (_tmp18_.x != _tmp19_.x, "res[i].center.x != default_point.x");
				_tmp20_ = res;
				_tmp20__length1 = res_length1;
				_tmp21_ = _tmp20_[i];
				_tmp22_ = _tmp21_.center;
				_tmp23_ = default_point;
				_vala_assert (_tmp22_.y != _tmp23_.y, "res[i].center.y != default_point.y");
				_tmp24_ = res;
				_tmp24__length1 = res_length1;
				_tmp25_ = map;
				_tmp26_ = radius_key;
				_tmp24_[i].radius = key_value_map_get_int (_tmp25_, _tmp26_, -1);
				_tmp27_ = res;
				_tmp27__length1 = res_length1;
				_tmp28_ = _tmp27_[i];
				_vala_assert (_tmp28_.radius != -1, "res[i].radius != -1");
				_g_free0 (radius_key);
				_g_free0 (center_key);
			}
		}
	}
	_tmp29_ = res;
	_tmp29__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp29__length1;
	}
	result = _tmp29_;
	_key_value_map_unref0 (map);
	return result;
}

gboolean
photo_has_redeye_transformations (Photo* self)
{
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	result = photo_has_transformation (self, "redeye");
	return result;
}

void
photo_add_redeye_instance (Photo* self,
                           EditingToolsRedeyeInstance* redeye)
{
	KeyValueMap* map = NULL;
	KeyValueMap* _tmp0_;
	KeyValueMap* _tmp1_;
	gint num_points = 0;
	KeyValueMap* _tmp4_;
	gint _tmp5_;
	gchar* radius_key = NULL;
	gchar* _tmp6_;
	gchar* center_key = NULL;
	gchar* _tmp7_;
	KeyValueMap* _tmp8_;
	const gchar* _tmp9_;
	EditingToolsRedeyeInstance _tmp10_;
	KeyValueMap* _tmp11_;
	const gchar* _tmp12_;
	EditingToolsRedeyeInstance _tmp13_;
	GdkPoint _tmp14_;
	KeyValueMap* _tmp15_;
	KeyValueMap* _tmp16_;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (redeye != NULL);
	_tmp0_ = photo_get_transformation (self, "redeye");
	map = _tmp0_;
	_tmp1_ = map;
	if (_tmp1_ == NULL) {
		KeyValueMap* _tmp2_;
		KeyValueMap* _tmp3_;
		_tmp2_ = key_value_map_new ("redeye");
		_key_value_map_unref0 (map);
		map = _tmp2_;
		_tmp3_ = map;
		key_value_map_set_int (_tmp3_, "num_points", 0);
	}
	_tmp4_ = map;
	num_points = key_value_map_get_int (_tmp4_, "num_points", -1);
	_vala_assert (num_points >= 0, "num_points >= 0");
	_tmp5_ = num_points;
	num_points = _tmp5_ + 1;
	_tmp6_ = g_strdup_printf ("radius%d", num_points - 1);
	radius_key = _tmp6_;
	_tmp7_ = g_strdup_printf ("center%d", num_points - 1);
	center_key = _tmp7_;
	_tmp8_ = map;
	_tmp9_ = radius_key;
	_tmp10_ = *redeye;
	key_value_map_set_int (_tmp8_, _tmp9_, _tmp10_.radius);
	_tmp11_ = map;
	_tmp12_ = center_key;
	_tmp13_ = *redeye;
	_tmp14_ = _tmp13_.center;
	key_value_map_set_point (_tmp11_, _tmp12_, &_tmp14_);
	_tmp15_ = map;
	key_value_map_set_int (_tmp15_, "num_points", num_points);
	_tmp16_ = map;
	if (photo_set_transformation (self, _tmp16_)) {
		Alteration* _tmp17_;
		Alteration* _tmp18_;
		_tmp17_ = alteration_new ("image", "redeye");
		_tmp18_ = _tmp17_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp18_);
		_alteration_unref0 (_tmp18_);
	}
	_g_free0 (center_key);
	_g_free0 (radius_key);
	_key_value_map_unref0 (map);
}

static gboolean
photo_calculate_pixbuf_dimensions (Photo* self,
                                   Scaling* scaling,
                                   PhotoException exceptions,
                                   Dimensions* scaled_image,
                                   Dimensions* scaled_to_viewport)
{
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	{
		PhotoRow* _tmp0_;
		gboolean _tmp7_ = FALSE;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			Scaling _tmp1_;
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			gboolean _tmp4_;
			_tmp1_ = *scaling;
			_tmp4_ = photo_locked_calculate_pixbuf_dimensions (self, &_tmp1_, exceptions, &_tmp2_, &_tmp3_);
			_vala_scaled_image = _tmp2_;
			_vala_scaled_to_viewport = _tmp3_;
			result = _tmp4_;
			{
				PhotoRow* _tmp5_;
				_tmp5_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (scaled_image) {
				*scaled_image = _vala_scaled_image;
			}
			if (scaled_to_viewport) {
				*scaled_to_viewport = _vala_scaled_to_viewport;
			}
			return result;
		}
		__finally0:
		{
			PhotoRow* _tmp6_;
			_tmp6_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
}

static gboolean
photo_locked_calculate_pixbuf_dimensions (Photo* self,
                                          Scaling* scaling,
                                          PhotoException exceptions,
                                          Dimensions* scaled_image,
                                          Dimensions* scaled_to_viewport)
{
	Dimensions _vala_scaled_image = {0};
	Dimensions _vala_scaled_to_viewport = {0};
	Dimensions raw = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	gboolean _tmp31_ = FALSE;
	Dimensions _tmp32_;
	Dimensions _tmp33_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	photo_get_raw_dimensions (self, &_tmp0_);
	raw = _tmp0_;
	if (scaling_is_unscaled (scaling)) {
		Dimensions _tmp1_;
		Dimensions _tmp2_;
		_tmp1_ = raw;
		_vala_scaled_image = _tmp1_;
		_tmp2_ = raw;
		_vala_scaled_to_viewport = _tmp2_;
		result = FALSE;
		if (scaled_image) {
			*scaled_image = _vala_scaled_image;
		}
		if (scaled_to_viewport) {
			*scaled_to_viewport = _vala_scaled_to_viewport;
		}
		return result;
	}
	orientation = photo_get_orientation (self);
	dimensions_init (&_vala_scaled_image, 0, 0);
	dimensions_init (&_vala_scaled_to_viewport, 0, 0);
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_CROP)) {
		Box crop = {0};
		Box _tmp3_ = {0};
		gboolean _tmp4_;
		_tmp4_ = photo_get_raw_crop (self, &_tmp3_);
		crop = _tmp3_;
		if (_tmp4_) {
			Dimensions rotated_raw = {0};
			Dimensions _tmp5_;
			Box scaled_crop = {0};
			Dimensions _tmp11_ = {0};
			Dimensions _tmp12_ = {0};
			Box _tmp13_ = {0};
			Dimensions _tmp14_ = {0};
			gboolean _tmp15_ = FALSE;
			Dimensions _tmp18_ = {0};
			Dimensions _tmp19_ = {0};
			Dimensions _tmp20_ = {0};
			_tmp5_ = raw;
			rotated_raw = _tmp5_;
			if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
				Dimensions _tmp6_;
				Box _tmp7_;
				Box _tmp8_ = {0};
				Dimensions _tmp9_;
				Dimensions _tmp10_ = {0};
				_tmp6_ = raw;
				_tmp7_ = crop;
				orientation_rotate_box (orientation, &_tmp6_, &_tmp7_, &_tmp8_);
				crop = _tmp8_;
				_tmp9_ = raw;
				orientation_rotate_dimensions (orientation, &_tmp9_, &_tmp10_);
				rotated_raw = _tmp10_;
			}
			box_get_dimensions (&crop, &_tmp11_);
			scaling_get_scaled_dimensions (scaling, &_tmp11_, &_tmp12_);
			box_get_scaled (&crop, &_tmp12_, &_tmp13_);
			scaled_crop = _tmp13_;
			box_get_dimensions (&scaled_crop, &_tmp14_);
			_vala_scaled_to_viewport = _tmp14_;
			if (box_get_width (&crop) <= box_get_width (&scaled_crop)) {
				_tmp15_ = box_get_height (&crop) <= box_get_height (&scaled_crop);
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				Dimensions _tmp16_;
				Dimensions _tmp17_ = {0};
				_tmp16_ = raw;
				_vala_scaled_image = _tmp16_;
				box_get_dimensions (&crop, &_tmp17_);
				_vala_scaled_to_viewport = _tmp17_;
				result = FALSE;
				if (scaled_image) {
					*scaled_image = _vala_scaled_image;
				}
				if (scaled_to_viewport) {
					*scaled_to_viewport = _vala_scaled_to_viewport;
				}
				return result;
			}
			box_get_dimensions (&crop, &_tmp18_);
			box_get_dimensions (&scaled_crop, &_tmp19_);
			dimensions_get_scaled_similar (&rotated_raw, &_tmp18_, &_tmp19_, &_tmp20_);
			_vala_scaled_image = _tmp20_;
			if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
				Dimensions _tmp21_;
				Dimensions _tmp22_ = {0};
				_tmp21_ = _vala_scaled_image;
				orientation_derotate_dimensions (orientation, &_tmp21_, &_tmp22_);
				_vala_scaled_image = _tmp22_;
			}
		}
	}
	if (!dimensions_has_area (&_vala_scaled_image)) {
		Dimensions rotated_raw = {0};
		Dimensions _tmp23_;
		Dimensions _tmp26_;
		Dimensions _tmp27_ = {0};
		Dimensions _tmp28_;
		_tmp23_ = raw;
		rotated_raw = _tmp23_;
		if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
			Dimensions _tmp24_;
			Dimensions _tmp25_ = {0};
			_tmp24_ = raw;
			orientation_rotate_dimensions (orientation, &_tmp24_, &_tmp25_);
			rotated_raw = _tmp25_;
		}
		_tmp26_ = rotated_raw;
		scaling_get_scaled_dimensions (scaling, &_tmp26_, &_tmp27_);
		_vala_scaled_image = _tmp27_;
		_tmp28_ = _vala_scaled_image;
		_vala_scaled_to_viewport = _tmp28_;
		if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
			Dimensions _tmp29_;
			Dimensions _tmp30_ = {0};
			_tmp29_ = _vala_scaled_image;
			orientation_derotate_dimensions (orientation, &_tmp29_, &_tmp30_);
			_vala_scaled_image = _tmp30_;
		}
	}
	_tmp32_ = _vala_scaled_image;
	_tmp33_ = raw;
	if (_tmp32_.width >= _tmp33_.width) {
		Dimensions _tmp34_;
		Dimensions _tmp35_;
		_tmp34_ = _vala_scaled_image;
		_tmp35_ = raw;
		_tmp31_ = _tmp34_.height >= _tmp35_.height;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		Dimensions _tmp36_;
		_tmp36_ = raw;
		_vala_scaled_image = _tmp36_;
		result = FALSE;
		if (scaled_image) {
			*scaled_image = _vala_scaled_image;
		}
		if (scaled_to_viewport) {
			*scaled_to_viewport = _vala_scaled_to_viewport;
		}
		return result;
	}
	_vala_assert (dimensions_has_area (&_vala_scaled_image), "scaled_image.has_area()");
	_vala_assert (dimensions_has_area (&_vala_scaled_to_viewport), "scaled_to_viewport.has_area()");
	result = TRUE;
	if (scaled_image) {
		*scaled_image = _vala_scaled_image;
	}
	if (scaled_to_viewport) {
		*scaled_to_viewport = _vala_scaled_to_viewport;
	}
	return result;
}

static GdkPixbuf*
photo_load_raw_pixbuf (Photo* self,
                       Scaling* scaling,
                       PhotoException exceptions,
                       BackingFetchMode fetch_mode,
                       GError** error)
{
	PhotoFileReader* loader = NULL;
	PhotoFileReader* _tmp0_;
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	gboolean is_scaled = FALSE;
	Scaling _tmp5_;
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	gboolean _tmp8_;
	GdkPixbuf* pixbuf = NULL;
	PhotoFileReader* _tmp13_;
	Dimensions _tmp14_ = {0};
	Dimensions _tmp15_;
	GdkPixbuf* _tmp16_;
	GdkPixbuf* _tmp17_;
	Dimensions _tmp18_ = {0};
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = photo_get_backing_reader (self, fetch_mode);
	loader = _tmp0_;
	if (scaling_is_unscaled (scaling)) {
		GdkPixbuf* _tmp1_ = NULL;
		PhotoFileReader* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp2_ = loader;
		_tmp3_ = photo_file_reader_unscaled_read (_tmp2_, &_inner_error0_);
		_tmp1_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (loader);
			return NULL;
		}
		_tmp4_ = _tmp1_;
		_tmp1_ = NULL;
		result = _tmp4_;
		_g_object_unref0 (_tmp1_);
		_photo_file_adapter_unref0 (loader);
		return result;
	}
	_tmp5_ = *scaling;
	_tmp8_ = photo_calculate_pixbuf_dimensions (self, &_tmp5_, exceptions, &_tmp6_, &_tmp7_);
	scaled_image = _tmp6_;
	scaled_to_viewport = _tmp7_;
	is_scaled = _tmp8_;
	if (!is_scaled) {
		GdkPixbuf* _tmp9_ = NULL;
		PhotoFileReader* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkPixbuf* _tmp12_;
		_tmp10_ = loader;
		_tmp11_ = photo_file_reader_unscaled_read (_tmp10_, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (loader);
			return NULL;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		result = _tmp12_;
		_g_object_unref0 (_tmp9_);
		_photo_file_adapter_unref0 (loader);
		return result;
	}
	_tmp13_ = loader;
	photo_get_raw_dimensions (self, &_tmp14_);
	_tmp15_ = scaled_image;
	_tmp16_ = photo_file_reader_scaled_read (_tmp13_, &_tmp14_, &_tmp15_, &_inner_error0_);
	pixbuf = _tmp16_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (loader);
		return NULL;
	}
	_tmp17_ = pixbuf;
	dimensions_for_pixbuf (_tmp17_, &_tmp18_);
	_vala_assert (dimensions_approx_equals (&scaled_image, &_tmp18_, PHOTO_SCALING_FUDGE), "scaled_image.approx_equals(Dimensions.for_pixbuf(pixbuf), SCALING_FUDGE)");
	result = pixbuf;
	_photo_file_adapter_unref0 (loader);
	return result;
}

GdkPixbuf*
photo_get_master_pixbuf (Photo* self,
                         Scaling* scaling,
                         gboolean rotate,
                         GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp1_ = *scaling;
	_tmp2_ = photo_get_untransformed_pixbuf (self, &_tmp1_, rotate, BACKING_FETCH_MODE_MASTER, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

GdkPixbuf*
photo_get_unmodified_pixbuf (Photo* self,
                             Scaling* scaling,
                             gboolean rotate,
                             GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp1_ = *scaling;
	_tmp2_ = photo_get_untransformed_pixbuf (self, &_tmp1_, rotate, BACKING_FETCH_MODE_UNMODIFIED, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static GdkPixbuf*
photo_get_untransformed_pixbuf (Photo* self,
                                Scaling* scaling,
                                gboolean rotate,
                                BackingFetchMode fetch_mode,
                                GError** error)
{
	Dimensions scaled_image = {0};
	Dimensions scaled_to_viewport = {0};
	Orientation original_orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	Scaling _tmp5_;
	GdkPixbuf* _tmp6_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			Scaling _tmp1_;
			Dimensions _tmp2_ = {0};
			Dimensions _tmp3_ = {0};
			_tmp1_ = *scaling;
			photo_calculate_pixbuf_dimensions (self, &_tmp1_, PHOTO_EXCEPTION_NONE, &_tmp2_, &_tmp3_);
			scaled_image = _tmp2_;
			scaled_to_viewport = _tmp3_;
			original_orientation = photo_get_original_orientation (self);
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = *scaling;
	_tmp6_ = photo_load_raw_pixbuf (self, &_tmp5_, PHOTO_EXCEPTION_NONE, fetch_mode, &_inner_error0_);
	pixbuf = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	if (rotate) {
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		_tmp7_ = pixbuf;
		_tmp8_ = orientation_rotate_pixbuf (original_orientation, _tmp7_);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp8_;
	}
	result = pixbuf;
	return result;
}

static GdkPixbuf*
photo_real_get_pixbuf (PhotoSource* base,
                       Scaling* scaling,
                       GError** error)
{
	Photo * self;
	GdkPixbuf* _tmp0_ = NULL;
	Scaling _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_PHOTO, Photo);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp1_ = *scaling;
	_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
	_tmp0_ = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp3_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp3_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * One-stop shopping for the source pixbuf cache.
     *
     * The source pixbuf cache holds untransformed, unscaled (full-sized) pixbufs of Photo objects.
     * These can be rather large and shouldn't be held in memory for too long, nor should many be
     * allowed to stack up.
     *
     * If locate is non-null, a source pixbuf is returned for the Photo.  If keep is true, the
     * pixbuf is stored in the cache.  (Thus, passing a Photo w/ keep == false will drop the cached
     * pixbuf.)  If Photo is non-null but keep is false, null is returned.
     *
     * Whether locate is null or not, the cache is walked in its entirety, dropping expired pixbufs
     * and dropping excessive pixbufs from the LRU.  Locating a Photo "touches" the pixbuf, i.e.
     * it moves to the head of the LRU.
     */
static gpointer
_photo_cached_pixbuf_ref0 (gpointer self)
{
	return self ? photo_cached_pixbuf_ref (self) : NULL;
}

static gboolean
_photo_trim_source_pixbuf_cache_gsource_func (gpointer self)
{
	gboolean result;
	result = photo_trim_source_pixbuf_cache ();
	return result;
}

static GdkPixbuf*
photo_run_source_pixbuf_cache (Photo* locate,
                               gboolean keep,
                               GError** error)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail ((locate == NULL) || IS_PHOTO (locate), NULL);
	{
		GeeLinkedList* _tmp0_;
		_tmp0_ = photo_source_pixbuf_cache;
		g_rec_mutex_lock (&__lock_photo_photo_source_pixbuf_cache);
		{
			PhotoCachedPixbuf* found = NULL;
			gdouble min_elapsed = 0.0;
			gint count = 0;
			GeeIterator* iter = NULL;
			GeeLinkedList* _tmp1_;
			GeeIterator* _tmp2_;
			gboolean _tmp18_ = FALSE;
			gboolean _tmp19_ = FALSE;
			PhotoCachedPixbuf* _tmp20_;
			gboolean _tmp28_ = FALSE;
			PhotoCachedPixbuf* _tmp29_;
			GeeLinkedList* _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			GdkPixbuf* _tmp43_ = NULL;
			PhotoCachedPixbuf* _tmp44_;
			GdkPixbuf* _tmp47_;
			found = NULL;
			min_elapsed = DBL_MAX;
			count = 0;
			_tmp1_ = photo_source_pixbuf_cache;
			_tmp2_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			iter = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_;
				PhotoCachedPixbuf* cached_pixbuf = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				gdouble elapsed = 0.0;
				PhotoCachedPixbuf* _tmp6_;
				GTimer* _tmp7_;
				gboolean _tmp8_ = FALSE;
				_tmp3_ = iter;
				if (!gee_iterator_next (_tmp3_)) {
					break;
				}
				_tmp4_ = iter;
				_tmp5_ = gee_iterator_get (_tmp4_);
				cached_pixbuf = (PhotoCachedPixbuf*) _tmp5_;
				_tmp6_ = cached_pixbuf;
				_tmp7_ = _tmp6_->last_touched;
				elapsed = trunc (g_timer_elapsed (_tmp7_, NULL)) + 1;
				if (locate != NULL) {
					PhotoCachedPixbuf* _tmp9_;
					Photo* _tmp10_;
					_tmp9_ = cached_pixbuf;
					_tmp10_ = _tmp9_->photo;
					_tmp8_ = data_source_equals (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (locate, TYPE_DATA_SOURCE, DataSource));
				} else {
					_tmp8_ = FALSE;
				}
				if (_tmp8_) {
					GeeIterator* _tmp11_;
					PhotoCachedPixbuf* _tmp12_;
					PhotoCachedPixbuf* _tmp13_;
					gint _tmp14_;
					_tmp11_ = iter;
					gee_iterator_remove (_tmp11_);
					_tmp12_ = cached_pixbuf;
					_tmp13_ = _photo_cached_pixbuf_ref0 (_tmp12_);
					_photo_cached_pixbuf_unref0 (found);
					found = _tmp13_;
					_tmp14_ = count;
					count = _tmp14_ + 1;
				} else {
					if (elapsed >= ((gdouble) PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC)) {
						GeeIterator* _tmp15_;
						_tmp15_ = iter;
						gee_iterator_remove (_tmp15_);
					} else {
						if (count >= PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT) {
							GeeIterator* _tmp16_;
							_tmp16_ = iter;
							gee_iterator_remove (_tmp16_);
						} else {
							gint _tmp17_;
							min_elapsed = MIN (elapsed, min_elapsed);
							_tmp17_ = count;
							count = _tmp17_ + 1;
						}
					}
				}
				_photo_cached_pixbuf_unref0 (cached_pixbuf);
			}
			_tmp20_ = found;
			if (_tmp20_ == NULL) {
				_tmp19_ = locate != NULL;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				_tmp18_ = keep;
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				GdkPixbuf* _tmp21_ = NULL;
				Scaling _tmp22_ = {0};
				GdkPixbuf* _tmp23_;
				PhotoCachedPixbuf* _tmp24_;
				scaling_for_original (&_tmp22_);
				_tmp23_ = photo_load_raw_pixbuf (locate, &_tmp22_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_SOURCE, &_inner_error0_);
				_tmp21_ = _tmp23_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (iter);
					_photo_cached_pixbuf_unref0 (found);
					goto __catch0_g_error;
				}
				_tmp24_ = photo_cached_pixbuf_new (locate, _tmp21_);
				_photo_cached_pixbuf_unref0 (found);
				found = _tmp24_;
				_g_object_unref0 (_tmp21_);
			} else {
				PhotoCachedPixbuf* _tmp25_;
				_tmp25_ = found;
				if (_tmp25_ != NULL) {
					PhotoCachedPixbuf* _tmp26_;
					GTimer* _tmp27_;
					_tmp26_ = found;
					_tmp27_ = _tmp26_->last_touched;
					g_timer_start (_tmp27_);
				}
			}
			_tmp29_ = found;
			if (_tmp29_ != NULL) {
				_tmp28_ = keep;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				GeeLinkedList* _tmp30_;
				PhotoCachedPixbuf* _tmp31_;
				PhotoCachedPixbuf* _tmp32_;
				GTimer* _tmp33_;
				_tmp30_ = photo_source_pixbuf_cache;
				_tmp31_ = found;
				gee_abstract_list_insert (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), 0, _tmp31_);
				_tmp32_ = found;
				_tmp33_ = _tmp32_->last_touched;
				min_elapsed = MIN (g_timer_elapsed (_tmp33_, NULL), min_elapsed);
				while (TRUE) {
					GeeLinkedList* _tmp34_;
					gint _tmp35_;
					gint _tmp36_;
					GeeLinkedList* _tmp37_;
					gpointer _tmp38_;
					PhotoCachedPixbuf* _tmp39_;
					_tmp34_ = photo_source_pixbuf_cache;
					_tmp35_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
					_tmp36_ = _tmp35_;
					if (!(_tmp36_ > PHOTO_SOURCE_PIXBUF_MAX_LRU_COUNT)) {
						break;
					}
					_tmp37_ = photo_source_pixbuf_cache;
					_tmp38_ = gee_deque_poll_tail (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, GEE_TYPE_DEQUE, GeeDeque));
					_tmp39_ = (PhotoCachedPixbuf*) _tmp38_;
					_photo_cached_pixbuf_unref0 (_tmp39_);
				}
			}
			if (photo_discard_source_id != ((guint) 0)) {
				g_source_remove (photo_discard_source_id);
				photo_discard_source_id = (guint) 0;
			}
			_tmp40_ = photo_source_pixbuf_cache;
			_tmp41_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp42_ = _tmp41_;
			if (_tmp42_ > PHOTO_SOURCE_PIXBUF_MIN_LRU_COUNT) {
				guint retry_sec = 0U;
				_vala_assert (min_elapsed >= 0.0, "min_elapsed >= 0.0");
				retry_sec = PHOTO_SOURCE_PIXBUF_TIME_TO_LIVE_SEC - ((guint) trunc (min_elapsed));
				photo_discard_source_id = g_timeout_add_seconds_full (G_PRIORITY_LOW, retry_sec, _photo_trim_source_pixbuf_cache_gsource_func, NULL, NULL);
			}
			_tmp44_ = found;
			if (_tmp44_ != NULL) {
				PhotoCachedPixbuf* _tmp45_;
				GdkPixbuf* _tmp46_;
				_tmp45_ = found;
				_tmp46_ = _tmp45_->pixbuf;
				_tmp43_ = _tmp46_;
			} else {
				_tmp43_ = NULL;
			}
			_tmp47_ = _g_object_ref0 (_tmp43_);
			result = _tmp47_;
			_g_object_unref0 (iter);
			_photo_cached_pixbuf_unref0 (found);
			{
				GError* _inner_error0_ = NULL;
				GeeLinkedList* _tmp48_;
				_tmp48_ = photo_source_pixbuf_cache;
				g_rec_mutex_unlock (&__lock_photo_photo_source_pixbuf_cache);
			}
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp49_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp49_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp49_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			GeeLinkedList* _tmp50_;
			_tmp50_ = photo_source_pixbuf_cache;
			g_rec_mutex_unlock (&__lock_photo_photo_source_pixbuf_cache);
		}
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
}

static gboolean
photo_trim_source_pixbuf_cache (void)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = photo_run_source_pixbuf_cache (NULL, FALSE, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = FALSE;
	return result;
}

/**
     * @brief Get a copy of what's in the cache.
     *
     * @return A copy of the Pixbuf with the image data from unmodified_precached.
     */
GdkPixbuf*
photo_get_prefetched_copy (Photo* self,
                           GError** error)
{
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	_tmp1_ = photo_run_source_pixbuf_cache (self, TRUE, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = gdk_pixbuf_copy (_tmp0_);
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

/**
     * @brief Discards the cached version of the unmodified image.
     */
void
photo_discard_prefetched (Photo* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	{
		GdkPixbuf* _tmp0_;
		GdkPixbuf* _tmp1_;
		_tmp0_ = photo_run_source_pixbuf_cache (self, FALSE, &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

/**
     * @brief Returns a fully transformed and scaled pixbuf.  Transformations may be excluded via
     * the mask. If the image is smaller than the scaling, it will be returned in its actual size.
     * The caller is responsible for scaling thereafter.
     *
     * @param scaling A scaling object that describes the size the output pixbuf should be.
     * @param exceptions The parts of the pipeline that should be skipped; defaults to NONE if
     *      left unset.
     * @param fetch_mode The fetch mode; if left unset, defaults to BASELINE so that
     *      we get the image exactly as it is in the file.
     */
GdkPixbuf*
photo_get_pixbuf_with_options (Photo* self,
                               Scaling* scaling,
                               PhotoException exceptions,
                               BackingFetchMode fetch_mode,
                               GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean is_scaled = FALSE;
	gboolean is_cropped = FALSE;
	gboolean is_straightened = FALSE;
	Dimensions scaled_to_viewport = {0};
	Dimensions original = {0};
	Dimensions scaled = {0};
	EditingToolsRedeyeInstance* redeye_instances = NULL;
	gint redeye_instances_length1;
	gint _redeye_instances_size_;
	Box crop = {0};
	gdouble straightening_angle = 0.0;
	PixelTransformer* transformer = NULL;
	Orientation orientation = 0;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp22_;
	gboolean _tmp60_ = FALSE;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp3_ = photo_get_develop_raw_photos_to_files ();
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		_tmp2_ = photo_get_master_file_format (self) == PHOTO_FILE_FORMAT_RAW;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		if (fetch_mode == BACKING_FETCH_MODE_BASELINE) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = fetch_mode == BACKING_FETCH_MODE_UNMODIFIED;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = fetch_mode == BACKING_FETCH_MODE_SOURCE;
		}
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !photo_is_raw_developer_complete (self, photo_get_raw_developer (self));
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		photo_set_raw_developer (self, photo_get_raw_developer (self), TRUE);
	}
	dimensions_init (&original, 0, 0);
	dimensions_init (&scaled, 0, 0);
	redeye_instances = NULL;
	redeye_instances_length1 = 0;
	_redeye_instances_size_ = redeye_instances_length1;
	transformer = NULL;
	{
		PhotoRow* _tmp7_;
		_tmp7_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			Dimensions _tmp8_ = {0};
			Dimensions _tmp9_ = {0};
			Dimensions _tmp10_ = {0};
			Dimensions _tmp11_;
			Dimensions _tmp12_ = {0};
			Dimensions _tmp13_;
			gint _tmp14_ = 0;
			EditingToolsRedeyeInstance* _tmp15_;
			Box _tmp16_ = {0};
			gboolean _tmp17_;
			gdouble _tmp18_ = 0.0;
			gboolean _tmp19_;
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_ALL, &_tmp8_);
			original = _tmp8_;
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), exceptions, &_tmp9_);
			scaling_get_scaled_dimensions (scaling, &_tmp9_, &_tmp10_);
			scaled = _tmp10_;
			_tmp11_ = scaled;
			scaled_to_viewport = _tmp11_;
			media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp12_);
			_tmp13_ = scaled;
			is_scaled = !dimensions_equals (&_tmp12_, &_tmp13_);
			_tmp15_ = photo_get_raw_redeye_instances (self, &_tmp14_);
			redeye_instances = (g_free (redeye_instances), NULL);
			redeye_instances = _tmp15_;
			redeye_instances_length1 = _tmp14_;
			_redeye_instances_size_ = redeye_instances_length1;
			_tmp17_ = photo_get_raw_crop (self, &_tmp16_);
			crop = _tmp16_;
			is_cropped = _tmp17_;
			_tmp19_ = photo_get_raw_straighten (self, &_tmp18_);
			straightening_angle = _tmp18_;
			is_straightened = _tmp19_;
			if (photo_has_color_adjustments (self)) {
				PixelTransformer* _tmp20_;
				_tmp20_ = photo_get_pixel_transformer (self);
				_pixel_transformer_unref0 (transformer);
				transformer = _tmp20_;
			}
			orientation = photo_get_orientation (self);
		}
		__finally0:
		{
			PhotoRow* _tmp21_;
			_tmp21_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_pixel_transformer_unref0 (transformer);
			redeye_instances = (g_free (redeye_instances), NULL);
			return NULL;
		}
	}
	_tmp22_ = photo_get_prefetched_copy (self, &_inner_error0_);
	pixbuf = _tmp22_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_pixel_transformer_unref0 (transformer);
		redeye_instances = (g_free (redeye_instances), NULL);
		return NULL;
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_REDEYE)) {
		EditingToolsRedeyeInstance* _tmp23_;
		gint _tmp23__length1;
		_tmp23_ = redeye_instances;
		_tmp23__length1 = redeye_instances_length1;
		{
			EditingToolsRedeyeInstance* instance_collection = NULL;
			gint instance_collection_length1 = 0;
			gint _instance_collection_size_ = 0;
			gint instance_it = 0;
			instance_collection = _tmp23_;
			instance_collection_length1 = _tmp23__length1;
			for (instance_it = 0; instance_it < instance_collection_length1; instance_it = instance_it + 1) {
				EditingToolsRedeyeInstance instance = {0};
				instance = instance_collection[instance_it];
				{
					GdkPixbuf* _tmp24_;
					EditingToolsRedeyeInstance _tmp25_;
					GdkPixbuf* _tmp26_;
					_tmp24_ = pixbuf;
					_tmp25_ = instance;
					_tmp26_ = photo_do_redeye (self, _tmp24_, &_tmp25_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp26_;
				}
			}
		}
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_STRAIGHTEN)) {
		if (is_straightened) {
			GdkPixbuf* _tmp27_;
			GdkPixbuf* _tmp28_;
			_tmp27_ = pixbuf;
			_tmp28_ = rotate_arb (_tmp27_, straightening_angle);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp28_;
		}
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_CROP)) {
		if (is_cropped) {
			Box _tmp29_;
			GdkPixbuf* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			Box _tmp33_;
			GdkPixbuf* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			Box _tmp37_;
			Box _tmp38_;
			GdkPixbuf* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			Box _tmp42_;
			Box _tmp43_;
			GdkPixbuf* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			GdkPixbuf* _tmp47_;
			Box _tmp48_;
			Box _tmp49_;
			GdkPixbuf* _tmp50_;
			_tmp29_ = crop;
			_tmp30_ = pixbuf;
			_tmp31_ = gdk_pixbuf_get_width (_tmp30_);
			_tmp32_ = _tmp31_;
			crop.left = CLAMP (_tmp29_.left, 0, _tmp32_ - 2);
			_tmp33_ = crop;
			_tmp34_ = pixbuf;
			_tmp35_ = gdk_pixbuf_get_height (_tmp34_);
			_tmp36_ = _tmp35_;
			crop.top = CLAMP (_tmp33_.top, 0, _tmp36_ - 2);
			_tmp37_ = crop;
			_tmp38_ = crop;
			_tmp39_ = pixbuf;
			_tmp40_ = gdk_pixbuf_get_width (_tmp39_);
			_tmp41_ = _tmp40_;
			crop.right = CLAMP (_tmp37_.right, _tmp38_.left + 1, _tmp41_ - 1);
			_tmp42_ = crop;
			_tmp43_ = crop;
			_tmp44_ = pixbuf;
			_tmp45_ = gdk_pixbuf_get_height (_tmp44_);
			_tmp46_ = _tmp45_;
			crop.bottom = CLAMP (_tmp42_.bottom, _tmp43_.top + 1, _tmp46_ - 1);
			_tmp47_ = pixbuf;
			_tmp48_ = crop;
			_tmp49_ = crop;
			_tmp50_ = gdk_pixbuf_new_subpixbuf (_tmp47_, _tmp48_.left, _tmp49_.top, box_get_width (&crop), box_get_height (&crop));
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp50_;
		}
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
		GdkPixbuf* _tmp51_;
		GdkPixbuf* _tmp52_;
		_tmp51_ = pixbuf;
		_tmp52_ = orientation_rotate_pixbuf (orientation, _tmp51_);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp52_;
	}
	if (is_scaled) {
		GdkPixbuf* _tmp53_;
		Dimensions _tmp54_;
		Dimensions _tmp55_;
		GdkPixbuf* _tmp56_;
		_tmp53_ = pixbuf;
		_tmp54_ = scaled_to_viewport;
		_tmp55_ = scaled_to_viewport;
		_tmp56_ = gdk_pixbuf_scale_simple (_tmp53_, _tmp54_.width, _tmp55_.height, GDK_INTERP_BILINEAR);
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp56_;
	}
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ADJUST)) {
		PixelTransformer* _tmp57_;
		_tmp57_ = transformer;
		if (_tmp57_ != NULL) {
			PixelTransformer* _tmp58_;
			GdkPixbuf* _tmp59_;
			_tmp58_ = transformer;
			_tmp59_ = pixbuf;
			pixel_transformer_transform_pixbuf (_tmp58_, _tmp59_, NULL);
		}
	}
	if (is_scaled) {
		_tmp60_ = !is_straightened;
	} else {
		_tmp60_ = FALSE;
	}
	if (_tmp60_) {
		GdkPixbuf* _tmp61_;
		Dimensions _tmp62_ = {0};
		_tmp61_ = pixbuf;
		dimensions_for_pixbuf (_tmp61_, &_tmp62_);
		_vala_assert (dimensions_approx_equals (&scaled_to_viewport, &_tmp62_, PHOTO_SCALING_FUDGE), "scaled_to_viewport.approx_equals(Dimensions.for_pixbuf(pixbuf), SCALING_FUDGE)");
	}
	result = pixbuf;
	_pixel_transformer_unref0 (transformer);
	redeye_instances = (g_free (redeye_instances), NULL);
	return result;
}

static gboolean
photo_real_has_user_generated_metadata (Photo* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `photo_has_user_generated_metadata'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
photo_has_user_generated_metadata (Photo* self)
{
	PhotoClass* _klass_;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->has_user_generated_metadata) {
		return _klass_->has_user_generated_metadata (self);
	}
	return FALSE;
}

static void
photo_real_set_user_metadata_for_export (Photo* self,
                                         PhotoMetadata* metadata)
{
	g_critical ("Type `%s' does not implement abstract method `photo_set_user_metadata_for_export'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
photo_set_user_metadata_for_export (Photo* self,
                                    PhotoMetadata* metadata)
{
	PhotoClass* _klass_;
	g_return_if_fail (IS_PHOTO (self));
	_klass_ = PHOTO_GET_CLASS (self);
	if (_klass_->set_user_metadata_for_export) {
		_klass_->set_user_metadata_for_export (self, metadata);
	}
}

gchar*
photo_get_export_basename (Photo* self,
                           PhotoFileFormat* file_format)
{
	gchar* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	if (file_format != NULL) {
		PhotoFileFormatProperties* _tmp0_;
		PhotoFileFormatProperties* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp0_ = photo_file_format_get_properties (*file_format);
		_tmp1_ = _tmp0_;
		_tmp2_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp3_ = _tmp2_;
		_tmp4_ = photo_file_format_properties_convert_file_extension (_tmp1_, _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_basename (_tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_g_object_unref0 (_tmp3_);
		_photo_file_format_properties_unref0 (_tmp1_);
		result = _tmp7_;
		return result;
	} else {
		if (photo_file_format_can_write (photo_get_file_format (self))) {
			PhotoFileFormatProperties* _tmp8_;
			PhotoFileFormatProperties* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = photo_file_format_get_properties (photo_get_file_format (self));
			_tmp9_ = _tmp8_;
			_tmp10_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp11_ = _tmp10_;
			_tmp12_ = photo_file_format_properties_convert_file_extension (_tmp9_, _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_file_get_basename (_tmp13_);
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp13_);
			_g_object_unref0 (_tmp11_);
			_photo_file_format_properties_unref0 (_tmp9_);
			result = _tmp15_;
			return result;
		} else {
			PhotoFileFormatProperties* _tmp16_;
			PhotoFileFormatProperties* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			_tmp16_ = photo_file_format_get_properties (photo_file_format_get_system_default_format ());
			_tmp17_ = _tmp16_;
			_tmp18_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp19_ = _tmp18_;
			_tmp20_ = photo_file_format_properties_convert_file_extension (_tmp17_, _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_file_get_basename (_tmp21_);
			_tmp23_ = _tmp22_;
			_g_object_unref0 (_tmp21_);
			_g_object_unref0 (_tmp19_);
			_photo_file_format_properties_unref0 (_tmp17_);
			result = _tmp23_;
			return result;
		}
	}
}

static gboolean
photo_export_fullsized_backing (Photo* self,
                                GFile* file,
                                gboolean export_metadata,
                                GError** error)
{
	PhotoFileReader* export_reader = NULL;
	gboolean is_master = FALSE;
	PhotoFileReader* _tmp24_;
	PhotoFileFormatProperties* format_properties = NULL;
	PhotoFileReader* _tmp25_;
	PhotoFileFormatProperties* _tmp26_;
	GFile* dest_file = NULL;
	PhotoFileFormatProperties* _tmp27_;
	GFile* _tmp28_;
	PhotoFileMetadataWriter* writer = NULL;
	PhotoFileReader* _tmp29_;
	GFile* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	PhotoFileMetadataWriter* _tmp33_;
	PhotoFileMetadataWriter* _tmp34_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	PhotoFileMetadataWriter* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	PhotoFileReader* _tmp41_;
	GFile* _tmp42_;
	GFile* _tmp43_;
	GFile* _tmp44_;
	gboolean _tmp46_ = FALSE;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	gboolean _tmp49_ = FALSE;
	gboolean _tmp50_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoFileReader* _tmp55_;
	PhotoMetadata* _tmp56_;
	PhotoMetadata* _tmp58_;
	PhotoFileMetadataWriter* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	GDateTime* _tmp64_;
	GDateTime* _tmp65_;
	gboolean _tmp66_;
	PhotoFileMetadataWriter* _tmp86_;
	PhotoMetadata* _tmp87_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	export_reader = NULL;
	is_master = TRUE;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			gboolean _tmp1_ = FALSE;
			PhotoBackingReaders* _tmp2_;
			PhotoFileReader* _tmp3_;
			_tmp2_ = self->priv->readers;
			_tmp3_ = _tmp2_->editable;
			if (_tmp3_ != NULL) {
				PhotoBackingReaders* _tmp4_;
				PhotoFileReader* _tmp5_;
				_tmp4_ = self->priv->readers;
				_tmp5_ = _tmp4_->editable;
				_tmp1_ = photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)));
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				PhotoBackingReaders* _tmp6_;
				PhotoFileReader* _tmp7_;
				PhotoFileReader* _tmp8_;
				_tmp6_ = self->priv->readers;
				_tmp7_ = _tmp6_->editable;
				_tmp8_ = _photo_file_adapter_ref0 (_tmp7_);
				_photo_file_adapter_unref0 (export_reader);
				export_reader = _tmp8_;
				is_master = FALSE;
			} else {
				gboolean _tmp9_ = FALSE;
				PhotoBackingReaders* _tmp10_;
				PhotoFileReader* _tmp11_;
				_tmp10_ = self->priv->readers;
				_tmp11_ = _tmp10_->developer;
				if (_tmp11_ != NULL) {
					PhotoBackingReaders* _tmp12_;
					PhotoFileReader* _tmp13_;
					_tmp12_ = self->priv->readers;
					_tmp13_ = _tmp12_->developer;
					_tmp9_ = photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)));
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					PhotoBackingReaders* _tmp14_;
					PhotoFileReader* _tmp15_;
					PhotoFileReader* _tmp16_;
					_tmp14_ = self->priv->readers;
					_tmp15_ = _tmp14_->developer;
					_tmp16_ = _photo_file_adapter_ref0 (_tmp15_);
					_photo_file_adapter_unref0 (export_reader);
					export_reader = _tmp16_;
					is_master = FALSE;
				} else {
					PhotoBackingReaders* _tmp17_;
					PhotoFileReader* _tmp18_;
					_tmp17_ = self->priv->readers;
					_tmp18_ = _tmp17_->master;
					if (photo_file_format_can_write_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)))) {
						PhotoBackingReaders* _tmp19_;
						PhotoFileReader* _tmp20_;
						PhotoFileReader* _tmp21_;
						_tmp19_ = self->priv->readers;
						_tmp20_ = _tmp19_->master;
						_tmp21_ = _photo_file_adapter_ref0 (_tmp20_);
						_photo_file_adapter_unref0 (export_reader);
						export_reader = _tmp21_;
					}
				}
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp22_;
			_tmp22_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp23_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			_photo_file_adapter_unref0 (export_reader);
			return _tmp23_;
		}
	}
	_tmp24_ = export_reader;
	if (_tmp24_ == NULL) {
		result = FALSE;
		_photo_file_adapter_unref0 (export_reader);
		return result;
	}
	_tmp25_ = export_reader;
	_tmp26_ = photo_file_format_get_properties (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)));
	format_properties = _tmp26_;
	_tmp27_ = format_properties;
	_tmp28_ = photo_file_format_properties_convert_file_extension (_tmp27_, file);
	dest_file = _tmp28_;
	_tmp29_ = export_reader;
	_tmp30_ = dest_file;
	_tmp31_ = g_file_get_path (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = photo_file_format_create_metadata_writer (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)), _tmp32_, &_inner_error0_);
	_tmp34_ = _tmp33_;
	_g_free0 (_tmp32_);
	writer = _tmp34_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp35_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp35_;
	}
	_tmp36_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp37_ = _tmp36_;
	_tmp38_ = writer;
	_tmp39_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp40_ = _tmp39_;
	g_debug ("Photo.vala:3645: Exporting full-sized copy of %s to %s", _tmp37_, _tmp40_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp37_);
	_tmp41_ = export_reader;
	_tmp42_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp43_ = _tmp42_;
	_tmp44_ = dest_file;
	g_file_copy (_tmp43_, _tmp44_, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error0_);
	_g_object_unref0 (_tmp43_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp45_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp45_;
	}
	if (!photo_has_alterations (self)) {
		_tmp50_ = is_master;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		_tmp49_ = !photo_has_user_generated_metadata (self);
	} else {
		_tmp49_ = FALSE;
	}
	if (_tmp49_) {
		gchar* _tmp51_;
		gchar* _tmp52_;
		_tmp51_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_ == NULL;
		_g_free0 (_tmp52_);
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp53_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp54_ = _tmp53_;
		_tmp47_ = _tmp54_ == NULL;
		_g_free0 (_tmp54_);
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		_tmp46_ = export_metadata;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		result = TRUE;
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return result;
	}
	_tmp55_ = export_reader;
	_tmp56_ = photo_file_reader_read_metadata (_tmp55_, &_inner_error0_);
	metadata = _tmp56_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp57_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp57_;
	}
	_tmp58_ = metadata;
	if (_tmp58_ == NULL) {
		PhotoFileReader* _tmp59_;
		PhotoMetadata* _tmp60_;
		_tmp59_ = export_reader;
		_tmp60_ = photo_file_format_create_metadata (photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter)));
		_media_metadata_unref0 (metadata);
		metadata = _tmp60_;
	}
	_tmp61_ = writer;
	_tmp62_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp63_ = _tmp62_;
	g_debug ("Photo.vala:3661: Updating metadata of %s", _tmp63_);
	_g_free0 (_tmp63_);
	_tmp64_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp65_ = _tmp64_;
	_tmp66_ = _tmp65_ != NULL;
	_g_date_time_unref0 (_tmp65_);
	if (_tmp66_) {
		PhotoMetadata* _tmp67_;
		GDateTime* _tmp68_;
		GDateTime* _tmp69_;
		MetadataDateTime* _tmp70_;
		MetadataDateTime* _tmp71_;
		_tmp67_ = metadata;
		_tmp68_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp69_ = _tmp68_;
		_tmp70_ = metadata_date_time_new (_tmp69_);
		_tmp71_ = _tmp70_;
		photo_metadata_set_exposure_date_time (_tmp67_, _tmp71_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_metadata_date_time_unref0 (_tmp71_);
		_g_date_time_unref0 (_tmp69_);
	} else {
		PhotoMetadata* _tmp72_;
		_tmp72_ = metadata;
		photo_metadata_set_exposure_date_time (_tmp72_, NULL, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	}
	if (export_metadata) {
		PhotoMetadata* _tmp73_;
		gchar* _tmp74_;
		gchar* _tmp75_;
		PhotoMetadata* _tmp76_;
		gchar* _tmp77_;
		gchar* _tmp78_;
		PhotoMetadata* _tmp79_;
		Dimensions _tmp80_ = {0};
		PhotoMetadata* _tmp81_;
		PhotoMetadata* _tmp82_;
		PhotoMetadata* _tmp84_;
		_tmp73_ = metadata;
		_tmp74_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp75_ = _tmp74_;
		photo_metadata_set_title (_tmp73_, _tmp75_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_free0 (_tmp75_);
		_tmp76_ = metadata;
		_tmp77_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp78_ = _tmp77_;
		photo_metadata_set_comment (_tmp76_, _tmp78_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_free0 (_tmp78_);
		_tmp79_ = metadata;
		media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp80_);
		photo_metadata_set_pixel_dimensions (_tmp79_, &_tmp80_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_tmp81_ = metadata;
		photo_metadata_set_orientation (_tmp81_, photo_get_orientation (self));
		_tmp82_ = metadata;
		photo_metadata_set_software (_tmp82_, RESOURCES_APP_TITLE, RESOURCES_APP_VERSION);
		if (photo_get_orientation (self) != photo_get_original_orientation (self)) {
			PhotoMetadata* _tmp83_;
			_tmp83_ = metadata;
			photo_metadata_remove_exif_thumbnail (_tmp83_);
		}
		_tmp84_ = metadata;
		photo_set_user_metadata_for_export (self, _tmp84_);
	} else {
		PhotoMetadata* _tmp85_;
		_tmp85_ = metadata;
		photo_metadata_clear (_tmp85_);
	}
	_tmp86_ = writer;
	_tmp87_ = metadata;
	photo_file_metadata_writer_write_metadata (_tmp86_, _tmp87_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp88_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (writer);
		_g_object_unref0 (dest_file);
		_photo_file_format_properties_unref0 (format_properties);
		_photo_file_adapter_unref0 (export_reader);
		return _tmp88_;
	}
	result = TRUE;
	_media_metadata_unref0 (metadata);
	_photo_file_adapter_unref0 (writer);
	_g_object_unref0 (dest_file);
	_photo_file_format_properties_unref0 (format_properties);
	_photo_file_adapter_unref0 (export_reader);
	return result;
}

gboolean
photo_is_export_required (Photo* self,
                          Scaling* scaling,
                          PhotoFileFormat export_format)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	g_return_val_if_fail (scaling != NULL, FALSE);
	if (!scaling_is_unscaled (scaling)) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = photo_has_alterations (self);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = photo_has_user_generated_metadata (self);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = export_format != photo_get_file_format (self);
	}
	result = _tmp0_;
	return result;
}

void
photo_export (Photo* self,
              GFile* dest_file,
              Scaling* scaling,
              JpegQuality quality,
              PhotoFileFormat export_format,
              gboolean direct_copy_unmodified,
              gboolean export_metadata,
              GError** error)
{
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp7_;
	PhotoMetadata* _tmp8_;
	PhotoFileWriter* writer = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	PhotoFileWriter* _tmp12_;
	PhotoFileWriter* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	PhotoFileWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GEnumValue* _tmp19_;
	GdkPixbuf* pixbuf = NULL;
	gboolean _tmp20_ = FALSE;
	PhotoFileWriter* _tmp29_;
	GdkPixbuf* _tmp30_;
	PhotoFileWriter* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gboolean _tmp55_ = FALSE;
	PhotoFileMetadataWriter* _tmp63_ = NULL;
	gchar* _tmp64_;
	gchar* _tmp65_;
	PhotoFileMetadataWriter* _tmp66_;
	PhotoFileMetadataWriter* _tmp67_;
	PhotoMetadata* _tmp68_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (dest_file, g_file_get_type ()));
	g_return_if_fail (scaling != NULL);
	if (direct_copy_unmodified) {
		GFile* _tmp0_;
		GFile* _tmp1_;
		_tmp0_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp1_ = _tmp0_;
		g_file_copy (_tmp1_, dest_file, G_FILE_COPY_OVERWRITE | G_FILE_COPY_TARGET_DEFAULT_PERMS, NULL, NULL, NULL, &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		return;
	}
	if (scaling_is_unscaled (scaling)) {
		gboolean _tmp5_ = FALSE;
		if (!photo_has_alterations (self)) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = photo_only_metadata_changed (self);
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		_tmp3_ = export_format == photo_get_file_format (self);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = photo_get_file_format (self) == PHOTO_FILE_FORMAT_JFIF;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp6_ = FALSE;
		_tmp6_ = photo_export_fullsized_backing (self, dest_file, export_metadata, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			return;
		}
		if (_tmp6_) {
			return;
		}
	}
	_tmp7_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
	metadata = _tmp7_;
	_tmp8_ = metadata;
	if (_tmp8_ == NULL) {
		PhotoMetadata* _tmp9_;
		_tmp9_ = photo_file_format_create_metadata (export_format);
		_media_metadata_unref0 (metadata);
		metadata = _tmp9_;
	}
	if (!photo_file_format_can_write (export_format)) {
		export_format = photo_file_format_get_system_default_format ();
	}
	_tmp10_ = g_file_get_path (dest_file);
	_tmp11_ = _tmp10_;
	_tmp12_ = photo_file_format_create_writer (export_format, _tmp11_, &_inner_error0_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	writer = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_media_metadata_unref0 (metadata);
		return;
	}
	_tmp14_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp15_ = _tmp14_;
	_tmp16_ = writer;
	_tmp17_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp18_ = _tmp17_;
	_tmp19_ = g_enum_get_value (g_type_class_ref (TYPE_PHOTO_FILE_FORMAT), export_format);
	g_debug ("Photo.vala:3731: Saving transformed version of %s to %s in file format" \
" %s", _tmp15_, _tmp18_, (_tmp19_ != NULL) ? _tmp19_->value_name : NULL);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	if (photo_get_file_format (self) == PHOTO_FILE_FORMAT_JFIF) {
		_tmp20_ = TRUE;
	} else {
		_tmp20_ = photo_get_file_format (self) == PHOTO_FILE_FORMAT_RAW;
	}
	if (_tmp20_) {
		GdkPixbuf* _tmp21_ = NULL;
		Scaling _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		_tmp22_ = *scaling;
		_tmp23_ = photo_get_pixbuf_with_options (self, &_tmp22_, PHOTO_EXCEPTION_ORIENTATION, BACKING_FETCH_MODE_SOURCE, &_inner_error0_);
		_tmp21_ = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pixbuf);
			_photo_file_adapter_unref0 (writer);
			_media_metadata_unref0 (metadata);
			return;
		}
		_tmp24_ = _tmp21_;
		_tmp21_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp24_;
		_g_object_unref0 (_tmp21_);
	} else {
		GdkPixbuf* _tmp25_ = NULL;
		Scaling _tmp26_;
		GdkPixbuf* _tmp27_;
		GdkPixbuf* _tmp28_;
		_tmp26_ = *scaling;
		_tmp27_ = photo_get_pixbuf_with_options (self, &_tmp26_, PHOTO_EXCEPTION_NONE, BACKING_FETCH_MODE_SOURCE, &_inner_error0_);
		_tmp25_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (pixbuf);
			_photo_file_adapter_unref0 (writer);
			_media_metadata_unref0 (metadata);
			return;
		}
		_tmp28_ = _tmp25_;
		_tmp25_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp28_;
		_g_object_unref0 (_tmp25_);
	}
	_tmp29_ = writer;
	_tmp30_ = pixbuf;
	photo_file_writer_write (_tmp29_, _tmp30_, quality, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		return;
	}
	_tmp31_ = writer;
	_tmp32_ = photo_file_adapter_get_filepath (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	_tmp33_ = _tmp32_;
	g_debug ("Photo.vala:3750: Setting EXIF for %s", _tmp33_);
	_g_free0 (_tmp33_);
	if (export_metadata) {
		PhotoMetadata* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		PhotoMetadata* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		PhotoMetadata* _tmp40_;
		GDateTime* _tmp41_;
		GDateTime* _tmp42_;
		gboolean _tmp43_;
		PhotoMetadata* _tmp50_;
		PhotoMetadata* _tmp51_;
		PhotoMetadata* _tmp52_;
		_tmp34_ = metadata;
		_tmp35_ = media_source_get_title (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp36_ = _tmp35_;
		photo_metadata_set_title (_tmp34_, _tmp36_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_free0 (_tmp36_);
		_tmp37_ = metadata;
		_tmp38_ = media_source_get_comment (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp39_ = _tmp38_;
		photo_metadata_set_comment (_tmp37_, _tmp39_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_free0 (_tmp39_);
		_tmp40_ = metadata;
		photo_metadata_set_software (_tmp40_, RESOURCES_APP_TITLE, RESOURCES_APP_VERSION);
		_tmp41_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_ != NULL;
		_g_date_time_unref0 (_tmp42_);
		if (_tmp43_) {
			PhotoMetadata* _tmp44_;
			GDateTime* _tmp45_;
			GDateTime* _tmp46_;
			MetadataDateTime* _tmp47_;
			MetadataDateTime* _tmp48_;
			_tmp44_ = metadata;
			_tmp45_ = media_source_get_exposure_time (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp46_ = _tmp45_;
			_tmp47_ = metadata_date_time_new (_tmp46_);
			_tmp48_ = _tmp47_;
			photo_metadata_set_exposure_date_time (_tmp44_, _tmp48_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
			_metadata_date_time_unref0 (_tmp48_);
			_g_date_time_unref0 (_tmp46_);
		} else {
			PhotoMetadata* _tmp49_;
			_tmp49_ = metadata;
			photo_metadata_set_exposure_date_time (_tmp49_, NULL, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		}
		_tmp50_ = metadata;
		photo_metadata_remove_tag (_tmp50_, "Exif.Iop.RelatedImageWidth");
		_tmp51_ = metadata;
		photo_metadata_remove_tag (_tmp51_, "Exif.Iop.RelatedImageHeight");
		_tmp52_ = metadata;
		photo_metadata_remove_exif_thumbnail (_tmp52_);
		if (photo_has_user_generated_metadata (self)) {
			PhotoMetadata* _tmp53_;
			_tmp53_ = metadata;
			photo_set_user_metadata_for_export (self, _tmp53_);
		}
	} else {
		PhotoMetadata* _tmp54_;
		_tmp54_ = metadata;
		photo_metadata_clear (_tmp54_);
	}
	if (photo_get_file_format (self) == PHOTO_FILE_FORMAT_JFIF) {
		_tmp55_ = TRUE;
	} else {
		_tmp55_ = photo_get_file_format (self) == PHOTO_FILE_FORMAT_RAW;
	}
	if (_tmp55_) {
		PhotoMetadata* _tmp56_;
		Dimensions _tmp57_ = {0};
		PhotoMetadata* _tmp58_;
		_tmp56_ = metadata;
		media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_ORIENTATION, &_tmp57_);
		photo_metadata_set_pixel_dimensions (_tmp56_, &_tmp57_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_tmp58_ = metadata;
		photo_metadata_set_orientation (_tmp58_, photo_get_orientation (self));
	} else {
		PhotoMetadata* _tmp59_;
		GdkPixbuf* _tmp60_;
		Dimensions _tmp61_ = {0};
		PhotoMetadata* _tmp62_;
		_tmp59_ = metadata;
		_tmp60_ = pixbuf;
		dimensions_for_pixbuf (_tmp60_, &_tmp61_);
		photo_metadata_set_pixel_dimensions (_tmp59_, &_tmp61_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_tmp62_ = metadata;
		photo_metadata_set_orientation (_tmp62_, ORIENTATION_TOP_LEFT);
	}
	_tmp64_ = g_file_get_path (dest_file);
	_tmp65_ = _tmp64_;
	_tmp66_ = photo_file_format_create_metadata_writer (export_format, _tmp65_, &_inner_error0_);
	_tmp67_ = _tmp66_;
	_g_free0 (_tmp65_);
	_tmp63_ = _tmp67_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (pixbuf);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		return;
	}
	_tmp68_ = metadata;
	photo_file_metadata_writer_write_metadata (_tmp63_, _tmp68_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_photo_file_adapter_unref0 (_tmp63_);
		_g_object_unref0 (pixbuf);
		_photo_file_adapter_unref0 (writer);
		_media_metadata_unref0 (metadata);
		return;
	}
	_photo_file_adapter_unref0 (_tmp63_);
	_g_object_unref0 (pixbuf);
	_photo_file_adapter_unref0 (writer);
	_media_metadata_unref0 (metadata);
}

static GFile*
photo_generate_new_editable_file (Photo* self,
                                  PhotoFileFormat* file_format,
                                  GError** error)
{
	PhotoFileFormat _vala_file_format = 0;
	GFile* backing = NULL;
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gchar* editable_basename = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gboolean collision = FALSE;
	GFile* _tmp18_ = NULL;
	GFile* _tmp19_;
	GFile* _tmp20_;
	gboolean _tmp21_ = FALSE;
	GFile* _tmp22_;
	GFile* _tmp23_;
	GFile* _tmp24_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	{
		PhotoRow* _tmp0_;
		_tmp0_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			GFile* _tmp1_;
			_vala_file_format = photo_get_file_format (self);
			_tmp1_ = media_source_get_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
			_g_object_unref0 (backing);
			backing = _tmp1_;
		}
		__finally0:
		{
			PhotoRow* _tmp2_;
			_tmp2_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (backing);
			return NULL;
		}
	}
	if (!photo_file_format_can_write (_vala_file_format)) {
		_vala_file_format = photo_file_format_get_system_default_format ();
	}
	_tmp3_ = g_file_get_basename (backing);
	_tmp4_ = _tmp3_;
	disassemble_filename (_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (name);
	name = _tmp5_;
	_g_free0 (ext);
	ext = _tmp6_;
	_g_free0 (_tmp4_);
	_tmp8_ = ext;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		PhotoFileFormatProperties* _tmp9_;
		PhotoFileFormatProperties* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = photo_file_format_get_properties (_vala_file_format);
		_tmp10_ = _tmp9_;
		_tmp11_ = ext;
		_tmp7_ = !photo_file_format_properties_is_recognized_extension (_tmp10_, _tmp11_);
		_photo_file_format_properties_unref0 (_tmp10_);
	}
	if (_tmp7_) {
		PhotoFileFormatProperties* _tmp12_;
		PhotoFileFormatProperties* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = photo_file_format_get_properties (_vala_file_format);
		_tmp13_ = _tmp12_;
		_tmp14_ = photo_file_format_properties_get_default_extension (_tmp13_);
		_g_free0 (ext);
		ext = _tmp14_;
		_photo_file_format_properties_unref0 (_tmp13_);
	}
	_tmp15_ = name;
	_tmp16_ = ext;
	_tmp17_ = g_strdup_printf ("%s_%s.%s", _tmp15_, _ ("modified"), _tmp16_);
	editable_basename = _tmp17_;
	_tmp19_ = g_file_get_parent (backing);
	_tmp20_ = _tmp19_;
	_tmp22_ = generate_unique_file (_tmp20_, editable_basename, &_tmp21_, NULL, &_inner_error0_);
	collision = _tmp21_;
	_tmp23_ = _tmp22_;
	_g_object_unref0 (_tmp20_);
	_tmp18_ = _tmp23_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (editable_basename);
		_g_free0 (ext);
		_g_free0 (name);
		_g_object_unref0 (backing);
		return NULL;
	}
	_tmp24_ = _tmp18_;
	_tmp18_ = NULL;
	result = _tmp24_;
	_g_object_unref0 (_tmp18_);
	_g_free0 (editable_basename);
	_g_free0 (ext);
	_g_free0 (name);
	_g_object_unref0 (backing);
	if (file_format) {
		*file_format = _vala_file_format;
	}
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
photo_launch_editor (GFile* file,
                     PhotoFileFormat file_format,
                     GError** error)
{
	gchar* _tmp0_ = NULL;
	gchar* commandline = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GAppInfo* app = NULL;
	GList* files = NULL;
	GFile* _tmp14_;
	GAppInfo* _tmp15_;
	gchar** argv = NULL;
	gchar** _tmp20_;
	gint argv_length1;
	gint _argv_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	gchar* _tmp25_;
	GPid child_pid = 0;
	gboolean _tmp26_ = FALSE;
	gchar** _tmp27_;
	gint _tmp27__length1;
	GPid _tmp28_ = 0;
	gboolean _tmp29_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	if (file_format == PHOTO_FILE_FORMAT_RAW) {
		ConfigFacade* _tmp1_;
		ConfigFacade* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = config_facade_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = configuration_facade_get_external_raw_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
	} else {
		ConfigFacade* _tmp4_;
		ConfigFacade* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = config_facade_get_instance ();
		_tmp5_ = _tmp4_;
		_tmp6_ = configuration_facade_get_external_photo_app (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_CONFIGURATION_FACADE, ConfigurationFacade));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp7_ = g_strdup (_tmp0_);
	commandline = _tmp7_;
	_tmp8_ = commandline;
	if (is_string_empty (_tmp8_)) {
		result = FALSE;
		_g_free0 (commandline);
		_g_free0 (_tmp0_);
		return result;
	}
	{
		GAppInfo* _tmp9_ = NULL;
		const gchar* _tmp10_;
		GAppInfo* _tmp11_;
		GAppInfo* _tmp12_;
		_tmp10_ = commandline;
		_tmp11_ = g_app_info_create_from_commandline (_tmp10_, "", G_APP_INFO_CREATE_NONE, &_inner_error0_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (app);
		app = _tmp12_;
		_g_object_unref0 (_tmp9_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		_g_object_unref0 (app);
		app = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (app);
		_g_free0 (commandline);
		_g_free0 (_tmp0_);
		return _tmp13_;
	}
	files = NULL;
	_tmp14_ = _g_object_ref0 (file);
	files = g_list_insert (files, _tmp14_, -1);
	_tmp15_ = app;
	if (_tmp15_ != NULL) {
		gboolean _tmp16_ = FALSE;
		GAppInfo* _tmp17_;
		GList* _tmp18_;
		_tmp17_ = app;
		_tmp18_ = files;
		_tmp16_ = g_app_info_launch (_tmp17_, _tmp18_, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp19_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
			_g_object_unref0 (app);
			_g_free0 (commandline);
			_g_free0 (_tmp0_);
			return _tmp19_;
		}
		result = _tmp16_;
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app);
		_g_free0 (commandline);
		_g_free0 (_tmp0_);
		return result;
	}
	_tmp20_ = g_new0 (gchar*, 2 + 1);
	argv = _tmp20_;
	argv_length1 = 2;
	_argv_size_ = argv_length1;
	_tmp21_ = argv;
	_tmp21__length1 = argv_length1;
	_tmp22_ = commandline;
	_tmp23_ = g_strdup (_tmp22_);
	_g_free0 (_tmp21_[0]);
	_tmp21_[0] = _tmp23_;
	_tmp24_ = argv;
	_tmp24__length1 = argv_length1;
	_tmp25_ = g_file_get_path (file);
	_g_free0 (_tmp24_[1]);
	_tmp24_[1] = _tmp25_;
	_tmp27_ = argv;
	_tmp27__length1 = argv_length1;
	_tmp29_ = g_spawn_async ("/", _tmp27_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp28_, &_inner_error0_);
	child_pid = _tmp28_;
	_tmp26_ = _tmp29_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp30_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
		_g_object_unref0 (app);
		_g_free0 (commandline);
		_g_free0 (_tmp0_);
		return _tmp30_;
	}
	result = _tmp26_;
	argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	_g_object_unref0 (app);
	_g_free0 (commandline);
	_g_free0 (_tmp0_);
	return result;
}

void
photo_open_with_raw_external_editor (Photo* self,
                                     GError** error)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = _tmp0_;
	photo_launch_editor (_tmp1_, photo_get_master_file_format (self), &_inner_error0_);
	_g_object_unref0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
photo_open_with_external_editor (Photo* self,
                                 GError** error)
{
	GFile* current_editable_file = NULL;
	GFile* create_editable_file = NULL;
	PhotoFileFormat editable_file_format = 0;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	GFile* _tmp17_;
	gboolean _tmp23_ = FALSE;
	GFile* _tmp24_;
	GFile* _tmp38_;
	GFileMonitor* _tmp39_;
	GFile* _tmp41_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	current_editable_file = NULL;
	create_editable_file = NULL;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			GFile* _tmp6_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
				_g_object_unref0 (current_editable_file);
				current_editable_file = _tmp5_;
			}
			_tmp6_ = current_editable_file;
			if (_tmp6_ == NULL) {
				GFile* _tmp7_ = NULL;
				PhotoFileFormat _tmp8_ = 0;
				GFile* _tmp9_;
				GFile* _tmp10_;
				_tmp9_ = photo_generate_new_editable_file (self, &_tmp8_, &_inner_error0_);
				editable_file_format = _tmp8_;
				_tmp7_ = _tmp9_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp10_ = _tmp7_;
				_tmp7_ = NULL;
				_g_object_unref0 (create_editable_file);
				create_editable_file = _tmp10_;
				_g_object_unref0 (_tmp7_);
			} else {
				PhotoBackingReaders* _tmp11_;
				PhotoFileReader* _tmp12_;
				_tmp11_ = self->priv->readers;
				_tmp12_ = _tmp11_->editable;
				editable_file_format = photo_file_adapter_get_file_format (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* _lock_error_ = NULL;
			GError* _tmp13_;
			_lock_error_ = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = _lock_error_;
			_lock_error_ = NULL;
			_inner_error0_ = _tmp13_;
			_g_error_free0 (_lock_error_);
			goto __finally0;
		}
		__finally0:
		{
			GError* _inner_error1_ = NULL;
			PhotoBackingReaders* _tmp14_;
			_tmp14_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return;
		}
	}
	_tmp17_ = create_editable_file;
	if (_tmp17_ == NULL) {
		GFile* _tmp18_;
		_tmp18_ = current_editable_file;
		_tmp16_ = _tmp18_ != NULL;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gboolean _tmp19_ = FALSE;
		GFile* _tmp20_;
		_tmp20_ = current_editable_file;
		if (!g_file_query_exists (_tmp20_, NULL)) {
			_tmp19_ = TRUE;
		} else {
			_tmp19_ = photo_has_transformations (self);
		}
		_tmp15_ = _tmp19_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		GFile* _tmp21_;
		GFile* _tmp22_;
		_tmp21_ = current_editable_file;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		_g_object_unref0 (create_editable_file);
		create_editable_file = _tmp22_;
	}
	_tmp24_ = create_editable_file;
	if (_tmp24_ != NULL) {
		_tmp23_ = photo_file_format_can_write (editable_file_format);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		GFile* _tmp35_;
		GFile* _tmp36_;
		GFile* _tmp37_;
		photo_halt_monitoring_editable (self);
		{
			GFile* _tmp25_;
			Scaling _tmp26_ = {0};
			_tmp25_ = create_editable_file;
			scaling_for_original (&_tmp26_);
			photo_export (self, _tmp25_, &_tmp26_, JPEG_QUALITY_MAXIMUM, editable_file_format, FALSE, TRUE, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp33_;
			GError* _tmp34_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			{
				GFile* _tmp27_;
				_tmp27_ = create_editable_file;
				g_file_delete (_tmp27_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch2_g_error;
				}
			}
			goto __finally2;
			__catch2_g_error:
			{
				GError* delete_err = NULL;
				GFile* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				GError* _tmp31_;
				const gchar* _tmp32_;
				delete_err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp28_ = create_editable_file;
				_tmp29_ = g_file_get_path (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = delete_err;
				_tmp32_ = _tmp31_->message;
				g_warning ("Photo.vala:3891: Unable to delete editable file %s after export error:" \
" %s", _tmp30_, _tmp32_);
				_g_free0 (_tmp30_);
				_g_error_free0 (delete_err);
			}
			__finally2:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_error_free0 (err);
				_g_object_unref0 (create_editable_file);
				_g_object_unref0 (current_editable_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_tmp33_ = err;
			_tmp34_ = _g_error_copy0 (_tmp33_);
			_inner_error0_ = _tmp34_;
			_g_error_free0 (err);
			goto __finally1;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return;
		}
		_tmp35_ = create_editable_file;
		photo_attach_editable (self, editable_file_format, _tmp35_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return;
		}
		_tmp36_ = create_editable_file;
		_tmp37_ = _g_object_ref0 (_tmp36_);
		_g_object_unref0 (current_editable_file);
		current_editable_file = _tmp37_;
	}
	_tmp38_ = current_editable_file;
	_vala_assert (_tmp38_ != NULL, "current_editable_file != null");
	_tmp39_ = self->priv->editable_monitor;
	if (_tmp39_ == NULL) {
		GFile* _tmp40_;
		_tmp40_ = current_editable_file;
		photo_start_monitoring_editable (self, _tmp40_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (create_editable_file);
			_g_object_unref0 (current_editable_file);
			return;
		}
	}
	_tmp41_ = current_editable_file;
	photo_launch_editor (_tmp41_, photo_get_file_format (self), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (create_editable_file);
		_g_object_unref0 (current_editable_file);
		return;
	}
	_g_object_unref0 (create_editable_file);
	_g_object_unref0 (current_editable_file);
}

void
photo_revert_to_master (Photo* self,
                        gboolean notify)
{
	g_return_if_fail (IS_PHOTO (self));
	photo_detach_editable (self, TRUE, TRUE, notify);
}

static void
_photo_on_editable_file_changed_g_file_monitor_changed (GFileMonitor* _sender,
                                                        GFile* file,
                                                        GFile* other_file,
                                                        GFileMonitorEvent event_type,
                                                        gpointer self)
{
	photo_on_editable_file_changed ((Photo*) self, file, other_file, event_type);
}

static void
photo_start_monitoring_editable (Photo* self,
                                 GFile* file,
                                 GError** error)
{
	GFileMonitor* _tmp0_ = NULL;
	GFileMonitor* _tmp1_;
	GFileMonitor* _tmp2_;
	GFileMonitor* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	photo_halt_monitoring_editable (self);
	library_monitor_blacklist_file (file, "Photo.start_monitoring_editable");
	_tmp1_ = g_file_monitor (file, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	_g_object_unref0 (self->priv->editable_monitor);
	self->priv->editable_monitor = _tmp2_;
	_tmp3_ = self->priv->editable_monitor;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _photo_on_editable_file_changed_g_file_monitor_changed, self, 0);
	_g_object_unref0 (_tmp0_);
}

static void
photo_halt_monitoring_editable (Photo* self)
{
	GFileMonitor* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFileMonitor* _tmp4_;
	guint _tmp5_;
	GFileMonitor* _tmp6_;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = self->priv->editable_monitor;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = photo_get_editable_file (self);
	file = _tmp1_;
	_tmp2_ = file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		_tmp3_ = file;
		library_monitor_unblacklist_file (_tmp3_);
	}
	_tmp4_ = self->priv->editable_monitor;
	g_signal_parse_name ("changed", g_file_monitor_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _photo_on_editable_file_changed_g_file_monitor_changed, self);
	_tmp6_ = self->priv->editable_monitor;
	g_file_monitor_cancel (_tmp6_);
	_g_object_unref0 (self->priv->editable_monitor);
	self->priv->editable_monitor = NULL;
	_g_object_unref0 (file);
}

static void
photo_attach_editable (Photo* self,
                       PhotoFileFormat file_format,
                       GFile* file,
                       GError** error)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	photo_remove_all_transformations (self, FALSE);
	_tmp0_ = g_file_get_path (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = photo_file_format_create_reader (file_format, _tmp1_);
	_tmp3_ = _tmp2_;
	photo_update_editable (self, FALSE, _tmp3_, &_inner_error0_);
	_photo_file_adapter_unref0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
photo_update_editable_attributes (Photo* self,
                                  GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	photo_update_editable (self, TRUE, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

void
photo_reimport_editable (Photo* self,
                         GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	photo_update_editable (self, FALSE, NULL, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_vala_array_add102 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add103 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add104 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add105 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add106 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add107 (gchar** * array,
                    gint* length,
                    gint* size,
                    gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
photo_update_editable (Photo* self,
                       gboolean only_attributes,
                       PhotoFileReader* new_reader,
                       GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	PhotoFileReader* old_reader = NULL;
	PhotoFileReader* _tmp2_;
	PhotoFileReader* _tmp3_ = NULL;
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp5_;
	PhotoFileReader* _tmp6_;
	gboolean timestamp_changed = FALSE;
	gboolean filesize_changed = FALSE;
	gboolean is_new_editable = FALSE;
	BackingPhotoID editable_id = {0};
	BackingPhotoID _tmp7_ = {0};
	GFile* file = NULL;
	PhotoFileReader* _tmp8_;
	GFile* _tmp9_;
	DetectedPhotoInformation* detected = NULL;
	BackingPhotoRow* backing = NULL;
	GFile* _tmp10_;
	DetectedPhotoInformation* _tmp11_ = NULL;
	BackingPhotoRow* _tmp12_;
	gboolean _tmp83_ = FALSE;
	gchar** alteration_list = NULL;
	gchar** _tmp92_;
	gint alteration_list_length1;
	gint _alteration_list_size_;
	gboolean _tmp96_ = FALSE;
	gchar** _tmp100_;
	gint _tmp100__length1;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail ((new_reader == NULL) || IS_PHOTO_FILE_READER (new_reader));
	if (only_attributes) {
		_tmp1_ = new_reader == NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !only_attributes;
	}
	_vala_assert (_tmp0_, "(only_attributes && new_reader == null) || (!only_attributes)");
	_tmp2_ = photo_get_editable_reader (self);
	old_reader = _tmp2_;
	_tmp3_ = new_reader;
	if (_tmp3_ == NULL) {
		PhotoFileReader* _tmp4_;
		_tmp4_ = old_reader;
		_tmp3_ = _tmp4_;
	}
	_tmp5_ = _photo_file_adapter_ref0 (_tmp3_);
	reader = _tmp5_;
	_tmp6_ = reader;
	if (_tmp6_ == NULL) {
		photo_detach_editable (self, FALSE, TRUE, TRUE);
		_photo_file_adapter_unref0 (reader);
		_photo_file_adapter_unref0 (old_reader);
		return;
	}
	timestamp_changed = FALSE;
	filesize_changed = FALSE;
	is_new_editable = FALSE;
	photo_get_editable_id (self, &_tmp7_);
	editable_id = _tmp7_;
	_tmp8_ = reader;
	_tmp9_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	file = _tmp9_;
	_tmp10_ = file;
	_tmp12_ = photo_query_backing_photo_row (self, _tmp10_, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp11_, &_inner_error0_);
	_detected_photo_information_unref0 (detected);
	detected = _tmp11_;
	backing = _tmp12_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (file);
		_photo_file_adapter_unref0 (reader);
		_photo_file_adapter_unref0 (old_reader);
		return;
	}
	if (backing_photo_id_is_invalid (&editable_id)) {
		BackingPhotoRow* _tmp13_;
		_tmp13_ = backing;
		if (_tmp13_ != NULL) {
			BackingPhotoTable* _tmp14_;
			BackingPhotoTable* _tmp15_;
			BackingPhotoRow* _tmp16_;
			_tmp14_ = backing_photo_table_get_instance ();
			_tmp15_ = _tmp14_;
			_tmp16_ = backing;
			backing_photo_table_add (_tmp15_, _tmp16_, &_inner_error0_);
			_database_table_unref0 (_tmp15_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
			{
				PhotoRow* _tmp17_;
				_tmp17_ = self->row;
				g_rec_mutex_lock (&self->priv->__lock_row);
				{
					PhotoTable* _tmp18_;
					PhotoTable* _tmp19_;
					PhotoRow* _tmp20_;
					BackingPhotoRow* _tmp21_;
					BackingPhotoID _tmp22_;
					BackingPhotoRow* _tmp23_;
					BackingPhotoRow* _tmp24_;
					BackingPhotoRow* _tmp25_;
					BackingPhotoRow* _tmp26_;
					BackingPhotoRow* _tmp27_;
					timestamp_changed = TRUE;
					filesize_changed = TRUE;
					_tmp18_ = photo_table_get_instance ();
					_tmp19_ = _tmp18_;
					_tmp20_ = self->row;
					_tmp21_ = backing;
					_tmp22_ = _tmp21_->id;
					photo_table_attach_editable (_tmp19_, _tmp20_, &_tmp22_, &_inner_error0_);
					_database_table_unref0 (_tmp19_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp23_ = backing;
					_tmp24_ = _backing_photo_row_ref0 (_tmp23_);
					_backing_photo_row_unref0 (self->priv->editable);
					self->priv->editable = _tmp24_;
					_tmp25_ = self->priv->editable;
					_tmp26_ = _backing_photo_row_ref0 (_tmp25_);
					_backing_photo_row_unref0 (self->backing_photo_row);
					self->backing_photo_row = _tmp26_;
					_tmp27_ = self->backing_photo_row;
					photo_set_orientation (self, _tmp27_->original_orientation);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* _lock_error_ = NULL;
					GError* _tmp28_;
					_lock_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp28_ = _lock_error_;
					_lock_error_ = NULL;
					_inner_error0_ = _tmp28_;
					_g_error_free0 (_lock_error_);
					goto __finally0;
				}
				__finally0:
				{
					GError* _inner_error1_ = NULL;
					PhotoRow* _tmp29_;
					_tmp29_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_backing_photo_row_unref0 (backing);
					_detected_photo_information_unref0 (detected);
					_g_object_unref0 (file);
					_photo_file_adapter_unref0 (reader);
					_photo_file_adapter_unref0 (old_reader);
					return;
				}
			}
		}
		is_new_editable = TRUE;
	}
	if (only_attributes) {
		GFileInfo* info = NULL;
		GDateTime* timestamp = NULL;
		GFileInfo* _tmp38_;
		GDateTime* _tmp39_;
		GDateTime* _tmp40_;
		GDateTime* _tmp41_;
		GDateTime* _tmp42_;
		BackingPhotoTable* _tmp43_;
		BackingPhotoTable* _tmp44_;
		BackingPhotoID _tmp45_;
		GDateTime* _tmp46_;
		GFileInfo* _tmp47_;
		_vala_assert (backing_photo_id_is_valid (&editable_id), "editable_id.is_valid()");
		{
			GFileInfo* _tmp30_ = NULL;
			GFile* _tmp31_;
			GFileInfo* _tmp32_;
			GFileInfo* _tmp33_;
			_tmp31_ = file;
			_tmp32_ = g_file_query_filesystem_info (_tmp31_, DIRECTORY_MONITOR_SUPPLIED_ATTRIBUTES, NULL, &_inner_error0_);
			_tmp30_ = _tmp32_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp33_ = _tmp30_;
			_tmp30_ = NULL;
			_g_object_unref0 (info);
			info = _tmp33_;
			_g_object_unref0 (_tmp30_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_;
			GError* _tmp36_;
			const gchar* _tmp37_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp34_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
			_tmp35_ = _tmp34_;
			_tmp36_ = err;
			_tmp37_ = _tmp36_->message;
			g_warning ("Photo.vala:4010: Unable to read editable filesystem info for %s: %s", _tmp35_, _tmp37_);
			_g_free0 (_tmp35_);
			photo_detach_editable (self, FALSE, TRUE, TRUE);
			_g_error_free0 (err);
			_g_object_unref0 (info);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_file_adapter_unref0 (reader);
			_photo_file_adapter_unref0 (old_reader);
			return;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_file_adapter_unref0 (reader);
			_photo_file_adapter_unref0 (old_reader);
			return;
		}
		_tmp38_ = info;
		_tmp39_ = g_file_info_get_modification_date_time (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = coarsify_date_time (_tmp40_);
		_tmp42_ = _tmp41_;
		_g_date_time_unref0 (_tmp40_);
		timestamp = _tmp42_;
		_tmp43_ = backing_photo_table_get_instance ();
		_tmp44_ = _tmp43_;
		_tmp45_ = editable_id;
		_tmp46_ = timestamp;
		_tmp47_ = info;
		backing_photo_table_update_attributes (_tmp44_, &_tmp45_, _tmp46_, g_file_info_get_size (_tmp47_), &_inner_error0_);
		_database_table_unref0 (_tmp44_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_date_time_unref0 (timestamp);
			_g_object_unref0 (info);
			_backing_photo_row_unref0 (backing);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (file);
			_photo_file_adapter_unref0 (reader);
			_photo_file_adapter_unref0 (old_reader);
			return;
		}
		{
			PhotoRow* _tmp48_;
			_tmp48_ = self->row;
			g_rec_mutex_lock (&self->priv->__lock_row);
			{
				BackingPhotoRow* _tmp49_;
				GDateTime* _tmp50_;
				GDateTime* _tmp51_;
				BackingPhotoRow* _tmp52_;
				GFileInfo* _tmp53_;
				BackingPhotoRow* _tmp54_;
				GDateTime* _tmp55_;
				GDateTime* _tmp56_;
				BackingPhotoRow* _tmp57_;
				GFileInfo* _tmp58_;
				_tmp49_ = self->priv->editable;
				_tmp50_ = _tmp49_->timestamp;
				_tmp51_ = timestamp;
				timestamp_changed = !g_date_time_equal (_tmp50_, _tmp51_);
				_tmp52_ = self->priv->editable;
				_tmp53_ = info;
				filesize_changed = _tmp52_->filesize != g_file_info_get_size (_tmp53_);
				_tmp54_ = self->priv->editable;
				_tmp55_ = timestamp;
				_tmp56_ = _g_date_time_ref0 (_tmp55_);
				_g_date_time_unref0 (_tmp54_->timestamp);
				_tmp54_->timestamp = _tmp56_;
				_tmp57_ = self->priv->editable;
				_tmp58_ = info;
				_tmp57_->filesize = g_file_info_get_size (_tmp58_);
			}
			__finally2:
			{
				PhotoRow* _tmp59_;
				_tmp59_ = self->row;
				g_rec_mutex_unlock (&self->priv->__lock_row);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_date_time_unref0 (timestamp);
				_g_object_unref0 (info);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
		}
		_g_date_time_unref0 (timestamp);
		_g_object_unref0 (info);
	} else {
		gboolean _tmp60_ = FALSE;
		if (backing_photo_id_is_valid (&editable_id)) {
			_tmp60_ = !is_new_editable;
		} else {
			_tmp60_ = FALSE;
		}
		if (_tmp60_) {
			BackingPhotoRow* _tmp61_;
			BackingPhotoID _tmp62_;
			BackingPhotoTable* _tmp63_;
			BackingPhotoTable* _tmp64_;
			BackingPhotoRow* _tmp65_;
			_tmp61_ = backing;
			_tmp62_ = editable_id;
			_tmp61_->id = _tmp62_;
			_tmp63_ = backing_photo_table_get_instance ();
			_tmp64_ = _tmp63_;
			_tmp65_ = backing;
			backing_photo_table_update (_tmp64_, _tmp65_, &_inner_error0_);
			_database_table_unref0 (_tmp64_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
			{
				PhotoRow* _tmp66_;
				_tmp66_ = self->row;
				g_rec_mutex_lock (&self->priv->__lock_row);
				{
					BackingPhotoRow* _tmp67_;
					GDateTime* _tmp68_;
					BackingPhotoRow* _tmp69_;
					GDateTime* _tmp70_;
					BackingPhotoRow* _tmp71_;
					BackingPhotoRow* _tmp72_;
					BackingPhotoRow* _tmp73_;
					BackingPhotoRow* _tmp74_;
					BackingPhotoRow* _tmp75_;
					BackingPhotoRow* _tmp76_;
					BackingPhotoRow* _tmp77_;
					_tmp67_ = self->priv->editable;
					_tmp68_ = _tmp67_->timestamp;
					_tmp69_ = backing;
					_tmp70_ = _tmp69_->timestamp;
					timestamp_changed = _tmp68_ != _tmp70_;
					_tmp71_ = self->priv->editable;
					_tmp72_ = backing;
					filesize_changed = _tmp71_->filesize != _tmp72_->filesize;
					_tmp73_ = backing;
					_tmp74_ = _backing_photo_row_ref0 (_tmp73_);
					_backing_photo_row_unref0 (self->priv->editable);
					self->priv->editable = _tmp74_;
					_tmp75_ = self->priv->editable;
					_tmp76_ = _backing_photo_row_ref0 (_tmp75_);
					_backing_photo_row_unref0 (self->backing_photo_row);
					self->backing_photo_row = _tmp76_;
					_tmp77_ = self->backing_photo_row;
					photo_set_orientation (self, _tmp77_->original_orientation);
				}
				__finally3:
				{
					PhotoRow* _tmp78_;
					_tmp78_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_backing_photo_row_unref0 (backing);
					_detected_photo_information_unref0 (detected);
					_g_object_unref0 (file);
					_photo_file_adapter_unref0 (reader);
					_photo_file_adapter_unref0 (old_reader);
					return;
				}
			}
		}
	}
	if (new_reader != NULL) {
		{
			PhotoBackingReaders* _tmp79_;
			_tmp79_ = self->priv->readers;
			g_rec_mutex_lock (&self->priv->__lock_readers);
			{
				PhotoBackingReaders* _tmp80_;
				PhotoFileReader* _tmp81_;
				_tmp80_ = self->priv->readers;
				_tmp81_ = _photo_file_adapter_ref0 (new_reader);
				_photo_file_adapter_unref0 (_tmp80_->editable);
				_tmp80_->editable = _tmp81_;
			}
			__finally4:
			{
				PhotoBackingReaders* _tmp82_;
				_tmp82_ = self->priv->readers;
				g_rec_mutex_unlock (&self->priv->__lock_readers);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (backing);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (file);
				_photo_file_adapter_unref0 (reader);
				_photo_file_adapter_unref0 (old_reader);
				return;
			}
		}
	}
	if (!only_attributes) {
		PhotoFileReader* _tmp84_;
		PhotoFileReader* _tmp85_;
		_tmp84_ = reader;
		_tmp85_ = old_reader;
		_tmp83_ = _tmp84_ != _tmp85_;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		GFile* _tmp86_ = NULL;
		PhotoFileReader* _tmp87_;
		GFile* _tmp90_ = NULL;
		photo_notify_baseline_replaced (self);
		_tmp87_ = old_reader;
		if (_tmp87_ != NULL) {
			PhotoFileReader* _tmp88_;
			GFile* _tmp89_;
			_tmp88_ = old_reader;
			_tmp89_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			_g_object_unref0 (_tmp86_);
			_tmp86_ = _tmp89_;
		} else {
			_g_object_unref0 (_tmp86_);
			_tmp86_ = NULL;
		}
		if (new_reader != NULL) {
			GFile* _tmp91_;
			_tmp91_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (new_reader, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			_g_object_unref0 (_tmp90_);
			_tmp90_ = _tmp91_;
		} else {
			_g_object_unref0 (_tmp90_);
			_tmp90_ = NULL;
		}
		photo_notify_editable_replaced (self, _tmp86_, _tmp90_);
		_g_object_unref0 (_tmp90_);
		_g_object_unref0 (_tmp86_);
	}
	_tmp92_ = g_new0 (gchar*, 0 + 1);
	alteration_list = _tmp92_;
	alteration_list_length1 = 0;
	_alteration_list_size_ = alteration_list_length1;
	if (timestamp_changed) {
		gchar* _tmp93_;
		gchar* _tmp94_;
		_tmp93_ = g_strdup ("metadata:editable-timestamp");
		_vala_array_add102 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp93_);
		_tmp94_ = g_strdup ("metadata:baseline-timestamp");
		_vala_array_add103 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp94_);
		if (photo_is_editable_source (self)) {
			gchar* _tmp95_;
			_tmp95_ = g_strdup ("metadata:source-timestamp");
			_vala_array_add104 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp95_);
		}
	}
	if (filesize_changed) {
		_tmp96_ = TRUE;
	} else {
		_tmp96_ = new_reader != NULL;
	}
	if (_tmp96_) {
		gchar* _tmp97_;
		gchar* _tmp98_;
		_tmp97_ = g_strdup ("image:editable");
		_vala_array_add105 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp97_);
		_tmp98_ = g_strdup ("image:baseline");
		_vala_array_add106 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp98_);
		if (photo_is_editable_source (self)) {
			gchar* _tmp99_;
			_tmp99_ = g_strdup ("image:source");
			_vala_array_add107 (&alteration_list, &alteration_list_length1, &_alteration_list_size_, _tmp99_);
		}
	}
	_tmp100_ = alteration_list;
	_tmp100__length1 = alteration_list_length1;
	if (_tmp100__length1 > 0) {
		gchar** _tmp101_;
		gint _tmp101__length1;
		Alteration* _tmp102_;
		Alteration* _tmp103_;
		_tmp101_ = alteration_list;
		_tmp101__length1 = alteration_list_length1;
		_tmp102_ = alteration_new_from_array (_tmp101_, _tmp101__length1);
		_tmp103_ = _tmp102_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp103_);
		_alteration_unref0 (_tmp103_);
	}
	alteration_list = (_vala_array_free (alteration_list, alteration_list_length1, (GDestroyNotify) g_free), NULL);
	_backing_photo_row_unref0 (backing);
	_detected_photo_information_unref0 (detected);
	_g_object_unref0 (file);
	_photo_file_adapter_unref0 (reader);
	_photo_file_adapter_unref0 (old_reader);
}

static void
photo_detach_editable (Photo* self,
                       gboolean delete_editable,
                       gboolean remove_transformations,
                       gboolean notify)
{
	gboolean has_editable = FALSE;
	GFile* editable_file = NULL;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp37_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	photo_halt_monitoring_editable (self);
	has_editable = FALSE;
	editable_file = NULL;
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			if (_tmp2_ != NULL) {
				PhotoBackingReaders* _tmp3_;
				PhotoFileReader* _tmp4_;
				GFile* _tmp5_;
				PhotoBackingReaders* _tmp6_;
				_tmp3_ = self->priv->readers;
				_tmp4_ = _tmp3_->editable;
				_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
				_g_object_unref0 (editable_file);
				editable_file = _tmp5_;
				_tmp6_ = self->priv->readers;
				_photo_file_adapter_unref0 (_tmp6_->editable);
				_tmp6_->editable = NULL;
				has_editable = TRUE;
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp7_;
			_tmp7_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (has_editable) {
		BackingPhotoID editable_id = {0};
		backing_photo_id_init (&editable_id, BACKING_PHOTO_ID_INVALID);
		{
			{
				PhotoRow* _tmp8_;
				_tmp8_ = self->row;
				g_rec_mutex_lock (&self->priv->__lock_row);
				{
					PhotoRow* _tmp9_;
					BackingPhotoID _tmp10_;
					PhotoRow* _tmp14_;
					BackingPhotoRow* _tmp15_;
					BackingPhotoRow* _tmp16_;
					_tmp9_ = self->row;
					_tmp10_ = _tmp9_->editable_id;
					editable_id = _tmp10_;
					if (backing_photo_id_is_valid (&editable_id)) {
						PhotoTable* _tmp11_;
						PhotoTable* _tmp12_;
						PhotoRow* _tmp13_;
						_tmp11_ = photo_table_get_instance ();
						_tmp12_ = _tmp11_;
						_tmp13_ = self->row;
						photo_table_detach_editable (_tmp12_, _tmp13_, &_inner_error0_);
						_database_table_unref0 (_tmp12_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							goto __catch2_g_error;
						}
					}
					_tmp14_ = self->row;
					_tmp15_ = _tmp14_->master;
					_tmp16_ = _backing_photo_row_ref0 (_tmp15_);
					_backing_photo_row_unref0 (self->backing_photo_row);
					self->backing_photo_row = _tmp16_;
				}
				goto __finally2;
				__catch2_g_error:
				{
					GError* _lock_error_ = NULL;
					GError* _tmp17_;
					_lock_error_ = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp17_ = _lock_error_;
					_lock_error_ = NULL;
					_inner_error0_ = _tmp17_;
					_g_error_free0 (_lock_error_);
					goto __finally2;
				}
				__finally2:
				{
					GError* _inner_error1_ = NULL;
					PhotoRow* _tmp18_;
					_tmp18_ = self->row;
					g_rec_mutex_unlock (&self->priv->__lock_row);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GError* _tmp19_;
			const gchar* _tmp20_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp19_ = err;
			_tmp20_ = _tmp19_->message;
			g_warning ("Photo.vala:4104: Unable to remove editable from PhotoTable: %s", _tmp20_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		{
			if (backing_photo_id_is_valid (&editable_id)) {
				BackingPhotoTable* _tmp21_;
				BackingPhotoTable* _tmp22_;
				BackingPhotoID _tmp23_;
				_tmp21_ = backing_photo_table_get_instance ();
				_tmp22_ = _tmp21_;
				_tmp23_ = editable_id;
				backing_photo_table_remove (_tmp22_, &_tmp23_, &_inner_error0_);
				_database_table_unref0 (_tmp22_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch3_database_error;
					}
					_g_object_unref0 (editable_file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
		goto __finally3;
		__catch3_database_error:
		{
			GError* err = NULL;
			GError* _tmp24_;
			const gchar* _tmp25_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp24_ = err;
			_tmp25_ = _tmp24_->message;
			g_warning ("Photo.vala:4111: Unable to remove editable from BackingPhotoTable: %s", _tmp25_);
			_g_error_free0 (err);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (remove_transformations) {
		photo_remove_all_transformations (self, FALSE);
	}
	if (has_editable) {
		GFile* _tmp26_;
		photo_notify_baseline_replaced (self);
		_tmp26_ = editable_file;
		photo_notify_editable_replaced (self, _tmp26_, NULL);
	}
	if (delete_editable) {
		GFile* _tmp28_;
		_tmp28_ = editable_file;
		_tmp27_ = _tmp28_ != NULL;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		{
			GFile* _tmp29_;
			_tmp29_ = editable_file;
			g_file_trash (_tmp29_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* err = NULL;
			GFile* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			GError* _tmp35_;
			const gchar* _tmp36_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp30_ = editable_file;
			_tmp31_ = g_file_get_path (_tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
			_tmp34_ = _tmp33_;
			_tmp35_ = err;
			_tmp36_ = _tmp35_->message;
			g_warning ("Photo.vala:4127: Unable to trash editable %s for %s: %s", _tmp32_, _tmp34_, _tmp36_);
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_error_free0 (err);
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (editable_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	if (has_editable) {
		_tmp38_ = TRUE;
	} else {
		_tmp38_ = remove_transformations;
	}
	if (_tmp38_) {
		_tmp37_ = notify;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		Alteration* _tmp39_;
		Alteration* _tmp40_;
		_tmp39_ = alteration_new ("image", "revert");
		_tmp40_ = _tmp39_;
		data_object_notify_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject), _tmp40_);
		_alteration_unref0 (_tmp40_);
	}
	_g_object_unref0 (editable_file);
}

static void
_photo_on_reimport_editable_one_shot_callback (gpointer self)
{
	photo_on_reimport_editable ((Photo*) self);
}

static void
_photo_on_update_editable_attributes_one_shot_callback (gpointer self)
{
	photo_on_update_editable_attributes ((Photo*) self);
}

static void
_photo_on_remove_editable_one_shot_callback (gpointer self)
{
	photo_on_remove_editable ((Photo*) self);
}

static void
photo_on_editable_file_changed (Photo* self,
                                GFile* file,
                                GFile* other_file,
                                GFileMonitorEvent event)
{
	GEnumValue* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	g_return_if_fail ((other_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (other_file, g_file_get_type ()));
	{
		PhotoBackingReaders* _tmp0_;
		_tmp0_ = self->priv->readers;
		g_rec_mutex_lock (&self->priv->__lock_readers);
		{
			PhotoBackingReaders* _tmp1_;
			PhotoFileReader* _tmp2_;
			PhotoBackingReaders* _tmp3_;
			PhotoFileReader* _tmp4_;
			GFile* _tmp5_;
			GFile* _tmp6_;
			gboolean _tmp7_;
			_tmp1_ = self->priv->readers;
			_tmp2_ = _tmp1_->editable;
			_vala_assert (_tmp2_ != NULL, "readers.editable != null");
			_tmp3_ = self->priv->readers;
			_tmp4_ = _tmp3_->editable;
			_tmp5_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
			_tmp6_ = _tmp5_;
			_tmp7_ = !g_file_equal (file, _tmp6_);
			_g_object_unref0 (_tmp6_);
			if (_tmp7_) {
				{
					PhotoBackingReaders* _tmp8_;
					_tmp8_ = self->priv->readers;
					g_rec_mutex_unlock (&self->priv->__lock_readers);
				}
				return;
			}
		}
		__finally0:
		{
			PhotoBackingReaders* _tmp9_;
			_tmp9_ = self->priv->readers;
			g_rec_mutex_unlock (&self->priv->__lock_readers);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp10_ = g_enum_get_value (g_type_class_ref (g_file_monitor_event_get_type ()), event);
	_tmp11_ = g_file_get_path (file);
	_tmp12_ = _tmp11_;
	g_debug ("Photo.vala:4149: EDITABLE %s: %s", (_tmp10_ != NULL) ? _tmp10_->value_name : NULL, _tmp12_);
	_g_free0 (_tmp12_);
	switch (event) {
		case G_FILE_MONITOR_EVENT_CHANGED:
		case G_FILE_MONITOR_EVENT_CREATED:
		{
			OneShotScheduler* _tmp13_;
			OneShotScheduler* _tmp15_;
			_tmp13_ = self->priv->reimport_editable_scheduler;
			if (_tmp13_ == NULL) {
				OneShotScheduler* _tmp14_;
				_tmp14_ = one_shot_scheduler_new ("Photo.reimport_editable", _photo_on_reimport_editable_one_shot_callback, self);
				_one_shot_scheduler_unref0 (self->priv->reimport_editable_scheduler);
				self->priv->reimport_editable_scheduler = _tmp14_;
			}
			_tmp15_ = self->priv->reimport_editable_scheduler;
			one_shot_scheduler_after_timeout (_tmp15_, (guint) 1000, TRUE);
			break;
		}
		case G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED:
		{
			OneShotScheduler* _tmp16_;
			OneShotScheduler* _tmp18_;
			_tmp16_ = self->priv->update_editable_attributes_scheduler;
			if (_tmp16_ == NULL) {
				OneShotScheduler* _tmp17_;
				_tmp17_ = one_shot_scheduler_new ("Photo.update_editable_attributes", _photo_on_update_editable_attributes_one_shot_callback, self);
				_one_shot_scheduler_unref0 (self->priv->update_editable_attributes_scheduler);
				self->priv->update_editable_attributes_scheduler = _tmp17_;
			}
			_tmp18_ = self->priv->update_editable_attributes_scheduler;
			one_shot_scheduler_after_timeout (_tmp18_, (guint) 1000, TRUE);
			break;
		}
		case G_FILE_MONITOR_EVENT_DELETED:
		{
			OneShotScheduler* _tmp19_;
			OneShotScheduler* _tmp21_;
			_tmp19_ = self->priv->remove_editable_scheduler;
			if (_tmp19_ == NULL) {
				OneShotScheduler* _tmp20_;
				_tmp20_ = one_shot_scheduler_new ("Photo.remove_editable", _photo_on_remove_editable_one_shot_callback, self);
				_one_shot_scheduler_unref0 (self->priv->remove_editable_scheduler);
				self->priv->remove_editable_scheduler = _tmp20_;
			}
			_tmp21_ = self->priv->remove_editable_scheduler;
			one_shot_scheduler_after_timeout (_tmp21_, (guint) 3000, TRUE);
			break;
		}
		default:
		case G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT:
		{
			break;
		}
	}
	photo_discard_prefetched (self);
}

static void
photo_on_reimport_editable (Photo* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	photo_discard_prefetched (self);
	_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	g_debug ("Photo.vala:4195: Reimporting editable for %s", _tmp1_);
	_g_free0 (_tmp1_);
	{
		photo_reimport_editable (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp3_ = _tmp2_;
		_tmp4_ = err;
		_tmp5_ = _tmp4_->message;
		g_warning ("Photo.vala:4199: Unable to reimport photo %s changed by external edito" \
"r: %s", _tmp3_, _tmp5_);
		_g_free0 (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_on_update_editable_attributes (Photo* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp1_ = _tmp0_;
	g_debug ("Photo.vala:4205: Updating editable attributes for %s", _tmp1_);
	_g_free0 (_tmp1_);
	{
		photo_update_editable_attributes (self, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Photo.vala:4209: Unable to update editable attributes: %s", _tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
photo_on_remove_editable (Photo* self)
{
	PhotoFileReader* reader = NULL;
	PhotoFileReader* _tmp0_;
	PhotoFileReader* _tmp1_;
	GFile* file = NULL;
	PhotoFileReader* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (IS_PHOTO (self));
	_tmp0_ = photo_get_editable_reader (self);
	reader = _tmp0_;
	_tmp1_ = reader;
	if (_tmp1_ == NULL) {
		_photo_file_adapter_unref0 (reader);
		return;
	}
	_tmp2_ = reader;
	_tmp3_ = photo_file_adapter_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_PHOTO_FILE_ADAPTER, PhotoFileAdapter));
	file = _tmp3_;
	_tmp4_ = file;
	if (g_file_query_exists (_tmp4_, NULL)) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp6_ = _tmp5_;
		g_debug ("Photo.vala:4220: Not removing editable for %s: file exists", _tmp6_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (file);
		_photo_file_adapter_unref0 (reader);
		return;
	}
	_tmp7_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
	_tmp8_ = _tmp7_;
	g_debug ("Photo.vala:4225: Removing editable for %s: file no longer exists", _tmp8_);
	_g_free0 (_tmp8_);
	photo_detach_editable (self, FALSE, TRUE, TRUE);
	_g_object_unref0 (file);
	_photo_file_adapter_unref0 (reader);
}

void
photo_get_original_dimensions (Photo* self,
                               Dimensions* result)
{
	Dimensions dim = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (IS_PHOTO (self));
	photo_get_raw_dimensions (self, &_tmp0_);
	dim = _tmp0_;
	orientation = photo_get_orientation (self);
	_tmp1_ = dim;
	orientation_rotate_dimensions (orientation, &_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

void
photo_get_master_dimensions (Photo* self,
                             Dimensions* result)
{
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	g_return_if_fail (IS_PHOTO (self));
	photo_get_raw_dimensions (self, &_tmp0_);
	orientation_rotate_dimensions (photo_get_original_orientation (self), &_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

gboolean
photo_get_crop (Photo* self,
                Box* crop,
                PhotoException exceptions)
{
	Box _vala_crop = {0};
	Box raw = {0};
	Box _tmp0_ = {0};
	gboolean _tmp1_;
	Dimensions dim = {0};
	Dimensions _tmp2_ = {0};
	Orientation orientation = 0;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_tmp1_ = photo_get_raw_crop (self, &_tmp0_);
	raw = _tmp0_;
	if (!_tmp1_) {
		box_init (&_vala_crop, 0, 0, 0, 0);
		result = FALSE;
		if (crop) {
			*crop = _vala_crop;
		}
		return result;
	}
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_ORIENTATION, &_tmp2_);
	dim = _tmp2_;
	orientation = photo_get_orientation (self);
	if (photo_exception_allows (exceptions, PHOTO_EXCEPTION_ORIENTATION)) {
		Dimensions _tmp3_;
		Box _tmp4_;
		Box _tmp5_ = {0};
		_tmp3_ = dim;
		_tmp4_ = raw;
		orientation_rotate_box (orientation, &_tmp3_, &_tmp4_, &_tmp5_);
		_vala_crop = _tmp5_;
	} else {
		Box _tmp6_;
		_tmp6_ = raw;
		_vala_crop = _tmp6_;
	}
	result = TRUE;
	if (crop) {
		*crop = _vala_crop;
	}
	return result;
}

void
photo_set_crop (Photo* self,
                Box* crop)
{
	Dimensions dim = {0};
	Dimensions _tmp0_ = {0};
	Orientation orientation = 0;
	Box derotated = {0};
	Dimensions _tmp1_;
	Box _tmp2_;
	Box _tmp3_ = {0};
	Box _tmp4_;
	Dimensions _tmp5_;
	Box _tmp6_;
	Box _tmp7_;
	Dimensions _tmp8_;
	Box _tmp9_;
	Dimensions _tmp10_;
	Box _tmp11_;
	Box _tmp12_;
	Dimensions _tmp13_;
	Box _tmp14_;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (crop != NULL);
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_CROP | PHOTO_EXCEPTION_ORIENTATION, &_tmp0_);
	dim = _tmp0_;
	orientation = photo_get_orientation (self);
	_tmp1_ = dim;
	_tmp2_ = *crop;
	orientation_derotate_box (orientation, &_tmp1_, &_tmp2_, &_tmp3_);
	derotated = _tmp3_;
	_tmp4_ = derotated;
	_tmp5_ = dim;
	derotated.left = CLAMP (_tmp4_.left, 0, _tmp5_.width - 2);
	_tmp6_ = derotated;
	_tmp7_ = derotated;
	_tmp8_ = dim;
	derotated.right = CLAMP (_tmp6_.right, _tmp7_.left, _tmp8_.width - 1);
	_tmp9_ = derotated;
	_tmp10_ = dim;
	derotated.top = CLAMP (_tmp9_.top, 0, _tmp10_.height - 2);
	_tmp11_ = derotated;
	_tmp12_ = derotated;
	_tmp13_ = dim;
	derotated.bottom = CLAMP (_tmp11_.bottom, _tmp12_.top, _tmp13_.height - 1);
	_tmp14_ = derotated;
	photo_set_raw_crop (self, &_tmp14_);
}

gboolean
photo_get_straighten (Photo* self,
                      gdouble* theta)
{
	gdouble _vala_theta = 0.0;
	gdouble _tmp0_ = 0.0;
	gboolean _tmp1_;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_tmp1_ = photo_get_raw_straighten (self, &_tmp0_);
	_vala_theta = _tmp0_;
	if (!_tmp1_) {
		result = FALSE;
		if (theta) {
			*theta = _vala_theta;
		}
		return result;
	}
	result = TRUE;
	if (theta) {
		*theta = _vala_theta;
	}
	return result;
}

void
photo_set_straighten (Photo* self,
                      gdouble theta)
{
	g_return_if_fail (IS_PHOTO (self));
	photo_set_raw_straighten (self, theta);
}

static GdkPixbuf*
photo_do_redeye (Photo* self,
                 GdkPixbuf* pixbuf,
                 EditingToolsRedeyeInstance* inst)
{
	gdouble r = 0.0;
	EditingToolsRedeyeInstance _tmp0_;
	gint* x_insets_first_quadrant = NULL;
	EditingToolsRedeyeInstance _tmp1_;
	gint* _tmp2_;
	gint x_insets_first_quadrant_length1;
	gint _x_insets_first_quadrant_size_;
	gint i = 0;
	gint x_bounds_min = 0;
	EditingToolsRedeyeInstance _tmp7_;
	GdkPoint _tmp8_;
	EditingToolsRedeyeInstance _tmp9_;
	gint x_bounds_max = 0;
	EditingToolsRedeyeInstance _tmp10_;
	GdkPoint _tmp11_;
	EditingToolsRedeyeInstance _tmp12_;
	gint ymin = 0;
	EditingToolsRedeyeInstance _tmp13_;
	GdkPoint _tmp14_;
	EditingToolsRedeyeInstance _tmp15_;
	gint _tmp16_ = 0;
	gint ymax = 0;
	EditingToolsRedeyeInstance _tmp17_;
	GdkPoint _tmp18_;
	gint _tmp19_ = 0;
	gint _tmp20_;
	gint _tmp21_;
	gint inset_index = 0;
	EditingToolsRedeyeInstance _tmp41_;
	GdkPoint _tmp42_;
	EditingToolsRedeyeInstance _tmp43_;
	GdkPoint _tmp44_;
	EditingToolsRedeyeInstance _tmp45_;
	gint* _tmp46_;
	gint _tmp46__length1;
	GdkPixbuf* _tmp64_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	g_return_val_if_fail (inst != NULL, NULL);
	_tmp0_ = *inst;
	r = (gdouble) _tmp0_.radius;
	_tmp1_ = *inst;
	_tmp2_ = g_new0 (gint, _tmp1_.radius + 1);
	x_insets_first_quadrant = _tmp2_;
	x_insets_first_quadrant_length1 = _tmp1_.radius + 1;
	_x_insets_first_quadrant_size_ = x_insets_first_quadrant_length1;
	i = 0;
	{
		gdouble y = 0.0;
		y = r;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gdouble theta = 0.0;
				gint x = 0;
				gint* _tmp4_;
				gint _tmp4__length1;
				EditingToolsRedeyeInstance _tmp5_;
				gint _tmp6_;
				if (!_tmp3_) {
					y -= 1.0;
				}
				_tmp3_ = FALSE;
				if (!(y >= 0.0)) {
					break;
				}
				theta = asin (y / r);
				x = (gint) ((r * cos (theta)) + 0.5);
				_tmp4_ = x_insets_first_quadrant;
				_tmp4__length1 = x_insets_first_quadrant_length1;
				_tmp5_ = *inst;
				_tmp4_[i] = _tmp5_.radius - x;
				_tmp6_ = i;
				i = _tmp6_ + 1;
			}
		}
	}
	_tmp7_ = *inst;
	_tmp8_ = _tmp7_.center;
	_tmp9_ = *inst;
	x_bounds_min = _tmp8_.x - _tmp9_.radius;
	_tmp10_ = *inst;
	_tmp11_ = _tmp10_.center;
	_tmp12_ = *inst;
	x_bounds_max = _tmp11_.x + _tmp12_.radius;
	_tmp13_ = *inst;
	_tmp14_ = _tmp13_.center;
	_tmp15_ = *inst;
	ymin = _tmp14_.y - _tmp15_.radius;
	if (ymin < 0) {
		_tmp16_ = 0;
	} else {
		_tmp16_ = ymin;
	}
	ymin = _tmp16_;
	_tmp17_ = *inst;
	_tmp18_ = _tmp17_.center;
	ymax = _tmp18_.y;
	_tmp20_ = gdk_pixbuf_get_height (pixbuf);
	_tmp21_ = _tmp20_;
	if (ymax > (_tmp21_ - 1)) {
		gint _tmp22_;
		gint _tmp23_;
		_tmp22_ = gdk_pixbuf_get_height (pixbuf);
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_ - 1;
	} else {
		_tmp19_ = ymax;
	}
	ymax = _tmp19_;
	inset_index = 0;
	{
		gint y_it = 0;
		y_it = ymin;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint xmin = 0;
				gint* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				gint _tmp28_ = 0;
				gint xmax = 0;
				gint* _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				gint _tmp31_ = 0;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp40_;
				if (!_tmp24_) {
					gint _tmp25_;
					_tmp25_ = y_it;
					y_it = _tmp25_ + 1;
				}
				_tmp24_ = FALSE;
				if (!(y_it <= ymax)) {
					break;
				}
				_tmp26_ = x_insets_first_quadrant;
				_tmp26__length1 = x_insets_first_quadrant_length1;
				_tmp27_ = _tmp26_[inset_index];
				xmin = x_bounds_min + _tmp27_;
				if (xmin < 0) {
					_tmp28_ = 0;
				} else {
					_tmp28_ = xmin;
				}
				xmin = _tmp28_;
				_tmp29_ = x_insets_first_quadrant;
				_tmp29__length1 = x_insets_first_quadrant_length1;
				_tmp30_ = _tmp29_[inset_index];
				xmax = x_bounds_max - _tmp30_;
				_tmp32_ = gdk_pixbuf_get_width (pixbuf);
				_tmp33_ = _tmp32_;
				if (xmax > (_tmp33_ - 1)) {
					gint _tmp34_;
					gint _tmp35_;
					_tmp34_ = gdk_pixbuf_get_width (pixbuf);
					_tmp35_ = _tmp34_;
					_tmp31_ = _tmp35_ - 1;
				} else {
					_tmp31_ = xmax;
				}
				xmax = _tmp31_;
				{
					gint x_it = 0;
					x_it = xmin;
					{
						gboolean _tmp36_ = FALSE;
						_tmp36_ = TRUE;
						while (TRUE) {
							GdkPixbuf* _tmp38_;
							GdkPixbuf* _tmp39_;
							if (!_tmp36_) {
								gint _tmp37_;
								_tmp37_ = x_it;
								x_it = _tmp37_ + 1;
							}
							_tmp36_ = FALSE;
							if (!(x_it <= xmax)) {
								break;
							}
							_tmp38_ = photo_red_reduce_pixel (self, pixbuf, x_it, y_it);
							_tmp39_ = _tmp38_;
							_g_object_unref0 (_tmp39_);
						}
					}
				}
				_tmp40_ = inset_index;
				inset_index = _tmp40_ + 1;
			}
		}
	}
	_tmp41_ = *inst;
	_tmp42_ = _tmp41_.center;
	ymin = _tmp42_.y;
	_tmp43_ = *inst;
	_tmp44_ = _tmp43_.center;
	_tmp45_ = *inst;
	ymax = _tmp44_.y + _tmp45_.radius;
	_tmp46_ = x_insets_first_quadrant;
	_tmp46__length1 = x_insets_first_quadrant_length1;
	inset_index = _tmp46__length1 - 1;
	{
		gint y_it = 0;
		y_it = ymin;
		{
			gboolean _tmp47_ = FALSE;
			_tmp47_ = TRUE;
			while (TRUE) {
				gint xmin = 0;
				gint* _tmp49_;
				gint _tmp49__length1;
				gint _tmp50_;
				gint _tmp51_ = 0;
				gint xmax = 0;
				gint* _tmp52_;
				gint _tmp52__length1;
				gint _tmp53_;
				gint _tmp54_ = 0;
				gint _tmp55_;
				gint _tmp56_;
				gint _tmp63_;
				if (!_tmp47_) {
					gint _tmp48_;
					_tmp48_ = y_it;
					y_it = _tmp48_ + 1;
				}
				_tmp47_ = FALSE;
				if (!(y_it <= ymax)) {
					break;
				}
				_tmp49_ = x_insets_first_quadrant;
				_tmp49__length1 = x_insets_first_quadrant_length1;
				_tmp50_ = _tmp49_[inset_index];
				xmin = x_bounds_min + _tmp50_;
				if (xmin < 0) {
					_tmp51_ = 0;
				} else {
					_tmp51_ = xmin;
				}
				xmin = _tmp51_;
				_tmp52_ = x_insets_first_quadrant;
				_tmp52__length1 = x_insets_first_quadrant_length1;
				_tmp53_ = _tmp52_[inset_index];
				xmax = x_bounds_max - _tmp53_;
				_tmp55_ = gdk_pixbuf_get_width (pixbuf);
				_tmp56_ = _tmp55_;
				if (xmax > (_tmp56_ - 1)) {
					gint _tmp57_;
					gint _tmp58_;
					_tmp57_ = gdk_pixbuf_get_width (pixbuf);
					_tmp58_ = _tmp57_;
					_tmp54_ = _tmp58_ - 1;
				} else {
					_tmp54_ = xmax;
				}
				xmax = _tmp54_;
				{
					gint x_it = 0;
					x_it = xmin;
					{
						gboolean _tmp59_ = FALSE;
						_tmp59_ = TRUE;
						while (TRUE) {
							GdkPixbuf* _tmp61_;
							GdkPixbuf* _tmp62_;
							if (!_tmp59_) {
								gint _tmp60_;
								_tmp60_ = x_it;
								x_it = _tmp60_ + 1;
							}
							_tmp59_ = FALSE;
							if (!(x_it <= xmax)) {
								break;
							}
							_tmp61_ = photo_red_reduce_pixel (self, pixbuf, x_it, y_it);
							_tmp62_ = _tmp61_;
							_g_object_unref0 (_tmp62_);
						}
					}
				}
				_tmp63_ = inset_index;
				inset_index = _tmp63_ - 1;
			}
		}
	}
	_tmp64_ = _g_object_ref0 (pixbuf);
	result = _tmp64_;
	x_insets_first_quadrant = (g_free (x_insets_first_quadrant), NULL);
	return result;
}

static GdkPixbuf*
photo_red_reduce_pixel (Photo* self,
                        GdkPixbuf* pixbuf,
                        gint x,
                        gint y)
{
	gint px_start_byte_offset = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	px_start_byte_offset = (y * gdk_pixbuf_get_rowstride (pixbuf)) + (x * gdk_pixbuf_get_n_channels (pixbuf));
	if (x >= 0) {
		_tmp2_ = y >= 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = gdk_pixbuf_get_width (pixbuf);
		_tmp4_ = _tmp3_;
		_tmp1_ = x < _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gint _tmp5_;
		gint _tmp6_;
		_tmp5_ = gdk_pixbuf_get_height (pixbuf);
		_tmp6_ = _tmp5_;
		_tmp0_ = y < _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guchar* pixel_data = NULL;
		guint8* _tmp7_;
		gint pixel_data_length1;
		gint _pixel_data_size_;
		guchar g = '\0';
		guchar* _tmp8_;
		gint _tmp8__length1;
		guchar _tmp9_;
		guchar b = '\0';
		guchar* _tmp10_;
		gint _tmp10__length1;
		guchar _tmp11_;
		guchar r = '\0';
		guchar* _tmp12_;
		gint _tmp12__length1;
		_tmp7_ = gdk_pixbuf_get_pixels (pixbuf);
		pixel_data = _tmp7_;
		pixel_data_length1 = -1;
		_pixel_data_size_ = pixel_data_length1;
		_tmp8_ = pixel_data;
		_tmp8__length1 = pixel_data_length1;
		_tmp9_ = _tmp8_[px_start_byte_offset + 1];
		g = _tmp9_;
		_tmp10_ = pixel_data;
		_tmp10__length1 = pixel_data_length1;
		_tmp11_ = _tmp10_[px_start_byte_offset + 2];
		b = _tmp11_;
		r = (guchar) ((g + b) / 2);
		_tmp12_ = pixel_data;
		_tmp12__length1 = pixel_data_length1;
		_tmp12_[px_start_byte_offset] = r;
	}
	_tmp13_ = _g_object_ref0 (pixbuf);
	result = _tmp13_;
	return result;
}

void
photo_unscaled_to_raw_point (Photo* self,
                             GdkPoint* unscaled_point,
                             GdkPoint* result)
{
	Orientation unscaled_orientation = 0;
	Dimensions unscaled_dims = {0};
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	gint unscaled_x_offset_raw = 0;
	gint unscaled_y_offset_raw = 0;
	Box crop_box = {0};
	Box _tmp2_ = {0};
	gboolean _tmp3_;
	GdkPoint derotated_point = {0};
	Dimensions _tmp6_;
	GdkPoint _tmp7_;
	GdkPoint _tmp8_ = {0};
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (unscaled_point != NULL);
	unscaled_orientation = photo_get_orientation (self);
	media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp0_);
	orientation_rotate_dimensions (unscaled_orientation, &_tmp0_, &_tmp1_);
	unscaled_dims = _tmp1_;
	unscaled_x_offset_raw = 0;
	unscaled_y_offset_raw = 0;
	_tmp3_ = photo_get_raw_crop (self, &_tmp2_);
	crop_box = _tmp2_;
	if (_tmp3_) {
		Box _tmp4_;
		Box _tmp5_;
		_tmp4_ = crop_box;
		unscaled_x_offset_raw = _tmp4_.left;
		_tmp5_ = crop_box;
		unscaled_y_offset_raw = _tmp5_.top;
	}
	_tmp6_ = unscaled_dims;
	_tmp7_ = *unscaled_point;
	orientation_derotate_point (unscaled_orientation, &_tmp6_, &_tmp7_, &_tmp8_);
	derotated_point = _tmp8_;
	derotated_point.x = derotated_point.x + unscaled_x_offset_raw;
	derotated_point.y = derotated_point.y + unscaled_y_offset_raw;
	*result = derotated_point;
	return;
}

void
photo_unscaled_to_raw_rect (Photo* self,
                            GdkRectangle* unscaled_rect,
                            GdkRectangle* result)
{
	GdkPoint upper_left = {0};
	GdkPoint _tmp0_ = {0};
	GdkPoint lower_right = {0};
	GdkPoint _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	GdkPoint _tmp4_;
	GdkRectangle _tmp5_;
	GdkPoint _tmp6_;
	GdkRectangle _tmp7_;
	GdkPoint _tmp8_;
	GdkPoint _tmp9_ = {0};
	GdkPoint _tmp10_;
	GdkPoint _tmp11_ = {0};
	GdkPoint _tmp12_;
	GdkPoint _tmp13_;
	GdkPoint _tmp16_;
	GdkPoint _tmp17_;
	GdkRectangle raw_rect = {0};
	GdkPoint _tmp20_;
	GdkPoint _tmp21_;
	GdkPoint _tmp22_;
	GdkPoint _tmp23_;
	GdkPoint _tmp24_;
	GdkPoint _tmp25_;
	g_return_if_fail (IS_PHOTO (self));
	g_return_if_fail (unscaled_rect != NULL);
	_tmp0_.x = 0;
	upper_left = _tmp0_;
	_tmp1_.x = 0;
	lower_right = _tmp1_;
	_tmp2_ = *unscaled_rect;
	upper_left.x = _tmp2_.x;
	_tmp3_ = *unscaled_rect;
	upper_left.y = _tmp3_.y;
	_tmp4_ = upper_left;
	_tmp5_ = *unscaled_rect;
	lower_right.x = _tmp4_.x + _tmp5_.width;
	_tmp6_ = upper_left;
	_tmp7_ = *unscaled_rect;
	lower_right.y = _tmp6_.y + _tmp7_.height;
	_tmp8_ = upper_left;
	photo_unscaled_to_raw_point (self, &_tmp8_, &_tmp9_);
	upper_left = _tmp9_;
	_tmp10_ = lower_right;
	photo_unscaled_to_raw_point (self, &_tmp10_, &_tmp11_);
	lower_right = _tmp11_;
	_tmp12_ = upper_left;
	_tmp13_ = lower_right;
	if (_tmp12_.x > _tmp13_.x) {
		gint temp = 0;
		GdkPoint _tmp14_;
		GdkPoint _tmp15_;
		_tmp14_ = upper_left;
		temp = _tmp14_.x;
		_tmp15_ = lower_right;
		upper_left.x = _tmp15_.x;
		lower_right.x = temp;
	}
	_tmp16_ = upper_left;
	_tmp17_ = lower_right;
	if (_tmp16_.y > _tmp17_.y) {
		gint temp = 0;
		GdkPoint _tmp18_;
		GdkPoint _tmp19_;
		_tmp18_ = upper_left;
		temp = _tmp18_.y;
		_tmp19_ = lower_right;
		upper_left.y = _tmp19_.y;
		lower_right.y = temp;
	}
	memset (&raw_rect, 0, sizeof (GdkRectangle));
	_tmp20_ = upper_left;
	raw_rect.x = _tmp20_.x;
	_tmp21_ = upper_left;
	raw_rect.y = _tmp21_.y;
	_tmp22_ = lower_right;
	_tmp23_ = upper_left;
	raw_rect.width = _tmp22_.x - _tmp23_.x;
	_tmp24_ = lower_right;
	_tmp25_ = upper_left;
	raw_rect.height = _tmp24_.y - _tmp25_.y;
	*result = raw_rect;
	return;
}

PixelTransformationBundle*
photo_get_enhance_transformations (Photo* self)
{
	GdkPixbuf* pixbuf = NULL;
	PixelTransformationBundle* transformations = NULL;
	GdkPixbuf* _tmp4_;
	PixelTransformationBundle* _tmp5_;
	GError* _inner_error0_ = NULL;
	PixelTransformationBundle* result;
	g_return_val_if_fail (IS_PHOTO (self), NULL);
	pixbuf = NULL;
	{
		GdkPixbuf* _tmp0_ = NULL;
		Scaling _tmp1_ = {0};
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		scaling_for_best_fit (360, FALSE, &_tmp1_);
		_tmp2_ = photo_get_pixbuf_with_options (self, &_tmp1_, PHOTO_EXCEPTION_ALL, BACKING_FETCH_MODE_BASELINE, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (pixbuf);
		pixbuf = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		g_warning ("Photo.vala:4458: %s", "Photo: get_enhance_transformations: couldn't obtain pixbuf to build " "transform histogram");
		result = NULL;
		_g_object_unref0 (pixbuf);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp4_ = pixbuf;
	_tmp5_ = auto_enhance_create_auto_enhance_adjustments (_tmp4_);
	transformations = _tmp5_;
	result = transformations;
	_g_object_unref0 (pixbuf);
	return result;
}

gboolean
photo_enhance (Photo* self)
{
	PixelTransformationBundle* transformations = NULL;
	PixelTransformationBundle* _tmp0_;
	PixelTransformationBundle* _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_PHOTO (self), FALSE);
	_tmp0_ = photo_get_enhance_transformations (self);
	transformations = _tmp0_;
	_tmp1_ = transformations;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_pixel_transformation_bundle_unref0 (transformations);
		return result;
	}
	{
		PhotoRow* _tmp2_;
		_tmp2_ = self->row;
		g_rec_mutex_lock (&self->priv->__lock_row);
		{
			PixelTransformationBundle* _tmp3_;
			_tmp3_ = transformations;
			photo_set_color_adjustments (self, _tmp3_);
		}
		__finally0:
		{
			PhotoRow* _tmp4_;
			_tmp4_ = self->row;
			g_rec_mutex_unlock (&self->priv->__lock_row);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp5_ = FALSE;
			_pixel_transformation_bundle_unref0 (transformations);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	result = TRUE;
	_pixel_transformation_bundle_unref0 (transformations);
	return result;
}

gboolean
photo_get_develop_raw_photos_to_files (void)
{
	gboolean result;
	result = photo__develop_raw_photos_to_files;
	return result;
}

void
photo_set_develop_raw_photos_to_files (gboolean value)
{
	photo__develop_raw_photos_to_files = value;
}

static void
photo_real_editable_replaced (Photo* self,
                              GFile* old_file,
                              GFile* new_file)
{
	g_return_if_fail ((old_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail ((new_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
photo_real_raw_development_modified (Photo* self)
{
}

static void
photo_real_baseline_replaced (Photo* self)
{
}

static void
photo_real_master_reimported (Photo* self,
                              PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
g_cclosure_user_marshal_VOID__MEDIA_METADATA (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__MEDIA_METADATA) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__MEDIA_METADATA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__MEDIA_METADATA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_media_metadata (param_values + 1), data2);
}

static void
photo_real_editable_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
photo_real_baseline_reimported (Photo* self,
                                PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
photo_real_source_reimported (Photo* self,
                              PhotoMetadata* metadata)
{
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static inline gpointer
photo_photo_transformation_state_impl_get_instance_private (PhotoPhotoTransformationStateImpl* self)
{
	return G_STRUCT_MEMBER_P (self, PhotoPhotoTransformationStateImpl_private_offset);
}

static void
_photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced (Photo* _sender,
                                                                                           gpointer self)
{
	photo_photo_transformation_state_impl_on_photo_baseline_replaced ((PhotoPhotoTransformationStateImpl*) self);
}

static PhotoPhotoTransformationStateImpl*
photo_photo_transformation_state_impl_construct (GType object_type,
                                                 Photo* photo,
                                                 Orientation orientation,
                                                 GeeHashMap* transformations,
                                                 PixelTransformer* transformer,
                                                 PixelTransformationBundle* adjustments)
{
	PhotoPhotoTransformationStateImpl * self = NULL;
	Photo* _tmp0_;
	GeeHashMap* _tmp1_;
	PixelTransformer* _tmp2_;
	PixelTransformationBundle* _tmp3_;
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
	g_return_val_if_fail ((transformations == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (transformations, GEE_TYPE_HASH_MAP), NULL);
	g_return_val_if_fail ((transformer == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (transformer, TYPE_PIXEL_TRANSFORMER), NULL);
	g_return_val_if_fail ((adjustments == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (adjustments, TYPE_PIXEL_TRANSFORMATION_BUNDLE), NULL);
	self = (PhotoPhotoTransformationStateImpl*) photo_transformation_state_construct (object_type);
	_tmp0_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->priv->photo);
	self->priv->photo = _tmp0_;
	self->priv->orientation = orientation;
	_tmp1_ = photo_photo_transformation_state_impl_copy_transformations (transformations);
	_g_object_unref0 (self->priv->transformations);
	self->priv->transformations = _tmp1_;
	_tmp2_ = _pixel_transformer_ref0 (transformer);
	_pixel_transformer_unref0 (self->priv->transformer);
	self->priv->transformer = _tmp2_;
	_tmp3_ = _pixel_transformation_bundle_ref0 (adjustments);
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	self->priv->adjustments = _tmp3_;
	g_signal_connect_object (photo, "baseline-replaced", (GCallback) _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced, self, 0);
	return self;
}

static PhotoPhotoTransformationStateImpl*
photo_photo_transformation_state_impl_new (Photo* photo,
                                           Orientation orientation,
                                           GeeHashMap* transformations,
                                           PixelTransformer* transformer,
                                           PixelTransformationBundle* adjustments)
{
	return photo_photo_transformation_state_impl_construct (PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, photo, orientation, transformations, transformer, adjustments);
}

static Orientation
photo_photo_transformation_state_impl_get_orientation (PhotoPhotoTransformationStateImpl* self)
{
	Orientation result;
	g_return_val_if_fail (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (self), 0);
	result = self->priv->orientation;
	return result;
}

static GeeHashMap*
photo_photo_transformation_state_impl_get_transformations (PhotoPhotoTransformationStateImpl* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* result;
	g_return_val_if_fail (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (self), NULL);
	_tmp0_ = self->priv->transformations;
	_tmp1_ = photo_photo_transformation_state_impl_copy_transformations (_tmp0_);
	result = _tmp1_;
	return result;
}

static PixelTransformer*
photo_photo_transformation_state_impl_get_transformer (PhotoPhotoTransformationStateImpl* self)
{
	PixelTransformer* _tmp0_ = NULL;
	PixelTransformer* _tmp1_;
	PixelTransformer* result;
	g_return_val_if_fail (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (self), NULL);
	_tmp1_ = self->priv->transformer;
	if (_tmp1_ != NULL) {
		PixelTransformer* _tmp2_;
		PixelTransformer* _tmp3_;
		_tmp2_ = self->priv->transformer;
		_tmp3_ = pixel_transformer_copy (_tmp2_);
		_pixel_transformer_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_pixel_transformer_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static PixelTransformationBundle*
photo_photo_transformation_state_impl_get_color_adjustments (PhotoPhotoTransformationStateImpl* self)
{
	PixelTransformationBundle* _tmp0_ = NULL;
	PixelTransformationBundle* _tmp1_;
	PixelTransformationBundle* result;
	g_return_val_if_fail (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (self), NULL);
	_tmp1_ = self->priv->adjustments;
	if (_tmp1_ != NULL) {
		PixelTransformationBundle* _tmp2_;
		PixelTransformationBundle* _tmp3_;
		_tmp2_ = self->priv->adjustments;
		_tmp3_ = pixel_transformation_bundle_copy (_tmp2_);
		_pixel_transformation_bundle_unref0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		_pixel_transformation_bundle_unref0 (_tmp0_);
		_tmp0_ = NULL;
	}
	result = _tmp0_;
	return result;
}

static GeeHashMap*
photo_photo_transformation_state_impl_copy_transformations (GeeHashMap* original)
{
	GeeHashMap* clone = NULL;
	GeeHashMap* _tmp0_;
	GeeHashMap* result;
	g_return_val_if_fail ((original == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (original, GEE_TYPE_HASH_MAP), NULL);
	if (original == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_KEY_VALUE_MAP, (GBoxedCopyFunc) key_value_map_ref, (GDestroyNotify) key_value_map_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	clone = _tmp0_;
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = gee_abstract_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (original, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_object_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gchar* object = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			GeeHashMap* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			gpointer _tmp12_;
			KeyValueMap* _tmp13_;
			KeyValueMap* _tmp14_;
			KeyValueMap* _tmp15_;
			_tmp6_ = _object_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _object_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			object = (gchar*) _tmp8_;
			_tmp9_ = clone;
			_tmp10_ = object;
			_tmp11_ = object;
			_tmp12_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (original, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp11_);
			_tmp13_ = (KeyValueMap*) _tmp12_;
			_tmp14_ = key_value_map_copy (_tmp13_);
			_tmp15_ = _tmp14_;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_, _tmp15_);
			_key_value_map_unref0 (_tmp15_);
			_key_value_map_unref0 (_tmp13_);
			_g_free0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	result = clone;
	return result;
}

static void
photo_photo_transformation_state_impl_on_photo_baseline_replaced (PhotoPhotoTransformationStateImpl* self)
{
	g_return_if_fail (PHOTO_IS_PHOTO_TRANSFORMATION_STATE_IMPL (self));
	if (!photo_transformation_state_is_broken (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState))) {
		g_signal_emit (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_TRANSFORMATION_STATE, PhotoTransformationState), photo_transformation_state_signals[PHOTO_TRANSFORMATION_STATE_BROKEN_SIGNAL], 0);
	}
}

static void
photo_photo_transformation_state_impl_class_init (PhotoPhotoTransformationStateImplClass * klass,
                                                  gpointer klass_data)
{
	photo_photo_transformation_state_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PhotoPhotoTransformationStateImpl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = photo_photo_transformation_state_impl_finalize;
}

static void
photo_photo_transformation_state_impl_instance_init (PhotoPhotoTransformationStateImpl * self,
                                                     gpointer klass)
{
	self->priv = photo_photo_transformation_state_impl_get_instance_private (self);
}

static void
photo_photo_transformation_state_impl_finalize (GObject * obj)
{
	PhotoPhotoTransformationStateImpl * self;
	Photo* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_PHOTO_TRANSFORMATION_STATE_IMPL, PhotoPhotoTransformationStateImpl);
	_tmp0_ = self->priv->photo;
	g_signal_parse_name ("baseline-replaced", TYPE_PHOTO, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _photo_photo_transformation_state_impl_on_photo_baseline_replaced_photo_baseline_replaced, self);
	_g_object_unref0 (self->priv->photo);
	_g_object_unref0 (self->priv->transformations);
	_pixel_transformer_unref0 (self->priv->transformer);
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	G_OBJECT_CLASS (photo_photo_transformation_state_impl_parent_class)->finalize (obj);
}

static GType
photo_photo_transformation_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoPhotoTransformationStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_photo_transformation_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoPhotoTransformationStateImpl), 0, (GInstanceInitFunc) photo_photo_transformation_state_impl_instance_init, NULL };
	GType photo_photo_transformation_state_impl_type_id;
	photo_photo_transformation_state_impl_type_id = g_type_register_static (TYPE_PHOTO_TRANSFORMATION_STATE, "PhotoPhotoTransformationStateImpl", &g_define_type_info, 0);
	PhotoPhotoTransformationStateImpl_private_offset = g_type_add_instance_private (photo_photo_transformation_state_impl_type_id, sizeof (PhotoPhotoTransformationStateImplPrivate));
	return photo_photo_transformation_state_impl_type_id;
}

static GType
photo_photo_transformation_state_impl_get_type (void)
{
	static volatile gsize photo_photo_transformation_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_photo_transformation_state_impl_type_id__once)) {
		GType photo_photo_transformation_state_impl_type_id;
		photo_photo_transformation_state_impl_type_id = photo_photo_transformation_state_impl_get_type_once ();
		g_once_init_leave (&photo_photo_transformation_state_impl_type_id__once, photo_photo_transformation_state_impl_type_id);
	}
	return photo_photo_transformation_state_impl_type_id__once;
}

static PhotoBackingReaders*
photo_backing_readers_construct (GType object_type)
{
	PhotoBackingReaders* self = NULL;
	self = (PhotoBackingReaders*) g_type_create_instance (object_type);
	return self;
}

static PhotoBackingReaders*
photo_backing_readers_new (void)
{
	return photo_backing_readers_construct (PHOTO_TYPE_BACKING_READERS);
}

static void
photo_value_backing_readers_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_backing_readers_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_backing_readers_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_backing_readers_copy_value (const GValue* src_value,
                                        GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_backing_readers_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_backing_readers_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_backing_readers_collect_value (GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoBackingReaders * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_backing_readers_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_backing_readers_lcopy_value (const GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	PhotoBackingReaders ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_backing_readers_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
photo_param_spec_backing_readers (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags)
{
	PhotoParamSpecBackingReaders* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_BACKING_READERS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
photo_value_get_backing_readers (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_BACKING_READERS), NULL);
	return value->data[0].v_pointer;
}

static void
photo_value_set_backing_readers (GValue* value,
                                 gpointer v_object)
{
	PhotoBackingReaders * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_BACKING_READERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_BACKING_READERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_backing_readers_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_backing_readers_unref (old);
	}
}

static void
photo_value_take_backing_readers (GValue* value,
                                  gpointer v_object)
{
	PhotoBackingReaders * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_BACKING_READERS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_BACKING_READERS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_backing_readers_unref (old);
	}
}

static void
photo_backing_readers_class_init (PhotoBackingReadersClass * klass,
                                  gpointer klass_data)
{
	photo_backing_readers_parent_class = g_type_class_peek_parent (klass);
	((PhotoBackingReadersClass *) klass)->finalize = photo_backing_readers_finalize;
}

static void
photo_backing_readers_instance_init (PhotoBackingReaders * self,
                                     gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_backing_readers_finalize (PhotoBackingReaders * obj)
{
	PhotoBackingReaders * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_BACKING_READERS, PhotoBackingReaders);
	g_signal_handlers_destroy (self);
	_photo_file_adapter_unref0 (self->master);
	_photo_file_adapter_unref0 (self->developer);
	_photo_file_adapter_unref0 (self->editable);
}

static GType
photo_backing_readers_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_backing_readers_init, photo_value_backing_readers_free_value, photo_value_backing_readers_copy_value, photo_value_backing_readers_peek_pointer, "p", photo_value_backing_readers_collect_value, "p", photo_value_backing_readers_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoBackingReadersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_backing_readers_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoBackingReaders), 0, (GInstanceInitFunc) photo_backing_readers_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_backing_readers_type_id;
	photo_backing_readers_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoBackingReaders", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_backing_readers_type_id;
}

static GType
photo_backing_readers_get_type (void)
{
	static volatile gsize photo_backing_readers_type_id__once = 0;
	if (g_once_init_enter (&photo_backing_readers_type_id__once)) {
		GType photo_backing_readers_type_id;
		photo_backing_readers_type_id = photo_backing_readers_get_type_once ();
		g_once_init_leave (&photo_backing_readers_type_id__once, photo_backing_readers_type_id);
	}
	return photo_backing_readers_type_id__once;
}

static gpointer
photo_backing_readers_ref (gpointer instance)
{
	PhotoBackingReaders * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
photo_backing_readers_unref (gpointer instance)
{
	PhotoBackingReaders * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_BACKING_READERS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoCachedPixbuf*
photo_cached_pixbuf_construct (GType object_type,
                               Photo* photo,
                               GdkPixbuf* pixbuf)
{
	PhotoCachedPixbuf* self = NULL;
	Photo* _tmp0_;
	GdkPixbuf* _tmp1_;
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (pixbuf, gdk_pixbuf_get_type ()), NULL);
	self = (PhotoCachedPixbuf*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (photo);
	_g_object_unref0 (self->photo);
	self->photo = _tmp0_;
	_tmp1_ = _g_object_ref0 (pixbuf);
	_g_object_unref0 (self->pixbuf);
	self->pixbuf = _tmp1_;
	return self;
}

static PhotoCachedPixbuf*
photo_cached_pixbuf_new (Photo* photo,
                         GdkPixbuf* pixbuf)
{
	return photo_cached_pixbuf_construct (PHOTO_TYPE_CACHED_PIXBUF, photo, pixbuf);
}

static void
photo_value_cached_pixbuf_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_cached_pixbuf_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_cached_pixbuf_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_cached_pixbuf_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_cached_pixbuf_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_cached_pixbuf_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_cached_pixbuf_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoCachedPixbuf * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_cached_pixbuf_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_cached_pixbuf_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	PhotoCachedPixbuf ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_cached_pixbuf_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
photo_param_spec_cached_pixbuf (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	PhotoParamSpecCachedPixbuf* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_CACHED_PIXBUF), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
photo_value_get_cached_pixbuf (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_CACHED_PIXBUF), NULL);
	return value->data[0].v_pointer;
}

static void
photo_value_set_cached_pixbuf (GValue* value,
                               gpointer v_object)
{
	PhotoCachedPixbuf * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_CACHED_PIXBUF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_CACHED_PIXBUF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_cached_pixbuf_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_cached_pixbuf_unref (old);
	}
}

static void
photo_value_take_cached_pixbuf (GValue* value,
                                gpointer v_object)
{
	PhotoCachedPixbuf * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_CACHED_PIXBUF));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_CACHED_PIXBUF));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_cached_pixbuf_unref (old);
	}
}

static void
photo_cached_pixbuf_class_init (PhotoCachedPixbufClass * klass,
                                gpointer klass_data)
{
	photo_cached_pixbuf_parent_class = g_type_class_peek_parent (klass);
	((PhotoCachedPixbufClass *) klass)->finalize = photo_cached_pixbuf_finalize;
}

static void
photo_cached_pixbuf_instance_init (PhotoCachedPixbuf * self,
                                   gpointer klass)
{
	GTimer* _tmp0_;
	_tmp0_ = g_timer_new ();
	self->last_touched = _tmp0_;
	self->ref_count = 1;
}

static void
photo_cached_pixbuf_finalize (PhotoCachedPixbuf * obj)
{
	PhotoCachedPixbuf * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_CACHED_PIXBUF, PhotoCachedPixbuf);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->photo);
	_g_object_unref0 (self->pixbuf);
	_g_timer_destroy0 (self->last_touched);
}

static GType
photo_cached_pixbuf_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_cached_pixbuf_init, photo_value_cached_pixbuf_free_value, photo_value_cached_pixbuf_copy_value, photo_value_cached_pixbuf_peek_pointer, "p", photo_value_cached_pixbuf_collect_value, "p", photo_value_cached_pixbuf_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoCachedPixbufClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_cached_pixbuf_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoCachedPixbuf), 0, (GInstanceInitFunc) photo_cached_pixbuf_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_cached_pixbuf_type_id;
	photo_cached_pixbuf_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoCachedPixbuf", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_cached_pixbuf_type_id;
}

static GType
photo_cached_pixbuf_get_type (void)
{
	static volatile gsize photo_cached_pixbuf_type_id__once = 0;
	if (g_once_init_enter (&photo_cached_pixbuf_type_id__once)) {
		GType photo_cached_pixbuf_type_id;
		photo_cached_pixbuf_type_id = photo_cached_pixbuf_get_type_once ();
		g_once_init_leave (&photo_cached_pixbuf_type_id__once, photo_cached_pixbuf_type_id);
	}
	return photo_cached_pixbuf_type_id__once;
}

static gpointer
photo_cached_pixbuf_ref (gpointer instance)
{
	PhotoCachedPixbuf * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
photo_cached_pixbuf_unref (gpointer instance)
{
	PhotoCachedPixbuf * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_CACHED_PIXBUF_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

PhotoReimportMasterState*
photo_reimport_master_state_construct (GType object_type)
{
	PhotoReimportMasterState* self = NULL;
	self = (PhotoReimportMasterState*) g_type_create_instance (object_type);
	return self;
}

static void
photo_value_reimport_master_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_reimport_master_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_master_state_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_reimport_master_state_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_master_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_reimport_master_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_reimport_master_state_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportMasterState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_master_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_reimport_master_state_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	PhotoReimportMasterState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_master_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
photo_param_spec_reimport_master_state (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	PhotoParamSpecReimportMasterState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_REIMPORT_MASTER_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
photo_value_get_reimport_master_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_MASTER_STATE), NULL);
	return value->data[0].v_pointer;
}

void
photo_value_set_reimport_master_state (GValue* value,
                                       gpointer v_object)
{
	PhotoReimportMasterState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_MASTER_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_MASTER_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_master_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_master_state_unref (old);
	}
}

void
photo_value_take_reimport_master_state (GValue* value,
                                        gpointer v_object)
{
	PhotoReimportMasterState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_MASTER_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_MASTER_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_master_state_unref (old);
	}
}

static void
photo_reimport_master_state_class_init (PhotoReimportMasterStateClass * klass,
                                        gpointer klass_data)
{
	photo_reimport_master_state_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportMasterStateClass *) klass)->finalize = photo_reimport_master_state_finalize;
}

static void
photo_reimport_master_state_instance_init (PhotoReimportMasterState * self,
                                           gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_reimport_master_state_finalize (PhotoReimportMasterState * obj)
{
	PhotoReimportMasterState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_MASTER_STATE, PhotoReimportMasterState);
	g_signal_handlers_destroy (self);
}

static GType
photo_reimport_master_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_reimport_master_state_init, photo_value_reimport_master_state_free_value, photo_value_reimport_master_state_copy_value, photo_value_reimport_master_state_peek_pointer, "p", photo_value_reimport_master_state_collect_value, "p", photo_value_reimport_master_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportMasterStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_master_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportMasterState), 0, (GInstanceInitFunc) photo_reimport_master_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_master_state_type_id;
	photo_reimport_master_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportMasterState", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_reimport_master_state_type_id;
}

GType
photo_reimport_master_state_get_type (void)
{
	static volatile gsize photo_reimport_master_state_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_master_state_type_id__once)) {
		GType photo_reimport_master_state_type_id;
		photo_reimport_master_state_type_id = photo_reimport_master_state_get_type_once ();
		g_once_init_leave (&photo_reimport_master_state_type_id__once, photo_reimport_master_state_type_id);
	}
	return photo_reimport_master_state_type_id__once;
}

gpointer
photo_reimport_master_state_ref (gpointer instance)
{
	PhotoReimportMasterState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_reimport_master_state_unref (gpointer instance)
{
	PhotoReimportMasterState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_MASTER_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static gchar**
_vala_array_dup33 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static PhotoReimportMasterStateImpl*
photo_reimport_master_state_impl_construct (GType object_type,
                                            PhotoRow* row,
                                            PhotoMetadata* metadata,
                                            gchar** alterations,
                                            gint alterations_length1)
{
	PhotoReimportMasterStateImpl* self = NULL;
	PhotoRow* _tmp0_;
	PhotoMetadata* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
	g_return_val_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata), NULL);
	self = (PhotoReimportMasterStateImpl*) photo_reimport_master_state_construct (object_type);
	_tmp0_ = _photo_row_ref0 (row);
	_photo_row_unref0 (self->row);
	self->row = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->metadata);
	self->metadata = _tmp1_;
	_tmp2_ = (alterations != NULL) ? _vala_array_dup33 (alterations, alterations_length1) : alterations;
	_tmp2__length1 = alterations_length1;
	self->alterations = (_vala_array_free (self->alterations, self->alterations_length1, (GDestroyNotify) g_free), NULL);
	self->alterations = _tmp2_;
	self->alterations_length1 = _tmp2__length1;
	self->_alterations_size_ = self->alterations_length1;
	return self;
}

static PhotoReimportMasterStateImpl*
photo_reimport_master_state_impl_new (PhotoRow* row,
                                      PhotoMetadata* metadata,
                                      gchar** alterations,
                                      gint alterations_length1)
{
	return photo_reimport_master_state_impl_construct (PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, row, metadata, alterations, alterations_length1);
}

static void
photo_reimport_master_state_impl_class_init (PhotoReimportMasterStateImplClass * klass,
                                             gpointer klass_data)
{
	photo_reimport_master_state_impl_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportMasterStateClass *) klass)->finalize = photo_reimport_master_state_impl_finalize;
}

static void
photo_reimport_master_state_impl_instance_init (PhotoReimportMasterStateImpl * self,
                                                gpointer klass)
{
	PhotoRow* _tmp0_;
	_tmp0_ = photo_row_new ();
	self->row = _tmp0_;
	self->metadata_only = FALSE;
}

static void
photo_reimport_master_state_impl_finalize (PhotoReimportMasterState * obj)
{
	PhotoReimportMasterStateImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_MASTER_STATE_IMPL, PhotoReimportMasterStateImpl);
	_photo_row_unref0 (self->row);
	_media_metadata_unref0 (self->metadata);
	self->alterations = (_vala_array_free (self->alterations, self->alterations_length1, (GDestroyNotify) g_free), NULL);
	PHOTO_REIMPORT_MASTER_STATE_CLASS (photo_reimport_master_state_impl_parent_class)->finalize (obj);
}

static GType
photo_reimport_master_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportMasterStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_master_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportMasterStateImpl), 0, (GInstanceInitFunc) photo_reimport_master_state_impl_instance_init, NULL };
	GType photo_reimport_master_state_impl_type_id;
	photo_reimport_master_state_impl_type_id = g_type_register_static (PHOTO_TYPE_REIMPORT_MASTER_STATE, "PhotoReimportMasterStateImpl", &g_define_type_info, 0);
	return photo_reimport_master_state_impl_type_id;
}

static GType
photo_reimport_master_state_impl_get_type (void)
{
	static volatile gsize photo_reimport_master_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_master_state_impl_type_id__once)) {
		GType photo_reimport_master_state_impl_type_id;
		photo_reimport_master_state_impl_type_id = photo_reimport_master_state_impl_get_type_once ();
		g_once_init_leave (&photo_reimport_master_state_impl_type_id__once, photo_reimport_master_state_impl_type_id);
	}
	return photo_reimport_master_state_impl_type_id__once;
}

PhotoReimportEditableState*
photo_reimport_editable_state_construct (GType object_type)
{
	PhotoReimportEditableState* self = NULL;
	self = (PhotoReimportEditableState*) g_type_create_instance (object_type);
	return self;
}

static void
photo_value_reimport_editable_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_reimport_editable_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_editable_state_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_reimport_editable_state_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_editable_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_reimport_editable_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_reimport_editable_state_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportEditableState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_editable_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_reimport_editable_state_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	PhotoReimportEditableState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_editable_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
photo_param_spec_reimport_editable_state (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	PhotoParamSpecReimportEditableState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_REIMPORT_EDITABLE_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
photo_value_get_reimport_editable_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_EDITABLE_STATE), NULL);
	return value->data[0].v_pointer;
}

void
photo_value_set_reimport_editable_state (GValue* value,
                                         gpointer v_object)
{
	PhotoReimportEditableState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_editable_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_editable_state_unref (old);
	}
}

void
photo_value_take_reimport_editable_state (GValue* value,
                                          gpointer v_object)
{
	PhotoReimportEditableState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_EDITABLE_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_editable_state_unref (old);
	}
}

static void
photo_reimport_editable_state_class_init (PhotoReimportEditableStateClass * klass,
                                          gpointer klass_data)
{
	photo_reimport_editable_state_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportEditableStateClass *) klass)->finalize = photo_reimport_editable_state_finalize;
}

static void
photo_reimport_editable_state_instance_init (PhotoReimportEditableState * self,
                                             gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_reimport_editable_state_finalize (PhotoReimportEditableState * obj)
{
	PhotoReimportEditableState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_EDITABLE_STATE, PhotoReimportEditableState);
	g_signal_handlers_destroy (self);
}

static GType
photo_reimport_editable_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_reimport_editable_state_init, photo_value_reimport_editable_state_free_value, photo_value_reimport_editable_state_copy_value, photo_value_reimport_editable_state_peek_pointer, "p", photo_value_reimport_editable_state_collect_value, "p", photo_value_reimport_editable_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportEditableStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_editable_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportEditableState), 0, (GInstanceInitFunc) photo_reimport_editable_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_editable_state_type_id;
	photo_reimport_editable_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportEditableState", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_reimport_editable_state_type_id;
}

GType
photo_reimport_editable_state_get_type (void)
{
	static volatile gsize photo_reimport_editable_state_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_editable_state_type_id__once)) {
		GType photo_reimport_editable_state_type_id;
		photo_reimport_editable_state_type_id = photo_reimport_editable_state_get_type_once ();
		g_once_init_leave (&photo_reimport_editable_state_type_id__once, photo_reimport_editable_state_type_id);
	}
	return photo_reimport_editable_state_type_id__once;
}

gpointer
photo_reimport_editable_state_ref (gpointer instance)
{
	PhotoReimportEditableState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_reimport_editable_state_unref (gpointer instance)
{
	PhotoReimportEditableState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_EDITABLE_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoReimportEditableStateImpl*
photo_reimport_editable_state_impl_construct (GType object_type,
                                              BackingPhotoRow* backing_state,
                                              PhotoMetadata* metadata)
{
	PhotoReimportEditableStateImpl* self = NULL;
	BackingPhotoRow* _tmp0_;
	PhotoMetadata* _tmp1_;
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (backing_state), NULL);
	g_return_val_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata), NULL);
	self = (PhotoReimportEditableStateImpl*) photo_reimport_editable_state_construct (object_type);
	_tmp0_ = _backing_photo_row_ref0 (backing_state);
	_backing_photo_row_unref0 (self->backing_state);
	self->backing_state = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->metadata);
	self->metadata = _tmp1_;
	return self;
}

static PhotoReimportEditableStateImpl*
photo_reimport_editable_state_impl_new (BackingPhotoRow* backing_state,
                                        PhotoMetadata* metadata)
{
	return photo_reimport_editable_state_impl_construct (PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, backing_state, metadata);
}

static void
photo_reimport_editable_state_impl_class_init (PhotoReimportEditableStateImplClass * klass,
                                               gpointer klass_data)
{
	photo_reimport_editable_state_impl_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportEditableStateClass *) klass)->finalize = photo_reimport_editable_state_impl_finalize;
}

static void
photo_reimport_editable_state_impl_instance_init (PhotoReimportEditableStateImpl * self,
                                                  gpointer klass)
{
	BackingPhotoRow* _tmp0_;
	_tmp0_ = backing_photo_row_new ();
	self->backing_state = _tmp0_;
	self->metadata_only = FALSE;
}

static void
photo_reimport_editable_state_impl_finalize (PhotoReimportEditableState * obj)
{
	PhotoReimportEditableStateImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_EDITABLE_STATE_IMPL, PhotoReimportEditableStateImpl);
	_backing_photo_row_unref0 (self->backing_state);
	_media_metadata_unref0 (self->metadata);
	PHOTO_REIMPORT_EDITABLE_STATE_CLASS (photo_reimport_editable_state_impl_parent_class)->finalize (obj);
}

static GType
photo_reimport_editable_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportEditableStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_editable_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportEditableStateImpl), 0, (GInstanceInitFunc) photo_reimport_editable_state_impl_instance_init, NULL };
	GType photo_reimport_editable_state_impl_type_id;
	photo_reimport_editable_state_impl_type_id = g_type_register_static (PHOTO_TYPE_REIMPORT_EDITABLE_STATE, "PhotoReimportEditableStateImpl", &g_define_type_info, 0);
	return photo_reimport_editable_state_impl_type_id;
}

static GType
photo_reimport_editable_state_impl_get_type (void)
{
	static volatile gsize photo_reimport_editable_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_editable_state_impl_type_id__once)) {
		GType photo_reimport_editable_state_impl_type_id;
		photo_reimport_editable_state_impl_type_id = photo_reimport_editable_state_impl_get_type_once ();
		g_once_init_leave (&photo_reimport_editable_state_impl_type_id__once, photo_reimport_editable_state_impl_type_id);
	}
	return photo_reimport_editable_state_impl_type_id__once;
}

PhotoReimportRawDevelopmentState*
photo_reimport_raw_development_state_construct (GType object_type)
{
	PhotoReimportRawDevelopmentState* self = NULL;
	self = (PhotoReimportRawDevelopmentState*) g_type_create_instance (object_type);
	return self;
}

static void
photo_value_reimport_raw_development_state_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_value_reimport_raw_development_state_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_raw_development_state_unref (value->data[0].v_pointer);
	}
}

static void
photo_value_reimport_raw_development_state_copy_value (const GValue* src_value,
                                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_raw_development_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_value_reimport_raw_development_state_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_value_reimport_raw_development_state_collect_value (GValue* value,
                                                          guint n_collect_values,
                                                          GTypeCValue* collect_values,
                                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportRawDevelopmentState * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_raw_development_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_value_reimport_raw_development_state_lcopy_value (const GValue* value,
                                                        guint n_collect_values,
                                                        GTypeCValue* collect_values,
                                                        guint collect_flags)
{
	PhotoReimportRawDevelopmentState ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_raw_development_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
photo_param_spec_reimport_raw_development_state (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags)
{
	PhotoParamSpecReimportRawDevelopmentState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
photo_value_get_reimport_raw_development_state (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE), NULL);
	return value->data[0].v_pointer;
}

void
photo_value_set_reimport_raw_development_state (GValue* value,
                                                gpointer v_object)
{
	PhotoReimportRawDevelopmentState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_raw_development_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_unref (old);
	}
}

void
photo_value_take_reimport_raw_development_state (GValue* value,
                                                 gpointer v_object)
{
	PhotoReimportRawDevelopmentState * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_unref (old);
	}
}

static void
photo_reimport_raw_development_state_class_init (PhotoReimportRawDevelopmentStateClass * klass,
                                                 gpointer klass_data)
{
	photo_reimport_raw_development_state_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportRawDevelopmentStateClass *) klass)->finalize = photo_reimport_raw_development_state_finalize;
}

static void
photo_reimport_raw_development_state_instance_init (PhotoReimportRawDevelopmentState * self,
                                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
photo_reimport_raw_development_state_finalize (PhotoReimportRawDevelopmentState * obj)
{
	PhotoReimportRawDevelopmentState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, PhotoReimportRawDevelopmentState);
	g_signal_handlers_destroy (self);
}

static GType
photo_reimport_raw_development_state_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_value_reimport_raw_development_state_init, photo_value_reimport_raw_development_state_free_value, photo_value_reimport_raw_development_state_copy_value, photo_value_reimport_raw_development_state_peek_pointer, "p", photo_value_reimport_raw_development_state_collect_value, "p", photo_value_reimport_raw_development_state_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportRawDevelopmentStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_raw_development_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportRawDevelopmentState), 0, (GInstanceInitFunc) photo_reimport_raw_development_state_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_raw_development_state_type_id;
	photo_reimport_raw_development_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportRawDevelopmentState", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return photo_reimport_raw_development_state_type_id;
}

GType
photo_reimport_raw_development_state_get_type (void)
{
	static volatile gsize photo_reimport_raw_development_state_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_raw_development_state_type_id__once)) {
		GType photo_reimport_raw_development_state_type_id;
		photo_reimport_raw_development_state_type_id = photo_reimport_raw_development_state_get_type_once ();
		g_once_init_leave (&photo_reimport_raw_development_state_type_id__once, photo_reimport_raw_development_state_type_id);
	}
	return photo_reimport_raw_development_state_type_id__once;
}

gpointer
photo_reimport_raw_development_state_ref (gpointer instance)
{
	PhotoReimportRawDevelopmentState * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
photo_reimport_raw_development_state_unref (gpointer instance)
{
	PhotoReimportRawDevelopmentState * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static PhotoReimportRawDevelopmentStateImpl*
photo_reimport_raw_development_state_impl_construct (GType object_type)
{
	PhotoReimportRawDevelopmentStateImpl* self = NULL;
	self = (PhotoReimportRawDevelopmentStateImpl*) photo_reimport_raw_development_state_construct (object_type);
	return self;
}

static PhotoReimportRawDevelopmentStateImpl*
photo_reimport_raw_development_state_impl_new (void)
{
	return photo_reimport_raw_development_state_impl_construct (PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL);
}

static void
photo_reimport_raw_development_state_impl_add (PhotoReimportRawDevelopmentStateImpl* self,
                                               BackingPhotoRow* backing,
                                               PhotoMetadata* metadata)
{
	GeeCollection* _tmp0_;
	PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp1_;
	PhotoReimportRawDevelopmentStateImplDevToReimport* _tmp2_;
	g_return_if_fail (PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (self));
	g_return_if_fail (IS_BACKING_PHOTO_ROW (backing));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	_tmp0_ = self->list;
	_tmp1_ = photo_reimport_raw_development_state_impl_dev_to_reimport_new (backing, metadata);
	_tmp2_ = _tmp1_;
	gee_collection_add (_tmp0_, _tmp2_);
	_photo_reimport_raw_development_state_impl_dev_to_reimport_unref0 (_tmp2_);
}

static gint
photo_reimport_raw_development_state_impl_get_size (PhotoReimportRawDevelopmentStateImpl* self)
{
	GeeCollection* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (PHOTO_IS_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL (self), 0);
	_tmp0_ = self->list;
	_tmp1_ = gee_collection_get_size (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static PhotoReimportRawDevelopmentStateImplDevToReimport*
photo_reimport_raw_development_state_impl_dev_to_reimport_construct (GType object_type,
                                                                     BackingPhotoRow* backing,
                                                                     PhotoMetadata* metadata)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport* self = NULL;
	BackingPhotoRow* _tmp0_;
	PhotoMetadata* _tmp1_;
	g_return_val_if_fail (IS_BACKING_PHOTO_ROW (backing), NULL);
	g_return_val_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata), NULL);
	self = (PhotoReimportRawDevelopmentStateImplDevToReimport*) g_type_create_instance (object_type);
	_tmp0_ = _backing_photo_row_ref0 (backing);
	_backing_photo_row_unref0 (self->backing);
	self->backing = _tmp0_;
	_tmp1_ = _media_metadata_ref0 (metadata);
	_media_metadata_unref0 (self->metadata);
	self->metadata = _tmp1_;
	return self;
}

static PhotoReimportRawDevelopmentStateImplDevToReimport*
photo_reimport_raw_development_state_impl_dev_to_reimport_new (BackingPhotoRow* backing,
                                                               PhotoMetadata* metadata)
{
	return photo_reimport_raw_development_state_impl_dev_to_reimport_construct (PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, backing, metadata);
}

static void
photo_reimport_raw_development_state_impl_value_dev_to_reimport_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
photo_reimport_raw_development_state_impl_value_dev_to_reimport_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		photo_reimport_raw_development_state_impl_dev_to_reimport_unref (value->data[0].v_pointer);
	}
}

static void
photo_reimport_raw_development_state_impl_value_dev_to_reimport_copy_value (const GValue* src_value,
                                                                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = photo_reimport_raw_development_state_impl_dev_to_reimport_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
photo_reimport_raw_development_state_impl_value_dev_to_reimport_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
photo_reimport_raw_development_state_impl_value_dev_to_reimport_collect_value (GValue* value,
                                                                               guint n_collect_values,
                                                                               GTypeCValue* collect_values,
                                                                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PhotoReimportRawDevelopmentStateImplDevToReimport * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = photo_reimport_raw_development_state_impl_dev_to_reimport_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
photo_reimport_raw_development_state_impl_value_dev_to_reimport_lcopy_value (const GValue* value,
                                                                             guint n_collect_values,
                                                                             GTypeCValue* collect_values,
                                                                             guint collect_flags)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = photo_reimport_raw_development_state_impl_dev_to_reimport_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
photo_reimport_raw_development_state_impl_param_spec_dev_to_reimport (const gchar* name,
                                                                      const gchar* nick,
                                                                      const gchar* blurb,
                                                                      GType object_type,
                                                                      GParamFlags flags)
{
	PhotoReimportRawDevelopmentStateImplParamSpecDevToReimport* spec;
	g_return_val_if_fail (g_type_is_a (object_type, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
photo_reimport_raw_development_state_impl_value_get_dev_to_reimport (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT), NULL);
	return value->data[0].v_pointer;
}

static void
photo_reimport_raw_development_state_impl_value_set_dev_to_reimport (GValue* value,
                                                                     gpointer v_object)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		photo_reimport_raw_development_state_impl_dev_to_reimport_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_impl_dev_to_reimport_unref (old);
	}
}

static void
photo_reimport_raw_development_state_impl_value_take_dev_to_reimport (GValue* value,
                                                                      gpointer v_object)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		photo_reimport_raw_development_state_impl_dev_to_reimport_unref (old);
	}
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_class_init (PhotoReimportRawDevelopmentStateImplDevToReimportClass * klass,
                                                                      gpointer klass_data)
{
	photo_reimport_raw_development_state_impl_dev_to_reimport_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportRawDevelopmentStateImplDevToReimportClass *) klass)->finalize = photo_reimport_raw_development_state_impl_dev_to_reimport_finalize;
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_instance_init (PhotoReimportRawDevelopmentStateImplDevToReimport * self,
                                                                         gpointer klass)
{
	BackingPhotoRow* _tmp0_;
	_tmp0_ = backing_photo_row_new ();
	self->backing = _tmp0_;
	self->ref_count = 1;
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_finalize (PhotoReimportRawDevelopmentStateImplDevToReimport * obj)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, PhotoReimportRawDevelopmentStateImplDevToReimport);
	g_signal_handlers_destroy (self);
	_backing_photo_row_unref0 (self->backing);
	_media_metadata_unref0 (self->metadata);
}

static GType
photo_reimport_raw_development_state_impl_dev_to_reimport_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { photo_reimport_raw_development_state_impl_value_dev_to_reimport_init, photo_reimport_raw_development_state_impl_value_dev_to_reimport_free_value, photo_reimport_raw_development_state_impl_value_dev_to_reimport_copy_value, photo_reimport_raw_development_state_impl_value_dev_to_reimport_peek_pointer, "p", photo_reimport_raw_development_state_impl_value_dev_to_reimport_collect_value, "p", photo_reimport_raw_development_state_impl_value_dev_to_reimport_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportRawDevelopmentStateImplDevToReimportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_raw_development_state_impl_dev_to_reimport_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportRawDevelopmentStateImplDevToReimport), 0, (GInstanceInitFunc) photo_reimport_raw_development_state_impl_dev_to_reimport_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType photo_reimport_raw_development_state_impl_dev_to_reimport_type_id;
	photo_reimport_raw_development_state_impl_dev_to_reimport_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PhotoReimportRawDevelopmentStateImplDevToReimport", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return photo_reimport_raw_development_state_impl_dev_to_reimport_type_id;
}

GType
photo_reimport_raw_development_state_impl_dev_to_reimport_get_type (void)
{
	static volatile gsize photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once)) {
		GType photo_reimport_raw_development_state_impl_dev_to_reimport_type_id;
		photo_reimport_raw_development_state_impl_dev_to_reimport_type_id = photo_reimport_raw_development_state_impl_dev_to_reimport_get_type_once ();
		g_once_init_leave (&photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once, photo_reimport_raw_development_state_impl_dev_to_reimport_type_id);
	}
	return photo_reimport_raw_development_state_impl_dev_to_reimport_type_id__once;
}

static gpointer
photo_reimport_raw_development_state_impl_dev_to_reimport_ref (gpointer instance)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
photo_reimport_raw_development_state_impl_dev_to_reimport_unref (gpointer instance)
{
	PhotoReimportRawDevelopmentStateImplDevToReimport * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_DEV_TO_REIMPORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
photo_reimport_raw_development_state_impl_class_init (PhotoReimportRawDevelopmentStateImplClass * klass,
                                                      gpointer klass_data)
{
	photo_reimport_raw_development_state_impl_parent_class = g_type_class_peek_parent (klass);
	((PhotoReimportRawDevelopmentStateClass *) klass)->finalize = photo_reimport_raw_development_state_impl_finalize;
}

static void
photo_reimport_raw_development_state_impl_instance_init (PhotoReimportRawDevelopmentStateImpl * self,
                                                         gpointer klass)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = gee_array_list_new (PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL_TYPE_DEV_TO_REIMPORT, (GBoxedCopyFunc) photo_reimport_raw_development_state_impl_dev_to_reimport_ref, (GDestroyNotify) photo_reimport_raw_development_state_impl_dev_to_reimport_unref, NULL, NULL, NULL);
	self->list = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	self->metadata_only = FALSE;
}

static void
photo_reimport_raw_development_state_impl_finalize (PhotoReimportRawDevelopmentState * obj)
{
	PhotoReimportRawDevelopmentStateImpl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE_IMPL, PhotoReimportRawDevelopmentStateImpl);
	_g_object_unref0 (self->list);
	PHOTO_REIMPORT_RAW_DEVELOPMENT_STATE_CLASS (photo_reimport_raw_development_state_impl_parent_class)->finalize (obj);
}

static GType
photo_reimport_raw_development_state_impl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoReimportRawDevelopmentStateImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_reimport_raw_development_state_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PhotoReimportRawDevelopmentStateImpl), 0, (GInstanceInitFunc) photo_reimport_raw_development_state_impl_instance_init, NULL };
	GType photo_reimport_raw_development_state_impl_type_id;
	photo_reimport_raw_development_state_impl_type_id = g_type_register_static (PHOTO_TYPE_REIMPORT_RAW_DEVELOPMENT_STATE, "PhotoReimportRawDevelopmentStateImpl", &g_define_type_info, 0);
	return photo_reimport_raw_development_state_impl_type_id;
}

static GType
photo_reimport_raw_development_state_impl_get_type (void)
{
	static volatile gsize photo_reimport_raw_development_state_impl_type_id__once = 0;
	if (g_once_init_enter (&photo_reimport_raw_development_state_impl_type_id__once)) {
		GType photo_reimport_raw_development_state_impl_type_id;
		photo_reimport_raw_development_state_impl_type_id = photo_reimport_raw_development_state_impl_get_type_once ();
		g_once_init_leave (&photo_reimport_raw_development_state_impl_type_id__once, photo_reimport_raw_development_state_impl_type_id);
	}
	return photo_reimport_raw_development_state_impl_type_id__once;
}

static void
photo_class_init (PhotoClass * klass,
                  gpointer klass_data)
{
	photo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Photo_private_offset);
	((PhotoClass *) klass)->notify_editable_replaced = (void (*) (Photo*, GFile*, GFile*)) photo_real_notify_editable_replaced;
	((PhotoClass *) klass)->notify_raw_development_modified = (void (*) (Photo*)) photo_real_notify_raw_development_modified;
	((PhotoClass *) klass)->notify_baseline_replaced = (void (*) (Photo*)) photo_real_notify_baseline_replaced;
	((PhotoClass *) klass)->notify_master_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_master_reimported;
	((PhotoClass *) klass)->notify_editable_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_editable_reimported;
	((PhotoClass *) klass)->notify_source_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_source_reimported;
	((PhotoClass *) klass)->notify_baseline_reimported = (void (*) (Photo*, PhotoMetadata*)) photo_real_notify_baseline_reimported;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) photo_real_internal_delete_backing;
	((MediaSourceClass *) klass)->get_backing_files_state = (BackingFileState** (*) (MediaSource*, gint*)) photo_real_get_backing_files_state;
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo*, PhotoMetadata*)) photo_real_apply_user_metadata_for_reimport;
	((DataSourceClass *) klass)->get_typename = (gchar* (*) (DataSource*)) photo_real_get_typename;
	((DataSourceClass *) klass)->get_instance_id = (gint64 (*) (DataSource*)) photo_real_get_instance_id;
	((DataSourceClass *) klass)->get_source_id = (gchar* (*) (DataSource*)) photo_real_get_source_id;
	((ThumbnailSourceClass *) klass)->get_preferred_thumbnail_format = (PhotoFileFormat (*) (ThumbnailSource*)) photo_real_get_preferred_thumbnail_format;
	((ThumbnailSourceClass *) klass)->create_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) photo_real_create_thumbnail;
	((MediaSourceClass *) klass)->get_file = (GFile* (*) (MediaSource*)) photo_real_get_file;
	((MediaSourceClass *) klass)->get_master_file = (GFile* (*) (MediaSource*)) photo_real_get_master_file;
	((MediaSourceClass *) klass)->get_timestamp = (GDateTime* (*) (MediaSource*)) photo_real_get_timestamp;
	((MediaSourceClass *) klass)->get_event_id = (void (*) (MediaSource*, EventID*)) photo_real_get_event_id;
	((MediaSourceClass *) klass)->get_import_id = (void (*) (MediaSource*, ImportID*)) photo_real_get_import_id;
	((MediaSourceClass *) klass)->get_master_md5 = (gchar* (*) (MediaSource*)) photo_real_get_master_md5;
	((MediaSourceClass *) klass)->get_rating = (Rating (*) (MediaSource*)) photo_real_get_rating;
	((MediaSourceClass *) klass)->set_rating = (void (*) (MediaSource*, Rating)) photo_real_set_rating;
	((MediaSourceClass *) klass)->increase_rating = (void (*) (MediaSource*)) photo_real_increase_rating;
	((MediaSourceClass *) klass)->decrease_rating = (void (*) (MediaSource*)) photo_real_decrease_rating;
	((DataSourceClass *) klass)->commit_backlinks = (void (*) (DataSource*, SourceCollection*, const gchar*)) photo_real_commit_backlinks;
	((MediaSourceClass *) klass)->set_event_id = (gboolean (*) (MediaSource*, EventID*)) photo_real_set_event_id;
	((DataObjectClass *) klass)->to_string = (gchar* (*) (DataObject*)) photo_real_to_string;
	((DataSourceClass *) klass)->equals = (gboolean (*) (DataSource*, DataSource*)) photo_real_equals;
	((MediaSourceClass *) klass)->get_filesize = (guint64 (*) (MediaSource*)) photo_real_get_filesize;
	((MediaSourceClass *) klass)->get_master_filesize = (guint64 (*) (MediaSource*)) photo_real_get_master_filesize;
	((MediaSourceClass *) klass)->get_exposure_time = (GDateTime* (*) (MediaSource*)) photo_real_get_exposure_time;
	((MediaSourceClass *) klass)->get_basename = (gchar* (*) (MediaSource*)) photo_real_get_basename;
	((MediaSourceClass *) klass)->get_title = (gchar* (*) (MediaSource*)) photo_real_get_title;
	((MediaSourceClass *) klass)->get_comment = (gchar* (*) (MediaSource*)) photo_real_get_comment;
	((MediaSourceClass *) klass)->set_title = (void (*) (MediaSource*, const gchar*)) photo_real_set_title;
	((MediaSourceClass *) klass)->set_comment = (gboolean (*) (MediaSource*, const gchar*)) photo_real_set_comment;
	((MediaSourceClass *) klass)->get_dimensions = (void (*) (MediaSource*, PhotoException, Dimensions*)) photo_real_get_dimensions;
	((PhotoSourceClass *) klass)->get_metadata = (PhotoMetadata* (*) (PhotoSource*)) photo_real_get_metadata;
	((PhotoClass *) klass)->rotate = (void (*) (Photo*, Rotation)) photo_real_rotate;
	((PhotoSourceClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (PhotoSource*, Scaling*, GError**)) photo_real_get_pixbuf;
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo*)) photo_real_has_user_generated_metadata;
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo*, PhotoMetadata*)) photo_real_set_user_metadata_for_export;
	((PhotoClass *) klass)->editable_replaced = photo_real_editable_replaced;
	((PhotoClass *) klass)->raw_development_modified = photo_real_raw_development_modified;
	((PhotoClass *) klass)->baseline_replaced = photo_real_baseline_replaced;
	((PhotoClass *) klass)->master_reimported = photo_real_master_reimported;
	((PhotoClass *) klass)->editable_reimported = photo_real_editable_reimported;
	((PhotoClass *) klass)->baseline_reimported = photo_real_baseline_reimported;
	((PhotoClass *) klass)->source_reimported = photo_real_source_reimported;
	G_OBJECT_CLASS (klass)->get_property = _vala_photo_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_photo_set_property;
	G_OBJECT_CLASS (klass)->finalize = photo_finalize;
	photo_signals[PHOTO_EDITABLE_REPLACED_SIGNAL] = g_signal_new ("editable-replaced", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, editable_replaced), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, g_file_get_type (), g_file_get_type ());
	photo_signals[PHOTO_RAW_DEVELOPMENT_MODIFIED_SIGNAL] = g_signal_new ("raw-development-modified", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, raw_development_modified), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	photo_signals[PHOTO_BASELINE_REPLACED_SIGNAL] = g_signal_new ("baseline-replaced", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, baseline_replaced), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	photo_signals[PHOTO_MASTER_REIMPORTED_SIGNAL] = g_signal_new ("master-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, master_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	photo_signals[PHOTO_EDITABLE_REIMPORTED_SIGNAL] = g_signal_new ("editable-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, editable_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	photo_signals[PHOTO_BASELINE_REIMPORTED_SIGNAL] = g_signal_new ("baseline-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, baseline_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	photo_signals[PHOTO_SOURCE_REIMPORTED_SIGNAL] = g_signal_new ("source-reimported", TYPE_PHOTO, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (PhotoClass, source_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__MEDIA_METADATA, G_TYPE_NONE, 1, TYPE_PHOTO_METADATA);
	g_rec_mutex_init (&__lock_photo_photo_source_pixbuf_cache);
}

static void
photo_dateable_interface_init (DateableIface * iface,
                               gpointer iface_data)
{
	photo_dateable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_exposure_time = (GDateTime* (*) (Dateable*)) photo_real_get_exposure_time;
	iface->set_exposure_time = (void (*) (Dateable*, GDateTime*)) photo_real_set_exposure_time;
}

static void
photo_positionable_interface_init (PositionableIface * iface,
                                   gpointer iface_data)
{
	photo_positionable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_gps_coords = (void (*) (Positionable*, GpsCoords*)) photo_real_get_gps_coords;
	iface->set_gps_coords = (void (*) (Positionable*, GpsCoords*)) photo_real_set_gps_coords;
}

static void
photo_instance_init (Photo * self,
                     gpointer klass)
{
	BackingPhotoRow* _tmp0_;
	PhotoBackingReaders* _tmp1_;
	self->priv = photo_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_row);
	_tmp0_ = backing_photo_row_new ();
	self->priv->editable = _tmp0_;
	g_rec_mutex_init (&self->priv->__lock_readers);
	_tmp1_ = photo_backing_readers_new ();
	self->priv->readers = _tmp1_;
	self->priv->transformer = NULL;
	self->priv->adjustments = NULL;
	self->priv->file_title = NULL;
	self->priv->editable_monitor = NULL;
	self->priv->reimport_editable_scheduler = NULL;
	self->priv->update_editable_attributes_scheduler = NULL;
	self->priv->remove_editable_scheduler = NULL;
	self->can_rotate_now = TRUE;
	g_rec_mutex_init (&self->priv->__lock_developments);
	self->priv->developments = NULL;
	self->backing_photo_row = NULL;
}

static void
photo_finalize (GObject * obj)
{
	Photo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PHOTO, Photo);
	_g_date_time_unref0 (self->priv->cached_exposure_time);
	g_rec_mutex_clear (&self->priv->__lock_row);
	_photo_row_unref0 (self->row);
	_backing_photo_row_unref0 (self->priv->editable);
	g_rec_mutex_clear (&self->priv->__lock_readers);
	_photo_backing_readers_unref0 (self->priv->readers);
	_pixel_transformer_unref0 (self->priv->transformer);
	_pixel_transformation_bundle_unref0 (self->priv->adjustments);
	_g_free0 (self->priv->file_title);
	_g_object_unref0 (self->priv->editable_monitor);
	_one_shot_scheduler_unref0 (self->priv->reimport_editable_scheduler);
	_one_shot_scheduler_unref0 (self->priv->update_editable_attributes_scheduler);
	_one_shot_scheduler_unref0 (self->priv->remove_editable_scheduler);
	g_rec_mutex_clear (&self->priv->__lock_developments);
	_g_object_unref0 (self->priv->developments);
	_backing_photo_row_unref0 (self->backing_photo_row);
	G_OBJECT_CLASS (photo_parent_class)->finalize (obj);
}

static GType
photo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Photo), 0, (GInstanceInitFunc) photo_instance_init, NULL };
	static const GInterfaceInfo dateable_info = { (GInterfaceInitFunc) photo_dateable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo positionable_info = { (GInterfaceInitFunc) photo_positionable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType photo_type_id;
	photo_type_id = g_type_register_static (TYPE_PHOTO_SOURCE, "Photo", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	g_type_add_interface_static (photo_type_id, TYPE_DATEABLE, &dateable_info);
	g_type_add_interface_static (photo_type_id, TYPE_POSITIONABLE, &positionable_info);
	Photo_private_offset = g_type_add_instance_private (photo_type_id, sizeof (PhotoPrivate));
	return photo_type_id;
}

GType
photo_get_type (void)
{
	static volatile gsize photo_type_id__once = 0;
	if (g_once_init_enter (&photo_type_id__once)) {
		GType photo_type_id;
		photo_type_id = photo_get_type_once ();
		g_once_init_leave (&photo_type_id__once, photo_type_id);
	}
	return photo_type_id__once;
}

static void
_vala_photo_get_property (GObject * object,
                          guint property_id,
                          GValue * value,
                          GParamSpec * pspec)
{
	Photo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PHOTO, Photo);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_photo_set_property (GObject * object,
                          guint property_id,
                          const GValue * value,
                          GParamSpec * pspec)
{
	Photo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_PHOTO, Photo);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
library_photo_source_collection_get_instance_private (LibraryPhotoSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryPhotoSourceCollection_private_offset);
}

static GType
library_photo_source_collection_state_get_type_once (void)
{
	static const GEnumValue values[] = {{LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN", "unknown"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE", "online"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE", "offline"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH", "trash"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE", "editable"}, {LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER, "LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER", "developer"}, {0, NULL, NULL}};
	GType library_photo_source_collection_state_type_id;
	library_photo_source_collection_state_type_id = g_enum_register_static ("LibraryPhotoSourceCollectionState", values);
	return library_photo_source_collection_state_type_id;
}

GType
library_photo_source_collection_state_get_type (void)
{
	static volatile gsize library_photo_source_collection_state_type_id__once = 0;
	if (g_once_init_enter (&library_photo_source_collection_state_type_id__once)) {
		GType library_photo_source_collection_state_type_id;
		library_photo_source_collection_state_type_id = library_photo_source_collection_state_get_type_once ();
		g_once_init_leave (&library_photo_source_collection_state_type_id__once, library_photo_source_collection_state_type_id);
	}
	return library_photo_source_collection_state_type_id__once;
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static gint
_int64_compare_gcompare_data_func (gconstpointer a,
                                   gconstpointer b,
                                   gpointer self)
{
	gint result;
	result = int64_compare ((gint64*) a, (gint64*) b);
	return result;
}

static gint64*
_int64_dup (gint64* self)
{
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}

static gboolean
_int64_equal_gee_equal_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gboolean result;
	result = int64_equal ((gint64*) a, (gint64*) b);
	return result;
}

static gint64
_photo_get_photo_key_get_source_database_key (DataSource* source,
                                              gpointer self)
{
	gint64 result;
	result = photo_get_photo_key (source);
	return result;
}

static void
_library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                    GeeCollection* added,
                                                                                                    GeeCollection* removed,
                                                                                                    gpointer self)
{
	library_photo_source_collection_on_trashcan_contents_altered ((LibraryPhotoSourceCollection*) self, added, removed);
}

static void
_library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered (SourceHoldingTank* _sender,
                                                                                                   GeeCollection* added,
                                                                                                   GeeCollection* removed,
                                                                                                   gpointer self)
{
	library_photo_source_collection_on_offline_contents_altered ((LibraryPhotoSourceCollection*) self, added, removed);
}

LibraryPhotoSourceCollection*
library_photo_source_collection_construct (GType object_type)
{
	LibraryPhotoSourceCollection* self = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	self = (LibraryPhotoSourceCollection*) media_source_collection_construct (object_type, "LibraryPhotoSourceCollection", _photo_get_photo_key_get_source_database_key, NULL);
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _library_photo_source_collection_on_trashcan_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp1_);
	_tmp2_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp3_ = _tmp2_;
	g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), "contents-altered", (GCallback) _library_photo_source_collection_on_offline_contents_altered_source_holding_tank_contents_altered, self);
	_source_holding_tank_unref0 (_tmp3_);
	return self;
}

LibraryPhotoSourceCollection*
library_photo_source_collection_new (void)
{
	return library_photo_source_collection_construct (TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION);
}

static gboolean
_library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                           Alteration* alteration,
                                                                                           gpointer self)
{
	gboolean result;
	result = library_photo_source_collection_check_if_trashed_photo ((LibraryPhotoSourceCollection*) self, source, alteration);
	return result;
}

static MediaSourceHoldingTank*
library_photo_source_collection_real_create_trashcan (MediaSourceCollection* base)
{
	LibraryPhotoSourceCollection * self;
	LibraryPhotoSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	_tmp0_ = library_photo_source_holding_tank_new (self, _library_photo_source_collection_check_if_trashed_photo_source_holding_tank_check_to_keep, self, _photo_get_photo_key_get_source_database_key, NULL);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank);
	return result;
}

static gboolean
_library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep (DataSource* source,
                                                                                           Alteration* alteration,
                                                                                           gpointer self)
{
	gboolean result;
	result = library_photo_source_collection_check_if_offline_photo ((LibraryPhotoSourceCollection*) self, source, alteration);
	return result;
}

static MediaSourceHoldingTank*
library_photo_source_collection_real_create_offline_bin (MediaSourceCollection* base)
{
	LibraryPhotoSourceCollection * self;
	LibraryPhotoSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	_tmp0_ = library_photo_source_holding_tank_new (self, _library_photo_source_collection_check_if_offline_photo_source_holding_tank_check_to_keep, self, _photo_get_photo_key_get_source_database_key, NULL);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank);
	return result;
}

static MediaMonitor*
library_photo_source_collection_real_create_media_monitor (MediaSourceCollection* base,
                                                           Workers* workers,
                                                           GCancellable* cancellable)
{
	LibraryPhotoSourceCollection * self;
	PhotoMonitor* _tmp0_;
	MediaMonitor* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_val_if_fail (IS_WORKERS (workers), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = photo_monitor_new (workers, cancellable);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_MONITOR, MediaMonitor);
	return result;
}

static gboolean
library_photo_source_collection_real_holds_type_of_source (SourceCollection* base,
                                                           DataSource* source)
{
	LibraryPhotoSourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	result = IS_LIBRARY_PHOTO (source);
	return result;
}

static gchar*
library_photo_source_collection_real_get_typename (MediaSourceCollection* base)
{
	LibraryPhotoSourceCollection * self;
	gchar* _tmp0_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	_tmp0_ = g_strdup (PHOTO_TYPENAME);
	result = _tmp0_;
	return result;
}

static gboolean
library_photo_source_collection_real_is_file_recognized (MediaSourceCollection* base,
                                                         GFile* file)
{
	LibraryPhotoSourceCollection * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	result = photo_file_format_is_file_supported (file);
	return result;
}

static void
_library_photo_source_collection_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                               GFile* old_file,
                                                                               GFile* new_file,
                                                                               gpointer self)
{
	library_photo_source_collection_on_editable_replaced ((LibraryPhotoSourceCollection*) self, _sender, old_file, new_file);
}

static void
_library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                             gpointer self)
{
	library_photo_source_collection_on_raw_development_modified ((LibraryPhotoSourceCollection*) self, _sender);
}

static void
library_photo_source_collection_real_notify_contents_altered (DataCollection* base,
                                                              GeeIterable* added,
                                                              GeeIterable* removed)
{
	LibraryPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_ITERABLE));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_ITERABLE));
	if (added != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (added);
			_object_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataObject* object = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				LibraryPhoto* photo = NULL;
				DataObject* _tmp4_;
				LibraryPhoto* _tmp5_;
				GFile* editable = NULL;
				LibraryPhoto* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				LibraryPhoto* _tmp12_;
				GeeCollection* raw_list = NULL;
				LibraryPhoto* _tmp13_;
				GeeCollection* _tmp14_;
				GeeCollection* _tmp15_;
				LibraryPhoto* _tmp24_;
				gint64 master_filesize = 0LL;
				LibraryPhoto* _tmp25_;
				BackingPhotoRow* _tmp26_;
				BackingPhotoRow* _tmp27_;
				gint64 _tmp28_;
				gint64 _tmp29_ = 0LL;
				LibraryPhoto* _tmp30_;
				BackingPhotoRow* _tmp31_;
				BackingPhotoRow* _tmp32_;
				gboolean _tmp33_;
				gint64 editable_filesize = 0LL;
				GeeMultiMap* _tmp37_;
				LibraryPhoto* _tmp38_;
				GeeHashMap* _tmp39_;
				LibraryPhoto* _tmp40_;
				GeeCollection* raw_rows = NULL;
				LibraryPhoto* _tmp45_;
				GeeCollection* _tmp46_;
				GeeCollection* _tmp47_;
				_tmp1_ = _object_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _object_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				object = (DataObject*) _tmp3_;
				_tmp4_ = object;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp5_;
				_tmp6_ = photo;
				_tmp7_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
				editable = _tmp7_;
				_tmp8_ = editable;
				if (_tmp8_ != NULL) {
					GeeHashMap* _tmp9_;
					GFile* _tmp10_;
					LibraryPhoto* _tmp11_;
					_tmp9_ = self->priv->by_editable_file;
					_tmp10_ = editable;
					_tmp11_ = photo;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp10_, _tmp11_);
				}
				_tmp12_ = photo;
				g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_PHOTO, Photo), "editable-replaced", (GCallback) _library_photo_source_collection_on_editable_replaced_photo_editable_replaced, self);
				_tmp13_ = photo;
				_tmp14_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_PHOTO, Photo));
				raw_list = _tmp14_;
				_tmp15_ = raw_list;
				if (_tmp15_ != NULL) {
					{
						GeeIterator* _f_it = NULL;
						GeeCollection* _tmp16_;
						GeeIterator* _tmp17_;
						_tmp16_ = raw_list;
						_tmp17_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, GEE_TYPE_ITERABLE, GeeIterable));
						_f_it = _tmp17_;
						while (TRUE) {
							GeeIterator* _tmp18_;
							GFile* f = NULL;
							GeeIterator* _tmp19_;
							gpointer _tmp20_;
							GeeHashMap* _tmp21_;
							GFile* _tmp22_;
							LibraryPhoto* _tmp23_;
							_tmp18_ = _f_it;
							if (!gee_iterator_next (_tmp18_)) {
								break;
							}
							_tmp19_ = _f_it;
							_tmp20_ = gee_iterator_get (_tmp19_);
							f = (GFile*) _tmp20_;
							_tmp21_ = self->priv->by_raw_development_file;
							_tmp22_ = f;
							_tmp23_ = photo;
							gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp22_, _tmp23_);
							_g_object_unref0 (f);
						}
						_g_object_unref0 (_f_it);
					}
				}
				_tmp24_ = photo;
				g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_PHOTO, Photo), "raw-development-modified", (GCallback) _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified, self);
				_tmp25_ = photo;
				_tmp26_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, TYPE_PHOTO, Photo));
				_tmp27_ = _tmp26_;
				_tmp28_ = _tmp27_->filesize;
				_backing_photo_row_unref0 (_tmp27_);
				master_filesize = _tmp28_;
				_tmp30_ = photo;
				_tmp31_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO, Photo));
				_tmp32_ = _tmp31_;
				_tmp33_ = _tmp32_ != NULL;
				_backing_photo_row_unref0 (_tmp32_);
				if (_tmp33_) {
					LibraryPhoto* _tmp34_;
					BackingPhotoRow* _tmp35_;
					BackingPhotoRow* _tmp36_;
					_tmp34_ = photo;
					_tmp35_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_PHOTO, Photo));
					_tmp36_ = _tmp35_;
					_tmp29_ = _tmp36_->filesize;
					_backing_photo_row_unref0 (_tmp36_);
				} else {
					_tmp29_ = (gint64) -1;
				}
				editable_filesize = _tmp29_;
				_tmp37_ = self->priv->filesize_to_photo;
				_tmp38_ = photo;
				gee_multi_map_set (_tmp37_, &master_filesize, _tmp38_);
				_tmp39_ = self->priv->photo_to_master_filesize;
				_tmp40_ = photo;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp40_, &master_filesize);
				if (editable_filesize >= ((gint64) 0)) {
					GeeMultiMap* _tmp41_;
					LibraryPhoto* _tmp42_;
					GeeHashMap* _tmp43_;
					LibraryPhoto* _tmp44_;
					_tmp41_ = self->priv->filesize_to_photo;
					_tmp42_ = photo;
					gee_multi_map_set (_tmp41_, &editable_filesize, _tmp42_);
					_tmp43_ = self->priv->photo_to_editable_filesize;
					_tmp44_ = photo;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp43_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp44_, &editable_filesize);
				}
				_tmp45_ = photo;
				_tmp46_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_PHOTO, Photo));
				raw_rows = _tmp46_;
				_tmp47_ = raw_rows;
				if (_tmp47_ != NULL) {
					{
						GeeIterator* _row_it = NULL;
						GeeCollection* _tmp48_;
						GeeIterator* _tmp49_;
						_tmp48_ = raw_rows;
						_tmp49_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_ITERABLE, GeeIterable));
						_row_it = _tmp49_;
						while (TRUE) {
							GeeIterator* _tmp50_;
							BackingPhotoRow* row = NULL;
							GeeIterator* _tmp51_;
							gpointer _tmp52_;
							BackingPhotoRow* _tmp53_;
							_tmp50_ = _row_it;
							if (!gee_iterator_next (_tmp50_)) {
								break;
							}
							_tmp51_ = _row_it;
							_tmp52_ = gee_iterator_get (_tmp51_);
							row = (BackingPhotoRow*) _tmp52_;
							_tmp53_ = row;
							if (_tmp53_->filesize >= ((gint64) 0)) {
								GeeMultiMap* _tmp54_;
								BackingPhotoRow* _tmp55_;
								LibraryPhoto* _tmp56_;
								GeeMultiMap* _tmp57_;
								LibraryPhoto* _tmp58_;
								BackingPhotoRow* _tmp59_;
								_tmp54_ = self->priv->filesize_to_photo;
								_tmp55_ = row;
								_tmp56_ = photo;
								gee_multi_map_set (_tmp54_, &_tmp55_->filesize, _tmp56_);
								_tmp57_ = self->priv->photo_to_raw_development_filesize;
								_tmp58_ = photo;
								_tmp59_ = row;
								gee_multi_map_set (_tmp57_, _tmp58_, &_tmp59_->filesize);
							}
							_backing_photo_row_unref0 (row);
						}
						_g_object_unref0 (_row_it);
					}
				}
				_g_object_unref0 (raw_rows);
				_g_object_unref0 (raw_list);
				_g_object_unref0 (editable);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _object_it = NULL;
			GeeIterator* _tmp60_;
			_tmp60_ = gee_iterable_iterator (removed);
			_object_it = _tmp60_;
			while (TRUE) {
				GeeIterator* _tmp61_;
				DataObject* object = NULL;
				GeeIterator* _tmp62_;
				gpointer _tmp63_;
				LibraryPhoto* photo = NULL;
				DataObject* _tmp64_;
				LibraryPhoto* _tmp65_;
				GFile* editable = NULL;
				LibraryPhoto* _tmp66_;
				GFile* _tmp67_;
				GFile* _tmp68_;
				LibraryPhoto* _tmp74_;
				guint _tmp75_;
				GeeCollection* raw_list = NULL;
				LibraryPhoto* _tmp76_;
				GeeCollection* _tmp77_;
				GeeCollection* _tmp78_;
				LibraryPhoto* _tmp86_;
				guint _tmp87_;
				gint64 master_filesize = 0LL;
				LibraryPhoto* _tmp88_;
				BackingPhotoRow* _tmp89_;
				BackingPhotoRow* _tmp90_;
				gint64 _tmp91_;
				gint64 _tmp92_ = 0LL;
				LibraryPhoto* _tmp93_;
				BackingPhotoRow* _tmp94_;
				BackingPhotoRow* _tmp95_;
				gboolean _tmp96_;
				gint64 editable_filesize = 0LL;
				GeeMultiMap* _tmp100_;
				LibraryPhoto* _tmp101_;
				GeeHashMap* _tmp102_;
				LibraryPhoto* _tmp103_;
				GeeCollection* raw_rows = NULL;
				LibraryPhoto* _tmp108_;
				GeeCollection* _tmp109_;
				GeeCollection* _tmp110_;
				_tmp61_ = _object_it;
				if (!gee_iterator_next (_tmp61_)) {
					break;
				}
				_tmp62_ = _object_it;
				_tmp63_ = gee_iterator_get (_tmp62_);
				object = (DataObject*) _tmp63_;
				_tmp64_ = object;
				_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp65_;
				_tmp66_ = photo;
				_tmp67_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, TYPE_PHOTO, Photo));
				editable = _tmp67_;
				_tmp68_ = editable;
				if (_tmp68_ != NULL) {
					gboolean is_removed = FALSE;
					GeeHashMap* _tmp69_;
					LibraryPhoto* _tmp70_;
					GFile* _tmp71_;
					GFile* _tmp72_;
					gboolean _tmp73_;
					_tmp69_ = self->priv->by_editable_file;
					_tmp70_ = photo;
					_tmp71_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_PHOTO, Photo));
					_tmp72_ = _tmp71_;
					_tmp73_ = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp72_, NULL);
					_g_object_unref0 (_tmp72_);
					is_removed = _tmp73_;
					_vala_assert (is_removed, "is_removed");
				}
				_tmp74_ = photo;
				g_signal_parse_name ("editable-replaced", TYPE_PHOTO, &_tmp75_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, TYPE_PHOTO, Photo), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp75_, 0, NULL, (GCallback) _library_photo_source_collection_on_editable_replaced_photo_editable_replaced, self);
				_tmp76_ = photo;
				_tmp77_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, TYPE_PHOTO, Photo));
				raw_list = _tmp77_;
				_tmp78_ = raw_list;
				if (_tmp78_ != NULL) {
					{
						GeeIterator* _f_it = NULL;
						GeeCollection* _tmp79_;
						GeeIterator* _tmp80_;
						_tmp79_ = raw_list;
						_tmp80_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GEE_TYPE_ITERABLE, GeeIterable));
						_f_it = _tmp80_;
						while (TRUE) {
							GeeIterator* _tmp81_;
							GFile* f = NULL;
							GeeIterator* _tmp82_;
							gpointer _tmp83_;
							GeeHashMap* _tmp84_;
							GFile* _tmp85_;
							_tmp81_ = _f_it;
							if (!gee_iterator_next (_tmp81_)) {
								break;
							}
							_tmp82_ = _f_it;
							_tmp83_ = gee_iterator_get (_tmp82_);
							f = (GFile*) _tmp83_;
							_tmp84_ = self->priv->by_raw_development_file;
							_tmp85_ = f;
							gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp84_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp85_, NULL);
							_g_object_unref0 (f);
						}
						_g_object_unref0 (_f_it);
					}
				}
				_tmp86_ = photo;
				g_signal_parse_name ("raw-development-modified", TYPE_PHOTO, &_tmp87_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, TYPE_PHOTO, Photo), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp87_, 0, NULL, (GCallback) _library_photo_source_collection_on_raw_development_modified_photo_raw_development_modified, self);
				_tmp88_ = photo;
				_tmp89_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, TYPE_PHOTO, Photo));
				_tmp90_ = _tmp89_;
				_tmp91_ = _tmp90_->filesize;
				_backing_photo_row_unref0 (_tmp90_);
				master_filesize = _tmp91_;
				_tmp93_ = photo;
				_tmp94_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, TYPE_PHOTO, Photo));
				_tmp95_ = _tmp94_;
				_tmp96_ = _tmp95_ != NULL;
				_backing_photo_row_unref0 (_tmp95_);
				if (_tmp96_) {
					LibraryPhoto* _tmp97_;
					BackingPhotoRow* _tmp98_;
					BackingPhotoRow* _tmp99_;
					_tmp97_ = photo;
					_tmp98_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, TYPE_PHOTO, Photo));
					_tmp99_ = _tmp98_;
					_tmp92_ = _tmp99_->filesize;
					_backing_photo_row_unref0 (_tmp99_);
				} else {
					_tmp92_ = (gint64) -1;
				}
				editable_filesize = _tmp92_;
				_tmp100_ = self->priv->filesize_to_photo;
				_tmp101_ = photo;
				gee_multi_map_remove (_tmp100_, &master_filesize, _tmp101_);
				_tmp102_ = self->priv->photo_to_master_filesize;
				_tmp103_ = photo;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp103_, NULL);
				if (editable_filesize >= ((gint64) 0)) {
					GeeMultiMap* _tmp104_;
					LibraryPhoto* _tmp105_;
					GeeHashMap* _tmp106_;
					LibraryPhoto* _tmp107_;
					_tmp104_ = self->priv->filesize_to_photo;
					_tmp105_ = photo;
					gee_multi_map_remove (_tmp104_, &editable_filesize, _tmp105_);
					_tmp106_ = self->priv->photo_to_editable_filesize;
					_tmp107_ = photo;
					gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp107_, NULL);
				}
				_tmp108_ = photo;
				_tmp109_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (_tmp108_, TYPE_PHOTO, Photo));
				raw_rows = _tmp109_;
				_tmp110_ = raw_rows;
				if (_tmp110_ != NULL) {
					{
						GeeIterator* _row_it = NULL;
						GeeCollection* _tmp111_;
						GeeIterator* _tmp112_;
						_tmp111_ = raw_rows;
						_tmp112_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, GEE_TYPE_ITERABLE, GeeIterable));
						_row_it = _tmp112_;
						while (TRUE) {
							GeeIterator* _tmp113_;
							BackingPhotoRow* row = NULL;
							GeeIterator* _tmp114_;
							gpointer _tmp115_;
							BackingPhotoRow* _tmp116_;
							_tmp113_ = _row_it;
							if (!gee_iterator_next (_tmp113_)) {
								break;
							}
							_tmp114_ = _row_it;
							_tmp115_ = gee_iterator_get (_tmp114_);
							row = (BackingPhotoRow*) _tmp115_;
							_tmp116_ = row;
							if (_tmp116_->filesize >= ((gint64) 0)) {
								GeeMultiMap* _tmp117_;
								BackingPhotoRow* _tmp118_;
								LibraryPhoto* _tmp119_;
								GeeMultiMap* _tmp120_;
								LibraryPhoto* _tmp121_;
								BackingPhotoRow* _tmp122_;
								_tmp117_ = self->priv->filesize_to_photo;
								_tmp118_ = row;
								_tmp119_ = photo;
								gee_multi_map_remove (_tmp117_, &_tmp118_->filesize, _tmp119_);
								_tmp120_ = self->priv->photo_to_raw_development_filesize;
								_tmp121_ = photo;
								_tmp122_ = row;
								gee_multi_map_remove (_tmp120_, _tmp121_, &_tmp122_->filesize);
							}
							_backing_photo_row_unref0 (row);
						}
						_g_object_unref0 (_row_it);
					}
				}
				_g_object_unref0 (raw_rows);
				_g_object_unref0 (raw_list);
				_g_object_unref0 (editable);
				_g_object_unref0 (photo);
				_g_object_unref0 (object);
			}
			_g_object_unref0 (_object_it);
		}
	}
	DATA_COLLECTION_CLASS (library_photo_source_collection_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_DATA_COLLECTION, DataCollection), added, removed);
}

static void
library_photo_source_collection_on_editable_replaced (LibraryPhotoSourceCollection* self,
                                                      Photo* photo,
                                                      GFile* old_file,
                                                      GFile* new_file)
{
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_PHOTO (photo));
	g_return_if_fail ((old_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail ((new_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	if (old_file != NULL) {
		gboolean is_removed = FALSE;
		GeeHashMap* _tmp0_;
		_tmp0_ = self->priv->by_editable_file;
		is_removed = gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), old_file, NULL);
		_vala_assert (is_removed, "is_removed");
	}
	if (new_file != NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = self->priv->by_editable_file;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), new_file, G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_LIBRARY_PHOTO, LibraryPhoto));
	}
}

static void
library_photo_source_collection_on_raw_development_modified (LibraryPhotoSourceCollection* self,
                                                             Photo* _photo)
{
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GeeMultiMap* _tmp2_;
	LibraryPhoto* _tmp3_;
	GeeCollection* raw_list = NULL;
	LibraryPhoto* _tmp19_;
	GeeCollection* _tmp20_;
	GeeCollection* _tmp21_;
	GeeCollection* raw_rows = NULL;
	LibraryPhoto* _tmp30_;
	GeeCollection* _tmp31_;
	GeeCollection* _tmp32_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_PHOTO (_photo));
	_tmp0_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_photo) ? ((LibraryPhoto*) _photo) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (photo);
		return;
	}
	_tmp2_ = self->priv->photo_to_raw_development_filesize;
	_tmp3_ = photo;
	if (gee_multi_map_contains (_tmp2_, _tmp3_)) {
		GeeMultiMap* _tmp17_;
		LibraryPhoto* _tmp18_;
		{
			GeeIterator* _s_it = NULL;
			GeeMultiMap* _tmp4_;
			LibraryPhoto* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeIterator* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp4_ = self->priv->photo_to_raw_development_filesize;
			_tmp5_ = photo;
			_tmp6_ = gee_multi_map_get (_tmp4_, _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			_s_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				gint64 s = 0LL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				gint64* _tmp13_;
				gint64 _tmp14_;
				GeeMultiMap* _tmp15_;
				LibraryPhoto* _tmp16_;
				_tmp10_ = _s_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _s_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				_tmp13_ = (gint64*) _tmp12_;
				_tmp14_ = *_tmp13_;
				_g_free0 (_tmp13_);
				s = _tmp14_;
				_tmp15_ = self->priv->filesize_to_photo;
				_tmp16_ = photo;
				gee_multi_map_remove (_tmp15_, &s, _tmp16_);
			}
			_g_object_unref0 (_s_it);
		}
		_tmp17_ = self->priv->photo_to_raw_development_filesize;
		_tmp18_ = photo;
		gee_multi_map_remove_all (_tmp17_, _tmp18_);
	}
	_tmp19_ = photo;
	_tmp20_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_PHOTO, Photo));
	raw_list = _tmp20_;
	_tmp21_ = raw_list;
	if (_tmp21_ != NULL) {
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp22_;
			GeeIterator* _tmp23_;
			_tmp22_ = raw_list;
			_tmp23_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ITERABLE, GeeIterable));
			_f_it = _tmp23_;
			while (TRUE) {
				GeeIterator* _tmp24_;
				GFile* f = NULL;
				GeeIterator* _tmp25_;
				gpointer _tmp26_;
				GeeHashMap* _tmp27_;
				GFile* _tmp28_;
				LibraryPhoto* _tmp29_;
				_tmp24_ = _f_it;
				if (!gee_iterator_next (_tmp24_)) {
					break;
				}
				_tmp25_ = _f_it;
				_tmp26_ = gee_iterator_get (_tmp25_);
				f = (GFile*) _tmp26_;
				_tmp27_ = self->priv->by_raw_development_file;
				_tmp28_ = f;
				_tmp29_ = photo;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp28_, _tmp29_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	_tmp30_ = photo;
	_tmp31_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_PHOTO, Photo));
	raw_rows = _tmp31_;
	_tmp32_ = raw_rows;
	if (_tmp32_ != NULL) {
		{
			GeeIterator* _row_it = NULL;
			GeeCollection* _tmp33_;
			GeeIterator* _tmp34_;
			_tmp33_ = raw_rows;
			_tmp34_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_ITERABLE, GeeIterable));
			_row_it = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_;
				BackingPhotoRow* row = NULL;
				GeeIterator* _tmp36_;
				gpointer _tmp37_;
				BackingPhotoRow* _tmp38_;
				_tmp35_ = _row_it;
				if (!gee_iterator_next (_tmp35_)) {
					break;
				}
				_tmp36_ = _row_it;
				_tmp37_ = gee_iterator_get (_tmp36_);
				row = (BackingPhotoRow*) _tmp37_;
				_tmp38_ = row;
				if (_tmp38_->filesize > ((gint64) 0)) {
					GeeMultiMap* _tmp39_;
					BackingPhotoRow* _tmp40_;
					LibraryPhoto* _tmp41_;
					GeeMultiMap* _tmp42_;
					LibraryPhoto* _tmp43_;
					BackingPhotoRow* _tmp44_;
					_tmp39_ = self->priv->filesize_to_photo;
					_tmp40_ = row;
					_tmp41_ = photo;
					gee_multi_map_set (_tmp39_, &_tmp40_->filesize, _tmp41_);
					_tmp42_ = self->priv->photo_to_raw_development_filesize;
					_tmp43_ = photo;
					_tmp44_ = row;
					gee_multi_map_set (_tmp42_, _tmp43_, &_tmp44_->filesize);
				}
				_backing_photo_row_unref0 (row);
			}
			_g_object_unref0 (_row_it);
		}
	}
	_g_object_unref0 (raw_rows);
	_g_object_unref0 (raw_list);
	_g_object_unref0 (photo);
}

static gpointer
__int64_dup0 (gpointer self)
{
	return self ? _int64_dup (self) : NULL;
}

static void
library_photo_source_collection_real_items_altered (DataCollection* base,
                                                    GeeMap* items)
{
	LibraryPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_MAP));
	{
		GeeIterator* _object_it = NULL;
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = gee_map_get_keys (items);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_object_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			DataObject* object = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			Alteration* alteration = NULL;
			DataObject* _tmp8_;
			gpointer _tmp9_;
			LibraryPhoto* photo = NULL;
			DataObject* _tmp10_;
			LibraryPhoto* _tmp11_;
			gboolean _tmp12_ = FALSE;
			Alteration* _tmp13_;
			_tmp5_ = _object_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _object_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			object = (DataObject*) _tmp7_;
			_tmp8_ = object;
			_tmp9_ = gee_map_get (items, _tmp8_);
			alteration = (Alteration*) _tmp9_;
			_tmp10_ = object;
			_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp11_;
			_tmp13_ = alteration;
			if (alteration_has_detail (_tmp13_, "image", "master")) {
				_tmp12_ = TRUE;
			} else {
				Alteration* _tmp14_;
				_tmp14_ = alteration;
				_tmp12_ = alteration_has_detail (_tmp14_, "image", "editable");
			}
			if (_tmp12_) {
				gint64 old_master_filesize = 0LL;
				GeeHashMap* _tmp15_;
				LibraryPhoto* _tmp16_;
				gpointer _tmp17_;
				gint64* _tmp18_;
				gint64 _tmp19_;
				gint64* _tmp20_ = NULL;
				GeeHashMap* _tmp21_;
				LibraryPhoto* _tmp22_;
				gint64 old_editable_filesize = 0LL;
				GeeHashMap* _tmp28_;
				LibraryPhoto* _tmp29_;
				GeeMultiMap* _tmp30_;
				LibraryPhoto* _tmp31_;
				gint64 master_filesize = 0LL;
				LibraryPhoto* _tmp36_;
				BackingPhotoRow* _tmp37_;
				BackingPhotoRow* _tmp38_;
				gint64 _tmp39_;
				gint64 _tmp40_ = 0LL;
				LibraryPhoto* _tmp41_;
				BackingPhotoRow* _tmp42_;
				BackingPhotoRow* _tmp43_;
				gboolean _tmp44_;
				gint64 editable_filesize = 0LL;
				GeeHashMap* _tmp48_;
				LibraryPhoto* _tmp49_;
				GeeMultiMap* _tmp50_;
				LibraryPhoto* _tmp51_;
				_tmp15_ = self->priv->photo_to_master_filesize;
				_tmp16_ = photo;
				_tmp17_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp16_);
				_tmp18_ = (gint64*) _tmp17_;
				_tmp19_ = *_tmp18_;
				_g_free0 (_tmp18_);
				old_master_filesize = _tmp19_;
				_tmp21_ = self->priv->photo_to_editable_filesize;
				_tmp22_ = photo;
				if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp22_)) {
					GeeHashMap* _tmp23_;
					LibraryPhoto* _tmp24_;
					gpointer _tmp25_;
					_tmp23_ = self->priv->photo_to_editable_filesize;
					_tmp24_ = photo;
					_tmp25_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_);
					_g_free0 (_tmp20_);
					_tmp20_ = (gint64*) _tmp25_;
				} else {
					gint64 _tmp26_;
					gint64* _tmp27_;
					_tmp26_ = (gint64) -1;
					_tmp27_ = __int64_dup0 (&_tmp26_);
					_g_free0 (_tmp20_);
					_tmp20_ = _tmp27_;
				}
				old_editable_filesize = *_tmp20_;
				_tmp28_ = self->priv->photo_to_master_filesize;
				_tmp29_ = photo;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp29_, NULL);
				_tmp30_ = self->priv->filesize_to_photo;
				_tmp31_ = photo;
				gee_multi_map_remove (_tmp30_, &old_master_filesize, _tmp31_);
				if (old_editable_filesize >= ((gint64) 0)) {
					GeeHashMap* _tmp32_;
					LibraryPhoto* _tmp33_;
					GeeMultiMap* _tmp34_;
					LibraryPhoto* _tmp35_;
					_tmp32_ = self->priv->photo_to_editable_filesize;
					_tmp33_ = photo;
					gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp33_, NULL);
					_tmp34_ = self->priv->filesize_to_photo;
					_tmp35_ = photo;
					gee_multi_map_remove (_tmp34_, &old_editable_filesize, _tmp35_);
				}
				_tmp36_ = photo;
				_tmp37_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, TYPE_PHOTO, Photo));
				_tmp38_ = _tmp37_;
				_tmp39_ = _tmp38_->filesize;
				_backing_photo_row_unref0 (_tmp38_);
				master_filesize = _tmp39_;
				_tmp41_ = photo;
				_tmp42_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_PHOTO, Photo));
				_tmp43_ = _tmp42_;
				_tmp44_ = _tmp43_ != NULL;
				_backing_photo_row_unref0 (_tmp43_);
				if (_tmp44_) {
					LibraryPhoto* _tmp45_;
					BackingPhotoRow* _tmp46_;
					BackingPhotoRow* _tmp47_;
					_tmp45_ = photo;
					_tmp46_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, TYPE_PHOTO, Photo));
					_tmp47_ = _tmp46_;
					_tmp40_ = _tmp47_->filesize;
					_backing_photo_row_unref0 (_tmp47_);
				} else {
					_tmp40_ = (gint64) -1;
				}
				editable_filesize = _tmp40_;
				_tmp48_ = self->priv->photo_to_master_filesize;
				_tmp49_ = photo;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp49_, &master_filesize);
				_tmp50_ = self->priv->filesize_to_photo;
				_tmp51_ = photo;
				gee_multi_map_set (_tmp50_, &master_filesize, _tmp51_);
				if (editable_filesize >= ((gint64) 0)) {
					GeeHashMap* _tmp52_;
					LibraryPhoto* _tmp53_;
					GeeMultiMap* _tmp54_;
					LibraryPhoto* _tmp55_;
					_tmp52_ = self->priv->photo_to_editable_filesize;
					_tmp53_ = photo;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp53_, &editable_filesize);
					_tmp54_ = self->priv->filesize_to_photo;
					_tmp55_ = photo;
					gee_multi_map_set (_tmp54_, &editable_filesize, _tmp55_);
				}
				_g_free0 (_tmp20_);
			}
			_g_object_unref0 (photo);
			_alteration_unref0 (alteration);
			_g_object_unref0 (object);
		}
		_g_object_unref0 (_object_it);
	}
	DATA_COLLECTION_CLASS (library_photo_source_collection_parent_class)->items_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_DATA_COLLECTION, DataCollection), items);
}

static void
library_photo_source_collection_real_postprocess_imported_media (MediaSourceCollection* base,
                                                                 GeeCollection* media_sources)
{
	LibraryPhotoSourceCollection * self;
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (media_sources, GEE_TYPE_COLLECTION));
	_tmp0_ = gee_hash_multi_map_new (TYPE_TAG, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_ITERABLE, GeeIterable));
		_media_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			MediaSource* media = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp5_;
			LibraryPhoto* _tmp6_;
			PhotoMetadata* metadata = NULL;
			LibraryPhoto* _tmp7_;
			PhotoMetadata* _tmp8_;
			HierarchicalTagIndex* global_index = NULL;
			HierarchicalTagIndex* _tmp9_;
			HierarchicalTagIndex* htag_index = NULL;
			gboolean _tmp10_ = FALSE;
			PhotoMetadata* _tmp11_;
			LibraryPhoto* _tmp17_;
			GeeCollection* _tmp18_;
			GeeCollection* _tmp19_;
			gboolean _tmp20_;
			gboolean _tmp51_ = FALSE;
			PhotoMetadata* _tmp52_;
			_tmp2_ = _media_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _media_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			media = (MediaSource*) _tmp4_;
			_tmp5_ = media;
			_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp6_;
			_tmp7_ = photo;
			_tmp8_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO_SOURCE, PhotoSource));
			metadata = _tmp8_;
			_tmp9_ = hierarchical_tag_index_get_global_index ();
			global_index = _tmp9_;
			htag_index = NULL;
			_tmp11_ = metadata;
			if (_tmp11_ != NULL) {
				PhotoMetadata* _tmp12_;
				_tmp12_ = metadata;
				_tmp10_ = photo_metadata_has_hierarchical_keywords (_tmp12_);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				PhotoMetadata* _tmp13_;
				GeeSet* _tmp14_;
				GeeSet* _tmp15_;
				HierarchicalTagIndex* _tmp16_;
				_tmp13_ = metadata;
				_tmp14_ = photo_metadata_get_hierarchical_keywords (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = hierarchical_tag_utilities_process_hierarchical_import_keywords (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection));
				_hierarchical_tag_index_unref0 (htag_index);
				htag_index = _tmp16_;
				_g_object_unref0 (_tmp15_);
			}
			_tmp17_ = photo;
			_tmp18_ = library_photo_get_import_keywords (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _tmp19_ != NULL;
			_g_object_unref0 (_tmp19_);
			if (_tmp20_) {
				{
					GeeIterator* _keyword_it = NULL;
					LibraryPhoto* _tmp21_;
					GeeCollection* _tmp22_;
					GeeCollection* _tmp23_;
					GeeIterator* _tmp24_;
					GeeIterator* _tmp25_;
					_tmp21_ = photo;
					_tmp22_ = library_photo_get_import_keywords (_tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ITERABLE, GeeIterable));
					_tmp25_ = _tmp24_;
					_g_object_unref0 (_tmp23_);
					_keyword_it = _tmp25_;
					while (TRUE) {
						GeeIterator* _tmp26_;
						gchar* keyword = NULL;
						GeeIterator* _tmp27_;
						gpointer _tmp28_;
						gboolean _tmp29_ = FALSE;
						HierarchicalTagIndex* _tmp30_;
						gchar* name = NULL;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						HierarchicalTagIndex* _tmp35_;
						const gchar* _tmp36_;
						const gchar* _tmp45_;
						_tmp26_ = _keyword_it;
						if (!gee_iterator_next (_tmp26_)) {
							break;
						}
						_tmp27_ = _keyword_it;
						_tmp28_ = gee_iterator_get (_tmp27_);
						keyword = (gchar*) _tmp28_;
						_tmp30_ = htag_index;
						if (_tmp30_ != NULL) {
							HierarchicalTagIndex* _tmp31_;
							const gchar* _tmp32_;
							_tmp31_ = htag_index;
							_tmp32_ = keyword;
							_tmp29_ = hierarchical_tag_index_is_tag_in_index (_tmp31_, _tmp32_);
						} else {
							_tmp29_ = FALSE;
						}
						if (_tmp29_) {
							_g_free0 (keyword);
							continue;
						}
						_tmp33_ = keyword;
						_tmp34_ = tag_prep_tag_name (_tmp33_);
						name = _tmp34_;
						_tmp35_ = global_index;
						_tmp36_ = name;
						if (hierarchical_tag_index_is_tag_in_index (_tmp35_, _tmp36_)) {
							gchar* most_derived_path = NULL;
							HierarchicalTagIndex* _tmp37_;
							const gchar* _tmp38_;
							gchar* _tmp39_;
							GeeHashMultiMap* _tmp40_;
							const gchar* _tmp41_;
							Tag* _tmp42_;
							Tag* _tmp43_;
							LibraryPhoto* _tmp44_;
							_tmp37_ = global_index;
							_tmp38_ = name;
							_tmp39_ = hierarchical_tag_index_get_path_for_name (_tmp37_, _tmp38_);
							most_derived_path = _tmp39_;
							_tmp40_ = map;
							_tmp41_ = most_derived_path;
							_tmp42_ = tag_for_path (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = photo;
							gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp43_, _tmp44_);
							_g_object_unref0 (_tmp43_);
							_g_free0 (most_derived_path);
							_g_free0 (name);
							_g_free0 (keyword);
							continue;
						}
						_tmp45_ = name;
						if (_tmp45_ != NULL) {
							GeeHashMultiMap* _tmp46_;
							const gchar* _tmp47_;
							Tag* _tmp48_;
							Tag* _tmp49_;
							LibraryPhoto* _tmp50_;
							_tmp46_ = map;
							_tmp47_ = name;
							_tmp48_ = tag_for_path (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = photo;
							gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp49_, _tmp50_);
							_g_object_unref0 (_tmp49_);
						}
						_g_free0 (name);
						_g_free0 (keyword);
					}
					_g_object_unref0 (_keyword_it);
				}
			}
			_tmp52_ = metadata;
			if (_tmp52_ != NULL) {
				PhotoMetadata* _tmp53_;
				_tmp53_ = metadata;
				_tmp51_ = photo_metadata_has_hierarchical_keywords (_tmp53_);
			} else {
				_tmp51_ = FALSE;
			}
			if (_tmp51_) {
				{
					GeeIterator* _path_it = NULL;
					HierarchicalTagIndex* _tmp54_;
					GeeCollection* _tmp55_;
					GeeCollection* _tmp56_;
					GeeIterator* _tmp57_;
					GeeIterator* _tmp58_;
					_tmp54_ = htag_index;
					_tmp55_ = hierarchical_tag_index_get_all_paths (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ITERABLE, GeeIterable));
					_tmp58_ = _tmp57_;
					_g_object_unref0 (_tmp56_);
					_path_it = _tmp58_;
					while (TRUE) {
						GeeIterator* _tmp59_;
						gchar* path = NULL;
						GeeIterator* _tmp60_;
						gpointer _tmp61_;
						gchar* name = NULL;
						const gchar* _tmp62_;
						gchar* _tmp63_;
						const gchar* _tmp64_;
						_tmp59_ = _path_it;
						if (!gee_iterator_next (_tmp59_)) {
							break;
						}
						_tmp60_ = _path_it;
						_tmp61_ = gee_iterator_get (_tmp60_);
						path = (gchar*) _tmp61_;
						_tmp62_ = path;
						_tmp63_ = tag_prep_tag_name (_tmp62_);
						name = _tmp63_;
						_tmp64_ = name;
						if (_tmp64_ != NULL) {
							GeeHashMultiMap* _tmp65_;
							const gchar* _tmp66_;
							Tag* _tmp67_;
							Tag* _tmp68_;
							LibraryPhoto* _tmp69_;
							_tmp65_ = map;
							_tmp66_ = name;
							_tmp67_ = tag_for_path (_tmp66_);
							_tmp68_ = _tmp67_;
							_tmp69_ = photo;
							gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp68_, _tmp69_);
							_g_object_unref0 (_tmp68_);
						}
						_g_free0 (name);
						_g_free0 (path);
					}
					_g_object_unref0 (_path_it);
				}
			}
			_hierarchical_tag_index_unref0 (htag_index);
			_hierarchical_tag_index_unref0 (global_index);
			_media_metadata_unref0 (metadata);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	{
		GeeIterator* _media_it = NULL;
		GeeIterator* _tmp70_;
		_tmp70_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (media_sources, GEE_TYPE_ITERABLE, GeeIterable));
		_media_it = _tmp70_;
		while (TRUE) {
			GeeIterator* _tmp71_;
			MediaSource* media = NULL;
			GeeIterator* _tmp72_;
			gpointer _tmp73_;
			LibraryPhoto* photo = NULL;
			MediaSource* _tmp74_;
			LibraryPhoto* _tmp75_;
			LibraryPhoto* _tmp76_;
			_tmp71_ = _media_it;
			if (!gee_iterator_next (_tmp71_)) {
				break;
			}
			_tmp72_ = _media_it;
			_tmp73_ = gee_iterator_get (_tmp72_);
			media = (MediaSource*) _tmp73_;
			_tmp74_ = media;
			_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			photo = _tmp75_;
			_tmp76_ = photo;
			library_photo_clear_import_keywords (_tmp76_);
			_g_object_unref0 (photo);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	{
		GeeIterator* _tag_it = NULL;
		GeeHashMultiMap* _tmp77_;
		GeeSet* _tmp78_;
		GeeSet* _tmp79_;
		GeeIterator* _tmp80_;
		GeeIterator* _tmp81_;
		_tmp77_ = map;
		_tmp78_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
		_tmp79_ = _tmp78_;
		_tmp80_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp81_ = _tmp80_;
		_g_object_unref0 (_tmp79_);
		_tag_it = _tmp81_;
		while (TRUE) {
			GeeIterator* _tmp82_;
			Tag* tag = NULL;
			GeeIterator* _tmp83_;
			gpointer _tmp84_;
			Tag* _tmp85_;
			GeeHashMultiMap* _tmp86_;
			Tag* _tmp87_;
			GeeCollection* _tmp88_;
			GeeCollection* _tmp89_;
			_tmp82_ = _tag_it;
			if (!gee_iterator_next (_tmp82_)) {
				break;
			}
			_tmp83_ = _tag_it;
			_tmp84_ = gee_iterator_get (_tmp83_);
			tag = (Tag*) _tmp84_;
			_tmp85_ = tag;
			_tmp86_ = map;
			_tmp87_ = tag;
			_tmp88_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp87_);
			_tmp89_ = _tmp88_;
			tag_attach_many (_tmp85_, _tmp89_);
			_g_object_unref0 (_tmp89_);
			_g_object_unref0 (tag);
		}
		_g_object_unref0 (_tag_it);
	}
	MEDIA_SOURCE_COLLECTION_CLASS (library_photo_source_collection_parent_class)->postprocess_imported_media (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), media_sources);
	_g_object_unref0 (map);
}

static void
library_photo_source_collection_real_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_master_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_master_reimported) {
		_klass_->notify_master_reimported (self, photo, metadata);
	}
}

static void
library_photo_source_collection_real_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_editable_reimported (LibraryPhotoSourceCollection* self,
                                                            LibraryPhoto* photo,
                                                            PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_editable_reimported) {
		_klass_->notify_editable_reimported (self, photo, metadata);
	}
}

static void
library_photo_source_collection_real_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                               LibraryPhoto* photo,
                                                               PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_source_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_source_reimported) {
		_klass_->notify_source_reimported (self, photo, metadata);
	}
}

static void
library_photo_source_collection_real_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                                 LibraryPhoto* photo,
                                                                 PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	g_signal_emit (self, library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL], 0, photo, metadata);
}

void
library_photo_source_collection_notify_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                            LibraryPhoto* photo,
                                                            PhotoMetadata* metadata)
{
	LibraryPhotoSourceCollectionClass* _klass_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	_klass_ = LIBRARY_PHOTO_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_baseline_reimported) {
		_klass_->notify_baseline_reimported (self, photo, metadata);
	}
}

static MediaSource*
library_photo_source_collection_real_fetch_by_numeric_id (MediaSourceCollection* base,
                                                          gint64 numeric_id)
{
	LibraryPhotoSourceCollection * self;
	PhotoID _tmp0_ = {0};
	LibraryPhoto* _tmp1_;
	MediaSource* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	photo_id_init (&_tmp0_, numeric_id);
	_tmp1_ = library_photo_source_collection_fetch (self, &_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_MEDIA_SOURCE, MediaSource);
	return result;
}

static void
library_photo_source_collection_on_trashcan_contents_altered (LibraryPhotoSourceCollection* self,
                                                              GeeCollection* added,
                                                              GeeCollection* removed)
{
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "trashcan-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static gboolean
library_photo_source_collection_check_if_trashed_photo (LibraryPhotoSourceCollection* self,
                                                        DataSource* source,
                                                        Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

static void
library_photo_source_collection_on_offline_contents_altered (LibraryPhotoSourceCollection* self,
                                                             GeeCollection* added,
                                                             GeeCollection* removed)
{
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_signal_emit_by_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), "offline-contents-altered", G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_COLLECTION, GeeCollection), G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_COLLECTION, GeeCollection));
}

static gboolean
library_photo_source_collection_check_if_offline_photo (LibraryPhotoSourceCollection* self,
                                                        DataSource* source,
                                                        Alteration* alteration)
{
	gboolean result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_DATA_SOURCE (source), FALSE);
	g_return_val_if_fail (IS_ALTERATION (alteration), FALSE);
	result = media_source_is_offline (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_LIBRARY_PHOTO, LibraryPhoto), TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

static MediaSource*
library_photo_source_collection_real_fetch_by_source_id (MediaSourceCollection* base,
                                                         const gchar* source_id)
{
	LibraryPhotoSourceCollection * self;
	gchar* numeric_only = NULL;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	MediaSource* _tmp3_;
	MediaSource* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_val_if_fail (source_id != NULL, NULL);
	_vala_assert (g_str_has_prefix (source_id, PHOTO_TYPENAME), "source_id.has_prefix(Photo.TYPENAME)");
	_tmp0_ = strlen (PHOTO_TYPENAME);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_substring (source_id, (glong) _tmp1_, (glong) -1);
	numeric_only = _tmp2_;
	_tmp3_ = media_source_collection_fetch_by_numeric_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), int64_parse (numeric_only, (guint) 16));
	result = _tmp3_;
	_g_free0 (numeric_only);
	return result;
}

static GeeCollection*
library_photo_source_collection_real_get_event_source_ids (MediaSourceCollection* base,
                                                           EventID* event_id)
{
	LibraryPhotoSourceCollection * self;
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	EventID _tmp2_;
	GeeArrayList* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_val_if_fail (event_id != NULL, NULL);
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = *event_id;
	_tmp3_ = photo_table_get_event_source_ids (_tmp1_, &_tmp2_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
	_database_table_unref0 (_tmp1_);
	result = _tmp4_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_fetch (LibraryPhotoSourceCollection* self,
                                       PhotoID* photo_id)
{
	PhotoID _tmp0_;
	DataSource* _tmp1_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = *photo_id;
	_tmp1_ = database_source_collection_fetch_by_key (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), _tmp0_.id);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	return result;
}

LibraryPhoto*
library_photo_source_collection_fetch_by_editable_file (LibraryPhotoSourceCollection* self,
                                                        GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->by_editable_file;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (LibraryPhoto*) _tmp1_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_fetch_by_raw_development_file (LibraryPhotoSourceCollection* self,
                                                               GFile* file)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = self->priv->by_raw_development_file;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (LibraryPhoto*) _tmp1_;
	return result;
}

static void
library_photo_source_collection_compare_backing (LibraryPhotoSourceCollection* self,
                                                 LibraryPhoto* photo,
                                                 GFileInfo* info,
                                                 GeeCollection* matches_master,
                                                 GeeCollection* matches_editable,
                                                 GeeCollection* matches_development)
{
	BackingPhotoRow* _tmp0_;
	BackingPhotoRow* _tmp1_;
	gboolean _tmp2_;
	BackingPhotoRow* editable = NULL;
	BackingPhotoRow* _tmp3_;
	gboolean _tmp4_ = FALSE;
	BackingPhotoRow* _tmp5_;
	GeeCollection* development = NULL;
	GeeCollection* _tmp7_;
	GeeCollection* _tmp8_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matches_master, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matches_editable, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matches_development, GEE_TYPE_COLLECTION));
	_tmp0_ = photo_get_master_photo_row (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	_tmp1_ = _tmp0_;
	_tmp2_ = backing_photo_row_matches_file_info (_tmp1_, info);
	_backing_photo_row_unref0 (_tmp1_);
	if (_tmp2_) {
		gee_collection_add (matches_master, photo);
	}
	_tmp3_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	editable = _tmp3_;
	_tmp5_ = editable;
	if (_tmp5_ != NULL) {
		BackingPhotoRow* _tmp6_;
		_tmp6_ = editable;
		_tmp4_ = backing_photo_row_matches_file_info (_tmp6_, info);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gee_collection_add (matches_editable, photo);
	}
	_tmp7_ = photo_get_raw_development_photo_rows (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo));
	development = _tmp7_;
	_tmp8_ = development;
	if (_tmp8_ != NULL) {
		{
			GeeIterator* _row_it = NULL;
			GeeCollection* _tmp9_;
			GeeIterator* _tmp10_;
			_tmp9_ = development;
			_tmp10_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_ITERABLE, GeeIterable));
			_row_it = _tmp10_;
			while (TRUE) {
				GeeIterator* _tmp11_;
				BackingPhotoRow* row = NULL;
				GeeIterator* _tmp12_;
				gpointer _tmp13_;
				BackingPhotoRow* _tmp14_;
				_tmp11_ = _row_it;
				if (!gee_iterator_next (_tmp11_)) {
					break;
				}
				_tmp12_ = _row_it;
				_tmp13_ = gee_iterator_get (_tmp12_);
				row = (BackingPhotoRow*) _tmp13_;
				_tmp14_ = row;
				if (backing_photo_row_matches_file_info (_tmp14_, info)) {
					gee_collection_add (matches_development, photo);
					_backing_photo_row_unref0 (row);
					break;
				}
				_backing_photo_row_unref0 (row);
			}
			_g_object_unref0 (_row_it);
		}
	}
	_g_object_unref0 (development);
	_backing_photo_row_unref0 (editable);
}

void
library_photo_source_collection_fetch_by_matching_backing (LibraryPhotoSourceCollection* self,
                                                           GFileInfo* info,
                                                           GeeCollection* matches_master,
                                                           GeeCollection* matches_editable,
                                                           GeeCollection* matched_development)
{
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matches_master, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matches_editable, GEE_TYPE_COLLECTION));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (matched_development, GEE_TYPE_COLLECTION));
	{
		GeeIterator* _photo_it = NULL;
		GeeMultiMap* _tmp0_;
		gint64 _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp0_ = self->priv->filesize_to_photo;
		_tmp1_ = g_file_info_get_size (info);
		_tmp2_ = gee_multi_map_get (_tmp0_, &_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_photo_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			LibraryPhoto* _tmp9_;
			_tmp6_ = _photo_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _photo_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			photo = (LibraryPhoto*) _tmp8_;
			_tmp9_ = photo;
			library_photo_source_collection_compare_backing (self, _tmp9_, info, matches_master, matches_editable, matched_development);
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	{
		GeeIterator* _media_it = NULL;
		GeeCollection* _tmp10_;
		GeeCollection* _tmp11_;
		GeeIterator* _tmp12_;
		GeeIterator* _tmp13_;
		_tmp10_ = media_source_collection_get_offline_bin_contents (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
		_tmp11_ = _tmp10_;
		_tmp12_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		_media_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			MediaSource* media = NULL;
			GeeIterator* _tmp15_;
			gpointer _tmp16_;
			MediaSource* _tmp17_;
			_tmp14_ = _media_it;
			if (!gee_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _media_it;
			_tmp16_ = gee_iterator_get (_tmp15_);
			media = (MediaSource*) _tmp16_;
			_tmp17_ = media;
			library_photo_source_collection_compare_backing (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_LIBRARY_PHOTO, LibraryPhoto), info, matches_master, matches_editable, matched_development);
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
}

void
library_photo_source_collection_get_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                 const gchar* basename,
                                                                 gint64 filesize,
                                                                 PhotoID* result)
{
	PhotoID _tmp16_ = {0};
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self));
	g_return_if_fail (basename != NULL);
	{
		GeeIterator* _photo_it = NULL;
		GeeMultiMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_;
		GeeIterator* _tmp4_;
		_tmp0_ = self->priv->filesize_to_photo;
		_tmp1_ = gee_multi_map_get (_tmp0_, &filesize);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_photo_it = _tmp4_;
		while (TRUE) {
			GeeIterator* _tmp5_;
			LibraryPhoto* photo = NULL;
			GeeIterator* _tmp6_;
			gpointer _tmp7_;
			LibraryPhoto* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gboolean _tmp13_;
			_tmp5_ = _photo_it;
			if (!gee_iterator_next (_tmp5_)) {
				break;
			}
			_tmp6_ = _photo_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			photo = (LibraryPhoto*) _tmp7_;
			_tmp8_ = photo;
			_tmp9_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_MEDIA_SOURCE, MediaSource));
			_tmp10_ = _tmp9_;
			_tmp11_ = g_file_get_basename (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = utf8_ci_compare (_tmp12_, basename) == 0;
			_g_free0 (_tmp12_);
			_g_object_unref0 (_tmp10_);
			if (_tmp13_) {
				LibraryPhoto* _tmp14_;
				PhotoID _tmp15_ = {0};
				_tmp14_ = photo;
				photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, TYPE_PHOTO, Photo), &_tmp15_);
				*result = _tmp15_;
				_g_object_unref0 (photo);
				_g_object_unref0 (_photo_it);
				return;
			}
			_g_object_unref0 (photo);
		}
		_g_object_unref0 (_photo_it);
	}
	photo_id_init (&_tmp16_, PHOTO_ID_INVALID);
	*result = _tmp16_;
	return;
}

gboolean
library_photo_source_collection_has_basename_filesize_duplicate (LibraryPhotoSourceCollection* self,
                                                                 const gchar* basename,
                                                                 gint64 filesize)
{
	PhotoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (basename != NULL, FALSE);
	library_photo_source_collection_get_basename_filesize_duplicate (self, basename, filesize, &_tmp0_);
	result = photo_id_is_valid (&_tmp0_);
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_trashed_by_file (LibraryPhotoSourceCollection* self,
                                                     GFile* file)
{
	LibraryPhoto* photo = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* _tmp4_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_master_file (_tmp1_, file);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	photo = _tmp3_;
	_tmp4_ = photo;
	if (_tmp4_ == NULL) {
		MediaSourceHoldingTank* _tmp5_;
		LibraryPhotoSourceHoldingTank* _tmp6_;
		LibraryPhoto* _tmp7_;
		_tmp5_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
		_tmp7_ = library_photo_source_holding_tank_fetch_by_backing_file (_tmp6_, file);
		_g_object_unref0 (photo);
		photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
		_source_holding_tank_unref0 (_tmp6_);
	}
	result = photo;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_trashed_by_md5 (LibraryPhotoSourceCollection* self,
                                                    const gchar* md5)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (md5 != NULL, NULL);
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_md5 (_tmp1_, md5);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_offline_by_file (LibraryPhotoSourceCollection* self,
                                                     GFile* file)
{
	LibraryPhoto* photo = NULL;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* _tmp4_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_master_file (_tmp1_, file);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	photo = _tmp3_;
	_tmp4_ = photo;
	if (_tmp4_ == NULL) {
		MediaSourceHoldingTank* _tmp5_;
		LibraryPhotoSourceHoldingTank* _tmp6_;
		LibraryPhoto* _tmp7_;
		_tmp5_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
		_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
		_tmp7_ = library_photo_source_holding_tank_fetch_by_backing_file (_tmp6_, file);
		_g_object_unref0 (photo);
		photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
		_source_holding_tank_unref0 (_tmp6_);
	}
	result = photo;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_offline_by_md5 (LibraryPhotoSourceCollection* self,
                                                    const gchar* md5)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSource* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (md5 != NULL, NULL);
	_tmp0_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = media_source_holding_tank_fetch_by_md5 (_tmp1_, md5);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}

gint
library_photo_source_collection_get_offline_count (LibraryPhotoSourceCollection* self)
{
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), 0);
	_tmp0_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_get_count (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank));
	_source_holding_tank_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

LibraryPhoto*
library_photo_source_collection_get_state_by_file (LibraryPhotoSourceCollection* self,
                                                   GFile* file,
                                                   LibraryPhotoSourceCollectionState* state)
{
	LibraryPhotoSourceCollectionState _vala_state = 0;
	LibraryPhoto* photo = NULL;
	MediaSource* _tmp0_;
	LibraryPhoto* _tmp1_;
	LibraryPhoto* _tmp2_;
	LibraryPhoto* _tmp3_;
	LibraryPhoto* _tmp4_;
	LibraryPhoto* _tmp5_;
	LibraryPhoto* _tmp6_;
	LibraryPhoto* _tmp7_;
	LibraryPhoto* _tmp8_;
	LibraryPhoto* _tmp9_;
	LibraryPhoto* _tmp10_;
	LibraryPhoto* _tmp11_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	_tmp0_ = media_source_collection_fetch_by_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), file);
	photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp1_ = photo;
	if (_tmp1_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp2_ = library_photo_source_collection_fetch_by_editable_file (self, file);
	_g_object_unref0 (photo);
	photo = _tmp2_;
	_tmp3_ = photo;
	if (_tmp3_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp4_ = library_photo_source_collection_fetch_by_raw_development_file (self, file);
	_g_object_unref0 (photo);
	photo = _tmp4_;
	_tmp5_ = photo;
	if (_tmp5_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp6_ = library_photo_source_collection_get_trashed_by_file (self, file);
	_tmp7_ = IS_LIBRARY_PHOTO (_tmp6_) ? ((LibraryPhoto*) _tmp6_) : NULL;
	if (_tmp7_ == NULL) {
		_g_object_unref0 (_tmp6_);
	}
	_g_object_unref0 (photo);
	photo = _tmp7_;
	_tmp8_ = photo;
	if (_tmp8_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_tmp9_ = library_photo_source_collection_get_offline_by_file (self, file);
	_tmp10_ = IS_LIBRARY_PHOTO (_tmp9_) ? ((LibraryPhoto*) _tmp9_) : NULL;
	if (_tmp10_ == NULL) {
		_g_object_unref0 (_tmp9_);
	}
	_g_object_unref0 (photo);
	photo = _tmp10_;
	_tmp11_ = photo;
	if (_tmp11_ != NULL) {
		_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE;
		result = photo;
		if (state) {
			*state = _vala_state;
		}
		return result;
	}
	_vala_state = LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_UNKNOWN;
	result = NULL;
	_g_object_unref0 (photo);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

static gboolean
library_photo_source_collection_real_has_backlink (SourceCollection* base,
                                                   SourceBacklink* backlink)
{
	LibraryPhotoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	gboolean _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	MediaSourceHoldingTank* _tmp4_;
	gboolean _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_val_if_fail (IS_SOURCE_BACKLINK (backlink), FALSE);
	if (SOURCE_COLLECTION_CLASS (library_photo_source_collection_parent_class)->has_backlink (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_SOURCE_COLLECTION, SourceCollection), backlink)) {
		result = TRUE;
		return result;
	}
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	_tmp2_ = source_holding_tank_has_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), backlink);
	_source_holding_tank_unref0 (_tmp1_);
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp3_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp4_ = _tmp3_;
	_tmp5_ = source_holding_tank_has_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), backlink);
	_source_holding_tank_unref0 (_tmp4_);
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static void
library_photo_source_collection_real_remove_backlink (SourceCollection* base,
                                                      SourceBacklink* backlink)
{
	LibraryPhotoSourceCollection * self;
	MediaSourceHoldingTank* _tmp0_;
	MediaSourceHoldingTank* _tmp1_;
	MediaSourceHoldingTank* _tmp2_;
	MediaSourceHoldingTank* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	_tmp0_ = media_source_collection_get_trashcan (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp1_ = _tmp0_;
	source_holding_tank_remove_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), backlink);
	_source_holding_tank_unref0 (_tmp1_);
	_tmp2_ = media_source_collection_get_offline_bin (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	_tmp3_ = _tmp2_;
	source_holding_tank_remove_backlink (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), backlink);
	_source_holding_tank_unref0 (_tmp3_);
	SOURCE_COLLECTION_CLASS (library_photo_source_collection_parent_class)->remove_backlink (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), TYPE_SOURCE_COLLECTION, SourceCollection), backlink);
}

static TransactionController*
library_photo_source_collection_real_get_transaction_controller (MediaSourceCollection* base)
{
	TransactionController* result;
	LibraryPhotoSourceCollection* self;
	TransactionController* _tmp0_;
	TransactionController* _tmp2_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	_tmp0_ = self->priv->_transaction_controller;
	if (_tmp0_ == NULL) {
		MediaSourceTransactionController* _tmp1_;
		_tmp1_ = media_source_transaction_controller_new (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
		_transaction_controller_unref0 (self->priv->_transaction_controller);
		self->priv->_transaction_controller = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TRANSACTION_CONTROLLER, TransactionController);
	}
	_tmp2_ = self->priv->_transaction_controller;
	result = _tmp2_;
	return result;
}

static void
library_photo_source_collection_real_master_reimported (LibraryPhotoSourceCollection* self,
                                                        LibraryPhoto* photo,
                                                        PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_MEDIA_METADATA) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_MEDIA_METADATA callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_MEDIA_METADATA) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), value_get_media_metadata (param_values + 2), data2);
}

static void
library_photo_source_collection_real_editable_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
library_photo_source_collection_real_baseline_reimported (LibraryPhotoSourceCollection* self,
                                                          LibraryPhoto* photo,
                                                          PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
library_photo_source_collection_real_source_reimported (LibraryPhotoSourceCollection* self,
                                                        LibraryPhoto* photo,
                                                        PhotoMetadata* metadata)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
}

static void
library_photo_source_collection_class_init (LibraryPhotoSourceCollectionClass * klass,
                                            gpointer klass_data)
{
	library_photo_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = library_photo_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &LibraryPhotoSourceCollection_private_offset);
	((MediaSourceCollectionClass *) klass)->create_trashcan = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) library_photo_source_collection_real_create_trashcan;
	((MediaSourceCollectionClass *) klass)->create_offline_bin = (MediaSourceHoldingTank* (*) (MediaSourceCollection*)) library_photo_source_collection_real_create_offline_bin;
	((MediaSourceCollectionClass *) klass)->create_media_monitor = (MediaMonitor* (*) (MediaSourceCollection*, Workers*, GCancellable*)) library_photo_source_collection_real_create_media_monitor;
	((SourceCollectionClass *) klass)->holds_type_of_source = (gboolean (*) (SourceCollection*, DataSource*)) library_photo_source_collection_real_holds_type_of_source;
	((MediaSourceCollectionClass *) klass)->get_typename = (gchar* (*) (MediaSourceCollection*)) library_photo_source_collection_real_get_typename;
	((MediaSourceCollectionClass *) klass)->is_file_recognized = (gboolean (*) (MediaSourceCollection*, GFile*)) library_photo_source_collection_real_is_file_recognized;
	((DataCollectionClass *) klass)->notify_contents_altered = (void (*) (DataCollection*, GeeIterable*, GeeIterable*)) library_photo_source_collection_real_notify_contents_altered;
	((DataCollectionClass *) klass)->items_altered = (void (*) (DataCollection*, GeeMap*)) library_photo_source_collection_real_items_altered;
	((MediaSourceCollectionClass *) klass)->postprocess_imported_media = (void (*) (MediaSourceCollection*, GeeCollection*)) library_photo_source_collection_real_postprocess_imported_media;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_master_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_master_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_editable_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_editable_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_source_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_source_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->notify_baseline_reimported = (void (*) (LibraryPhotoSourceCollection*, LibraryPhoto*, PhotoMetadata*)) library_photo_source_collection_real_notify_baseline_reimported;
	((MediaSourceCollectionClass *) klass)->fetch_by_numeric_id = (MediaSource* (*) (MediaSourceCollection*, gint64)) library_photo_source_collection_real_fetch_by_numeric_id;
	((MediaSourceCollectionClass *) klass)->fetch_by_source_id = (MediaSource* (*) (MediaSourceCollection*, const gchar*)) library_photo_source_collection_real_fetch_by_source_id;
	((MediaSourceCollectionClass *) klass)->get_event_source_ids = (GeeCollection* (*) (MediaSourceCollection*, EventID*)) library_photo_source_collection_real_get_event_source_ids;
	((SourceCollectionClass *) klass)->has_backlink = (gboolean (*) (SourceCollection*, SourceBacklink*)) library_photo_source_collection_real_has_backlink;
	((SourceCollectionClass *) klass)->remove_backlink = (void (*) (SourceCollection*, SourceBacklink*)) library_photo_source_collection_real_remove_backlink;
	((LibraryPhotoSourceCollectionClass *) klass)->master_reimported = library_photo_source_collection_real_master_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->editable_reimported = library_photo_source_collection_real_editable_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->baseline_reimported = library_photo_source_collection_real_baseline_reimported;
	((LibraryPhotoSourceCollectionClass *) klass)->source_reimported = library_photo_source_collection_real_source_reimported;
	MEDIA_SOURCE_COLLECTION_CLASS (klass)->get_transaction_controller = (TransactionController* (*) (MediaSourceCollection*)) library_photo_source_collection_real_get_transaction_controller;
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_MASTER_REIMPORTED_SIGNAL] = g_signal_new ("master-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, master_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_EDITABLE_REIMPORTED_SIGNAL] = g_signal_new ("editable-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, editable_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_BASELINE_REIMPORTED_SIGNAL] = g_signal_new ("baseline-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, baseline_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
	library_photo_source_collection_signals[LIBRARY_PHOTO_SOURCE_COLLECTION_SOURCE_REIMPORTED_SIGNAL] = g_signal_new ("source-reimported", TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (LibraryPhotoSourceCollectionClass, source_reimported), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_MEDIA_METADATA, G_TYPE_NONE, 2, TYPE_LIBRARY_PHOTO, TYPE_PHOTO_METADATA);
}

static void
library_photo_source_collection_instance_init (LibraryPhotoSourceCollection * self,
                                               gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeTreeMultiMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeTreeMultiMap* _tmp5_;
	self->priv = library_photo_source_collection_get_instance_private (self);
	self->priv->_transaction_controller = NULL;
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->by_editable_file = _tmp0_;
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->by_raw_development_file = _tmp1_;
	_tmp2_ = gee_tree_multi_map_new (G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _int64_compare_gcompare_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->filesize_to_photo = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	_tmp3_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, _int64_equal_gee_equal_data_func, NULL, NULL);
	self->priv->photo_to_master_filesize = _tmp3_;
	_tmp4_ = gee_hash_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, _int64_equal_gee_equal_data_func, NULL, NULL);
	self->priv->photo_to_editable_filesize = _tmp4_;
	_tmp5_ = gee_tree_multi_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_INT64, (GBoxedCopyFunc) _int64_dup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->photo_to_raw_development_filesize = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
}

static void
library_photo_source_collection_finalize (DataCollection * obj)
{
	LibraryPhotoSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_PHOTO_SOURCE_COLLECTION, LibraryPhotoSourceCollection);
	_transaction_controller_unref0 (self->priv->_transaction_controller);
	_g_object_unref0 (self->priv->by_editable_file);
	_g_object_unref0 (self->priv->by_raw_development_file);
	_g_object_unref0 (self->priv->filesize_to_photo);
	_g_object_unref0 (self->priv->photo_to_master_filesize);
	_g_object_unref0 (self->priv->photo_to_editable_filesize);
	_g_object_unref0 (self->priv->photo_to_raw_development_filesize);
	DATA_COLLECTION_CLASS (library_photo_source_collection_parent_class)->finalize (obj);
}

static GType
library_photo_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryPhotoSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_photo_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryPhotoSourceCollection), 0, (GInstanceInitFunc) library_photo_source_collection_instance_init, NULL };
	GType library_photo_source_collection_type_id;
	library_photo_source_collection_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_COLLECTION, "LibraryPhotoSourceCollection", &g_define_type_info, 0);
	LibraryPhotoSourceCollection_private_offset = g_type_add_instance_private (library_photo_source_collection_type_id, sizeof (LibraryPhotoSourceCollectionPrivate));
	return library_photo_source_collection_type_id;
}

GType
library_photo_source_collection_get_type (void)
{
	static volatile gsize library_photo_source_collection_type_id__once = 0;
	if (g_once_init_enter (&library_photo_source_collection_type_id__once)) {
		GType library_photo_source_collection_type_id;
		library_photo_source_collection_type_id = library_photo_source_collection_get_type_once ();
		g_once_init_leave (&library_photo_source_collection_type_id__once, library_photo_source_collection_type_id);
	}
	return library_photo_source_collection_type_id__once;
}

static inline gpointer
library_photo_get_instance_private (LibraryPhoto* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryPhoto_private_offset);
}

static void
_library_photo_generate_thumbnails_one_shot_callback (gpointer self)
{
	library_photo_generate_thumbnails ((LibraryPhoto*) self);
}

static void
_library_photo_import_gps_metadata_one_shot_callback (gpointer self)
{
	library_photo_import_gps_metadata ((LibraryPhoto*) self);
}

static LibraryPhoto*
library_photo_construct (GType object_type,
                         PhotoRow* row)
{
	LibraryPhoto * self = NULL;
	OneShotScheduler* _tmp0_;
	GpsCoords _tmp1_;
	g_return_val_if_fail (IS_PHOTO_ROW (row), NULL);
	self = (LibraryPhoto*) photo_construct (object_type, row);
	_g_object_unref0 (self->priv->import_keywords);
	self->priv->import_keywords = NULL;
	_tmp0_ = one_shot_scheduler_new ("LibraryPhoto", _library_photo_generate_thumbnails_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->thumbnail_scheduler);
	self->priv->thumbnail_scheduler = _tmp0_;
	_tmp1_ = row->gps_coords;
	if (_tmp1_.has_gps == -1) {
		OneShotScheduler* gps_import_scheduler = NULL;
		OneShotScheduler* _tmp2_;
		OneShotScheduler* _tmp3_;
		_tmp2_ = one_shot_scheduler_new ("LibraryPhoto", _library_photo_import_gps_metadata_one_shot_callback, self);
		gps_import_scheduler = _tmp2_;
		_tmp3_ = gps_import_scheduler;
		one_shot_scheduler_at_priority_idle (_tmp3_, G_PRIORITY_LOW);
		_one_shot_scheduler_unref0 (gps_import_scheduler);
	}
	if ((row->flags & (LIBRARY_PHOTO_FLAG_TRASH | LIBRARY_PHOTO_FLAG_OFFLINE)) != ((guint64) 0)) {
		LibraryPhotoSourceCollection* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = library_photo_global;
		_tmp5_ = row->backlinks;
		data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp5_);
	}
	if ((row->flags & (LIBRARY_PHOTO_FLAG_HIDDEN | LIBRARY_PHOTO_FLAG_FAVORITE)) != ((guint64) 0)) {
		library_photo_upgrade_rating_flags (self, row->flags);
	}
	return self;
}

static LibraryPhoto*
library_photo_new (PhotoRow* row)
{
	return library_photo_construct (TYPE_LIBRARY_PHOTO, row);
}

static LibraryPhoto*
library_photo_construct_from_import_params (GType object_type,
                                            PhotoImportParams* import_params)
{
	LibraryPhoto * self = NULL;
	PhotoRow* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	OneShotScheduler* _tmp3_;
	PhotoRow* _tmp4_;
	PhotoRow* _tmp8_;
	g_return_val_if_fail (IS_PHOTO_IMPORT_PARAMS (import_params), NULL);
	_tmp0_ = import_params->row;
	self = (LibraryPhoto*) photo_construct (object_type, _tmp0_);
	_tmp1_ = import_params->keywords;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->import_keywords);
	self->priv->import_keywords = _tmp2_;
	_tmp3_ = one_shot_scheduler_new ("LibraryPhoto", _library_photo_generate_thumbnails_one_shot_callback, self);
	_one_shot_scheduler_unref0 (self->priv->thumbnail_scheduler);
	self->priv->thumbnail_scheduler = _tmp3_;
	_tmp4_ = import_params->row;
	if ((_tmp4_->flags & (LIBRARY_PHOTO_FLAG_TRASH | LIBRARY_PHOTO_FLAG_OFFLINE)) != ((guint64) 0)) {
		LibraryPhotoSourceCollection* _tmp5_;
		PhotoRow* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = library_photo_global;
		_tmp6_ = import_params->row;
		_tmp7_ = _tmp6_->backlinks;
		data_source_rehydrate_backlinks (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_SOURCE, DataSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp7_);
	}
	_tmp8_ = import_params->row;
	if ((_tmp8_->flags & (LIBRARY_PHOTO_FLAG_HIDDEN | LIBRARY_PHOTO_FLAG_FAVORITE)) != ((guint64) 0)) {
		PhotoRow* _tmp9_;
		_tmp9_ = import_params->row;
		library_photo_upgrade_rating_flags (self, _tmp9_->flags);
	}
	return self;
}

static LibraryPhoto*
library_photo_new_from_import_params (PhotoImportParams* import_params)
{
	return library_photo_construct_from_import_params (TYPE_LIBRARY_PHOTO, import_params);
}

void
library_photo_init (ProgressMonitor monitor,
                    gpointer monitor_target)
{
	LibraryPhotoSourceCollection* _tmp0_;
	GeeArrayList* all = NULL;
	PhotoTable* _tmp1_;
	PhotoTable* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* all_photos = NULL;
	GeeArrayList* _tmp5_;
	GeeArrayList* trashed_photos = NULL;
	GeeArrayList* _tmp6_;
	GeeArrayList* offline_photos = NULL;
	GeeArrayList* _tmp7_;
	gint count = 0;
	GeeArrayList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	LibraryPhotoSourceCollection* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeCollection* _tmp26_;
	GeeCollection* _tmp27_;
	LibraryPhotoSourceCollection* _tmp28_;
	GeeArrayList* _tmp29_;
	LibraryPhotoSourceCollection* _tmp30_;
	GeeArrayList* _tmp31_;
	photo_init_photo ();
	_tmp0_ = library_photo_source_collection_new ();
	_data_collection_unref0 (library_photo_global);
	library_photo_global = _tmp0_;
	_tmp1_ = photo_table_get_instance ();
	_tmp2_ = _tmp1_;
	_tmp3_ = photo_table_get_all (_tmp2_);
	_tmp4_ = _tmp3_;
	_database_table_unref0 (_tmp2_);
	all = _tmp4_;
	_tmp5_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all_photos = _tmp5_;
	_tmp6_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	trashed_photos = _tmp6_;
	_tmp7_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	offline_photos = _tmp7_;
	_tmp8_ = all;
	_tmp9_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	_tmp10_ = _tmp9_;
	count = _tmp10_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp11_ = FALSE;
			_tmp11_ = TRUE;
			while (TRUE) {
				PhotoRow* row = NULL;
				GeeArrayList* _tmp13_;
				gpointer _tmp14_;
				LibraryPhoto* photo = NULL;
				PhotoRow* _tmp15_;
				LibraryPhoto* _tmp16_;
				guint64 flags = 0ULL;
				PhotoRow* _tmp17_;
				if (!_tmp11_) {
					gint _tmp12_;
					_tmp12_ = ctr;
					ctr = _tmp12_ + 1;
				}
				_tmp11_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp13_ = all;
				_tmp14_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), ctr);
				row = (PhotoRow*) _tmp14_;
				_tmp15_ = row;
				_tmp16_ = library_photo_new (_tmp15_);
				photo = _tmp16_;
				_tmp17_ = row;
				flags = _tmp17_->flags;
				if ((flags & LIBRARY_PHOTO_FLAG_TRASH) != ((guint64) 0)) {
					GeeArrayList* _tmp18_;
					LibraryPhoto* _tmp19_;
					_tmp18_ = trashed_photos;
					_tmp19_ = photo;
					gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp19_);
				} else {
					if ((flags & LIBRARY_PHOTO_FLAG_OFFLINE) != ((guint64) 0)) {
						GeeArrayList* _tmp20_;
						LibraryPhoto* _tmp21_;
						_tmp20_ = offline_photos;
						_tmp21_ = photo;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp21_);
					} else {
						GeeArrayList* _tmp22_;
						LibraryPhoto* _tmp23_;
						_tmp22_ = all_photos;
						_tmp23_ = photo;
						gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp23_);
					}
				}
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
				_g_object_unref0 (photo);
				_photo_row_unref0 (row);
			}
		}
	}
	_tmp24_ = library_photo_global;
	_tmp25_ = all_photos;
	_tmp26_ = data_collection_add_many (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_COLLECTION, GeeCollection), NULL, NULL);
	_tmp27_ = _tmp26_;
	_g_object_unref0 (_tmp27_);
	_tmp28_ = library_photo_global;
	_tmp29_ = trashed_photos;
	media_source_collection_add_many_to_trash (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp30_ = library_photo_global;
	_tmp31_ = offline_photos;
	media_source_collection_add_many_to_offline (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, GEE_TYPE_COLLECTION, GeeCollection));
	_g_object_unref0 (offline_photos);
	_g_object_unref0 (trashed_photos);
	_g_object_unref0 (all_photos);
	_g_object_unref0 (all);
}

void
library_photo_terminate (void)
{
	photo_terminate_photo ();
}

ImportResult
library_photo_import_create (PhotoImportParams* params,
                             LibraryPhoto** photo)
{
	LibraryPhoto* _vala_photo = NULL;
	PhotoID photo_id = {0};
	PhotoTable* _tmp0_;
	PhotoTable* _tmp1_;
	PhotoRow* _tmp2_;
	PhotoID _tmp3_ = {0};
	PhotoID _tmp4_;
	LibraryPhoto* _tmp5_;
	ImportResult result;
	g_return_val_if_fail (IS_PHOTO_IMPORT_PARAMS (params), 0);
	_tmp0_ = photo_table_get_instance ();
	_tmp1_ = _tmp0_;
	_tmp2_ = params->row;
	photo_table_add (_tmp1_, _tmp2_, &_tmp3_);
	_tmp4_ = _tmp3_;
	_database_table_unref0 (_tmp1_);
	photo_id = _tmp4_;
	if (photo_id_is_invalid (&photo_id)) {
		_g_object_unref0 (_vala_photo);
		_vala_photo = NULL;
		result = IMPORT_RESULT_DATABASE_ERROR;
		if (photo) {
			*photo = _vala_photo;
		} else {
			_g_object_unref0 (_vala_photo);
		}
		return result;
	}
	_tmp5_ = library_photo_new_from_import_params (params);
	_g_object_unref0 (_vala_photo);
	_vala_photo = _tmp5_;
	result = IMPORT_RESULT_SUCCESS;
	if (photo) {
		*photo = _vala_photo;
	} else {
		_g_object_unref0 (_vala_photo);
	}
	return result;
}

void
library_photo_import_failed (LibraryPhoto* photo)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_LIBRARY_PHOTO (photo));
	{
		PhotoTable* _tmp0_;
		PhotoTable* _tmp1_;
		PhotoID _tmp2_ = {0};
		_tmp0_ = photo_table_get_instance ();
		_tmp1_ = _tmp0_;
		photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (photo, TYPE_PHOTO, Photo), &_tmp2_);
		photo_table_remove (_tmp1_, &_tmp2_, &_inner_error0_);
		_database_table_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = err;
		app_window_database_error (_tmp3_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
library_photo_real_notify_master_reimported (Photo* base,
                                             PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	PHOTO_CLASS (library_photo_parent_class)->notify_master_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_master_reimported (_tmp0_, self, metadata);
}

static void
library_photo_real_notify_editable_reimported (Photo* base,
                                               PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	PHOTO_CLASS (library_photo_parent_class)->notify_editable_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_editable_reimported (_tmp0_, self, metadata);
}

static void
library_photo_real_notify_source_reimported (Photo* base,
                                             PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	PHOTO_CLASS (library_photo_parent_class)->notify_source_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_source_reimported (_tmp0_, self, metadata);
}

static void
library_photo_real_notify_baseline_reimported (Photo* base,
                                               PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	LibraryPhotoSourceCollection* _tmp0_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail ((metadata == NULL) || IS_PHOTO_METADATA (metadata));
	PHOTO_CLASS (library_photo_parent_class)->notify_baseline_reimported (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), metadata);
	_tmp0_ = library_photo_global;
	library_photo_source_collection_notify_baseline_reimported (_tmp0_, self, metadata);
}

static void
library_photo_generate_thumbnails (LibraryPhoto* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_LIBRARY_PHOTO (self));
	{
		thumbnail_cache_import_from_source (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp1_ = _tmp0_;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Photo.vala:5142: Unable to generate thumbnails for %s: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	thumbnail_source_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
}

static void
library_photo_import_gps_metadata (LibraryPhoto* self)
{
	GpsCoords gps_coords = {0};
	PhotoMetadata* _tmp0_;
	PhotoMetadata* _tmp1_;
	GpsCoords _tmp2_ = {0};
	GpsCoords _tmp3_;
	GpsCoords _tmp4_;
	g_return_if_fail (IS_LIBRARY_PHOTO (self));
	_tmp0_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
	_tmp1_ = _tmp0_;
	photo_metadata_get_gps_coords (_tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	_media_metadata_unref0 (_tmp1_);
	gps_coords = _tmp3_;
	_tmp4_ = gps_coords;
	positionable_set_gps_coords (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_POSITIONABLE, Positionable), &_tmp4_);
}

GeeCollection*
library_photo_get_import_keywords (LibraryPhoto* self)
{
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO (self), NULL);
	_tmp0_ = self->priv->import_keywords;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

void
library_photo_clear_import_keywords (LibraryPhoto* self)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (self));
	_g_object_unref0 (self->priv->import_keywords);
	self->priv->import_keywords = NULL;
}

static void
library_photo_real_notify_altered (DataObject* base,
                                   Alteration* alteration)
{
	LibraryPhoto * self;
	gboolean _tmp0_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail (IS_ALTERATION (alteration));
	if (!self->priv->block_thumbnail_generation) {
		_tmp0_ = alteration_has_subject (alteration, "image");
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		OneShotScheduler* _tmp1_;
		_tmp1_ = self->priv->thumbnail_scheduler;
		one_shot_scheduler_at_priority_idle (_tmp1_, G_PRIORITY_LOW);
	}
	DATA_OBJECT_CLASS (library_photo_parent_class)->notify_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_DATA_OBJECT, DataObject), alteration);
}

static GdkPixbuf*
library_photo_real_get_preview_pixbuf (MediaSource* base,
                                       Scaling* scaling,
                                       GError** error)
{
	LibraryPhoto * self;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_val_if_fail (scaling != NULL, NULL);
	_tmp0_ = thumbnail_source_get_thumbnail (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), (gint) THUMBNAIL_CACHE_SIZE_BIG, &_inner_error0_);
	pixbuf = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = scaling_perform_on_pixbuf (scaling, pixbuf, GDK_INTERP_BILINEAR, TRUE);
	result = _tmp1_;
	_g_object_unref0 (pixbuf);
	return result;
}

static void
library_photo_real_rotate (Photo* base,
                           Rotation rotation)
{
	LibraryPhoto * self;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	self->priv->block_thumbnail_generation = TRUE;
	PHOTO_CLASS (library_photo_parent_class)->rotate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), rotation);
	self->priv->block_thumbnail_generation = FALSE;
	{
		thumbnail_cache_rotate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), rotation, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_OBJECT, DataObject));
		_tmp1_ = _tmp0_;
		_tmp2_ = err;
		_tmp3_ = _tmp2_->message;
		g_warning ("Photo.vala:5192: Unable to update thumbnails for %s: %s", _tmp1_, _tmp3_);
		_g_free0 (_tmp1_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	thumbnail_source_notify_thumbnail_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
}

static GdkPixbuf*
library_photo_real_get_thumbnail (ThumbnailSource* base,
                                  gint scale,
                                  GError** error)
{
	LibraryPhoto * self;
	GdkPixbuf* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp1_ = thumbnail_cache_fetch (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), scale, &_inner_error0_);
	_tmp0_ = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp2_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp2_;
	_g_object_unref0 (_tmp0_);
	return result;
}

static void
_library_photo_on_duplicate_progress_gfile_progress_callback (gint64 current_num_bytes,
                                                              gint64 total_num_bytes,
                                                              gpointer self)
{
	library_photo_on_duplicate_progress ((LibraryPhoto*) self, current_num_bytes, total_num_bytes);
}

static void
library_photo_duplicate_backing_photo (LibraryPhoto* self,
                                       BackingPhotoRow* backing,
                                       BackingPhotoID* result,
                                       GError** error)
{
	BackingPhotoID backing_id = {0};
	gboolean _tmp0_ = FALSE;
	GFile* file = NULL;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_LIBRARY_PHOTO (self));
	g_return_if_fail ((backing == NULL) || IS_BACKING_PHOTO_ROW (backing));
	backing_photo_id_init (&backing_id, BACKING_PHOTO_ID_INVALID);
	if (backing == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp1_;
		_tmp1_ = backing->filepath;
		_tmp0_ = _tmp1_ == NULL;
	}
	if (_tmp0_) {
		*result = backing_id;
		return;
	}
	_tmp2_ = backing->filepath;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	file = _tmp3_;
	_tmp4_ = file;
	if (g_file_query_exists (_tmp4_, NULL)) {
		GFile* dupe_file = NULL;
		GFile* _tmp5_;
		GFile* _tmp6_;
		DetectedPhotoInformation* detected = NULL;
		BackingPhotoRow* state = NULL;
		GFile* _tmp7_;
		DetectedPhotoInformation* _tmp8_ = NULL;
		BackingPhotoRow* _tmp9_;
		BackingPhotoRow* _tmp10_;
		_tmp5_ = file;
		_tmp6_ = library_files_duplicate (_tmp5_, _library_photo_on_duplicate_progress_gfile_progress_callback, self, TRUE, &_inner_error0_);
		dupe_file = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (file);
			return;
		}
		_tmp7_ = dupe_file;
		_tmp9_ = photo_query_backing_photo_row (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), _tmp7_, PHOTO_FILE_SNIFFER_OPTIONS_NO_MD5, &_tmp8_, &_inner_error0_);
		_detected_photo_information_unref0 (detected);
		detected = _tmp8_;
		state = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_detected_photo_information_unref0 (detected);
			_g_object_unref0 (dupe_file);
			_g_object_unref0 (file);
			return;
		}
		_tmp10_ = state;
		if (_tmp10_ != NULL) {
			BackingPhotoTable* _tmp11_;
			BackingPhotoTable* _tmp12_;
			BackingPhotoRow* _tmp13_;
			BackingPhotoRow* _tmp14_;
			BackingPhotoID _tmp15_;
			_tmp11_ = backing_photo_table_get_instance ();
			_tmp12_ = _tmp11_;
			_tmp13_ = state;
			backing_photo_table_add (_tmp12_, _tmp13_, &_inner_error0_);
			_database_table_unref0 (_tmp12_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_backing_photo_row_unref0 (state);
				_detected_photo_information_unref0 (detected);
				_g_object_unref0 (dupe_file);
				_g_object_unref0 (file);
				return;
			}
			_tmp14_ = state;
			_tmp15_ = _tmp14_->id;
			backing_id = _tmp15_;
		}
		_backing_photo_row_unref0 (state);
		_detected_photo_information_unref0 (detected);
		_g_object_unref0 (dupe_file);
	}
	*result = backing_id;
	_g_object_unref0 (file);
	return;
}

LibraryPhoto*
library_photo_duplicate (LibraryPhoto* self,
                         GError** error)
{
	GFile* dupe_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	BackingPhotoID dupe_editable_id = {0};
	BackingPhotoRow* _tmp4_;
	BackingPhotoRow* _tmp5_;
	BackingPhotoID _tmp6_ = {0};
	BackingPhotoID _tmp7_;
	BackingPhotoID dupe_raw_shotwell_id = {0};
	BackingPhotoRow* _tmp8_;
	BackingPhotoRow* _tmp9_;
	BackingPhotoID _tmp10_ = {0};
	BackingPhotoID _tmp11_;
	BackingPhotoID dupe_raw_camera_id = {0};
	BackingPhotoRow* _tmp12_;
	BackingPhotoRow* _tmp13_;
	BackingPhotoID _tmp14_ = {0};
	BackingPhotoID _tmp15_;
	BackingPhotoID dupe_raw_embedded_id = {0};
	BackingPhotoRow* _tmp16_;
	BackingPhotoRow* _tmp17_;
	BackingPhotoID _tmp18_ = {0};
	BackingPhotoID _tmp19_;
	PhotoID dupe_id = {0};
	PhotoTable* _tmp20_;
	PhotoTable* _tmp21_;
	PhotoID _tmp22_ = {0};
	GFile* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	BackingPhotoID _tmp26_;
	BackingPhotoID _tmp27_;
	BackingPhotoID _tmp28_;
	BackingPhotoID _tmp29_;
	PhotoID _tmp30_ = {0};
	PhotoID _tmp31_;
	PhotoRow* dupe_row = NULL;
	PhotoTable* _tmp32_;
	PhotoTable* _tmp33_;
	PhotoID _tmp34_;
	PhotoRow* _tmp35_;
	PhotoRow* _tmp36_;
	LibraryPhoto* dupe = NULL;
	PhotoRow* _tmp37_;
	LibraryPhoto* _tmp38_;
	LibraryPhoto* _tmp39_;
	LibraryPhotoSourceCollection* _tmp40_;
	LibraryPhoto* _tmp41_;
	LibraryPhoto* _tmp42_;
	Event* _tmp43_;
	Event* _tmp44_;
	gboolean _tmp45_;
	GeeCollection* tags = NULL;
	TagSourceCollection* _tmp50_;
	GeeList* _tmp51_;
	GeeCollection* _tmp52_;
	GeeCollection* faces = NULL;
	FaceSourceCollection* _tmp60_;
	GeeList* _tmp61_;
	GeeCollection* _tmp62_;
	GError* _inner_error0_ = NULL;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO (self), NULL);
	_tmp0_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp1_ = _tmp0_;
	_tmp2_ = library_files_duplicate (_tmp1_, _library_photo_on_duplicate_progress_gfile_progress_callback, self, TRUE, &_inner_error0_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	dupe_file = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp4_ = photo_get_editable_photo_row (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo));
	_tmp5_ = _tmp4_;
	library_photo_duplicate_backing_photo (self, _tmp5_, &_tmp6_, &_inner_error0_);
	_tmp7_ = _tmp6_;
	_backing_photo_row_unref0 (_tmp5_);
	dupe_editable_id = _tmp7_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp8_ = photo_get_raw_development_photo_row (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), RAW_DEVELOPER_SHOTWELL);
	_tmp9_ = _tmp8_;
	library_photo_duplicate_backing_photo (self, _tmp9_, &_tmp10_, &_inner_error0_);
	_tmp11_ = _tmp10_;
	_backing_photo_row_unref0 (_tmp9_);
	dupe_raw_shotwell_id = _tmp11_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp12_ = photo_get_raw_development_photo_row (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), RAW_DEVELOPER_CAMERA);
	_tmp13_ = _tmp12_;
	library_photo_duplicate_backing_photo (self, _tmp13_, &_tmp14_, &_inner_error0_);
	_tmp15_ = _tmp14_;
	_backing_photo_row_unref0 (_tmp13_);
	dupe_raw_camera_id = _tmp15_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp16_ = photo_get_raw_development_photo_row (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), RAW_DEVELOPER_EMBEDDED);
	_tmp17_ = _tmp16_;
	library_photo_duplicate_backing_photo (self, _tmp17_, &_tmp18_, &_inner_error0_);
	_tmp19_ = _tmp18_;
	_backing_photo_row_unref0 (_tmp17_);
	dupe_raw_embedded_id = _tmp19_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (dupe_file);
		return NULL;
	}
	_tmp20_ = photo_table_get_instance ();
	_tmp21_ = _tmp20_;
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp22_);
	_tmp23_ = dupe_file;
	_tmp24_ = g_file_get_path (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = dupe_editable_id;
	_tmp27_ = dupe_raw_shotwell_id;
	_tmp28_ = dupe_raw_camera_id;
	_tmp29_ = dupe_raw_embedded_id;
	photo_table_duplicate (_tmp21_, &_tmp22_, _tmp25_, &_tmp26_, &_tmp27_, &_tmp28_, &_tmp29_, &_tmp30_);
	_tmp31_ = _tmp30_;
	_g_free0 (_tmp25_);
	_database_table_unref0 (_tmp21_);
	dupe_id = _tmp31_;
	_tmp32_ = photo_table_get_instance ();
	_tmp33_ = _tmp32_;
	_tmp34_ = dupe_id;
	_tmp35_ = photo_table_get_row (_tmp33_, &_tmp34_);
	_tmp36_ = _tmp35_;
	_database_table_unref0 (_tmp33_);
	dupe_row = _tmp36_;
	_tmp37_ = dupe_row;
	_tmp38_ = library_photo_new (_tmp37_);
	dupe = _tmp38_;
	_tmp39_ = dupe;
	thumbnail_cache_duplicate (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource), G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
	_tmp40_ = library_photo_global;
	_tmp41_ = dupe;
	data_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_DATA_OBJECT, DataObject));
	_tmp42_ = dupe;
	_tmp43_ = media_source_get_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, TYPE_MEDIA_SOURCE, MediaSource));
	_tmp44_ = _tmp43_;
	_tmp45_ = _tmp44_ != NULL;
	_g_object_unref0 (_tmp44_);
	if (_tmp45_) {
		LibraryPhoto* _tmp46_;
		Event* _tmp47_;
		Event* _tmp48_;
		LibraryPhoto* _tmp49_;
		_tmp46_ = dupe;
		_tmp47_ = media_source_get_event (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, TYPE_MEDIA_SOURCE, MediaSource));
		_tmp48_ = _tmp47_;
		_tmp49_ = dupe;
		event_attach (_tmp48_, G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, TYPE_MEDIA_SOURCE, MediaSource));
		_g_object_unref0 (_tmp48_);
	}
	_tmp50_ = tag_global;
	_tmp51_ = tag_source_collection_fetch_for_source (_tmp50_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp52_ = tags;
	if (_tmp52_ != NULL) {
		{
			GeeIterator* _tag_it = NULL;
			GeeCollection* _tmp53_;
			GeeIterator* _tmp54_;
			_tmp53_ = tags;
			_tmp54_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, GEE_TYPE_ITERABLE, GeeIterable));
			_tag_it = _tmp54_;
			while (TRUE) {
				GeeIterator* _tmp55_;
				Tag* tag = NULL;
				GeeIterator* _tmp56_;
				gpointer _tmp57_;
				Tag* _tmp58_;
				LibraryPhoto* _tmp59_;
				_tmp55_ = _tag_it;
				if (!gee_iterator_next (_tmp55_)) {
					break;
				}
				_tmp56_ = _tag_it;
				_tmp57_ = gee_iterator_get (_tmp56_);
				tag = (Tag*) _tmp57_;
				_tmp58_ = tag;
				_tmp59_ = dupe;
				tag_attach (_tmp58_, G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, TYPE_MEDIA_SOURCE, MediaSource));
				_g_object_unref0 (tag);
			}
			_g_object_unref0 (_tag_it);
		}
	}
	_tmp60_ = face_global;
	_tmp61_ = face_source_collection_fetch_for_source (_tmp60_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	faces = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp62_ = faces;
	if (_tmp62_ != NULL) {
		{
			GeeIterator* _face_it = NULL;
			GeeCollection* _tmp63_;
			GeeIterator* _tmp64_;
			_tmp63_ = faces;
			_tmp64_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, GEE_TYPE_ITERABLE, GeeIterable));
			_face_it = _tmp64_;
			while (TRUE) {
				GeeIterator* _tmp65_;
				Face* face = NULL;
				GeeIterator* _tmp66_;
				gpointer _tmp67_;
				FaceLocation* location = NULL;
				Face* _tmp68_;
				FaceID _tmp69_ = {0};
				PhotoID _tmp70_ = {0};
				FaceLocation* _tmp71_;
				FaceLocation* _tmp72_;
				_tmp65_ = _face_it;
				if (!gee_iterator_next (_tmp65_)) {
					break;
				}
				_tmp66_ = _face_it;
				_tmp67_ = gee_iterator_get (_tmp66_);
				face = (Face*) _tmp67_;
				_tmp68_ = face;
				face_get_face_id (_tmp68_, &_tmp69_);
				photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp70_);
				_tmp71_ = face_location_get_face_location (&_tmp69_, &_tmp70_);
				location = _tmp71_;
				_tmp72_ = location;
				if (_tmp72_ != NULL) {
					Face* _tmp73_;
					LibraryPhoto* _tmp74_;
					Face* _tmp75_;
					FaceID _tmp76_ = {0};
					LibraryPhoto* _tmp77_;
					PhotoID _tmp78_ = {0};
					FaceLocation* _tmp79_;
					FaceLocationData _tmp80_ = {0};
					FaceLocationData _tmp81_;
					FaceLocation* _tmp82_;
					FaceLocation* _tmp83_;
					_tmp73_ = face;
					_tmp74_ = dupe;
					face_attach (_tmp73_, G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, TYPE_MEDIA_SOURCE, MediaSource));
					_tmp75_ = face;
					face_get_face_id (_tmp75_, &_tmp76_);
					_tmp77_ = dupe;
					photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, TYPE_PHOTO, Photo), &_tmp78_);
					_tmp79_ = location;
					face_location_get_face_data (_tmp79_, &_tmp80_);
					_tmp81_ = _tmp80_;
					_tmp82_ = face_location_create (&_tmp76_, &_tmp78_, &_tmp81_);
					_tmp83_ = _tmp82_;
					_g_object_unref0 (_tmp83_);
					face_location_data_destroy (&_tmp81_);
				}
				_g_object_unref0 (location);
				_g_object_unref0 (face);
			}
			_g_object_unref0 (_face_it);
		}
	}
	result = dupe;
	_g_object_unref0 (faces);
	_g_object_unref0 (tags);
	_photo_row_unref0 (dupe_row);
	_g_object_unref0 (dupe_file);
	return result;
}

static void
library_photo_on_duplicate_progress (LibraryPhoto* self,
                                     gint64 current,
                                     gint64 total)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (self));
	spin_event_loop ();
}

static void
library_photo_upgrade_rating_flags (LibraryPhoto* self,
                                    guint64 flags)
{
	g_return_if_fail (IS_LIBRARY_PHOTO (self));
	if ((flags & LIBRARY_PHOTO_FLAG_HIDDEN) != ((guint64) 0)) {
		media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), RATING_REJECTED);
		photo_remove_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_HIDDEN, NULL);
	}
	if ((flags & LIBRARY_PHOTO_FLAG_FAVORITE) != ((guint64) 0)) {
		media_source_set_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource), RATING_FIVE);
		photo_remove_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_FAVORITE, NULL);
	}
}

static gboolean
library_photo_real_is_trashed (MediaSource* base)
{
	LibraryPhoto * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	result = photo_is_flag_set (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_TRASH);
	return result;
}

static void
library_photo_real_trash (MediaSource* base)
{
	LibraryPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	photo_add_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_TRASH, NULL);
}

static void
library_photo_real_untrash (MediaSource* base)
{
	LibraryPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	photo_remove_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_TRASH, NULL);
}

static gboolean
library_photo_real_is_offline (Monitorable* base)
{
	LibraryPhoto * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	result = photo_is_flag_set (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_OFFLINE);
	return result;
}

static void
library_photo_real_mark_offline (Monitorable* base)
{
	LibraryPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	photo_add_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_OFFLINE, NULL);
}

static void
library_photo_real_mark_online (Monitorable* base)
{
	LibraryPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	photo_remove_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_OFFLINE, NULL);
}

static gboolean
library_photo_real_is_flagged (Flaggable* base)
{
	LibraryPhoto * self;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	result = photo_is_flag_set (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_FLAGGED);
	return result;
}

static void
library_photo_real_mark_flagged (Flaggable* base)
{
	LibraryPhoto * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	photo_add_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static void
library_photo_real_mark_unflagged (Flaggable* base)
{
	LibraryPhoto * self;
	Alteration* _tmp0_;
	Alteration* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp0_ = alteration_new ("metadata", "flagged");
	_tmp1_ = _tmp0_;
	photo_remove_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), LIBRARY_PHOTO_FLAG_FLAGGED, _tmp1_);
	_alteration_unref0 (_tmp1_);
}

static gboolean
library_photo_real_internal_delete_backing (DataSource* base,
                                            GError** error)
{
	LibraryPhoto * self;
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp0_ = DATA_SOURCE_CLASS (library_photo_parent_class)->internal_delete_backing (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_DATA_SOURCE, DataSource), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp1_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		return _tmp1_;
	}
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	result = media_source_delete_original_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	return result;
}

static void
library_photo_real_destroy (DataSource* base)
{
	LibraryPhoto * self;
	PhotoID photo_id = {0};
	PhotoID _tmp0_ = {0};
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	photo_get_photo_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), &_tmp0_);
	photo_id = _tmp0_;
	thumbnail_cache_remove (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_THUMBNAIL_SOURCE, ThumbnailSource));
	{
		PhotoTable* _tmp1_;
		PhotoTable* _tmp2_;
		PhotoID _tmp3_;
		_tmp1_ = photo_table_get_instance ();
		_tmp2_ = _tmp1_;
		_tmp3_ = photo_id;
		photo_table_remove (_tmp2_, &_tmp3_, &_inner_error0_);
		_database_table_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp4_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = err;
		app_window_database_error (_tmp4_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	DATA_SOURCE_CLASS (library_photo_parent_class)->destroy (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO, Photo), TYPE_DATA_SOURCE, DataSource));
}

gboolean
library_photo_has_nontrash_duplicate (GFile* file,
                                      const gchar* thumbnail_md5,
                                      const gchar* full_md5,
                                      PhotoFileFormat file_format)
{
	PhotoID _tmp0_ = {0};
	gboolean result;
	g_return_val_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	library_photo_get_nontrash_duplicate (file, thumbnail_md5, full_md5, file_format, &_tmp0_);
	result = photo_id_is_valid (&_tmp0_);
	return result;
}

void
library_photo_get_nontrash_duplicate (GFile* file,
                                      const gchar* thumbnail_md5,
                                      const gchar* full_md5,
                                      PhotoFileFormat file_format,
                                      PhotoID* result)
{
	PhotoID* ids = NULL;
	gint _tmp0_ = 0;
	PhotoID* _tmp1_;
	gint ids_length1;
	gint _ids_size_;
	gboolean _tmp2_ = FALSE;
	PhotoID* _tmp3_;
	gint _tmp3__length1;
	PhotoID* _tmp6_;
	gint _tmp6__length1;
	PhotoID _tmp13_ = {0};
	g_return_if_fail ((file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()));
	_tmp1_ = photo_get_duplicate_ids (file, thumbnail_md5, full_md5, file_format, &_tmp0_);
	ids = _tmp1_;
	ids_length1 = _tmp0_;
	_ids_size_ = ids_length1;
	_tmp3_ = ids;
	_tmp3__length1 = ids_length1;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		PhotoID* _tmp4_;
		gint _tmp4__length1;
		_tmp4_ = ids;
		_tmp4__length1 = ids_length1;
		_tmp2_ = _tmp4__length1 == 0;
	}
	if (_tmp2_) {
		PhotoID _tmp5_ = {0};
		photo_id_init (&_tmp5_, PHOTO_ID_INVALID);
		*result = _tmp5_;
		ids = (g_free (ids), NULL);
		return;
	}
	_tmp6_ = ids;
	_tmp6__length1 = ids_length1;
	{
		PhotoID* id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = _tmp6_;
		id_collection_length1 = _tmp6__length1;
		for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
			PhotoID id = {0};
			id = id_collection[id_it];
			{
				LibraryPhoto* photo = NULL;
				LibraryPhotoSourceCollection* _tmp7_;
				PhotoID _tmp8_;
				LibraryPhoto* _tmp9_;
				gboolean _tmp10_ = FALSE;
				LibraryPhoto* _tmp11_;
				_tmp7_ = library_photo_global;
				_tmp8_ = id;
				_tmp9_ = library_photo_source_collection_fetch (_tmp7_, &_tmp8_);
				photo = _tmp9_;
				_tmp11_ = photo;
				if (_tmp11_ != NULL) {
					LibraryPhoto* _tmp12_;
					_tmp12_ = photo;
					_tmp10_ = !media_source_is_trashed (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, TYPE_MEDIA_SOURCE, MediaSource));
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					*result = id;
					_g_object_unref0 (photo);
					ids = (g_free (ids), NULL);
					return;
				}
				_g_object_unref0 (photo);
			}
		}
	}
	photo_id_init (&_tmp13_, PHOTO_ID_INVALID);
	*result = _tmp13_;
	ids = (g_free (ids), NULL);
	return;
}

static gboolean
library_photo_real_has_user_generated_metadata (Photo* base)
{
	LibraryPhoto * self;
	GeeList* tags = NULL;
	TagSourceCollection* _tmp0_;
	GeeList* _tmp1_;
	PhotoMetadata* metadata = NULL;
	PhotoMetadata* _tmp2_;
	PhotoMetadata* _tmp3_;
	PhotoMetadata* _tmp12_;
	GpsCoords old_coords = {0};
	PhotoMetadata* _tmp13_;
	GpsCoords _tmp14_ = {0};
	GpsCoords _tmp15_ = {0};
	gboolean _tmp16_;
	GeeSet* keywords = NULL;
	PhotoMetadata* _tmp17_;
	GeeSet* _tmp18_;
	gint _tmp19_ = 0;
	GeeList* _tmp20_;
	gint tags_count = 0;
	gint _tmp24_ = 0;
	GeeSet* _tmp25_;
	gint keywords_count = 0;
	gboolean _tmp29_ = FALSE;
	GeeList* _tmp30_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_fetch_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	tags = _tmp1_;
	_tmp2_ = photo_source_get_metadata (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PHOTO_SOURCE, PhotoSource));
	metadata = _tmp2_;
	_tmp3_ = metadata;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GeeList* _tmp7_;
		_tmp7_ = tags;
		if (_tmp7_ != NULL) {
			_tmp6_ = TRUE;
		} else {
			GeeList* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			_tmp8_ = tags;
			_tmp9_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ > 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = media_source_get_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource)) != RATING_UNRATED;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			GpsCoords _tmp11_ = {0};
			positionable_get_gps_coords (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_POSITIONABLE, Positionable), &_tmp11_);
			_tmp4_ = _tmp11_.has_gps != 0;
		}
		result = _tmp4_;
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (tags);
		return result;
	}
	_tmp12_ = metadata;
	if (media_source_get_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource)) != photo_metadata_get_rating (_tmp12_)) {
		result = TRUE;
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (tags);
		return result;
	}
	_tmp13_ = metadata;
	photo_metadata_get_gps_coords (_tmp13_, &_tmp14_);
	old_coords = _tmp14_;
	positionable_get_gps_coords (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_POSITIONABLE, Positionable), &_tmp15_);
	_tmp16_ = gps_coords_equals (&_tmp15_, &old_coords);
	if (!_tmp16_) {
		result = TRUE;
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (tags);
		return result;
	}
	_tmp17_ = metadata;
	_tmp18_ = photo_metadata_get_keywords (_tmp17_, NULL, NULL, NULL);
	keywords = _tmp18_;
	_tmp20_ = tags;
	if (_tmp20_ != NULL) {
		GeeList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		_tmp21_ = tags;
		_tmp22_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp23_ = _tmp22_;
		_tmp19_ = _tmp23_;
	} else {
		_tmp19_ = 0;
	}
	tags_count = _tmp19_;
	_tmp25_ = keywords;
	if (_tmp25_ != NULL) {
		GeeSet* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp26_ = keywords;
		_tmp27_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_COLLECTION, GeeCollection));
		_tmp28_ = _tmp27_;
		_tmp24_ = _tmp28_;
	} else {
		_tmp24_ = 0;
	}
	keywords_count = _tmp24_;
	if (tags_count != keywords_count) {
		result = TRUE;
		_g_object_unref0 (keywords);
		_media_metadata_unref0 (metadata);
		_g_object_unref0 (tags);
		return result;
	}
	_tmp30_ = tags;
	if (_tmp30_ != NULL) {
		GeeSet* _tmp31_;
		_tmp31_ = keywords;
		_tmp29_ = _tmp31_ != NULL;
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		{
			GeeList* _tag_list = NULL;
			GeeList* _tmp32_;
			gint _tag_size = 0;
			GeeList* _tmp33_;
			gint _tmp34_;
			gint _tmp35_;
			gint _tag_index = 0;
			_tmp32_ = tags;
			_tag_list = _tmp32_;
			_tmp33_ = _tag_list;
			_tmp34_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp35_ = _tmp34_;
			_tag_size = _tmp35_;
			_tag_index = -1;
			while (TRUE) {
				gint _tmp36_;
				gint _tmp37_;
				Tag* tag = NULL;
				GeeList* _tmp38_;
				gpointer _tmp39_;
				GeeSet* _tmp40_;
				Tag* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gboolean _tmp46_;
				_tag_index = _tag_index + 1;
				_tmp36_ = _tag_index;
				_tmp37_ = _tag_size;
				if (!(_tmp36_ < _tmp37_)) {
					break;
				}
				_tmp38_ = _tag_list;
				_tmp39_ = gee_list_get (_tmp38_, _tag_index);
				tag = (Tag*) _tmp39_;
				_tmp40_ = keywords;
				_tmp41_ = tag;
				_tmp42_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp41_, TYPE_DATA_OBJECT, DataObject));
				_tmp43_ = _tmp42_;
				_tmp44_ = g_utf8_normalize (_tmp43_, (gssize) -1, G_NORMALIZE_DEFAULT);
				_tmp45_ = _tmp44_;
				_tmp46_ = !gee_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, GEE_TYPE_COLLECTION, GeeCollection), _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				if (_tmp46_) {
					result = TRUE;
					_g_object_unref0 (tag);
					_g_object_unref0 (keywords);
					_media_metadata_unref0 (metadata);
					_g_object_unref0 (tags);
					return result;
				}
				_g_object_unref0 (tag);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (keywords);
	_media_metadata_unref0 (metadata);
	_g_object_unref0 (tags);
	return result;
}

static void
library_photo_real_set_user_metadata_for_export (Photo* base,
                                                 PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	GeeList* photo_tags = NULL;
	TagSourceCollection* _tmp0_;
	GeeList* _tmp1_;
	GeeList* _tmp2_;
	GpsCoords _tmp17_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
	_tmp0_ = tag_global;
	_tmp1_ = tag_source_collection_fetch_for_source (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
	photo_tags = _tmp1_;
	_tmp2_ = photo_tags;
	if (_tmp2_ != NULL) {
		GeeCollection* string_tags = NULL;
		GeeArrayList* _tmp3_;
		GeeCollection* _tmp16_;
		_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
		string_tags = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
		{
			GeeList* _tag_list = NULL;
			GeeList* _tmp4_;
			gint _tag_size = 0;
			GeeList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _tag_index = 0;
			_tmp4_ = photo_tags;
			_tag_list = _tmp4_;
			_tmp5_ = _tag_list;
			_tmp6_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp7_ = _tmp6_;
			_tag_size = _tmp7_;
			_tag_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				Tag* tag = NULL;
				GeeList* _tmp10_;
				gpointer _tmp11_;
				GeeCollection* _tmp12_;
				Tag* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tag_index = _tag_index + 1;
				_tmp8_ = _tag_index;
				_tmp9_ = _tag_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _tag_list;
				_tmp11_ = gee_list_get (_tmp10_, _tag_index);
				tag = (Tag*) _tmp11_;
				_tmp12_ = string_tags;
				_tmp13_ = tag;
				_tmp14_ = data_object_get_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_DATA_OBJECT, DataObject));
				_tmp15_ = _tmp14_;
				gee_collection_add (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				_g_object_unref0 (tag);
			}
		}
		_tmp16_ = string_tags;
		photo_metadata_set_keywords (metadata, _tmp16_, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
		_g_object_unref0 (string_tags);
	} else {
		photo_metadata_set_keywords (metadata, NULL, PHOTO_METADATA_SET_OPTION_ALL_DOMAINS);
	}
	photo_metadata_set_rating (metadata, media_source_get_rating (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource)));
	positionable_get_gps_coords (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_POSITIONABLE, Positionable), &_tmp17_);
	photo_metadata_set_gps_coords (metadata, &_tmp17_);
	_g_object_unref0 (photo_tags);
}

static void
library_photo_real_apply_user_metadata_for_reimport (Photo* base,
                                                     PhotoMetadata* metadata)
{
	LibraryPhoto * self;
	HierarchicalTagIndex* new_htag_index = NULL;
	GeeCollection* keywords = NULL;
	GeeSet* _tmp3_;
	GeeCollection* _tmp4_;
	HierarchicalTagIndex* _tmp31_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	g_return_if_fail (IS_PHOTO_METADATA (metadata));
	new_htag_index = NULL;
	if (photo_metadata_has_hierarchical_keywords (metadata)) {
		GeeSet* _tmp0_;
		GeeSet* _tmp1_;
		HierarchicalTagIndex* _tmp2_;
		_tmp0_ = photo_metadata_get_hierarchical_keywords (metadata);
		_tmp1_ = _tmp0_;
		_tmp2_ = hierarchical_tag_utilities_process_hierarchical_import_keywords (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
		_hierarchical_tag_index_unref0 (new_htag_index);
		new_htag_index = _tmp2_;
		_g_object_unref0 (_tmp1_);
	}
	_tmp3_ = photo_metadata_get_keywords (metadata, NULL, NULL, NULL);
	keywords = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp4_ = keywords;
	if (_tmp4_ != NULL) {
		{
			GeeIterator* _keyword_it = NULL;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			_tmp5_ = keywords;
			_tmp6_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ITERABLE, GeeIterable));
			_keyword_it = _tmp6_;
			while (TRUE) {
				GeeIterator* _tmp7_;
				gchar* keyword = NULL;
				GeeIterator* _tmp8_;
				gpointer _tmp9_;
				gboolean _tmp10_ = FALSE;
				HierarchicalTagIndex* _tmp11_;
				gchar* safe_keyword = NULL;
				const gchar* _tmp14_;
				gchar* _tmp15_;
				gchar* promoted_keyword = NULL;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				TagSourceCollection* _tmp18_;
				const gchar* _tmp19_;
				TagSourceCollection* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp28_;
				Tag* _tmp29_;
				Tag* _tmp30_;
				_tmp7_ = _keyword_it;
				if (!gee_iterator_next (_tmp7_)) {
					break;
				}
				_tmp8_ = _keyword_it;
				_tmp9_ = gee_iterator_get (_tmp8_);
				keyword = (gchar*) _tmp9_;
				_tmp11_ = new_htag_index;
				if (_tmp11_ != NULL) {
					HierarchicalTagIndex* _tmp12_;
					const gchar* _tmp13_;
					_tmp12_ = new_htag_index;
					_tmp13_ = keyword;
					_tmp10_ = hierarchical_tag_index_is_tag_in_index (_tmp12_, _tmp13_);
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					_g_free0 (keyword);
					continue;
				}
				_tmp14_ = keyword;
				_tmp15_ = hierarchical_tag_utilities_make_flat_tag_safe (_tmp14_);
				safe_keyword = _tmp15_;
				_tmp16_ = safe_keyword;
				_tmp17_ = hierarchical_tag_utilities_flat_to_hierarchical (_tmp16_);
				promoted_keyword = _tmp17_;
				_tmp18_ = tag_global;
				_tmp19_ = safe_keyword;
				if (tag_source_collection_exists (_tmp18_, _tmp19_, FALSE)) {
					const gchar* _tmp20_;
					Tag* _tmp21_;
					Tag* _tmp22_;
					_tmp20_ = safe_keyword;
					_tmp21_ = tag_for_path (_tmp20_);
					_tmp22_ = _tmp21_;
					tag_attach (_tmp22_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
					_g_object_unref0 (_tmp22_);
					_g_free0 (promoted_keyword);
					_g_free0 (safe_keyword);
					_g_free0 (keyword);
					continue;
				}
				_tmp23_ = tag_global;
				_tmp24_ = promoted_keyword;
				if (tag_source_collection_exists (_tmp23_, _tmp24_, FALSE)) {
					const gchar* _tmp25_;
					Tag* _tmp26_;
					Tag* _tmp27_;
					_tmp25_ = promoted_keyword;
					_tmp26_ = tag_for_path (_tmp25_);
					_tmp27_ = _tmp26_;
					tag_attach (_tmp27_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
					_g_object_unref0 (_tmp27_);
					_g_free0 (promoted_keyword);
					_g_free0 (safe_keyword);
					_g_free0 (keyword);
					continue;
				}
				_tmp28_ = keyword;
				_tmp29_ = tag_for_path (_tmp28_);
				_tmp30_ = _tmp29_;
				tag_attach (_tmp30_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
				_g_object_unref0 (_tmp30_);
				_g_free0 (promoted_keyword);
				_g_free0 (safe_keyword);
				_g_free0 (keyword);
			}
			_g_object_unref0 (_keyword_it);
		}
	}
	_tmp31_ = new_htag_index;
	if (_tmp31_ != NULL) {
		{
			GeeIterator* _path_it = NULL;
			HierarchicalTagIndex* _tmp32_;
			GeeCollection* _tmp33_;
			GeeCollection* _tmp34_;
			GeeIterator* _tmp35_;
			GeeIterator* _tmp36_;
			_tmp32_ = new_htag_index;
			_tmp33_ = hierarchical_tag_index_get_all_paths (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp36_ = _tmp35_;
			_g_object_unref0 (_tmp34_);
			_path_it = _tmp36_;
			while (TRUE) {
				GeeIterator* _tmp37_;
				gchar* path = NULL;
				GeeIterator* _tmp38_;
				gpointer _tmp39_;
				const gchar* _tmp40_;
				Tag* _tmp41_;
				Tag* _tmp42_;
				_tmp37_ = _path_it;
				if (!gee_iterator_next (_tmp37_)) {
					break;
				}
				_tmp38_ = _path_it;
				_tmp39_ = gee_iterator_get (_tmp38_);
				path = (gchar*) _tmp39_;
				_tmp40_ = path;
				_tmp41_ = tag_for_path (_tmp40_);
				_tmp42_ = _tmp41_;
				tag_attach (_tmp42_, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE, MediaSource));
				_g_object_unref0 (_tmp42_);
				_g_free0 (path);
			}
			_g_object_unref0 (_path_it);
		}
	}
	_g_object_unref0 (keywords);
	_hierarchical_tag_index_unref0 (new_htag_index);
}

static void
library_photo_class_init (LibraryPhotoClass * klass,
                          gpointer klass_data)
{
	library_photo_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &LibraryPhoto_private_offset);
	((PhotoClass *) klass)->notify_master_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_master_reimported;
	((PhotoClass *) klass)->notify_editable_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_editable_reimported;
	((PhotoClass *) klass)->notify_source_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_source_reimported;
	((PhotoClass *) klass)->notify_baseline_reimported = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_notify_baseline_reimported;
	((DataObjectClass *) klass)->notify_altered = (void (*) (DataObject*, Alteration*)) library_photo_real_notify_altered;
	((MediaSourceClass *) klass)->get_preview_pixbuf = (GdkPixbuf* (*) (MediaSource*, Scaling*, GError**)) library_photo_real_get_preview_pixbuf;
	((PhotoClass *) klass)->rotate = (void (*) (Photo*, Rotation)) library_photo_real_rotate;
	((ThumbnailSourceClass *) klass)->get_thumbnail = (GdkPixbuf* (*) (ThumbnailSource*, gint, GError**)) library_photo_real_get_thumbnail;
	((MediaSourceClass *) klass)->is_trashed = (gboolean (*) (MediaSource*)) library_photo_real_is_trashed;
	((MediaSourceClass *) klass)->trash = (void (*) (MediaSource*)) library_photo_real_trash;
	((MediaSourceClass *) klass)->untrash = (void (*) (MediaSource*)) library_photo_real_untrash;
	((MediaSourceClass *) klass)->is_offline = (gboolean (*) (MediaSource*)) library_photo_real_is_offline;
	((MediaSourceClass *) klass)->mark_offline = (void (*) (MediaSource*)) library_photo_real_mark_offline;
	((MediaSourceClass *) klass)->mark_online = (void (*) (MediaSource*)) library_photo_real_mark_online;
	((DataSourceClass *) klass)->internal_delete_backing = (gboolean (*) (DataSource*, GError**)) library_photo_real_internal_delete_backing;
	((DataSourceClass *) klass)->destroy = (void (*) (DataSource*)) library_photo_real_destroy;
	((PhotoClass *) klass)->has_user_generated_metadata = (gboolean (*) (Photo*)) library_photo_real_has_user_generated_metadata;
	((PhotoClass *) klass)->set_user_metadata_for_export = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_set_user_metadata_for_export;
	((PhotoClass *) klass)->apply_user_metadata_for_reimport = (void (*) (Photo*, PhotoMetadata*)) library_photo_real_apply_user_metadata_for_reimport;
	G_OBJECT_CLASS (klass)->finalize = library_photo_finalize;
}

static void
library_photo_flaggable_interface_init (FlaggableIface * iface,
                                        gpointer iface_data)
{
	library_photo_flaggable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_flagged = (gboolean (*) (Flaggable*)) library_photo_real_is_flagged;
	iface->mark_flagged = (void (*) (Flaggable*)) library_photo_real_mark_flagged;
	iface->mark_unflagged = (void (*) (Flaggable*)) library_photo_real_mark_unflagged;
}

static void
library_photo_monitorable_interface_init (MonitorableIface * iface,
                                          gpointer iface_data)
{
	library_photo_monitorable_parent_iface = g_type_interface_peek_parent (iface);
	iface->is_offline = (gboolean (*) (Monitorable*)) library_photo_real_is_offline;
	iface->mark_offline = (void (*) (Monitorable*)) library_photo_real_mark_offline;
	iface->mark_online = (void (*) (Monitorable*)) library_photo_real_mark_online;
	iface->set_master_file = (void (*) (Monitorable*, GFile*)) photo_set_master_file;
	iface->set_master_timestamp = (void (*) (Monitorable*, GFileInfo*)) photo_set_master_timestamp;
}

static void
library_photo_instance_init (LibraryPhoto * self,
                             gpointer klass)
{
	self->priv = library_photo_get_instance_private (self);
	self->priv->block_thumbnail_generation = FALSE;
	self->priv->thumbnail_scheduler = NULL;
}

static void
library_photo_finalize (GObject * obj)
{
	LibraryPhoto * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_PHOTO, LibraryPhoto);
	_one_shot_scheduler_unref0 (self->priv->thumbnail_scheduler);
	_g_object_unref0 (self->priv->import_keywords);
	G_OBJECT_CLASS (library_photo_parent_class)->finalize (obj);
}

static GType
library_photo_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryPhotoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_photo_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryPhoto), 0, (GInstanceInitFunc) library_photo_instance_init, NULL };
	static const GInterfaceInfo flaggable_info = { (GInterfaceInitFunc) library_photo_flaggable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo monitorable_info = { (GInterfaceInitFunc) library_photo_monitorable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType library_photo_type_id;
	library_photo_type_id = g_type_register_static (TYPE_PHOTO, "LibraryPhoto", &g_define_type_info, 0);
	g_type_add_interface_static (library_photo_type_id, TYPE_FLAGGABLE, &flaggable_info);
	g_type_add_interface_static (library_photo_type_id, TYPE_MONITORABLE, &monitorable_info);
	LibraryPhoto_private_offset = g_type_add_instance_private (library_photo_type_id, sizeof (LibraryPhotoPrivate));
	return library_photo_type_id;
}

GType
library_photo_get_type (void)
{
	static volatile gsize library_photo_type_id__once = 0;
	if (g_once_init_enter (&library_photo_type_id__once)) {
		GType library_photo_type_id;
		library_photo_type_id = library_photo_get_type_once ();
		g_once_init_leave (&library_photo_type_id__once, library_photo_type_id);
	}
	return library_photo_type_id__once;
}

static inline gpointer
library_photo_source_holding_tank_get_instance_private (LibraryPhotoSourceHoldingTank* self)
{
	return G_STRUCT_MEMBER_P (self, LibraryPhotoSourceHoldingTank_private_offset);
}

LibraryPhotoSourceHoldingTank*
library_photo_source_holding_tank_construct (GType object_type,
                                             LibraryPhotoSourceCollection* sources,
                                             SourceHoldingTankCheckToKeep check_to_keep,
                                             gpointer check_to_keep_target,
                                             GetSourceDatabaseKey get_key,
                                             gpointer get_key_target)
{
	LibraryPhotoSourceHoldingTank* self = NULL;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_COLLECTION (sources), NULL);
	self = (LibraryPhotoSourceHoldingTank*) media_source_holding_tank_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (sources, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), check_to_keep, check_to_keep_target, get_key, get_key_target);
	return self;
}

LibraryPhotoSourceHoldingTank*
library_photo_source_holding_tank_new (LibraryPhotoSourceCollection* sources,
                                       SourceHoldingTankCheckToKeep check_to_keep,
                                       gpointer check_to_keep_target,
                                       GetSourceDatabaseKey get_key,
                                       gpointer get_key_target)
{
	return library_photo_source_holding_tank_construct (TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, sources, check_to_keep, check_to_keep_target, get_key, get_key_target);
}

LibraryPhoto*
library_photo_source_holding_tank_fetch_by_backing_file (LibraryPhotoSourceHoldingTank* self,
                                                         GFile* file)
{
	LibraryPhoto* ret = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	LibraryPhoto* _tmp2_;
	GeeHashMap* _tmp3_;
	gpointer _tmp4_;
	LibraryPhoto* result;
	g_return_val_if_fail (IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	ret = NULL;
	_tmp0_ = self->priv->editable_file_map;
	_tmp1_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	_g_object_unref0 (ret);
	ret = (LibraryPhoto*) _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ != NULL) {
		result = ret;
		return result;
	}
	_tmp3_ = self->priv->development_file_map;
	_tmp4_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), file);
	result = (LibraryPhoto*) _tmp4_;
	_g_object_unref0 (ret);
	return result;
}

static void
_library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced (Photo* _sender,
                                                                                 GFile* old_file,
                                                                                 GFile* new_file,
                                                                                 gpointer self)
{
	library_photo_source_holding_tank_on_editable_replaced ((LibraryPhotoSourceHoldingTank*) self, _sender, old_file, new_file);
}

static void
_library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified (Photo* _sender,
                                                                                               gpointer self)
{
	library_photo_source_holding_tank_on_raw_development_modified ((LibraryPhotoSourceHoldingTank*) self, _sender);
}

static void
library_photo_source_holding_tank_real_notify_contents_altered (SourceHoldingTank* base,
                                                                GeeCollection* added,
                                                                GeeCollection* removed)
{
	LibraryPhotoSourceHoldingTank * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	if (added != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp0_;
			_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (added, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp0_;
			while (TRUE) {
				GeeIterator* _tmp1_;
				DataSource* source = NULL;
				GeeIterator* _tmp2_;
				gpointer _tmp3_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp4_;
				LibraryPhoto* _tmp5_;
				LibraryPhoto* _tmp6_;
				GFile* _tmp7_;
				GFile* _tmp8_;
				gboolean _tmp9_;
				GeeCollection* raw_files = NULL;
				LibraryPhoto* _tmp20_;
				GeeCollection* _tmp21_;
				GeeCollection* _tmp22_;
				LibraryPhoto* _tmp34_;
				LibraryPhoto* _tmp35_;
				_tmp1_ = _source_it;
				if (!gee_iterator_next (_tmp1_)) {
					break;
				}
				_tmp2_ = _source_it;
				_tmp3_ = gee_iterator_get (_tmp2_);
				source = (DataSource*) _tmp3_;
				_tmp4_ = source;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp5_;
				_tmp6_ = photo;
				_tmp7_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, TYPE_PHOTO, Photo));
				_tmp8_ = _tmp7_;
				_tmp9_ = _tmp8_ != NULL;
				_g_object_unref0 (_tmp8_);
				if (_tmp9_) {
					GeeHashMap* _tmp10_;
					LibraryPhoto* _tmp11_;
					GFile* _tmp12_;
					GFile* _tmp13_;
					LibraryPhoto* _tmp14_;
					GeeMultiMap* _tmp15_;
					LibraryPhoto* _tmp16_;
					LibraryPhoto* _tmp17_;
					GFile* _tmp18_;
					GFile* _tmp19_;
					_tmp10_ = self->priv->editable_file_map;
					_tmp11_ = photo;
					_tmp12_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, TYPE_PHOTO, Photo));
					_tmp13_ = _tmp12_;
					_tmp14_ = photo;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp13_, _tmp14_);
					_g_object_unref0 (_tmp13_);
					_tmp15_ = self->priv->reverse_editable_file_map;
					_tmp16_ = photo;
					_tmp17_ = photo;
					_tmp18_ = photo_get_editable_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO, Photo));
					_tmp19_ = _tmp18_;
					gee_multi_map_set (_tmp15_, _tmp16_, _tmp19_);
					_g_object_unref0 (_tmp19_);
				}
				_tmp20_ = photo;
				_tmp21_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_PHOTO, Photo));
				raw_files = _tmp21_;
				_tmp22_ = raw_files;
				if (_tmp22_ != NULL) {
					{
						GeeIterator* _f_it = NULL;
						GeeCollection* _tmp23_;
						GeeIterator* _tmp24_;
						_tmp23_ = raw_files;
						_tmp24_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ITERABLE, GeeIterable));
						_f_it = _tmp24_;
						while (TRUE) {
							GeeIterator* _tmp25_;
							GFile* f = NULL;
							GeeIterator* _tmp26_;
							gpointer _tmp27_;
							GeeHashMap* _tmp28_;
							GFile* _tmp29_;
							LibraryPhoto* _tmp30_;
							GeeMultiMap* _tmp31_;
							LibraryPhoto* _tmp32_;
							GFile* _tmp33_;
							_tmp25_ = _f_it;
							if (!gee_iterator_next (_tmp25_)) {
								break;
							}
							_tmp26_ = _f_it;
							_tmp27_ = gee_iterator_get (_tmp26_);
							f = (GFile*) _tmp27_;
							_tmp28_ = self->priv->development_file_map;
							_tmp29_ = f;
							_tmp30_ = photo;
							gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp29_, _tmp30_);
							_tmp31_ = self->priv->reverse_development_file_map;
							_tmp32_ = photo;
							_tmp33_ = f;
							gee_multi_map_set (_tmp31_, _tmp32_, _tmp33_);
							_g_object_unref0 (f);
						}
						_g_object_unref0 (_f_it);
					}
				}
				_tmp34_ = photo;
				g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, TYPE_PHOTO, Photo), "editable-replaced", (GCallback) _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced, self);
				_tmp35_ = photo;
				g_signal_connect (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, TYPE_PHOTO, Photo), "raw-development-modified", (GCallback) _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified, self);
				_g_object_unref0 (raw_files);
				_g_object_unref0 (photo);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	if (removed != NULL) {
		{
			GeeIterator* _source_it = NULL;
			GeeIterator* _tmp36_;
			_tmp36_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (removed, GEE_TYPE_ITERABLE, GeeIterable));
			_source_it = _tmp36_;
			while (TRUE) {
				GeeIterator* _tmp37_;
				DataSource* source = NULL;
				GeeIterator* _tmp38_;
				gpointer _tmp39_;
				LibraryPhoto* photo = NULL;
				DataSource* _tmp40_;
				LibraryPhoto* _tmp41_;
				GeeMultiMap* _tmp64_;
				LibraryPhoto* _tmp65_;
				GeeMultiMap* _tmp66_;
				LibraryPhoto* _tmp67_;
				LibraryPhoto* _tmp68_;
				guint _tmp69_;
				LibraryPhoto* _tmp70_;
				guint _tmp71_;
				_tmp37_ = _source_it;
				if (!gee_iterator_next (_tmp37_)) {
					break;
				}
				_tmp38_ = _source_it;
				_tmp39_ = gee_iterator_get (_tmp38_);
				source = (DataSource*) _tmp39_;
				_tmp40_ = source;
				_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
				photo = _tmp41_;
				{
					GeeIterator* _f_it = NULL;
					GeeMultiMap* _tmp42_;
					LibraryPhoto* _tmp43_;
					GeeCollection* _tmp44_;
					GeeCollection* _tmp45_;
					GeeIterator* _tmp46_;
					GeeIterator* _tmp47_;
					_tmp42_ = self->priv->reverse_editable_file_map;
					_tmp43_ = photo;
					_tmp44_ = gee_multi_map_get (_tmp42_, _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, GEE_TYPE_ITERABLE, GeeIterable));
					_tmp47_ = _tmp46_;
					_g_object_unref0 (_tmp45_);
					_f_it = _tmp47_;
					while (TRUE) {
						GeeIterator* _tmp48_;
						GFile* f = NULL;
						GeeIterator* _tmp49_;
						gpointer _tmp50_;
						GeeHashMap* _tmp51_;
						GFile* _tmp52_;
						_tmp48_ = _f_it;
						if (!gee_iterator_next (_tmp48_)) {
							break;
						}
						_tmp49_ = _f_it;
						_tmp50_ = gee_iterator_get (_tmp49_);
						f = (GFile*) _tmp50_;
						_tmp51_ = self->priv->editable_file_map;
						_tmp52_ = f;
						gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp52_, NULL);
						_g_object_unref0 (f);
					}
					_g_object_unref0 (_f_it);
				}
				{
					GeeIterator* _f_it = NULL;
					GeeMultiMap* _tmp53_;
					LibraryPhoto* _tmp54_;
					GeeCollection* _tmp55_;
					GeeCollection* _tmp56_;
					GeeIterator* _tmp57_;
					GeeIterator* _tmp58_;
					_tmp53_ = self->priv->reverse_development_file_map;
					_tmp54_ = photo;
					_tmp55_ = gee_multi_map_get (_tmp53_, _tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, GEE_TYPE_ITERABLE, GeeIterable));
					_tmp58_ = _tmp57_;
					_g_object_unref0 (_tmp56_);
					_f_it = _tmp58_;
					while (TRUE) {
						GeeIterator* _tmp59_;
						GFile* f = NULL;
						GeeIterator* _tmp60_;
						gpointer _tmp61_;
						GeeHashMap* _tmp62_;
						GFile* _tmp63_;
						_tmp59_ = _f_it;
						if (!gee_iterator_next (_tmp59_)) {
							break;
						}
						_tmp60_ = _f_it;
						_tmp61_ = gee_iterator_get (_tmp60_);
						f = (GFile*) _tmp61_;
						_tmp62_ = self->priv->development_file_map;
						_tmp63_ = f;
						gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp63_, NULL);
						_g_object_unref0 (f);
					}
					_g_object_unref0 (_f_it);
				}
				_tmp64_ = self->priv->reverse_editable_file_map;
				_tmp65_ = photo;
				gee_multi_map_remove_all (_tmp64_, _tmp65_);
				_tmp66_ = self->priv->reverse_development_file_map;
				_tmp67_ = photo;
				gee_multi_map_remove_all (_tmp66_, _tmp67_);
				_tmp68_ = photo;
				g_signal_parse_name ("editable-replaced", TYPE_PHOTO, &_tmp69_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, TYPE_PHOTO, Photo), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp69_, 0, NULL, (GCallback) _library_photo_source_holding_tank_on_editable_replaced_photo_editable_replaced, self);
				_tmp70_ = photo;
				g_signal_parse_name ("raw-development-modified", TYPE_PHOTO, &_tmp71_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp70_, TYPE_PHOTO, Photo), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp71_, 0, NULL, (GCallback) _library_photo_source_holding_tank_on_raw_development_modified_photo_raw_development_modified, self);
				_g_object_unref0 (photo);
				_g_object_unref0 (source);
			}
			_g_object_unref0 (_source_it);
		}
	}
	SOURCE_HOLDING_TANK_CLASS (library_photo_source_holding_tank_parent_class)->notify_contents_altered (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_SOURCE_HOLDING_TANK, MediaSourceHoldingTank), TYPE_SOURCE_HOLDING_TANK, SourceHoldingTank), added, removed);
}

static void
library_photo_source_holding_tank_on_editable_replaced (LibraryPhotoSourceHoldingTank* self,
                                                        Photo* _photo,
                                                        GFile* old_file,
                                                        GFile* new_file)
{
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GeeMultiMap* _tmp7_;
	LibraryPhoto* _tmp8_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (self));
	g_return_if_fail (IS_PHOTO (_photo));
	g_return_if_fail ((old_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()));
	g_return_if_fail ((new_file == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()));
	_tmp0_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_photo) ? ((LibraryPhoto*) _photo) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	_vala_assert (_tmp1_ != NULL, "photo != null");
	if (old_file != NULL) {
		GeeHashMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		LibraryPhoto* _tmp4_;
		_tmp2_ = self->priv->editable_file_map;
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), old_file, NULL);
		_tmp3_ = self->priv->reverse_editable_file_map;
		_tmp4_ = photo;
		gee_multi_map_remove (_tmp3_, _tmp4_, old_file);
	}
	if (new_file != NULL) {
		GeeHashMap* _tmp5_;
		LibraryPhoto* _tmp6_;
		_tmp5_ = self->priv->editable_file_map;
		_tmp6_ = photo;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), new_file, _tmp6_);
	}
	_tmp7_ = self->priv->reverse_editable_file_map;
	_tmp8_ = photo;
	gee_multi_map_set (_tmp7_, _tmp8_, new_file);
	_g_object_unref0 (photo);
}

static void
library_photo_source_holding_tank_on_raw_development_modified (LibraryPhotoSourceHoldingTank* self,
                                                               Photo* _photo)
{
	LibraryPhoto* photo = NULL;
	LibraryPhoto* _tmp0_;
	LibraryPhoto* _tmp1_;
	GeeMultiMap* _tmp2_;
	LibraryPhoto* _tmp3_;
	GeeCollection* raw_list = NULL;
	LibraryPhoto* _tmp17_;
	GeeCollection* _tmp18_;
	GeeCollection* _tmp19_;
	g_return_if_fail (IS_LIBRARY_PHOTO_SOURCE_HOLDING_TANK (self));
	g_return_if_fail (IS_PHOTO (_photo));
	_tmp0_ = _g_object_ref0 (IS_LIBRARY_PHOTO (_photo) ? ((LibraryPhoto*) _photo) : NULL);
	photo = _tmp0_;
	_tmp1_ = photo;
	_vala_assert (_tmp1_ != NULL, "photo != null");
	_tmp2_ = self->priv->reverse_development_file_map;
	_tmp3_ = photo;
	if (gee_multi_map_contains (_tmp2_, _tmp3_)) {
		GeeMultiMap* _tmp15_;
		LibraryPhoto* _tmp16_;
		{
			GeeIterator* _f_it = NULL;
			GeeMultiMap* _tmp4_;
			LibraryPhoto* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeIterator* _tmp8_;
			GeeIterator* _tmp9_;
			_tmp4_ = self->priv->reverse_development_file_map;
			_tmp5_ = photo;
			_tmp6_ = gee_multi_map_get (_tmp4_, _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ITERABLE, GeeIterable));
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			_f_it = _tmp9_;
			while (TRUE) {
				GeeIterator* _tmp10_;
				GFile* f = NULL;
				GeeIterator* _tmp11_;
				gpointer _tmp12_;
				GeeHashMap* _tmp13_;
				GFile* _tmp14_;
				_tmp10_ = _f_it;
				if (!gee_iterator_next (_tmp10_)) {
					break;
				}
				_tmp11_ = _f_it;
				_tmp12_ = gee_iterator_get (_tmp11_);
				f = (GFile*) _tmp12_;
				_tmp13_ = self->priv->development_file_map;
				_tmp14_ = f;
				gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp14_, NULL);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		_tmp15_ = self->priv->reverse_development_file_map;
		_tmp16_ = photo;
		gee_multi_map_remove_all (_tmp15_, _tmp16_);
	}
	_tmp17_ = photo;
	_tmp18_ = photo_get_raw_developer_files (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_PHOTO, Photo));
	raw_list = _tmp18_;
	_tmp19_ = raw_list;
	if (_tmp19_ != NULL) {
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp20_;
			GeeIterator* _tmp21_;
			_tmp20_ = raw_list;
			_tmp21_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ITERABLE, GeeIterable));
			_f_it = _tmp21_;
			while (TRUE) {
				GeeIterator* _tmp22_;
				GFile* f = NULL;
				GeeIterator* _tmp23_;
				gpointer _tmp24_;
				GeeHashMap* _tmp25_;
				GFile* _tmp26_;
				LibraryPhoto* _tmp27_;
				GeeMultiMap* _tmp28_;
				LibraryPhoto* _tmp29_;
				GFile* _tmp30_;
				_tmp22_ = _f_it;
				if (!gee_iterator_next (_tmp22_)) {
					break;
				}
				_tmp23_ = _f_it;
				_tmp24_ = gee_iterator_get (_tmp23_);
				f = (GFile*) _tmp24_;
				_tmp25_ = self->priv->development_file_map;
				_tmp26_ = f;
				_tmp27_ = photo;
				gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp26_, _tmp27_);
				_tmp28_ = self->priv->reverse_development_file_map;
				_tmp29_ = photo;
				_tmp30_ = f;
				gee_multi_map_set (_tmp28_, _tmp29_, _tmp30_);
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
	}
	_g_object_unref0 (raw_list);
	_g_object_unref0 (photo);
}

static void
library_photo_source_holding_tank_class_init (LibraryPhotoSourceHoldingTankClass * klass,
                                              gpointer klass_data)
{
	library_photo_source_holding_tank_parent_class = g_type_class_peek_parent (klass);
	((SourceHoldingTankClass *) klass)->finalize = library_photo_source_holding_tank_finalize;
	g_type_class_adjust_private_offset (klass, &LibraryPhotoSourceHoldingTank_private_offset);
	((SourceHoldingTankClass *) klass)->notify_contents_altered = (void (*) (SourceHoldingTank*, GeeCollection*, GeeCollection*)) library_photo_source_holding_tank_real_notify_contents_altered;
}

static void
library_photo_source_holding_tank_instance_init (LibraryPhotoSourceHoldingTank * self,
                                                 gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMultiMap* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	self->priv = library_photo_source_holding_tank_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->editable_file_map = _tmp0_;
	_tmp1_ = gee_hash_map_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->development_file_map = _tmp1_;
	_tmp2_ = gee_hash_multi_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->reverse_editable_file_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	_tmp3_ = gee_hash_multi_map_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
	self->priv->reverse_development_file_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
}

static void
library_photo_source_holding_tank_finalize (SourceHoldingTank * obj)
{
	LibraryPhotoSourceHoldingTank * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_LIBRARY_PHOTO_SOURCE_HOLDING_TANK, LibraryPhotoSourceHoldingTank);
	_g_object_unref0 (self->priv->editable_file_map);
	_g_object_unref0 (self->priv->development_file_map);
	_g_object_unref0 (self->priv->reverse_editable_file_map);
	_g_object_unref0 (self->priv->reverse_development_file_map);
	SOURCE_HOLDING_TANK_CLASS (library_photo_source_holding_tank_parent_class)->finalize (obj);
}

static GType
library_photo_source_holding_tank_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (LibraryPhotoSourceHoldingTankClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) library_photo_source_holding_tank_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LibraryPhotoSourceHoldingTank), 0, (GInstanceInitFunc) library_photo_source_holding_tank_instance_init, NULL };
	GType library_photo_source_holding_tank_type_id;
	library_photo_source_holding_tank_type_id = g_type_register_static (TYPE_MEDIA_SOURCE_HOLDING_TANK, "LibraryPhotoSourceHoldingTank", &g_define_type_info, 0);
	LibraryPhotoSourceHoldingTank_private_offset = g_type_add_instance_private (library_photo_source_holding_tank_type_id