/* server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_drsuapi.h"
#include <util/debug.h>

NTSTATUS dcerpc_server_drsuapi_init(TALLOC_CTX *);

/* drsuapi - dcerpc server boilerplate generated by pidl */


static NTSTATUS drsuapi__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_DRSUAPI_BIND
	return DCESRV_INTERFACE_DRSUAPI_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void drsuapi__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_DRSUAPI_UNBIND
	DCESRV_INTERFACE_DRSUAPI_UNBIND(context, iface);
#else
	return;
#endif
}

static NTSTATUS drsuapi__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_drsuapi.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx,
			  ndr_table_drsuapi.calls[opnum].struct_size,
			  "struct %s",
			  ndr_table_drsuapi.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

        /* unravel the NDR for the packet */
	ndr_err = ndr_table_drsuapi.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS drsuapi__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct drsuapi_DsBind *r2 = (struct drsuapi_DsBind *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsBind, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsBind(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsBind will reply async\n"));
		}
		break;
	}
	case 1: {
		struct drsuapi_DsUnbind *r2 = (struct drsuapi_DsUnbind *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsUnbind, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsUnbind(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsUnbind will reply async\n"));
		}
		break;
	}
	case 2: {
		struct drsuapi_DsReplicaSync *r2 = (struct drsuapi_DsReplicaSync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaSync, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsReplicaSync(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaSync will reply async\n"));
		}
		break;
	}
	case 3: {
		struct drsuapi_DsGetNCChanges *r2 = (struct drsuapi_DsGetNCChanges *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNCChanges, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsGetNCChanges(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetNCChanges will reply async\n"));
		}
		break;
	}
	case 4: {
		struct drsuapi_DsReplicaUpdateRefs *r2 = (struct drsuapi_DsReplicaUpdateRefs *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaUpdateRefs, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsReplicaUpdateRefs(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaUpdateRefs will reply async\n"));
		}
		break;
	}
	case 5: {
		struct drsuapi_DsReplicaAdd *r2 = (struct drsuapi_DsReplicaAdd *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaAdd, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsReplicaAdd(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaAdd will reply async\n"));
		}
		break;
	}
	case 6: {
		struct drsuapi_DsReplicaDel *r2 = (struct drsuapi_DsReplicaDel *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaDel, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsReplicaDel(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaDel will reply async\n"));
		}
		break;
	}
	case 7: {
		struct drsuapi_DsReplicaMod *r2 = (struct drsuapi_DsReplicaMod *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaMod, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsReplicaMod(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaMod will reply async\n"));
		}
		break;
	}
	case 8: {
		struct DRSUAPI_VERIFY_NAMES *r2 = (struct DRSUAPI_VERIFY_NAMES *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_VERIFY_NAMES, NDR_IN, r2);
		}
		r2->out.result = dcesrv_DRSUAPI_VERIFY_NAMES(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_VERIFY_NAMES will reply async\n"));
		}
		break;
	}
	case 9: {
		struct drsuapi_DsGetMemberships *r2 = (struct drsuapi_DsGetMemberships *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsGetMemberships(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetMemberships will reply async\n"));
		}
		break;
	}
	case 10: {
		struct DRSUAPI_INTER_DOMAIN_MOVE *r2 = (struct DRSUAPI_INTER_DOMAIN_MOVE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_INTER_DOMAIN_MOVE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_DRSUAPI_INTER_DOMAIN_MOVE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_INTER_DOMAIN_MOVE will reply async\n"));
		}
		break;
	}
	case 11: {
		struct drsuapi_DsGetNT4ChangeLog *r2 = (struct drsuapi_DsGetNT4ChangeLog *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNT4ChangeLog, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsGetNT4ChangeLog(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetNT4ChangeLog will reply async\n"));
		}
		break;
	}
	case 12: {
		struct drsuapi_DsCrackNames *r2 = (struct drsuapi_DsCrackNames *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsCrackNames, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsCrackNames(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsCrackNames will reply async\n"));
		}
		break;
	}
	case 13: {
		struct drsuapi_DsWriteAccountSpn *r2 = (struct drsuapi_DsWriteAccountSpn *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsWriteAccountSpn, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsWriteAccountSpn(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsWriteAccountSpn will reply async\n"));
		}
		break;
	}
	case 14: {
		struct drsuapi_DsRemoveDSServer *r2 = (struct drsuapi_DsRemoveDSServer *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsRemoveDSServer, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsRemoveDSServer(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsRemoveDSServer will reply async\n"));
		}
		break;
	}
	case 15: {
		struct DRSUAPI_REMOVE_DS_DOMAIN *r2 = (struct DRSUAPI_REMOVE_DS_DOMAIN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REMOVE_DS_DOMAIN, NDR_IN, r2);
		}
		r2->out.result = dcesrv_DRSUAPI_REMOVE_DS_DOMAIN(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_REMOVE_DS_DOMAIN will reply async\n"));
		}
		break;
	}
	case 16: {
		struct drsuapi_DsGetDomainControllerInfo *r2 = (struct drsuapi_DsGetDomainControllerInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetDomainControllerInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsGetDomainControllerInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetDomainControllerInfo will reply async\n"));
		}
		break;
	}
	case 17: {
		struct drsuapi_DsAddEntry *r2 = (struct drsuapi_DsAddEntry *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsAddEntry, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsAddEntry(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsAddEntry will reply async\n"));
		}
		break;
	}
	case 18: {
		struct drsuapi_DsExecuteKCC *r2 = (struct drsuapi_DsExecuteKCC *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsExecuteKCC, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsExecuteKCC(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsExecuteKCC will reply async\n"));
		}
		break;
	}
	case 19: {
		struct drsuapi_DsReplicaGetInfo *r2 = (struct drsuapi_DsReplicaGetInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaGetInfo, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsReplicaGetInfo(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaGetInfo will reply async\n"));
		}
		break;
	}
	case 20: {
		struct DRSUAPI_ADD_SID_HISTORY *r2 = (struct DRSUAPI_ADD_SID_HISTORY *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_ADD_SID_HISTORY, NDR_IN, r2);
		}
		r2->out.result = dcesrv_DRSUAPI_ADD_SID_HISTORY(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_ADD_SID_HISTORY will reply async\n"));
		}
		break;
	}
	case 21: {
		struct drsuapi_DsGetMemberships2 *r2 = (struct drsuapi_DsGetMemberships2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships2, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_DsGetMemberships2(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetMemberships2 will reply async\n"));
		}
		break;
	}
	case 22: {
		struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r2 = (struct DRSUAPI_REPLICA_VERIFY_OBJECTS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REPLICA_VERIFY_OBJECTS, NDR_IN, r2);
		}
		r2->out.result = dcesrv_DRSUAPI_REPLICA_VERIFY_OBJECTS(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_REPLICA_VERIFY_OBJECTS will reply async\n"));
		}
		break;
	}
	case 23: {
		struct DRSUAPI_GET_OBJECT_EXISTENCE *r2 = (struct DRSUAPI_GET_OBJECT_EXISTENCE *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_GET_OBJECT_EXISTENCE, NDR_IN, r2);
		}
		r2->out.result = dcesrv_DRSUAPI_GET_OBJECT_EXISTENCE(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_GET_OBJECT_EXISTENCE will reply async\n"));
		}
		break;
	}
	case 24: {
		struct drsuapi_QuerySitesByCost *r2 = (struct drsuapi_QuerySitesByCost *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_QuerySitesByCost, NDR_IN, r2);
		}
		r2->out.result = dcesrv_drsuapi_QuerySitesByCost(dce_call, mem_ctx, r2);
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_QuerySitesByCost will reply async\n"));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS drsuapi__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: {
		struct drsuapi_DsBind *r2 = (struct drsuapi_DsBind *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsBind replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsBind, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsBind\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 1: {
		struct drsuapi_DsUnbind *r2 = (struct drsuapi_DsUnbind *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsUnbind replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsUnbind, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsUnbind\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 2: {
		struct drsuapi_DsReplicaSync *r2 = (struct drsuapi_DsReplicaSync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaSync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaSync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsReplicaSync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 3: {
		struct drsuapi_DsGetNCChanges *r2 = (struct drsuapi_DsGetNCChanges *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetNCChanges replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNCChanges, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsGetNCChanges\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 4: {
		struct drsuapi_DsReplicaUpdateRefs *r2 = (struct drsuapi_DsReplicaUpdateRefs *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaUpdateRefs replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaUpdateRefs, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsReplicaUpdateRefs\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 5: {
		struct drsuapi_DsReplicaAdd *r2 = (struct drsuapi_DsReplicaAdd *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaAdd replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaAdd, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsReplicaAdd\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 6: {
		struct drsuapi_DsReplicaDel *r2 = (struct drsuapi_DsReplicaDel *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaDel replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaDel, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsReplicaDel\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 7: {
		struct drsuapi_DsReplicaMod *r2 = (struct drsuapi_DsReplicaMod *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaMod replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaMod, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsReplicaMod\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 8: {
		struct DRSUAPI_VERIFY_NAMES *r2 = (struct DRSUAPI_VERIFY_NAMES *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_VERIFY_NAMES replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_VERIFY_NAMES, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in DRSUAPI_VERIFY_NAMES\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 9: {
		struct drsuapi_DsGetMemberships *r2 = (struct drsuapi_DsGetMemberships *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetMemberships replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsGetMemberships\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 10: {
		struct DRSUAPI_INTER_DOMAIN_MOVE *r2 = (struct DRSUAPI_INTER_DOMAIN_MOVE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_INTER_DOMAIN_MOVE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_INTER_DOMAIN_MOVE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in DRSUAPI_INTER_DOMAIN_MOVE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 11: {
		struct drsuapi_DsGetNT4ChangeLog *r2 = (struct drsuapi_DsGetNT4ChangeLog *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetNT4ChangeLog replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetNT4ChangeLog, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsGetNT4ChangeLog\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 12: {
		struct drsuapi_DsCrackNames *r2 = (struct drsuapi_DsCrackNames *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsCrackNames replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsCrackNames, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsCrackNames\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 13: {
		struct drsuapi_DsWriteAccountSpn *r2 = (struct drsuapi_DsWriteAccountSpn *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsWriteAccountSpn replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsWriteAccountSpn, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsWriteAccountSpn\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 14: {
		struct drsuapi_DsRemoveDSServer *r2 = (struct drsuapi_DsRemoveDSServer *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsRemoveDSServer replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsRemoveDSServer, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsRemoveDSServer\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 15: {
		struct DRSUAPI_REMOVE_DS_DOMAIN *r2 = (struct DRSUAPI_REMOVE_DS_DOMAIN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_REMOVE_DS_DOMAIN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REMOVE_DS_DOMAIN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in DRSUAPI_REMOVE_DS_DOMAIN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 16: {
		struct drsuapi_DsGetDomainControllerInfo *r2 = (struct drsuapi_DsGetDomainControllerInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetDomainControllerInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetDomainControllerInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsGetDomainControllerInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 17: {
		struct drsuapi_DsAddEntry *r2 = (struct drsuapi_DsAddEntry *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsAddEntry replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsAddEntry, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsAddEntry\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 18: {
		struct drsuapi_DsExecuteKCC *r2 = (struct drsuapi_DsExecuteKCC *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsExecuteKCC replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsExecuteKCC, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsExecuteKCC\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 19: {
		struct drsuapi_DsReplicaGetInfo *r2 = (struct drsuapi_DsReplicaGetInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsReplicaGetInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsReplicaGetInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsReplicaGetInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 20: {
		struct DRSUAPI_ADD_SID_HISTORY *r2 = (struct DRSUAPI_ADD_SID_HISTORY *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_ADD_SID_HISTORY replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_ADD_SID_HISTORY, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in DRSUAPI_ADD_SID_HISTORY\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 21: {
		struct drsuapi_DsGetMemberships2 *r2 = (struct drsuapi_DsGetMemberships2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_DsGetMemberships2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_DsGetMemberships2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_DsGetMemberships2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 22: {
		struct DRSUAPI_REPLICA_VERIFY_OBJECTS *r2 = (struct DRSUAPI_REPLICA_VERIFY_OBJECTS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_REPLICA_VERIFY_OBJECTS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_REPLICA_VERIFY_OBJECTS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in DRSUAPI_REPLICA_VERIFY_OBJECTS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 23: {
		struct DRSUAPI_GET_OBJECT_EXISTENCE *r2 = (struct DRSUAPI_GET_OBJECT_EXISTENCE *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function DRSUAPI_GET_OBJECT_EXISTENCE replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(DRSUAPI_GET_OBJECT_EXISTENCE, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in DRSUAPI_GET_OBJECT_EXISTENCE\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}
	case 24: {
		struct drsuapi_QuerySitesByCost *r2 = (struct drsuapi_QuerySitesByCost *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function drsuapi_QuerySitesByCost replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(drsuapi_QuerySitesByCost, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DEBUG(2,("dcerpc_fault %s in drsuapi_QuerySitesByCost\n", dcerpc_errstr(mem_ctx, dce_call->fault_code)));
		}
		break;
	}

	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS drsuapi__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_drsuapi.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static const struct dcesrv_interface dcesrv_drsuapi_interface = {
	.name		    = "drsuapi",
	.syntax_id          = {{0xe3514235,0x4b06,0x11d1,{0xab,0x04},{0x00,0xc0,0x4f,0xc2,0xdc,0xd2}},4.0},
	.bind		    = drsuapi__op_bind,
	.unbind		    = drsuapi__op_unbind,
	.ndr_pull	    = drsuapi__op_ndr_pull,
	.dispatch	    = drsuapi__op_dispatch,
	.reply		    = drsuapi__op_reply,
	.ndr_push	    = drsuapi__op_ndr_push,
	.local		    = NULL,
#ifdef DCESRV_INTERFACE_DRSUAPI_FLAGS
	.flags              = DCESRV_INTERFACE_DRSUAPI_FLAGS
#else
	.flags              = 0
#endif
};


static NTSTATUS drsuapi__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	int i;
#ifdef DCESRV_INTERFACE_DRSUAPI_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint =
		DCESRV_INTERFACE_DRSUAPI_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_drsuapi.endpoints->count;i++) {
		NTSTATUS ret;
		const char *name = ndr_table_drsuapi.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx,
						name,
						ncacn_np_secondary_endpoint,
						&dcesrv_drsuapi_interface,
						NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DEBUG(1,("drsuapi_op_init_server: failed to register endpoint '%s'\n",name));
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS drsuapi__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool drsuapi__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_drsuapi_interface.syntax_id.if_version == if_version &&
		GUID_equal(&dcesrv_drsuapi_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_drsuapi_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool drsuapi__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_drsuapi_interface.name, name)==0) {
		memcpy(iface, &dcesrv_drsuapi_interface, sizeof(*iface));
		return true;
	}

	return false;
}

NTSTATUS dcerpc_server_drsuapi_init(TALLOC_CTX *ctx)
{
	NTSTATUS ret;
	static const struct dcesrv_endpoint_server ep_server = {
	    /* fill in our name */
	    .name = "drsuapi",

	    /* Initialization flag */
	    .initialized = false,

	    /* fill in all the operations */
#ifdef DCESRV_INTERFACE_DRSUAPI_INIT_SERVER
	    .init_server = DCESRV_INTERFACE_DRSUAPI_INIT_SERVER,
#else
	    .init_server = drsuapi__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_DRSUAPI_SHUTDOWN_SERVER
	    .shutdown_server = DCESRV_INTERFACE_DRSUAPI_SHUTDOWN_SERVER,
#else
	    .shutdown_server = drsuapi__op_shutdown_server,
#endif
	    .interface_by_uuid = drsuapi__op_interface_by_uuid,
	    .interface_by_name = drsuapi__op_interface_by_name
	};
	/* register ourselves with the DCERPC subsystem. */
	ret = dcerpc_register_ep_server(&ep_server);

	if (!NT_STATUS_IS_OK(ret)) {
		DEBUG(0,("Failed to register 'drsuapi' endpoint server!\n"));
		return ret;
	}

	return ret;
}

