/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* AMDGPUPreLegalizerCombinerImpl Combiner Match Table                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct AMDGPUPreLegalizerCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 9:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "opy_prop", 8) != 0)
        break;
      return 13;	 // "copy_prop"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ors", 7) != 0)
          break;
        return 198;	 // "match_ors"
      case 'u':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "lo_by_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case '0':	 // 1 string to match.
          return 145;	 // "mulo_by_0"
        case '2':	 // 1 string to match.
          return 144;	 // "mulo_by_2"
        }
        break;
      }
      break;
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "neg_zext", 8) != 0)
        break;
      return 203;	 // "nneg_zext"
    }
    break;
  case 10:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2p_to_p2i", 9) != 0)
        break;
      return 89;	 // "i2p_to_p2i"
    case 'm':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_ands", 8) != 0)
          break;
        return 197;	 // "match_ands"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_to_shl", 8) != 0)
          break;
        return 14;	 // "mul_to_shl"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2i_to_i2p", 9) != 0)
        break;
      return 88;	 // "p2i_to_i2p"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_trunc", 8) != 0)
          break;
        return 201;	 // "sext_trunc"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_to_add", 8) != 0)
          break;
        return 15;	 // "sub_to_add"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc", 9) != 0)
        break;
      return 202;	 // "zext_trunc"
    }
    break;
  case 11:	 // 8 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_sub_reg", 10) != 0)
        break;
      return 94;	 // "add_sub_reg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_addos", 10) != 0)
        break;
      return 217;	 // "match_addos"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ub_add_reg", 10) != 0)
        break;
      return 192;	 // "sub_add_reg"
    case 't':	 // 4 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_", 5) != 0)
        break;
      switch (RuleIdentifier[6]) {
      default: break;
      case 's':	 // 3 strings to match.
        switch (RuleIdentifier[7]) {
        default: break;
        case 'h':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+8, "ift", 3) != 0)
            break;
          return 132;	 // "trunc_shift"
        case 's':	 // 2 strings to match.
          if (memcmp(RuleIdentifier.data()+8, "at", 2) != 0)
            break;
          switch (RuleIdentifier[10]) {
          default: break;
          case 's':	 // 1 string to match.
            return 219;	 // "trunc_ssats"
          case 'u':	 // 1 string to match.
            return 220;	 // "trunc_ssatu"
          }
          break;
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+7, "satu", 4) != 0)
          break;
        return 221;	 // "trunc_usatu"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_cst", 10) != 0)
        break;
      return 211;	 // "unmerge_cst"
    }
    break;
  case 12:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinusB", 11) != 0)
        break;
      return 2;	 // "APlusBMinusB"
    case 'B':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusAPlusA", 11) != 0)
        break;
      return 3;	 // "BMinusAPlusA"
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dde_to_addo", 11) != 0)
        break;
      return 146;	 // "adde_to_addo"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "sub_to_fneg", 11) != 0)
        break;
      return 194;	 // "fsub_to_fneg"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ulh_to_lshr", 11) != 0)
        break;
      return 174;	 // "mulh_to_lshr"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ot_cmp_fold", 11) != 0)
        break;
      return 133;	 // "not_cmp_fold"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_or", 11) != 0)
        break;
      return 128;	 // "redundant_or"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_pow2", 10) != 0)
          break;
        return 189;	 // "sdiv_by_pow2"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "xt_of_sext", 10) != 0)
          break;
        return 48;	 // "sext_of_sext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "div_by_pow2", 11) != 0)
        break;
      return 188;	 // "udiv_by_pow2"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_zext", 11) != 0)
        break;
      return 46;	 // "zext_of_zext"
    }
    break;
  case 13:	 // 16 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dd_of_vscale", 12) != 0)
        break;
      return 37;	 // "add_of_vscale"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_shift", 12) != 0)
        break;
      return 164;	 // "commute_shift"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oldable_fneg", 12) != 0)
        break;
      return 226;	 // "foldable_fneg"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_and_mask", 12) != 0)
        break;
      return 69;	 // "load_and_mask"
    case 'm':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "tch_selects", 11) != 0)
          break;
        return 125;	 // "match_selects"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "rge_unmerge", 11) != 0)
          break;
        return 210;	 // "merge_unmerge"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 38;	 // "mul_of_vscale"
      }
      break;
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_and", 12) != 0)
        break;
      return 126;	 // "redundant_and"
    case 's':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 191;	 // "sdiv_by_const"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "l_of_vscale", 11) != 0)
          break;
        return 39;	 // "shl_of_vscale"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 187;	 // "srem_by_const"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "b_of_vscale", 11) != 0)
          break;
        return 40;	 // "sub_of_vscale"
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "iv_by_const", 11) != 0)
          break;
        return 190;	 // "udiv_by_const"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "merge_", 6) != 0)
          break;
        switch (RuleIdentifier[8]) {
        default: break;
        case 'm':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "erge", 4) != 0)
            break;
          return 209;	 // "unmerge_merge"
        case 'u':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+9, "ndef", 4) != 0)
            break;
          return 212;	 // "unmerge_undef"
        }
        break;
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_by_const", 11) != 0)
          break;
        return 186;	 // "urem_by_const"
      }
      break;
    }
    break;
  case 14:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1PlusC2", 12) != 0)
          break;
        return 12;	 // "AMinusC1PlusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusC1MinusC2", 12) != 0)
          break;
        return 8;	 // "APlusC1MinusC2"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2MinusAPlusC1", 13) != 0)
        break;
      return 9;	 // "C2MinusAPlusC1"
    case 'a':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_", 9) != 0)
        break;
      switch (RuleIdentifier[10]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 52;	 // "anyext_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+11, "ext", 3) != 0)
          break;
        return 51;	 // "anyext_of_zext"
      }
      break;
    case 'b':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'i')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "op_same_val", 11) != 0)
          break;
        return 85;	 // "binop_same_val"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "reverse_shl", 11) != 0)
          break;
        return 162;	 // "bitreverse_shl"
      }
      break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "bs_fneg_fold", 12) != 0)
          break;
        return 173;	 // "fabs_fneg_fold"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "eg_fneg_fold", 12) != 0)
          break;
        return 91;	 // "fneg_fneg_fold"
      }
      break;
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ul_by_neg_one", 13) != 0)
        break;
      return 17;	 // "mul_by_neg_one"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eassoc_ptradd", 13) != 0)
        break;
      return 107;	 // "reassoc_ptradd"
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 2 strings to match.
        switch (RuleIdentifier[2]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "ect_of_zext", 11) != 0)
            break;
          return 54;	 // "select_of_zext"
        case 'x':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+3, "t_of_anyext", 11) != 0)
            break;
          return 49;	 // "sext_of_anyext"
        }
        break;
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ifts_too_big", 12) != 0)
          break;
        return 106;	 // "shifts_too_big"
      }
      break;
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_of_anyext", 13) != 0)
        break;
      return 47;	 // "zext_of_anyext"
    }
    break;
  case 15:	 // 12 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'M':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "inusC1MinusC2", 13) != 0)
          break;
        return 10;	 // "AMinusC1MinusC2"
      case 'P':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lusZeroMinusB", 13) != 0)
          break;
        return 1;	 // "APlusZeroMinusB"
      }
      break;
    case 'C':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "1Minus2MinusC2", 14) != 0)
        break;
      return 11;	 // "C1Minus2MinusC2"
    case 'Z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eroMinusAPlusB", 14) != 0)
        break;
      return 0;	 // "ZeroMinusAPlusB"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itreverse_lshr", 14) != 0)
        break;
      return 163;	 // "bitreverse_lshr"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtending_loads", 14) != 0)
        break;
      return 68;	 // "extending_loads"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "dempotent_prop", 14) != 0)
        break;
      return 18;	 // "idempotent_prop"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_or_combine", 14) != 0)
        break;
      return 153;	 // "load_or_combine"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_or", 14) != 0)
        break;
      return 62;	 // "narrow_binop_or"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "verlapping_and", 14) != 0)
        break;
      return 143;	 // "overlapping_and"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_same_val", 14) != 0)
        break;
      return 83;	 // "select_same_val"
    case 'z':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_trunc_fold", 14) != 0)
        break;
      return 130;	 // "zext_trunc_fold"
    }
    break;
  case 16:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_of_anyext", 15) != 0)
        break;
      return 50;	 // "anyext_of_anyext"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "lamp_i64_to_i16", 15) != 0)
        break;
      return 225;	 // "clamp_i64_to_i16"
    case 'n':	 // 5 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_", 12) != 0)
        break;
      switch (RuleIdentifier[13]) {
      default: break;
      case 'a':	 // 2 strings to match.
        switch (RuleIdentifier[14]) {
        default: break;
        case 'd':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 58;	 // "narrow_binop_add"
        case 'n':	 // 1 string to match.
          if (RuleIdentifier[15] != 'd')
            break;
          return 61;	 // "narrow_binop_and"
        }
        break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ul", 2) != 0)
          break;
        return 60;	 // "narrow_binop_mul"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "ub", 2) != 0)
          break;
        return 59;	 // "narrow_binop_sub"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+14, "or", 2) != 0)
          break;
        return 63;	 // "narrow_binop_xor"
      }
      break;
    case 's':	 // 3 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_", 6) != 0)
        break;
      switch (RuleIdentifier[7]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "f_anyext", 8) != 0)
          break;
        return 55;	 // "select_of_anyext"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "o_minmax", 8) != 0)
          break;
        return 193;	 // "select_to_minmax"
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+8, "ndef_cmp", 8) != 0)
          break;
        return 122;	 // "select_undef_cmp"
      }
      break;
    case 't':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_", 11) != 0)
        break;
      switch (RuleIdentifier[12]) {
      default: break;
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 44;	 // "truncate_of_sext"
      case 'z':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+13, "ext", 3) != 0)
          break;
        return 43;	 // "truncate_of_zext"
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ndef_to_fp_zero", 15) != 0)
        break;
      return 71;	 // "undef_to_fp_zero"
    }
    break;
  case 17:	 // 14 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "PlusBMinus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'A':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "plusC", 5) != 0)
          break;
        return 6;	 // "APlusBMinusAplusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "PlusA", 5) != 0)
          break;
        return 7;	 // "APlusBMinusCPlusA"
      }
      break;
    case 'a':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "d_p2i_to_ptradd", 15) != 0)
          break;
        return 16;	 // "add_p2i_to_ptradd"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "yext_trunc_fold", 15) != 0)
          break;
        return 90;	 // "anyext_trunc_fold"
      }
      break;
    case 'c':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'a':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nonicalize_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 111;	 // "canonicalize_fcmp"
        case 'i':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "cmp", 3) != 0)
            break;
          return 110;	 // "canonicalize_icmp"
        }
        break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "nstant_fold_fma", 15) != 0)
          break;
        return 171;	 // "constant_fold_fma"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "iv_rem_to_divrem", 16) != 0)
        break;
      return 154;	 // "div_rem_to_divrem"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "rase_undef_store", 16) != 0)
        break;
      return 81;	 // "erase_undef_store"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_with_zero", 16) != 0)
        break;
      return 150;	 // "ptr_add_with_zero"
    case 's':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_to_iminmax", 15) != 0)
          break;
        return 124;	 // "select_to_iminmax"
      case 'h':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ift_immed_chain", 15) != 0)
          break;
        return 151;	 // "shift_immed_chain"
      }
      break;
    case 'u':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "def_to_int_zero", 15) != 0)
          break;
        return 72;	 // "undef_to_int_zero"
      case 'r':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "em_pow2_to_mask", 15) != 0)
          break;
        return 129;	 // "urem_pow2_to_mask"
      }
      break;
    }
    break;
  case 18:	 // 11 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'A':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "MinusBPlus", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'B':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusC", 6) != 0)
          break;
        return 5;	 // "AMinusBPlusBMinusC"
      case 'C':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "MinusA", 6) != 0)
          break;
        return 4;	 // "AMinusBPlusCMinusA"
      }
      break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_to_zero", 17) != 0)
        break;
      return 86;	 // "binop_left_to_zero"
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_minmax_nan", 15) != 0)
          break;
        return 147;	 // "combine_minmax_nan"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_f", 12) != 0)
          break;
        switch (RuleIdentifier[15]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "bs", 2) != 0)
            break;
          return 136;	 // "constant_fold_fabs"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+16, "eg", 2) != 0)
            break;
          return 135;	 // "constant_fold_fneg"
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xpand_const_fpowi", 17) != 0)
        break;
      return 148;	 // "expand_const_fpowi"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ptrunc_fpext_fold", 17) != 0)
        break;
      return 99;	 // "fptrunc_fpext_fold"
    case 's':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'e')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'l':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ect_of_truncate", 15) != 0)
          break;
        return 56;	 // "select_of_truncate"
      case 'x':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "t_inreg_of_load", 15) != 0)
          break;
        return 119;	 // "sext_inreg_of_load"
      }
      break;
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcate_of_anyext", 17) != 0)
        break;
      return 45;	 // "truncate_of_anyext"
    }
    break;
  case 19:	 // 15 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_to_zero", 18) != 0)
        break;
      return 87;	 // "binop_right_to_zero"
    case 'c':	 // 4 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "onst", 4) != 0)
        break;
      switch (RuleIdentifier[5]) {
      default: break;
      case '_':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+6, "ptradd_to_i2p", 13) != 0)
          break;
        return 142;	 // "const_ptradd_to_i2p"
      case 'a':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+6, "nt_fold_", 8) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'b':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "inop", 4) != 0)
            break;
          return 169;	 // "constant_fold_binop"
        case 'f':	 // 2 strings to match.
          switch (RuleIdentifier[15]) {
          default: break;
          case 'l':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "og2", 3) != 0)
              break;
            return 138;	 // "constant_fold_flog2"
          case 's':	 // 1 string to match.
            if (memcmp(RuleIdentifier.data()+16, "qrt", 3) != 0)
              break;
            return 137;	 // "constant_fold_fsqrt"
          }
          break;
        }
        break;
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtend_through_phis", 18) != 0)
        break;
      return 103;	 // "extend_through_phis"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nteger_of_truncate", 18) != 0)
        break;
      return 64;	 // "integer_of_truncate"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_zero", 18) != 0)
        break;
      return 216;	 // "merge_of_x_and_zero"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "tr_add_immed_chain", 18) != 0)
        break;
      return 109;	 // "ptr_add_immed_chain"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "assoc_comm_binops", 17) != 0)
          break;
        return 108;	 // "reassoc_comm_binops"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_zero", 17) != 0)
          break;
        return 84;	 // "right_identity_zero"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "lect_constant_cmp", 17) != 0)
          break;
        return 123;	 // "select_constant_cmp"
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "mplify_", 7) != 0)
          break;
        switch (RuleIdentifier[9]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "dd_to_sub", 9) != 0)
            break;
          return 104;	 // "simplify_add_to_sub"
        case 'n':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+10, "eg_minmax", 9) != 0)
            break;
          return 199;	 // "simplify_neg_minmax"
        }
        break;
      }
      break;
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nary_undef_to_zero", 18) != 0)
        break;
      return 76;	 // "unary_undef_to_zero"
    }
    break;
  case 20:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nd_or_disjoint_mask", 19) != 0)
        break;
      return 176;	 // "and_or_disjoint_mask"
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itcast_bitcast_fold", 19) != 0)
        break;
      return 98;	 // "bitcast_bitcast_fold"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "erge_of_x_and_undef", 19) != 0)
        break;
      return 215;	 // "merge_of_x_and_undef"
    case 'r':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "edu", 3) != 0)
        break;
      switch (RuleIdentifier[4]) {
      default: break;
      case 'c':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "e_shl_of_extend", 15) != 0)
          break;
        return 120;	 // "reduce_shl_of_extend"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+5, "dant_sext_inreg", 15) != 0)
          break;
        return 127;	 // "redundant_sext_inreg"
      }
      break;
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ry_undef_to_undef", 17) != 0)
          break;
        return 77;	 // "unary_undef_to_undef"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_zext_to_zext", 17) != 0)
          break;
        return 214;	 // "unmerge_zext_to_zext"
      }
      break;
    }
    break;
  case 21:	 // 8 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 3 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_concat_vector", 18) != 0)
          break;
        return 200;	 // "combine_concat_vector"
      case 'n':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_", 11) != 0)
          break;
        switch (RuleIdentifier[14]) {
        default: break;
        case 'c':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ast_op", 6) != 0)
            break;
          return 172;	 // "constant_fold_cast_op"
        case 'f':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+15, "ptrunc", 6) != 0)
            break;
          return 139;	 // "constant_fold_fptrunc"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_vector_elt_oob", 20) != 0)
        break;
      return 24;	 // "insert_vector_elt_oob"
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "shr_of_trunc_of_lshr", 20) != 0)
        break;
      return 223;	 // "lshr_of_trunc_of_lshr"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_fp", 20) != 0)
        break;
      return 93;	 // "right_identity_one_fp"
    case 'u':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'n')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'd':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "ef_to_negative_one", 18) != 0)
          break;
        return 73;	 // "undef_to_negative_one"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "erge_dead_to_trunc", 18) != 0)
          break;
        return 213;	 // "unmerge_dead_to_trunc"
      }
      break;
    }
    break;
  case 22:	 // 13 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (RuleIdentifier[1] != 'o')
        break;
      switch (RuleIdentifier[2]) {
      default: break;
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "bine_shuffle_concat", 19) != 0)
          break;
        return 204;	 // "combine_shuffle_concat"
      case 'n':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+3, "stant_fold_fp_binop", 19) != 0)
          break;
        return 170;	 // "constant_fold_fp_binop"
      }
      break;
    case 'f':	 // 4 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ld_binop_into_select", 20) != 0)
          break;
        return 185;	 // "fold_binop_into_select"
      case 'u':	 // 3 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "nnel_shift_", 11) != 0)
          break;
        switch (RuleIdentifier[13]) {
        default: break;
        case 'l':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "eft_zero", 8) != 0)
            break;
          return 158;	 // "funnel_shift_left_zero"
        case 'o':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "vershift", 8) != 0)
            break;
          return 159;	 // "funnel_shift_overshift"
        case 't':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+14, "o_rotate", 8) != 0)
            break;
          return 156;	 // "funnel_shift_to_rotate"
        }
        break;
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_lhs_known_bits", 21) != 0)
        break;
      return 113;	 // "icmp_to_lhs_known_bits"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_subo_no_overflow", 21) != 0)
        break;
      return 218;	 // "match_subo_no_overflow"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_any_op", 21) != 0)
        break;
      return 78;	 // "propagate_undef_any_op"
    case 'r':	 // 2 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "dundant_neg_operands", 20) != 0)
          break;
        return 175;	 // "redundant_neg_operands"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ght_identity_one_int", 20) != 0)
          break;
        return 92;	 // "right_identity_one_int"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hl_ashr_to_sext_inreg", 21) != 0)
        break;
      return 117;	 // "shl_ashr_to_sext_inreg"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_buildvector_fold", 21) != 0)
        break;
      return 96;	 // "trunc_buildvector_fold"
    }
    break;
  case 23:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "uildvector_of_truncate", 22) != 0)
        break;
      return 57;	 // "buildvector_of_truncate"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_right_zero", 22) != 0)
        break;
      return 157;	 // "funnel_shift_right_zero"
    case 'i':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "tof_const_zero_fold_", 20) != 0)
        break;
      switch (RuleIdentifier[21]) {
      default: break;
      case 's':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 140;	 // "itof_const_zero_fold_si"
      case 'u':	 // 1 string to match.
        if (RuleIdentifier[22] != 'i')
          break;
        return 141;	 // "itof_const_zero_fold_ui"
      }
      break;
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_all_ops", 22) != 0)
        break;
      return 79;	 // "propagate_undef_all_ops"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runcusatu_to_fptouisat", 22) != 0)
        break;
      return 222;	 // "truncusatu_to_fptouisat"
    }
    break;
  case 24:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_undef_to_zero", 23) != 0)
        break;
      return 74;	 // "binop_left_undef_to_zero"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element", 23) != 0)
        break;
      return 23;	 // "match_extract_of_element"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "arrow_binop_feeding_and", 23) != 0)
        break;
      return 121;	 // "narrow_binop_feeding_and"
    case 's':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ext_inreg_", 10) != 0)
        break;
      switch (RuleIdentifier[11]) {
      default: break;
      case 'o':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "f_sext_inreg", 12) != 0)
          break;
        return 53;	 // "sext_inreg_of_sext_inreg"
      case 't':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+12, "o_zext_inreg", 12) != 0)
          break;
        return 131;	 // "sext_inreg_to_zext_inreg"
      }
      break;
    case 'x':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "or_of_and_with_same_reg", 23) != 0)
        break;
      return 149;	 // "xor_of_and_with_same_reg"
    }
    break;
  case 25:	 // 7 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 3 strings to match.
      switch (RuleIdentifier[1]) {
      default: break;
      case 'i':	 // 2 strings to match.
        if (memcmp(RuleIdentifier.data()+2, "tfield_extract_from_", 20) != 0)
          break;
        switch (RuleIdentifier[22]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "nd", 2) != 0)
            break;
          return 166;	 // "bitfield_extract_from_and"
        case 's':	 // 1 string to match.
          if (memcmp(RuleIdentifier.data()+23, "hr", 2) != 0)
            break;
          return 167;	 // "bitfield_extract_from_shr"
        }
        break;
      case 'u':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+2, "ildvector_identity_fold", 23) != 0)
          break;
        return 95;	 // "buildvector_identity_fold"
      }
      break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_shuffle_undef_rhs", 24) != 0)
        break;
      return 205;	 // "combine_shuffle_undef_rhs"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vec_elt_build_vec", 24) != 0)
        break;
      return 66;	 // "extract_vec_elt_build_vec"
    case 'n':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "eg_and_one_to_sext_inreg", 24) != 0)
        break;
      return 118;	 // "neg_and_one_to_sext_inreg"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_one_fp", 24) != 0)
        break;
      return 102;	 // "right_identity_neg_one_fp"
    }
    break;
  case 26:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_undef_to_undef", 25) != 0)
        break;
      return 75;	 // "binop_right_undef_to_undef"
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_fp_constant_to_rhs", 25) != 0)
        break;
      return 196;	 // "commute_fp_constant_to_rhs"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_from_or_shift", 25) != 0)
        break;
      return 155;	 // "funnel_shift_from_or_shift"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp", 25) != 0)
        break;
      return 100;	 // "right_identity_neg_zero_fp"
    }
    break;
  case 27:	 // 6 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "om", 2) != 0)
        break;
      switch (RuleIdentifier[3]) {
      default: break;
      case 'b':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ine_use_vector_truncate", 23) != 0)
          break;
        return 207;	 // "combine_use_vector_truncate"
      case 'm':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+4, "ute_int_constant_to_rhs", 23) != 0)
          break;
        return 195;	 // "commute_int_constant_to_rhs"
      }
      break;
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_or_combine", 26) != 0)
        break;
      return 115;	 // "double_icmp_zero_or_combine"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_binop_in_equality", 26) != 0)
        break;
      return 116;	 // "redundant_binop_in_equality"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_lshr_buildvector_fold", 26) != 0)
        break;
      return 97;	 // "trunc_lshr_buildvector_fold"
    case 'u':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nmerge_anyext_build_vector", 26) != 0)
        break;
      return 208;	 // "unmerge_anyext_build_vector"
    }
    break;
  case 28:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_or_s64_with_s32_mask", 27) != 0)
        break;
      return 228;	 // "combine_or_s64_with_s32_mask"
    case 'd':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ouble_icmp_zero_and_combine", 27) != 0)
        break;
      return 114;	 // "double_icmp_zero_and_combine"
    case 'o':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "pt_brcond_by_inverting_cond", 27) != 0)
        break;
      return 134;	 // "opt_brcond_by_inverting_cond"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ropagate_undef_shuffle_mask", 27) != 0)
        break;
      return 80;	 // "propagate_undef_shuffle_mask"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hift_of_shifted_logic_chain", 27) != 0)
        break;
      return 152;	 // "shift_of_shifted_logic_chain"
    }
    break;
  case 29:	 // 5 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_shr_and", 28) != 0)
        break;
      return 168;	 // "bitfield_extract_from_shr_and"
    case 'c':	 // 3 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "nd_s64_with_s32_mask", 20) != 0)
          break;
        return 229;	 // "combine_and_s64_with_s32_mask"
      case 'e':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "xtracted_vector_load", 20) != 0)
          break;
        return 70;	 // "combine_extracted_vector_load"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "huffle_disjoint_mask", 20) != 0)
          break;
        return 206;	 // "combine_shuffle_disjoint_mask"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "cmp_to_true_false_known_bits", 28) != 0)
        break;
      return 112;	 // "icmp_to_true_false_known_bits"
    }
    break;
  case 30:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "reeze_of_non_undef_non_poison", 29) != 0)
        break;
      return 41;	 // "freeze_of_non_undef_non_poison"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp_nsz", 29) != 0)
        break;
      return 101;	 // "right_identity_neg_zero_fp_nsz"
    }
    break;
  case 31:	 // 2 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_", 22) != 0)
      break;
    switch (RuleIdentifier[22]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "lt_undef", 8) != 0)
        break;
      return 22;	 // "insert_vector_element_elt_undef"
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+23, "dx_undef", 8) != 0)
        break;
      return 21;	 // "insert_vector_element_idx_undef"
    }
    break;
  case 32:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "itfield_extract_from_sext_inreg", 31) != 0)
        break;
      return 165;	 // "bitfield_extract_from_sext_inreg"
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_f", 8) != 0)
        break;
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 177;	 // "combine_fadd_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fmul_to_fmad_or_fma", 22) != 0)
          break;
        return 181;	 // "combine_fsub_fmul_to_fmad_or_fma"
      }
      break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_not_const", 31) != 0)
        break;
      return 25;	 // "extract_vector_element_not_const"
    }
    break;
  case 34:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fmul_with_select_to_fldexp", 33) != 0)
        break;
      return 224;	 // "combine_fmul_with_select_to_fldexp"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_all_elts_from_build_vector", 33) != 0)
        break;
      return 67;	 // "extract_all_elts_from_build_vector"
    }
    break;
  case 35:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_build_vector", 35) != 0)
      break;
    return 27;	 // "extract_vector_element_build_vector"
  case 36:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 2 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_", 7) != 0)
        break;
      switch (RuleIdentifier[8]) {
      default: break;
      case 'f':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "add_fma_fmul_to_fmad_or_fma", 27) != 0)
          break;
        return 179;	 // "combine_fadd_fma_fmul_to_fmad_or_fma"
      case 'i':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+9, "nsert_vec_elts_build_vector", 27) != 0)
          break;
        return 65;	 // "combine_insert_vec_elts_build_vector"
      }
      break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nsert_extract_vec_elt_out_of_bounds", 35) != 0)
        break;
      return 82;	 // "insert_extract_vec_elt_out_of_bounds"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_index", 35) != 0)
        break;
      return 20;	 // "match_extract_of_element_undef_index"
    }
    break;
  case 37:	 // 4 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fsub_fneg_fmul_to_fmad_or_fma", 36) != 0)
        break;
      return 182;	 // "combine_fsub_fneg_fmul_to_fmad_or_fma"
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_shuffle_vector", 36) != 0)
        break;
      return 35;	 // "extract_vector_element_shuffle_vector"
    case 'h':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oist_logic_op_with_same_opcode_hands", 36) != 0)
        break;
      return 105;	 // "hoist_logic_op_with_same_opcode_hands"
    case 'm':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "atch_extract_of_element_undef_vector", 36) != 0)
        break;
      return 19;	 // "match_extract_of_element_undef_vector"
    }
    break;
  case 38:	 // 3 strings to match.
    if (memcmp(RuleIdentifier.data()+0, "combine_", 8) != 0)
      break;
    switch (RuleIdentifier[8]) {
    default: break;
    case 'f':	 // 2 strings to match.
      switch (RuleIdentifier[9]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "dd_fpext_fmul_to_fmad_or_fma", 28) != 0)
          break;
        return 178;	 // "combine_fadd_fpext_fmul_to_fmad_or_fma"
      case 's':	 // 1 string to match.
        if (memcmp(RuleIdentifier.data()+10, "ub_fpext_fmul_to_fmad_or_fma", 28) != 0)
          break;
        return 183;	 // "combine_fsub_fpext_fmul_to_fmad_or_fma"
      }
      break;
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+9, "huffle_vector_to_build_vector", 29) != 0)
        break;
      return 227;	 // "combine_shuffle_vector_to_build_vector"
    }
    break;
  case 40:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "extract_vector_element_different_indices", 40) != 0)
      break;
    return 26;	 // "extract_vector_element_different_indices"
  case 42:	 // 9 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fadd_fpext_fma_fmul_to_fmad_or_fma", 41) != 0)
        break;
      return 180;	 // "combine_fadd_fpext_fma_fmul_to_fmad_or_fma"
    case 'e':	 // 7 strings to match.
      if (memcmp(RuleIdentifier.data()+1, "xtract_vector_element_build_vector_trunc", 40) != 0)
        break;
      switch (RuleIdentifier[41]) {
      default: break;
      case '2':	 // 1 string to match.
        return 28;	 // "extract_vector_element_build_vector_trunc2"
      case '3':	 // 1 string to match.
        return 29;	 // "extract_vector_element_build_vector_trunc3"
      case '4':	 // 1 string to match.
        return 30;	 // "extract_vector_element_build_vector_trunc4"
      case '5':	 // 1 string to match.
        return 31;	 // "extract_vector_element_build_vector_trunc5"
      case '6':	 // 1 string to match.
        return 32;	 // "extract_vector_element_build_vector_trunc6"
      case '7':	 // 1 string to match.
        return 33;	 // "extract_vector_element_build_vector_trunc7"
      case '8':	 // 1 string to match.
        return 34;	 // "extract_vector_element_build_vector_trunc8"
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_or_shift_to_funnel_shift_left", 41) != 0)
        break;
      return 160;	 // "funnel_shift_or_shift_to_funnel_shift_left"
    }
    break;
  case 43:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ombine_fsub_fpext_fneg_fmul_to_fmad_or_fma", 42) != 0)
        break;
      return 184;	 // "combine_fsub_fpext_fneg_fmul_to_fmad_or_fma"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "unnel_shift_or_shift_to_funnel_shift_right", 42) != 0)
        break;
      return 161;	 // "funnel_shift_or_shift_to_funnel_shift_right"
    }
    break;
  case 44:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "insert_vector_element_extract_vector_element", 44) != 0)
      break;
    return 36;	 // "insert_vector_element_extract_vector_element"
  case 46:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "push_freeze_to_prevent_poison_from_propagating", 46) != 0)
      break;
    return 42;	 // "push_freeze_to_prevent_poison_from_propagating"
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 230}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool AMDGPUPreLegalizerCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool AMDGPUPreLegalizerCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> AMDGPUPreLegalizerCombinerOption;
static cl::list<std::string> AMDGPUPreLegalizerCombinerDisableOption(
    "amdgpuprelegalizercombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the AMDGPUPreLegalizerCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      AMDGPUPreLegalizerCombinerOption.push_back(Str);
    }));
static cl::list<std::string> AMDGPUPreLegalizerCombinerOnlyEnableOption(
    "amdgpuprelegalizercombiner-only-enable-rule",
    cl::desc("Disable all rules in the AMDGPUPreLegalizerCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      AMDGPUPreLegalizerCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        AMDGPUPreLegalizerCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool AMDGPUPreLegalizerCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool AMDGPUPreLegalizerCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : AMDGPUPreLegalizerCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUPreLegalizerCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUPreLegalizerCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUPreLegalizerCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUPreLegalizerCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s32,
  GILLT_s64,
};
const static size_t NumTypeObjects = 2;
const static LLT TypeObjects[] = {
  LLT::scalar(32),
  LLT::scalar(64),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset AMDGPUPreLegalizerCombinerImpl::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void AMDGPUPreLegalizerCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUPreLegalizerCombinerImpl::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

AMDGPUPreLegalizerCombinerImpl::ComplexMatcherMemFn
AMDGPUPreLegalizerCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
  GICXXPred_MI_Predicate_GICombiner3,
  GICXXPred_MI_Predicate_GICombiner4,
  GICXXPred_MI_Predicate_GICombiner5,
  GICXXPred_MI_Predicate_GICombiner6,
  GICXXPred_MI_Predicate_GICombiner7,
  GICXXPred_MI_Predicate_GICombiner8,
  GICXXPred_MI_Predicate_GICombiner9,
  GICXXPred_MI_Predicate_GICombiner10,
  GICXXPred_MI_Predicate_GICombiner11,
  GICXXPred_MI_Predicate_GICombiner12,
  GICXXPred_MI_Predicate_GICombiner13,
};
bool AMDGPUPreLegalizerCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return isGuaranteedNotToBeUndefOrPoison(State.MIs[0]->getOperand(1).getReg(), MRI);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner3: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner4: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner5: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner6: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_EQ &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner7: {
    return State.MIs[1]->getOperand(1).getPredicate() == CmpInst::ICMP_NE &&
                               !MRI.getType(State.MIs[1]->getOperand(2).getReg()).getScalarType().isPointer() &&
                               (MRI.getType(State.MIs[1]->getOperand(2).getReg()) ==
                                   MRI.getType(State.MIs[2]->getOperand(2).getReg()));
  }
  case GICXXPred_MI_Predicate_GICombiner8: {
    return MRI.hasOneNonDBGUse(State.MIs[0]->getOperand(2).getReg()) &&
                    Helper.isLegalOrBeforeLegalizer(
                      {TargetOpcode::G_SEXT_INREG, {MRI.getType(State.MIs[1]->getOperand(1).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner9: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_LSHR,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner10: {
    return Helper.isLegalOrBeforeLegalizer({TargetOpcode::G_SHL,
                                                           {MRI.getType(State.MIs[2]->getOperand(1).getReg()),
                                                            MRI.getType(State.MIs[1]->getOperand(2).getReg())}});
  }
  case GICXXPred_MI_Predicate_GICombiner11: {
    return Helper.matchTruncUSatU(*State.MIs[0], *State.MIs[1]);
  }
  case GICXXPred_MI_Predicate_GICombiner12: {
    return Helper.matchTruncUSatUToFPTOUISat(*State.MIs[0], *State.MIs[1]);
  }
  case GICXXPred_MI_Predicate_GICombiner13: {
    return Helper.matchConstantIs32BitMask(State.MIs[0]->getOperand(1).getReg()) ||
                           Helper.matchConstantIs32BitMask(State.MIs[0]->getOperand(2).getReg());
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUPreLegalizerCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
  GICXXPred_Simple_IsRule24Enabled,
  GICXXPred_Simple_IsRule25Enabled,
  GICXXPred_Simple_IsRule26Enabled,
  GICXXPred_Simple_IsRule27Enabled,
  GICXXPred_Simple_IsRule28Enabled,
  GICXXPred_Simple_IsRule29Enabled,
  GICXXPred_Simple_IsRule30Enabled,
  GICXXPred_Simple_IsRule31Enabled,
  GICXXPred_Simple_IsRule32Enabled,
  GICXXPred_Simple_IsRule33Enabled,
  GICXXPred_Simple_IsRule34Enabled,
  GICXXPred_Simple_IsRule35Enabled,
  GICXXPred_Simple_IsRule36Enabled,
  GICXXPred_Simple_IsRule37Enabled,
  GICXXPred_Simple_IsRule38Enabled,
  GICXXPred_Simple_IsRule39Enabled,
  GICXXPred_Simple_IsRule40Enabled,
  GICXXPred_Simple_IsRule41Enabled,
  GICXXPred_Simple_IsRule42Enabled,
  GICXXPred_Simple_IsRule43Enabled,
  GICXXPred_Simple_IsRule44Enabled,
  GICXXPred_Simple_IsRule45Enabled,
  GICXXPred_Simple_IsRule46Enabled,
  GICXXPred_Simple_IsRule47Enabled,
  GICXXPred_Simple_IsRule48Enabled,
  GICXXPred_Simple_IsRule49Enabled,
  GICXXPred_Simple_IsRule50Enabled,
  GICXXPred_Simple_IsRule51Enabled,
  GICXXPred_Simple_IsRule52Enabled,
  GICXXPred_Simple_IsRule53Enabled,
  GICXXPred_Simple_IsRule54Enabled,
  GICXXPred_Simple_IsRule55Enabled,
  GICXXPred_Simple_IsRule56Enabled,
  GICXXPred_Simple_IsRule57Enabled,
  GICXXPred_Simple_IsRule58Enabled,
  GICXXPred_Simple_IsRule59Enabled,
  GICXXPred_Simple_IsRule60Enabled,
  GICXXPred_Simple_IsRule61Enabled,
  GICXXPred_Simple_IsRule62Enabled,
  GICXXPred_Simple_IsRule63Enabled,
  GICXXPred_Simple_IsRule64Enabled,
  GICXXPred_Simple_IsRule65Enabled,
  GICXXPred_Simple_IsRule66Enabled,
  GICXXPred_Simple_IsRule67Enabled,
  GICXXPred_Simple_IsRule68Enabled,
  GICXXPred_Simple_IsRule69Enabled,
  GICXXPred_Simple_IsRule70Enabled,
  GICXXPred_Simple_IsRule71Enabled,
  GICXXPred_Simple_IsRule72Enabled,
  GICXXPred_Simple_IsRule73Enabled,
  GICXXPred_Simple_IsRule74Enabled,
  GICXXPred_Simple_IsRule75Enabled,
  GICXXPred_Simple_IsRule76Enabled,
  GICXXPred_Simple_IsRule77Enabled,
  GICXXPred_Simple_IsRule78Enabled,
  GICXXPred_Simple_IsRule79Enabled,
  GICXXPred_Simple_IsRule80Enabled,
  GICXXPred_Simple_IsRule81Enabled,
  GICXXPred_Simple_IsRule82Enabled,
  GICXXPred_Simple_IsRule83Enabled,
  GICXXPred_Simple_IsRule84Enabled,
  GICXXPred_Simple_IsRule85Enabled,
  GICXXPred_Simple_IsRule86Enabled,
  GICXXPred_Simple_IsRule87Enabled,
  GICXXPred_Simple_IsRule88Enabled,
  GICXXPred_Simple_IsRule89Enabled,
  GICXXPred_Simple_IsRule90Enabled,
  GICXXPred_Simple_IsRule91Enabled,
  GICXXPred_Simple_IsRule92Enabled,
  GICXXPred_Simple_IsRule93Enabled,
  GICXXPred_Simple_IsRule94Enabled,
  GICXXPred_Simple_IsRule95Enabled,
  GICXXPred_Simple_IsRule96Enabled,
  GICXXPred_Simple_IsRule97Enabled,
  GICXXPred_Simple_IsRule98Enabled,
  GICXXPred_Simple_IsRule99Enabled,
  GICXXPred_Simple_IsRule100Enabled,
  GICXXPred_Simple_IsRule101Enabled,
  GICXXPred_Simple_IsRule102Enabled,
  GICXXPred_Simple_IsRule103Enabled,
  GICXXPred_Simple_IsRule104Enabled,
  GICXXPred_Simple_IsRule105Enabled,
  GICXXPred_Simple_IsRule106Enabled,
  GICXXPred_Simple_IsRule107Enabled,
  GICXXPred_Simple_IsRule108Enabled,
  GICXXPred_Simple_IsRule109Enabled,
  GICXXPred_Simple_IsRule110Enabled,
  GICXXPred_Simple_IsRule111Enabled,
  GICXXPred_Simple_IsRule112Enabled,
  GICXXPred_Simple_IsRule113Enabled,
  GICXXPred_Simple_IsRule114Enabled,
  GICXXPred_Simple_IsRule115Enabled,
  GICXXPred_Simple_IsRule116Enabled,
  GICXXPred_Simple_IsRule117Enabled,
  GICXXPred_Simple_IsRule118Enabled,
  GICXXPred_Simple_IsRule119Enabled,
  GICXXPred_Simple_IsRule120Enabled,
  GICXXPred_Simple_IsRule121Enabled,
  GICXXPred_Simple_IsRule122Enabled,
  GICXXPred_Simple_IsRule123Enabled,
  GICXXPred_Simple_IsRule124Enabled,
  GICXXPred_Simple_IsRule125Enabled,
  GICXXPred_Simple_IsRule126Enabled,
  GICXXPred_Simple_IsRule127Enabled,
  GICXXPred_Simple_IsRule128Enabled,
  GICXXPred_Simple_IsRule129Enabled,
  GICXXPred_Simple_IsRule130Enabled,
  GICXXPred_Simple_IsRule131Enabled,
  GICXXPred_Simple_IsRule132Enabled,
  GICXXPred_Simple_IsRule133Enabled,
  GICXXPred_Simple_IsRule134Enabled,
  GICXXPred_Simple_IsRule135Enabled,
  GICXXPred_Simple_IsRule136Enabled,
  GICXXPred_Simple_IsRule137Enabled,
  GICXXPred_Simple_IsRule138Enabled,
  GICXXPred_Simple_IsRule139Enabled,
  GICXXPred_Simple_IsRule140Enabled,
  GICXXPred_Simple_IsRule141Enabled,
  GICXXPred_Simple_IsRule142Enabled,
  GICXXPred_Simple_IsRule143Enabled,
  GICXXPred_Simple_IsRule144Enabled,
  GICXXPred_Simple_IsRule145Enabled,
  GICXXPred_Simple_IsRule146Enabled,
  GICXXPred_Simple_IsRule147Enabled,
  GICXXPred_Simple_IsRule148Enabled,
  GICXXPred_Simple_IsRule149Enabled,
  GICXXPred_Simple_IsRule150Enabled,
  GICXXPred_Simple_IsRule151Enabled,
  GICXXPred_Simple_IsRule152Enabled,
  GICXXPred_Simple_IsRule153Enabled,
  GICXXPred_Simple_IsRule154Enabled,
  GICXXPred_Simple_IsRule155Enabled,
  GICXXPred_Simple_IsRule156Enabled,
  GICXXPred_Simple_IsRule157Enabled,
  GICXXPred_Simple_IsRule158Enabled,
  GICXXPred_Simple_IsRule159Enabled,
  GICXXPred_Simple_IsRule160Enabled,
  GICXXPred_Simple_IsRule161Enabled,
  GICXXPred_Simple_IsRule162Enabled,
  GICXXPred_Simple_IsRule163Enabled,
  GICXXPred_Simple_IsRule164Enabled,
  GICXXPred_Simple_IsRule165Enabled,
  GICXXPred_Simple_IsRule166Enabled,
  GICXXPred_Simple_IsRule167Enabled,
  GICXXPred_Simple_IsRule168Enabled,
  GICXXPred_Simple_IsRule169Enabled,
  GICXXPred_Simple_IsRule170Enabled,
  GICXXPred_Simple_IsRule171Enabled,
  GICXXPred_Simple_IsRule172Enabled,
  GICXXPred_Simple_IsRule173Enabled,
  GICXXPred_Simple_IsRule174Enabled,
  GICXXPred_Simple_IsRule175Enabled,
  GICXXPred_Simple_IsRule176Enabled,
  GICXXPred_Simple_IsRule177Enabled,
  GICXXPred_Simple_IsRule178Enabled,
  GICXXPred_Simple_IsRule179Enabled,
  GICXXPred_Simple_IsRule180Enabled,
  GICXXPred_Simple_IsRule181Enabled,
  GICXXPred_Simple_IsRule182Enabled,
  GICXXPred_Simple_IsRule183Enabled,
  GICXXPred_Simple_IsRule184Enabled,
  GICXXPred_Simple_IsRule185Enabled,
  GICXXPred_Simple_IsRule186Enabled,
  GICXXPred_Simple_IsRule187Enabled,
  GICXXPred_Simple_IsRule188Enabled,
  GICXXPred_Simple_IsRule189Enabled,
  GICXXPred_Simple_IsRule190Enabled,
  GICXXPred_Simple_IsRule191Enabled,
  GICXXPred_Simple_IsRule192Enabled,
  GICXXPred_Simple_IsRule193Enabled,
  GICXXPred_Simple_IsRule194Enabled,
  GICXXPred_Simple_IsRule195Enabled,
  GICXXPred_Simple_IsRule196Enabled,
  GICXXPred_Simple_IsRule197Enabled,
  GICXXPred_Simple_IsRule198Enabled,
  GICXXPred_Simple_IsRule199Enabled,
  GICXXPred_Simple_IsRule200Enabled,
  GICXXPred_Simple_IsRule201Enabled,
  GICXXPred_Simple_IsRule202Enabled,
  GICXXPred_Simple_IsRule203Enabled,
  GICXXPred_Simple_IsRule204Enabled,
  GICXXPred_Simple_IsRule205Enabled,
  GICXXPred_Simple_IsRule206Enabled,
  GICXXPred_Simple_IsRule207Enabled,
  GICXXPred_Simple_IsRule208Enabled,
  GICXXPred_Simple_IsRule209Enabled,
  GICXXPred_Simple_IsRule210Enabled,
  GICXXPred_Simple_IsRule211Enabled,
  GICXXPred_Simple_IsRule212Enabled,
  GICXXPred_Simple_IsRule213Enabled,
  GICXXPred_Simple_IsRule214Enabled,
  GICXXPred_Simple_IsRule215Enabled,
  GICXXPred_Simple_IsRule216Enabled,
  GICXXPred_Simple_IsRule217Enabled,
  GICXXPred_Simple_IsRule218Enabled,
  GICXXPred_Simple_IsRule219Enabled,
  GICXXPred_Simple_IsRule220Enabled,
  GICXXPred_Simple_IsRule221Enabled,
  GICXXPred_Simple_IsRule222Enabled,
  GICXXPred_Simple_IsRule223Enabled,
  GICXXPred_Simple_IsRule224Enabled,
  GICXXPred_Simple_IsRule225Enabled,
  GICXXPred_Simple_IsRule226Enabled,
  GICXXPred_Simple_IsRule227Enabled,
  GICXXPred_Simple_IsRule228Enabled,
  GICXXPred_Simple_IsRule229Enabled,
};

bool AMDGPUPreLegalizerCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
AMDGPUPreLegalizerCombinerImpl::CustomRendererFn
AMDGPUPreLegalizerCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool AMDGPUPreLegalizerCombinerImpl::tryCombineAllImpl(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
  GICXXCustomAction_GICombiner17,
  GICXXCustomAction_GICombiner18,
  GICXXCustomAction_GICombiner19,
  GICXXCustomAction_GICombiner20,
  GICXXCustomAction_GICombiner21,
  GICXXCustomAction_GICombiner22,
  GICXXCustomAction_GICombiner23,
  GICXXCustomAction_GICombiner24,
  GICXXCustomAction_GICombiner25,
  GICXXCustomAction_GICombiner26,
  GICXXCustomAction_GICombiner27,
  GICXXCustomAction_GICombiner28,
  GICXXCustomAction_GICombiner29,
  GICXXCustomAction_GICombiner30,
  GICXXCustomAction_GICombiner31,
  GICXXCustomAction_GICombiner32,
  GICXXCustomAction_GICombiner33,
  GICXXCustomAction_GICombiner34,
  GICXXCustomAction_GICombiner35,
  GICXXCustomAction_GICombiner36,
  GICXXCustomAction_GICombiner37,
  GICXXCustomAction_GICombiner38,
  GICXXCustomAction_GICombiner39,
  GICXXCustomAction_GICombiner40,
  GICXXCustomAction_GICombiner41,
  GICXXCustomAction_GICombiner42,
  GICXXCustomAction_GICombiner43,
  GICXXCustomAction_GICombiner44,
  GICXXCustomAction_GICombiner45,
  GICXXCustomAction_GICombiner46,
  GICXXCustomAction_GICombiner47,
  GICXXCustomAction_GICombiner48,
  GICXXCustomAction_GICombiner49,
  GICXXCustomAction_GICombiner50,
  GICXXCustomAction_GICombiner51,
  GICXXCustomAction_GICombiner52,
  GICXXCustomAction_GICombiner53,
  GICXXCustomAction_GICombiner54,
  GICXXCustomAction_GICombiner55,
  GICXXCustomAction_GICombiner56,
  GICXXCustomAction_GICombiner57,
  GICXXCustomAction_GICombiner58,
  GICXXCustomAction_GICombiner59,
  GICXXCustomAction_GICombiner60,
  GICXXCustomAction_GICombiner61,
  GICXXCustomAction_GICombiner62,
  GICXXCustomAction_GICombiner63,
  GICXXCustomAction_GICombiner64,
  GICXXCustomAction_GICombiner65,
  GICXXCustomAction_GICombiner66,
  GICXXCustomAction_GICombiner67,
  GICXXCustomAction_GICombiner68,
  GICXXCustomAction_GICombiner69,
  GICXXCustomAction_GICombiner70,
  GICXXCustomAction_GICombiner71,
  GICXXCustomAction_GICombiner72,
  GICXXCustomAction_GICombiner73,
  GICXXCustomAction_GICombiner74,
  GICXXCustomAction_GICombiner75,
  GICXXCustomAction_GICombiner76,
  GICXXCustomAction_GICombiner77,
  GICXXCustomAction_GICombiner78,
  GICXXCustomAction_GICombiner79,
  GICXXCustomAction_GICombiner80,
  GICXXCustomAction_GICombiner81,
  GICXXCustomAction_GICombiner82,
  GICXXCustomAction_GICombiner83,
  GICXXCustomAction_GICombiner84,
  GICXXCustomAction_GICombiner85,
  GICXXCustomAction_GICombiner86,
  GICXXCustomAction_GICombiner87,
  GICXXCustomAction_GICombiner88,
  GICXXCustomAction_GICombiner89,
  GICXXCustomAction_GICombiner90,
  GICXXCustomAction_GICombiner91,
  GICXXCustomAction_GICombiner92,
  GICXXCustomAction_GICombiner93,
  GICXXCustomAction_GICombiner94,
  GICXXCustomAction_GICombiner95,
  GICXXCustomAction_GICombiner96,
  GICXXCustomAction_GICombiner97,
  GICXXCustomAction_GICombiner98,
  GICXXCustomAction_GICombiner99,
  GICXXCustomAction_GICombiner100,
  GICXXCustomAction_GICombiner101,
  GICXXCustomAction_GICombiner102,
  GICXXCustomAction_GICombiner103,
  GICXXCustomAction_GICombiner104,
  GICXXCustomAction_GICombiner105,
  GICXXCustomAction_GICombiner106,
  GICXXCustomAction_GICombiner107,
  GICXXCustomAction_GICombiner108,
  GICXXCustomAction_GICombiner109,
  GICXXCustomAction_GICombiner110,
  GICXXCustomAction_GICombiner111,
  GICXXCustomAction_GICombiner112,
  GICXXCustomAction_GICombiner113,
  GICXXCustomAction_GICombiner114,
  GICXXCustomAction_GICombiner115,
  GICXXCustomAction_GICombiner116,
  GICXXCustomAction_GICombiner117,
  GICXXCustomAction_GICombiner118,
  GICXXCustomAction_GICombiner119,
  GICXXCustomAction_GICombiner120,
  GICXXCustomAction_GICombiner121,
  GICXXCustomAction_GICombiner122,
  GICXXCustomAction_GICombiner123,
  GICXXCustomAction_GICombiner124,
  GICXXCustomAction_GICombiner125,
  GICXXCustomAction_GICombiner126,
  GICXXCustomAction_GICombiner127,
  GICXXCustomAction_GICombiner128,
  GICXXCustomAction_GICombiner129,
  GICXXCustomAction_GICombiner130,
  GICXXCustomAction_GICombiner131,
  GICXXCustomAction_GICombiner132,
  GICXXCustomAction_GICombiner133,
  GICXXCustomAction_GICombiner134,
  GICXXCustomAction_GICombiner135,
  GICXXCustomAction_GICombiner136,
  GICXXCustomAction_GICombiner137,
  GICXXCustomAction_GICombiner138,
  GICXXCustomAction_GICombiner139,
  GICXXCustomAction_GICombiner140,
  GICXXCustomAction_GICombiner141,
  GICXXCustomAction_GICombiner142,
  GICXXCustomAction_GICombiner143,
  GICXXCustomAction_GICombiner144,
  GICXXCustomAction_GICombiner145,
  GICXXCustomAction_GICombiner146,
  GICXXCustomAction_GICombiner147,
  GICXXCustomAction_GICombiner148,
  GICXXCustomAction_GICombiner149,
  GICXXCustomAction_GICombiner150,
  GICXXCustomAction_GICombiner151,
  GICXXCustomAction_GICombiner152,
  GICXXCustomAction_GICombiner153,
  GICXXCustomAction_GICombiner154,
  GICXXCustomAction_GICombiner155,
  GICXXCustomAction_GICombiner156,
  GICXXCustomAction_GICombiner157,
};
bool AMDGPUPreLegalizerCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAPlusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC2MinusAPlusC1(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldC1Minus2MinusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldAMinusC1PlusC2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    // Match Patterns
    if(![&](){return Helper.matchCombineCopy(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineCopy(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineMulToShl(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineSubToAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    std::pair<Register, bool> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineAddP2IToPtrAdd(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElement(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchInsertVectorElementOOB(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithDifferentIndices(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithBuildVectorTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVectorElementWithShuffleVector(*State.MIs[0], *State.MIs[1],
              GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner17:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShlOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner18:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubOfVScale(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner19:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return !isGuaranteedNotToBePoison(State.MIs[0]->getOperand(1).getReg(), MRI) && Helper.matchFreezeOfSingleMaybePoisonOperand(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner20:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncateOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner21:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtOfExt(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner22:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantSextInReg(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner23:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfSelect(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner24:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfBuildVector(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner25:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinop(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner26:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCastOfInteger(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner27:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineInsertVecElts(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineInsertVecElts(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner28:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractVecEltBuildVec(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner29:{
    SmallVector<std::pair<Register, MachineInstr*>> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtractAllEltsFromBuildVector(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner30:{
    PreferredTuple GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner31:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineLoadWithAndMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner32:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtractedVectorLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner33:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner34:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner35:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], -1);
    return true;
  }
  case GICXXCustomAction_GICombiner36:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], 0);
    return true;
  }
  case GICXXCustomAction_GICombiner37:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsUndef(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner38:{
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]->getOperand(0).getParent());
    return true;
  }
  case GICXXCustomAction_GICombiner39:{
    // Match Patterns
    if(![&](){return Helper.matchAnyExplicitUseIsUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner40:{
    // Match Patterns
    if(![&](){return Helper.matchAllExplicitUsesAreUndef(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner41:{
    // Match Patterns
    if(![&](){return Helper.matchUndefShuffleVectorMask(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner42:{
    // Match Patterns
    if(![&](){return Helper.matchUndefStore(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.eraseInst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner43:{
    // Match Patterns
    if(![&](){return Helper.matchInsertExtractVecEltOutOfBounds(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithUndef(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner44:{
    // Match Patterns
    if(![&](){return Helper.matchSelectSameVal(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 2);
    return true;
  }
  case GICXXCustomAction_GICombiner45:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsZero(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner46:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineI2PToP2I(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineI2PToP2I(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner47:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){GIMatchData_info = State.MIs[1]->getOperand(1).getReg(); return true;}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineP2IToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner48:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineAnyExtTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner49:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchBuildVectorIdentityFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner50:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner51:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncLshrBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner52:{
    // Match Patterns
    if(![&](){return MRI.getType(State.MIs[1]->getOperand(1).getReg()) == MRI.getType(State.MIs[0]->getOperand(0).getReg());}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], State.MIs[1]->getOperand(1).getReg());
    return true;
  }
  case GICXXCustomAction_GICombiner53:{
    MachineInstr* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExtendThroughPhis(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner54:{
    std::tuple<Register, Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyAddToSub(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyAddToSub(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner55:{
    InstructionStepsMatchInfo GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchHoistLogicOpWithSameOpcodeHands(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildInstructionSteps(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner56:{
    std::optional<int64_t> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftsTooBig(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    if (GIMatchData_matchinfo) {
              Helper.replaceInstWithConstant(*State.MIs[0], *GIMatchData_matchinfo);
            } else {
              Helper.replaceInstWithUndef(*State.MIs[0]);
            }
    return true;
  }
  case GICXXCustomAction_GICombiner57:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocPtrAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner58:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchReassocCommBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner59:{
    PtrAddChain GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner60:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeICmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner61:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCanonicalizeFCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner62:{
    int64_t GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchICmpToTrueFalseKnownBits(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner63:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchICmpToLHSKnownBits(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner64:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchRedundantBinOpInEquality(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner65:{
    std::tuple<Register, int64_t> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAshrShlToSextInreg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyAshShlToSextInreg(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner66:{
    std::tuple<Register, unsigned> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySextInRegOfLoad(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner67:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShlOfExtend(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner68:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNarrowBinopFeedingAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner69:{
    unsigned GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantSelectCmp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner70:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSelectIMinMax(State.MIs[0]->getOperand(0), GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner71:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSelect(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner72:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner73:{
    // Match Patterns
    if(![&](){return Helper.matchRedundantSExtInReg(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner74:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner75:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsKnownToBeAPowerOfTwo(*State.MIs[0], 2);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySimplifyURemByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner76:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineZextTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner77:{
    // Match Patterns
    if(![&](){unsigned BitWidth = MRI.getType(State.MIs[0]->getOperand(1).getReg()).getScalarSizeInBits();
                return Helper.getValueTracking()->maskedValueIsZero(State.MIs[0]->getOperand(1).getReg(),
                         APInt::getOneBitSet(BitWidth, State.MIs[0]->getOperand(2).getImm() - 1));}()) {
      return false;
    }
    // Apply Patterns
    Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
              Helper.getBuilder().buildZExtInReg(State.MIs[0]->getOperand(0), State.MIs[0]->getOperand(1), State.MIs[0]->getOperand(2).getImm());
              State.MIs[0]->eraseFromParent();
    return true;
  }
  case GICXXCustomAction_GICombiner78:{
    std::pair<MachineInstr*, LLT> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineTruncOfShift(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner79:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchNotCmp(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyNotCmp(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner80:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyOptBrCondByInvertingCond(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner81:{
    // Apply Patterns
    Helper.applyCombineConstantFoldFpUnary(*State.MIs[0], State.MIs[1]->getOperand(1).getFPImm());
    return true;
  }
  case GICXXCustomAction_GICombiner82:{
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0]->getOperand(0).getParent(), 0.0);
    return true;
  }
  case GICXXCustomAction_GICombiner83:{
    APInt GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConstPtrAddToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner84:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOverlappingAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner85:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy2(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner86:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMulOBy0(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner87:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddEToAddO(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner88:{
    unsigned GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFMinMaxNaN(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner89:{
    // Match Patterns
    if(![&](){return Helper.matchFPowIExpansion(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyExpandFPowI(*State.MIs[0], State.MIs[1]->getOperand(1).getCImm()->getSExtValue());
    return true;
  }
  case GICXXCustomAction_GICombiner90:{
    std::pair<Register, Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyXorOfAndWithSameReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner91:{
    // Match Patterns
    if(![&](){return Helper.matchPtrAddZero(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyPtrAddZero(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner92:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner93:{
    ShiftOfShiftedLogic GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftOfShiftedLogic(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner94:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchLoadOrCombine(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner95:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineDivRem(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner96:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchOrShiftToFunnelShift(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner97:{
    // Match Patterns
    if(![&](){return Helper.matchFunnelShiftToRotate(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftToRotate(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner98:{
    // Match Patterns
    if(![&](){return Helper.matchConstantLargerBitWidth(*State.MIs[0], 3);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFunnelShiftConstantModulo(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner99:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCommuteShift(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner100:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromSExtInReg(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner101:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner102:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShr(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner103:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchBitfieldExtractFromShrAnd(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner104:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner105:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFPBinOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner106:{
    ConstantFP* GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldFMA(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithFConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner107:{
    APInt GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchConstantFoldCastOp(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceInstWithConstant(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner108:{
    // Match Patterns
    if(![&](){return Helper.matchUMulHToLShr(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUMulHToLShr(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner109:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantNegOperands(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner110:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchAndOrDisjointMask(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner111:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner112:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner113:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFMAFMulToFMadOrFMA(*State.MIs[0],
                                                                     GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner114:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFAddFpExtFMulToFMadOrFMAAggressive(
                                                          *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner115:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFMulToFMadOrFMA(*State.MIs[0],
                                                                  GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner116:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFNegFMulToFMadOrFMA(*State.MIs[0],
                                                                      GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner117:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFMulToFMadOrFMA(*State.MIs[0],
                                                                       GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner118:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineFSubFpExtFNegFMulToFMadOrFMA(
                                                    *State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner119:{
    unsigned GIMatchData_select_op_no;
    // Match Patterns
    if(![&](){return Helper.matchFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldBinOpIntoSelect(*State.MIs[0], GIMatchData_select_op_no);
    return true;
  }
  case GICXXCustomAction_GICombiner120:{
    // Match Patterns
    if(![&](){return Helper.matchUDivOrURemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivOrURemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner121:{
    // Match Patterns
    if(![&](){return Helper.matchSDivOrSRemByConst(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivOrSRemByConst(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner122:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/false);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner123:{
    // Match Patterns
    if(![&](){return Helper.matchDivByPow2(*State.MIs[0], /*IsSigned=*/true);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applySDivByPow2(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner124:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSubAddSameReg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner125:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchSimplifySelectToMinMax(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner126:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFsubToFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner127:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner128:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteFPConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner129:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner130:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchOr(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner131:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyNegMinMax(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner132:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineConcatVectors(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner133:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner134:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchZextOfTrunc(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner135:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchNonNegZext(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnMO(State.MIs[0]->getOperand(0), GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner136:{
    SmallVector<Register> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleConcat(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner137:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleUndefRHS(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner138:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShuffleDisjointMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner139:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyUseVectorTruncate(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner140:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchUnmergeValuesAnyExtBuildVector(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner141:{
    SmallVector<Register> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeMergeToPlainValues(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner142:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineMergeUnmerge(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner143:{
    SmallVector<APInt, 8> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeConstant(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner144:{
    std::function<void(MachineIRBuilder &)> GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeUndef(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner145:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeWithDeadLanesToTrunc(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner146:{
    // Match Patterns
    if(![&](){return Helper.matchCombineUnmergeZExtToZExt(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineUnmergeZExtToZExt(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner147:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndUndef(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner148:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchMergeXAndZero(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner149:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchAddOverflow(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner150:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSuboCarryOut(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner151:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncSSatS(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyTruncSSatS(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner152:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncSSatU(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyTruncSSatU(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner153:{
    LshrOfTruncOfLshr GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchLshrOfTruncOfLshr(*State.MIs[0], GIMatchData_matchinfo, *State.MIs[2]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyLshrOfTruncOfLshr(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner154:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineFmulWithSelectToFldexp(*State.MIs[0], *State.MIs[1], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner155:{
    ClampI64ToI16MatchInfo GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return matchClampI64ToI16(*State.MIs[0], MRI, MF, GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    applyClampI64ToI16(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner156:{
    MachineInstr * GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchFoldableFneg(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyFoldableFneg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner157:{
    // Match Patterns
    if(![&](){return Helper.matchCombineShuffleToBuildVector(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineShuffleToBuildVector(*State.MIs[0]);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUPreLegalizerCombinerImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(20), GIMT_Encode2(270), /*)*//*default:*//*Label 96*/ GIMT_Encode4(7680),
     /*   10 */ /*TargetOpcode::COPY*//*Label 0*/ GIMT_Encode4(1010), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  142 */ /*TargetOpcode::G_ADD*//*Label 1*/ GIMT_Encode4(1022),
     /*  146 */ /*TargetOpcode::G_SUB*//*Label 2*/ GIMT_Encode4(1579),
     /*  150 */ /*TargetOpcode::G_MUL*//*Label 3*/ GIMT_Encode4(1897),
     /*  154 */ /*TargetOpcode::G_SDIV*//*Label 4*/ GIMT_Encode4(2063),
     /*  158 */ /*TargetOpcode::G_UDIV*//*Label 5*/ GIMT_Encode4(2136),
     /*  162 */ /*TargetOpcode::G_SREM*//*Label 6*/ GIMT_Encode4(2220),
     /*  166 */ /*TargetOpcode::G_UREM*//*Label 7*/ GIMT_Encode4(2276), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  178 */ /*TargetOpcode::G_AND*//*Label 8*/ GIMT_Encode4(2354),
     /*  182 */ /*TargetOpcode::G_OR*//*Label 9*/ GIMT_Encode4(2749),
     /*  186 */ /*TargetOpcode::G_XOR*//*Label 10*/ GIMT_Encode4(3296), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  202 */ /*TargetOpcode::G_PHI*//*Label 11*/ GIMT_Encode4(3397), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  226 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 12*/ GIMT_Encode4(3409), GIMT_Encode4(0),
     /*  234 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 13*/ GIMT_Encode4(3476),
     /*  238 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 14*/ GIMT_Encode4(3550),
     /*  242 */ /*TargetOpcode::G_BUILD_VECTOR_TRUNC*//*Label 15*/ GIMT_Encode4(3598),
     /*  246 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 16*/ GIMT_Encode4(3610),
     /*  250 */ /*TargetOpcode::G_PTRTOINT*//*Label 17*/ GIMT_Encode4(3622),
     /*  254 */ /*TargetOpcode::G_INTTOPTR*//*Label 18*/ GIMT_Encode4(3665),
     /*  258 */ /*TargetOpcode::G_BITCAST*//*Label 19*/ GIMT_Encode4(3698),
     /*  262 */ /*TargetOpcode::G_FREEZE*//*Label 20*/ GIMT_Encode4(3741), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  302 */ /*TargetOpcode::G_LOAD*//*Label 21*/ GIMT_Encode4(3805),
     /*  306 */ /*TargetOpcode::G_SEXTLOAD*//*Label 22*/ GIMT_Encode4(3817),
     /*  310 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 23*/ GIMT_Encode4(3829), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  326 */ /*TargetOpcode::G_STORE*//*Label 24*/ GIMT_Encode4(3841), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  462 */ /*TargetOpcode::G_ANYEXT*//*Label 25*/ GIMT_Encode4(3853),
     /*  466 */ /*TargetOpcode::G_TRUNC*//*Label 26*/ GIMT_Encode4(3981), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  478 */ /*TargetOpcode::G_TRUNC_USAT_U*//*Label 27*/ GIMT_Encode4(4404), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  498 */ /*TargetOpcode::G_SEXT*//*Label 28*/ GIMT_Encode4(4437),
     /*  502 */ /*TargetOpcode::G_SEXT_INREG*//*Label 29*/ GIMT_Encode4(4512),
     /*  506 */ /*TargetOpcode::G_ZEXT*//*Label 30*/ GIMT_Encode4(4578),
     /*  510 */ /*TargetOpcode::G_SHL*//*Label 31*/ GIMT_Encode4(4708),
     /*  514 */ /*TargetOpcode::G_LSHR*//*Label 32*/ GIMT_Encode4(4877),
     /*  518 */ /*TargetOpcode::G_ASHR*//*Label 33*/ GIMT_Encode4(5029),
     /*  522 */ /*TargetOpcode::G_FSHL*//*Label 34*/ GIMT_Encode4(5163),
     /*  526 */ /*TargetOpcode::G_FSHR*//*Label 35*/ GIMT_Encode4(5206),
     /*  530 */ /*TargetOpcode::G_ROTR*//*Label 36*/ GIMT_Encode4(5249),
     /*  534 */ /*TargetOpcode::G_ROTL*//*Label 37*/ GIMT_Encode4(5273),
     /*  538 */ /*TargetOpcode::G_ICMP*//*Label 38*/ GIMT_Encode4(5297),
     /*  542 */ /*TargetOpcode::G_FCMP*//*Label 39*/ GIMT_Encode4(5342), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  554 */ /*TargetOpcode::G_SELECT*//*Label 40*/ GIMT_Encode4(5354),
     /*  558 */ /*TargetOpcode::G_UADDO*//*Label 41*/ GIMT_Encode4(5449),
     /*  562 */ /*TargetOpcode::G_UADDE*//*Label 42*/ GIMT_Encode4(5472),
     /*  566 */ /*TargetOpcode::G_USUBO*//*Label 43*/ GIMT_Encode4(5484),
     /*  570 */ /*TargetOpcode::G_USUBE*//*Label 44*/ GIMT_Encode4(5496),
     /*  574 */ /*TargetOpcode::G_SADDO*//*Label 45*/ GIMT_Encode4(5508),
     /*  578 */ /*TargetOpcode::G_SADDE*//*Label 46*/ GIMT_Encode4(5531),
     /*  582 */ /*TargetOpcode::G_SSUBO*//*Label 47*/ GIMT_Encode4(5543),
     /*  586 */ /*TargetOpcode::G_SSUBE*//*Label 48*/ GIMT_Encode4(5555),
     /*  590 */ /*TargetOpcode::G_UMULO*//*Label 49*/ GIMT_Encode4(5567),
     /*  594 */ /*TargetOpcode::G_SMULO*//*Label 50*/ GIMT_Encode4(5601),
     /*  598 */ /*TargetOpcode::G_UMULH*//*Label 51*/ GIMT_Encode4(5635),
     /*  602 */ /*TargetOpcode::G_SMULH*//*Label 52*/ GIMT_Encode4(5658),
     /*  606 */ /*TargetOpcode::G_UADDSAT*//*Label 53*/ GIMT_Encode4(5670),
     /*  610 */ /*TargetOpcode::G_SADDSAT*//*Label 54*/ GIMT_Encode4(5682), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  622 */ /*TargetOpcode::G_USHLSAT*//*Label 55*/ GIMT_Encode4(5694),
     /*  626 */ /*TargetOpcode::G_SSHLSAT*//*Label 56*/ GIMT_Encode4(5717),
     /*  630 */ /*TargetOpcode::G_SMULFIX*//*Label 57*/ GIMT_Encode4(5740),
     /*  634 */ /*TargetOpcode::G_UMULFIX*//*Label 58*/ GIMT_Encode4(5752),
     /*  638 */ /*TargetOpcode::G_SMULFIXSAT*//*Label 59*/ GIMT_Encode4(5764),
     /*  642 */ /*TargetOpcode::G_UMULFIXSAT*//*Label 60*/ GIMT_Encode4(5776), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  662 */ /*TargetOpcode::G_FADD*//*Label 61*/ GIMT_Encode4(5788),
     /*  666 */ /*TargetOpcode::G_FSUB*//*Label 62*/ GIMT_Encode4(5929),
     /*  670 */ /*TargetOpcode::G_FMUL*//*Label 63*/ GIMT_Encode4(6018),
     /*  674 */ /*TargetOpcode::G_FMA*//*Label 64*/ GIMT_Encode4(6127),
     /*  678 */ /*TargetOpcode::G_FMAD*//*Label 65*/ GIMT_Encode4(6150),
     /*  682 */ /*TargetOpcode::G_FDIV*//*Label 66*/ GIMT_Encode4(6173),
     /*  686 */ /*TargetOpcode::G_FREM*//*Label 67*/ GIMT_Encode4(6207), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  698 */ /*TargetOpcode::G_FPOWI*//*Label 68*/ GIMT_Encode4(6219), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  718 */ /*TargetOpcode::G_FLOG2*//*Label 69*/ GIMT_Encode4(6241), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  734 */ /*TargetOpcode::G_FNEG*//*Label 70*/ GIMT_Encode4(6263), GIMT_Encode4(0),
     /*  742 */ /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(6325),
     /*  746 */ /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(6368),
     /*  750 */ /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(6390),
     /*  754 */ /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(6412),
     /*  758 */ /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(6439), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  770 */ /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(6466), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  782 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 77*/ GIMT_Encode4(6545),
     /*  786 */ /*TargetOpcode::G_FMINNUM*//*Label 78*/ GIMT_Encode4(6575),
     /*  790 */ /*TargetOpcode::G_FMAXNUM*//*Label 79*/ GIMT_Encode4(6609),
     /*  794 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 80*/ GIMT_Encode4(6643),
     /*  798 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 81*/ GIMT_Encode4(6655),
     /*  802 */ /*TargetOpcode::G_FMINIMUM*//*Label 82*/ GIMT_Encode4(6667),
     /*  806 */ /*TargetOpcode::G_FMAXIMUM*//*Label 83*/ GIMT_Encode4(6701), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  850 */ /*TargetOpcode::G_PTR_ADD*//*Label 84*/ GIMT_Encode4(6735), GIMT_Encode4(0),
     /*  858 */ /*TargetOpcode::G_SMIN*//*Label 85*/ GIMT_Encode4(6825),
     /*  862 */ /*TargetOpcode::G_SMAX*//*Label 86*/ GIMT_Encode4(6859),
     /*  866 */ /*TargetOpcode::G_UMIN*//*Label 87*/ GIMT_Encode4(6893),
     /*  870 */ /*TargetOpcode::G_UMAX*//*Label 88*/ GIMT_Encode4(6927),
     /*  874 */ /*TargetOpcode::G_ABS*//*Label 89*/ GIMT_Encode4(6961), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  886 */ /*TargetOpcode::G_BR*//*Label 90*/ GIMT_Encode4(6973), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  906 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 91*/ GIMT_Encode4(6985),
     /*  910 */ /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 92*/ GIMT_Encode4(7115),
     /*  914 */ /*TargetOpcode::G_SHUFFLE_VECTOR*//*Label 93*/ GIMT_Encode4(7492), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  954 */ /*TargetOpcode::G_BITREVERSE*//*Label 94*/ GIMT_Encode4(7569), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /* 1006 */ /*TargetOpcode::G_FSQRT*//*Label 95*/ GIMT_Encode4(7658),
     /* 1010 */ // Label 0: @1010
     /* 1010 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1021), // Rule ID 13 //
     /* 1015 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /* 1018 */   // MIs[0] d
     /* 1018 */   // No operand predicates
     /* 1018 */   // MIs[0] s
     /* 1018 */   // No operand predicates
     /* 1018 */   // Combiner Rule #13: copy_prop
     /* 1018 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1021 */ // Label 97: @1021
     /* 1021 */ GIM_Reject,
     /* 1022 */ // Label 1: @1022
     /* 1022 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1033), // Rule ID 16 //
     /* 1027 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1030 */   // Combiner Rule #16: add_p2i_to_ptradd; wip_match_opcode 'G_ADD'
     /* 1030 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1033 */ // Label 98: @1033
     /* 1033 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1044), // Rule ID 94 //
     /* 1038 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1041 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_ADD'
     /* 1041 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1044 */ // Label 99: @1044
     /* 1044 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1055), // Rule ID 142 //
     /* 1049 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule104Enabled),
     /* 1052 */   // Combiner Rule #104: simplify_add_to_sub; wip_match_opcode 'G_ADD'
     /* 1052 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner54),
     /* 1055 */ // Label 100: @1055
     /* 1055 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1066), // Rule ID 236 //
     /* 1060 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 1063 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_ADD'
     /* 1063 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1066 */ // Label 101: @1066
     /* 1066 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1077), // Rule ID 280 //
     /* 1071 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 1074 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_ADD'
     /* 1074 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1077 */ // Label 102: @1077
     /* 1077 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1088), // Rule ID 315 //
     /* 1082 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 1085 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_ADD'
     /* 1085 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1088 */ // Label 103: @1088
     /* 1088 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1122), // Rule ID 0 //
     /* 1093 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /* 1096 */   // MIs[0] root
     /* 1096 */   // No operand predicates
     /* 1096 */   // MIs[0] sub
     /* 1096 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1100 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1104 */   // MIs[1] Operand 1
     /* 1104 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1108 */   // MIs[1] A
     /* 1108 */   // No operand predicates
     /* 1108 */   // MIs[0] B
     /* 1108 */   // No operand predicates
     /* 1108 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1110 */   // Combiner Rule #0: ZeroMinusAPlusB
     /* 1110 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1113 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1115 */   GIR_RootToRootCopy, /*OpIdx*/2, // B
     /* 1117 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // A
     /* 1121 */   GIR_EraseRootFromParent_Done,
     /* 1122 */ // Label 104: @1122
     /* 1122 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1159), // Rule ID 12 //
     /* 1127 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /* 1130 */   // MIs[0] root
     /* 1130 */   // No operand predicates
     /* 1130 */   // MIs[0] sub
     /* 1130 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1134 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1138 */   // MIs[1] A
     /* 1138 */   // No operand predicates
     /* 1138 */   // MIs[1] c1
     /* 1138 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1142 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1146 */   // MIs[2] imm1
     /* 1146 */   // No operand predicates
     /* 1146 */   // MIs[0] c2
     /* 1146 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1150 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1154 */   // MIs[3] imm2
     /* 1154 */   // No operand predicates
     /* 1154 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1156 */   // Combiner Rule #12: AMinusC1PlusC2
     /* 1156 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 1159 */ // Label 105: @1159
     /* 1159 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1193), // Rule ID 3 //
     /* 1164 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 1167 */   // MIs[0] root
     /* 1167 */   // No operand predicates
     /* 1167 */   // MIs[0] sub
     /* 1167 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1171 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1175 */   // MIs[1] B
     /* 1175 */   // No operand predicates
     /* 1175 */   // MIs[1] A
     /* 1175 */   // No operand predicates
     /* 1175 */   // MIs[0] A
     /* 1175 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1180 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1185 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1187 */   // Combiner Rule #3: BMinusAPlusA
     /* 1187 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1192 */   GIR_EraseRootFromParent_Done,
     /* 1193 */ // Label 106: @1193
     /* 1193 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1227), // Rule ID 131 //
     /* 1198 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1201 */   // MIs[0] dst
     /* 1201 */   // No operand predicates
     /* 1201 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1201 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1205 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1209 */   // MIs[1] src
     /* 1209 */   // No operand predicates
     /* 1209 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1209 */   // No operand predicates
     /* 1209 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1209 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1214 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1219 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1221 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[1]]
     /* 1221 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1226 */   GIR_EraseRootFromParent_Done,
     /* 1227 */ // Label 107: @1227
     /* 1227 */ GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1272), // Rule ID 5 //
     /* 1232 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1235 */   // MIs[0] root
     /* 1235 */   // No operand predicates
     /* 1235 */   // MIs[0] sub1
     /* 1235 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1239 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1243 */   // MIs[1] A
     /* 1243 */   // No operand predicates
     /* 1243 */   // MIs[1] B
     /* 1243 */   // No operand predicates
     /* 1243 */   // MIs[0] sub2
     /* 1243 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1247 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1251 */   // MIs[2] B
     /* 1251 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 1256 */   // MIs[2] C
     /* 1256 */   // No operand predicates
     /* 1256 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1258 */   // Combiner Rule #5: AMinusBPlusBMinusC
     /* 1258 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1261 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1263 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // A
     /* 1267 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1271 */   GIR_EraseRootFromParent_Done,
     /* 1272 */ // Label 108: @1272
     /* 1272 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1317), // Rule ID 4 //
     /* 1277 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 1280 */   // MIs[0] root
     /* 1280 */   // No operand predicates
     /* 1280 */   // MIs[0] sub1
     /* 1280 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1284 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1288 */   // MIs[1] A
     /* 1288 */   // No operand predicates
     /* 1288 */   // MIs[1] B
     /* 1288 */   // No operand predicates
     /* 1288 */   // MIs[0] sub2
     /* 1288 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1292 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1296 */   // MIs[2] C
     /* 1296 */   // No operand predicates
     /* 1296 */   // MIs[2] A
     /* 1296 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 1301 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1303 */   // Combiner Rule #4: AMinusBPlusCMinusA
     /* 1303 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1306 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1308 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1312 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1316 */   GIR_EraseRootFromParent_Done,
     /* 1317 */ // Label 109: @1317
     /* 1317 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1352), // Rule ID 39 //
     /* 1322 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule37Enabled),
     /* 1325 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1331 */   // MIs[0] root
     /* 1331 */   // No operand predicates
     /* 1331 */   // MIs[0] left
     /* 1331 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1335 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1339 */   // MIs[1] imm1
     /* 1339 */   // No operand predicates
     /* 1339 */   // MIs[0] right
     /* 1339 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1343 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1347 */   // MIs[2] imm2
     /* 1347 */   // No operand predicates
     /* 1347 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1349 */   // Combiner Rule #37: add_of_vscale
     /* 1349 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1352 */ // Label 110: @1352
     /* 1352 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1386), // Rule ID 1 //
     /* 1357 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1360 */   // MIs[0] root
     /* 1360 */   // No operand predicates
     /* 1360 */   // MIs[0] A
     /* 1360 */   // No operand predicates
     /* 1360 */   // MIs[0] sub
     /* 1360 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1364 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1368 */   // MIs[1] Operand 1
     /* 1368 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 0,
     /* 1372 */   // MIs[1] B
     /* 1372 */   // No operand predicates
     /* 1372 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1374 */   // Combiner Rule #1: APlusZeroMinusB
     /* 1374 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1377 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1379 */   GIR_RootToRootCopy, /*OpIdx*/1, // A
     /* 1381 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // B
     /* 1385 */   GIR_EraseRootFromParent_Done,
     /* 1386 */ // Label 111: @1386
     /* 1386 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1420), // Rule ID 2 //
     /* 1391 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 1394 */   // MIs[0] root
     /* 1394 */   // No operand predicates
     /* 1394 */   // MIs[0] A
     /* 1394 */   // No operand predicates
     /* 1394 */   // MIs[0] sub
     /* 1394 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1398 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1402 */   // MIs[1] B
     /* 1402 */   // No operand predicates
     /* 1402 */   // MIs[1] A
     /* 1402 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1407 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1412 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1414 */   // Combiner Rule #2: APlusBMinusB
     /* 1414 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1419 */   GIR_EraseRootFromParent_Done,
     /* 1420 */ // Label 112: @1420
     /* 1420 */ GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1454), // Rule ID 130 //
     /* 1425 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule94Enabled),
     /* 1428 */   // MIs[0] dst
     /* 1428 */   // No operand predicates
     /* 1428 */   // MIs[0] __add_sub_reg_match_0.x
     /* 1428 */   // No operand predicates
     /* 1428 */   // MIs[0] __add_sub_reg_match_0.tmp
     /* 1428 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1432 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1436 */   // MIs[1] src
     /* 1436 */   // No operand predicates
     /* 1436 */   // MIs[1] __add_sub_reg_match_0.x
     /* 1436 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1441 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1446 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1448 */   // Combiner Rule #94: add_sub_reg @ [__add_sub_reg_match_0[0]]
     /* 1448 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1453 */   GIR_EraseRootFromParent_Done,
     /* 1454 */ // Label 113: @1454
     /* 1454 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1499), // Rule ID 6 //
     /* 1459 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1462 */   // MIs[0] root
     /* 1462 */   // No operand predicates
     /* 1462 */   // MIs[0] A
     /* 1462 */   // No operand predicates
     /* 1462 */   // MIs[0] sub1
     /* 1462 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1466 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1470 */   // MIs[1] B
     /* 1470 */   // No operand predicates
     /* 1470 */   // MIs[1] add1
     /* 1470 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1474 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1478 */   // MIs[2] A
     /* 1478 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1483 */   // MIs[2] C
     /* 1483 */   // No operand predicates
     /* 1483 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1485 */   // Combiner Rule #6: APlusBMinusAplusC
     /* 1485 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1488 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1490 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1494 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // C
     /* 1498 */   GIR_EraseRootFromParent_Done,
     /* 1499 */ // Label 114: @1499
     /* 1499 */ GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1544), // Rule ID 7 //
     /* 1504 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1507 */   // MIs[0] root
     /* 1507 */   // No operand predicates
     /* 1507 */   // MIs[0] A
     /* 1507 */   // No operand predicates
     /* 1507 */   // MIs[0] sub1
     /* 1507 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1511 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1515 */   // MIs[1] B
     /* 1515 */   // No operand predicates
     /* 1515 */   // MIs[1] add1
     /* 1515 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1519 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1523 */   // MIs[2] C
     /* 1523 */   // No operand predicates
     /* 1523 */   // MIs[2] A
     /* 1523 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1528 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 1530 */   // Combiner Rule #7: APlusBMinusCPlusA
     /* 1530 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1533 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 1535 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /* 1539 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // C
     /* 1543 */   GIR_EraseRootFromParent_Done,
     /* 1544 */ // Label 115: @1544
     /* 1544 */ GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1567), // Rule ID 105 //
     /* 1549 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1552 */   // MIs[0] dst
     /* 1552 */   // No operand predicates
     /* 1552 */   // MIs[0] lhs
     /* 1552 */   // No operand predicates
     /* 1552 */   // MIs[0] Operand 2
     /* 1552 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1556 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1561 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[1]]
     /* 1561 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1566 */   GIR_EraseRootFromParent_Done,
     /* 1567 */ // Label 116: @1567
     /* 1567 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1578), // Rule ID 150 //
     /* 1572 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule108Enabled),
     /* 1575 */   // MIs[0] root
     /* 1575 */   // No operand predicates
     /* 1575 */   // MIs[0] src1
     /* 1575 */   // No operand predicates
     /* 1575 */   // MIs[0] src2
     /* 1575 */   // No operand predicates
     /* 1575 */   // Combiner Rule #108: reassoc_comm_binops
     /* 1575 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner58),
     /* 1578 */ // Label 117: @1578
     /* 1578 */ GIM_Reject,
     /* 1579 */ // Label 2: @1579
     /* 1579 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1590), // Rule ID 95 //
     /* 1584 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 1587 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_SUB'
     /* 1587 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 1590 */ // Label 118: @1590
     /* 1590 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1601), // Rule ID 244 //
     /* 1595 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 1598 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SUB'
     /* 1598 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1601 */ // Label 119: @1601
     /* 1601 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1612), // Rule ID 281 //
     /* 1606 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 1609 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SUB'
     /* 1609 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 1612 */ // Label 120: @1612
     /* 1612 */ GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1623), // Rule ID 312 //
     /* 1617 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule192Enabled),
     /* 1620 */   // Combiner Rule #192: sub_add_reg; wip_match_opcode 'G_SUB'
     /* 1620 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner124),
     /* 1623 */ // Label 121: @1623
     /* 1623 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1634), // Rule ID 346 //
     /* 1628 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule199Enabled),
     /* 1631 */   // Combiner Rule #199: simplify_neg_minmax; wip_match_opcode 'G_SUB'
     /* 1631 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner131),
     /* 1634 */ // Label 122: @1634
     /* 1634 */ GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1671), // Rule ID 8 //
     /* 1639 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /* 1642 */   // MIs[0] root
     /* 1642 */   // No operand predicates
     /* 1642 */   // MIs[0] add
     /* 1642 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1646 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1650 */   // MIs[1] A
     /* 1650 */   // No operand predicates
     /* 1650 */   // MIs[1] c1
     /* 1650 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1654 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1658 */   // MIs[2] imm1
     /* 1658 */   // No operand predicates
     /* 1658 */   // MIs[0] c2
     /* 1658 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1662 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1666 */   // MIs[3] imm2
     /* 1666 */   // No operand predicates
     /* 1666 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1668 */   // Combiner Rule #8: APlusC1MinusC2
     /* 1668 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /* 1671 */ // Label 123: @1671
     /* 1671 */ GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1708), // Rule ID 11 //
     /* 1676 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 1679 */   // MIs[0] root
     /* 1679 */   // No operand predicates
     /* 1679 */   // MIs[0] sub1
     /* 1679 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1683 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1687 */   // MIs[1] c1
     /* 1687 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 1691 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1695 */   // MIs[2] imm1
     /* 1695 */   // No operand predicates
     /* 1695 */   // MIs[1] A
     /* 1695 */   // No operand predicates
     /* 1695 */   // MIs[0] c2
     /* 1695 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1699 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1703 */   // MIs[3] imm2
     /* 1703 */   // No operand predicates
     /* 1703 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1705 */   // Combiner Rule #11: C1Minus2MinusC2
     /* 1705 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 1708 */ // Label 124: @1708
     /* 1708 */ GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1745), // Rule ID 10 //
     /* 1713 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 1716 */   // MIs[0] root
     /* 1716 */   // No operand predicates
     /* 1716 */   // MIs[0] sub1
     /* 1716 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1720 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1724 */   // MIs[1] A
     /* 1724 */   // No operand predicates
     /* 1724 */   // MIs[1] c1
     /* 1724 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 1728 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1732 */   // MIs[2] imm1
     /* 1732 */   // No operand predicates
     /* 1732 */   // MIs[0] c2
     /* 1732 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 1736 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1740 */   // MIs[3] imm2
     /* 1740 */   // No operand predicates
     /* 1740 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1742 */   // Combiner Rule #10: AMinusC1MinusC2
     /* 1742 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 1745 */ // Label 125: @1745
     /* 1745 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1788), // Rule ID 160 //
     /* 1750 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule118Enabled),
     /* 1753 */   // MIs[0] dst
     /* 1753 */   // No operand predicates
     /* 1753 */   // MIs[0] Operand 1
     /* 1753 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 1757 */   // MIs[0] and
     /* 1757 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1761 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 1765 */   // MIs[1] x
     /* 1765 */   // No operand predicates
     /* 1765 */   // MIs[1] Operand 2
     /* 1765 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /* 1769 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner8),
     /* 1773 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1775 */   // Combiner Rule #118: neg_and_one_to_sext_inreg
     /* 1775 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 1778 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1780 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 1784 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /* 1787 */   GIR_EraseRootFromParent_Done,
     /* 1788 */ // Label 126: @1788
     /* 1788 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1825), // Rule ID 9 //
     /* 1793 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1796 */   // MIs[0] root
     /* 1796 */   // No operand predicates
     /* 1796 */   // MIs[0] c2
     /* 1796 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1800 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1804 */   // MIs[1] imm2
     /* 1804 */   // No operand predicates
     /* 1804 */   // MIs[0] add
     /* 1804 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1808 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 1812 */   // MIs[2] A
     /* 1812 */   // No operand predicates
     /* 1812 */   // MIs[2] c1
     /* 1812 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /* 1816 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1820 */   // MIs[3] imm1
     /* 1820 */   // No operand predicates
     /* 1820 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 1822 */   // Combiner Rule #9: C2MinusAPlusC1
     /* 1822 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1825 */ // Label 127: @1825
     /* 1825 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1852), // Rule ID 42 //
     /* 1830 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule40Enabled),
     /* 1833 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1839 */   // MIs[0] root
     /* 1839 */   // No operand predicates
     /* 1839 */   // MIs[0] x
     /* 1839 */   // No operand predicates
     /* 1839 */   // MIs[0] right
     /* 1839 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1843 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1847 */   // MIs[1] imm
     /* 1847 */   // No operand predicates
     /* 1847 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1849 */   // Combiner Rule #40: sub_of_vscale
     /* 1849 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner18),
     /* 1852 */ // Label 128: @1852
     /* 1852 */ GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1875), // Rule ID 104 //
     /* 1857 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 1860 */   // MIs[0] dst
     /* 1860 */   // No operand predicates
     /* 1860 */   // MIs[0] lhs
     /* 1860 */   // No operand predicates
     /* 1860 */   // MIs[0] Operand 2
     /* 1860 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1864 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1869 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[0]]
     /* 1869 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1874 */   GIR_EraseRootFromParent_Done,
     /* 1875 */ // Label 129: @1875
     /* 1875 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1896), // Rule ID 15 //
     /* 1880 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /* 1883 */   // MIs[0] d
     /* 1883 */   // No operand predicates
     /* 1883 */   // MIs[0] op1
     /* 1883 */   // No operand predicates
     /* 1883 */   // MIs[0] c
     /* 1883 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 1887 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 1891 */   // MIs[1] imm
     /* 1891 */   // No operand predicates
     /* 1891 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1893 */   // Combiner Rule #15: sub_to_add
     /* 1893 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 1896 */ // Label 130: @1896
     /* 1896 */ GIM_Reject,
     /* 1897 */ // Label 3: @1897
     /* 1897 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1908), // Rule ID 78 //
     /* 1902 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 1905 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_MUL'
     /* 1905 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 1908 */ // Label 131: @1908
     /* 1908 */ GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1919), // Rule ID 241 //
     /* 1913 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 1916 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_MUL'
     /* 1916 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 1919 */ // Label 132: @1919
     /* 1919 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1930), // Rule ID 316 //
     /* 1924 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 1927 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_MUL'
     /* 1927 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 1930 */ // Label 133: @1930
     /* 1930 */ GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1970), // Rule ID 17 //
     /* 1935 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 1938 */   // MIs[0] dst
     /* 1938 */   GIM_RecordRegType, /*MI*/0, /*Op*/0, /*TempTypeIdx*/255,
     /* 1942 */   // MIs[0] x
     /* 1942 */   // No operand predicates
     /* 1942 */   // MIs[0] Operand 2
     /* 1942 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /* 1946 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 1949 */   GIR_BuildConstant, /*TempRegID*/0, /*Val*/GIMT_Encode8(0),
     /* 1959 */   // Combiner Rule #17: mul_by_neg_one
     /* 1959 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1962 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1964 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /* 1967 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 1969 */   GIR_EraseRootFromParent_Done,
     /* 1970 */ // Label 134: @1970
     /* 1970 */ GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2005), // Rule ID 40 //
     /* 1975 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule38Enabled),
     /* 1978 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 1984 */   // MIs[0] root
     /* 1984 */   // No operand predicates
     /* 1984 */   // MIs[0] left
     /* 1984 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1988 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 1992 */   // MIs[1] scale
     /* 1992 */   // No operand predicates
     /* 1992 */   // MIs[0] x
     /* 1992 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 1996 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2000 */   // MIs[2] imm1
     /* 2000 */   // No operand predicates
     /* 2000 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2002 */   // Combiner Rule #38: mul_of_vscale
     /* 2002 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /* 2005 */ // Label 135: @2005
     /* 2005 */ GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2028), // Rule ID 123 //
     /* 2010 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule87Enabled),
     /* 2013 */   // MIs[0] dst
     /* 2013 */   // No operand predicates
     /* 2013 */   // MIs[0] lhs
     /* 2013 */   // No operand predicates
     /* 2013 */   // MIs[0] zero
     /* 2013 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 2017 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2022 */   // Combiner Rule #87: binop_right_to_zero
     /* 2022 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 2027 */   GIR_EraseRootFromParent_Done,
     /* 2028 */ // Label 136: @2028
     /* 2028 */ GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2051), // Rule ID 128 //
     /* 2033 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule92Enabled),
     /* 2036 */   // MIs[0] dst
     /* 2036 */   // No operand predicates
     /* 2036 */   // MIs[0] x
     /* 2036 */   // No operand predicates
     /* 2036 */   // MIs[0] Operand 2
     /* 2036 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /* 2040 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2045 */   // Combiner Rule #92: right_identity_one_int
     /* 2045 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2050 */   GIR_EraseRootFromParent_Done,
     /* 2051 */ // Label 137: @2051
     /* 2051 */ GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2062), // Rule ID 14 //
     /* 2056 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 2059 */   // MIs[0] d
     /* 2059 */   // No operand predicates
     /* 2059 */   // MIs[0] op1
     /* 2059 */   // No operand predicates
     /* 2059 */   // MIs[0] op2
     /* 2059 */   // No operand predicates
     /* 2059 */   // Combiner Rule #14: mul_to_shl
     /* 2059 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 2062 */ // Label 138: @2062
     /* 2062 */ GIM_Reject,
     /* 2063 */ // Label 4: @2063
     /* 2063 */ GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2074), // Rule ID 119 //
     /* 2068 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2071 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SDIV'
     /* 2071 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2074 */ // Label 139: @2074
     /* 2074 */ GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2085), // Rule ID 212 //
     /* 2079 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2082 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_SDIV'
     /* 2082 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2085 */ // Label 140: @2085
     /* 2085 */ GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2096), // Rule ID 247 //
     /* 2090 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2093 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SDIV'
     /* 2093 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2096 */ // Label 141: @2096
     /* 2096 */ GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2107), // Rule ID 286 //
     /* 2101 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2104 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SDIV'
     /* 2104 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2107 */ // Label 142: @2107
     /* 2107 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2124), // Rule ID 309 //
     /* 2112 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule189Enabled),
     /* 2115 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2121 */   // MIs[0] dst
     /* 2121 */   // No operand predicates
     /* 2121 */   // MIs[0] x
     /* 2121 */   // No operand predicates
     /* 2121 */   // MIs[0] y
     /* 2121 */   // No operand predicates
     /* 2121 */   // Combiner Rule #189: sdiv_by_pow2
     /* 2121 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner123),
     /* 2124 */ // Label 143: @2124
     /* 2124 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2135), // Rule ID 311 //
     /* 2129 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule191Enabled),
     /* 2132 */   // MIs[0] dst
     /* 2132 */   // No operand predicates
     /* 2132 */   // MIs[0] x
     /* 2132 */   // No operand predicates
     /* 2132 */   // MIs[0] y
     /* 2132 */   // No operand predicates
     /* 2132 */   // Combiner Rule #191: sdiv_by_const
     /* 2132 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2135 */ // Label 144: @2135
     /* 2135 */ GIM_Reject,
     /* 2136 */ // Label 5: @2136
     /* 2136 */ GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2147), // Rule ID 81 //
     /* 2141 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2144 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UDIV'
     /* 2144 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2147 */ // Label 145: @2147
     /* 2147 */ GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2158), // Rule ID 120 //
     /* 2152 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2155 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UDIV'
     /* 2155 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2158 */ // Label 146: @2158
     /* 2158 */ GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2169), // Rule ID 213 //
     /* 2163 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2166 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_UDIV'
     /* 2166 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2169 */ // Label 147: @2169
     /* 2169 */ GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2180), // Rule ID 246 //
     /* 2174 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2177 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UDIV'
     /* 2177 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2180 */ // Label 148: @2180
     /* 2180 */ GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2191), // Rule ID 288 //
     /* 2185 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2188 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UDIV'
     /* 2188 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2191 */ // Label 149: @2191
     /* 2191 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2208), // Rule ID 308 //
     /* 2196 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule188Enabled),
     /* 2199 */   GIM_MIFlagsNot, /*MI*/0, GIMT_Encode4(MachineInstr::IsExact),
     /* 2205 */   // MIs[0] dst
     /* 2205 */   // No operand predicates
     /* 2205 */   // MIs[0] x
     /* 2205 */   // No operand predicates
     /* 2205 */   // MIs[0] y
     /* 2205 */   // No operand predicates
     /* 2205 */   // Combiner Rule #188: udiv_by_pow2
     /* 2205 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner122),
     /* 2208 */ // Label 150: @2208
     /* 2208 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2219), // Rule ID 310 //
     /* 2213 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule190Enabled),
     /* 2216 */   // MIs[0] dst
     /* 2216 */   // No operand predicates
     /* 2216 */   // MIs[0] x
     /* 2216 */   // No operand predicates
     /* 2216 */   // MIs[0] y
     /* 2216 */   // No operand predicates
     /* 2216 */   // Combiner Rule #190: udiv_by_const
     /* 2216 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2219 */ // Label 151: @2219
     /* 2219 */ GIM_Reject,
     /* 2220 */ // Label 6: @2220
     /* 2220 */ GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2231), // Rule ID 121 //
     /* 2225 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2228 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SREM'
     /* 2228 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2231 */ // Label 152: @2231
     /* 2231 */ GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2242), // Rule ID 214 //
     /* 2236 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2239 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_SREM'
     /* 2239 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2242 */ // Label 153: @2242
     /* 2242 */ GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2253), // Rule ID 249 //
     /* 2247 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2250 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SREM'
     /* 2250 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2253 */ // Label 154: @2253
     /* 2253 */ GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(2264), // Rule ID 287 //
     /* 2258 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2261 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SREM'
     /* 2261 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2264 */ // Label 155: @2264
     /* 2264 */ GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(2275), // Rule ID 307 //
     /* 2269 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule187Enabled),
     /* 2272 */   // MIs[0] dst
     /* 2272 */   // No operand predicates
     /* 2272 */   // MIs[0] x
     /* 2272 */   // No operand predicates
     /* 2272 */   // MIs[0] y
     /* 2272 */   // No operand predicates
     /* 2272 */   // Combiner Rule #187: srem_by_const
     /* 2272 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner121),
     /* 2275 */ // Label 156: @2275
     /* 2275 */ GIM_Reject,
     /* 2276 */ // Label 7: @2276
     /* 2276 */ GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(2287), // Rule ID 82 //
     /* 2281 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 2284 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_UREM'
     /* 2284 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 2287 */ // Label 157: @2287
     /* 2287 */ GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2298), // Rule ID 122 //
     /* 2292 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 2295 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_UREM'
     /* 2295 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 2298 */ // Label 158: @2298
     /* 2298 */ GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2309), // Rule ID 171 //
     /* 2303 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule129Enabled),
     /* 2306 */   // Combiner Rule #129: urem_pow2_to_mask; wip_match_opcode 'G_UREM'
     /* 2306 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner75),
     /* 2309 */ // Label 159: @2309
     /* 2309 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2320), // Rule ID 215 //
     /* 2314 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule154Enabled),
     /* 2317 */   // Combiner Rule #154: div_rem_to_divrem; wip_match_opcode 'G_UREM'
     /* 2317 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner95),
     /* 2320 */ // Label 160: @2320
     /* 2320 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2331), // Rule ID 248 //
     /* 2325 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2328 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UREM'
     /* 2328 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2331 */ // Label 161: @2331
     /* 2331 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2342), // Rule ID 289 //
     /* 2336 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2339 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UREM'
     /* 2339 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2342 */ // Label 162: @2342
     /* 2342 */ GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(2353), // Rule ID 306 //
     /* 2347 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule186Enabled),
     /* 2350 */   // MIs[0] dst
     /* 2350 */   // No operand predicates
     /* 2350 */   // MIs[0] x
     /* 2350 */   // No operand predicates
     /* 2350 */   // MIs[0] y
     /* 2350 */   // No operand predicates
     /* 2350 */   // Combiner Rule #186: urem_by_const
     /* 2350 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner120),
     /* 2353 */ // Label 163: @2353
     /* 2353 */ GIM_Reject,
     /* 2354 */ // Label 8: @2354
     /* 2354 */ GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(2365), // Rule ID 73 //
     /* 2359 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule69Enabled),
     /* 2362 */   // Combiner Rule #69: load_and_mask; wip_match_opcode 'G_AND'
     /* 2362 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner31),
     /* 2365 */ // Label 164: @2365
     /* 2365 */ GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(2376), // Rule ID 77 //
     /* 2370 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule72Enabled),
     /* 2373 */   // Combiner Rule #72: undef_to_int_zero; wip_match_opcode 'G_AND'
     /* 2373 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner34),
     /* 2376 */ // Label 165: @2376
     /* 2376 */ GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2387), // Rule ID 143 //
     /* 2381 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 2384 */   // Combiner Rule #105: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_AND'
     /* 2384 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2387 */ // Label 166: @2387
     /* 2387 */ GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2398), // Rule ID 163 //
     /* 2392 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule121Enabled),
     /* 2395 */   // Combiner Rule #121: narrow_binop_feeding_and; wip_match_opcode 'G_AND'
     /* 2395 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner68),
     /* 2398 */ // Label 167: @2398
     /* 2398 */ GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2409), // Rule ID 168 //
     /* 2403 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule126Enabled),
     /* 2406 */   // Combiner Rule #126: redundant_and; wip_match_opcode 'G_AND'
     /* 2406 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner72),
     /* 2409 */ // Label 168: @2409
     /* 2409 */ GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2420), // Rule ID 185 //
     /* 2414 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule143Enabled),
     /* 2417 */   // Combiner Rule #143: overlapping_and; wip_match_opcode 'G_AND'
     /* 2417 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner84),
     /* 2420 */ // Label 169: @2420
     /* 2420 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2431), // Rule ID 238 //
     /* 2425 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2428 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_AND'
     /* 2428 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2431 */ // Label 170: @2431
     /* 2431 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2442), // Rule ID 271 //
     /* 2436 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule176Enabled),
     /* 2439 */   // Combiner Rule #176: and_or_disjoint_mask; wip_match_opcode 'G_AND'
     /* 2439 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner110),
     /* 2442 */ // Label 171: @2442
     /* 2442 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2453), // Rule ID 283 //
     /* 2447 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2450 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_AND'
     /* 2450 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2453 */ // Label 172: @2453
     /* 2453 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2464), // Rule ID 317 //
     /* 2458 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 2461 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_AND'
     /* 2461 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2464 */ // Label 173: @2464
     /* 2464 */ GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2475), // Rule ID 344 //
     /* 2469 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule197Enabled),
     /* 2472 */   // Combiner Rule #197: match_ands; wip_match_opcode 'G_AND'
     /* 2472 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner129),
     /* 2475 */ // Label 174: @2475
     /* 2475 */ GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2573), // Rule ID 156 //
     /* 2480 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule114Enabled),
     /* 2483 */   // MIs[0] root
     /* 2483 */   // No operand predicates
     /* 2483 */   // MIs[0] d1
     /* 2483 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2487 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2491 */   // MIs[1] p
     /* 2491 */   // No operand predicates
     /* 2491 */   // MIs[1] s1
     /* 2491 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/255,
     /* 2495 */   // MIs[1] Operand 3
     /* 2495 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2499 */   // MIs[0] d2
     /* 2499 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2503 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2507 */   // MIs[2] p
     /* 2507 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2512 */   // MIs[2] s2
     /* 2512 */   // No operand predicates
     /* 2512 */   // MIs[2] Operand 3
     /* 2512 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2516 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner6),
     /* 2520 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2522 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/255,
     /* 2525 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 2535 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 2538 */   // Combiner Rule #114: double_icmp_zero_and_combine
     /* 2538 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 2541 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2546 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 2550 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 2554 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2558 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 2562 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 2566 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 2569 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 2572 */   GIR_EraseRootFromParent_Done,
     /* 2573 */ // Label 175: @2573
     /* 2573 */ GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2610), // Rule ID 231 //
     /* 2578 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule166Enabled),
     /* 2581 */   // MIs[0] root
     /* 2581 */   // No operand predicates
     /* 2581 */   // MIs[0] shift
     /* 2581 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2585 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2589 */   // MIs[1] x
     /* 2589 */   // No operand predicates
     /* 2589 */   // MIs[1] lsb
     /* 2589 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 2593 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2597 */   // MIs[2] imm1
     /* 2597 */   // No operand predicates
     /* 2597 */   // MIs[0] mask
     /* 2597 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /* 2601 */   GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 2605 */   // MIs[3] imm2
     /* 2605 */   // No operand predicates
     /* 2605 */   GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /* 2607 */   // Combiner Rule #166: bitfield_extract_from_and
     /* 2607 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner101),
     /* 2610 */ // Label 176: @2610
     /* 2610 */ GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2724), // Rule ID 378 //
     /* 2615 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule229Enabled),
     /* 2618 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 2621 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 2624 */   // MIs[0] dst
     /* 2624 */   // No operand predicates
     /* 2624 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner13),
     /* 2628 */   GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /* 2631 */   GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /* 2634 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /* 2637 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /* 2640 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /* 2643 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 2646 */   // Combiner Rule #229: combine_and_s64_with_s32_mask
     /* 2646 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 2649 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2654 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2659 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 2661 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 2665 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2670 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2675 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // y
     /* 2679 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::G_AND),
     /* 2683 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2688 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/0,
     /* 2691 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /* 2694 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::G_AND),
     /* 2698 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 2703 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/1,
     /* 2706 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /* 2709 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::G_MERGE_VALUES),
     /* 2713 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/0, // dst
     /* 2717 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /* 2720 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /* 2723 */   GIR_EraseRootFromParent_Done,
     /* 2724 */ // Label 177: @2724
     /* 2724 */ GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2748), // Rule ID 114 //
     /* 2729 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 2732 */   // MIs[0] dst
     /* 2732 */   // No operand predicates
     /* 2732 */   // MIs[0] src
     /* 2732 */   // No operand predicates
     /* 2732 */   // MIs[0] src
     /* 2732 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 2737 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2742 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[0]]
     /* 2742 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2747 */   GIR_EraseRootFromParent_Done,
     /* 2748 */ // Label 178: @2748
     /* 2748 */ GIM_Reject,
     /* 2749 */ // Label 9: @2749
     /* 2749 */ GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2760), // Rule ID 79 //
     /* 2754 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule73Enabled),
     /* 2757 */   // Combiner Rule #73: undef_to_negative_one; wip_match_opcode 'G_OR'
     /* 2757 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner35),
     /* 2760 */ // Label 179: @2760
     /* 2760 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2771), // Rule ID 144 //
     /* 2765 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 2768 */   // Combiner Rule #105: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_OR'
     /* 2768 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 2771 */ // Label 180: @2771
     /* 2771 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2782), // Rule ID 170 //
     /* 2776 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule128Enabled),
     /* 2779 */   // Combiner Rule #128: redundant_or; wip_match_opcode 'G_OR'
     /* 2779 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner74),
     /* 2782 */ // Label 181: @2782
     /* 2782 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2793), // Rule ID 211 //
     /* 2787 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule153Enabled),
     /* 2790 */   // Combiner Rule #153: load_or_combine; wip_match_opcode 'G_OR'
     /* 2790 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner94),
     /* 2793 */ // Label 182: @2793
     /* 2793 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2804), // Rule ID 216 //
     /* 2798 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule155Enabled),
     /* 2801 */   // Combiner Rule #155: funnel_shift_from_or_shift; wip_match_opcode 'G_OR'
     /* 2801 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner96),
     /* 2804 */ // Label 183: @2804
     /* 2804 */ GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2815), // Rule ID 242 //
     /* 2809 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 2812 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_OR'
     /* 2812 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 2815 */ // Label 184: @2815
     /* 2815 */ GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(2826), // Rule ID 284 //
     /* 2820 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 2823 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_OR'
     /* 2823 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 2826 */ // Label 185: @2826
     /* 2826 */ GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(2837), // Rule ID 318 //
     /* 2831 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 2834 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_OR'
     /* 2834 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 2837 */ // Label 186: @2837
     /* 2837 */ GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(2848), // Rule ID 345 //
     /* 2842 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule198Enabled),
     /* 2845 */   // Combiner Rule #198: match_ors; wip_match_opcode 'G_OR'
     /* 2845 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner130),
     /* 2848 */ // Label 187: @2848
     /* 2848 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(2895), // Rule ID 223 //
     /* 2853 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule160Enabled),
     /* 2856 */   // MIs[0] root
     /* 2856 */   // No operand predicates
     /* 2856 */   // MIs[0] out1
     /* 2856 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2860 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSHL),
     /* 2864 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 2864 */   // No operand predicates
     /* 2864 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.z
     /* 2864 */   // No operand predicates
     /* 2864 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 2864 */   // No operand predicates
     /* 2864 */   // MIs[0] out2
     /* 2864 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2868 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 2872 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 2872 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2877 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 2877 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 2882 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2887 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2889 */   // Combiner Rule #160: funnel_shift_or_shift_to_funnel_shift_left @ [__funnel_shift_or_shift_to_funnel_shift_left_match_0[0]]
     /* 2889 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2894 */   GIR_EraseRootFromParent_Done,
     /* 2895 */ // Label 188: @2895
     /* 2895 */ GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(2942), // Rule ID 225 //
     /* 2900 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule161Enabled),
     /* 2903 */   // MIs[0] root
     /* 2903 */   // No operand predicates
     /* 2903 */   // MIs[0] out1
     /* 2903 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2907 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSHR),
     /* 2911 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.z
     /* 2911 */   // No operand predicates
     /* 2911 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 2911 */   // No operand predicates
     /* 2911 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 2911 */   // No operand predicates
     /* 2911 */   // MIs[0] out2
     /* 2911 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2915 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2919 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 2919 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 2924 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 2924 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 2929 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2934 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2936 */   // Combiner Rule #161: funnel_shift_or_shift_to_funnel_shift_right @ [__funnel_shift_or_shift_to_funnel_shift_right_match_0[0]]
     /* 2936 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 2941 */   GIR_EraseRootFromParent_Done,
     /* 2942 */ // Label 189: @2942
     /* 2942 */ GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(3040), // Rule ID 157 //
     /* 2947 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule115Enabled),
     /* 2950 */   // MIs[0] root
     /* 2950 */   // No operand predicates
     /* 2950 */   // MIs[0] d1
     /* 2950 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2954 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2958 */   // MIs[1] p
     /* 2958 */   // No operand predicates
     /* 2958 */   // MIs[1] s1
     /* 2958 */   GIM_RecordRegType, /*MI*/1, /*Op*/2, /*TempTypeIdx*/255,
     /* 2962 */   // MIs[1] Operand 3
     /* 2962 */   GIM_CheckConstantInt8, /*MI*/1, /*Op*/3, 0,
     /* 2966 */   // MIs[0] d2
     /* 2966 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 2970 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 2974 */   // MIs[2] p
     /* 2974 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 2979 */   // MIs[2] s2
     /* 2979 */   // No operand predicates
     /* 2979 */   // MIs[2] Operand 3
     /* 2979 */   GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 0,
     /* 2983 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner7),
     /* 2987 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 2989 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/255,
     /* 2992 */   GIR_BuildConstant, /*TempRegID*/1, /*Val*/GIMT_Encode8(0),
     /* 3002 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/255,
     /* 3005 */   // Combiner Rule #115: double_icmp_zero_or_combine
     /* 3005 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 3008 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3013 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // s1
     /* 3017 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // s2
     /* 3021 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 3025 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/0, // root
     /* 3029 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // p
     /* 3033 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/0,
     /* 3036 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /* 3039 */   GIR_EraseRootFromParent_Done,
     /* 3040 */ // Label 190: @3040
     /* 3040 */ GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(3087), // Rule ID 226 //
     /* 3045 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule161Enabled),
     /* 3048 */   // MIs[0] root
     /* 3048 */   // No operand predicates
     /* 3048 */   // MIs[0] out2
     /* 3048 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3052 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 3056 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 3056 */   // No operand predicates
     /* 3056 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 3056 */   // No operand predicates
     /* 3056 */   // MIs[0] out1
     /* 3056 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 3060 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FSHR),
     /* 3064 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.z
     /* 3064 */   // No operand predicates
     /* 3064 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.x
     /* 3064 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 3069 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_right_match_0.y
     /* 3069 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 3074 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3079 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3081 */   // Combiner Rule #161: funnel_shift_or_shift_to_funnel_shift_right @ [__funnel_shift_or_shift_to_funnel_shift_right_match_0[1]]
     /* 3081 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3086 */   GIR_EraseRootFromParent_Done,
     /* 3087 */ // Label 191: @3087
     /* 3087 */ GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(3134), // Rule ID 224 //
     /* 3092 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule160Enabled),
     /* 3095 */   // MIs[0] root
     /* 3095 */   // No operand predicates
     /* 3095 */   // MIs[0] out2
     /* 3095 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3099 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 3103 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 3103 */   // No operand predicates
     /* 3103 */   // MIs[1] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 3103 */   // No operand predicates
     /* 3103 */   // MIs[0] out1
     /* 3103 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 3107 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_FSHL),
     /* 3111 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.x
     /* 3111 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /* 3116 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.z
     /* 3116 */   // No operand predicates
     /* 3116 */   // MIs[2] __funnel_shift_or_shift_to_funnel_shift_left_match_0.y
     /* 3116 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/2, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 3121 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3126 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 3128 */   // Combiner Rule #160: funnel_shift_or_shift_to_funnel_shift_left @ [__funnel_shift_or_shift_to_funnel_shift_left_match_0[1]]
     /* 3128 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /* 3133 */   GIR_EraseRootFromParent_Done,
     /* 3134 */ // Label 192: @3134
     /* 3134 */ GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(3248), // Rule ID 377 //
     /* 3139 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule228Enabled),
     /* 3142 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /* 3145 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 3148 */   // MIs[0] dst
     /* 3148 */   // No operand predicates
     /* 3148 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner13),
     /* 3152 */   GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_s32,
     /* 3155 */   GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s32,
     /* 3158 */   GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /* 3161 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
     /* 3164 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /* 3167 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /* 3170 */   // Combiner Rule #228: combine_or_s64_with_s32_mask
     /* 3170 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 3173 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3178 */   GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3183 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 3185 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::G_UNMERGE_VALUES),
     /* 3189 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3194 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3199 */   GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/2, // y
     /* 3203 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 3207 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3212 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/0,
     /* 3215 */   GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /* 3218 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::G_OR),
     /* 3222 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /* 3227 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/1,
     /* 3230 */   GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
     /* 3233 */   GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::G_MERGE_VALUES),
     /* 3237 */   GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/0, // dst
     /* 3241 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /* 3244 */   GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/5,
     /* 3247 */   GIR_EraseRootFromParent_Done,
     /* 3248 */ // Label 193: @3248
     /* 3248 */ GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(3272), // Rule ID 115 //
     /* 3253 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule85Enabled),
     /* 3256 */   // MIs[0] dst
     /* 3256 */   // No operand predicates
     /* 3256 */   // MIs[0] src
     /* 3256 */   // No operand predicates
     /* 3256 */   // MIs[0] src
     /* 3256 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 3261 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3266 */   // Combiner Rule #85: binop_same_val @ [__binop_same_val_match_0[1]]
     /* 3266 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3271 */   GIR_EraseRootFromParent_Done,
     /* 3272 */ // Label 194: @3272
     /* 3272 */ GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3295), // Rule ID 106 //
     /* 3277 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 3280 */   // MIs[0] dst
     /* 3280 */   // No operand predicates
     /* 3280 */   // MIs[0] lhs
     /* 3280 */   // No operand predicates
     /* 3280 */   // MIs[0] Operand 2
     /* 3280 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 3284 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3289 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[2]]
     /* 3289 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3294 */   GIR_EraseRootFromParent_Done,
     /* 3295 */ // Label 195: @3295
     /* 3295 */ GIM_Reject,
     /* 3296 */ // Label 10: @3296
     /* 3296 */ GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3307), // Rule ID 96 //
     /* 3301 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule78Enabled),
     /* 3304 */   // Combiner Rule #78: propagate_undef_any_op; wip_match_opcode 'G_XOR'
     /* 3304 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner39),
     /* 3307 */ // Label 196: @3307
     /* 3307 */ GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3318), // Rule ID 145 //
     /* 3312 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule105Enabled),
     /* 3315 */   // Combiner Rule #105: hoist_logic_op_with_same_opcode_hands; wip_match_opcode 'G_XOR'
     /* 3315 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner55),
     /* 3318 */ // Label 197: @3318
     /* 3318 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3329), // Rule ID 175 //
     /* 3323 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule133Enabled),
     /* 3326 */   // Combiner Rule #133: not_cmp_fold; wip_match_opcode 'G_XOR'
     /* 3326 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner79),
     /* 3329 */ // Label 198: @3329
     /* 3329 */ GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3340), // Rule ID 199 //
     /* 3334 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule149Enabled),
     /* 3337 */   // Combiner Rule #149: xor_of_and_with_same_reg; wip_match_opcode 'G_XOR'
     /* 3337 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner90),
     /* 3340 */ // Label 199: @3340
     /* 3340 */ GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3351), // Rule ID 245 //
     /* 3345 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 3348 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_XOR'
     /* 3348 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 3351 */ // Label 200: @3351
     /* 3351 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(3362), // Rule ID 285 //
     /* 3356 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 3359 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_XOR'
     /* 3359 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 3362 */ // Label 201: @3362
     /* 3362 */ GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3373), // Rule ID 319 //
     /* 3367 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 3370 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_XOR'
     /* 3370 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 3373 */ // Label 202: @3373
     /* 3373 */ GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3396), // Rule ID 107 //
     /* 3378 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 3381 */   // MIs[0] dst
     /* 3381 */   // No operand predicates
     /* 3381 */   // MIs[0] lhs
     /* 3381 */   // No operand predicates
     /* 3381 */   // MIs[0] Operand 2
     /* 3381 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 3385 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3390 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[3]]
     /* 3390 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3395 */   GIR_EraseRootFromParent_Done,
     /* 3396 */ // Label 203: @3396
     /* 3396 */ GIM_Reject,
     /* 3397 */ // Label 11: @3397
     /* 3397 */ GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3408), // Rule ID 141 //
     /* 3402 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule103Enabled),
     /* 3405 */   // Combiner Rule #103: extend_through_phis; wip_match_opcode 'G_PHI'
     /* 3405 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner53),
     /* 3408 */ // Label 204: @3408
     /* 3408 */ GIM_Reject,
     /* 3409 */ // Label 12: @3409
     /* 3409 */ GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(3420), // Rule ID 355 //
     /* 3414 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule208Enabled),
     /* 3417 */   // Combiner Rule #208: unmerge_anyext_build_vector; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3417 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner140),
     /* 3420 */ // Label 205: @3420
     /* 3420 */ GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(3431), // Rule ID 356 //
     /* 3425 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule209Enabled),
     /* 3428 */   // Combiner Rule #209: unmerge_merge; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3428 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner141),
     /* 3431 */ // Label 206: @3431
     /* 3431 */ GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(3442), // Rule ID 358 //
     /* 3436 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule211Enabled),
     /* 3439 */   // Combiner Rule #211: unmerge_cst; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3439 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner143),
     /* 3442 */ // Label 207: @3442
     /* 3442 */ GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(3453), // Rule ID 359 //
     /* 3447 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule212Enabled),
     /* 3450 */   // Combiner Rule #212: unmerge_undef; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3450 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner144),
     /* 3453 */ // Label 208: @3453
     /* 3453 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3464), // Rule ID 360 //
     /* 3458 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule213Enabled),
     /* 3461 */   // Combiner Rule #213: unmerge_dead_to_trunc; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3461 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner145),
     /* 3464 */ // Label 209: @3464
     /* 3464 */ GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3475), // Rule ID 361 //
     /* 3469 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule214Enabled),
     /* 3472 */   // Combiner Rule #214: unmerge_zext_to_zext; wip_match_opcode 'G_UNMERGE_VALUES'
     /* 3472 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner146),
     /* 3475 */ // Label 210: @3475
     /* 3475 */ GIM_Reject,
     /* 3476 */ // Label 13: @3476
     /* 3476 */ GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3487), // Rule ID 357 //
     /* 3481 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule210Enabled),
     /* 3484 */   // Combiner Rule #210: merge_unmerge; wip_match_opcode 'G_MERGE_VALUES'
     /* 3484 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner142),
     /* 3487 */ // Label 211: @3487
     /* 3487 */ GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3549),
     /* 3492 */   GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
     /* 3495 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(3516), // Rule ID 362 //
     /* 3500 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule215Enabled),
     /* 3503 */     // MIs[0] root
     /* 3503 */     // No operand predicates
     /* 3503 */     // MIs[0] x
     /* 3503 */     // No operand predicates
     /* 3503 */     // MIs[0] undef
     /* 3503 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3507 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3511 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3513 */     // Combiner Rule #215: merge_of_x_and_undef
     /* 3513 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner147),
     /* 3516 */   // Label 213: @3516
     /* 3516 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3548), // Rule ID 363 //
     /* 3521 */     GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule216Enabled),
     /* 3524 */     // MIs[0] root
     /* 3524 */     // No operand predicates
     /* 3524 */     // MIs[0] x
     /* 3524 */     // No operand predicates
     /* 3524 */     // MIs[0] zero
     /* 3524 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 3528 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 3532 */     // MIs[1] Operand 1
     /* 3532 */     GIM_CheckLiteralInt, /*MI*/1, /*Op*/1, GIMT_Encode8(0),
     /* 3543 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3545 */     // Combiner Rule #216: merge_of_x_and_zero
     /* 3545 */     GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner148),
     /* 3548 */   // Label 214: @3548
     /* 3548 */   GIM_Reject,
     /* 3549 */ // Label 212: @3549
     /* 3549 */ GIM_Reject,
     /* 3550 */ // Label 14: @3550
     /* 3550 */ GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3561), // Rule ID 69 //
     /* 3555 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule67Enabled),
     /* 3558 */   // Combiner Rule #67: extract_all_elts_from_build_vector; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3558 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner29),
     /* 3561 */ // Label 215: @3561
     /* 3561 */ GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(3572), // Rule ID 98 //
     /* 3566 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 3569 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3569 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 3572 */ // Label 216: @3572
     /* 3572 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3583), // Rule ID 133 //
     /* 3577 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3580 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR'
     /* 3580 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3583 */ // Label 217: @3583
     /* 3583 */ GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3597), // Rule ID 354 //
     /* 3588 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule207Enabled),
     /* 3591 */   GIM_CheckNumOperandsGE, /*MI*/0, /*Expected*/2,
     /* 3594 */   // MIs[0] dst
     /* 3594 */   // No operand predicates
     /* 3594 */   // MIs[0] unused
     /* 3594 */   // No operand predicates
     /* 3594 */   // Combiner Rule #207: combine_use_vector_truncate
     /* 3594 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner139),
     /* 3597 */ // Label 218: @3597
     /* 3597 */ GIM_Reject,
     /* 3598 */ // Label 15: @3598
     /* 3598 */ GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3609), // Rule ID 132 //
     /* 3603 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule95Enabled),
     /* 3606 */   // Combiner Rule #95: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR_TRUNC'
     /* 3606 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner49),
     /* 3609 */ // Label 219: @3609
     /* 3609 */ GIM_Reject,
     /* 3610 */ // Label 16: @3610
     /* 3610 */ GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3621), // Rule ID 347 //
     /* 3615 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule200Enabled),
     /* 3618 */   // Combiner Rule #200: combine_concat_vector; wip_match_opcode 'G_CONCAT_VECTORS'
     /* 3618 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner132),
     /* 3621 */ // Label 220: @3621
     /* 3621 */ GIM_Reject,
     /* 3622 */ // Label 17: @3622
     /* 3622 */ GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3643), // Rule ID 125 //
     /* 3627 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule89Enabled),
     /* 3630 */   // MIs[0] dst
     /* 3630 */   // No operand predicates
     /* 3630 */   // MIs[0] t
     /* 3630 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3634 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTTOPTR),
     /* 3638 */   // MIs[1] ptr
     /* 3638 */   // No operand predicates
     /* 3638 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3640 */   // Combiner Rule #89: i2p_to_p2i
     /* 3640 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner47),
     /* 3643 */ // Label 221: @3643
     /* 3643 */ GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3664), // Rule ID 90 //
     /* 3648 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3651 */   // MIs[0] dst
     /* 3651 */   // No operand predicates
     /* 3651 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3651 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3655 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3659 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3661 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[3]]
     /* 3661 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3664 */ // Label 222: @3664
     /* 3664 */ GIM_Reject,
     /* 3665 */ // Label 18: @3665
     /* 3665 */ GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3676), // Rule ID 124 //
     /* 3670 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule88Enabled),
     /* 3673 */   // Combiner Rule #88: p2i_to_i2p; wip_match_opcode 'G_INTTOPTR'
     /* 3673 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner46),
     /* 3676 */ // Label 223: @3676
     /* 3676 */ GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3697), // Rule ID 91 //
     /* 3681 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3684 */   // MIs[0] dst
     /* 3684 */   // No operand predicates
     /* 3684 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3684 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3688 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3692 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3694 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[4]]
     /* 3694 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3697 */ // Label 224: @3697
     /* 3697 */ GIM_Reject,
     /* 3698 */ // Label 19: @3698
     /* 3698 */ GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(3719), // Rule ID 136 //
     /* 3703 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule98Enabled),
     /* 3706 */   // MIs[0] dst
     /* 3706 */   // No operand predicates
     /* 3706 */   // MIs[0] src1
     /* 3706 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3710 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /* 3714 */   // MIs[1] src0
     /* 3714 */   // No operand predicates
     /* 3714 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3716 */   // Combiner Rule #98: bitcast_bitcast_fold
     /* 3716 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 3719 */ // Label 225: @3719
     /* 3719 */ GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(3740), // Rule ID 88 //
     /* 3724 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3727 */   // MIs[0] dst
     /* 3727 */   // No operand predicates
     /* 3727 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3727 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3731 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3735 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3737 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[1]]
     /* 3737 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3740 */ // Label 226: @3740
     /* 3740 */ GIM_Reject,
     /* 3741 */ // Label 20: @3741
     /* 3741 */ GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(3770), // Rule ID 18 //
     /* 3746 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 3749 */   // MIs[0] dst
     /* 3749 */   // No operand predicates
     /* 3749 */   // MIs[0] src
     /* 3749 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3753 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREEZE),
     /* 3757 */   // MIs[1] __idempotent_prop_match_0.x
     /* 3757 */   // No operand predicates
     /* 3757 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3762 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3764 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[0]]
     /* 3764 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3769 */   GIR_EraseRootFromParent_Done,
     /* 3770 */ // Label 227: @3770
     /* 3770 */ GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(3793), // Rule ID 43 //
     /* 3775 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule41Enabled),
     /* 3778 */   // MIs[0] root
     /* 3778 */   // No operand predicates
     /* 3778 */   // MIs[0] src
     /* 3778 */   // No operand predicates
     /* 3778 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner1),
     /* 3782 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3787 */   // Combiner Rule #41: freeze_of_non_undef_non_poison
     /* 3787 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 3792 */   GIR_EraseRootFromParent_Done,
     /* 3793 */ // Label 228: @3793
     /* 3793 */ GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(3804), // Rule ID 44 //
     /* 3798 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule42Enabled),
     /* 3801 */   // MIs[0] dst
     /* 3801 */   // No operand predicates
     /* 3801 */   // MIs[0] src
     /* 3801 */   // No operand predicates
     /* 3801 */   // Combiner Rule #42: push_freeze_to_prevent_poison_from_propagating
     /* 3801 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner19),
     /* 3804 */ // Label 229: @3804
     /* 3804 */ GIM_Reject,
     /* 3805 */ // Label 21: @3805
     /* 3805 */ GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(3816), // Rule ID 70 //
     /* 3810 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3813 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_LOAD'
     /* 3813 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3816 */ // Label 230: @3816
     /* 3816 */ GIM_Reject,
     /* 3817 */ // Label 22: @3817
     /* 3817 */ GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(3828), // Rule ID 71 //
     /* 3822 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3825 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_SEXTLOAD'
     /* 3825 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3828 */ // Label 231: @3828
     /* 3828 */ GIM_Reject,
     /* 3829 */ // Label 23: @3829
     /* 3829 */ GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(3840), // Rule ID 72 //
     /* 3834 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule68Enabled),
     /* 3837 */   // Combiner Rule #68: extending_loads; wip_match_opcode 'G_ZEXTLOAD'
     /* 3837 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner30),
     /* 3840 */ // Label 232: @3840
     /* 3840 */ GIM_Reject,
     /* 3841 */ // Label 24: @3841
     /* 3841 */ GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(3852), // Rule ID 100 //
     /* 3846 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule81Enabled),
     /* 3849 */   // Combiner Rule #81: erase_undef_store; wip_match_opcode 'G_STORE'
     /* 3849 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner42),
     /* 3852 */ // Label 233: @3852
     /* 3852 */ GIM_Reject,
     /* 3853 */ // Label 25: @3853
     /* 3853 */ GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(3864), // Rule ID 126 //
     /* 3858 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule90Enabled),
     /* 3861 */   // Combiner Rule #90: anyext_trunc_fold; wip_match_opcode 'G_ANYEXT'
     /* 3861 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner48),
     /* 3864 */ // Label 234: @3864
     /* 3864 */ GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(3875), // Rule ID 262 //
     /* 3869 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 3872 */   // Combiner Rule #172: constant_fold_cast_op; wip_match_opcode 'G_ANYEXT'
     /* 3872 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 3875 */ // Label 235: @3875
     /* 3875 */ GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(3896), // Rule ID 57 //
     /* 3880 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule55Enabled),
     /* 3883 */   // MIs[0] root
     /* 3883 */   // No operand predicates
     /* 3883 */   // MIs[0] select
     /* 3883 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3887 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 3891 */   // MIs[1] cond
     /* 3891 */   // No operand predicates
     /* 3891 */   // MIs[1] true
     /* 3891 */   // No operand predicates
     /* 3891 */   // MIs[1] false
     /* 3891 */   // No operand predicates
     /* 3891 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3893 */   // Combiner Rule #55: select_of_anyext
     /* 3893 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 3896 */ // Label 236: @3896
     /* 3896 */ GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(3917), // Rule ID 52 //
     /* 3901 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule50Enabled),
     /* 3904 */   // MIs[0] root
     /* 3904 */   // No operand predicates
     /* 3904 */   // MIs[0] second
     /* 3904 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3908 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 3912 */   // MIs[1] src
     /* 3912 */   // No operand predicates
     /* 3912 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3914 */   // Combiner Rule #50: anyext_of_anyext
     /* 3914 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3917 */ // Label 237: @3917
     /* 3917 */ GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(3938), // Rule ID 54 //
     /* 3922 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule52Enabled),
     /* 3925 */   // MIs[0] root
     /* 3925 */   // No operand predicates
     /* 3925 */   // MIs[0] second
     /* 3925 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3929 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 3933 */   // MIs[1] src
     /* 3933 */   // No operand predicates
     /* 3933 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3935 */   // Combiner Rule #52: anyext_of_sext
     /* 3935 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3938 */ // Label 238: @3938
     /* 3938 */ GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(3959), // Rule ID 53 //
     /* 3943 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule51Enabled),
     /* 3946 */   // MIs[0] root
     /* 3946 */   // No operand predicates
     /* 3946 */   // MIs[0] second
     /* 3946 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3950 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 3954 */   // MIs[1] src
     /* 3954 */   // No operand predicates
     /* 3954 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3956 */   // Combiner Rule #51: anyext_of_zext
     /* 3956 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 3959 */ // Label 239: @3959
     /* 3959 */ GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(3980), // Rule ID 89 //
     /* 3964 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 3967 */   // MIs[0] dst
     /* 3967 */   // No operand predicates
     /* 3967 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 3967 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3971 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 3975 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3977 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[2]]
     /* 3977 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 3980 */ // Label 240: @3980
     /* 3980 */ GIM_Reject,
     /* 3981 */ // Label 26: @3981
     /* 3981 */ GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(3992), // Rule ID 134 //
     /* 3986 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule96Enabled),
     /* 3989 */   // Combiner Rule #96: trunc_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 3989 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner50),
     /* 3992 */ // Label 241: @3992
     /* 3992 */ GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(4003), // Rule ID 135 //
     /* 3997 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule97Enabled),
     /* 4000 */   // Combiner Rule #97: trunc_lshr_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 4000 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner51),
     /* 4003 */ // Label 242: @4003
     /* 4003 */ GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(4014), // Rule ID 174 //
     /* 4008 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule132Enabled),
     /* 4011 */   // Combiner Rule #132: trunc_shift; wip_match_opcode 'G_TRUNC'
     /* 4011 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner78),
     /* 4014 */ // Label 243: @4014
     /* 4014 */ GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(4025), // Rule ID 374 //
     /* 4019 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule225Enabled),
     /* 4022 */   // Combiner Rule #225: clamp_i64_to_i16; wip_match_opcode 'G_TRUNC'
     /* 4022 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner155),
     /* 4025 */ // Label 244: @4025
     /* 4025 */ GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(4046), // Rule ID 58 //
     /* 4030 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule56Enabled),
     /* 4033 */   // MIs[0] root
     /* 4033 */   // No operand predicates
     /* 4033 */   // MIs[0] select
     /* 4033 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4037 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 4041 */   // MIs[1] cond
     /* 4041 */   // No operand predicates
     /* 4041 */   // MIs[1] true
     /* 4041 */   // No operand predicates
     /* 4041 */   // MIs[1] false
     /* 4041 */   // No operand predicates
     /* 4041 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4043 */   // Combiner Rule #56: select_of_truncate
     /* 4043 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 4046 */ // Label 245: @4046
     /* 4046 */ GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(4075), // Rule ID 60 //
     /* 4051 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule58Enabled),
     /* 4054 */   // MIs[0] root
     /* 4054 */   // No operand predicates
     /* 4054 */   // MIs[0] binop
     /* 4054 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4058 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 4062 */   // MIs[1] x
     /* 4062 */   // No operand predicates
     /* 4062 */   // MIs[1] const
     /* 4062 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4066 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4070 */   // MIs[2] imm
     /* 4070 */   // No operand predicates
     /* 4070 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4072 */   // Combiner Rule #58: narrow_binop_add
     /* 4072 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4075 */ // Label 246: @4075
     /* 4075 */ GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(4104), // Rule ID 63 //
     /* 4080 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule61Enabled),
     /* 4083 */   // MIs[0] root
     /* 4083 */   // No operand predicates
     /* 4083 */   // MIs[0] binop
     /* 4083 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4087 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 4091 */   // MIs[1] x
     /* 4091 */   // No operand predicates
     /* 4091 */   // MIs[1] const
     /* 4091 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4095 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4099 */   // MIs[2] imm
     /* 4099 */   // No operand predicates
     /* 4099 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4101 */   // Combiner Rule #61: narrow_binop_and
     /* 4101 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4104 */ // Label 247: @4104
     /* 4104 */ GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(4133), // Rule ID 62 //
     /* 4109 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule60Enabled),
     /* 4112 */   // MIs[0] root
     /* 4112 */   // No operand predicates
     /* 4112 */   // MIs[0] binop
     /* 4112 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4116 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /* 4120 */   // MIs[1] x
     /* 4120 */   // No operand predicates
     /* 4120 */   // MIs[1] const
     /* 4120 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4124 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4128 */   // MIs[2] imm
     /* 4128 */   // No operand predicates
     /* 4128 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4130 */   // Combiner Rule #60: narrow_binop_mul
     /* 4130 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4133 */ // Label 248: @4133
     /* 4133 */ GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(4162), // Rule ID 64 //
     /* 4138 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule62Enabled),
     /* 4141 */   // MIs[0] root
     /* 4141 */   // No operand predicates
     /* 4141 */   // MIs[0] binop
     /* 4141 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4145 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /* 4149 */   // MIs[1] x
     /* 4149 */   // No operand predicates
     /* 4149 */   // MIs[1] const
     /* 4149 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4153 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4157 */   // MIs[2] imm
     /* 4157 */   // No operand predicates
     /* 4157 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4159 */   // Combiner Rule #62: narrow_binop_or
     /* 4159 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4162 */ // Label 249: @4162
     /* 4162 */ GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(4191), // Rule ID 61 //
     /* 4167 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule59Enabled),
     /* 4170 */   // MIs[0] root
     /* 4170 */   // No operand predicates
     /* 4170 */   // MIs[0] binop
     /* 4170 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4174 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 4178 */   // MIs[1] x
     /* 4178 */   // No operand predicates
     /* 4178 */   // MIs[1] const
     /* 4178 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4182 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4186 */   // MIs[2] imm
     /* 4186 */   // No operand predicates
     /* 4186 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4188 */   // Combiner Rule #59: narrow_binop_sub
     /* 4188 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4191 */ // Label 250: @4191
     /* 4191 */ GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(4223), // Rule ID 370 //
     /* 4196 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule221Enabled),
     /* 4199 */   // MIs[0] dst
     /* 4199 */   // No operand predicates
     /* 4199 */   // MIs[0] min
     /* 4199 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4203 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UMIN),
     /* 4207 */   // MIs[1] x
     /* 4207 */   // No operand predicates
     /* 4207 */   // MIs[1] y
     /* 4207 */   // No operand predicates
     /* 4207 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner11),
     /* 4211 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4213 */   // Combiner Rule #221: trunc_usatu
     /* 4213 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_TRUNC_USAT_U),
     /* 4216 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 4218 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 4222 */   GIR_EraseRootFromParent_Done,
     /* 4223 */ // Label 251: @4223
     /* 4223 */ GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(4252), // Rule ID 65 //
     /* 4228 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule63Enabled),
     /* 4231 */   // MIs[0] root
     /* 4231 */   // No operand predicates
     /* 4231 */   // MIs[0] binop
     /* 4231 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4235 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /* 4239 */   // MIs[1] x
     /* 4239 */   // No operand predicates
     /* 4239 */   // MIs[1] const
     /* 4239 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /* 4243 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4247 */   // MIs[2] imm
     /* 4247 */   // No operand predicates
     /* 4247 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4249 */   // Combiner Rule #63: narrow_binop_xor
     /* 4249 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner25),
     /* 4252 */ // Label 252: @4252
     /* 4252 */ GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(4273), // Rule ID 47 //
     /* 4257 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule45Enabled),
     /* 4260 */   // MIs[0] root
     /* 4260 */   // No operand predicates
     /* 4260 */   // MIs[0] ext
     /* 4260 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4264 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4268 */   // MIs[1] src
     /* 4268 */   // No operand predicates
     /* 4268 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4270 */   // Combiner Rule #45: truncate_of_anyext
     /* 4270 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 4273 */ // Label 253: @4273
     /* 4273 */ GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(4297), // Rule ID 59 //
     /* 4278 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule57Enabled),
     /* 4281 */   // MIs[0] root
     /* 4281 */   // No operand predicates
     /* 4281 */   // MIs[0] bv
     /* 4281 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4285 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 4289 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 4292 */   // MIs[1] unused
     /* 4292 */   // No operand predicates
     /* 4292 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4294 */   // Combiner Rule #57: buildvector_of_truncate
     /* 4294 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner24),
     /* 4297 */ // Label 254: @4297
     /* 4297 */ GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(4318), // Rule ID 46 //
     /* 4302 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule44Enabled),
     /* 4305 */   // MIs[0] root
     /* 4305 */   // No operand predicates
     /* 4305 */   // MIs[0] ext
     /* 4305 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4309 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 4313 */   // MIs[1] src
     /* 4313 */   // No operand predicates
     /* 4313 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4315 */   // Combiner Rule #44: truncate_of_sext
     /* 4315 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 4318 */ // Label 255: @4318
     /* 4318 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(4339), // Rule ID 45 //
     /* 4323 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule43Enabled),
     /* 4326 */   // MIs[0] root
     /* 4326 */   // No operand predicates
     /* 4326 */   // MIs[0] ext
     /* 4326 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4330 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 4334 */   // MIs[1] src
     /* 4334 */   // No operand predicates
     /* 4334 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4336 */   // Combiner Rule #43: truncate_of_zext
     /* 4336 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner20),
     /* 4339 */ // Label 256: @4339
     /* 4339 */ GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(4360), // Rule ID 87 //
     /* 4344 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 4347 */   // MIs[0] dst
     /* 4347 */   // No operand predicates
     /* 4347 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 4347 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4351 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 4355 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4357 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[0]]
     /* 4357 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 4360 */ // Label 257: @4360
     /* 4360 */ GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(4381), // Rule ID 66 //
     /* 4365 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule64Enabled),
     /* 4368 */   // MIs[0] root
     /* 4368 */   // No operand predicates
     /* 4368 */   // MIs[0] int
     /* 4368 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4372 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4376 */   // MIs[1] imm
     /* 4376 */   // No operand predicates
     /* 4376 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4378 */   // Combiner Rule #64: integer_of_truncate
     /* 4378 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner26),
     /* 4381 */ // Label 258: @4381
     /* 4381 */ GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(4392), // Rule ID 368 //
     /* 4386 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule219Enabled),
     /* 4389 */   // MIs[0] dst
     /* 4389 */   // No operand predicates
     /* 4389 */   // MIs[0] src
     /* 4389 */   // No operand predicates
     /* 4389 */   // Combiner Rule #219: trunc_ssats
     /* 4389 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner151),
     /* 4392 */ // Label 259: @4392
     /* 4392 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(4403), // Rule ID 369 //
     /* 4397 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule220Enabled),
     /* 4400 */   // MIs[0] dst
     /* 4400 */   // No operand predicates
     /* 4400 */   // MIs[0] src
     /* 4400 */   // No operand predicates
     /* 4400 */   // Combiner Rule #220: trunc_ssatu
     /* 4400 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner152),
     /* 4403 */ // Label 260: @4403
     /* 4403 */ GIM_Reject,
     /* 4404 */ // Label 27: @4404
     /* 4404 */ GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(4436), // Rule ID 371 //
     /* 4409 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule222Enabled),
     /* 4412 */   // MIs[0] dst
     /* 4412 */   // No operand predicates
     /* 4412 */   // MIs[0] src
     /* 4412 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4416 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPTOUI),
     /* 4420 */   // MIs[1] x
     /* 4420 */   // No operand predicates
     /* 4420 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner12),
     /* 4424 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4426 */   // Combiner Rule #222: truncusatu_to_fptouisat
     /* 4426 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FPTOUI_SAT),
     /* 4429 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 4431 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 4435 */   GIR_EraseRootFromParent_Done,
     /* 4436 */ // Label 261: @4436
     /* 4436 */ GIM_Reject,
     /* 4437 */ // Label 28: @4437
     /* 4437 */ GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(4448), // Rule ID 261 //
     /* 4442 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 4445 */   // Combiner Rule #172: constant_fold_cast_op; wip_match_opcode 'G_SEXT'
     /* 4445 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 4448 */ // Label 262: @4448
     /* 4448 */ GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(4469), // Rule ID 51 //
     /* 4453 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule49Enabled),
     /* 4456 */   // MIs[0] root
     /* 4456 */   // No operand predicates
     /* 4456 */   // MIs[0] second
     /* 4456 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4460 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4464 */   // MIs[1] src
     /* 4464 */   // No operand predicates
     /* 4464 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4466 */   // Combiner Rule #49: sext_of_anyext
     /* 4466 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4469 */ // Label 263: @4469
     /* 4469 */ GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(4490), // Rule ID 50 //
     /* 4474 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule48Enabled),
     /* 4477 */   // MIs[0] root
     /* 4477 */   // No operand predicates
     /* 4477 */   // MIs[0] second
     /* 4477 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4481 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /* 4485 */   // MIs[1] src
     /* 4485 */   // No operand predicates
     /* 4485 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4487 */   // Combiner Rule #48: sext_of_sext
     /* 4487 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4490 */ // Label 264: @4490
     /* 4490 */ GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(4511), // Rule ID 348 //
     /* 4495 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule201Enabled),
     /* 4498 */   // MIs[0] root
     /* 4498 */   // No operand predicates
     /* 4498 */   // MIs[0] src
     /* 4498 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4502 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4506 */   // MIs[1] x
     /* 4506 */   // No operand predicates
     /* 4506 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4508 */   // Combiner Rule #201: sext_trunc
     /* 4508 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner133),
     /* 4511 */ // Label 265: @4511
     /* 4511 */ GIM_Reject,
     /* 4512 */ // Label 29: @4512
     /* 4512 */ GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(4523), // Rule ID 161 //
     /* 4517 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule119Enabled),
     /* 4520 */   // Combiner Rule #119: sext_inreg_of_load; wip_match_opcode 'G_SEXT_INREG'
     /* 4520 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner66),
     /* 4523 */ // Label 266: @4523
     /* 4523 */ GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(4534), // Rule ID 169 //
     /* 4528 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule127Enabled),
     /* 4531 */   // Combiner Rule #127: redundant_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4531 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner73),
     /* 4534 */ // Label 267: @4534
     /* 4534 */ GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(4545), // Rule ID 230 //
     /* 4539 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule165Enabled),
     /* 4542 */   // Combiner Rule #165: bitfield_extract_from_sext_inreg; wip_match_opcode 'G_SEXT_INREG'
     /* 4542 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner100),
     /* 4545 */ // Label 268: @4545
     /* 4545 */ GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(4566), // Rule ID 55 //
     /* 4550 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule53Enabled),
     /* 4553 */   // MIs[0] dst
     /* 4553 */   // No operand predicates
     /* 4553 */   // MIs[0] x
     /* 4553 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4557 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /* 4561 */   // MIs[1] src
     /* 4561 */   // No operand predicates
     /* 4561 */   // MIs[1] a
     /* 4561 */   // No operand predicates
     /* 4561 */   // MIs[0] b
     /* 4561 */   // No operand predicates
     /* 4561 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4563 */   // Combiner Rule #53: sext_inreg_of_sext_inreg
     /* 4563 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner22),
     /* 4566 */ // Label 269: @4566
     /* 4566 */ GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(4577), // Rule ID 173 //
     /* 4571 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule131Enabled),
     /* 4574 */   // MIs[0] dst
     /* 4574 */   // No operand predicates
     /* 4574 */   // MIs[0] src
     /* 4574 */   // No operand predicates
     /* 4574 */   // MIs[0] imm
     /* 4574 */   // No operand predicates
     /* 4574 */   // Combiner Rule #131: sext_inreg_to_zext_inreg
     /* 4574 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner77),
     /* 4577 */ // Label 270: @4577
     /* 4577 */ GIM_Reject,
     /* 4578 */ // Label 30: @4578
     /* 4578 */ GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(4589), // Rule ID 172 //
     /* 4583 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule130Enabled),
     /* 4586 */   // Combiner Rule #130: zext_trunc_fold; wip_match_opcode 'G_ZEXT'
     /* 4586 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner76),
     /* 4589 */ // Label 271: @4589
     /* 4589 */ GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(4600), // Rule ID 260 //
     /* 4594 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule172Enabled),
     /* 4597 */   // Combiner Rule #172: constant_fold_cast_op; wip_match_opcode 'G_ZEXT'
     /* 4597 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner107),
     /* 4600 */ // Label 272: @4600
     /* 4600 */ GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(4621), // Rule ID 56 //
     /* 4605 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule54Enabled),
     /* 4608 */   // MIs[0] root
     /* 4608 */   // No operand predicates
     /* 4608 */   // MIs[0] select
     /* 4608 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4612 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 4616 */   // MIs[1] cond
     /* 4616 */   // No operand predicates
     /* 4616 */   // MIs[1] true
     /* 4616 */   // No operand predicates
     /* 4616 */   // MIs[1] false
     /* 4616 */   // No operand predicates
     /* 4616 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4618 */   // Combiner Rule #54: select_of_zext
     /* 4618 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner23),
     /* 4621 */ // Label 273: @4621
     /* 4621 */ GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(4642), // Rule ID 49 //
     /* 4626 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule47Enabled),
     /* 4629 */   // MIs[0] root
     /* 4629 */   // No operand predicates
     /* 4629 */   // MIs[0] second
     /* 4629 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4633 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /* 4637 */   // MIs[1] src
     /* 4637 */   // No operand predicates
     /* 4637 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4639 */   // Combiner Rule #47: zext_of_anyext
     /* 4639 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4642 */ // Label 274: @4642
     /* 4642 */ GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(4669), // Rule ID 349 //
     /* 4647 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule202Enabled),
     /* 4650 */   // MIs[0] root
     /* 4650 */   // No operand predicates
     /* 4650 */   // MIs[0] src
     /* 4650 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4654 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4658 */   GIM_MIFlags, /*MI*/1, GIMT_Encode4(MachineInstr::NoUWrap),
     /* 4664 */   // MIs[1] x
     /* 4664 */   // No operand predicates
     /* 4664 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4666 */   // Combiner Rule #202: zext_trunc
     /* 4666 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner134),
     /* 4669 */ // Label 275: @4669
     /* 4669 */ GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(4690), // Rule ID 48 //
     /* 4674 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule46Enabled),
     /* 4677 */   // MIs[0] root
     /* 4677 */   // No operand predicates
     /* 4677 */   // MIs[0] second
     /* 4677 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4681 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /* 4685 */   // MIs[1] src
     /* 4685 */   // No operand predicates
     /* 4685 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 4687 */   // Combiner Rule #46: zext_of_zext
     /* 4687 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner21),
     /* 4690 */ // Label 276: @4690
     /* 4690 */ GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(4707), // Rule ID 350 //
     /* 4695 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule203Enabled),
     /* 4698 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NonNeg),
     /* 4704 */   // MIs[0] root
     /* 4704 */   // No operand predicates
     /* 4704 */   // MIs[0] x
     /* 4704 */   // No operand predicates
     /* 4704 */   // Combiner Rule #203: nneg_zext
     /* 4704 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner135),
     /* 4707 */ // Label 277: @4707
     /* 4707 */ GIM_Reject,
     /* 4708 */ // Label 31: @4708
     /* 4708 */ GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(4719), // Rule ID 80 //
     /* 4713 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule74Enabled),
     /* 4716 */   // Combiner Rule #74: binop_left_undef_to_zero; wip_match_opcode 'G_SHL'
     /* 4716 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 4719 */ // Label 278: @4719
     /* 4719 */ GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(4730), // Rule ID 83 //
     /* 4724 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4727 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_SHL'
     /* 4727 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4730 */ // Label 279: @4730
     /* 4730 */ GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(4741), // Rule ID 116 //
     /* 4735 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4738 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_SHL'
     /* 4738 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4741 */ // Label 280: @4741
     /* 4741 */ GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(4752), // Rule ID 201 //
     /* 4746 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4749 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_SHL'
     /* 4749 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4752 */ // Label 281: @4752
     /* 4752 */ GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(4763), // Rule ID 206 //
     /* 4757 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 4760 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_SHL'
     /* 4760 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4763 */ // Label 282: @4763
     /* 4763 */ GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(4774), // Rule ID 229 //
     /* 4768 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule164Enabled),
     /* 4771 */   // Combiner Rule #164: commute_shift; wip_match_opcode 'G_SHL'
     /* 4771 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner99),
     /* 4774 */ // Label 283: @4774
     /* 4774 */ GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(4785), // Rule ID 243 //
     /* 4779 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 4782 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SHL'
     /* 4782 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4785 */ // Label 284: @4785
     /* 4785 */ GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(4796), // Rule ID 292 //
     /* 4790 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 4793 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SHL'
     /* 4793 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4796 */ // Label 285: @4796
     /* 4796 */ GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(4831), // Rule ID 41 //
     /* 4801 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule39Enabled),
     /* 4804 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::NoSWrap),
     /* 4810 */   // MIs[0] root
     /* 4810 */   // No operand predicates
     /* 4810 */   // MIs[0] left
     /* 4810 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4814 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VSCALE),
     /* 4818 */   // MIs[1] imm
     /* 4818 */   // No operand predicates
     /* 4818 */   // MIs[0] x
     /* 4818 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 4822 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 4826 */   // MIs[2] imm1
     /* 4826 */   // No operand predicates
     /* 4826 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4828 */   // Combiner Rule #39: shl_of_vscale
     /* 4828 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner17),
     /* 4831 */ // Label 286: @4831
     /* 4831 */ GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(4854), // Rule ID 108 //
     /* 4836 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 4839 */   // MIs[0] dst
     /* 4839 */   // No operand predicates
     /* 4839 */   // MIs[0] lhs
     /* 4839 */   // No operand predicates
     /* 4839 */   // MIs[0] Operand 2
     /* 4839 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 4843 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4848 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[4]]
     /* 4848 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 4853 */   GIR_EraseRootFromParent_Done,
     /* 4854 */ // Label 287: @4854
     /* 4854 */ GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(4865), // Rule ID 146 //
     /* 4859 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 4862 */   // MIs[0] root
     /* 4862 */   // No operand predicates
     /* 4862 */   // MIs[0] mi.shifted
     /* 4862 */   // No operand predicates
     /* 4862 */   // MIs[0] mi.amt
     /* 4862 */   // No operand predicates
     /* 4862 */   // Combiner Rule #106: shifts_too_big @ [mi[0]]
     /* 4862 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 4865 */ // Label 288: @4865
     /* 4865 */ GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(4876), // Rule ID 162 //
     /* 4870 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule120Enabled),
     /* 4873 */   // MIs[0] dst
     /* 4873 */   // No operand predicates
     /* 4873 */   // MIs[0] src0
     /* 4873 */   // No operand predicates
     /* 4873 */   // MIs[0] src1
     /* 4873 */   // No operand predicates
     /* 4873 */   // Combiner Rule #120: reduce_shl_of_extend
     /* 4873 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner67),
     /* 4876 */ // Label 289: @4876
     /* 4876 */ GIM_Reject,
     /* 4877 */ // Label 32: @4877
     /* 4877 */ GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(4888), // Rule ID 85 //
     /* 4882 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 4885 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_LSHR'
     /* 4885 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 4888 */ // Label 290: @4888
     /* 4888 */ GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(4899), // Rule ID 117 //
     /* 4893 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 4896 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_LSHR'
     /* 4896 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 4899 */ // Label 291: @4899
     /* 4899 */ GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(4910), // Rule ID 203 //
     /* 4904 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 4907 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_LSHR'
     /* 4907 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 4910 */ // Label 292: @4910
     /* 4910 */ GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(4921), // Rule ID 208 //
     /* 4915 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 4918 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_LSHR'
     /* 4918 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 4921 */ // Label 293: @4921
     /* 4921 */ GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(4932), // Rule ID 233 //
     /* 4926 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 4929 */   // Combiner Rule #167: bitfield_extract_from_shr; wip_match_opcode 'G_LSHR'
     /* 4929 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 4932 */ // Label 294: @4932
     /* 4932 */ GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(4943), // Rule ID 235 //
     /* 4937 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 4940 */   // Combiner Rule #168: bitfield_extract_from_shr_and; wip_match_opcode 'G_LSHR'
     /* 4940 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 4943 */ // Label 295: @4943
     /* 4943 */ GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(4954), // Rule ID 240 //
     /* 4948 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 4951 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_LSHR'
     /* 4951 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 4954 */ // Label 296: @4954
     /* 4954 */ GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(4965), // Rule ID 290 //
     /* 4959 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 4962 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_LSHR'
     /* 4962 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 4965 */ // Label 297: @4965
     /* 4965 */ GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(4994), // Rule ID 372 //
     /* 4970 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule223Enabled),
     /* 4973 */   // MIs[0] dst
     /* 4973 */   // No operand predicates
     /* 4973 */   // MIs[0] d2
     /* 4973 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 4977 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /* 4981 */   // MIs[1] d1
     /* 4981 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 4985 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 4989 */   // MIs[2] x
     /* 4989 */   // No operand predicates
     /* 4989 */   // MIs[2] y
     /* 4989 */   // No operand predicates
     /* 4989 */   // MIs[0] z
     /* 4989 */   // No operand predicates
     /* 4989 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 4991 */   // Combiner Rule #223: lshr_of_trunc_of_lshr
     /* 4991 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner153),
     /* 4994 */ // Label 298: @4994
     /* 4994 */ GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(5017), // Rule ID 110 //
     /* 4999 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5002 */   // MIs[0] dst
     /* 5002 */   // No operand predicates
     /* 5002 */   // MIs[0] lhs
     /* 5002 */   // No operand predicates
     /* 5002 */   // MIs[0] Operand 2
     /* 5002 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5006 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5011 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[6]]
     /* 5011 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5016 */   GIR_EraseRootFromParent_Done,
     /* 5017 */ // Label 299: @5017
     /* 5017 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(5028), // Rule ID 148 //
     /* 5022 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 5025 */   // MIs[0] root
     /* 5025 */   // No operand predicates
     /* 5025 */   // MIs[0] mi.shifted
     /* 5025 */   // No operand predicates
     /* 5025 */   // MIs[0] mi.amt
     /* 5025 */   // No operand predicates
     /* 5025 */   // Combiner Rule #106: shifts_too_big @ [mi[2]]
     /* 5025 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 5028 */ // Label 300: @5028
     /* 5028 */ GIM_Reject,
     /* 5029 */ // Label 33: @5029
     /* 5029 */ GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(5040), // Rule ID 84 //
     /* 5034 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule75Enabled),
     /* 5037 */   // Combiner Rule #75: binop_right_undef_to_undef; wip_match_opcode 'G_ASHR'
     /* 5037 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner37),
     /* 5040 */ // Label 301: @5040
     /* 5040 */ GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(5051), // Rule ID 118 //
     /* 5045 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule86Enabled),
     /* 5048 */   // Combiner Rule #86: binop_left_to_zero; wip_match_opcode 'G_ASHR'
     /* 5048 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner45),
     /* 5051 */ // Label 302: @5051
     /* 5051 */ GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(5062), // Rule ID 159 //
     /* 5056 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule117Enabled),
     /* 5059 */   // Combiner Rule #117: shl_ashr_to_sext_inreg; wip_match_opcode 'G_ASHR'
     /* 5059 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner65),
     /* 5062 */ // Label 303: @5062
     /* 5062 */ GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(5073), // Rule ID 202 //
     /* 5067 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5070 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_ASHR'
     /* 5070 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5073 */ // Label 304: @5073
     /* 5073 */ GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(5084), // Rule ID 207 //
     /* 5078 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 5081 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_ASHR'
     /* 5081 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5084 */ // Label 305: @5084
     /* 5084 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(5095), // Rule ID 232 //
     /* 5089 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule167Enabled),
     /* 5092 */   // Combiner Rule #167: bitfield_extract_from_shr; wip_match_opcode 'G_ASHR'
     /* 5092 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner102),
     /* 5095 */ // Label 306: @5095
     /* 5095 */ GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(5106), // Rule ID 234 //
     /* 5100 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule168Enabled),
     /* 5103 */   // Combiner Rule #168: bitfield_extract_from_shr_and; wip_match_opcode 'G_ASHR'
     /* 5103 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner103),
     /* 5106 */ // Label 307: @5106
     /* 5106 */ GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(5117), // Rule ID 239 //
     /* 5111 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 5114 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_ASHR'
     /* 5114 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 5117 */ // Label 308: @5117
     /* 5117 */ GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(5128), // Rule ID 291 //
     /* 5122 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 5125 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_ASHR'
     /* 5125 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5128 */ // Label 309: @5128
     /* 5128 */ GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(5151), // Rule ID 109 //
     /* 5133 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5136 */   // MIs[0] dst
     /* 5136 */   // No operand predicates
     /* 5136 */   // MIs[0] lhs
     /* 5136 */   // No operand predicates
     /* 5136 */   // MIs[0] Operand 2
     /* 5136 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5140 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5145 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[5]]
     /* 5145 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5150 */   GIR_EraseRootFromParent_Done,
     /* 5151 */ // Label 310: @5151
     /* 5151 */ GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(5162), // Rule ID 147 //
     /* 5156 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule106Enabled),
     /* 5159 */   // MIs[0] root
     /* 5159 */   // No operand predicates
     /* 5159 */   // MIs[0] mi.shifted
     /* 5159 */   // No operand predicates
     /* 5159 */   // MIs[0] mi.amt
     /* 5159 */   // No operand predicates
     /* 5159 */   // Combiner Rule #106: shifts_too_big @ [mi[1]]
     /* 5159 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner56),
     /* 5162 */ // Label 311: @5162
     /* 5162 */ GIM_Reject,
     /* 5163 */ // Label 34: @5163
     /* 5163 */ GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(5174), // Rule ID 217 //
     /* 5168 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule156Enabled),
     /* 5171 */   // Combiner Rule #156: funnel_shift_to_rotate; wip_match_opcode 'G_FSHL'
     /* 5171 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 5174 */ // Label 312: @5174
     /* 5174 */ GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(5185), // Rule ID 221 //
     /* 5179 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule159Enabled),
     /* 5182 */   // Combiner Rule #159: funnel_shift_overshift; wip_match_opcode 'G_FSHL'
     /* 5182 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 5185 */ // Label 313: @5185
     /* 5185 */ GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(5205), // Rule ID 220 //
     /* 5190 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule158Enabled),
     /* 5193 */   // MIs[0] x
     /* 5193 */   // No operand predicates
     /* 5193 */   // MIs[0] y
     /* 5193 */   // No operand predicates
     /* 5193 */   // MIs[0] z
     /* 5193 */   // No operand predicates
     /* 5193 */   // MIs[0] Operand 3
     /* 5193 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 5197 */   // Combiner Rule #158: funnel_shift_left_zero
     /* 5197 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 5200 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 5202 */   GIR_RootToRootCopy, /*OpIdx*/1, // y
     /* 5204 */   GIR_EraseRootFromParent_Done,
     /* 5205 */ // Label 314: @5205
     /* 5205 */ GIM_Reject,
     /* 5206 */ // Label 35: @5206
     /* 5206 */ GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(5217), // Rule ID 218 //
     /* 5211 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule156Enabled),
     /* 5214 */   // Combiner Rule #156: funnel_shift_to_rotate; wip_match_opcode 'G_FSHR'
     /* 5214 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner97),
     /* 5217 */ // Label 315: @5217
     /* 5217 */ GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(5228), // Rule ID 222 //
     /* 5222 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule159Enabled),
     /* 5225 */   // Combiner Rule #159: funnel_shift_overshift; wip_match_opcode 'G_FSHR'
     /* 5225 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner98),
     /* 5228 */ // Label 316: @5228
     /* 5228 */ GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(5248), // Rule ID 219 //
     /* 5233 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule157Enabled),
     /* 5236 */   // MIs[0] x
     /* 5236 */   // No operand predicates
     /* 5236 */   // MIs[0] y
     /* 5236 */   // No operand predicates
     /* 5236 */   // MIs[0] z
     /* 5236 */   // No operand predicates
     /* 5236 */   // MIs[0] Operand 3
     /* 5236 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/3, 0,
     /* 5240 */   // Combiner Rule #157: funnel_shift_right_zero
     /* 5240 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /* 5243 */   GIR_RootToRootCopy, /*OpIdx*/0, // x
     /* 5245 */   GIR_RootToRootCopy, /*OpIdx*/2, // z
     /* 5247 */   GIR_EraseRootFromParent_Done,
     /* 5248 */ // Label 317: @5248
     /* 5248 */ GIM_Reject,
     /* 5249 */ // Label 36: @5249
     /* 5249 */ GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(5272), // Rule ID 113 //
     /* 5254 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5257 */   // MIs[0] dst
     /* 5257 */   // No operand predicates
     /* 5257 */   // MIs[0] lhs
     /* 5257 */   // No operand predicates
     /* 5257 */   // MIs[0] Operand 2
     /* 5257 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5261 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5266 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[9]]
     /* 5266 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5271 */   GIR_EraseRootFromParent_Done,
     /* 5272 */ // Label 318: @5272
     /* 5272 */ GIM_Reject,
     /* 5273 */ // Label 37: @5273
     /* 5273 */ GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(5296), // Rule ID 112 //
     /* 5278 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 5281 */   // MIs[0] dst
     /* 5281 */   // No operand predicates
     /* 5281 */   // MIs[0] lhs
     /* 5281 */   // No operand predicates
     /* 5281 */   // MIs[0] Operand 2
     /* 5281 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 5285 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5290 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[8]]
     /* 5290 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5295 */   GIR_EraseRootFromParent_Done,
     /* 5296 */ // Label 319: @5296
     /* 5296 */ GIM_Reject,
     /* 5297 */ // Label 38: @5297
     /* 5297 */ GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(5308), // Rule ID 154 //
     /* 5302 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule112Enabled),
     /* 5305 */   // Combiner Rule #112: icmp_to_true_false_known_bits; wip_match_opcode 'G_ICMP'
     /* 5305 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner62),
     /* 5308 */ // Label 320: @5308
     /* 5308 */ GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(5319), // Rule ID 155 //
     /* 5313 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule113Enabled),
     /* 5316 */   // Combiner Rule #113: icmp_to_lhs_known_bits; wip_match_opcode 'G_ICMP'
     /* 5316 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner63),
     /* 5319 */ // Label 321: @5319
     /* 5319 */ GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(5330), // Rule ID 158 //
     /* 5324 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule116Enabled),
     /* 5327 */   // Combiner Rule #116: redundant_binop_in_equality; wip_match_opcode 'G_ICMP'
     /* 5327 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner64),
     /* 5330 */ // Label 322: @5330
     /* 5330 */ GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(5341), // Rule ID 152 //
     /* 5335 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule110Enabled),
     /* 5338 */   // MIs[0] root
     /* 5338 */   // No operand predicates
     /* 5338 */   // MIs[0] pred
     /* 5338 */   // No operand predicates
     /* 5338 */   // MIs[0] lhs
     /* 5338 */   // No operand predicates
     /* 5338 */   // MIs[0] rhs
     /* 5338 */   // No operand predicates
     /* 5338 */   // Combiner Rule #110: canonicalize_icmp
     /* 5338 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner60),
     /* 5341 */ // Label 323: @5341
     /* 5341 */ GIM_Reject,
     /* 5342 */ // Label 39: @5342
     /* 5342 */ GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(5353), // Rule ID 153 //
     /* 5347 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule111Enabled),
     /* 5350 */   // MIs[0] root
     /* 5350 */   // No operand predicates
     /* 5350 */   // MIs[0] pred
     /* 5350 */   // No operand predicates
     /* 5350 */   // MIs[0] lhs
     /* 5350 */   // No operand predicates
     /* 5350 */   // MIs[0] rhs
     /* 5350 */   // No operand predicates
     /* 5350 */   // Combiner Rule #111: canonicalize_fcmp
     /* 5350 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner61),
     /* 5353 */ // Label 324: @5353
     /* 5353 */ GIM_Reject,
     /* 5354 */ // Label 40: @5354
     /* 5354 */ GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(5365), // Rule ID 103 //
     /* 5359 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule83Enabled),
     /* 5362 */   // Combiner Rule #83: select_same_val; wip_match_opcode 'G_SELECT'
     /* 5362 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner44),
     /* 5365 */ // Label 325: @5365
     /* 5365 */ GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(5376), // Rule ID 165 //
     /* 5370 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule123Enabled),
     /* 5373 */   // Combiner Rule #123: select_constant_cmp; wip_match_opcode 'G_SELECT'
     /* 5373 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner69),
     /* 5376 */ // Label 326: @5376
     /* 5376 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(5387), // Rule ID 167 //
     /* 5381 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule125Enabled),
     /* 5384 */   // Combiner Rule #125: match_selects; wip_match_opcode 'G_SELECT'
     /* 5384 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner71),
     /* 5387 */ // Label 327: @5387
     /* 5387 */ GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(5398), // Rule ID 313 //
     /* 5392 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule193Enabled),
     /* 5395 */   // Combiner Rule #193: select_to_minmax; wip_match_opcode 'G_SELECT'
     /* 5395 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner125),
     /* 5398 */ // Label 328: @5398
     /* 5398 */ GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(5419), // Rule ID 166 //
     /* 5403 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule124Enabled),
     /* 5406 */   // MIs[0] root
     /* 5406 */   // No operand predicates
     /* 5406 */   // MIs[0] tst
     /* 5406 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5410 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ICMP),
     /* 5414 */   // MIs[1] tst1
     /* 5414 */   // No operand predicates
     /* 5414 */   // MIs[1] a
     /* 5414 */   // No operand predicates
     /* 5414 */   // MIs[1] b
     /* 5414 */   // No operand predicates
     /* 5414 */   // MIs[0] x
     /* 5414 */   // No operand predicates
     /* 5414 */   // MIs[0] y
     /* 5414 */   // No operand predicates
     /* 5414 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5416 */   // Combiner Rule #124: select_to_iminmax
     /* 5416 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner70),
     /* 5419 */ // Label 329: @5419
     /* 5419 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(5448), // Rule ID 164 //
     /* 5424 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule122Enabled),
     /* 5427 */   // MIs[0] dst
     /* 5427 */   // No operand predicates
     /* 5427 */   // MIs[0] undef
     /* 5427 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 5431 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 5435 */   // MIs[0] x
     /* 5435 */   // No operand predicates
     /* 5435 */   // MIs[0] y
     /* 5435 */   // No operand predicates
     /* 5435 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 5440 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 5442 */   // Combiner Rule #122: select_undef_cmp
     /* 5442 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/3,
     /* 5447 */   GIR_EraseRootFromParent_Done,
     /* 5448 */ // Label 330: @5448
     /* 5448 */ GIM_Reject,
     /* 5449 */ // Label 41: @5449
     /* 5449 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(5460), // Rule ID 324 //
     /* 5454 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5457 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDO'
     /* 5457 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5460 */ // Label 331: @5460
     /* 5460 */ GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(5471), // Rule ID 365 //
     /* 5465 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule217Enabled),
     /* 5468 */   // Combiner Rule #217: match_addos; wip_match_opcode 'G_UADDO'
     /* 5468 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 5471 */ // Label 332: @5471
     /* 5471 */ GIM_Reject,
     /* 5472 */ // Label 42: @5472
     /* 5472 */ GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(5483), // Rule ID 190 //
     /* 5477 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5480 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_UADDE'
     /* 5480 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5483 */ // Label 333: @5483
     /* 5483 */ GIM_Reject,
     /* 5484 */ // Label 43: @5484
     /* 5484 */ GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(5495), // Rule ID 367 //
     /* 5489 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule218Enabled),
     /* 5492 */   // Combiner Rule #218: match_subo_no_overflow; wip_match_opcode 'G_USUBO'
     /* 5492 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 5495 */ // Label 334: @5495
     /* 5495 */ GIM_Reject,
     /* 5496 */ // Label 44: @5496
     /* 5496 */ GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(5507), // Rule ID 192 //
     /* 5501 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5504 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_USUBE'
     /* 5504 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5507 */ // Label 335: @5507
     /* 5507 */ GIM_Reject,
     /* 5508 */ // Label 45: @5508
     /* 5508 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(5519), // Rule ID 325 //
     /* 5513 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5516 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDO'
     /* 5516 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5519 */ // Label 336: @5519
     /* 5519 */ GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(5530), // Rule ID 364 //
     /* 5524 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule217Enabled),
     /* 5527 */   // Combiner Rule #217: match_addos; wip_match_opcode 'G_SADDO'
     /* 5527 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner149),
     /* 5530 */ // Label 337: @5530
     /* 5530 */ GIM_Reject,
     /* 5531 */ // Label 46: @5531
     /* 5531 */ GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(5542), // Rule ID 191 //
     /* 5536 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5539 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_SADDE'
     /* 5539 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5542 */ // Label 338: @5542
     /* 5542 */ GIM_Reject,
     /* 5543 */ // Label 47: @5543
     /* 5543 */ GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(5554), // Rule ID 366 //
     /* 5548 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule218Enabled),
     /* 5551 */   // Combiner Rule #218: match_subo_no_overflow; wip_match_opcode 'G_SSUBO'
     /* 5551 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner150),
     /* 5554 */ // Label 339: @5554
     /* 5554 */ GIM_Reject,
     /* 5555 */ // Label 48: @5555
     /* 5555 */ GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(5566), // Rule ID 193 //
     /* 5560 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule146Enabled),
     /* 5563 */   // Combiner Rule #146: adde_to_addo; wip_match_opcode 'G_SSUBE'
     /* 5563 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner87),
     /* 5566 */ // Label 340: @5566
     /* 5566 */ GIM_Reject,
     /* 5567 */ // Label 49: @5567
     /* 5567 */ GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(5578), // Rule ID 186 //
     /* 5572 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5575 */   // Combiner Rule #144: mulo_by_2; wip_match_opcode 'G_UMULO'
     /* 5575 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5578 */ // Label 341: @5578
     /* 5578 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(5589), // Rule ID 188 //
     /* 5583 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 5586 */   // Combiner Rule #145: mulo_by_0; wip_match_opcode 'G_UMULO'
     /* 5586 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5589 */ // Label 342: @5589
     /* 5589 */ GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(5600), // Rule ID 326 //
     /* 5594 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5597 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULO'
     /* 5597 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5600 */ // Label 343: @5600
     /* 5600 */ GIM_Reject,
     /* 5601 */ // Label 50: @5601
     /* 5601 */ GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(5612), // Rule ID 187 //
     /* 5606 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule144Enabled),
     /* 5609 */   // Combiner Rule #144: mulo_by_2; wip_match_opcode 'G_SMULO'
     /* 5609 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner85),
     /* 5612 */ // Label 344: @5612
     /* 5612 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(5623), // Rule ID 189 //
     /* 5617 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule145Enabled),
     /* 5620 */   // Combiner Rule #145: mulo_by_0; wip_match_opcode 'G_SMULO'
     /* 5620 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner86),
     /* 5623 */ // Label 345: @5623
     /* 5623 */ GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(5634), // Rule ID 327 //
     /* 5628 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5631 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULO'
     /* 5631 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5634 */ // Label 346: @5634
     /* 5634 */ GIM_Reject,
     /* 5635 */ // Label 51: @5635
     /* 5635 */ GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(5646), // Rule ID 264 //
     /* 5640 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule174Enabled),
     /* 5643 */   // Combiner Rule #174: mulh_to_lshr; wip_match_opcode 'G_UMULH'
     /* 5643 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner108),
     /* 5646 */ // Label 347: @5646
     /* 5646 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(5657), // Rule ID 328 //
     /* 5651 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5654 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULH'
     /* 5654 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5657 */ // Label 348: @5657
     /* 5657 */ GIM_Reject,
     /* 5658 */ // Label 52: @5658
     /* 5658 */ GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(5669), // Rule ID 329 //
     /* 5663 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5666 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULH'
     /* 5666 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5669 */ // Label 349: @5669
     /* 5669 */ GIM_Reject,
     /* 5670 */ // Label 53: @5670
     /* 5670 */ GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(5681), // Rule ID 330 //
     /* 5675 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5678 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDSAT'
     /* 5678 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5681 */ // Label 350: @5681
     /* 5681 */ GIM_Reject,
     /* 5682 */ // Label 54: @5682
     /* 5682 */ GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(5693), // Rule ID 331 //
     /* 5687 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5690 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDSAT'
     /* 5690 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5693 */ // Label 351: @5693
     /* 5693 */ GIM_Reject,
     /* 5694 */ // Label 55: @5694
     /* 5694 */ GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(5705), // Rule ID 205 //
     /* 5699 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5702 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_USHLSAT'
     /* 5702 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5705 */ // Label 352: @5705
     /* 5705 */ GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(5716), // Rule ID 209 //
     /* 5710 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 5713 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_USHLSAT'
     /* 5713 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5716 */ // Label 353: @5716
     /* 5716 */ GIM_Reject,
     /* 5717 */ // Label 56: @5717
     /* 5717 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(5728), // Rule ID 204 //
     /* 5722 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule151Enabled),
     /* 5725 */   // Combiner Rule #151: shift_immed_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5725 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner92),
     /* 5728 */ // Label 354: @5728
     /* 5728 */ GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(5739), // Rule ID 210 //
     /* 5733 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule152Enabled),
     /* 5736 */   // Combiner Rule #152: shift_of_shifted_logic_chain; wip_match_opcode 'G_SSHLSAT'
     /* 5736 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner93),
     /* 5739 */ // Label 355: @5739
     /* 5739 */ GIM_Reject,
     /* 5740 */ // Label 57: @5740
     /* 5740 */ GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(5751), // Rule ID 332 //
     /* 5745 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5748 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIX'
     /* 5748 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5751 */ // Label 356: @5751
     /* 5751 */ GIM_Reject,
     /* 5752 */ // Label 58: @5752
     /* 5752 */ GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(5763), // Rule ID 333 //
     /* 5757 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5760 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIX'
     /* 5760 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5763 */ // Label 357: @5763
     /* 5763 */ GIM_Reject,
     /* 5764 */ // Label 59: @5764
     /* 5764 */ GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(5775), // Rule ID 334 //
     /* 5769 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5772 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIXSAT'
     /* 5772 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5775 */ // Label 358: @5775
     /* 5775 */ GIM_Reject,
     /* 5776 */ // Label 60: @5776
     /* 5776 */ GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(5787), // Rule ID 335 //
     /* 5781 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 5784 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIXSAT'
     /* 5784 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 5787 */ // Label 359: @5787
     /* 5787 */ GIM_Reject,
     /* 5788 */ // Label 61: @5788
     /* 5788 */ GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(5799), // Rule ID 254 //
     /* 5793 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 5796 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FADD'
     /* 5796 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5799 */ // Label 360: @5799
     /* 5799 */ GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(5810), // Rule ID 265 //
     /* 5804 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 5807 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FADD'
     /* 5807 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5810 */ // Label 361: @5810
     /* 5810 */ GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(5821), // Rule ID 272 //
     /* 5815 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule177Enabled),
     /* 5818 */   // Combiner Rule #177: combine_fadd_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5818 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner111),
     /* 5821 */ // Label 362: @5821
     /* 5821 */ GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(5832), // Rule ID 273 //
     /* 5826 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule178Enabled),
     /* 5829 */   // Combiner Rule #178: combine_fadd_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5829 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner112),
     /* 5832 */ // Label 363: @5832
     /* 5832 */ GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(5843), // Rule ID 274 //
     /* 5837 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule179Enabled),
     /* 5840 */   // Combiner Rule #179: combine_fadd_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5840 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner113),
     /* 5843 */ // Label 364: @5843
     /* 5843 */ GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(5854), // Rule ID 275 //
     /* 5848 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule180Enabled),
     /* 5851 */   // Combiner Rule #180: combine_fadd_fpext_fma_fmul_to_fmad_or_fma; wip_match_opcode 'G_FADD'
     /* 5851 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner114),
     /* 5854 */ // Label 365: @5854
     /* 5854 */ GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(5865), // Rule ID 298 //
     /* 5859 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 5862 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FADD'
     /* 5862 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 5865 */ // Label 366: @5865
     /* 5865 */ GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(5876), // Rule ID 336 //
     /* 5870 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 5873 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FADD'
     /* 5873 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 5876 */ // Label 367: @5876
     /* 5876 */ GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(5899), // Rule ID 138 //
     /* 5881 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule100Enabled),
     /* 5884 */   // MIs[0] dst
     /* 5884 */   // No operand predicates
     /* 5884 */   // MIs[0] x
     /* 5884 */   // No operand predicates
     /* 5884 */   // MIs[0] y
     /* 5884 */   // No operand predicates
     /* 5884 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner3),
     /* 5888 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5893 */   // Combiner Rule #100: right_identity_neg_zero_fp
     /* 5893 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5898 */   GIR_EraseRootFromParent_Done,
     /* 5899 */ // Label 368: @5899
     /* 5899 */ GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(5928), // Rule ID 139 //
     /* 5904 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule101Enabled),
     /* 5907 */   GIM_MIFlags, /*MI*/0, GIMT_Encode4(MachineInstr::FmNsz),
     /* 5913 */   // MIs[0] dst
     /* 5913 */   // No operand predicates
     /* 5913 */   // MIs[0] x
     /* 5913 */   // No operand predicates
     /* 5913 */   // MIs[0] y
     /* 5913 */   // No operand predicates
     /* 5913 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner4),
     /* 5917 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5922 */   // Combiner Rule #101: right_identity_neg_zero_fp_nsz
     /* 5922 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 5927 */   GIR_EraseRootFromParent_Done,
     /* 5928 */ // Label 369: @5928
     /* 5928 */ GIM_Reject,
     /* 5929 */ // Label 62: @5929
     /* 5929 */ GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(5940), // Rule ID 255 //
     /* 5934 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 5937 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FSUB'
     /* 5937 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 5940 */ // Label 370: @5940
     /* 5940 */ GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(5951), // Rule ID 266 //
     /* 5945 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 5948 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FSUB'
     /* 5948 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 5951 */ // Label 371: @5951
     /* 5951 */ GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(5962), // Rule ID 276 //
     /* 5956 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule181Enabled),
     /* 5959 */   // Combiner Rule #181: combine_fsub_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5959 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner115),
     /* 5962 */ // Label 372: @5962
     /* 5962 */ GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(5973), // Rule ID 277 //
     /* 5967 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule182Enabled),
     /* 5970 */   // Combiner Rule #182: combine_fsub_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5970 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner116),
     /* 5973 */ // Label 373: @5973
     /* 5973 */ GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(5984), // Rule ID 278 //
     /* 5978 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule183Enabled),
     /* 5981 */   // Combiner Rule #183: combine_fsub_fpext_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5981 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner117),
     /* 5984 */ // Label 374: @5984
     /* 5984 */ GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(5995), // Rule ID 279 //
     /* 5989 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule184Enabled),
     /* 5992 */   // Combiner Rule #184: combine_fsub_fpext_fneg_fmul_to_fmad_or_fma; wip_match_opcode 'G_FSUB'
     /* 5992 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner118),
     /* 5995 */ // Label 375: @5995
     /* 5995 */ GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(6006), // Rule ID 299 //
     /* 6000 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6003 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FSUB'
     /* 6003 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6006 */ // Label 376: @6006
     /* 6006 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(6017), // Rule ID 314 //
     /* 6011 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule194Enabled),
     /* 6014 */   // Combiner Rule #194: fsub_to_fneg; wip_match_opcode 'G_FSUB'
     /* 6014 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner126),
     /* 6017 */ // Label 377: @6017
     /* 6017 */ GIM_Reject,
     /* 6018 */ // Label 63: @6018
     /* 6018 */ GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(6029), // Rule ID 256 //
     /* 6023 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 6026 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FMUL'
     /* 6026 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 6029 */ // Label 378: @6029
     /* 6029 */ GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(6040), // Rule ID 267 //
     /* 6034 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6037 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FMUL'
     /* 6037 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6040 */ // Label 379: @6040
     /* 6040 */ GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(6051), // Rule ID 297 //
     /* 6045 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6048 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMUL'
     /* 6048 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6051 */ // Label 380: @6051
     /* 6051 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(6062), // Rule ID 337 //
     /* 6056 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6059 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMUL'
     /* 6059 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6062 */ // Label 381: @6062
     /* 6062 */ GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(6083), // Rule ID 373 //
     /* 6067 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule224Enabled),
     /* 6070 */   // MIs[0] dst
     /* 6070 */   // No operand predicates
     /* 6070 */   // MIs[0] x
     /* 6070 */   // No operand predicates
     /* 6070 */   // MIs[0] select
     /* 6070 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6074 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 6078 */   // MIs[1] y
     /* 6078 */   // No operand predicates
     /* 6078 */   // MIs[1] A
     /* 6078 */   // No operand predicates
     /* 6078 */   // MIs[1] B
     /* 6078 */   // No operand predicates
     /* 6078 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6080 */   // Combiner Rule #224: combine_fmul_with_select_to_fldexp
     /* 6080 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner154),
     /* 6083 */ // Label 382: @6083
     /* 6083 */ GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(6106), // Rule ID 129 //
     /* 6088 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule93Enabled),
     /* 6091 */   // MIs[0] dst
     /* 6091 */   // No operand predicates
     /* 6091 */   // MIs[0] x
     /* 6091 */   // No operand predicates
     /* 6091 */   // MIs[0] y
     /* 6091 */   // No operand predicates
     /* 6091 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner2),
     /* 6095 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6100 */   // Combiner Rule #93: right_identity_one_fp
     /* 6100 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6105 */   GIR_EraseRootFromParent_Done,
     /* 6106 */ // Label 383: @6106
     /* 6106 */ GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(6126), // Rule ID 140 //
     /* 6111 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule102Enabled),
     /* 6114 */   // MIs[0] dst
     /* 6114 */   // No operand predicates
     /* 6114 */   // MIs[0] x
     /* 6114 */   // No operand predicates
     /* 6114 */   // MIs[0] y
     /* 6114 */   // No operand predicates
     /* 6114 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner5),
     /* 6118 */   // Combiner Rule #102: right_identity_neg_one_fp
     /* 6118 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 6121 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 6123 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 6125 */   GIR_EraseRootFromParent_Done,
     /* 6126 */ // Label 384: @6126
     /* 6126 */ GIM_Reject,
     /* 6127 */ // Label 64: @6127
     /* 6127 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(6138), // Rule ID 259 //
     /* 6132 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule171Enabled),
     /* 6135 */   // Combiner Rule #171: constant_fold_fma; wip_match_opcode 'G_FMA'
     /* 6135 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 6138 */ // Label 385: @6138
     /* 6138 */ GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(6149), // Rule ID 270 //
     /* 6143 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6146 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FMA'
     /* 6146 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6149 */ // Label 386: @6149
     /* 6149 */ GIM_Reject,
     /* 6150 */ // Label 65: @6150
     /* 6150 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(6161), // Rule ID 258 //
     /* 6155 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule171Enabled),
     /* 6158 */   // Combiner Rule #171: constant_fold_fma; wip_match_opcode 'G_FMAD'
     /* 6158 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner106),
     /* 6161 */ // Label 387: @6161
     /* 6161 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(6172), // Rule ID 269 //
     /* 6166 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6169 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FMAD'
     /* 6169 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6172 */ // Label 388: @6172
     /* 6172 */ GIM_Reject,
     /* 6173 */ // Label 66: @6173
     /* 6173 */ GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(6184), // Rule ID 257 //
     /* 6178 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule170Enabled),
     /* 6181 */   // Combiner Rule #170: constant_fold_fp_binop; wip_match_opcode 'G_FDIV'
     /* 6181 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner105),
     /* 6184 */ // Label 389: @6184
     /* 6184 */ GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(6195), // Rule ID 268 //
     /* 6189 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule175Enabled),
     /* 6192 */   // Combiner Rule #175: redundant_neg_operands; wip_match_opcode 'G_FDIV'
     /* 6192 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner109),
     /* 6195 */ // Label 390: @6195
     /* 6195 */ GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(6206), // Rule ID 300 //
     /* 6200 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6203 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FDIV'
     /* 6203 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6206 */ // Label 391: @6206
     /* 6206 */ GIM_Reject,
     /* 6207 */ // Label 67: @6207
     /* 6207 */ GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(6218), // Rule ID 301 //
     /* 6212 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6215 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FREM'
     /* 6215 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6218 */ // Label 392: @6218
     /* 6218 */ GIM_Reject,
     /* 6219 */ // Label 68: @6219
     /* 6219 */ GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(6240), // Rule ID 198 //
     /* 6224 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule148Enabled),
     /* 6227 */   // MIs[0] dst
     /* 6227 */   // No operand predicates
     /* 6227 */   // MIs[0] float
     /* 6227 */   // No operand predicates
     /* 6227 */   // MIs[0] int
     /* 6227 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 6231 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 6235 */   // MIs[1] imm
     /* 6235 */   // No operand predicates
     /* 6235 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6237 */   // Combiner Rule #148: expand_const_fpowi
     /* 6237 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner89),
     /* 6240 */ // Label 393: @6240
     /* 6240 */ GIM_Reject,
     /* 6241 */ // Label 69: @6241
     /* 6241 */ GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(6262), // Rule ID 180 //
     /* 6246 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule138Enabled),
     /* 6249 */   // MIs[0] dst
     /* 6249 */   // No operand predicates
     /* 6249 */   // MIs[0] src0
     /* 6249 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6253 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6257 */   // MIs[1] cst
     /* 6257 */   // No operand predicates
     /* 6257 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6259 */   // Combiner Rule #138: constant_fold_flog2
     /* 6259 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6262 */ // Label 394: @6262
     /* 6262 */ GIM_Reject,
     /* 6263 */ // Label 70: @6263
     /* 6263 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(6274), // Rule ID 375 //
     /* 6268 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule226Enabled),
     /* 6271 */   // Combiner Rule #226: foldable_fneg; wip_match_opcode 'G_FNEG'
     /* 6271 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner156),
     /* 6274 */ // Label 395: @6274
     /* 6274 */ GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(6295), // Rule ID 177 //
     /* 6279 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule135Enabled),
     /* 6282 */   // MIs[0] dst
     /* 6282 */   // No operand predicates
     /* 6282 */   // MIs[0] src0
     /* 6282 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6286 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6290 */   // MIs[1] cst
     /* 6290 */   // No operand predicates
     /* 6290 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6292 */   // Combiner Rule #135: constant_fold_fneg
     /* 6292 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6295 */ // Label 396: @6295
     /* 6295 */ GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(6324), // Rule ID 127 //
     /* 6300 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule91Enabled),
     /* 6303 */   // MIs[0] dst
     /* 6303 */   // No operand predicates
     /* 6303 */   // MIs[0] t
     /* 6303 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6307 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 6311 */   // MIs[1] src
     /* 6311 */   // No operand predicates
     /* 6311 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 6316 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6318 */   // Combiner Rule #91: fneg_fneg_fold
     /* 6318 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 6323 */   GIR_EraseRootFromParent_Done,
     /* 6324 */ // Label 397: @6324
     /* 6324 */ GIM_Reject,
     /* 6325 */ // Label 71: @6325
     /* 6325 */ GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(6346), // Rule ID 181 //
     /* 6330 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule139Enabled),
     /* 6333 */   // MIs[0] dst
     /* 6333 */   // No operand predicates
     /* 6333 */   // MIs[0] src0
     /* 6333 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6337 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6341 */   // MIs[1] cst
     /* 6341 */   // No operand predicates
     /* 6341 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6343 */   // Combiner Rule #139: constant_fold_fptrunc
     /* 6343 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6346 */ // Label 398: @6346
     /* 6346 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(6367), // Rule ID 137 //
     /* 6351 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule99Enabled),
     /* 6354 */   // MIs[0] dst
     /* 6354 */   // No operand predicates
     /* 6354 */   // MIs[0] src1
     /* 6354 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6358 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPEXT),
     /* 6362 */   // MIs[1] src0
     /* 6362 */   // No operand predicates
     /* 6362 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6364 */   // Combiner Rule #99: fptrunc_fpext_fold
     /* 6364 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner52),
     /* 6367 */ // Label 399: @6367
     /* 6367 */ GIM_Reject,
     /* 6368 */ // Label 72: @6368
     /* 6368 */ GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(6389), // Rule ID 92 //
     /* 6373 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 6376 */   // MIs[0] dst
     /* 6376 */   // No operand predicates
     /* 6376 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 6376 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6380 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6384 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6386 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[5]]
     /* 6386 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 6389 */ // Label 400: @6389
     /* 6389 */ GIM_Reject,
     /* 6390 */ // Label 73: @6390
     /* 6390 */ GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(6411), // Rule ID 93 //
     /* 6395 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule77Enabled),
     /* 6398 */   // MIs[0] dst
     /* 6398 */   // No operand predicates
     /* 6398 */   // MIs[0] __unary_undef_to_undef_match_0.x
     /* 6398 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6402 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 6406 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6408 */   // Combiner Rule #77: unary_undef_to_undef @ [__unary_undef_to_undef_match_0[6]]
     /* 6408 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner38),
     /* 6411 */ // Label 401: @6411
     /* 6411 */ GIM_Reject,
     /* 6412 */ // Label 74: @6412
     /* 6412 */ GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(6423), // Rule ID 76 //
     /* 6417 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 6420 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_SITOFP'
     /* 6420 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 6423 */ // Label 402: @6423
     /* 6423 */ GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(6438), // Rule ID 182 //
     /* 6428 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule140Enabled),
     /* 6431 */   // MIs[0] dst
     /* 6431 */   // No operand predicates
     /* 6431 */   // MIs[0] Operand 1
     /* 6431 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 6435 */   // Combiner Rule #140: itof_const_zero_fold_si
     /* 6435 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 6438 */ // Label 403: @6438
     /* 6438 */ GIM_Reject,
     /* 6439 */ // Label 75: @6439
     /* 6439 */ GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(6450), // Rule ID 75 //
     /* 6444 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule71Enabled),
     /* 6447 */   // Combiner Rule #71: undef_to_fp_zero; wip_match_opcode 'G_UITOFP'
     /* 6447 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner33),
     /* 6450 */ // Label 404: @6450
     /* 6450 */ GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(6465), // Rule ID 183 //
     /* 6455 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule141Enabled),
     /* 6458 */   // MIs[0] dst
     /* 6458 */   // No operand predicates
     /* 6458 */   // MIs[0] Operand 1
     /* 6458 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /* 6462 */   // Combiner Rule #141: itof_const_zero_fold_ui
     /* 6462 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner82),
     /* 6465 */ // Label 405: @6465
     /* 6465 */ GIM_Reject,
     /* 6466 */ // Label 76: @6466
     /* 6466 */ GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(6495), // Rule ID 19 //
     /* 6471 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 6474 */   // MIs[0] dst
     /* 6474 */   // No operand predicates
     /* 6474 */   // MIs[0] src
     /* 6474 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6478 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FABS),
     /* 6482 */   // MIs[1] __idempotent_prop_match_0.x
     /* 6482 */   // No operand predicates
     /* 6482 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6487 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6489 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[1]]
     /* 6489 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6494 */   GIR_EraseRootFromParent_Done,
     /* 6495 */ // Label 406: @6495
     /* 6495 */ GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(6516), // Rule ID 178 //
     /* 6500 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule136Enabled),
     /* 6503 */   // MIs[0] dst
     /* 6503 */   // No operand predicates
     /* 6503 */   // MIs[0] src0
     /* 6503 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6507 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 6511 */   // MIs[1] cst
     /* 6511 */   // No operand predicates
     /* 6511 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6513 */   // Combiner Rule #136: constant_fold_fabs
     /* 6513 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 6516 */ // Label 407: @6516
     /* 6516 */ GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(6544), // Rule ID 263 //
     /* 6521 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule173Enabled),
     /* 6524 */   // MIs[0] dst
     /* 6524 */   // No operand predicates
     /* 6524 */   // MIs[0] tmp
     /* 6524 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6528 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 6532 */   // MIs[1] x
     /* 6532 */   // No operand predicates
     /* 6532 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6534 */   // Combiner Rule #173: fabs_fneg_fold
     /* 6534 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FABS),
     /* 6537 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 6539 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // x
     /* 6543 */   GIR_EraseRootFromParent_Done,
     /* 6544 */ // Label 408: @6544
     /* 6544 */ GIM_Reject,
     /* 6545 */ // Label 77: @6545
     /* 6545 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(6574), // Rule ID 20 //
     /* 6550 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 6553 */   // MIs[0] dst
     /* 6553 */   // No operand predicates
     /* 6553 */   // MIs[0] src
     /* 6553 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 6557 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCANONICALIZE),
     /* 6561 */   // MIs[1] __idempotent_prop_match_0.x
     /* 6561 */   // No operand predicates
     /* 6561 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6566 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 6568 */   // Combiner Rule #18: idempotent_prop @ [__idempotent_prop_match_0[2]]
     /* 6568 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6573 */   GIR_EraseRootFromParent_Done,
     /* 6574 */ // Label 409: @6574
     /* 6574 */ GIM_Reject,
     /* 6575 */ // Label 78: @6575
     /* 6575 */ GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(6586), // Rule ID 194 //
     /* 6580 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6583 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMINNUM'
     /* 6583 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6586 */ // Label 410: @6586
     /* 6586 */ GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(6597), // Rule ID 302 //
     /* 6591 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6594 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMINNUM'
     /* 6594 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6597 */ // Label 411: @6597
     /* 6597 */ GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(6608), // Rule ID 338 //
     /* 6602 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6605 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM'
     /* 6605 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6608 */ // Label 412: @6608
     /* 6608 */ GIM_Reject,
     /* 6609 */ // Label 79: @6609
     /* 6609 */ GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(6620), // Rule ID 195 //
     /* 6614 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6617 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMAXNUM'
     /* 6617 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6620 */ // Label 413: @6620
     /* 6620 */ GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(6631), // Rule ID 303 //
     /* 6625 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6628 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMAXNUM'
     /* 6628 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6631 */ // Label 414: @6631
     /* 6631 */ GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(6642), // Rule ID 339 //
     /* 6636 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6639 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM'
     /* 6639 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6642 */ // Label 415: @6642
     /* 6642 */ GIM_Reject,
     /* 6643 */ // Label 80: @6643
     /* 6643 */ GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(6654), // Rule ID 340 //
     /* 6648 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6651 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM_IEEE'
     /* 6651 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6654 */ // Label 416: @6654
     /* 6654 */ GIM_Reject,
     /* 6655 */ // Label 81: @6655
     /* 6655 */ GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(6666), // Rule ID 341 //
     /* 6660 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6663 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM_IEEE'
     /* 6663 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6666 */ // Label 417: @6666
     /* 6666 */ GIM_Reject,
     /* 6667 */ // Label 82: @6667
     /* 6667 */ GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(6678), // Rule ID 196 //
     /* 6672 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6675 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMINIMUM'
     /* 6675 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6678 */ // Label 418: @6678
     /* 6678 */ GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(6689), // Rule ID 304 //
     /* 6683 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6686 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMINIMUM'
     /* 6686 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6689 */ // Label 419: @6689
     /* 6689 */ GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(6700), // Rule ID 342 //
     /* 6694 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6697 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINIMUM'
     /* 6697 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6700 */ // Label 420: @6700
     /* 6700 */ GIM_Reject,
     /* 6701 */ // Label 83: @6701
     /* 6701 */ GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(6712), // Rule ID 197 //
     /* 6706 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule147Enabled),
     /* 6709 */   // Combiner Rule #147: combine_minmax_nan; wip_match_opcode 'G_FMAXIMUM'
     /* 6709 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner88),
     /* 6712 */ // Label 421: @6712
     /* 6712 */ GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(6723), // Rule ID 305 //
     /* 6717 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6720 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_FMAXIMUM'
     /* 6720 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6723 */ // Label 422: @6723
     /* 6723 */ GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(6734), // Rule ID 343 //
     /* 6728 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule196Enabled),
     /* 6731 */   // Combiner Rule #196: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXIMUM'
     /* 6731 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner128),
     /* 6734 */ // Label 423: @6734
     /* 6734 */ GIM_Reject,
     /* 6735 */ // Label 84: @6735
     /* 6735 */ GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(6746), // Rule ID 149 //
     /* 6740 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule107Enabled),
     /* 6743 */   // Combiner Rule #107: reassoc_ptradd; wip_match_opcode 'G_PTR_ADD'
     /* 6743 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner57),
     /* 6746 */ // Label 424: @6746
     /* 6746 */ GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(6757), // Rule ID 151 //
     /* 6751 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule109Enabled),
     /* 6754 */   // Combiner Rule #109: ptr_add_immed_chain; wip_match_opcode 'G_PTR_ADD'
     /* 6754 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner59),
     /* 6757 */ // Label 425: @6757
     /* 6757 */ GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(6768), // Rule ID 184 //
     /* 6762 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule142Enabled),
     /* 6765 */   // Combiner Rule #142: const_ptradd_to_i2p; wip_match_opcode 'G_PTR_ADD'
     /* 6765 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner83),
     /* 6768 */ // Label 426: @6768
     /* 6768 */ GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(6779), // Rule ID 200 //
     /* 6773 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule150Enabled),
     /* 6776 */   // Combiner Rule #150: ptr_add_with_zero; wip_match_opcode 'G_PTR_ADD'
     /* 6776 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner91),
     /* 6779 */ // Label 427: @6779
     /* 6779 */ GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(6790), // Rule ID 237 //
     /* 6784 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6787 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_PTR_ADD'
     /* 6787 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6790 */ // Label 428: @6790
     /* 6790 */ GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(6801), // Rule ID 282 //
     /* 6795 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6798 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_PTR_ADD'
     /* 6798 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6801 */ // Label 429: @6801
     /* 6801 */ GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(6824), // Rule ID 111 //
     /* 6806 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule84Enabled),
     /* 6809 */   // MIs[0] dst
     /* 6809 */   // No operand predicates
     /* 6809 */   // MIs[0] lhs
     /* 6809 */   // No operand predicates
     /* 6809 */   // MIs[0] Operand 2
     /* 6809 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 6813 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6818 */   // Combiner Rule #84: right_identity_zero @ [__right_identity_zero_match_0[7]]
     /* 6818 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 6823 */   GIR_EraseRootFromParent_Done,
     /* 6824 */ // Label 430: @6824
     /* 6824 */ GIM_Reject,
     /* 6825 */ // Label 85: @6825
     /* 6825 */ GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(6836), // Rule ID 250 //
     /* 6830 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6833 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SMIN'
     /* 6833 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6836 */ // Label 431: @6836
     /* 6836 */ GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(6847), // Rule ID 293 //
     /* 6841 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6844 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SMIN'
     /* 6844 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6847 */ // Label 432: @6847
     /* 6847 */ GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(6858), // Rule ID 320 //
     /* 6852 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6855 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMIN'
     /* 6855 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6858 */ // Label 433: @6858
     /* 6858 */ GIM_Reject,
     /* 6859 */ // Label 86: @6859
     /* 6859 */ GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(6870), // Rule ID 251 //
     /* 6864 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6867 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_SMAX'
     /* 6867 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6870 */ // Label 434: @6870
     /* 6870 */ GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(6881), // Rule ID 294 //
     /* 6875 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6878 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_SMAX'
     /* 6878 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6881 */ // Label 435: @6881
     /* 6881 */ GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(6892), // Rule ID 321 //
     /* 6886 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6889 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_SMAX'
     /* 6889 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6892 */ // Label 436: @6892
     /* 6892 */ GIM_Reject,
     /* 6893 */ // Label 87: @6893
     /* 6893 */ GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(6904), // Rule ID 252 //
     /* 6898 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6901 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UMIN'
     /* 6901 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6904 */ // Label 437: @6904
     /* 6904 */ GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(6915), // Rule ID 295 //
     /* 6909 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6912 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UMIN'
     /* 6912 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6915 */ // Label 438: @6915
     /* 6915 */ GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(6926), // Rule ID 322 //
     /* 6920 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6923 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMIN'
     /* 6923 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6926 */ // Label 439: @6926
     /* 6926 */ GIM_Reject,
     /* 6927 */ // Label 88: @6927
     /* 6927 */ GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(6938), // Rule ID 253 //
     /* 6932 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule169Enabled),
     /* 6935 */   // Combiner Rule #169: constant_fold_binop; wip_match_opcode 'G_UMAX'
     /* 6935 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner104),
     /* 6938 */ // Label 440: @6938
     /* 6938 */ GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(6949), // Rule ID 296 //
     /* 6943 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule185Enabled),
     /* 6946 */   // Combiner Rule #185: fold_binop_into_select; wip_match_opcode 'G_UMAX'
     /* 6946 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner119),
     /* 6949 */ // Label 441: @6949
     /* 6949 */ GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(6960), // Rule ID 323 //
     /* 6954 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule195Enabled),
     /* 6957 */   // Combiner Rule #195: commute_int_constant_to_rhs; wip_match_opcode 'G_UMAX'
     /* 6957 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner127),
     /* 6960 */ // Label 442: @6960
     /* 6960 */ GIM_Reject,
     /* 6961 */ // Label 89: @6961
     /* 6961 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(6972), // Rule ID 86 //
     /* 6966 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule76Enabled),
     /* 6969 */   // Combiner Rule #76: unary_undef_to_zero; wip_match_opcode 'G_ABS'
     /* 6969 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner36),
     /* 6972 */ // Label 443: @6972
     /* 6972 */ GIM_Reject,
     /* 6973 */ // Label 90: @6973
     /* 6973 */ GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(6984), // Rule ID 176 //
     /* 6978 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule134Enabled),
     /* 6981 */   // Combiner Rule #134: opt_brcond_by_inverting_cond; wip_match_opcode 'G_BR'
     /* 6981 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner80),
     /* 6984 */ // Label 444: @6984
     /* 6984 */ GIM_Reject,
     /* 6985 */ // Label 91: @6985
     /* 6985 */ GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(6996), // Rule ID 26 //
     /* 6990 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 6993 */   // Combiner Rule #24: insert_vector_elt_oob; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 6993 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 6996 */ // Label 445: @6996
     /* 6996 */ GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(7007), // Rule ID 67 //
     /* 7001 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule65Enabled),
     /* 7004 */   // Combiner Rule #65: combine_insert_vec_elts_build_vector; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 7004 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner27),
     /* 7007 */ // Label 446: @7007
     /* 7007 */ GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(7018), // Rule ID 101 //
     /* 7012 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 7015 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_INSERT_VECTOR_ELT'
     /* 7015 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 7018 */ // Label 447: @7018
     /* 7018 */ GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(7057), // Rule ID 38 //
     /* 7023 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule36Enabled),
     /* 7026 */   // MIs[0] root
     /* 7026 */   // No operand predicates
     /* 7026 */   // MIs[0] src
     /* 7026 */   // No operand predicates
     /* 7026 */   // MIs[0] elt
     /* 7026 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7030 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_EXTRACT_VECTOR_ELT),
     /* 7034 */   // MIs[1] src
     /* 7034 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 7039 */   // MIs[1] idx
     /* 7039 */   // No operand predicates
     /* 7039 */   // MIs[0] idx
     /* 7039 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/3, /*OtherMI*/1, /*OtherOpIdx*/2,
     /* 7044 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7049 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7051 */   // Combiner Rule #36: insert_vector_element_extract_vector_element
     /* 7051 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7056 */   GIR_EraseRootFromParent_Done,
     /* 7057 */ // Label 448: @7057
     /* 7057 */ GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(7090), // Rule ID 24 //
     /* 7062 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /* 7065 */   // MIs[0] root
     /* 7065 */   // No operand predicates
     /* 7065 */   // MIs[0] src
     /* 7065 */   // No operand predicates
     /* 7065 */   // MIs[0] elt
     /* 7065 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7069 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7073 */   // MIs[0] idx
     /* 7073 */   // No operand predicates
     /* 7073 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /* 7077 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7082 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7084 */   // Combiner Rule #22: insert_vector_element_elt_undef
     /* 7084 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 7089 */   GIR_EraseRootFromParent_Done,
     /* 7090 */ // Label 449: @7090
     /* 7090 */ GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(7114), // Rule ID 23 //
     /* 7095 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /* 7098 */   // MIs[0] root
     /* 7098 */   // No operand predicates
     /* 7098 */   // MIs[0] src
     /* 7098 */   // No operand predicates
     /* 7098 */   // MIs[0] elt
     /* 7098 */   // No operand predicates
     /* 7098 */   // MIs[0] idx
     /* 7098 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
     /* 7102 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7106 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7108 */   // Combiner Rule #21: insert_vector_element_idx_undef
     /* 7108 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7111 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 7113 */   GIR_EraseRootFromParent_Done,
     /* 7114 */ // Label 450: @7114
     /* 7114 */ GIM_Reject,
     /* 7115 */ // Label 92: @7115
     /* 7115 */ GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(7126), // Rule ID 25 //
     /* 7120 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 7123 */   // Combiner Rule #23: match_extract_of_element; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7123 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 7126 */ // Label 451: @7126
     /* 7126 */ GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(7137), // Rule ID 68 //
     /* 7131 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule66Enabled),
     /* 7134 */   // Combiner Rule #66: extract_vec_elt_build_vec; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7134 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner28),
     /* 7137 */ // Label 452: @7137
     /* 7137 */ GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(7148), // Rule ID 74 //
     /* 7142 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule70Enabled),
     /* 7145 */   // Combiner Rule #70: combine_extracted_vector_load; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7145 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner32),
     /* 7148 */ // Label 453: @7148
     /* 7148 */ GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(7159), // Rule ID 102 //
     /* 7153 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule82Enabled),
     /* 7156 */   // Combiner Rule #82: insert_extract_vec_elt_out_of_bounds; wip_match_opcode 'G_EXTRACT_VECTOR_ELT'
     /* 7156 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner43),
     /* 7159 */ // Label 454: @7159
     /* 7159 */ GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(7183), // Rule ID 36 //
     /* 7164 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule34Enabled),
     /* 7167 */   // MIs[0] root
     /* 7167 */   // No operand predicates
     /* 7167 */   // MIs[0] src
     /* 7167 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7171 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7175 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/9,
     /* 7178 */   // MIs[1] x
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] y
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] z
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] a
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] b
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] c
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] d
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[1] e
     /* 7178 */   // No operand predicates
     /* 7178 */   // MIs[0] idx
     /* 7178 */   // No operand predicates
     /* 7178 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7180 */   // Combiner Rule #34: extract_vector_element_build_vector_trunc8
     /* 7180 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7183 */ // Label 455: @7183
     /* 7183 */ GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(7207), // Rule ID 35 //
     /* 7188 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule33Enabled),
     /* 7191 */   // MIs[0] root
     /* 7191 */   // No operand predicates
     /* 7191 */   // MIs[0] src
     /* 7191 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7195 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7199 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/8,
     /* 7202 */   // MIs[1] x
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[1] y
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[1] z
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[1] a
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[1] b
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[1] c
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[1] d
     /* 7202 */   // No operand predicates
     /* 7202 */   // MIs[0] idx
     /* 7202 */   // No operand predicates
     /* 7202 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7204 */   // Combiner Rule #33: extract_vector_element_build_vector_trunc7
     /* 7204 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7207 */ // Label 456: @7207
     /* 7207 */ GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(7231), // Rule ID 34 //
     /* 7212 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule32Enabled),
     /* 7215 */   // MIs[0] root
     /* 7215 */   // No operand predicates
     /* 7215 */   // MIs[0] src
     /* 7215 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7219 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7223 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/7,
     /* 7226 */   // MIs[1] x
     /* 7226 */   // No operand predicates
     /* 7226 */   // MIs[1] y
     /* 7226 */   // No operand predicates
     /* 7226 */   // MIs[1] z
     /* 7226 */   // No operand predicates
     /* 7226 */   // MIs[1] a
     /* 7226 */   // No operand predicates
     /* 7226 */   // MIs[1] b
     /* 7226 */   // No operand predicates
     /* 7226 */   // MIs[1] c
     /* 7226 */   // No operand predicates
     /* 7226 */   // MIs[0] idx
     /* 7226 */   // No operand predicates
     /* 7226 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7228 */   // Combiner Rule #32: extract_vector_element_build_vector_trunc6
     /* 7228 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7231 */ // Label 457: @7231
     /* 7231 */ GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(7255), // Rule ID 33 //
     /* 7236 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule31Enabled),
     /* 7239 */   // MIs[0] root
     /* 7239 */   // No operand predicates
     /* 7239 */   // MIs[0] src
     /* 7239 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7243 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7247 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/6,
     /* 7250 */   // MIs[1] x
     /* 7250 */   // No operand predicates
     /* 7250 */   // MIs[1] y
     /* 7250 */   // No operand predicates
     /* 7250 */   // MIs[1] z
     /* 7250 */   // No operand predicates
     /* 7250 */   // MIs[1] a
     /* 7250 */   // No operand predicates
     /* 7250 */   // MIs[1] b
     /* 7250 */   // No operand predicates
     /* 7250 */   // MIs[0] idx
     /* 7250 */   // No operand predicates
     /* 7250 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7252 */   // Combiner Rule #31: extract_vector_element_build_vector_trunc5
     /* 7252 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7255 */ // Label 458: @7255
     /* 7255 */ GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(7279), // Rule ID 32 //
     /* 7260 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule30Enabled),
     /* 7263 */   // MIs[0] root
     /* 7263 */   // No operand predicates
     /* 7263 */   // MIs[0] src
     /* 7263 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7267 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7271 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/5,
     /* 7274 */   // MIs[1] x
     /* 7274 */   // No operand predicates
     /* 7274 */   // MIs[1] y
     /* 7274 */   // No operand predicates
     /* 7274 */   // MIs[1] z
     /* 7274 */   // No operand predicates
     /* 7274 */   // MIs[1] a
     /* 7274 */   // No operand predicates
     /* 7274 */   // MIs[0] idx
     /* 7274 */   // No operand predicates
     /* 7274 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7276 */   // Combiner Rule #30: extract_vector_element_build_vector_trunc4
     /* 7276 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7279 */ // Label 459: @7279
     /* 7279 */ GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(7303), // Rule ID 31 //
     /* 7284 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule29Enabled),
     /* 7287 */   // MIs[0] root
     /* 7287 */   // No operand predicates
     /* 7287 */   // MIs[0] src
     /* 7287 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7291 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7295 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /* 7298 */   // MIs[1] x
     /* 7298 */   // No operand predicates
     /* 7298 */   // MIs[1] y
     /* 7298 */   // No operand predicates
     /* 7298 */   // MIs[1] z
     /* 7298 */   // No operand predicates
     /* 7298 */   // MIs[0] idx
     /* 7298 */   // No operand predicates
     /* 7298 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7300 */   // Combiner Rule #29: extract_vector_element_build_vector_trunc3
     /* 7300 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7303 */ // Label 460: @7303
     /* 7303 */ GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(7337), // Rule ID 27 //
     /* 7308 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 7311 */   // MIs[0] root
     /* 7311 */   // No operand predicates
     /* 7311 */   // MIs[0] src
     /* 7311 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7315 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 7319 */   // MIs[1] x
     /* 7319 */   // No operand predicates
     /* 7319 */   // MIs[1] value
     /* 7319 */   // No operand predicates
     /* 7319 */   // MIs[1] idx
     /* 7319 */   // No operand predicates
     /* 7319 */   // MIs[0] idx
     /* 7319 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/3,
     /* 7324 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 7329 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7331 */   // Combiner Rule #25: extract_vector_element_not_const
     /* 7331 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/2,
     /* 7336 */   GIR_EraseRootFromParent_Done,
     /* 7337 */ // Label 461: @7337
     /* 7337 */ GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(7358), // Rule ID 28 //
     /* 7342 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule26Enabled),
     /* 7345 */   // MIs[0] root
     /* 7345 */   // No operand predicates
     /* 7345 */   // MIs[0] src
     /* 7345 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7349 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INSERT_VECTOR_ELT),
     /* 7353 */   // MIs[1] x
     /* 7353 */   // No operand predicates
     /* 7353 */   // MIs[1] value
     /* 7353 */   // No operand predicates
     /* 7353 */   // MIs[1] idx2
     /* 7353 */   // No operand predicates
     /* 7353 */   // MIs[0] idx1
     /* 7353 */   // No operand predicates
     /* 7353 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7355 */   // Combiner Rule #26: extract_vector_element_different_indices
     /* 7355 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 7358 */ // Label 462: @7358
     /* 7358 */ GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(7387), // Rule ID 37 //
     /* 7363 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule35Enabled),
     /* 7366 */   // MIs[0] root
     /* 7366 */   // No operand predicates
     /* 7366 */   // MIs[0] src
     /* 7366 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7370 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHUFFLE_VECTOR),
     /* 7374 */   // MIs[1] src1
     /* 7374 */   // No operand predicates
     /* 7374 */   // MIs[1] src2
     /* 7374 */   // No operand predicates
     /* 7374 */   // MIs[1] mask
     /* 7374 */   // No operand predicates
     /* 7374 */   // MIs[0] idx
     /* 7374 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 7378 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 7382 */   // MIs[2] imm
     /* 7382 */   // No operand predicates
     /* 7382 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7384 */   // Combiner Rule #35: extract_vector_element_shuffle_vector
     /* 7384 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 7387 */ // Label 463: @7387
     /* 7387 */ GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(7411), // Rule ID 30 //
     /* 7392 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule28Enabled),
     /* 7395 */   // MIs[0] root
     /* 7395 */   // No operand predicates
     /* 7395 */   // MIs[0] src
     /* 7395 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7399 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /* 7403 */   GIM_CheckNumOperands, /*MI*/1, /*Expected*/3,
     /* 7406 */   // MIs[1] x
     /* 7406 */   // No operand predicates
     /* 7406 */   // MIs[1] y
     /* 7406 */   // No operand predicates
     /* 7406 */   // MIs[0] idx
     /* 7406 */   // No operand predicates
     /* 7406 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7408 */   // Combiner Rule #28: extract_vector_element_build_vector_trunc2
     /* 7408 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 7411 */ // Label 464: @7411
     /* 7411 */ GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(7443), // Rule ID 29 //
     /* 7416 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule27Enabled),
     /* 7419 */   // MIs[0] root
     /* 7419 */   // No operand predicates
     /* 7419 */   // MIs[0] src
     /* 7419 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7423 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR),
     /* 7427 */   GIM_CheckNumOperandsGE, /*MI*/1, /*Expected*/2,
     /* 7430 */   // MIs[1] unused
     /* 7430 */   // No operand predicates
     /* 7430 */   // MIs[0] idx
     /* 7430 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /* 7434 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /* 7438 */   // MIs[2] imm
     /* 7438 */   // No operand predicates
     /* 7438 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7440 */   // Combiner Rule #27: extract_vector_element_build_vector
     /* 7440 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 7443 */ // Label 465: @7443
     /* 7443 */ GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(7467), // Rule ID 21 //
     /* 7448 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 7451 */   // MIs[0] root
     /* 7451 */   // No operand predicates
     /* 7451 */   // MIs[0] vector
     /* 7451 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7455 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7459 */   // MIs[0] idx
     /* 7459 */   // No operand predicates
     /* 7459 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7461 */   // Combiner Rule #19: match_extract_of_element_undef_vector
     /* 7461 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7464 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 7466 */   GIR_EraseRootFromParent_Done,
     /* 7467 */ // Label 466: @7467
     /* 7467 */ GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(7491), // Rule ID 22 //
     /* 7472 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 7475 */   // MIs[0] root
     /* 7475 */   // No operand predicates
     /* 7475 */   // MIs[0] vector
     /* 7475 */   // No operand predicates
     /* 7475 */   // MIs[0] idx
     /* 7475 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7479 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7483 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7485 */   // Combiner Rule #20: match_extract_of_element_undef_index
     /* 7485 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7488 */   GIR_RootToRootCopy, /*OpIdx*/0, // root
     /* 7490 */   GIR_EraseRootFromParent_Done,
     /* 7491 */ // Label 467: @7491
     /* 7491 */ GIM_Reject,
     /* 7492 */ // Label 93: @7492
     /* 7492 */ GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(7503), // Rule ID 97 //
     /* 7497 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule79Enabled),
     /* 7500 */   // Combiner Rule #79: propagate_undef_all_ops; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7500 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner40),
     /* 7503 */ // Label 468: @7503
     /* 7503 */ GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(7514), // Rule ID 99 //
     /* 7508 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule80Enabled),
     /* 7511 */   // Combiner Rule #80: propagate_undef_shuffle_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7511 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner41),
     /* 7514 */ // Label 469: @7514
     /* 7514 */ GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(7525), // Rule ID 351 //
     /* 7519 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule204Enabled),
     /* 7522 */   // Combiner Rule #204: combine_shuffle_concat; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7522 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner136),
     /* 7525 */ // Label 470: @7525
     /* 7525 */ GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(7536), // Rule ID 353 //
     /* 7530 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule206Enabled),
     /* 7533 */   // Combiner Rule #206: combine_shuffle_disjoint_mask; wip_match_opcode 'G_SHUFFLE_VECTOR'
     /* 7533 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner138),
     /* 7536 */ // Label 471: @7536
     /* 7536 */ GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(7557), // Rule ID 352 //
     /* 7541 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule205Enabled),
     /* 7544 */   // MIs[0] root
     /* 7544 */   // No operand predicates
     /* 7544 */   // MIs[0] src1
     /* 7544 */   // No operand predicates
     /* 7544 */   // MIs[0] undef
     /* 7544 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /* 7548 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_IMPLICIT_DEF),
     /* 7552 */   // MIs[0] mask
     /* 7552 */   // No operand predicates
     /* 7552 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7554 */   // Combiner Rule #205: combine_shuffle_undef_rhs
     /* 7554 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner137),
     /* 7557 */ // Label 472: @7557
     /* 7557 */ GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(7568), // Rule ID 376 //
     /* 7562 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule227Enabled),
     /* 7565 */   // MIs[0] dst
     /* 7565 */   // No operand predicates
     /* 7565 */   // MIs[0] src1
     /* 7565 */   // No operand predicates
     /* 7565 */   // MIs[0] src2
     /* 7565 */   // No operand predicates
     /* 7565 */   // MIs[0] mask
     /* 7565 */   // No operand predicates
     /* 7565 */   // Combiner Rule #227: combine_shuffle_vector_to_build_vector
     /* 7565 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner157),
     /* 7568 */ // Label 473: @7568
     /* 7568 */ GIM_Reject,
     /* 7569 */ // Label 94: @7569
     /* 7569 */ GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(7613), // Rule ID 228 //
     /* 7574 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule163Enabled),
     /* 7577 */   // MIs[0] d
     /* 7577 */   // No operand predicates
     /* 7577 */   // MIs[0] src
     /* 7577 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7581 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7585 */   // MIs[1] rev
     /* 7585 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 7589 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7593 */   // MIs[2] val
     /* 7593 */   // No operand predicates
     /* 7593 */   // MIs[1] amt
     /* 7593 */   // No operand predicates
     /* 7593 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner10),
     /* 7597 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7599 */   // Combiner Rule #163: bitreverse_lshr
     /* 7599 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_SHL),
     /* 7602 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7604 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7608 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7612 */   GIR_EraseRootFromParent_Done,
     /* 7613 */ // Label 474: @7613
     /* 7613 */ GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(7657), // Rule ID 227 //
     /* 7618 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule162Enabled),
     /* 7621 */   // MIs[0] d
     /* 7621 */   // No operand predicates
     /* 7621 */   // MIs[0] src
     /* 7621 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7625 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 7629 */   // MIs[1] rev
     /* 7629 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /* 7633 */   GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BITREVERSE),
     /* 7637 */   // MIs[2] val
     /* 7637 */   // No operand predicates
     /* 7637 */   // MIs[1] amt
     /* 7637 */   // No operand predicates
     /* 7637 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner9),
     /* 7641 */   GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /* 7643 */   // Combiner Rule #162: bitreverse_shl
     /* 7643 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 7646 */   GIR_RootToRootCopy, /*OpIdx*/0, // d
     /* 7648 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // val
     /* 7652 */   GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // amt
     /* 7656 */   GIR_EraseRootFromParent_Done,
     /* 7657 */ // Label 475: @7657
     /* 7657 */ GIM_Reject,
     /* 7658 */ // Label 95: @7658
     /* 7658 */ GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(7679), // Rule ID 179 //
     /* 7663 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule137Enabled),
     /* 7666 */   // MIs[0] dst
     /* 7666 */   // No operand predicates
     /* 7666 */   // MIs[0] src0
     /* 7666 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 7670 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FCONSTANT),
     /* 7674 */   // MIs[1] cst
     /* 7674 */   // No operand predicates
     /* 7674 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 7676 */   // Combiner Rule #137: constant_fold_fsqrt
     /* 7676 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner81),
     /* 7679 */ // Label 476: @7679
     /* 7679 */ GIM_Reject,
     /* 7680 */ // Label 96: @7680
     /* 7680 */ GIM_Reject,
     /* 7681 */ }; // Size: 7681 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

